/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.action.MenuData;
import docking.widgets.table.GTable;
import docking.widgets.tree.GTreeNode;
import generic.theme.GIcon;
import ghidra.framework.main.datatable.DomainFileInfo;
import ghidra.framework.main.datatable.FrontendProjectTreeAction;
import ghidra.framework.main.datatable.ProjectDataContext;
import ghidra.framework.main.datatable.ProjectDataTableModel;
import ghidra.framework.main.datatree.DataTree;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.util.Msg;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ProjectDataRenameAction
extends FrontendProjectTreeAction {
    private static final Icon ICON = new GIcon("icon.projectdata.rename");

    public ProjectDataRenameAction(String owner, String group) {
        super("Rename", owner);
        this.setPopupMenuData(new MenuData(new String[]{"Rename"}, ICON, group));
        this.markHelpUnnecessary();
    }

    protected void actionPerformed(ProjectDataContext context) {
        Component component;
        if (context.getFileCount() == 1) {
            DomainFile file = context.getSelectedFiles().get(0);
            if (file.isCheckedOut()) {
                Msg.showInfo(((Object)((Object)this)).getClass(), (Component)context.getComponent(), (String)"Rename Not Allowed", (Object)"Can't rename a file that is checked out!");
                return;
            }
            if (!file.getConsumers().isEmpty() || file.isBusy()) {
                Msg.showInfo(((Object)((Object)this)).getClass(), (Component)context.getComponent(), (String)"Rename Not Allowed", (Object)"Can't rename a file that is open!");
                return;
            }
        }
        if ((component = context.getComponent()) instanceof DataTree) {
            DataTree tree = (DataTree)((Object)component);
            GTreeNode node = (GTreeNode)context.getContextObject();
            tree.setEditable(true);
            tree.startEditing(node);
        } else if (component instanceof GTable) {
            GTable table = (GTable)component;
            DomainFileInfo info = (DomainFileInfo)context.getContextObject();
            ProjectDataTableModel model = (ProjectDataTableModel)((Object)table.getModel());
            List modelData = model.getModelData();
            int indexOf = modelData.indexOf(info);
            if (indexOf >= 0) {
                model.setEditing(true);
                table.editCellAt(indexOf, this.findNameColumn(table));
                model.setEditing(false);
            }
        }
    }

    private int findNameColumn(GTable table) {
        TableColumnModel model = table.getColumnModel();
        int columnCount = model.getColumnCount();
        for (int col = 0; col < columnCount; ++col) {
            TableColumn column = model.getColumn(col);
            if (!"Name".equals(column.getHeaderValue().toString())) continue;
            return col;
        }
        return 0;
    }

    @Override
    protected boolean isEnabledForContext(ProjectDataContext context) {
        DomainFolder folder;
        DomainFile file;
        if (!context.hasExactlyOneFileOrFolder()) {
            return false;
        }
        if (context.getFileCount() == 1 ? (file = context.getSelectedFiles().get(0)).isReadOnly() : (folder = context.getSelectedFolders().get(0)).getParent() == null) {
            return false;
        }
        return !context.isReadOnlyProject();
    }
}

