/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.formats.android.oat.OatConstants;
import ghidra.file.formats.android.oat.OatHeader;
import ghidra.file.formats.android.oat.UnsupportedOatVersionException;
import ghidra.file.formats.android.oat.bundle.OatBundle;
import ghidra.file.formats.android.oat.bundle.OatBundleFactory;
import ghidra.file.formats.android.oat.headers.OatHeader_007;
import ghidra.file.formats.android.oat.headers.OatHeader_039;
import ghidra.file.formats.android.oat.headers.OatHeader_045;
import ghidra.file.formats.android.oat.headers.OatHeader_051;
import ghidra.file.formats.android.oat.headers.OatHeader_064;
import ghidra.file.formats.android.oat.headers.OatHeader_079;
import ghidra.file.formats.android.oat.headers.OatHeader_088;
import ghidra.file.formats.android.oat.headers.OatHeader_124;
import ghidra.file.formats.android.oat.headers.OatHeader_126;
import ghidra.file.formats.android.oat.headers.OatHeader_131;
import ghidra.file.formats.android.oat.headers.OatHeader_138;
import ghidra.file.formats.android.oat.headers.OatHeader_170;
import ghidra.file.formats.android.oat.headers.OatHeader_183;
import ghidra.file.formats.android.oat.headers.OatHeader_195;
import ghidra.file.formats.android.oat.headers.OatHeader_199;
import ghidra.file.formats.android.oat.headers.OatHeader_220;
import ghidra.file.formats.android.oat.headers.OatHeader_223;
import ghidra.file.formats.android.oat.headers.OatHeader_225;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public final class OatHeaderFactory {
    public static final OatHeader newOatHeader(BinaryReader reader) throws IOException, UnsupportedOatVersionException {
        String magic = new String(reader.readByteArray(0L, "oat\n".length()));
        String version = reader.readAsciiString(4L, 4);
        if (magic.equals("oat\n") && OatConstants.isSupportedVersion(version)) {
            switch (version) {
                case "007": {
                    return new OatHeader_007(reader);
                }
                case "039": {
                    return new OatHeader_039(reader);
                }
                case "045": {
                    return new OatHeader_045(reader);
                }
                case "051": {
                    return new OatHeader_051(reader);
                }
                case "064": {
                    return new OatHeader_064(reader);
                }
                case "079": {
                    return new OatHeader_079(reader);
                }
                case "088": {
                    return new OatHeader_088(reader);
                }
                case "124": {
                    return new OatHeader_124(reader);
                }
                case "126": {
                    return new OatHeader_126(reader);
                }
                case "131": {
                    return new OatHeader_131(reader);
                }
                case "138": {
                    return new OatHeader_138(reader);
                }
                case "170": {
                    return new OatHeader_170(reader);
                }
                case "183": {
                    return new OatHeader_183(reader);
                }
                case "195": {
                    return new OatHeader_195(reader);
                }
                case "199": {
                    return new OatHeader_199(reader);
                }
                case "220": {
                    return new OatHeader_220(reader);
                }
                case "223": {
                    return new OatHeader_223(reader);
                }
                case "225": {
                    return new OatHeader_225(reader);
                }
            }
        }
        throw new UnsupportedOatVersionException(magic, version);
    }

    public static final void parseOatHeader(OatHeader oatHeader, Program oatProgram, BinaryReader reader, TaskMonitor monitor, MessageLog log) throws UnsupportedOatVersionException, IOException {
        OatBundle bundle = OatBundleFactory.getOatBundle(oatProgram, oatHeader, monitor, log);
        oatHeader.parse(reader, bundle);
        bundle.close();
    }
}

