/*
 * Decompiled with CFR 0.152.
 */
package ghidra;

import ghidra.util.Msg;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class GhidraClassLoader
extends URLClassLoader {
    public static final String ENABLE_RESTRICTED_EXTENSIONS_PROPERTY = "ghidra.extensions.classpath.restricted";
    public static final String CP = "java.class.path";
    public static final String CP_EXT = "java.class.path.ext";
    private Set<URL> alreadyAdded = new HashSet<URL>();

    public static List<String> getClasspath(String propertyName) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(System.getProperty(propertyName, ""), File.pathSeparator);
        while (st.hasMoreTokens()) {
            result.add(st.nextToken());
        }
        return result;
    }

    public GhidraClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    @Override
    public void addURL(URL url) {
        if (!this.alreadyAdded.add(url)) {
            return;
        }
        super.addURL(url);
        try {
            System.setProperty(CP, System.getProperty(CP) + File.pathSeparatorChar + String.valueOf(new File(url.toURI())));
        }
        catch (URISyntaxException e) {
            Msg.debug(this, "URL is not a valid path: " + String.valueOf(url));
        }
    }

    public boolean addPath(String path) {
        try {
            this.addURL(new File(path).toURI().toURL());
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    private void appendToClassPathForInstrumentation(String path) {
        this.addPath(path);
    }
}

