/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit;

import ghidra.pcode.emu.PcodeEmulationCallbacks;
import ghidra.pcode.emu.PcodeEmulator;
import ghidra.pcode.emu.PcodeMachine;
import ghidra.pcode.emu.PcodeThread;
import ghidra.pcode.emu.jit.JitCompiler;
import ghidra.pcode.emu.jit.JitConfiguration;
import ghidra.pcode.emu.jit.JitDefaultBytesPcodeExecutorState;
import ghidra.pcode.emu.jit.JitPassage;
import ghidra.pcode.emu.jit.JitPcodeThread;
import ghidra.pcode.emu.jit.decode.JitPassageDecoder;
import ghidra.pcode.emu.jit.gen.tgt.JitCompiledPassage;
import ghidra.pcode.emu.jit.gen.tgt.JitCompiledPassageClass;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeStateCallbacks;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.lang.Language;
import ghidra.util.Msg;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.objectweb.asm.MethodTooLargeException;

public class JitPcodeEmulator
extends PcodeEmulator {
    protected final JitCompiler compiler;
    private final MethodHandles.Lookup lookup;
    protected final Map<JitPassage.AddrCtx, CompletableFuture<JitCompiledPassage.EntryPointPrototype>> codeCache = new HashMap<JitPassage.AddrCtx, CompletableFuture<JitCompiledPassage.EntryPointPrototype>>();

    private JitPcodeEmulator(Language language, PcodeEmulationCallbacks<byte[]> cb, JitConfiguration config, MethodHandles.Lookup lookup) {
        super(language, cb);
        this.compiler = new JitCompiler(config);
        this.lookup = lookup;
    }

    public JitPcodeEmulator(Language language, JitConfiguration config, MethodHandles.Lookup lookup) {
        this(language, PcodeEmulationCallbacks.none(), config, lookup);
    }

    @Override
    protected PcodeExecutorState<byte[]> createSharedState() {
        PcodeStateCallbacks scb = this.cb.wrapFor(null);
        return new JitDefaultBytesPcodeExecutorState((Language)this.language, scb);
    }

    @Override
    protected PcodeExecutorState<byte[]> createLocalState(PcodeThread<byte[]> thread) {
        PcodeStateCallbacks scb = this.cb.wrapFor(thread);
        return new JitDefaultBytesPcodeExecutorState((Language)this.language, scb);
    }

    @Override
    protected JitPcodeThread createThread(String name) {
        return new JitPcodeThread(name, this);
    }

    public JitPcodeThread newThread() {
        return (JitPcodeThread)super.newThread();
    }

    public JitPcodeThread newThread(String name) {
        return (JitPcodeThread)super.newThread(name);
    }

    @Override
    protected PcodeUseropLibrary<byte[]> createUseropLibrary() {
        return super.createUseropLibrary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasEntryPrototype(JitPassage.AddrCtx pcCtx) {
        Map<JitPassage.AddrCtx, CompletableFuture<JitCompiledPassage.EntryPointPrototype>> map = this.codeCache;
        synchronized (map) {
            CompletableFuture<JitCompiledPassage.EntryPointPrototype> proto = this.codeCache.get(pcCtx);
            return proto != null && proto.isDone();
        }
    }

    protected JitCompiledPassageClass compileWithMaxOpsBackoff(JitPassage.AddrCtx pcCtx, JitPassageDecoder decoder) {
        for (int maxOps = this.getConfiguration().maxPassageOps(); maxOps > 0; maxOps >>= 1) {
            JitPassage decoded = decoder.decodePassage(pcCtx, maxOps);
            try {
                return this.compiler.compilePassage(this.lookup, decoded);
            }
            catch (MethodTooLargeException e) {
                Msg.warn((Object)this, (Object)("Method too large for " + String.valueOf(pcCtx) + " with maxOps=" + maxOps + ". Retrying with half."));
                continue;
            }
        }
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JitCompiledPassage.EntryPointPrototype getEntryPrototype(JitPassage.AddrCtx pcCtx, JitPassageDecoder decoder) {
        boolean wasAbsent;
        CompletableFuture<JitCompiledPassage.EntryPointPrototype> proto;
        Map<JitPassage.AddrCtx, CompletableFuture<JitCompiledPassage.EntryPointPrototype>> map = this.codeCache;
        synchronized (map) {
            proto = this.codeCache.get(pcCtx);
            boolean bl = wasAbsent = proto == null;
            if (wasAbsent) {
                proto = new CompletableFuture();
                this.codeCache.put(pcCtx, proto);
            }
        }
        if (wasAbsent) {
            try {
                JitCompiledPassageClass compiled = this.compileWithMaxOpsBackoff(pcCtx, decoder);
                Map<JitPassage.AddrCtx, CompletableFuture<JitCompiledPassage.EntryPointPrototype>> map2 = this.codeCache;
                synchronized (map2) {
                    for (Map.Entry<JitPassage.AddrCtx, JitCompiledPassage.EntryPointPrototype> ent : compiled.getBlockEntries().entrySet()) {
                        if (ent.getKey().equals(pcCtx)) {
                            proto.complete(ent.getValue());
                            continue;
                        }
                        this.codeCache.put(ent.getKey(), CompletableFuture.completedFuture(ent.getValue()));
                    }
                }
            }
            catch (Throwable t) {
                proto.completeExceptionally(t);
            }
        }
        try {
            return proto.get();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        catch (ExecutionException e) {
            return (JitCompiledPassage.EntryPointPrototype)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public JitConfiguration getConfiguration() {
        return this.compiler.getConfiguration();
    }

    @Override
    public void addAccessBreakpoint(AddressRange range, PcodeMachine.AccessKind kind) {
        throw new UnsupportedOperationException();
    }
}

