/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ClassFieldMsAttributes;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MsTypeField;
import java.math.BigInteger;

public abstract class AbstractMemberMsType
extends AbstractMsType
implements MsTypeField {
    protected ClassFieldMsAttributes attribute;
    protected RecordNumber fieldTypeRecordNumber;
    protected BigInteger offset;
    protected String name;

    public AbstractMemberMsType(AbstractPdb pdb, PdbByteReader reader) {
        super(pdb, reader);
    }

    public AbstractMemberMsType(AbstractPdb pdb, String name, long offset, RecordNumber fieldTypeRecordNumber, ClassFieldMsAttributes attribute) {
        super(pdb, null);
        this.name = name;
        this.offset = BigInteger.valueOf(offset);
        this.fieldTypeRecordNumber = fieldTypeRecordNumber;
        this.attribute = attribute;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public BigInteger getOffset() {
        return this.offset;
    }

    public ClassFieldMsAttributes getAttribute() {
        return this.attribute;
    }

    public RecordNumber getFieldTypeRecordNumber() {
        return this.fieldTypeRecordNumber;
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        builder.append(this.attribute);
        builder.append(": ");
        StringBuilder myBuilder = new StringBuilder();
        myBuilder.append(this.name);
        this.pdb.getTypeRecord(this.fieldTypeRecordNumber).emit(myBuilder, AbstractMsType.Bind.NONE);
        builder.append((CharSequence)myBuilder);
        builder.append("<@");
        builder.append(this.offset);
        builder.append(">");
    }
}

