/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;

public class FunctionIdMsType
extends AbstractMsType {
    public static final int PDB_ID = 5633;
    private RecordNumber scopeIdRecordNumber;
    private RecordNumber functionTypeRecordNumber;
    private String name;

    public FunctionIdMsType(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.scopeIdRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.ITEM, 32);
        this.functionTypeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        this.name = reader.parseString(pdb, StringParseType.StringNt);
        reader.skipPadding();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public RecordNumber getScopeIdRecordNumber() {
        return this.scopeIdRecordNumber;
    }

    public RecordNumber getFunctionTypeRecordNumber() {
        return this.functionTypeRecordNumber;
    }

    @Override
    public int getPdbId() {
        return 5633;
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        StringBuilder myBuilder = new StringBuilder();
        if (this.scopeIdRecordNumber != RecordNumber.NO_TYPE) {
            myBuilder.append(this.pdb.getTypeRecord(this.scopeIdRecordNumber));
            myBuilder.append("::");
        }
        myBuilder.append(this.name);
        this.pdb.getTypeRecord(this.functionTypeRecordNumber).emit(myBuilder, AbstractMsType.Bind.NONE);
        builder.append("FunctionId for: ");
        builder.append((CharSequence)myBuilder);
    }
}

