/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.listing;

import docking.DialogComponentProvider;
import docking.widgets.dialogs.ReadTextDialog;
import ghidra.app.merge.MergeConstants;
import ghidra.app.merge.ProgramMultiUserMergeManager;
import ghidra.app.merge.listing.ConflictInfoPanel;
import ghidra.app.merge.listing.ConflictPanel;
import ghidra.app.merge.listing.ListingMergeConstants;
import ghidra.app.merge.listing.ListingMergeManager;
import ghidra.app.merge.listing.ListingMerger;
import ghidra.app.merge.tool.ListingMergePanel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.util.DiffUtility;
import ghidra.program.util.ProgramDiff;
import ghidra.util.exception.AssertException;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

abstract class AbstractListingMerger
implements ListingMerger,
ListingMergeConstants {
    protected static final int RESULT = 0;
    protected static final int LATEST = 1;
    protected static final int MY = 2;
    protected static final int ORIGINAL = 3;
    protected static final Color MERGE_HIGHLIGHT_COLOR = MergeConstants.HIGHLIGHT_COLOR;
    protected ProgramMultiUserMergeManager mergeManager;
    protected ListingMergeManager listingMergeMgr;
    protected ListingMergePanel listingMergePanel;
    protected ConflictInfoPanel conflictInfoPanel;
    protected int conflictOption = 0;
    protected Address currentAddress;
    protected TaskMonitor currentMonitor;
    protected Program resultPgm;
    protected Program originalPgm;
    protected Program latestPgm;
    protected Program myPgm;
    protected AddressFactory resultAddressFactory;
    protected ProgramDiff diffOriginalLatest;
    protected ProgramDiff diffOriginalMy;
    protected ProgramDiff diffLatestMy;
    protected StringBuffer errorBuf;
    protected StringBuffer infoBuf;
    protected long totalChanges = 1L;
    protected long changeNum;
    protected int minPhaseProgressPercentage;
    protected int maxPhaseProgressPercentage;
    protected ConflictPanel currentConflictPanel;
    protected int numConflictsResolved;

    AbstractListingMerger(ListingMergeManager listingMergeMgr) {
        this.listingMergeMgr = listingMergeMgr;
        this.init();
    }

    protected void init() {
        this.errorBuf = new StringBuffer();
        this.infoBuf = new StringBuffer();
        this.mergeManager = this.listingMergeMgr.mergeManager;
        this.listingMergePanel = this.listingMergeMgr.getListingMergePanel();
        this.conflictInfoPanel = this.listingMergeMgr.getConflictInfoPanel();
        this.resultPgm = this.listingMergeMgr.programs[0];
        this.originalPgm = this.listingMergeMgr.programs[3];
        this.latestPgm = this.listingMergeMgr.programs[1];
        this.myPgm = this.listingMergeMgr.programs[2];
        this.resultAddressFactory = this.resultPgm.getAddressFactory();
        this.diffOriginalLatest = this.listingMergeMgr.diffOriginalLatest;
        this.diffOriginalMy = this.listingMergeMgr.diffOriginalMy;
        this.diffLatestMy = this.listingMergeMgr.diffLatestMy;
    }

    protected void initializeAutoMerge(String progressMessage, int progressMin, int progressMax, TaskMonitor monitor) {
        this.minPhaseProgressPercentage = progressMin;
        this.maxPhaseProgressPercentage = progressMax;
        this.totalChanges = 0L;
        this.changeNum = 0L;
        this.mergeManager.updateProgress(progressMin, progressMessage);
        monitor.setMessage(progressMessage);
    }

    int getProgramIndex(Program pgm) {
        if (pgm == this.resultPgm) {
            return 0;
        }
        if (pgm == this.latestPgm) {
            return 1;
        }
        if (pgm == this.myPgm) {
            return 2;
        }
        if (pgm == this.originalPgm) {
            return 3;
        }
        return -1;
    }

    Program getProgramForConflictOption(int chosenConflictOption) {
        switch (chosenConflictOption) {
            case 2: {
                return this.latestPgm;
            }
            case 4: {
                return this.myPgm;
            }
            case 1: {
                return this.originalPgm;
            }
        }
        return null;
    }

    AddressSet limitToStartofCodeUnits(Program program, AddressSetView initialSet) {
        Listing listing = program.getListing();
        AddressSet returnSet = new AddressSet();
        AddressIterator iter = initialSet.getAddresses(true);
        while (iter.hasNext()) {
            Address address = iter.next();
            CodeUnit cu = listing.getCodeUnitAt(address);
            if (cu == null) continue;
            returnSet.addRange(address, address);
        }
        return returnSet;
    }

    protected AddressSetView getCodeUnitAddressSet(Address addr) {
        return this.getCodeUnitAddressSet(new AddressSet(addr, addr));
    }

    protected AddressSetView getCodeUnitAddressSet(AddressSet addrs) {
        AddressSet codeSet = new AddressSet();
        codeSet.add((AddressSetView)DiffUtility.getCodeUnitSet((AddressSetView)addrs, this.latestPgm));
        codeSet.add((AddressSetView)DiffUtility.getCodeUnitSet((AddressSetView)addrs, this.myPgm));
        codeSet.add((AddressSetView)DiffUtility.getCodeUnitSet((AddressSetView)addrs, this.originalPgm));
        return codeSet;
    }

    void clearResolveErrors() {
        if (this.errorBuf.length() > 0) {
            this.errorBuf = new StringBuffer();
        }
    }

    void showResolveErrors() {
        if (this.errorBuf.length() > 0) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        String title = AbstractListingMerger.this.getConflictType() + " Merge Errors";
                        String msg = AbstractListingMerger.this.errorBuf.toString();
                        ReadTextDialog dialog = new ReadTextDialog(title, msg);
                        PluginTool mergeTool = AbstractListingMerger.this.mergeManager.getMergeTool();
                        AbstractListingMerger.this.mergeManager.getMergeTool().showDialog((DialogComponentProvider)dialog, (Component)mergeTool.getActiveWindow());
                    }
                });
            }
            catch (InterruptedException e) {
                throw new AssertException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new AssertException((Throwable)e);
            }
        }
    }

    void clearResolveInfo() {
        if (this.infoBuf.length() > 0) {
            this.infoBuf = new StringBuffer();
        }
    }

    void showResolveInfo() {
        if (this.infoBuf.length() > 0) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        String title = AbstractListingMerger.this.getConflictType() + " Merge Information";
                        String msg = AbstractListingMerger.this.infoBuf.toString();
                        ReadTextDialog dialog = new ReadTextDialog(title, msg);
                        PluginTool mergeTool = AbstractListingMerger.this.mergeManager.getMergeTool();
                        AbstractListingMerger.this.mergeManager.getMergeTool().showDialog((DialogComponentProvider)dialog, (Component)mergeTool.getActiveWindow());
                    }
                });
            }
            catch (InterruptedException e) {
                throw new AssertException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new AssertException((Throwable)e);
            }
        }
    }

    @Override
    public boolean apply() {
        this.numConflictsResolved = 0;
        if (this.currentConflictPanel != null) {
            this.numConflictsResolved = this.currentConflictPanel.getNumConflictsResolved();
            if (this.currentConflictPanel.allChoicesAreResolved()) {
                this.currentConflictPanel.removeAllListeners();
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void cancel() {
    }

    @Override
    public int getNumConflictsResolved() {
        return this.numConflictsResolved;
    }

    protected void incrementProgress(int increment) {
        int progressRange = this.maxPhaseProgressPercentage - this.minPhaseProgressPercentage;
        this.changeNum += (long)increment;
        long granularity = this.totalChanges / (long)progressRange + 1L;
        if (this.changeNum % granularity == 0L) {
            if (this.totalChanges <= 0L) {
                this.totalChanges = 1L;
            }
            this.mergeManager.updateProgress((int)((long)this.minPhaseProgressPercentage + this.changeNum * (long)progressRange / this.totalChanges));
        }
    }

    protected void updateProgressMessage(String message) {
        this.mergeManager.updateProgress(message);
    }

    protected void updateProgress(int myPercentComplete) {
        int progressRange = this.maxPhaseProgressPercentage - this.minPhaseProgressPercentage;
        int myProgress = myPercentComplete * progressRange / 100;
        this.mergeManager.updateProgress(this.minPhaseProgressPercentage + myProgress);
    }

    protected void updateProgress(int myPercentComplete, String message) {
        int progressRange = this.maxPhaseProgressPercentage - this.minPhaseProgressPercentage;
        int myProgress = myPercentComplete * progressRange / 100;
        this.mergeManager.updateProgress(this.minPhaseProgressPercentage + myProgress);
        this.mergeManager.updateProgress(message);
    }
}

