/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.tree.ArchiveRootNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeArchiveGTree;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import resources.Icons;

public class CollapseAllArchivesAction
extends DockingAction {
    private Icon collapseIcon = Icons.COLLAPSE_ALL_ICON;
    private final DataTypeManagerPlugin plugin;

    public CollapseAllArchivesAction(DataTypeManagerPlugin plugin) {
        super("Collapse All", plugin.getName());
        this.plugin = plugin;
        this.updatePopupMenu(false);
        this.setToolBarData(new ToolBarData(this.collapseIcon, null));
        this.setKeyBindingData(new KeyBindingData(38, 512));
        this.setEnabled(true);
        this.setDescription("Collapse All Data Types for Program and Archives");
    }

    private void updatePopupMenu(boolean isSingleNodeSelected) {
        if (isSingleNodeSelected) {
            this.setPopupMenuData(new MenuData(new String[]{"Collapse"}, this.collapseIcon, "Tree"));
        } else {
            this.setPopupMenuData(new MenuData(new String[]{"Collapse All"}, this.collapseIcon, "Tree"));
        }
    }

    public boolean isAddToPopup(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        Object contextObject = context.getContextObject();
        GTree gtree = (GTree)contextObject;
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        boolean hasLeaf = this.isLeafNodeSelection(selectionPaths);
        if (hasLeaf) {
            return selectionPaths.length != 1;
        }
        return true;
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            this.updatePopupMenu(false);
            return false;
        }
        Object contextObject = context.getContextObject();
        GTree gtree = (GTree)contextObject;
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        if (selectionPaths.length == 0) {
            this.updatePopupMenu(false);
        } else if (selectionPaths.length == 1) {
            this.updatePopupMenu(true);
        } else {
            this.updatePopupMenu(false);
        }
        return true;
    }

    private boolean isLeafNodeSelection(TreePath[] selectionPaths) {
        for (TreePath path : selectionPaths) {
            GTreeNode node = (GTreeNode)path.getLastPathComponent();
            if (!node.isLeaf()) continue;
            return true;
        }
        return false;
    }

    public void actionPerformed(ActionContext context) {
        DataTypesActionContext dataTypeContext;
        if (!(context instanceof DataTypesActionContext)) {
            this.collapseAll(this.plugin.getProvider().getGTree());
        }
        if ((dataTypeContext = (DataTypesActionContext)context).isToolbarAction()) {
            this.collapseAll(this.plugin.getProvider().getGTree());
        } else {
            DataTypeArchiveGTree gtree = (DataTypeArchiveGTree)((Object)context.getContextObject());
            TreePath[] selectionPaths = gtree.getSelectionPaths();
            if (selectionPaths == null || selectionPaths.length != 1) {
                this.collapseAll(this.plugin.getProvider().getGTree());
            }
            if (selectionPaths != null) {
                for (TreePath path : selectionPaths) {
                    GTreeNode node = (GTreeNode)path.getLastPathComponent();
                    if (node instanceof ArchiveRootNode) {
                        this.collapseAll(gtree);
                        return;
                    }
                    gtree.collapseAll(node);
                }
            }
        }
    }

    private void collapseAll(GTree archiveGTree) {
        GTreeNode rootNode = archiveGTree.getViewRoot();
        List children = rootNode.getChildren();
        for (GTreeNode childNode : children) {
            archiveGTree.collapseAll(childNode);
        }
    }
}

