/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.ToolBarData;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesProvider;
import ghidra.app.plugin.core.datamgr.tree.DataTypeArchiveGTree;
import ghidra.app.plugin.core.datamgr.tree.DtFilterDialog;
import ghidra.app.plugin.core.datamgr.tree.DtFilterState;
import java.awt.Component;
import java.util.List;
import javax.swing.tree.TreePath;
import resources.Icons;

public class DtFilterAction
extends DockingAction {
    private DataTypeManagerPlugin plugin;

    public DtFilterAction(DataTypeManagerPlugin plugin) {
        super("Show Filter", plugin.getName());
        this.plugin = plugin;
        this.setToolBarData(new ToolBarData(Icons.CONFIGURE_FILTER_ICON, "filters"));
        this.setDescription("Shows the Data Types filter");
    }

    public boolean isEnabledForContext(ActionContext context) {
        ComponentProvider provider = context.getComponentProvider();
        return provider instanceof DataTypesProvider;
    }

    public void actionPerformed(ActionContext context) {
        DataTypeArchiveGTree gtree = (DataTypeArchiveGTree)((Object)context.getContextObject());
        List expandedPaths = gtree.getExpandedPaths(gtree.getViewRoot());
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        DataTypesProvider provider = (DataTypesProvider)context.getComponentProvider();
        DtFilterState currentFilterState = provider.getFilterState();
        DtFilterDialog dialog = new DtFilterDialog(currentFilterState);
        this.plugin.getTool().showDialog((DialogComponentProvider)dialog, (Component)provider.getComponent());
        if (dialog.isCancelled()) {
            return;
        }
        DtFilterState newFilterState = dialog.getFilterState();
        if (currentFilterState.equals(newFilterState)) {
            return;
        }
        provider.setFilterState(newFilterState);
        gtree.expandPaths(expandedPaths);
        gtree.setSelectionPaths(selectionPaths);
    }
}

