/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.disassembler;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.disassembler.DisassemblerPlugin;
import ghidra.program.model.address.Address;

class DisassembleAction
extends ListingContextAction {
    private DisassemblerPlugin plugin;

    public DisassembleAction(DisassemblerPlugin plugin, String groupName) {
        super("Disassemble", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Disassemble", "Disassemble"}, null, groupName));
        this.setKeyBindingData(new KeyBindingData(68, 0));
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        this.plugin.disassembleCallback(context);
    }

    @Override
    public boolean isEnabledForContext(ListingActionContext context) {
        Address address = context.getAddress();
        if (address == null) {
            return false;
        }
        return this.plugin.checkDisassemblyEnabled(context, address, true);
    }
}

