/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.searchtext;

import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.RowColLocation;
import ghidra.app.plugin.core.searchtext.SearchOptions;
import ghidra.app.plugin.core.searchtext.Searcher;
import ghidra.app.plugin.core.searchtext.iterators.DataSearchAddressIterator;
import ghidra.app.plugin.core.searchtext.iterators.InstructionSearchAddressIterator;
import ghidra.app.plugin.core.searchtext.iterators.LabelSearchAddressIterator;
import ghidra.app.services.CodeViewerService;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.listingpanel.ListingModel;
import ghidra.framework.model.DomainObjectException;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.util.MultiAddressIterator;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Msg;
import ghidra.util.UserSearchUtils;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ListingDisplaySearcher
implements Searcher {
    private PluginTool tool;
    private Program program;
    private ListingModel listingModel;
    private boolean isInitialized;
    private SearchOptions options;
    private AddressSetView searchAddresses;
    private TaskMonitor monitor;
    private List<Searcher.TextSearchResult> results;
    private ListIterator<Searcher.TextSearchResult> locationIterator;
    private ProgramLocation startLocation;
    private int startIndex;
    private Address startAddress;
    private Address currentAddress;
    private CodeUnit currentCodeUnit;
    private Layout currentLayout;
    private int currentFieldIndex;
    private MultiAddressIterator addressIterator;
    private Pattern searchPattern;

    ListingDisplaySearcher(PluginTool tool, Program program, ProgramLocation startLocation, AddressSetView set, SearchOptions options, TaskMonitor monitor) {
        this.tool = tool;
        this.program = program;
        this.startLocation = startLocation;
        this.searchAddresses = set;
        this.options = options;
        this.monitor = monitor;
        this.initializeStartAddress(set);
        this.initializeAddressSet();
        this.addressIterator = new MultiAddressIterator(this.getSearchIterators(), options.isForward());
        this.searchPattern = UserSearchUtils.createSearchPattern((String)options.getText(), (boolean)options.isCaseSensitive());
        this.results = new ArrayList<Searcher.TextSearchResult>();
        this.locationIterator = this.results.listIterator();
        CodeViewerService service = (CodeViewerService)tool.getService(CodeViewerService.class);
        this.listingModel = service.getListingModel();
        monitor.initialize(this.searchAddresses.getNumAddresses());
    }

    private void initializeStartAddress(AddressSetView set) {
        this.startAddress = this.startLocation != null ? this.startLocation.getAddress() : (set != null ? (this.options.isForward() ? set.getMinAddress() : set.getMaxAddress()) : (this.options.isForward() ? this.program.getMinAddress() : this.program.getMaxAddress()));
    }

    private void initializeAddressSet() {
        Address end;
        if (this.searchAddresses == null) {
            this.searchAddresses = this.program.getMemory();
        }
        CodeUnit cu = this.program.getListing().getCodeUnitContaining(this.startAddress);
        Address start = this.options.isForward() ? cu.getMinAddress() : this.searchAddresses.getMinAddress();
        Address address = end = this.options.isForward() ? this.searchAddresses.getMaxAddress() : cu.getMaxAddress();
        if (start.compareTo((Object)end) <= 0) {
            AddressSet restrictedSet = new AddressSet(this.program, start, end);
            this.searchAddresses = this.searchAddresses.intersect((AddressSetView)restrictedSet);
        } else {
            this.searchAddresses = new AddressSet();
        }
    }

    private AddressIterator[] getSearchIterators() {
        ArrayList<Object> iterators = new ArrayList<Object>();
        Listing listing = this.program.getListing();
        InstructionIterator instructions = listing.getInstructions(this.searchAddresses, this.options.isForward());
        iterators.add(new InstructionSearchAddressIterator(instructions));
        DataIterator data = listing.getDefinedData(this.searchAddresses, this.options.isForward());
        iterators.add(new DataSearchAddressIterator(data, this.options.isForward()));
        boolean all = this.options.searchAllFields();
        if (this.options.searchComments() || all) {
            iterators.add(listing.getCommentAddressIterator(this.searchAddresses, this.options.isForward()));
        }
        if (this.options.searchLabels() || all) {
            SymbolIterator labels = this.program.getSymbolTable().getPrimarySymbolIterator(this.searchAddresses, this.options.isForward());
            iterators.add(new LabelSearchAddressIterator(labels));
        }
        return iterators.toArray(new AddressIterator[iterators.size()]);
    }

    Searcher.TextSearchResult next() {
        boolean isForward;
        if (this.results.size() == 0) {
            this.findNext();
        }
        if ((isForward = this.options.isForward()) && this.locationIterator.hasNext()) {
            Searcher.TextSearchResult result = this.locationIterator.next();
            if (!this.locationIterator.hasNext()) {
                this.results.clear();
                this.locationIterator = this.results.listIterator();
            }
            return result;
        }
        if (!isForward && this.locationIterator.hasPrevious()) {
            Searcher.TextSearchResult result = this.locationIterator.previous();
            if (!this.locationIterator.hasPrevious()) {
                this.results.clear();
                this.locationIterator = this.results.listIterator();
            }
            return result;
        }
        return null;
    }

    boolean hasNext() {
        if (this.results.size() == 0) {
            this.findNext();
        }
        return this.options.isForward() ? this.locationIterator.hasNext() : this.locationIterator.hasPrevious();
    }

    @Override
    public void setMonitor(TaskMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public Searcher.TextSearchResult search() {
        block5: {
            try {
                if (this.hasNext()) {
                    return this.next();
                }
            }
            catch (Exception e) {
                if (this.tool.isExecutingCommand()) {
                    this.tool.setStatusInfo("Search failed: try search when tool is not executing commands that may change the program");
                }
                if (!this.program.isClosed() && this.program.getCurrentTransactionInfo() != null) {
                    this.tool.setStatusInfo("Search failed: try search when program is not being changed");
                }
                if (this.program.isClosed() || e instanceof DomainObjectException) break block5;
                Msg.showError((Object)this, null, (String)"Error", (Object)"Error searching", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public SearchOptions getSearchOptions() {
        return this.options;
    }

    private void findNext() {
        if (this.currentLayout != null) {
            this.findNextMatch();
            if (this.results.size() > 0) {
                return;
            }
        }
        int progress = this.options.getProgress();
        this.monitor.setMessage("Searching...");
        this.currentAddress = null;
        this.currentCodeUnit = null;
        Listing listing = this.program.getListing();
        while (!this.monitor.isCancelled() && this.currentLayout == null && this.addressIterator.hasNext() && this.results.size() == 0) {
            this.currentAddress = this.addressIterator.next();
            this.monitor.setMessage("Checking address " + String.valueOf(this.currentAddress));
            if (!this.options.searchAllFields()) {
                this.currentCodeUnit = listing.getCodeUnitContaining(this.currentAddress);
            }
            this.options.setProgress(++progress);
            this.monitor.setProgress((long)progress);
            if (this.options.isForward() && this.currentAddress.compareTo((Object)this.startAddress) < 0 || !this.options.isForward() && this.currentAddress.compareTo((Object)this.startAddress) > 0) continue;
            if (this.options.isForward() && this.currentAddress.compareTo((Object)this.searchAddresses.getMaxAddress()) > 0 || !this.options.isForward() && this.currentAddress.compareTo((Object)this.searchAddresses.getMinAddress()) < 0) {
                return;
            }
            if (!this.searchAddresses.contains(this.currentAddress)) continue;
            this.currentLayout = this.listingModel.getLayout(this.currentAddress, false);
            if (this.currentLayout == null) continue;
            if (this.options.isForward()) {
                while (!this.monitor.isCancelled() && this.results.size() == 0 && this.currentLayout != null && this.currentFieldIndex < this.currentLayout.getNumFields()) {
                    this.findNextMatch();
                }
                continue;
            }
            this.currentFieldIndex = this.currentLayout.getNumFields() - 1;
            while (!this.monitor.isCancelled() && this.results.size() == 0 && this.currentLayout != null && this.currentFieldIndex >= 0) {
                this.findNextMatch();
            }
        }
    }

    private void findNextMatch() {
        if (this.options.isForward()) {
            this.initializeForward();
            this.searchForward();
        } else {
            this.initializeBackward();
            this.searchBackward();
        }
    }

    private void searchForward() {
        int i = this.currentFieldIndex;
        while (i < this.currentLayout.getNumFields()) {
            int matchingFieldCount = this.findLocations(i);
            if (matchingFieldCount != 0) {
                this.currentFieldIndex += matchingFieldCount;
                return;
            }
            ++i;
            ++this.currentFieldIndex;
        }
        this.currentLayout = null;
        this.currentFieldIndex = 0;
    }

    private void searchBackward() {
        int i = this.currentFieldIndex;
        while (i >= 0) {
            int matchingFieldCount = this.findLocations(i);
            if (matchingFieldCount != 0) {
                this.currentFieldIndex -= matchingFieldCount;
                return;
            }
            --i;
            --this.currentFieldIndex;
        }
        this.currentLayout = null;
        this.currentFieldIndex = 0;
    }

    private int findLocations(int fieldIndex) {
        boolean isInstructionsOrData;
        Field f = this.currentLayout.getField(fieldIndex);
        if (!(f instanceof ListingField)) {
            return 0;
        }
        ListingField field = (ListingField)f;
        FieldFactory ff = field.getFieldFactory();
        String fieldName = ff.getFieldName();
        if (!this.doSearchField(fieldName)) {
            return 0;
        }
        int fieldCount = 1;
        boolean isMnemonic = fieldName.equals("Mnemonic");
        boolean bl = isInstructionsOrData = this.options.searchAllFields() || this.options.searchBothDataMnemonicsAndOperands() || this.options.searchBothInstructionMnemonicAndOperands();
        if (isMnemonic && isInstructionsOrData) {
            if (this.currentFieldIndex <= this.currentLayout.getNumFields() - 2) {
                ListingField opField;
                Field f2 = this.currentLayout.getField(fieldIndex + 1);
                if (f2 instanceof ListingField && (opField = (ListingField)f2).getFieldFactory().getFieldName().equals("Operands")) {
                    this.findMnemonicOperandLocations(field, opField);
                    fieldCount = 2;
                }
            } else {
                this.findLocations(field);
            }
        } else {
            this.findLocations(field);
        }
        if (this.results.size() > 0) {
            return fieldCount;
        }
        return 0;
    }

    private void initializeForward() {
        if (this.isInitialized) {
            return;
        }
        this.startIndex = -1;
        if (this.startLocation != null && this.startLocation.getAddress().equals((Object)this.currentAddress)) {
            ListingField field;
            Field f;
            for (int i = 0; !(i >= this.currentLayout.getNumFields() || (f = this.currentLayout.getField(i)) instanceof ListingField && this.getFieldForLocation(field = (ListingField)f, i)); ++i) {
            }
        }
        this.isInitialized = true;
    }

    private void initializeBackward() {
        if (this.isInitialized) {
            return;
        }
        this.startIndex = Integer.MAX_VALUE;
        if (this.startLocation != null && this.startLocation.getAddress().equals((Object)this.currentAddress)) {
            ListingField field;
            for (int i = this.currentLayout.getNumFields() - 1; i >= 0 && !this.getFieldForLocation(field = (ListingField)this.currentLayout.getField(i), i); --i) {
            }
        }
        this.isInitialized = true;
    }

    private boolean getFieldForLocation(ListingField field, int fieldIndex) {
        FieldFactory ff = field.getFieldFactory();
        FieldLocation floc = ff.getFieldLocation(field, BigInteger.ZERO, fieldIndex, this.startLocation);
        if (floc == null) {
            return false;
        }
        if (!this.doSearchField(ff.getFieldName())) {
            return false;
        }
        this.currentFieldIndex = fieldIndex;
        this.startIndex = field.screenLocationToTextOffset(floc.getRow(), floc.getCol());
        return true;
    }

    private boolean doSearchField(String fieldName) {
        if (this.options.searchAllFields()) {
            return true;
        }
        if (this.options.searchComments() && (fieldName.equals("Pre-Comment") || fieldName.equals("Plate Comment") || fieldName.equals("Post-Comment") || fieldName.equals("EOL Comment"))) {
            return true;
        }
        if (this.options.searchBothInstructionMnemonicAndOperands() && this.currentCodeUnit instanceof Instruction && (fieldName.equals("Mnemonic") || fieldName.equals("Operands"))) {
            return true;
        }
        if (this.options.searchOnlyInstructionMnemonics() && this.currentCodeUnit instanceof Instruction && fieldName.equals("Mnemonic")) {
            return true;
        }
        if (this.options.searchOnlyInstructionOperands() && this.currentCodeUnit instanceof Instruction && fieldName.equals("Operands")) {
            return true;
        }
        if (this.options.searchBothDataMnemonicsAndOperands() && this.currentCodeUnit instanceof Data && (fieldName.equals("Mnemonic") || fieldName.equals("Operands"))) {
            return true;
        }
        if (this.options.searchOnlyDataMnemonics() && this.currentCodeUnit instanceof Data && fieldName.equals("Mnemonic")) {
            return true;
        }
        if (this.options.searchOnlyDataOperands() && this.currentCodeUnit instanceof Data && fieldName.equals("Operands")) {
            return true;
        }
        if (this.options.searchFunctions() && (fieldName.equals("Function Repeatable Comment") || fieldName.equals("Function Signature") || fieldName.equals("Variable Comment") || fieldName.equals("Variable Location") || fieldName.equals("Variable Name") || fieldName.equals("Variable Type"))) {
            return true;
        }
        return this.options.searchLabels() && fieldName.equals("Label");
    }

    private void findMnemonicOperandLocations(ListingField mnemonicField, ListingField opField) {
        int index;
        MnemonicText mnemonicText = this.generateMnemonicSearchText(mnemonicField, opField);
        String text = mnemonicText.getText();
        Matcher matcher = this.searchPattern.matcher(text);
        boolean forward = this.options.isForward();
        int mnemonicLength = mnemonicText.mnemonicLength();
        while (matcher.find() && (index = matcher.start()) <= mnemonicLength) {
            if (forward && index <= this.startIndex) continue;
            if (!forward && index >= this.startIndex) break;
            FieldFactory fieldFactory = mnemonicField.getFieldFactory();
            RowColLocation rc = mnemonicField.textOffsetToScreenLocation(index);
            int col = rc.col();
            if (index == mnemonicLength) {
                ++col;
            }
            ProgramLocation loc = fieldFactory.getProgramLocation(rc.row(), col, mnemonicField);
            this.results.add(new Searcher.TextSearchResult(loc, index));
        }
        this.adjustIterator();
    }

    private MnemonicText generateMnemonicSearchText(ListingField mnemonicField, ListingField opField) {
        String mnemonic = mnemonicField.getText();
        String operands = opField != null ? opField.getText() : "";
        return new MnemonicText(this, mnemonic, operands);
    }

    private void findLocations(ListingField field) {
        String text = field.getText();
        boolean forward = this.options.isForward();
        Matcher match = this.searchPattern.matcher(text);
        while (match.find()) {
            int index = match.start();
            if (forward && index <= this.startIndex) continue;
            if (!forward && index >= this.startIndex) break;
            RowColLocation rc = field.textOffsetToScreenLocation(index);
            FieldFactory fieldFactory = field.getFieldFactory();
            ProgramLocation loc = fieldFactory.getProgramLocation(rc.row(), rc.col(), field);
            if (loc == null || this.isSameLocation(loc)) continue;
            this.results.add(new Searcher.TextSearchResult(loc, index));
        }
        this.adjustIterator();
        this.startIndex = forward ? -1 : Integer.MAX_VALUE;
        this.startLocation = null;
    }

    private void adjustIterator() {
        this.locationIterator = this.results.listIterator();
        if (!this.options.isForward()) {
            while (this.locationIterator.hasNext()) {
                this.locationIterator.next();
            }
        }
    }

    private boolean isSameLocation(ProgramLocation loc) {
        if (this.startLocation == null || !(loc instanceof OperandFieldLocation) || !(this.startLocation instanceof OperandFieldLocation)) {
            return false;
        }
        OperandFieldLocation opStartLoc = (OperandFieldLocation)this.startLocation;
        OperandFieldLocation opLoc = (OperandFieldLocation)loc;
        if (!opStartLoc.getAddress().equals((Object)opLoc.getAddress())) {
            return false;
        }
        return opStartLoc.getSubOperandIndex() < 0 && opStartLoc.getOperandIndex() == opLoc.getOperandIndex();
    }

    private class MnemonicText {
        private String mnemonic;
        private String text;

        MnemonicText(ListingDisplaySearcher listingDisplaySearcher, String mnemonic, String operands) {
            this.mnemonic = mnemonic;
            this.text = mnemonic + " " + operands;
        }

        int mnemonicLength() {
            return this.mnemonic.length();
        }

        String getText() {
            return this.text;
        }
    }
}

