/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.script;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.label.GLabel;
import ghidra.app.script.SelectAllCheckBox;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class MultipleOptionsDialog<T>
extends DialogComponentProvider {
    private boolean isCanceled;
    private GCheckBox[] selectOptions;
    private List<T> actualChoices;
    private List<String> stringChoices;
    private List<T> chosenByUser;
    private boolean includeSelectAll;
    private SelectAllCheckBox selectAllGroup;

    protected MultipleOptionsDialog(String title, String message, List<T> choices, boolean includeSelectAllBox) {
        super(title, true);
        this.stringChoices = new ArrayList<String>();
        for (int i = 0; i < choices.size(); ++i) {
            this.stringChoices.add(choices.get(i).toString());
        }
        this.actualChoices = choices;
        this.includeSelectAll = includeSelectAllBox;
        this.setup(message);
    }

    protected MultipleOptionsDialog(String title, String message, List<T> choices, List<String> stringRepresentationOfChoices, boolean includeSelectAllBox) {
        super(title, true);
        this.stringChoices = stringRepresentationOfChoices;
        this.actualChoices = choices;
        this.includeSelectAll = includeSelectAllBox;
        this.setup(message);
    }

    protected void setup(String message) {
        JPanel panel = new JPanel(new GridLayout(0, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)new GLabel(message), "West");
        if (this.includeSelectAll) {
            this.selectAllGroup = new SelectAllCheckBox();
            GCheckBox selectAllCheckBox = new GCheckBox("[ Select All ]", false);
            selectAllCheckBox.setName("select.all.check.box");
            selectAllCheckBox.getAccessibleContext().setAccessibleName("Select All");
            panel.add((Component)selectAllCheckBox);
            panel.add(new JSeparator());
            this.selectAllGroup.setSelectAllCheckBox((JCheckBox)selectAllCheckBox);
        }
        this.selectOptions = new GCheckBox[this.stringChoices.size()];
        for (int i = 0; i < this.selectOptions.length; ++i) {
            GCheckBox newCheckBox = new GCheckBox(this.stringChoices.get(i));
            newCheckBox.setActionCommand(Integer.toString(i));
            newCheckBox.setName("choice.check.box." + (i + 1));
            newCheckBox.setSelected(false);
            newCheckBox.getAccessibleContext().setAccessibleName(this.stringChoices.get(i).toString());
            this.selectOptions[i] = newCheckBox;
            panel.add((Component)this.selectOptions[i]);
            if (!this.includeSelectAll) continue;
            this.selectAllGroup.addCheckBox((JCheckBox)newCheckBox);
        }
        panel.getAccessibleContext().setAccessibleName("Multiple Options");
        this.addWorkPanel(panel);
        this.addOKButton();
        this.addCancelButton();
    }

    public void show() {
        DockingWindowManager.showDialog(null, (DialogComponentProvider)this);
    }

    protected void okCallback() {
        ArrayList<T> choicesMade = new ArrayList<T>();
        for (int i = 0; i < this.selectOptions.length; ++i) {
            if (!this.selectOptions[i].isSelected()) continue;
            choicesMade.add(this.actualChoices.get(i));
        }
        this.chosenByUser = choicesMade;
        this.close();
    }

    protected void cancelCallback() {
        this.isCanceled = true;
        this.close();
    }

    protected boolean isCanceled() {
        return this.isCanceled;
    }

    protected List<T> getUserChoices() {
        return this.chosenByUser;
    }
}

