/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands.codesignature;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.codesignature.CodeSignatureBlobIndex;
import ghidra.app.util.bin.format.macho.commands.codesignature.CodeSignatureBlobParser;
import ghidra.app.util.bin.format.macho.commands.codesignature.CodeSignatureGenericBlob;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CodeSignatureSuperBlob
extends CodeSignatureGenericBlob {
    private int count;
    private List<CodeSignatureBlobIndex> indexList;
    private List<CodeSignatureGenericBlob> indexBlobs;

    public CodeSignatureSuperBlob(BinaryReader reader) throws IOException {
        super(reader);
        this.count = reader.readNextInt();
        this.indexList = new ArrayList<CodeSignatureBlobIndex>(this.count);
        for (int i = 0; i < this.count; ++i) {
            this.indexList.add(new CodeSignatureBlobIndex(reader));
        }
        this.indexBlobs = new ArrayList<CodeSignatureGenericBlob>(this.count);
        for (CodeSignatureBlobIndex blobIndex : this.indexList) {
            reader.setPointerIndex(this.base + blobIndex.getOffset());
            this.indexBlobs.add(CodeSignatureBlobParser.parse(reader));
        }
    }

    public int getCount() {
        return this.count;
    }

    public List<CodeSignatureBlobIndex> getIndexEntries() {
        return this.indexList;
    }

    public List<CodeSignatureGenericBlob> getIndexBlobs() {
        return this.indexBlobs;
    }

    @Override
    public void markup(Program program, Address addr, MachHeader header, TaskMonitor monitor, MessageLog log) throws CancelledException {
        try {
            for (int i = 0; i < this.count; ++i) {
                CodeSignatureBlobIndex blobIndex = this.indexList.get(i);
                CodeSignatureGenericBlob blob = this.indexBlobs.get(i);
                Data d = DataUtilities.createData((Program)program, (Address)addr.add(blobIndex.getOffset()), (DataType)blob.toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                StructConverter.setEndian(d, true);
                blob.markup(program, addr.add(blobIndex.getOffset()), header, monitor, log);
            }
        }
        catch (Exception e) {
            log.appendMsg(CodeSignatureSuperBlob.class.getSimpleName(), "Failed to markup CS_SuperBlob");
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("CS_SuperBlob", 0);
        struct.add(DWORD, "magic", "magic number");
        struct.add(DWORD, "length", "total length of SuperBlob");
        struct.add(DWORD, "count", "number of index entries following");
        if (!this.indexList.isEmpty()) {
            DataType dt = this.indexList.get(0).toDataType();
            struct.add((DataType)new ArrayDataType(dt, this.count, dt.getLength()), "index", "(count) entries");
        }
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

