/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheMappingInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfoCommon;
import ghidra.app.util.bin.format.macho.dyld.DyldChainedPtr;
import ghidra.app.util.bin.format.macho.dyld.DyldFixup;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DyldCacheSlideInfo5
extends DyldCacheSlideInfoCommon {
    private static final int DYLD_CACHE_SLIDE_V5_PAGE_ATTR_NO_REBASE = 65535;
    private static final DyldChainedPtr.DyldChainType TYPE = DyldChainedPtr.DyldChainType.DYLD_CHAINED_PTR_ARM64E_SHARED_CACHE;
    private int pageSize;
    private int pageStartsCount;
    private long valueAdd;
    private short[] pageStarts;

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageStartsCount() {
        return this.pageStartsCount;
    }

    public long getValueAdd() {
        return this.valueAdd;
    }

    public short[] getPageStarts() {
        return this.pageStarts;
    }

    public DyldCacheSlideInfo5(BinaryReader reader, DyldCacheMappingInfo mappingInfo) throws IOException {
        super(reader, mappingInfo);
        this.pageSize = reader.readNextInt();
        this.pageStartsCount = reader.readNextInt();
        reader.readNextInt();
        this.valueAdd = reader.readNextLong();
        this.pageStarts = reader.readNextShortArray(this.pageStartsCount);
    }

    @Override
    public List<DyldFixup> getSlideFixups(BinaryReader reader, int pointerSize, MessageLog log, TaskMonitor monitor) throws IOException, CancelledException {
        ArrayList<DyldFixup> fixups = new ArrayList<DyldFixup>();
        monitor.initialize((long)this.pageStartsCount, "Getting DYLD Cache V5 slide fixups...");
        for (int index = 0; index < this.pageStartsCount; ++index) {
            monitor.increment();
            long segmentOffset = this.pageSize * index;
            int pageEntry = Short.toUnsignedInt(this.pageStarts[index]);
            if (pageEntry == 65535) continue;
            long pageOffset = pageEntry / 8 * 8;
            fixups.addAll(this.processPointerChain(segmentOffset, pageOffset, reader, monitor));
        }
        return fixups;
    }

    private List<DyldFixup> processPointerChain(long segmentOffset, long pageOffset, BinaryReader reader, TaskMonitor monitor) throws IOException, CancelledException {
        ArrayList<DyldFixup> fixups = new ArrayList<DyldFixup>(1024);
        int size = DyldChainedPtr.getSize(TYPE);
        long stride = DyldChainedPtr.getStride(TYPE);
        long delta = -1L;
        while (delta != 0L) {
            monitor.checkCancelled();
            long dataOffset = segmentOffset + pageOffset;
            long chainValue = DyldChainedPtr.getChainValue(reader, dataOffset, TYPE);
            long newPtrValue = DyldChainedPtr.getTarget(TYPE, chainValue) + this.valueAdd;
            delta = DyldChainedPtr.getNext(TYPE, chainValue);
            if (!DyldChainedPtr.isAuthenticated(TYPE, chainValue)) {
                long high8 = chainValue >>> 34 & 0xFFL;
                newPtrValue |= high8 << 56;
            }
            fixups.add(new DyldFixup(dataOffset, newPtrValue, size, null, null));
            pageOffset += delta * stride;
        }
        return fixups;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_cache_slide_info5", 0);
        struct.add(DWORD, "version", "currently 5");
        struct.add(DWORD, "page_size", "currently 4096 (may also be 16384)");
        struct.add(DWORD, "page_starts_count", "");
        struct.add(DWORD, "pad", "");
        struct.add(QWORD, "value_add", "");
        struct.add((DataType)new ArrayDataType(WORD, this.pageStartsCount, 1), "page_starts", "");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

