/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.exporter;

import ghidra.app.util.DomainObjectService;
import ghidra.app.util.Option;
import ghidra.app.util.OptionException;
import ghidra.app.util.exporter.ExporterException;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.classfinder.ExtensionPoint;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class Exporter
implements ExtensionPoint {
    protected static final List<Option> EMPTY_OPTIONS = new ArrayList<Option>();
    protected MessageLog log = new MessageLog();
    protected ServiceProvider provider;
    private String name;
    private String extension;
    private HelpLocation help;

    protected Exporter(String name, String extension, HelpLocation help) {
        this.name = Objects.requireNonNull(name);
        this.extension = Objects.requireNonNull(extension);
        this.help = help;
    }

    public final String getName() {
        return this.name;
    }

    public final String getDefaultFileExtension() {
        return this.extension;
    }

    public final HelpLocation getHelpLocation() {
        return this.help;
    }

    public final MessageLog getMessageLog() {
        return this.log;
    }

    public final void setExporterServiceProvider(ServiceProvider provider) {
        this.provider = provider;
    }

    public boolean canExportDomainObject(Class<? extends DomainObject> domainObjectClass) {
        return Program.class.isAssignableFrom(domainObjectClass);
    }

    public boolean canExportDomainFile(DomainFile domainFile) {
        return false;
    }

    public boolean canExportDomainObject(DomainObject domainObject) {
        if (domainObject == null) {
            return false;
        }
        return this.canExportDomainObject(domainObject.getClass());
    }

    public boolean supportsAddressRestrictedExport() {
        return true;
    }

    public abstract List<Option> getOptions(DomainObjectService var1);

    public abstract void setOptions(List<Option> var1) throws OptionException;

    public abstract boolean export(File var1, DomainObject var2, AddressSetView var3, TaskMonitor var4) throws ExporterException, IOException;

    public boolean export(File file, DomainFile domainFile, TaskMonitor monitor) throws ExporterException, IOException {
        throw new UnsupportedOperationException("DomainFile export not supported");
    }

    public final String toString() {
        return this.getName();
    }
}

