/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;

public class MachoProgramUtils {
    public static Address getNextAvailableAddress(Program program) {
        Address maxAddress = null;
        for (MemoryBlock block : program.getMemory().getBlocks()) {
            if (block.isOverlay() || maxAddress != null && block.getEnd().compareTo((Object)maxAddress) <= 0) continue;
            maxAddress = block.getEnd();
        }
        if (maxAddress == null) {
            return program.getAddressFactory().getDefaultAddressSpace().getAddress(4096L);
        }
        long maxAddr = maxAddress.getOffset();
        long remainder = maxAddr % 4096L;
        return maxAddress.getNewAddress(maxAddr + 4096L - remainder);
    }
}

