/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.features.base.codecompare.listing.ListingDiffChangeListener;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.util.DiffUtility;
import ghidra.program.util.ListingAddressCorrelation;
import ghidra.util.Msg;
import ghidra.util.datastruct.Duo;
import java.util.ArrayList;

public class ListingDiff {
    private ListingAddressCorrelation correlation;
    AddressSet unmatchedCode1;
    AddressSet unmatchedCode2;
    AddressSet byteDiffs1;
    AddressSet byteDiffs2;
    AddressSet codeUnitDiffs1;
    AddressSet codeUnitDiffs2;
    private boolean ignoreByteDiffs;
    private boolean ignoreConstants;
    private boolean ignoreRegisters;
    private ArrayList<ListingDiffChangeListener> listeners = new ArrayList();

    public ListingDiff() {
        this.init();
    }

    public void setCorrelation(ListingAddressCorrelation correlation) throws MemoryAccessException {
        this.correlation = correlation;
        if (correlation == null) {
            this.init();
            return;
        }
        this.getDiffs();
    }

    public boolean hasCorrelation() {
        return this.correlation != null;
    }

    private void init() {
        this.unmatchedCode1 = new AddressSet();
        this.unmatchedCode2 = new AddressSet();
        this.codeUnitDiffs1 = new AddressSet();
        this.codeUnitDiffs2 = new AddressSet();
        this.byteDiffs1 = new AddressSet();
        this.byteDiffs2 = new AddressSet();
    }

    private void getDiffs() throws MemoryAccessException {
        this.init();
        AddressSetView addrSet1 = this.correlation.getAddresses(Duo.Side.LEFT);
        AddressSetView addrSet2 = this.correlation.getAddresses(Duo.Side.RIGHT);
        Listing listing1 = this.correlation.getProgram(Duo.Side.LEFT).getListing();
        Listing listing2 = this.correlation.getProgram(Duo.Side.RIGHT).getListing();
        CodeUnitIterator cuIter1 = listing1.getCodeUnits(addrSet1, true);
        CodeUnitIterator cuIter2 = listing2.getCodeUnits(addrSet2, true);
        for (CodeUnit cu1 : cuIter1) {
            Address min1 = cu1.getMinAddress();
            Address addr2 = this.correlation.getAddress(Duo.Side.RIGHT, min1);
            if (addr2 == null) {
                this.unmatchedCode1.addRange(cu1.getMinAddress(), cu1.getMaxAddress());
                continue;
            }
            CodeUnit cu2 = listing2.getCodeUnitAt(addr2);
            this.getByteDiffs(cu1, cu2, this.byteDiffs1);
            this.getCodeUnitDiffs(cu1, cu2, this.codeUnitDiffs1);
        }
        for (CodeUnit cu2 : cuIter2) {
            Address min2 = cu2.getMinAddress();
            Address addr1 = this.correlation.getAddress(Duo.Side.LEFT, min2);
            if (addr1 == null) {
                this.unmatchedCode2.addRange(cu2.getMinAddress(), cu2.getMaxAddress());
                continue;
            }
            CodeUnit cu1 = listing1.getCodeUnitAt(addr1);
            this.getByteDiffs(cu2, cu1, this.byteDiffs2);
            this.getCodeUnitDiffs(cu2, cu1, this.codeUnitDiffs2);
        }
        this.notifyListeners();
    }

    private void recomputeCodeUnitDiffs() {
        AddressSetView addressSet1 = this.correlation.getAddresses(Duo.Side.LEFT);
        AddressSetView addressSet2 = this.correlation.getAddresses(Duo.Side.RIGHT);
        AddressSet matchedAddresses1 = addressSet1.subtract((AddressSetView)this.unmatchedCode1);
        AddressSet matchedAddresses2 = addressSet2.subtract((AddressSetView)this.unmatchedCode2);
        Listing listing1 = this.correlation.getProgram(Duo.Side.LEFT).getListing();
        Listing listing2 = this.correlation.getProgram(Duo.Side.RIGHT).getListing();
        CodeUnitIterator cuIter1 = listing1.getCodeUnits((AddressSetView)matchedAddresses1, true);
        CodeUnitIterator cuIter2 = listing2.getCodeUnits((AddressSetView)matchedAddresses2, true);
        this.codeUnitDiffs1.clear();
        for (CodeUnit cu1 : cuIter1) {
            Address min1 = cu1.getMinAddress();
            Address addr2 = this.correlation.getAddress(Duo.Side.RIGHT, min1);
            if (addr2 == null) continue;
            CodeUnit cu2 = listing2.getCodeUnitAt(addr2);
            this.getCodeUnitDiffs(cu1, cu2, this.codeUnitDiffs1);
        }
        this.codeUnitDiffs2.clear();
        for (CodeUnit cu2 : cuIter2) {
            Address min2 = cu2.getMinAddress();
            Address addr1 = this.correlation.getAddress(Duo.Side.LEFT, min2);
            if (addr1 == null) continue;
            CodeUnit cu1 = listing1.getCodeUnitAt(addr1);
            this.getCodeUnitDiffs(cu2, cu1, this.codeUnitDiffs2);
        }
    }

    private void getByteDiffs(CodeUnit cu1, CodeUnit cu2, AddressSet byteDiffs) throws MemoryAccessException {
        if (cu2 == null) {
            byteDiffs.addRange(cu1.getMinAddress(), cu1.getMaxAddress());
        } else {
            byte[] bytes1 = cu1.getBytes();
            byte[] bytes2 = cu2.getBytes();
            int minBytes = Math.min(bytes1.length, bytes2.length);
            Address minAddr = cu1.getMinAddress();
            for (int i = 0; i < minBytes; ++i) {
                if (bytes1[i] == bytes2[i]) continue;
                byteDiffs.add(minAddr.add((long)i));
            }
            if (bytes1.length > bytes2.length) {
                byteDiffs.addRange(minAddr.add((long)bytes2.length), cu1.getMaxAddress());
            }
        }
    }

    private void getCodeUnitDiffs(CodeUnit cu1, CodeUnit cu2, AddressSet cuDiffs) {
        if (!this.equivalentCodeUnits(cu1, cu2)) {
            cuDiffs.addRange(cu1.getMinAddress(), cu1.getMaxAddress());
        }
    }

    private boolean equivalentCodeUnits(CodeUnit cu1, CodeUnit cu2) {
        if (!this.isSameMnemonic(cu1, cu2)) {
            return false;
        }
        if (this.doesEntireOperandSetDiffer(cu1, cu2)) {
            return false;
        }
        int[] operandsThatDiffer = this.getOperandsThatDiffer(cu1, cu2);
        return operandsThatDiffer != null && operandsThatDiffer.length == 0;
    }

    private boolean isSameMnemonic(CodeUnit codeUnit1, CodeUnit codeUnit2) {
        if (!this.sameType(codeUnit1, codeUnit2)) {
            return false;
        }
        return codeUnit1.getMnemonicString().equals(codeUnit2.getMnemonicString());
    }

    public int[] getOperandsThatDiffer(CodeUnit codeUnit1, CodeUnit codeUnit2) {
        Data data2;
        Data data1;
        int numOperands = codeUnit1.getNumOperands();
        if (codeUnit2 == null) {
            return this.getAllIndices(numOperands);
        }
        if (codeUnit1 instanceof Instruction && codeUnit2 instanceof Instruction) {
            int otherNumOperands = codeUnit2.getNumOperands();
            if (numOperands != otherNumOperands) {
                return this.getAllIndices(numOperands);
            }
            Instruction inst1 = (Instruction)codeUnit1;
            Instruction inst2 = (Instruction)codeUnit2;
            ArrayList<Integer> opIndices = new ArrayList<Integer>();
            for (int opIndex = 0; opIndex < numOperands; ++opIndex) {
                Object[] opObjects2;
                Object[] opObjects1 = inst1.getOpObjects(opIndex);
                if (!this.opObjectsDiffer(opObjects1, opObjects2 = inst2.getOpObjects(opIndex))) continue;
                opIndices.add(opIndex);
            }
            int[] diffOpIndices = new int[opIndices.size()];
            for (int index = 0; index < diffOpIndices.length; ++index) {
                diffOpIndices[index] = (Integer)opIndices.get(index);
            }
            return diffOpIndices;
        }
        if (codeUnit1 instanceof Data && codeUnit2 instanceof Data && this.isSameData(data1 = (Data)codeUnit1, data2 = (Data)codeUnit2)) {
            return new int[0];
        }
        return this.getAllIndices(numOperands);
    }

    private boolean opObjectsDiffer(Object[] opObjects1, Object[] opObjects2) {
        if (opObjects1.length != opObjects2.length) {
            return true;
        }
        for (int i = 0; i < opObjects1.length; ++i) {
            Object obj1 = opObjects1[i];
            Object obj2 = opObjects2[i];
            if (obj1.equals(obj2)) continue;
            if (obj1 instanceof Scalar && obj2 instanceof Scalar) {
                if (this.ignoreConstants) {
                    continue;
                }
            } else if (obj1 instanceof Address && obj2 instanceof Address) {
                if (this.ignoreConstants) {
                    continue;
                }
            } else if (obj1 instanceof Register && obj2 instanceof Register) {
                int len2;
                Register reg1 = (Register)obj1;
                Register reg2 = (Register)obj2;
                int len1 = reg1.getBitLength();
                if (len1 != (len2 = reg2.getBitLength())) {
                    return true;
                }
                if (this.ignoreRegisters || reg1.equals((Object)reg2)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean doesEntireOperandSetDiffer(CodeUnit codeUnit1, CodeUnit codeUnit2) {
        int otherNumOperands;
        if (!this.sameType(codeUnit1, codeUnit2)) {
            return true;
        }
        int numOperands = codeUnit1.getNumOperands();
        return numOperands != (otherNumOperands = codeUnit2.getNumOperands());
    }

    private boolean sameType(CodeUnit codeUnit1, CodeUnit codeUnit2) {
        if (codeUnit1 == null) {
            return codeUnit2 == null;
        }
        if (codeUnit2 == null) {
            return false;
        }
        return codeUnit1 instanceof Instruction && codeUnit2 instanceof Instruction || codeUnit1 instanceof Data && codeUnit2 instanceof Data;
    }

    private boolean isSameData(Data data1, Data data2) {
        DataType dt2;
        if (data1.getLength() != data2.getLength()) {
            return false;
        }
        DataType dt1 = data1.getDataType();
        if (!dt1.isEquivalent(dt2 = data2.getDataType())) {
            return false;
        }
        return dt1.getPathName().equals(dt2.getPathName());
    }

    private boolean sameBytes(CodeUnit cu1, CodeUnit cu2) {
        byte[] bytes2;
        byte[] bytes1;
        try {
            bytes1 = cu1.getBytes();
            bytes2 = cu2.getBytes();
        }
        catch (MemoryAccessException e) {
            return false;
        }
        if (bytes1.length != bytes2.length) {
            return false;
        }
        for (int i = 0; i < bytes1.length; ++i) {
            if (bytes1[i] == bytes2[i]) continue;
            return false;
        }
        return true;
    }

    public AddressSetView getUnmatchedCode(Duo.Side side) {
        return side == Duo.Side.LEFT ? this.unmatchedCode1 : this.unmatchedCode2;
    }

    public AddressSetView getDiffs(Duo.Side side) {
        AddressSet diffs = new AddressSet(this.getByteDiffs(side));
        diffs.add(this.getCodeUnitDiffs(side));
        return DiffUtility.getCodeUnitSet((AddressSetView)diffs, this.correlation.getProgram(side));
    }

    public AddressSetView getCodeUnitDiffs(Duo.Side side) {
        return new AddressSet((AddressSetView)(side == Duo.Side.LEFT ? this.codeUnitDiffs1 : this.codeUnitDiffs2));
    }

    public AddressSetView getByteDiffs(Duo.Side side) {
        if (this.ignoreByteDiffs) {
            return new AddressSet();
        }
        return new AddressSet((AddressSetView)(side == Duo.Side.LEFT ? this.byteDiffs1 : this.byteDiffs2));
    }

    public Address getMatchingAddress(Address address, boolean isListing1) {
        if (this.correlation == null) {
            return null;
        }
        if (isListing1) {
            return this.correlation.getAddress(Duo.Side.RIGHT, address);
        }
        return this.correlation.getAddress(Duo.Side.LEFT, address);
    }

    public void printFunctionComparisonDiffs() {
        StringBuffer buffer = new StringBuffer();
        this.outputAddressSet(buffer, "Unmatched Diffs 1", this.unmatchedCode1);
        this.outputAddressSet(buffer, "Unmatched Diffs 2", this.unmatchedCode2);
        this.outputAddressSet(buffer, "Byte Diffs 1", this.byteDiffs1);
        this.outputAddressSet(buffer, "Byte Diffs 2", this.byteDiffs2);
        this.outputAddressSet(buffer, "Code Diffs 1", this.codeUnitDiffs1);
        this.outputAddressSet(buffer, "Code Diffs 2", this.codeUnitDiffs2);
        Msg.info((Object)this, (Object)buffer.toString());
    }

    private void outputAddressSet(StringBuffer buffer, String title, AddressSet addressSet) {
        buffer.append(title + ":\n");
        int i = 0;
        for (AddressRange addressRange : addressSet) {
            buffer.append(addressRange.toString());
            if (++i % 10 != 0) continue;
            buffer.append("\n");
        }
        buffer.append("\n");
    }

    public boolean isIgnoringByteDiffs() {
        return this.ignoreByteDiffs;
    }

    public void setIgnoreByteDiffs(boolean ignore) {
        this.ignoreByteDiffs = ignore;
        this.notifyListeners();
    }

    public boolean isIgnoringConstants() {
        return this.ignoreConstants;
    }

    public void setIgnoreConstants(boolean ignore) {
        this.ignoreConstants = ignore;
        if (this.correlation != null) {
            this.recomputeCodeUnitDiffs();
        }
        this.notifyListeners();
    }

    public boolean isIgnoringRegisters() {
        return this.ignoreRegisters;
    }

    public void setIgnoreRegisters(boolean ignore) {
        this.ignoreRegisters = ignore;
        if (this.correlation != null) {
            this.recomputeCodeUnitDiffs();
        }
        this.notifyListeners();
    }

    private void notifyListeners() {
        for (ListingDiffChangeListener listener : this.listeners) {
            listener.listingDiffChanged();
        }
    }

    public void addListingDiffChangeListener(ListingDiffChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListingDiffChangeListener(ListingDiffChangeListener listener) {
        this.listeners.remove(listener);
    }

    public CodeUnit getMatchingCodeUnit(CodeUnit codeUnit, Duo.Side side) {
        if (this.correlation == null) {
            return null;
        }
        Duo.Side otherSide = side.otherSide();
        Address minAddress = codeUnit.getMinAddress();
        Program otherSideProgram = this.correlation.getProgram(otherSide);
        Address otherAddress = this.correlation.getAddress(otherSide, minAddress);
        if (otherAddress != null) {
            return otherSideProgram.getListing().getCodeUnitAt(otherAddress);
        }
        return null;
    }

    private int[] getAllIndices(int number) {
        if (number < 0) {
            throw new IllegalArgumentException();
        }
        int[] numbers = new int[number];
        for (int i = 0; i < number; ++i) {
            numbers[i] = i;
        }
        return numbers;
    }
}

