/*
 * Decompiled with CFR 0.152.
 */
package ghidra.jython;

import ghidra.GhidraApplicationLayout;
import ghidra.GhidraLaunchable;
import ghidra.framework.Application;
import ghidra.framework.ApplicationConfiguration;
import ghidra.framework.HeadlessGhidraApplicationConfiguration;
import ghidra.jython.JythonUtils;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import java.io.IOException;
import org.python.util.jython;
import utility.application.ApplicationLayout;

public class JythonRun
implements GhidraLaunchable {
    public void launch(GhidraApplicationLayout layout, String[] args) {
        HeadlessGhidraApplicationConfiguration configuration = new HeadlessGhidraApplicationConfiguration();
        Application.initializeApplication((ApplicationLayout)layout, (ApplicationConfiguration)configuration);
        try {
            JythonUtils.setupJythonHomeDir();
        }
        catch (IOException e) {
            Msg.showError(JythonRun.class, null, (String)"Jython home directory", (Object)e.getMessage());
            System.exit(1);
        }
        try {
            JythonUtils.setupJythonCacheDir(configuration.getTaskMonitor());
        }
        catch (IOException e) {
            Msg.showError(JythonRun.class, null, (String)"Jython cache directory", (Object)e.getMessage());
            System.exit(1);
        }
        catch (CancelledException e) {
            Msg.showError(JythonRun.class, null, (String)"Operation cancelled", (Object)e.getMessage());
            System.exit(1);
        }
        jython.main((String[])args);
    }
}

