/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.commands;

import java.util.Optional;
import java.util.Set;
import org.kordamp.jarviz.bundle.RB;
import org.kordamp.jarviz.core.Format;
import org.kordamp.jarviz.core.internal.AbstractCommand;
import org.kordamp.jarviz.core.internal.AbstractConfiguration;
import org.kordamp.jarviz.core.processors.JarProcessor;
import org.kordamp.jarviz.core.processors.ServicesShowJarProcessor;
import org.kordamp.jarviz.core.resolvers.JarFileResolver;
import org.kordamp.jarviz.reporting.Node;

public class ServicesShowCommand
extends AbstractCommand<Configuration> {
    public static Configuration config() {
        return new Configuration();
    }

    @Override
    public int execute(Configuration configuration) {
        JarFileResolver jarFileResolver = this.createJarFileResolver(configuration);
        ServicesShowJarProcessor processor = new ServicesShowJarProcessor(jarFileResolver);
        processor.setServiceName(configuration.getServiceName());
        Set<JarProcessor.JarFileResult<Optional<Set<String>>>> results = processor.getResult();
        if (results.isEmpty()) {
            return 1;
        }
        this.output(configuration, results);
        this.report(configuration, results);
        return 0;
    }

    private void output(Configuration configuration, Set<JarProcessor.JarFileResult<Optional<Set<String>>>> results) {
        Node root = this.createRootNode();
        Format outputFormat = configuration.getOutputFormat();
        for (JarProcessor.JarFileResult<Optional<Set<String>>> result : results) {
            if (null == outputFormat) {
                this.output(configuration, result);
                continue;
            }
            this.buildReport(configuration, outputFormat, root, result);
        }
        if (null != outputFormat) {
            this.writeOutput(configuration, this.resolveFormatter(outputFormat).write(root));
        }
    }

    private void output(Configuration configuration, JarProcessor.JarFileResult<Optional<Set<String>>> result) {
        if (result.getResult().isPresent()) {
            configuration.getOut().println(this.$$("output.subject", result.getJarFileName()));
            configuration.getOut().println(this.$$("services.show.service", configuration.getServiceName()));
            result.getResult().get().forEach(configuration.getOut()::println);
        }
    }

    private void report(Configuration configuration, Set<JarProcessor.JarFileResult<Optional<Set<String>>>> results) {
        if (null == configuration.getReportPath()) {
            return;
        }
        for (Format format : configuration.getReportFormats()) {
            Node root = this.createRootNode();
            for (JarProcessor.JarFileResult<Optional<Set<String>>> result : results) {
                if (!result.getResult().isPresent()) continue;
                this.buildReport(configuration, format, root, result);
            }
            this.writeReport(configuration, this.resolveFormatter(format).write(root), format);
        }
    }

    private void buildReport(Configuration configuration, Format format, Node root, JarProcessor.JarFileResult<Optional<Set<String>>> result) {
        this.appendSubject(root, result.getJarPath(), "services list", resultNode -> {
            Node implementations = resultNode.node(RB.$("report.key.service", new Object[0])).value(configuration.getServiceName()).end().array(RB.$("report.key.implementations", new Object[0]));
            for (String service : (Set)((Optional)result.getResult()).get()) {
                if (format != Format.XML) {
                    implementations.node(service);
                    continue;
                }
                implementations.node(RB.$("report.key.implementation", new Object[0])).value(service).end();
            }
        });
    }

    public static class Configuration
    extends AbstractConfiguration<Configuration> {
        private String serviceName;

        public String getServiceName() {
            return this.serviceName;
        }

        public Configuration withServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }
    }
}

