/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.reporting;

import org.kordamp.jarviz.reporting.Formatter;
import org.kordamp.jarviz.reporting.Node;
import org.kordamp.jarviz.reporting.Report;
import org.kordamp.jarviz.util.StringUtils;

public class YamlFormatter
extends Formatter {
    public static final YamlFormatter INSTANCE = new YamlFormatter();
    private static final String COLON = ":";
    private static final String ITEM = "- ";
    private static final String MULTILINE = "|";

    private YamlFormatter() {
    }

    @Override
    public String write(Node node) {
        Report report = new Report();
        for (Node child : node.getChildren()) {
            this.append(report, child);
        }
        return report.toString();
    }

    @Override
    protected void append(Report report, Node node) {
        if (StringUtils.isBlank(node.getValue()) && node.getChildren().isEmpty()) {
            report.indent(this.indentationFor(node)).append(node.isArrayElement() ? (node.isFirstChild() ? ITEM : "") : "").append(this.element(node.getName()));
            return;
        }
        if (!node.isCollapsable()) {
            report.indent(this.indentationFor(node)).append(node.isArrayElement() ? (node.isFirstChild() ? ITEM : "") : "").append(this.element(node.getName())).append(COLON);
        }
        if (StringUtils.isNotBlank(node.getValue())) {
            report.append((String)(node.isCollapsable() ? "  ".repeat(this.indentationFor(node)) + ITEM : " ")).append(this.formatValue(node));
            if (node.isCollapsable()) {
                report.newLine();
            }
        } else if (!node.getChildren().isEmpty()) {
            if (!node.isCollapsable()) {
                report.newLine();
            }
            for (Node child : node.getChildren()) {
                this.append(report, child);
            }
            if (!node.isCollapsable()) {
                report.newLine();
            }
        }
        if (!node.isCollapsable()) {
            report.newLine();
        }
    }

    @Override
    protected int indentationFor(Node node, int offset) {
        if (node.getParent().isPresent()) {
            offset += node.getParent().get().isCollapsable() && node.isArrayElement() && node.isFirstChild() ? -1 : 0;
        }
        return super.indentationFor(node, offset);
    }

    private String element(String str) {
        return str;
    }

    @Override
    protected int indentAdjustment() {
        return 1;
    }

    @Override
    protected String formatValue(Node node) {
        String value = node.getValue();
        if (!value.contains(System.lineSeparator())) {
            return this.formatValue(value);
        }
        StringBuilder b = new StringBuilder().append(MULTILINE).append(System.lineSeparator());
        String[] lines = value.split("\\r");
        String indentation = "  ".repeat(this.indentationFor(node, 1));
        for (String line : lines) {
            b.append(indentation).append(line.trim()).append(System.lineSeparator());
        }
        return b.toString();
    }
}

