/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ResourceBundle;

public class JarvizVersion {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(JarvizVersion.class.getName());
    private static final String JRELEASER_VERSION = BUNDLE.getString("jarviz_version");
    private static final String BUILD_DATE = BUNDLE.getString("build_date");
    private static final String BUILD_TIME = BUNDLE.getString("build_time");
    private static final String BUILD_REVISION = BUNDLE.getString("build_revision");
    private static final String SEPARATOR = "------------------------------------------------------------%n";
    private static final String JARVIZ_VERSION_FORMATTED = "jarviz %s%n";

    public static String getPlainVersion() {
        return JRELEASER_VERSION;
    }

    public static void banner(PrintStream out) {
        JarvizVersion.banner(out, true);
    }

    public static void banner(PrintStream out, boolean full) {
        JarvizVersion.banner(new PrintWriter(out, true, StandardCharsets.UTF_8), full);
    }

    public static void banner(PrintWriter out) {
        JarvizVersion.banner(out, true);
    }

    public static void banner(PrintWriter out, boolean full) {
        if (full) {
            out.printf(SEPARATOR, new Object[0]);
            out.printf(JARVIZ_VERSION_FORMATTED, JRELEASER_VERSION);
            String jvm = System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + " " + System.getProperty("java.vm.version") + ")";
            out.printf(SEPARATOR, new Object[0]);
            out.printf("Build time:   %s %s%n", BUILD_DATE, BUILD_TIME);
            out.printf("Revision:     %s%n", BUILD_REVISION);
            out.printf("JVM:          %s%n", jvm);
            out.printf(SEPARATOR, new Object[0]);
        } else {
            out.printf(JARVIZ_VERSION_FORMATTED, JRELEASER_VERSION);
        }
    }
}

