/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.sign;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Signing;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.api.signing.Keyring;
import org.jreleaser.model.api.signing.SigningException;
import org.jreleaser.model.internal.catalog.sbom.SbomCataloger;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.signing.Signing;
import org.jreleaser.model.internal.util.Artifacts;
import org.jreleaser.model.spi.catalog.sbom.SbomCatalogerProcessorHelper;
import org.jreleaser.sdk.signing.GpgCommandSigner;
import org.jreleaser.sdk.signing.SigningUtils;
import org.jreleaser.sdk.tool.Cosign;
import org.jreleaser.sdk.tool.ToolException;
import org.jreleaser.util.Algorithm;
import org.jreleaser.util.StringUtils;

public final class Signer {
    private Signer() {
    }

    public static void sign(org.jreleaser.model.internal.JReleaserContext context) throws SigningException {
        context.getLogger().info(RB.$((String)"signing.header", (Object[])new Object[0]));
        context.getLogger().increaseIndent();
        context.getLogger().setPrefix("sign");
        if (!context.getModel().getSigning().isEnabled()) {
            context.getLogger().info(RB.$((String)"signing.not.enabled", (Object[])new Object[0]));
            context.getLogger().restorePrefix();
            context.getLogger().decreaseIndent();
            return;
        }
        try {
            if (context.getModel().getSigning().getMode() == Signing.Mode.COMMAND) {
                Signer.cmdSign(context);
            } else if (context.getModel().getSigning().getMode() == Signing.Mode.COSIGN) {
                Signer.cosignSign(context);
            } else {
                Signer.bcSign(context);
            }
        }
        finally {
            context.getLogger().restorePrefix();
            context.getLogger().decreaseIndent();
        }
    }

    private static void cmdSign(org.jreleaser.model.internal.JReleaserContext context) throws SigningException {
        List<Object> files = Signer.collectArtifacts(context, pair -> SigningUtils.isValid((JReleaserContext)context.asImmutable(), null, (SigningUtils.FilePair)pair));
        if (files.isEmpty()) {
            context.getLogger().info(RB.$((String)"signing.no.match", (Object[])new Object[0]));
            return;
        }
        if ((files = files.stream().filter(SigningUtils.FilePair::isInvalid).collect(Collectors.toList())).isEmpty()) {
            context.getLogger().info(RB.$((String)"signing.up.to.date", (Object[])new Object[0]));
            return;
        }
        Signer.sign(context, files);
        if (context.getModel().getSigning().isVerify()) {
            Signer.verify(context, files);
        }
    }

    private static void cosignSign(org.jreleaser.model.internal.JReleaserContext context) throws SigningException {
        Path thePublicKeyFile;
        List<Object> files;
        Signing signing = context.getModel().getSigning();
        Cosign cosign = new Cosign(context.asImmutable(), signing.getCosign().getVersion());
        try {
            if (!cosign.setup()) {
                context.getLogger().warn(RB.$((String)"tool_unavailable", (Object[])new Object[]{"cosign"}));
                return;
            }
        }
        catch (ToolException e) {
            throw new SigningException(e.getMessage(), (Throwable)e);
        }
        String privateKey = signing.getCosign().getPrivateKeyFile();
        String publicKey = signing.getCosign().getPublicKeyFile();
        Path privateKeyFile = StringUtils.isNotBlank((String)privateKey) ? context.getBasedir().resolve(privateKey) : null;
        Path publicKeyFile = StringUtils.isNotBlank((String)publicKey) ? context.getBasedir().resolve(publicKey) : null;
        String password = signing.getPassphrase();
        boolean forceSign = false;
        if (null == privateKeyFile) {
            privateKeyFile = signing.getCosign().getResolvedPrivateKeyFilePath(context);
            publicKeyFile = privateKeyFile.resolveSibling("cosign.pub");
            if (!Files.exists(privateKeyFile, new LinkOption[0])) {
                privateKeyFile = cosign.generateKeyPair(password);
                forceSign = true;
            }
        }
        if ((files = Signer.collectArtifacts(context, forceSign, arg_0 -> Signer.lambda$cosignSign$1(context, cosign, thePublicKeyFile = publicKeyFile, arg_0))).isEmpty()) {
            context.getLogger().info(RB.$((String)"signing.no.match", (Object[])new Object[0]));
            return;
        }
        if ((files = files.stream().filter(SigningUtils.FilePair::isInvalid).collect(Collectors.toList())).isEmpty()) {
            context.getLogger().info(RB.$((String)"signing.up.to.date", (Object[])new Object[0]));
            return;
        }
        if (!cosign.checkPassword(privateKeyFile, password)) {
            context.getLogger().warn(RB.$((String)"WARN_cosign_password_does_not_match", (Object[])new Object[]{"cosign"}));
            return;
        }
        Signer.sign(context, files, cosign, privateKeyFile, password);
        Signer.verify(context, files, cosign, publicKeyFile);
    }

    private static void bcSign(org.jreleaser.model.internal.JReleaserContext context) throws SigningException {
        Keyring keyring = context.createKeyring();
        List<Object> files = Signer.collectArtifacts(context, pair -> SigningUtils.isValid((JReleaserContext)context.asImmutable(), (Keyring)keyring, (SigningUtils.FilePair)pair));
        if (files.isEmpty()) {
            context.getLogger().info(RB.$((String)"signing.no.match", (Object[])new Object[0]));
            return;
        }
        if ((files = files.stream().filter(SigningUtils.FilePair::isInvalid).collect(Collectors.toList())).isEmpty()) {
            context.getLogger().info(RB.$((String)"signing.up.to.date", (Object[])new Object[0]));
            return;
        }
        Signer.sign(context, keyring, files);
        if (context.getModel().getSigning().isVerify()) {
            Signer.verify(context, keyring, files);
        }
    }

    private static void verify(org.jreleaser.model.internal.JReleaserContext context, Keyring keyring, List<SigningUtils.FilePair> files) throws SigningException {
        if (null == keyring) {
            Signer.verify(context, files);
            return;
        }
        context.getLogger().debug(RB.$((String)"signing.verify.signatures", (Object[])new Object[0]), new Object[]{files.size()});
        for (SigningUtils.FilePair pair : files) {
            pair.setValid(Signer.verify(context, keyring, pair));
            if (pair.isValid()) continue;
            throw new SigningException(RB.$((String)"ERROR_signing_verify_file", (Object[])new Object[]{context.relativizeToBasedir(pair.getInputFile()), context.relativizeToBasedir(pair.getSignatureFile())}));
        }
    }

    private static void verify(org.jreleaser.model.internal.JReleaserContext context, List<SigningUtils.FilePair> files) throws SigningException {
        context.getLogger().debug(RB.$((String)"signing.verify.signatures", (Object[])new Object[0]), new Object[]{files.size()});
        for (SigningUtils.FilePair pair : files) {
            pair.setValid(SigningUtils.verify((JReleaserContext)context.asImmutable(), (SigningUtils.FilePair)pair));
            if (pair.isValid()) continue;
            throw new SigningException(RB.$((String)"ERROR_signing_verify_file", (Object[])new Object[]{context.relativizeToBasedir(pair.getInputFile()), context.relativizeToBasedir(pair.getSignatureFile())}));
        }
    }

    private static boolean verify(org.jreleaser.model.internal.JReleaserContext context, Keyring keyring, SigningUtils.FilePair filePair) throws SigningException {
        context.getLogger().setPrefix("verify");
        context.getLogger().debug("{}", new Object[]{context.relativizeToBasedir(filePair.getSignatureFile())});
        try {
            boolean bl;
            block20: {
                InputStream sigInputStream = PGPUtil.getDecoderStream((InputStream)new BufferedInputStream(Files.newInputStream(filePair.getSignatureFile(), new OpenOption[0])));
                try {
                    PGPObjectFactory pgpObjFactory = new PGPObjectFactory(sigInputStream, keyring.getKeyFingerPrintCalculator());
                    Iterable pgpSigList = null;
                    Object obj = pgpObjFactory.nextObject();
                    if (obj instanceof PGPCompressedData) {
                        PGPCompressedData c1 = (PGPCompressedData)obj;
                        pgpObjFactory = new PGPObjectFactory(c1.getDataStream(), keyring.getKeyFingerPrintCalculator());
                        pgpSigList = (Iterable)pgpObjFactory.nextObject();
                    } else {
                        pgpSigList = (Iterable)obj;
                    }
                    PGPSignature sig = (PGPSignature)pgpSigList.iterator().next();
                    try (BufferedInputStream fileInputStream = new BufferedInputStream(Files.newInputStream(filePair.getInputFile(), new OpenOption[0]));){
                        int ch;
                        PGPPublicKey pubKey = keyring.readPublicKey();
                        sig.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pubKey);
                        while ((ch = ((InputStream)fileInputStream).read()) >= 0) {
                            sig.update((byte)ch);
                        }
                    }
                    bl = sig.verify();
                    if (sigInputStream == null) break block20;
                }
                catch (Throwable throwable) {
                    try {
                        if (sigInputStream != null) {
                            try {
                                sigInputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | PGPException e) {
                        throw new SigningException(RB.$((String)"ERROR_signing_verify_signature", (Object[])new Object[]{context.relativizeToBasedir(filePair.getInputFile())}), e);
                    }
                }
                sigInputStream.close();
            }
            return bl;
        }
        finally {
            context.getLogger().restorePrefix();
        }
    }

    private static void sign(org.jreleaser.model.internal.JReleaserContext context, List<SigningUtils.FilePair> files, Cosign cosign, Path privateKeyFile, String password) throws SigningException {
        Path signaturesDirectory = context.getSignaturesDirectory();
        try {
            Files.createDirectories(signaturesDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new SigningException(RB.$((String)"ERROR_signing_create_signature_dir", (Object[])new Object[0]), (Throwable)e);
        }
        context.getLogger().debug(RB.$((String)"signing.signing.files", (Object[])new Object[0]), new Object[]{files.size(), context.relativizeToBasedir(signaturesDirectory)});
        for (SigningUtils.FilePair pair : files) {
            cosign.signBlob(privateKeyFile, password, pair.getInputFile(), signaturesDirectory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verify(org.jreleaser.model.internal.JReleaserContext context, List<SigningUtils.FilePair> files, Cosign cosign, Path publicKeyFile) throws SigningException {
        context.getLogger().debug(RB.$((String)"signing.verify.signatures", (Object[])new Object[0]), new Object[]{files.size()});
        context.getLogger().setPrefix("verify");
        try {
            for (SigningUtils.FilePair pair : files) {
                cosign.verifyBlob(publicKeyFile, pair.getSignatureFile(), pair.getInputFile());
                pair.setValid(true);
                if (pair.isValid()) continue;
                throw new SigningException(RB.$((String)"ERROR_signing_verify_file", (Object[])new Object[]{context.relativizeToBasedir(pair.getInputFile()), context.relativizeToBasedir(pair.getSignatureFile())}));
            }
        }
        finally {
            context.getLogger().restorePrefix();
        }
    }

    private static void sign(org.jreleaser.model.internal.JReleaserContext context, List<SigningUtils.FilePair> files) throws SigningException {
        Path signaturesDirectory = context.getSignaturesDirectory();
        try {
            Files.createDirectories(signaturesDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new SigningException(RB.$((String)"ERROR_signing_create_signature_dir", (Object[])new Object[0]), (Throwable)e);
        }
        context.getLogger().debug(RB.$((String)"signing.signing.files", (Object[])new Object[0]), new Object[]{files.size(), context.relativizeToBasedir(signaturesDirectory)});
        GpgCommandSigner commandSigner = SigningUtils.initCommandSigner((JReleaserContext)context.asImmutable());
        for (SigningUtils.FilePair pair : files) {
            SigningUtils.sign((JReleaserContext)context.asImmutable(), (GpgCommandSigner)commandSigner, (Path)pair.getInputFile(), (Path)pair.getSignatureFile());
        }
    }

    private static void sign(org.jreleaser.model.internal.JReleaserContext context, Keyring keyring, List<SigningUtils.FilePair> files) throws SigningException {
        Path signaturesDirectory = context.getSignaturesDirectory();
        try {
            Files.createDirectories(signaturesDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new SigningException(RB.$((String)"ERROR_signing_create_signature_dir", (Object[])new Object[0]), (Throwable)e);
        }
        context.getLogger().debug(RB.$((String)"signing.signing.files", (Object[])new Object[0]), new Object[]{files.size(), context.relativizeToBasedir(signaturesDirectory)});
        PGPSignatureGenerator signatureGenerator = SigningUtils.initSignatureGenerator((JReleaserContext)context.asImmutable(), (Keyring)keyring);
        for (SigningUtils.FilePair pair : files) {
            SigningUtils.sign((JReleaserContext)context.asImmutable(), (PGPSignatureGenerator)signatureGenerator, (Path)pair.getInputFile(), (Path)pair.getSignatureFile());
        }
    }

    private static List<SigningUtils.FilePair> collectArtifacts(org.jreleaser.model.internal.JReleaserContext context, Predicate<SigningUtils.FilePair> validator) {
        return Signer.collectArtifacts(context, false, validator);
    }

    private static List<SigningUtils.FilePair> collectArtifacts(org.jreleaser.model.internal.JReleaserContext context, boolean forceSign, Predicate<SigningUtils.FilePair> validator) {
        SigningUtils.FilePair pair;
        Path output;
        ArrayList<SigningUtils.FilePair> files = new ArrayList<SigningUtils.FilePair>();
        Signing signing = context.getModel().getSigning();
        Path signaturesDirectory = context.getSignaturesDirectory();
        String extension = ".sig";
        if (signing.getMode() != Signing.Mode.COSIGN) {
            String string = extension = signing.isArmored() ? ".asc" : ".sig";
        }
        if (signing.isFiles()) {
            for (Artifact artifact : Artifacts.resolveFiles((org.jreleaser.model.internal.JReleaserContext)context)) {
                if (!artifact.isActiveAndSelected() || artifact.extraPropertyIsTrue("skipSigning") || artifact.isOptional(context) && !artifact.resolvedPathExists()) continue;
                Path input = artifact.getEffectivePath(context);
                output = signaturesDirectory.resolve(input.getFileName().toString().concat(extension));
                pair = new SigningUtils.FilePair(input, output);
                if (!forceSign) {
                    pair.setValid(validator.test(pair));
                }
                files.add(pair);
            }
        }
        if (signing.isArtifacts()) {
            for (Object distribution : context.getModel().getActiveDistributions()) {
                if (distribution.extraPropertyIsTrue("skipSigning")) continue;
                for (Object artifact : distribution.getArtifacts()) {
                    if (!artifact.isActiveAndSelected() || artifact.extraPropertyIsTrue("skipSigning")) continue;
                    Path input = artifact.getEffectivePath(context, (Distribution)distribution);
                    if (artifact.isOptional(context) && !artifact.resolvedPathExists()) continue;
                    Path output2 = signaturesDirectory.resolve(input.getFileName().toString().concat(extension));
                    SigningUtils.FilePair pair2 = new SigningUtils.FilePair(input, output2);
                    if (!forceSign) {
                        pair2.setValid(validator.test(pair2));
                    }
                    files.add(pair2);
                }
            }
        }
        if (signing.isCatalogs()) {
            List catalogers = context.getModel().getCatalog().getSbom().findAllActiveSbomCatalogers();
            for (SbomCataloger cataloger : catalogers) {
                if (!cataloger.getPack().isEnabled()) continue;
                for (Artifact artifact : SbomCatalogerProcessorHelper.resolveArtifacts((org.jreleaser.model.internal.JReleaserContext)context, (SbomCataloger)cataloger)) {
                    Path input = artifact.getEffectivePath(context);
                    Path output3 = signaturesDirectory.resolve(input.getFileName().toString().concat(extension));
                    SigningUtils.FilePair pair3 = new SigningUtils.FilePair(input, output3);
                    if (!forceSign) {
                        pair3.setValid(validator.test(pair3));
                    }
                    files.add(pair3);
                }
            }
        }
        if (signing.isChecksums()) {
            for (Algorithm algorithm : context.getModel().getChecksum().getAlgorithms()) {
                Path checksums = context.getChecksumsDirectory().resolve(context.getModel().getChecksum().getResolvedName(context, algorithm));
                if (!Files.exists(checksums, new LinkOption[0])) continue;
                output = signaturesDirectory.resolve(checksums.getFileName().toString().concat(extension));
                pair = new SigningUtils.FilePair(checksums, output);
                if (!forceSign) {
                    pair.setValid(validator.test(pair));
                }
                files.add(pair);
            }
        }
        return files;
    }

    private static boolean isValid(org.jreleaser.model.internal.JReleaserContext context, Cosign cosign, Path publicKeyFile, SigningUtils.FilePair pair) {
        if (Files.notExists(pair.getSignatureFile(), new LinkOption[0])) {
            context.getLogger().debug(RB.$((String)"signing.signature.not.exist", (Object[])new Object[0]), new Object[]{context.relativizeToBasedir(pair.getSignatureFile())});
            return false;
        }
        if (pair.getInputFile().toFile().lastModified() > pair.getSignatureFile().toFile().lastModified()) {
            context.getLogger().debug(RB.$((String)"signing.file.newer", (Object[])new Object[0]), new Object[]{context.relativizeToBasedir(pair.getInputFile()), context.relativizeToBasedir(pair.getSignatureFile())});
            return false;
        }
        try {
            cosign.verifyBlob(publicKeyFile, pair.getSignatureFile(), pair.getInputFile());
            return true;
        }
        catch (SigningException e) {
            return false;
        }
    }

    private static /* synthetic */ boolean lambda$cosignSign$1(org.jreleaser.model.internal.JReleaserContext context, Cosign cosign, Path thePublicKeyFile, SigningUtils.FilePair pair) {
        return Signer.isValid(context, cosign, thePublicKeyFile, pair);
    }
}

