/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.api.packagers;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.api.common.Activatable;
import org.jreleaser.model.api.common.Domain;
import org.jreleaser.model.api.common.ExtraProperties;
import org.jreleaser.util.StringUtils;

public interface JibConfiguration
extends Domain,
ExtraProperties,
Activatable {
    public static final String TYPE = "jib";

    public String getTemplateDirectory();

    public List<String> getSkipTemplates();

    public String getBaseImage();

    public String getCreationTime();

    public Format getFormat();

    public Map<String, String> getEnvironment();

    public Map<String, String> getLabels();

    public Set<String> getImageNames();

    public Set<String> getVolumes();

    public Set<String> getExposedPorts();

    public String getUser();

    public String getWorkingDirectory();

    public Set<? extends Registry> getRegistries();

    public static enum Format {
        DOCKER("Docker"),
        OCI("OCI");

        private final String alias;

        private Format(String alias) {
            this.alias = alias;
        }

        public String formatted() {
            return this.alias;
        }

        public static Format of(String str) {
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            return Format.valueOf(str.toUpperCase(Locale.ENGLISH).trim().replace(".", "_"));
        }
    }

    public static interface Registry
    extends Domain,
    Comparable<Registry> {
        public String getName();

        public String getServer();

        public String getUsername();

        public String getToUsername();

        public String getFromUsername();

        public String getPassword();

        public String getToPassword();

        public String getFromPassword();
    }
}

