/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.hooks;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.Active;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.Matrix;
import org.jreleaser.model.internal.common.MatrixAware;
import org.jreleaser.model.internal.hooks.CommandHooks;
import org.jreleaser.model.internal.hooks.JbangHooks;
import org.jreleaser.model.internal.hooks.ScriptHooks;

public final class Hooks
extends AbstractActivatable<Hooks>
implements Domain,
MatrixAware {
    private static final long serialVersionUID = -2685043052339525443L;
    private final Map<String, String> environment = new LinkedHashMap<String, String>();
    private final CommandHooks command = new CommandHooks();
    private final ScriptHooks script = new ScriptHooks();
    private final JbangHooks jbang = new JbangHooks();
    private final Matrix matrix = new Matrix();
    private String condition;
    private Boolean applyDefaultMatrix;
    @JsonIgnore
    private final org.jreleaser.model.api.hooks.Hooks immutable = new org.jreleaser.model.api.hooks.Hooks(){
        private static final long serialVersionUID = -2830918236394905261L;

        public org.jreleaser.model.api.hooks.CommandHooks getCommand() {
            return Hooks.this.command.asImmutable();
        }

        public org.jreleaser.model.api.hooks.ScriptHooks getScript() {
            return Hooks.this.script.asImmutable();
        }

        public org.jreleaser.model.api.hooks.JbangHooks getJbang() {
            return Hooks.this.jbang.asImmutable();
        }

        public String getCondition() {
            return Hooks.this.getCondition();
        }

        public Map<String, String> getEnvironment() {
            return Collections.unmodifiableMap(Hooks.this.getEnvironment());
        }

        public boolean isApplyDefaultMatrix() {
            return Hooks.this.isApplyDefaultMatrix();
        }

        public org.jreleaser.model.api.common.Matrix getMatrix() {
            return Hooks.this.matrix.asImmutable();
        }

        public Active getActive() {
            return Hooks.this.getActive();
        }

        public boolean isEnabled() {
            return Hooks.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Hooks.this.asMap(full));
        }
    };

    public Hooks() {
        this.enabledSet(true);
    }

    public org.jreleaser.model.api.hooks.Hooks asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Hooks source) {
        super.merge(source);
        this.condition = this.merge(this.condition, source.condition);
        this.setCommand(source.command);
        this.setScript(source.script);
        this.setJbang(source.jbang);
        this.setEnvironment(this.merge(this.environment, source.getEnvironment()));
        this.setMatrix(source.matrix);
    }

    @Override
    public boolean isSet() {
        return super.isSet() || this.command.isSet() || this.script.isSet() || this.script.isSet();
    }

    public CommandHooks getCommand() {
        return this.command;
    }

    public void setCommand(CommandHooks command) {
        this.command.merge(command);
    }

    public ScriptHooks getScript() {
        return this.script;
    }

    public void setScript(ScriptHooks script) {
        this.script.merge(script);
    }

    public JbangHooks getJbang() {
        return this.jbang;
    }

    public void setJbang(JbangHooks jbang) {
        this.jbang.merge(jbang);
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment.clear();
        this.environment.putAll(environment);
    }

    @Override
    public boolean isApplyDefaultMatrixSet() {
        return null != this.applyDefaultMatrix;
    }

    @Override
    public boolean isApplyDefaultMatrix() {
        return null != this.applyDefaultMatrix && this.applyDefaultMatrix != false;
    }

    @Override
    public void setApplyDefaultMatrix(Boolean applyDefaultMatrix) {
        this.applyDefaultMatrix = applyDefaultMatrix;
    }

    @Override
    public Matrix getMatrix() {
        return this.matrix;
    }

    @Override
    public void setMatrix(Matrix matrix) {
        this.matrix.merge(matrix);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("active", this.getActive());
        map.put("condition", this.condition);
        map.put("environment", this.environment);
        this.matrix.asMap(map);
        map.put("command", this.command.asMap(full));
        map.put("jbang", this.jbang.asMap(full));
        map.put("script", this.script.asMap(full));
        return map;
    }
}

