/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.discord;

import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.WebhookAnnouncer;
import org.jreleaser.model.spi.announce.AnnounceException;
import org.jreleaser.model.spi.announce.Announcer;
import org.jreleaser.sdk.webhooks.WebhooksAnnouncer;

public class DiscordAnnouncer
implements Announcer<org.jreleaser.model.api.announce.DiscordAnnouncer> {
    private final JReleaserContext context;
    private final org.jreleaser.model.internal.announce.DiscordAnnouncer discord;

    public DiscordAnnouncer(JReleaserContext context) {
        this.context = context;
        this.discord = context.getModel().getAnnounce().getDiscord();
    }

    public org.jreleaser.model.api.announce.DiscordAnnouncer getAnnouncer() {
        return this.discord.asImmutable();
    }

    public String getName() {
        return "discord";
    }

    public boolean isEnabled() {
        return this.discord.isEnabled();
    }

    public void announce() throws AnnounceException {
        this.context.getLogger().setPrefix("webhook." + this.getName());
        try {
            WebhooksAnnouncer.announce((JReleaserContext)this.context, (WebhookAnnouncer)this.discord.asWebhookAnnouncer(), (boolean)false);
        }
        catch (AnnounceException x) {
            this.context.getLogger().warn(x.getMessage().trim());
        }
        finally {
            this.context.getLogger().restorePrefix();
        }
    }
}

