/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.Announce;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.validation.announce.ArticleAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.BlueskyAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.DiscordAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.DiscourseAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.DiscussionsAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.GitterAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.GoogleChatAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.HttpAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.LinkedinAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.MastodonAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.MattermostAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.OpenCollectiveAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.RedditAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.SdkmanAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.SlackAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.SmtpAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.TeamsAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.TelegramAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.TwitterAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.WebhooksAnnouncerValidator;
import org.jreleaser.model.internal.validation.announce.ZulipAnnouncerValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;

public final class AnnouncersValidator {
    private AnnouncersValidator() {
    }

    public static void validateAnnouncers(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Announce announce = context.getModel().getAnnounce();
        context.getLogger().debug("announce");
        if (!mode.validateConfig() && !mode.validateAnnounce()) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        Errors incoming = new Errors();
        ArticleAnnouncerValidator.validateArticle(context, announce.getArticle(), incoming);
        Validator.mergeErrors(context, errors, incoming, announce.getArticle());
        BlueskyAnnouncerValidator.validateBluesky(context, announce.getBluesky(), incoming);
        Validator.mergeErrors(context, errors, incoming, announce.getBluesky());
        DiscussionsAnnouncerValidator.validateDiscussions(context, announce.getDiscussions(), incoming);
        Validator.mergeErrors(context, errors, incoming, announce.getDiscussions());
        DiscordAnnouncerValidator.validateDiscord(context, announce.getDiscord(), incoming);
        Validator.mergeErrors(context, errors, incoming, announce.getDiscord());
        DiscourseAnnouncerValidator.validateDiscourse(context, announce.getDiscourse(), incoming);
        Validator.mergeErrors(context, errors, incoming, announce.getDiscourse());
        GitterAnnouncerValidator.validateGitter(context, announce.getGitter(), incoming);
        Validator.mergeErrors(context, errors, incoming, announce.getGitter());
        GoogleChatAnnouncerValidator.validateGoogleChat(context, announce.getGoogleChat(), incoming);
        Validator.mergeErrors(context, errors, incoming, announce.getGoogleChat());
        LinkedinAnnouncerValidator.validateLinkedin(context, announce.getLinkedin(), incoming);
        Validator.mergeErrors(context, errors, incoming, announce.getLinkedin());
        HttpAnnouncerValidator.validateHttpAnnouncers(context, mode, announce.getConfiguredHttp(), incoming);
        Validator.mergeErrors(context, errors, incoming, announce.getConfiguredHttp());
        SmtpAnnouncerValidator.validateSmtp(context, announce.getSmtp(), incoming);
        Validator.mergeErrors(context, errors, incoming, announce.getSmtp());
        MastodonAnnouncerValidator.validateMastodon(context, announce.getMastodon(), incoming);
        Validator.mergeErrors(context, errors, incoming, announce.getMastodon());
        MattermostAnnouncerValidator.validateMattermost(context, announce.getMattermost(), incoming);
        Validator.mergeErrors(context, errors, incoming, announce.getMattermost());
        RedditAnnouncerValidator.validateReddit(context, announce.getReddit(), incoming);
        Validator.mergeErrors(context, errors, incoming, announce.getReddit());
        OpenCollectiveAnnouncerValidator.validateOpenCollective(context, announce.getOpenCollective(), incoming);
        Validator.mergeErrors(context, errors, incoming, announce.getOpenCollective());
        SdkmanAnnouncerValidator.validateSdkmanAnnouncer(context, announce.getSdkman(), incoming);
        Validator.mergeErrors(context, errors, incoming, announce.getSdkman());
        SlackAnnouncerValidator.validateSlack(context, announce.getSlack(), incoming);
        Validator.mergeErrors(context, errors, incoming, announce.getSlack());
        TeamsAnnouncerValidator.validateTeams(context, announce.getTeams(), incoming);
        Validator.mergeErrors(context, errors, incoming, announce.getTeams());
        TelegramAnnouncerValidator.validateTelegram(context, announce.getTelegram(), incoming);
        Validator.mergeErrors(context, errors, incoming, announce.getTelegram());
        TwitterAnnouncerValidator.validateTwitter(context, announce.getTwitter(), incoming);
        Validator.mergeErrors(context, errors, incoming, announce.getTwitter());
        WebhooksAnnouncerValidator.validateWebhooks(context, mode, announce.getConfiguredWebhooks(), incoming);
        Validator.mergeErrors(context, errors, incoming, announce.getConfiguredWebhooks());
        ZulipAnnouncerValidator.validateZulip(context, announce.getZulip(), incoming);
        Validator.mergeErrors(context, errors, incoming, announce.getZulip());
        boolean activeSet = announce.isActiveSet();
        Validator.resolveActivatable(context, (Activatable)announce, "announce", "ALWAYS");
        announce.resolveEnabled(context.getModel().getProject());
        if (announce.isEnabled()) {
            boolean enabled;
            boolean bl = enabled = announce.getArticle().isEnabled() || announce.getBluesky().isEnabled() || announce.getDiscord().isEnabled() || announce.getDiscourse().isEnabled() || announce.getDiscussions().isEnabled() || announce.getGitter().isEnabled() || announce.getGoogleChat().isEnabled() || announce.getLinkedin().isEnabled() || announce.getConfiguredHttp().isEnabled() || announce.getSmtp().isEnabled() || announce.getMastodon().isEnabled() || announce.getMattermost().isEnabled() || announce.getOpenCollective().isEnabled() || announce.getReddit().isEnabled() || announce.getSdkman().isEnabled() || announce.getSlack().isEnabled() || announce.getTeams().isEnabled() || announce.getTelegram().isEnabled() || announce.getTwitter().isEnabled() || announce.getConfiguredWebhooks().isEnabled() || announce.getZulip().isEnabled();
            if (!activeSet && !enabled) {
                context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
                announce.disable();
            }
        }
    }
}

