/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.assemblers;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashSet;
import org.jreleaser.assemblers.AbstractAssemblerProcessor;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Archive;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.Assembler;
import org.jreleaser.model.internal.assemble.JavaArchiveAssembler;
import org.jreleaser.model.internal.common.Glob;
import org.jreleaser.model.internal.common.JvmOptions;
import org.jreleaser.model.spi.assemble.AssemblerProcessingException;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public class JavaArchiveAssemblerProcessor
extends AbstractAssemblerProcessor<org.jreleaser.model.api.assemble.JavaArchiveAssembler, JavaArchiveAssembler> {
    public JavaArchiveAssemblerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doAssemble(TemplateContext props) throws AssemblerProcessingException {
        Path assembleDirectory = (Path)props.get("distributionAssembleDirectory");
        String archiveName = ((JavaArchiveAssembler)this.assembler).getResolvedArchiveName(this.context);
        Path workDirectory = assembleDirectory.resolve("work");
        Path archiveDirectory = workDirectory.resolve(archiveName);
        try {
            FileUtils.deleteFiles((Path)workDirectory);
            Files.createDirectories(archiveDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_delete_archive", (Object[])new Object[]{archiveName}), (Throwable)e);
        }
        this.copyTemplates(this.context, props, archiveDirectory);
        this.context.getLogger().debug(RB.$((String)"assembler.copy.files", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(archiveDirectory)});
        this.copyArtifacts(this.context, archiveDirectory, PlatformUtils.getCurrentFull(), false);
        this.copyFiles(this.context, archiveDirectory);
        this.copyFileSets(this.context, archiveDirectory);
        Path jarsDirectory = archiveDirectory.resolve("lib");
        this.context.getLogger().debug(RB.$((String)"assembler.copy.jars", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(jarsDirectory)});
        this.copyJars(this.context, (JavaArchiveAssembler)this.assembler, jarsDirectory);
        this.generateSwidTag(this.context, archiveDirectory);
        for (Archive.Format format : ((JavaArchiveAssembler)this.assembler).getFormats()) {
            this.archive(workDirectory, assembleDirectory, archiveName, format);
        }
    }

    @Override
    protected void fillAssemblerProperties(TemplateContext props) {
        super.fillAssemblerProperties(props);
        if (StringUtils.isNotBlank((String)((JavaArchiveAssembler)this.assembler).getMainJar().getPath())) {
            props.set("distributionJavaMainJar", (Object)((JavaArchiveAssembler)this.assembler).getMainJar().getEffectivePath(this.context, this.assembler).getFileName());
        } else {
            props.set("distributionJavaMainJar", (Object)"");
        }
        props.setOrEmpty("distributionJavaMainClass", ((JavaArchiveAssembler)this.assembler).getJava().getMainClass());
        props.setOrEmpty("distributionJavaMainModule", ((JavaArchiveAssembler)this.assembler).getJava().getMainModule());
        JvmOptions jvmOptions = ((JavaArchiveAssembler)this.assembler).getJava().getJvmOptions();
        props.set("distributionExecutable", (Object)((JavaArchiveAssembler)this.assembler).getExecutable().getName());
        props.set("distributionJavaJvmOptionsUniversal", (Object)(!jvmOptions.getUniversal().isEmpty() ? MustacheUtils.passThrough((String)String.join((CharSequence)" ", jvmOptions.getResolvedUniversal(this.context))) : ""));
        props.set("distributionJavaJvmOptionsUnix", (Object)(!jvmOptions.getUnix().isEmpty() ? MustacheUtils.passThrough((String)String.join((CharSequence)" ", jvmOptions.getResolvedUnix(this.context))) : ""));
        props.set("distributionJavaJvmOptionsLinux", (Object)(!jvmOptions.getLinux().isEmpty() ? MustacheUtils.passThrough((String)String.join((CharSequence)" ", jvmOptions.getResolvedLinux(this.context))) : ""));
        props.set("distributionJavaJvmOptionsOsx", (Object)(!jvmOptions.getOsx().isEmpty() ? MustacheUtils.passThrough((String)String.join((CharSequence)" ", jvmOptions.getResolvedOsx(this.context))) : ""));
        props.set("distributionJavaJvmOptionsWindows", (Object)(!jvmOptions.getWindows().isEmpty() ? MustacheUtils.passThrough((String)String.join((CharSequence)" ", jvmOptions.getResolvedWindows(this.context))) : ""));
        props.set("distributionJavaEnvironmentVariablesUniversal", ((JavaArchiveAssembler)this.assembler).getJava().getEnvironmentVariables().getResolvedUniversal(this.context).entrySet());
        props.set("distributionJavaEnvironmentVariablesUnix", ((JavaArchiveAssembler)this.assembler).getJava().getEnvironmentVariables().getResolvedUnix(this.context).entrySet());
        props.set("distributionJavaEnvironmentVariablesLinux", ((JavaArchiveAssembler)this.assembler).getJava().getEnvironmentVariables().getResolvedLinux(this.context).entrySet());
        props.set("distributionJavaEnvironmentVariablesOsx", ((JavaArchiveAssembler)this.assembler).getJava().getEnvironmentVariables().getResolvedOsx(this.context).entrySet());
        props.set("distributionJavaEnvironmentVariablesWindows", ((JavaArchiveAssembler)this.assembler).getJava().getEnvironmentVariables().getResolvedWindows(this.context).entrySet());
    }

    private void archive(Path workDirectory, Path assembleDirectory, String archiveName, Archive.Format format) throws AssemblerProcessingException {
        String finalArchiveName = archiveName + "." + format.extension();
        this.context.getLogger().info("- {}", new Object[]{finalArchiveName});
        try {
            Path archiveFile = assembleDirectory.resolve(finalArchiveName);
            FileUtils.packArchive((Path)workDirectory, (Path)archiveFile, (FileUtils.ArchiveOptions)((JavaArchiveAssembler)this.assembler).getOptions().toOptions());
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    @Override
    protected Path resolveOutputFile(TemplateContext props, Path targetDirectory, String fileName) throws AssemblerProcessingException {
        String executableName = ((JavaArchiveAssembler)this.assembler).getExecutable().getName();
        String windowsExtension = "." + ((JavaArchiveAssembler)this.assembler).getExecutable().getWindowsExtension();
        String unixExtension = ((JavaArchiveAssembler)this.assembler).getExecutable().getUnixExtension();
        String string = unixExtension = StringUtils.isNotBlank((String)unixExtension) ? "." + unixExtension : "";
        return "bin/launcher.bat".equals(fileName) ? targetDirectory.resolve("bin").resolve(executableName.concat(windowsExtension)) : ("bin/launcher".equals(fileName) ? targetDirectory.resolve("bin").resolve(executableName.concat(unixExtension)) : targetDirectory.resolve(fileName));
    }

    private void copyJars(JReleaserContext context, JavaArchiveAssembler assembler, Path jarsDirectory) throws AssemblerProcessingException {
        LinkedHashSet<Path> paths = new LinkedHashSet<Path>();
        if (StringUtils.isNotBlank((String)assembler.getMainJar().getPath())) {
            paths.add(assembler.getMainJar().getEffectivePath(context, (Assembler)assembler));
        }
        for (Glob glob : assembler.getJars()) {
            if (!glob.resolveActiveAndSelected(context)) continue;
            glob.getResolvedArtifacts(context).stream().map(artifact -> artifact.getResolvedPath(context, (Assembler)assembler)).forEach(paths::add);
        }
        try {
            Files.createDirectories(jarsDirectory, new FileAttribute[0]);
            for (Path path : paths) {
                context.getLogger().debug(RB.$((String)"assembler.copying", (Object[])new Object[0]), new Object[]{path.getFileName()});
                Files.copy(path, jarsDirectory.resolve(path.getFileName()), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_copying_jars", (Object[])new Object[0]), (Throwable)e);
        }
    }
}

