/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.sign;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.sign.AbstractSigner;
import org.jreleaser.model.api.signing.SigningException;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.signing.Signing;
import org.jreleaser.model.internal.signing.SigningTool;
import org.jreleaser.sdk.signing.SigningUtils;
import org.jreleaser.sdk.tool.Minisign;
import org.jreleaser.sdk.tool.ToolException;

public final class MinisignSigner
extends AbstractSigner {
    public MinisignSigner(JReleaserContext context, SigningTool tool) {
        super(context, tool);
    }

    public void sign() throws SigningException {
        Signing signing = this.context.getModel().getSigning();
        Minisign minisign = new Minisign(this.context.asImmutable(), signing.getMinisign().getVersion());
        try {
            if (!minisign.setup()) {
                this.context.getLogger().warn(RB.$((String)"tool_unavailable", (Object[])new Object[]{"minisign"}));
                return;
            }
        }
        catch (ToolException e) {
            throw new SigningException(e.getMessage(), (Throwable)e);
        }
        Path secretKeyFile = signing.getMinisign().getResolvedSecretKeyFilePath(this.context);
        Path publicKeyFile = signing.getMinisign().getResolvedPublicKeyFilePath(this.context);
        String password = signing.getMinisign().getPassphrase();
        List<Object> files = this.collectArtifacts(pair -> this.isValid(minisign, publicKeyFile, (SigningUtils.FilePair)pair));
        if (files.isEmpty()) {
            this.context.getLogger().info(RB.$((String)"signing.no.match", (Object[])new Object[0]));
            return;
        }
        if ((files = files.stream().filter(SigningUtils.FilePair::isInvalid).collect(Collectors.toList())).isEmpty()) {
            this.context.getLogger().info(RB.$((String)"signing.up.to.date", (Object[])new Object[0]));
            return;
        }
        this.sign(files, minisign, secretKeyFile, password);
        this.verify(files, minisign, publicKeyFile);
    }

    private void sign(List<SigningUtils.FilePair> files, Minisign minisign, Path privateKeyFile, String password) throws SigningException {
        Path signaturesDirectory = this.context.getSignaturesDirectory();
        try {
            Files.createDirectories(signaturesDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new SigningException(RB.$((String)"ERROR_signing_create_signature_dir", (Object[])new Object[0]), (Throwable)e);
        }
        this.context.getLogger().debug(RB.$((String)"signing.signing.files", (Object[])new Object[0]), new Object[]{files.size(), this.context.relativizeToBasedir(signaturesDirectory)});
        for (SigningUtils.FilePair pair : files) {
            minisign.sign(privateKeyFile, password, pair.getInputFile(), signaturesDirectory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verify(List<SigningUtils.FilePair> files, Minisign minisign, Path publicKeyFile) throws SigningException {
        this.context.getLogger().debug(RB.$((String)"signing.verify.signatures", (Object[])new Object[0]), new Object[]{files.size()});
        this.context.getLogger().setPrefix("verify");
        try {
            for (SigningUtils.FilePair pair : files) {
                minisign.verify(publicKeyFile, pair.getSignatureFile(), pair.getInputFile());
                pair.setValid(true);
                if (pair.isValid()) continue;
                throw new SigningException(RB.$((String)"ERROR_signing_verify_file", (Object[])new Object[]{this.context.relativizeToBasedir(pair.getInputFile()), this.context.relativizeToBasedir(pair.getSignatureFile())}));
            }
        }
        finally {
            this.context.getLogger().restorePrefix();
        }
    }

    private boolean isValid(Minisign minisign, Path publicKeyFile, SigningUtils.FilePair pair) {
        if (Files.notExists(pair.getSignatureFile(), new LinkOption[0])) {
            this.context.getLogger().debug(RB.$((String)"signing.signature.not.exist", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(pair.getSignatureFile())});
            return false;
        }
        if (pair.getInputFile().toFile().lastModified() > pair.getSignatureFile().toFile().lastModified()) {
            this.context.getLogger().debug(RB.$((String)"signing.file.newer", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(pair.getInputFile()), this.context.relativizeToBasedir(pair.getSignatureFile())});
            return false;
        }
        try {
            minisign.verify(publicKeyFile, pair.getSignatureFile(), pair.getInputFile());
            return true;
        }
        catch (SigningException e) {
            return false;
        }
    }
}

