/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.reddit;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import feign.RequestInterceptor;
import feign.auth.BasicAuthRequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.FormEncoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import java.util.Objects;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.commons.RestAPIException;
import org.jreleaser.sdk.reddit.RedditSdkException;
import org.jreleaser.sdk.reddit.api.AccessTokenResponse;
import org.jreleaser.sdk.reddit.api.RedditAPI;
import org.jreleaser.sdk.reddit.api.SubmissionRequest;
import org.jreleaser.sdk.reddit.api.SubmissionResponse;
import org.jreleaser.util.StringUtils;

public class RedditSdk {
    private static final String REDDIT_BASE_URL = "https://www.reddit.com";
    private static final String REDDIT_OAUTH_URL = "https://oauth.reddit.com";
    private final JReleaserContext context;
    private final RedditAPI authApi;
    private final RedditAPI oauthApi;
    private final String clientId;
    private final String clientSecret;
    private final String username;
    private final String password;
    private final String userAgent;
    private final boolean dryrun;
    private String accessToken;

    private RedditSdk(JReleaserContext context, String clientId, String clientSecret, String username, String password, int connectTimeout, int readTimeout, boolean dryrun, String baseUrl, String oauthUrl) {
        Objects.requireNonNull(context, "'context' must not be null");
        StringUtils.requireNonBlank((String)clientId, (String)"'clientId' must not be blank");
        StringUtils.requireNonBlank((String)clientSecret, (String)"'clientSecret' must not be blank");
        StringUtils.requireNonBlank((String)username, (String)"'username' must not be blank");
        StringUtils.requireNonBlank((String)password, (String)"'password' must not be blank");
        ObjectMapper objectMapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.INDENT_OUTPUT, true);
        this.context = context;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.username = username;
        this.password = password;
        this.dryrun = dryrun;
        this.userAgent = String.format("JReleaser/%s by /u/%s", context.getModel().getProject().getVersion(), username);
        this.authApi = (RedditAPI)ClientUtils.builder((JReleaserContext)context, (int)connectTimeout, (int)readTimeout).encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder(objectMapper))).decoder((Decoder)new JacksonDecoder(objectMapper)).requestInterceptor((RequestInterceptor)new BasicAuthRequestInterceptor(clientId, clientSecret)).requestInterceptor(template -> {
            template.header("User-Agent", new String[]{this.userAgent});
            template.body("grant_type=password&username=" + username + "&password=" + password);
        }).target(RedditAPI.class, baseUrl);
        this.oauthApi = (RedditAPI)ClientUtils.builder((JReleaserContext)context, (int)connectTimeout, (int)readTimeout).encoder((Encoder)new FormEncoder()).decoder((Decoder)new JacksonDecoder(objectMapper)).requestInterceptor(template -> template.header("User-Agent", new String[]{this.userAgent})).target(RedditAPI.class, oauthUrl);
        this.context.getLogger().debug(RB.$((String)"workflow.dryrun", (Object[])new Object[0]), new Object[]{dryrun});
    }

    public void submitTextPost(String subreddit, String title, String text) throws RedditSdkException {
        this.ensureAuthenticated();
        this.wrap(() -> {
            SubmissionRequest request = SubmissionRequest.forTextPost(subreddit, title, text);
            SubmissionResponse response = this.oauthApi.submit(this.accessToken, request);
            if (response.hasErrors()) {
                throw new RedditSdkException(RB.$((String)"sdk.api.errors", (Object[])new Object[]{"Reddit", response.getErrors()}));
            }
        });
    }

    public void submitLinkPost(String subreddit, String title, String url) throws RedditSdkException {
        this.ensureAuthenticated();
        this.wrap(() -> {
            SubmissionRequest request = SubmissionRequest.forLinkPost(subreddit, title, url);
            SubmissionResponse response = this.oauthApi.submit(this.accessToken, request);
            if (response.hasErrors()) {
                throw new RedditSdkException(RB.$((String)"sdk.api.errors", (Object[])new Object[]{"Reddit", response.getErrors()}));
            }
        });
    }

    private void ensureAuthenticated() throws RedditSdkException {
        if (this.accessToken == null) {
            this.authenticate();
        }
    }

    private void authenticate() throws RedditSdkException {
        this.wrap(() -> {
            AccessTokenResponse response = this.authApi.getAccessToken();
            this.accessToken = response.getAccessToken();
        });
    }

    private void wrap(Runnable runnable) throws RedditSdkException {
        try {
            if (!this.dryrun) {
                runnable.run();
            }
        }
        catch (RestAPIException e) {
            this.context.getLogger().trace((Throwable)e);
            throw new RedditSdkException(RB.$((String)"sdk.operation.failed", (Object[])new Object[]{"Reddit"}), e);
        }
    }

    public static Builder builder(JReleaserContext context) {
        return new Builder(context);
    }

    public static class Builder {
        private final JReleaserContext context;
        private String clientId;
        private String clientSecret;
        private String username;
        private String password;
        private int connectTimeout = 20;
        private int readTimeout = 60;
        private boolean dryrun;
        private String baseUrl;
        private String oauthUrl;

        private Builder(JReleaserContext context) {
            this.context = Objects.requireNonNull(context, "'context' must not be null");
        }

        public Builder clientId(String clientId) {
            this.clientId = StringUtils.requireNonBlank((String)clientId, (String)"'clientId' must not be blank");
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = StringUtils.requireNonBlank((String)clientSecret, (String)"'clientSecret' must not be blank");
            return this;
        }

        public Builder username(String username) {
            this.username = StringUtils.requireNonBlank((String)username, (String)"'username' must not be blank");
            return this;
        }

        public Builder password(String password) {
            this.password = StringUtils.requireNonBlank((String)password, (String)"'password' must not be blank");
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder dryrun(boolean dryrun) {
            this.dryrun = dryrun;
            return this;
        }

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder oauthUrl(String oauthUrl) {
            this.oauthUrl = oauthUrl;
            return this;
        }

        private void validate() {
            StringUtils.requireNonBlank((String)this.clientId, (String)"'clientId' must not be blank");
            StringUtils.requireNonBlank((String)this.clientSecret, (String)"'clientSecret' must not be blank");
            StringUtils.requireNonBlank((String)this.username, (String)"'username' must not be blank");
            StringUtils.requireNonBlank((String)this.password, (String)"'password' must not be blank");
            if (StringUtils.isBlank((String)this.baseUrl)) {
                this.baseUrl = RedditSdk.REDDIT_BASE_URL;
            }
            if (StringUtils.isBlank((String)this.oauthUrl)) {
                this.oauthUrl = RedditSdk.REDDIT_OAUTH_URL;
            }
        }

        public RedditSdk build() {
            this.validate();
            return new RedditSdk(this.context, this.clientId, this.clientSecret, this.username, this.password, this.connectTimeout, this.readTimeout, this.dryrun, this.baseUrl, this.oauthUrl);
        }
    }
}

