/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnDiff;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.SchemaKt;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.OracleDataTypeProvider;
import org.jetbrains.exposed.sql.vendors.OracleFunctionProvider;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 *2\u00020\u0001:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\u0018\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\bH\u0016J\u0014\u0010 \u001a\u00020\b2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"H\u0016J\"\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00180$2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030&2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0014\u0010\u000f\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0014\u0010\u0011\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0014\u0010\u0013\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR\u0014\u0010\u0015\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\n\u00a8\u0006+"}, d2={"Lorg/jetbrains/exposed/sql/vendors/OracleDialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "()V", "defaultReferenceOption", "Lorg/jetbrains/exposed/sql/ReferenceOption;", "getDefaultReferenceOption", "()Lorg/jetbrains/exposed/sql/ReferenceOption;", "needsQuotesWhenSymbolsInNames", "", "getNeedsQuotesWhenSymbolsInNames", "()Z", "needsSequenceToAutoInc", "getNeedsSequenceToAutoInc", "supportsDualTableConcept", "getSupportsDualTableConcept", "supportsIfNotExists", "getSupportsIfNotExists", "supportsMultipleGeneratedKeys", "getSupportsMultipleGeneratedKeys", "supportsOnlyIdentifiersInGeneratedKeys", "getSupportsOnlyIdentifiersInGeneratedKeys", "supportsOrderByNullsFirstLast", "getSupportsOrderByNullsFirstLast", "createDatabase", "", "name", "createSchema", "schema", "Lorg/jetbrains/exposed/sql/Schema;", "dropDatabase", "dropSchema", "cascade", "isAllowedAsColumnDefault", "e", "Lorg/jetbrains/exposed/sql/Expression;", "modifyColumn", "", "column", "Lorg/jetbrains/exposed/sql/Column;", "columnDiff", "Lorg/jetbrains/exposed/sql/ColumnDiff;", "setSchema", "Companion", "exposed-core"})
public class OracleDialect
extends VendorDialect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean supportsIfNotExists;
    private final boolean needsSequenceToAutoInc;
    @NotNull
    private final ReferenceOption defaultReferenceOption = ReferenceOption.NO_ACTION;
    private final boolean needsQuotesWhenSymbolsInNames;
    private final boolean supportsMultipleGeneratedKeys;
    private final boolean supportsOnlyIdentifiersInGeneratedKeys;
    private final boolean supportsDualTableConcept;
    private final boolean supportsOrderByNullsFirstLast;
    @NotNull
    public static final String dialectName = "oracle";

    public OracleDialect() {
        super(dialectName, OracleDataTypeProvider.INSTANCE, OracleFunctionProvider.INSTANCE);
        this.needsSequenceToAutoInc = true;
        this.supportsOnlyIdentifiersInGeneratedKeys = true;
        this.supportsDualTableConcept = true;
        this.supportsOrderByNullsFirstLast = true;
    }

    @Override
    public boolean getSupportsIfNotExists() {
        return this.supportsIfNotExists;
    }

    @Override
    public boolean getNeedsSequenceToAutoInc() {
        return this.needsSequenceToAutoInc;
    }

    @Override
    @NotNull
    public ReferenceOption getDefaultReferenceOption() {
        return this.defaultReferenceOption;
    }

    @Override
    public boolean getNeedsQuotesWhenSymbolsInNames() {
        return this.needsQuotesWhenSymbolsInNames;
    }

    @Override
    public boolean getSupportsMultipleGeneratedKeys() {
        return this.supportsMultipleGeneratedKeys;
    }

    @Override
    public boolean getSupportsOnlyIdentifiersInGeneratedKeys() {
        return this.supportsOnlyIdentifiersInGeneratedKeys;
    }

    @Override
    public boolean getSupportsDualTableConcept() {
        return this.supportsDualTableConcept;
    }

    @Override
    public boolean getSupportsOrderByNullsFirstLast() {
        return this.supportsOrderByNullsFirstLast;
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> modifyColumn(@NotNull Column<?> column, @NotNull ColumnDiff columnDiff) {
        List list;
        Collection collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)columnDiff, (String)"columnDiff");
        Iterable $this$map$iv = super.modifyColumn(column, columnDiff);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.replace$default((String)it, (String)"MODIFY COLUMN", (String)"MODIFY", (boolean)false, (int)4, null));
        }
        List result = (List)destination$iv$iv;
        if (!columnDiff.getNullability()) {
            void $this$mapTo$iv$iv2;
            String nullableState = column.getColumnType().getNullable() ? "NULL " : "NOT NULL";
            Iterable $this$map$iv2 = result;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                String bl = (String)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(StringsKt.replace$default((String)it, (String)nullableState, (String)"", (boolean)false, (int)4, null));
            }
            list = (List)destination$iv$iv2;
        } else {
            list = result;
        }
        return list;
    }

    @Override
    @NotNull
    public String createDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return Intrinsics.stringPlus((String)"CREATE DATABASE ", (Object)DefaultKt.inProperCase(name));
    }

    @Override
    @NotNull
    public String dropDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return Intrinsics.stringPlus((String)"DROP DATABASE ", (Object)DefaultKt.inProperCase(name));
    }

    @Override
    @NotNull
    public String setSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return Intrinsics.stringPlus((String)"ALTER SESSION SET CURRENT_SCHEMA = ", (Object)schema.getIdentifier());
    }

    @Override
    @NotNull
    public String createSchema(@NotNull Schema schema) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        StringBuilder $this$createSchema_u24lambda_u2d2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (schema.getQuota() == null ^ schema.getOn() == null) {
            throw new IllegalArgumentException("You must either provide both <quota> and <on> options or non of them");
        }
        String[] stringArray = new String[]{"CREATE USER ", schema.getIdentifier()};
        StringsKt.append((StringBuilder)$this$createSchema_u24lambda_u2d2, (String[])stringArray);
        stringArray = new String[]{" IDENTIFIED BY ", schema.getPassword()};
        StringsKt.append((StringBuilder)$this$createSchema_u24lambda_u2d2, (String[])stringArray);
        SchemaKt.appendIfNotNull($this$createSchema_u24lambda_u2d2, " DEFAULT TABLESPACE ", schema.getDefaultTablespace());
        SchemaKt.appendIfNotNull($this$createSchema_u24lambda_u2d2, " TEMPORARY TABLESPACE ", schema.getTemporaryTablespace());
        SchemaKt.appendIfNotNull($this$createSchema_u24lambda_u2d2, " QUOTA ", schema.getQuota());
        SchemaKt.appendIfNotNull($this$createSchema_u24lambda_u2d2, " ON ", schema.getOn());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    @NotNull
    public String dropSchema(@NotNull Schema schema, boolean cascade) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        StringBuilder $this$dropSchema_u24lambda_u2d3 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String[] stringArray = new String[]{"DROP USER ", schema.getIdentifier()};
        StringsKt.append((StringBuilder)$this$dropSchema_u24lambda_u2d3, (String[])stringArray);
        if (cascade) {
            $this$dropSchema_u24lambda_u2d3.append(" CASCADE");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/exposed/sql/vendors/OracleDialect$Companion;", "", "()V", "dialectName", "", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

