/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.kt.classpath;

import java.nio.file.Path;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.javacs.kt.classpath.ClassPathEntry;
import org.javacs.kt.classpath.ClassPathResolver;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0011R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0011R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0011R\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lorg/javacs/kt/classpath/UnionClassPathResolver;", "Lorg/javacs/kt/classpath/ClassPathResolver;", "lhs", "rhs", "<init>", "(Lorg/javacs/kt/classpath/ClassPathResolver;Lorg/javacs/kt/classpath/ClassPathResolver;)V", "getLhs", "()Lorg/javacs/kt/classpath/ClassPathResolver;", "getRhs", "resolverType", "", "getResolverType", "()Ljava/lang/String;", "classpath", "", "Lorg/javacs/kt/classpath/ClassPathEntry;", "getClasspath", "()Ljava/util/Set;", "classpathOrEmpty", "getClasspathOrEmpty", "buildScriptClasspath", "Ljava/nio/file/Path;", "getBuildScriptClasspath", "buildScriptClasspathOrEmpty", "getBuildScriptClasspathOrEmpty", "classpathWithSources", "getClasspathWithSources", "currentBuildFileVersion", "", "getCurrentBuildFileVersion", "()J", "shared"})
public final class UnionClassPathResolver
implements ClassPathResolver {
    @NotNull
    private final ClassPathResolver lhs;
    @NotNull
    private final ClassPathResolver rhs;

    public UnionClassPathResolver(@NotNull ClassPathResolver lhs, @NotNull ClassPathResolver rhs) {
        Intrinsics.checkNotNullParameter((Object)lhs, (String)"lhs");
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @NotNull
    public final ClassPathResolver getLhs() {
        return this.lhs;
    }

    @NotNull
    public final ClassPathResolver getRhs() {
        return this.rhs;
    }

    @Override
    @NotNull
    public String getResolverType() {
        return "(" + this.lhs.getResolverType() + " + " + this.rhs.getResolverType() + ")";
    }

    @Override
    @NotNull
    public Set<ClassPathEntry> getClasspath() {
        return SetsKt.plus(this.lhs.getClasspath(), (Iterable)this.rhs.getClasspath());
    }

    @Override
    @NotNull
    public Set<ClassPathEntry> getClasspathOrEmpty() {
        return SetsKt.plus(this.lhs.getClasspathOrEmpty(), (Iterable)this.rhs.getClasspathOrEmpty());
    }

    @Override
    @NotNull
    public Set<Path> getBuildScriptClasspath() {
        return SetsKt.plus(this.lhs.getBuildScriptClasspath(), (Iterable)this.rhs.getBuildScriptClasspath());
    }

    @Override
    @NotNull
    public Set<Path> getBuildScriptClasspathOrEmpty() {
        return SetsKt.plus(this.lhs.getBuildScriptClasspathOrEmpty(), (Iterable)this.rhs.getBuildScriptClasspathOrEmpty());
    }

    @Override
    @NotNull
    public Set<ClassPathEntry> getClasspathWithSources() {
        return SetsKt.plus(this.lhs.getClasspathWithSources(), (Iterable)this.rhs.getClasspathWithSources());
    }

    @Override
    public long getCurrentBuildFileVersion() {
        return Math.max(this.lhs.getCurrentBuildFileVersion(), this.rhs.getCurrentBuildFileVersion());
    }
}

