/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.kt;

import java.io.BufferedReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.javacs.kt.LoggerKt;
import org.javacs.kt.util.URIsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a \u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u001a \u0010\f\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u00a8\u0006\r"}, d2={"patch", "", "sourceText", "change", "Lorg/eclipse/lsp4j/TextDocumentContentChangeEvent;", "logAdded", "", "sources", "", "Ljava/net/URI;", "rootPath", "Ljava/nio/file/Path;", "logRemoved", "server"})
public final class SourceFilesKt {
    private static final String patch(String sourceText, TextDocumentContentChangeEvent change) {
        Range range = change.getRange();
        BufferedReader reader = new BufferedReader(new StringReader(sourceText));
        StringWriter writer = new StringWriter();
        for (int line = 0; line < range.getStart().getLine(); ++line) {
            writer.write(reader.readLine() + "\n");
        }
        int n = range.getStart().getCharacter();
        for (int character = 0; character < n; ++character) {
            writer.write(reader.read());
        }
        writer.write(change.getText());
        n = range.getEnd().getLine() - range.getStart().getLine();
        for (int i = 0; i < n; ++i) {
            reader.readLine();
        }
        long l = range.getStart().getLine() == range.getEnd().getLine() ? reader.skip(range.getEnd().getCharacter() - range.getStart().getCharacter()) : reader.skip(range.getEnd().getCharacter());
        while (true) {
            int next;
            if ((next = reader.read()) == -1) {
                String string = writer.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }
            writer.write(next);
        }
    }

    private static final void logAdded(Collection<URI> sources, Path rootPath) {
        Object[] objectArray = new Object[]{URIsKt.describeURIs(sources), rootPath};
        LoggerKt.getLOG().info("Adding {} under {} to source path", objectArray);
    }

    private static final void logRemoved(Collection<URI> sources, Path rootPath) {
        Object[] objectArray = new Object[]{URIsKt.describeURIs(sources), rootPath};
        LoggerKt.getLOG().info("Removing {} under {} to source path", objectArray);
    }

    public static final /* synthetic */ String access$patch(String sourceText, TextDocumentContentChangeEvent change) {
        return SourceFilesKt.patch(sourceText, change);
    }

    public static final /* synthetic */ void access$logAdded(Collection sources, Path rootPath) {
        SourceFilesKt.logAdded(sources, rootPath);
    }

    public static final /* synthetic */ void access$logRemoved(Collection sources, Path rootPath) {
        SourceFilesKt.logRemoved(sources, rootPath);
    }
}

