/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvn;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.maven.api.cli.mvn.MavenOptions;
import org.apache.maven.cling.invoker.CommonsCliOptions;

public class CommonsCliMavenOptions
extends CommonsCliOptions
implements MavenOptions {
    public static CommonsCliMavenOptions parse(String source, String[] args) throws ParseException {
        CLIManager cliManager = new CLIManager();
        return new CommonsCliMavenOptions(source, cliManager, cliManager.parse(args));
    }

    protected CommonsCliMavenOptions(String source, CLIManager cliManager, CommandLine commandLine) {
        super(source, cliManager, commandLine);
    }

    public Optional<String> alternatePomFile() {
        if (this.commandLine.hasOption("f")) {
            return Optional.of(this.commandLine.getOptionValue("f"));
        }
        return Optional.empty();
    }

    public Optional<Boolean> nonRecursive() {
        if (this.commandLine.hasOption("N")) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    public Optional<Boolean> updateSnapshots() {
        if (this.commandLine.hasOption("U")) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    public Optional<List<String>> activatedProfiles() {
        if (this.commandLine.hasOption("P")) {
            return Optional.of(Arrays.asList(this.commandLine.getOptionValues("P")));
        }
        return Optional.empty();
    }

    public Optional<Boolean> suppressSnapshotUpdates() {
        if (this.commandLine.hasOption("nsu")) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    public Optional<Boolean> strictChecksums() {
        if (this.commandLine.hasOption("C")) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    public Optional<Boolean> relaxedChecksums() {
        if (this.commandLine.hasOption("c")) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    public Optional<Boolean> failFast() {
        if (this.commandLine.hasOption("ff")) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    public Optional<Boolean> failAtEnd() {
        if (this.commandLine.hasOption("fae")) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    public Optional<Boolean> failNever() {
        if (this.commandLine.hasOption("fn")) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    public Optional<Boolean> resume() {
        if (this.commandLine.hasOption("r")) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    public Optional<String> resumeFrom() {
        if (this.commandLine.hasOption("rf")) {
            return Optional.of(this.commandLine.getOptionValue("rf"));
        }
        return Optional.empty();
    }

    public Optional<List<String>> projects() {
        if (this.commandLine.hasOption("pl")) {
            return Optional.of(Arrays.asList(this.commandLine.getOptionValues("pl")));
        }
        return Optional.empty();
    }

    public Optional<Boolean> alsoMake() {
        if (this.commandLine.hasOption("am")) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    public Optional<Boolean> alsoMakeDependents() {
        if (this.commandLine.hasOption("amd")) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    public Optional<String> threads() {
        if (this.commandLine.hasOption("T")) {
            return Optional.of(this.commandLine.getOptionValue("T"));
        }
        return Optional.empty();
    }

    public Optional<String> builder() {
        if (this.commandLine.hasOption("b")) {
            return Optional.of(this.commandLine.getOptionValue("b"));
        }
        return Optional.empty();
    }

    public Optional<Boolean> noTransferProgress() {
        if (this.commandLine.hasOption("ntp")) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    public Optional<Boolean> cacheArtifactNotFound() {
        if (this.commandLine.hasOption("canf")) {
            return Optional.of(Boolean.parseBoolean(this.commandLine.getOptionValue("canf")));
        }
        return Optional.empty();
    }

    public Optional<Boolean> strictArtifactDescriptorPolicy() {
        if (this.commandLine.hasOption("sadp")) {
            return Optional.of(Boolean.parseBoolean(this.commandLine.getOptionValue("sadp")));
        }
        return Optional.empty();
    }

    public Optional<Boolean> ignoreTransitiveRepositories() {
        if (this.commandLine.hasOption("itr")) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    public Optional<String> atFile() {
        if (this.commandLine.hasOption("af")) {
            return Optional.of(this.commandLine.getOptionValue("af"));
        }
        return Optional.empty();
    }

    public Optional<List<String>> goals() {
        if (!this.commandLine.getArgList().isEmpty()) {
            return Optional.of(this.commandLine.getArgList());
        }
        return Optional.empty();
    }

    @Override
    protected CommonsCliMavenOptions copy(String source, CommonsCliOptions.CLIManager cliManager, CommandLine commandLine) {
        return new CommonsCliMavenOptions(source, (CLIManager)cliManager, commandLine);
    }

    protected static class CLIManager
    extends CommonsCliOptions.CLIManager {
        public static final String ALTERNATE_POM_FILE = "f";
        public static final String NON_RECURSIVE = "N";
        public static final String UPDATE_SNAPSHOTS = "U";
        public static final String ACTIVATE_PROFILES = "P";
        public static final String SUPPRESS_SNAPSHOT_UPDATES = "nsu";
        public static final String CHECKSUM_FAILURE_POLICY = "C";
        public static final String CHECKSUM_WARNING_POLICY = "c";
        public static final String FAIL_FAST = "ff";
        public static final String FAIL_AT_END = "fae";
        public static final String FAIL_NEVER = "fn";
        public static final String RESUME = "r";
        public static final String RESUME_FROM = "rf";
        public static final String PROJECT_LIST = "pl";
        public static final String ALSO_MAKE = "am";
        public static final String ALSO_MAKE_DEPENDENTS = "amd";
        public static final String THREADS = "T";
        public static final String BUILDER = "b";
        public static final String NO_TRANSFER_PROGRESS = "ntp";
        public static final String CACHE_ARTIFACT_NOT_FOUND = "canf";
        public static final String STRICT_ARTIFACT_DESCRIPTOR_POLICY = "sadp";
        public static final String IGNORE_TRANSITIVE_REPOSITORIES = "itr";
        public static final String AT_FILE = "af";

        protected CLIManager() {
        }

        @Override
        protected void prepareOptions(Options options) {
            super.prepareOptions(options);
            options.addOption(Option.builder((String)ALTERNATE_POM_FILE).longOpt("file").hasArg().desc("Force the use of an alternate POM file (or directory with pom.xml)").build());
            options.addOption(Option.builder((String)NON_RECURSIVE).longOpt("non-recursive").desc("Do not recurse into sub-projects. When used together with -pl, do not recurse into sub-projects of selected aggregators").build());
            options.addOption(Option.builder((String)UPDATE_SNAPSHOTS).longOpt("update-snapshots").desc("Forces a check for missing releases and updated snapshots on remote repositories").build());
            options.addOption(Option.builder((String)ACTIVATE_PROFILES).longOpt("activate-profiles").desc("Comma-delimited list of profiles to activate. Prefixing a profile with ! excludes it, and ? marks it as optional").hasArg().build());
            options.addOption(Option.builder((String)SUPPRESS_SNAPSHOT_UPDATES).longOpt("no-snapshot-updates").desc("Suppress SNAPSHOT updates").build());
            options.addOption(Option.builder((String)CHECKSUM_FAILURE_POLICY).longOpt("strict-checksums").desc("Fail the build if checksums don't match").build());
            options.addOption(Option.builder((String)CHECKSUM_WARNING_POLICY).longOpt("lax-checksums").desc("Warn if checksums don't match").build());
            options.addOption(Option.builder((String)FAIL_FAST).longOpt("fail-fast").desc("Stop at first failure in reactorized builds").build());
            options.addOption(Option.builder((String)FAIL_AT_END).longOpt("fail-at-end").desc("Only fail the build afterwards; allow all non-impacted builds to continue").build());
            options.addOption(Option.builder((String)FAIL_NEVER).longOpt("fail-never").desc("NEVER fail the build, regardless of project result").build());
            options.addOption(Option.builder((String)RESUME).longOpt("resume").desc("Resume reactor from the last failed project, using the resume.properties file in the build directory").build());
            options.addOption(Option.builder((String)RESUME_FROM).longOpt("resume-from").hasArg().desc("Resume reactor from specified project").build());
            options.addOption(Option.builder((String)PROJECT_LIST).longOpt("projects").desc("Comma-delimited list of specified reactor projects to build instead of all projects. A project can be specified by [groupId]:artifactId or by its relative path. Prefixing a project with ! excludes it, and ? marks it as optional").hasArg().build());
            options.addOption(Option.builder((String)ALSO_MAKE).longOpt("also-make").desc("If project list is specified, also build projects required by the list").build());
            options.addOption(Option.builder((String)ALSO_MAKE_DEPENDENTS).longOpt("also-make-dependents").desc("If project list is specified, also build projects that depend on projects on the list").build());
            options.addOption(Option.builder((String)THREADS).longOpt("threads").hasArg().desc("Thread count, for instance 4 (int) or 2C/2.5C (int/float) where C is core multiplied").build());
            options.addOption(Option.builder((String)BUILDER).longOpt("builder").hasArg().desc("The id of the build strategy to use").build());
            options.addOption(Option.builder((String)NO_TRANSFER_PROGRESS).longOpt("no-transfer-progress").desc("Do not display transfer progress when downloading or uploading").build());
            options.addOption(Option.builder((String)CACHE_ARTIFACT_NOT_FOUND).longOpt("cache-artifact-not-found").hasArg().desc("Defines caching behaviour for 'not found' artifacts. Supported values are 'true' (default), 'false'.").build());
            options.addOption(Option.builder((String)STRICT_ARTIFACT_DESCRIPTOR_POLICY).longOpt("strict-artifact-descriptor-policy").hasArg().desc("Defines 'strict' artifact descriptor policy. Supported values are 'true', 'false' (default).").build());
            options.addOption(Option.builder((String)IGNORE_TRANSITIVE_REPOSITORIES).longOpt("ignore-transitive-repositories").desc("If set, Maven will ignore remote repositories introduced by transitive dependencies.").build());
            options.addOption(Option.builder((String)AT_FILE).longOpt("at-file").hasArg().desc("If set, Maven will load command line options from the specified file and merge with CLI specified ones.").build());
        }
    }
}

