/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvnenc;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.maven.api.cli.ParserRequest;
import org.apache.maven.api.cli.mvnenc.EncryptOptions;
import org.apache.maven.cling.invoker.CommonsCliOptions;

public class CommonsCliEncryptOptions
extends CommonsCliOptions
implements EncryptOptions {
    public static CommonsCliEncryptOptions parse(String[] args) throws ParseException {
        CLIManager cliManager = new CLIManager();
        return new CommonsCliEncryptOptions("CLI", cliManager, cliManager.parse(args));
    }

    protected CommonsCliEncryptOptions(String source, CLIManager cliManager, CommandLine commandLine) {
        super(source, cliManager, commandLine);
    }

    public Optional<Boolean> force() {
        if (this.commandLine.hasOption("f")) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    public Optional<Boolean> yes() {
        if (this.commandLine.hasOption("y")) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    public Optional<List<String>> goals() {
        if (!this.commandLine.getArgList().isEmpty()) {
            return Optional.of(this.commandLine.getArgList());
        }
        return Optional.empty();
    }

    @Override
    public void displayHelp(ParserRequest request, Consumer<String> printStream) {
        super.displayHelp(request, printStream);
        printStream.accept("");
        printStream.accept("Goals:");
        printStream.accept("  diag - display encryption configuration diagnostic");
        printStream.accept("  init - wizard to configure encryption (interactive only)");
        printStream.accept("  encrypt - encrypts input");
        printStream.accept("  decrypt - decrypts encrypted input");
        printStream.accept("");
    }

    @Override
    protected CommonsCliEncryptOptions copy(String source, CommonsCliOptions.CLIManager cliManager, CommandLine commandLine) {
        return new CommonsCliEncryptOptions(source, (CLIManager)cliManager, commandLine);
    }

    protected static class CLIManager
    extends CommonsCliOptions.CLIManager {
        public static final String FORCE = "f";
        public static final String YES = "y";

        protected CLIManager() {
        }

        @Override
        protected void prepareOptions(Options options) {
            super.prepareOptions(options);
            options.addOption(Option.builder((String)FORCE).longOpt("force").desc("Should overwrite without asking any configuration?").get());
            options.addOption(Option.builder((String)YES).longOpt("yes").desc("Should imply user answered \"yes\" to all incoming questions?").get());
        }
    }
}

