/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.api.ProtoSession;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.services.BaseRequest;
import org.apache.maven.api.services.Request;
import org.apache.maven.api.services.RequestTrace;
import org.apache.maven.api.services.Source;
import org.apache.maven.api.services.Sources;

@Experimental
public interface ToolchainsBuilderRequest
extends Request<ProtoSession> {
    @Nonnull
    public Optional<Source> getInstallationToolchainsSource();

    @Nonnull
    public Optional<Source> getUserToolchainsSource();

    @Nonnull
    public static ToolchainsBuilderRequest build(@Nonnull ProtoSession session, @Nullable Source installationToolchainsFile, @Nullable Source userToolchainsSource) {
        return ToolchainsBuilderRequest.builder().session(Objects.requireNonNull(session, "session cannot be null")).installationToolchainsSource(installationToolchainsFile).userToolchainsSource(userToolchainsSource).build();
    }

    @Nonnull
    public static ToolchainsBuilderRequest build(@Nonnull ProtoSession session, @Nullable Path installationToolchainsFile, @Nullable Path userToolchainsPath) {
        return ToolchainsBuilderRequest.builder().session(Objects.requireNonNull(session, "session cannot be null")).installationToolchainsSource(installationToolchainsFile != null && Files.exists(installationToolchainsFile, new LinkOption[0]) ? Sources.fromPath(installationToolchainsFile) : null).userToolchainsSource(userToolchainsPath != null && Files.exists(userToolchainsPath, new LinkOption[0]) ? Sources.fromPath(userToolchainsPath) : null).build();
    }

    @Nonnull
    public static ToolchainsBuilderRequestBuilder builder() {
        return new ToolchainsBuilderRequestBuilder();
    }

    @NotThreadSafe
    public static class ToolchainsBuilderRequestBuilder {
        ProtoSession session;
        RequestTrace trace;
        Source installationToolchainsSource;
        Source userToolchainsSource;

        public ToolchainsBuilderRequestBuilder session(ProtoSession session) {
            this.session = session;
            return this;
        }

        public ToolchainsBuilderRequestBuilder trace(RequestTrace trace) {
            this.trace = trace;
            return this;
        }

        public ToolchainsBuilderRequestBuilder installationToolchainsSource(Source installationToolchainsSource) {
            this.installationToolchainsSource = installationToolchainsSource;
            return this;
        }

        public ToolchainsBuilderRequestBuilder userToolchainsSource(Source userToolchainsSource) {
            this.userToolchainsSource = userToolchainsSource;
            return this;
        }

        public ToolchainsBuilderRequest build() {
            return new DefaultToolchainsBuilderRequest(this.session, this.trace, this.installationToolchainsSource, this.userToolchainsSource);
        }

        private static class DefaultToolchainsBuilderRequest
        extends BaseRequest<ProtoSession>
        implements ToolchainsBuilderRequest {
            private final Source installationToolchainsSource;
            private final Source userToolchainsSource;

            DefaultToolchainsBuilderRequest(@Nonnull ProtoSession session, @Nullable RequestTrace trace, @Nullable Source installationToolchainsSource, @Nullable Source userToolchainsSource) {
                super(session, trace);
                this.installationToolchainsSource = installationToolchainsSource;
                this.userToolchainsSource = userToolchainsSource;
            }

            @Override
            @Nonnull
            public Optional<Source> getInstallationToolchainsSource() {
                return Optional.ofNullable(this.installationToolchainsSource);
            }

            @Override
            @Nonnull
            public Optional<Source> getUserToolchainsSource() {
                return Optional.ofNullable(this.userToolchainsSource);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean equals(Object o) {
                if (!(o instanceof DefaultToolchainsBuilderRequest)) return false;
                DefaultToolchainsBuilderRequest that = (DefaultToolchainsBuilderRequest)o;
                if (!Objects.equals(this.installationToolchainsSource, that.installationToolchainsSource)) return false;
                if (!Objects.equals(this.userToolchainsSource, that.userToolchainsSource)) return false;
                return true;
            }

            @Override
            public int hashCode() {
                return Objects.hash(this.installationToolchainsSource, this.userToolchainsSource);
            }

            @Override
            public String toString() {
                return "ToolchainsBuilderRequest[installationToolchainsSource=" + String.valueOf(this.installationToolchainsSource) + ", userToolchainsSource=" + String.valueOf(this.userToolchainsSource) + "]";
            }
        }
    }
}

