## Copyright (C) 2025 John Donoghue <john.donoghue@ieee.org>
## 
## This program is free software: you can redistribute it and/or modify it
## under the terms of the GNU General Public License as published by
## the Free Software Foundation, either version 3 of the License, or
## (at your option) any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

## -*- texinfo -*- 
## @deftypefn {} {} visatrigger (@var{dev})
## Trigger a GPIB or VXI visa device.
##
## Ths is ewquivalent to the viAssertTrigger
## VISA sepcification function.
##
## @subsubheading Inputs
## @var{dev} - connected visadev device
##
## @subsubheading Outputs
## None
##
## @seealso{visadev}
## @end deftypefn

function visatrigger (dev)
  __visadev_dispatch__ (dev, 'trigger');
endfunction
