# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.3.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _direction
else:
    import _direction

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class CDirection(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _direction.delete_CDirection

    def theta(self):
        return _direction.CDirection_theta(self)

    def phi(self):
        return _direction.CDirection_phi(self)

    def unitVector(self):
        return _direction.CDirection_unitVector(self)

# Register CDirection in _direction:
_direction.CDirection_swigregister(CDirection)
class CUnitVectorDirection(CDirection):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, arg2, arg3, arg4):
        _direction.CUnitVectorDirection_swiginit(self, _direction.new_CUnitVectorDirection(arg2, arg3, arg4))

    def x(self):
        return _direction.CUnitVectorDirection_x(self)

    def y(self):
        return _direction.CUnitVectorDirection_y(self)

    def z(self):
        return _direction.CUnitVectorDirection_z(self)
    __swig_destroy__ = _direction.delete_CUnitVectorDirection

# Register CUnitVectorDirection in _direction:
_direction.CUnitVectorDirection_swigregister(CUnitVectorDirection)
class CAngleDirection(CDirection):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, arg2, arg3):
        _direction.CAngleDirection_swiginit(self, _direction.new_CAngleDirection(arg2, arg3))
    __swig_destroy__ = _direction.delete_CAngleDirection

# Register CAngleDirection in _direction:
_direction.CAngleDirection_swigregister(CAngleDirection)
# -*- python -*-

# This software was produced by NIST, an agency of the U.S. government,
# and by statute is not subject to copyright in the United States.
# Recipients of this software assume all responsibilities associated
# with its operation, modification and maintenance. However, to
# facilitate maintenance we ask that before distributing modified
# versions of this software, you first contact the authors at
# oof_manager@nist.gov. 

# Wrappers  for   the  CDirection  classes,   so  that  they   can  be
# ConvertibleRegisteredClasses.

## TODO: Allow ConvertibleRegisteredClasses to be implemented in C++
## and get rid of these wrappers.  See orientationmatrix.py for more
## comments in a similar situation.

from ooflib.common import debug
from ooflib.common import registeredclass
from ooflib.common.IO import parameter

import math

class Direction(registeredclass.ConvertibleRegisteredClass):
    registry = []
    tip="Ways of representing a direction in 3D space."
    discussion="""<para>Don't confuse this with an <xref
    linkend='RegisteredClass-Orientation'/>, which describes how a
    crystal lattice is oriented.  This describes how an arrow is
    oriented.</para>"""
    xrefs = ["MenuItem-OOF.OrientationMap.Pole_Figure"]
    def unitVector(self):
        return self.cdirection.unitVector()

class DirectionRegistration(registeredclass.ConvertibleRegistration):
    def __init__(self, name, subclass, ordering,
                 from_base, params=[], tip=None, discussion=None):
        registeredclass.ConvertibleRegistration.__init__(
            self, name,
            Direction, subclass, ordering,
            from_base=from_base,
            params=params,
            tip=tip, discussion=discussion)
    def getParamValuesAsBase(self):
        temp = self()
        return temp.unitVector()

class VectorDirection(Direction):
    def __init__(self, x, y, z):
        self.cdirection = CUnitVectorDirection(x, y, z)
        self.x = x
        self.y = y
        self.z = z

def _vector_from_base(base):
    return [base.x(), base.y(), base.z()]

DirectionRegistration(
    'Vector',
    VectorDirection,
    1,
    from_base=_vector_from_base,
    params=[
        parameter.FloatParameter(
            'x', 0, tip="The x component of the direction."),
        parameter.FloatParameter(
            'y', 0, tip="The y component of the direction."),
        parameter.FloatParameter(
            'z', 0, tip="The z component of the direction.")],
    tip="A direction in space in the form of a vector.  ",
    discussion="""<para>Specify a direction in 3-space by giving the
    components of a vector. The input vector does not need to be
    normalized.</para>"""
    )

class AngleDirection(Direction):
    def __init__(self, theta, phi):
        self.cdirection = CAngleDirection(theta*math.pi/180, phi*math.pi/180)
        self.theta = theta
        self.phi = phi

def _angle_from_base(base):
    return [base.theta()*180/math.pi, base.phi()*180/math.pi]

DirectionRegistration(
    'Angles',
    AngleDirection,
    2,
    from_base=_angle_from_base,
    params=[
        parameter.FloatRangeParameter(
            'theta', (0, 180, 1), 0.0,
            tip="Inclination from the z axis, in degrees."),
        parameter.FloatRangeParameter(
            'phi', (0, 360, 1), 0.0,
            tip="Azimuth from the x axis, in degrees.")],
    tip="A direction in space in the form of inclination and azimuth.",
    discussion="<para>Use angles to specify a direction in 3-space.</para>")



