'use strict';
/*!
 * Copyright (c) Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
(function(root, factory) {
  const bokeh = factory();
  bokeh.__bokeh__ = true;
  if (typeof root.Bokeh === "undefined" || typeof root.Bokeh.__bokeh__ === "undefined") {
    root.Bokeh = bokeh;
  }
  const Bokeh = root.Bokeh;
  Bokeh[bokeh.version] = bokeh;
})(this, function() {
  let define;
  const parent_require = typeof require === "function" && require
  return (function(modules, entry, aliases, externals) {
  if (aliases === undefined) aliases = {};
  if (externals === undefined) externals = {};

  const cache = {};

  const normalize = function(name) {
    if (typeof name === "number")
      return name;

    if (name === "bokehjs")
      return entry;

    if (!externals[name]) {
      const prefix = "@bokehjs/"
      if (name.slice(0, prefix.length) === prefix)
        name = name.slice(prefix.length)
    }

    const alias = aliases[name]
    if (alias != null)
      return alias;

    const trailing = name.length > 0 && name[name.length-1] === "/";
    const index = aliases[name + (trailing ? "" : "/") + "index"];
    if (index != null)
      return index;

    return name;
  }

  const require = function(name) {
    let mod = cache[name];
    if (!mod) {
      const id = normalize(name);

      mod = cache[id];
      if (!mod) {
        if (!modules[id]) {
          if (externals[id] === false || (externals[id] == true && parent_require)) {
            try {
              mod = {exports: externals[id] ? parent_require(id) : {}};
              cache[id] = cache[name] = mod;
              return mod.exports;
            } catch (e) {}
          }

          const err = new Error("Cannot find module '" + name + "'");
          err.code = 'MODULE_NOT_FOUND';
          throw err;
        }

        mod = {exports: {}};
        cache[id] = cache[name] = mod;

        function __esModule() {
          Object.defineProperty(mod.exports, "__esModule", {value: true});
        }

        function __esExport(name, value) {
          Object.defineProperty(mod.exports, name, {
            enumerable: true, get: function () { return value; }
          });
        }

        modules[id].call(mod.exports, require, mod, mod.exports, __esModule, __esExport);
      } else {
        cache[name] = mod;
      }
    }

    return mod.exports;
  }
  require.resolve = function(name) {
    return ""
  }

  const main = require(entry);
  main.require = require;

  if (typeof Proxy !== "undefined") {
    // allow Bokeh.loader["@bokehjs/module/name"] syntax
    main.loader = new Proxy({}, {
      get: function(_obj, module) {
        return require(module);
      }
    });
  }

  main.register_plugin = function(plugin_modules, plugin_entry, plugin_aliases, plugin_externals) {
    if (plugin_aliases === undefined) plugin_aliases = {};
    if (plugin_externals === undefined) plugin_externals = {};

    for (let name in plugin_modules) {
      modules[name] = plugin_modules[name];
    }

    for (let name in plugin_aliases) {
      aliases[name] = plugin_aliases[name];
    }

    for (let name in plugin_externals) {
      externals[name] = plugin_externals[name];
    }

    const plugin = require(plugin_entry);

    for (let name in plugin) {
      main[name] = plugin[name];
    }

    return plugin;
  }

  return main;
})
([
/* main.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    tslib_1.__exportStar(require(2) /* ./index */, exports);
    // TODO: remove this when models are split up from core
    require(76) /* ./models/main */;
},
/* tslib/tslib.es6.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.__extends = __extends;
    exports.__rest = __rest;
    exports.__decorate = __decorate;
    exports.__param = __param;
    exports.__esDecorate = __esDecorate;
    exports.__runInitializers = __runInitializers;
    exports.__propKey = __propKey;
    exports.__setFunctionName = __setFunctionName;
    exports.__metadata = __metadata;
    exports.__awaiter = __awaiter;
    exports.__generator = __generator;
    exports.__exportStar = __exportStar;
    exports.__values = __values;
    exports.__read = __read;
    exports.__spread = __spread;
    exports.__spreadArrays = __spreadArrays;
    exports.__spreadArray = __spreadArray;
    exports.__await = __await;
    exports.__asyncGenerator = __asyncGenerator;
    exports.__asyncDelegator = __asyncDelegator;
    exports.__asyncValues = __asyncValues;
    exports.__makeTemplateObject = __makeTemplateObject;
    exports.__importStar = __importStar;
    exports.__importDefault = __importDefault;
    exports.__classPrivateFieldGet = __classPrivateFieldGet;
    exports.__classPrivateFieldSet = __classPrivateFieldSet;
    exports.__classPrivateFieldIn = __classPrivateFieldIn;
    exports.__addDisposableResource = __addDisposableResource;
    exports.__disposeResources = __disposeResources;
    exports.__rewriteRelativeImportExtension = __rewriteRelativeImportExtension;
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) {
                for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p];
            };
        return extendStatics(d, b);
    };
    function __extends(d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    }
    var __assign = function () {
        exports.__assign = Object.assign || function __assign(t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return exports.__assign.apply(this, arguments);
    };
    exports.__assign = __assign;
    function __rest(s, e) {
        var t = {};
        for (var p in s)
            if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
                t[p] = s[p];
        if (s != null && typeof Object.getOwnPropertySymbols === "function")
            for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
                if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                    t[p[i]] = s[p[i]];
            }
        return t;
    }
    function __decorate(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }
    function __param(paramIndex, decorator) {
        return function (target, key) { decorator(target, key, paramIndex); };
    }
    function __esDecorate(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
        function accept(f) {
            if (f !== void 0 && typeof f !== "function")
                throw new TypeError("Function expected");
            return f;
        }
        var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
        var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
        var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
        var _, done = false;
        for (var i = decorators.length - 1; i >= 0; i--) {
            var context = {};
            for (var p in contextIn)
                context[p] = p === "access" ? {} : contextIn[p];
            for (var p in contextIn.access)
                context.access[p] = contextIn.access[p];
            context.addInitializer = function (f) {
                if (done)
                    throw new TypeError("Cannot add initializers after decoration has completed");
                extraInitializers.push(accept(f || null));
            };
            var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
            if (kind === "accessor") {
                if (result === void 0)
                    continue;
                if (result === null || typeof result !== "object")
                    throw new TypeError("Object expected");
                if (_ = accept(result.get))
                    descriptor.get = _;
                if (_ = accept(result.set))
                    descriptor.set = _;
                if (_ = accept(result.init))
                    initializers.unshift(_);
            }
            else if (_ = accept(result)) {
                if (kind === "field")
                    initializers.unshift(_);
                else
                    descriptor[key] = _;
            }
        }
        if (target)
            Object.defineProperty(target, contextIn.name, descriptor);
        done = true;
    }
    ;
    function __runInitializers(thisArg, initializers, value) {
        var useValue = arguments.length > 2;
        for (var i = 0; i < initializers.length; i++) {
            value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
        }
        return useValue ? value : void 0;
    }
    ;
    function __propKey(x) {
        return typeof x === "symbol" ? x : "".concat(x);
    }
    ;
    function __setFunctionName(f, name, prefix) {
        if (typeof name === "symbol")
            name = name.description ? "[".concat(name.description, "]") : "";
        return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
    }
    ;
    function __metadata(metadataKey, metadataValue) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
            return Reflect.metadata(metadataKey, metadataValue);
    }
    function __awaiter(thisArg, _arguments, P, generator) {
        function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
        return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) {
                try {
                    step(generator.next(value));
                }
                catch (e) {
                    reject(e);
                }
            }
            function rejected(value) {
                try {
                    step(generator["throw"](value));
                }
                catch (e) {
                    reject(e);
                }
            }
            function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
            step((generator = generator.apply(thisArg, _arguments || [])).next());
        });
    }
    function __generator(thisArg, body) {
        var _ = { label: 0, sent: function () {
                if (t[0] & 1)
                    throw t[1];
                return t[1];
            }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
        return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function () { return this; }), g;
        function verb(n) { return function (v) { return step([n, v]); }; }
        function step(op) {
            if (f)
                throw new TypeError("Generator is already executing.");
            while (g && (g = 0, op[0] && (_ = 0)), _)
                try {
                    if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done)
                        return t;
                    if (y = 0, t)
                        op = [op[0] & 2, t.value];
                    switch (op[0]) {
                        case 0:
                        case 1:
                            t = op;
                            break;
                        case 4:
                            _.label++;
                            return { value: op[1], done: false };
                        case 5:
                            _.label++;
                            y = op[1];
                            op = [0];
                            continue;
                        case 7:
                            op = _.ops.pop();
                            _.trys.pop();
                            continue;
                        default:
                            if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                                _ = 0;
                                continue;
                            }
                            if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) {
                                _.label = op[1];
                                break;
                            }
                            if (op[0] === 6 && _.label < t[1]) {
                                _.label = t[1];
                                t = op;
                                break;
                            }
                            if (t && _.label < t[2]) {
                                _.label = t[2];
                                _.ops.push(op);
                                break;
                            }
                            if (t[2])
                                _.ops.pop();
                            _.trys.pop();
                            continue;
                    }
                    op = body.call(thisArg, _);
                }
                catch (e) {
                    op = [6, e];
                    y = 0;
                }
                finally {
                    f = t = 0;
                }
            if (op[0] & 5)
                throw op[1];
            return { value: op[0] ? op[1] : void 0, done: true };
        }
    }
    exports.__createBinding = Object.create ? (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        var desc = Object.getOwnPropertyDescriptor(m, k);
        if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
            desc = { enumerable: true, get: function () { return m[k]; } };
        }
        Object.defineProperty(o, k2, desc);
    }) : (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        o[k2] = m[k];
    });
    function __exportStar(m, o) {
        for (var p in m)
            if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p))
                (0, exports.__createBinding)(o, m, p);
    }
    function __values(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    }
    function __read(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    }
    /** @deprecated */
    function __spread() {
        for (var ar = [], i = 0; i < arguments.length; i++)
            ar = ar.concat(__read(arguments[i]));
        return ar;
    }
    /** @deprecated */
    function __spreadArrays() {
        for (var s = 0, i = 0, il = arguments.length; i < il; i++)
            s += arguments[i].length;
        for (var r = Array(s), k = 0, i = 0; i < il; i++)
            for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
                r[k] = a[j];
        return r;
    }
    function __spreadArray(to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    }
    function __await(v) {
        return this instanceof __await ? (this.v = v, this) : new __await(v);
    }
    function __asyncGenerator(thisArg, _arguments, generator) {
        if (!Symbol.asyncIterator)
            throw new TypeError("Symbol.asyncIterator is not defined.");
        var g = generator.apply(thisArg, _arguments || []), i, q = [];
        return i = Object.create((typeof AsyncIterator === "function" ? AsyncIterator : Object).prototype), verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function () { return this; }, i;
        function awaitReturn(f) { return function (v) { return Promise.resolve(v).then(f, reject); }; }
        function verb(n, f) {
            if (g[n]) {
                i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); };
                if (f)
                    i[n] = f(i[n]);
            }
        }
        function resume(n, v) {
            try {
                step(g[n](v));
            }
            catch (e) {
                settle(q[0][3], e);
            }
        }
        function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
        function fulfill(value) { resume("next", value); }
        function reject(value) { resume("throw", value); }
        function settle(f, v) {
            if (f(v), q.shift(), q.length)
                resume(q[0][0], q[0][1]);
        }
    }
    function __asyncDelegator(o) {
        var i, p;
        return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
        function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }
    }
    function __asyncValues(o) {
        if (!Symbol.asyncIterator)
            throw new TypeError("Symbol.asyncIterator is not defined.");
        var m = o[Symbol.asyncIterator], i;
        return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
        function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
        function settle(resolve, reject, d, v) { Promise.resolve(v).then(function (v) { resolve({ value: v, done: d }); }, reject); }
    }
    function __makeTemplateObject(cooked, raw) {
        if (Object.defineProperty) {
            Object.defineProperty(cooked, "raw", { value: raw });
        }
        else {
            cooked.raw = raw;
        }
        return cooked;
    }
    ;
    var __setModuleDefault = Object.create ? (function (o, v) {
        Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function (o, v) {
        o["default"] = v;
    };
    var ownKeys = function (o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o)
                if (Object.prototype.hasOwnProperty.call(o, k))
                    ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    function __importStar(mod) {
        if (mod && mod.__esModule)
            return mod;
        var result = {};
        if (mod != null)
            for (var k = ownKeys(mod), i = 0; i < k.length; i++)
                if (k[i] !== "default")
                    (0, exports.__createBinding)(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    }
    function __importDefault(mod) {
        return (mod && mod.__esModule) ? mod : { default: mod };
    }
    function __classPrivateFieldGet(receiver, state, kind, f) {
        if (kind === "a" && !f)
            throw new TypeError("Private accessor was defined without a getter");
        if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver))
            throw new TypeError("Cannot read private member from an object whose class did not declare it");
        return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
    }
    function __classPrivateFieldSet(receiver, state, value, kind, f) {
        if (kind === "m")
            throw new TypeError("Private method is not writable");
        if (kind === "a" && !f)
            throw new TypeError("Private accessor was defined without a setter");
        if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver))
            throw new TypeError("Cannot write private member to an object whose class did not declare it");
        return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
    }
    function __classPrivateFieldIn(state, receiver) {
        if (receiver === null || (typeof receiver !== "object" && typeof receiver !== "function"))
            throw new TypeError("Cannot use 'in' operator on non-object");
        return typeof state === "function" ? receiver === state : state.has(receiver);
    }
    function __addDisposableResource(env, value, async) {
        if (value !== null && value !== void 0) {
            if (typeof value !== "object" && typeof value !== "function")
                throw new TypeError("Object expected.");
            var dispose, inner;
            if (async) {
                if (!Symbol.asyncDispose)
                    throw new TypeError("Symbol.asyncDispose is not defined.");
                dispose = value[Symbol.asyncDispose];
            }
            if (dispose === void 0) {
                if (!Symbol.dispose)
                    throw new TypeError("Symbol.dispose is not defined.");
                dispose = value[Symbol.dispose];
                if (async)
                    inner = dispose;
            }
            if (typeof dispose !== "function")
                throw new TypeError("Object not disposable.");
            if (inner)
                dispose = function () {
                    try {
                        inner.call(this);
                    }
                    catch (e) {
                        return Promise.reject(e);
                    }
                };
            env.stack.push({ value: value, dispose: dispose, async: async });
        }
        else if (async) {
            env.stack.push({ async: true });
        }
        return value;
    }
    var _SuppressedError = typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
        var e = new Error(message);
        return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
    };
    function __disposeResources(env) {
        function fail(e) {
            env.error = env.hasError ? new _SuppressedError(e, env.error, "An error was suppressed during disposal.") : e;
            env.hasError = true;
        }
        var r, s = 0;
        function next() {
            while (r = env.stack.pop()) {
                try {
                    if (!r.async && s === 1)
                        return s = 0, env.stack.push(r), Promise.resolve().then(next);
                    if (r.dispose) {
                        var result = r.dispose.call(r.value);
                        if (r.async)
                            return s |= 2, Promise.resolve(result).then(next, function (e) { fail(e); return next(); });
                    }
                    else
                        s |= 1;
                }
                catch (e) {
                    fail(e);
                }
            }
            if (s === 1)
                return env.hasError ? Promise.reject(env.error) : Promise.resolve();
            if (env.hasError)
                throw env.error;
        }
        return next();
    }
    function __rewriteRelativeImportExtension(path, preserveJsx) {
        if (typeof path === "string" && /^\.\.?\//.test(path)) {
            return path.replace(/\.(tsx)$|((?:\.d)?)((?:\.[^./]+?)?)\.([cm]?)ts$/i, function (m, tsx, d, ext, cm) {
                return tsx ? preserveJsx ? ".jsx" : ".js" : d && (!ext || !cm) ? m : (d + ext + "." + cm.toLowerCase() + "js");
            });
        }
        return path;
    }
    exports.default = {
        __extends: __extends,
        __assign: exports.__assign,
        __rest: __rest,
        __decorate: __decorate,
        __param: __param,
        __esDecorate: __esDecorate,
        __runInitializers: __runInitializers,
        __propKey: __propKey,
        __setFunctionName: __setFunctionName,
        __metadata: __metadata,
        __awaiter: __awaiter,
        __generator: __generator,
        __createBinding: exports.__createBinding,
        __exportStar: __exportStar,
        __values: __values,
        __read: __read,
        __spread: __spread,
        __spreadArrays: __spreadArrays,
        __spreadArray: __spreadArray,
        __await: __await,
        __asyncGenerator: __asyncGenerator,
        __asyncDelegator: __asyncDelegator,
        __asyncValues: __asyncValues,
        __makeTemplateObject: __makeTemplateObject,
        __importStar: __importStar,
        __importDefault: __importDefault,
        __classPrivateFieldGet: __classPrivateFieldGet,
        __classPrivateFieldSet: __classPrivateFieldSet,
        __classPrivateFieldIn: __classPrivateFieldIn,
        __addDisposableResource: __addDisposableResource,
        __disposeResources: __disposeResources,
        __rewriteRelativeImportExtension: __rewriteRelativeImportExtension,
    };
},
/* index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var version_1 = require(3) /* ./version */;
    __esExport("version", version_1.version);
    var embed_1 = require(4) /* ./embed */;
    __esExport("index", embed_1.index);
    exports.embed = tslib_1.__importStar(require(4) /* ./embed */);
    exports.protocol = tslib_1.__importStar(require(74) /* ./protocol */);
    var logging_1 = require(20) /* ./core/logging */;
    __esExport("logger", logging_1.logger);
    __esExport("set_log_level", logging_1.set_log_level);
    var settings_1 = require(30) /* ./core/settings */;
    __esExport("settings", settings_1.settings);
    var base_1 = require(7) /* ./base */;
    __esExport("Models", base_1.Models);
    var document_1 = require(5) /* ./document */;
    __esExport("documents", document_1.documents);
    var safely_1 = require(75) /* ./safely */;
    __esExport("safely", safely_1.safely);
},
/* version.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.version = "3.7.2";
},
/* embed/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.embed_item = embed_item;
    exports.embed_items = embed_items;
    const document_1 = require(5) /* ../document */;
    const settings_1 = require(30) /* ../core/settings */;
    const logging_1 = require(20) /* ../core/logging */;
    const string_1 = require(40) /* ../core/util/string */;
    const object_1 = require(9) /* ../core/util/object */;
    const types_1 = require(8) /* ../core/util/types */;
    const defer_1 = require(17) /* ../core/util/defer */;
    const standalone_1 = require(54) /* ./standalone */;
    const server_1 = require(67) /* ./server */;
    const dom_1 = require(72) /* ./dom */;
    var standalone_2 = require(54) /* ./standalone */;
    __esExport("add_document_standalone", standalone_2.add_document_standalone);
    __esExport("index", standalone_2.index);
    var server_2 = require(67) /* ./server */;
    __esExport("add_document_from_session", server_2.add_document_from_session);
    var notebook_1 = require(73) /* ./notebook */;
    __esExport("embed_items_notebook", notebook_1.embed_items_notebook);
    __esExport("kernels", notebook_1.kernels);
    async function embed_item(item, target) {
        const docs_json = {};
        const doc_id = (0, string_1.uuid4)();
        docs_json[doc_id] = item.doc;
        if (target == null) {
            target = item.target_id;
        }
        const roots = { [item.root_id]: target };
        const render_item = { roots, root_ids: [item.root_id], docid: doc_id };
        await (0, defer_1.defer)();
        const [views] = await _embed_items(docs_json, [render_item]);
        return views;
    }
    // TODO (bev) this is currently clunky. Standalone embeds only provide
    // the first two args, whereas server provide the app_app, and *may* prove and
    // absolute_url as well if non-relative links are needed for resources. This function
    // should probably be split in to two pieces to reflect the different usage patterns
    async function embed_items(docs_json, render_items, app_path, absolute_url) {
        await (0, defer_1.defer)();
        return _embed_items(docs_json, render_items, app_path, absolute_url);
    }
    async function _embed_items(docs_json, render_items, app_path, absolute_url) {
        if ((0, types_1.isString)(docs_json)) {
            docs_json = JSON.parse((0, string_1.unescape)(docs_json));
        }
        const docs = {};
        for (const [docid, doc_json] of (0, object_1.entries)(docs_json)) {
            docs[docid] = document_1.Document.from_json(doc_json);
        }
        const views = [];
        for (const item of render_items) {
            const element = (0, dom_1._resolve_element)(item);
            const roots = (0, dom_1._resolve_root_elements)(item);
            if (item.docid != null) {
                views.push(await (0, standalone_1.add_document_standalone)(docs[item.docid], element, roots, item.use_for_title));
            }
            else if (item.token != null) {
                const websocket_url = (0, server_1._get_ws_url)(app_path, absolute_url);
                logging_1.logger.debug(`embed: computed ws url: ${websocket_url}`);
                try {
                    views.push(await (0, server_1.add_document_from_session)(websocket_url, item.token, element, roots, item.use_for_title));
                    console.log("Bokeh items were rendered successfully");
                }
                catch (error) {
                    if (settings_1.settings.dev) {
                        throw error;
                    }
                    else {
                        console.error("Error rendering Bokeh items:", error);
                    }
                }
            }
            else {
                throw new Error("Error rendering Bokeh items: either 'docid' or 'token' was expected.");
            }
        }
        return views;
    }
},
/* document/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    tslib_1.__exportStar(require(6) /* ./document */, exports);
    tslib_1.__exportStar(require(41) /* ./events */, exports);
},
/* document/document.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const base_1 = require(7) /* ../base */;
    const version_1 = require(3) /* ../version */;
    const logging_1 = require(20) /* ../core/logging */;
    const has_props_1 = require(15) /* ../core/has_props */;
    const resolvers_1 = require(46) /* ../core/resolvers */;
    const serialization_1 = require(33) /* ../core/serialization */;
    const deserializer_1 = require(47) /* ../core/serialization/deserializer */;
    const version_2 = require(49) /* ../core/util/version */;
    const signaling_1 = require(16) /* ../core/signaling */;
    const types_1 = require(8) /* ../core/util/types */;
    const eq_1 = require(27) /* ../core/util/eq */;
    const array_1 = require(10) /* ../core/util/array */;
    const object_1 = require(9) /* ../core/util/object */;
    const sets = tslib_1.__importStar(require(44) /* ../core/util/set */);
    const callbacks_1 = require(50) /* ../core/util/callbacks */;
    const assert_1 = require(12) /* ../core/util/assert */;
    const model_1 = require(51) /* ../model */;
    const defs_1 = require(52) /* ./defs */;
    const bokeh_events_1 = require(53) /* ../core/bokeh_events */;
    const bokeh_events_2 = require(53) /* ../core/bokeh_events */;
    const events_1 = require(41) /* ./events */;
    deserializer_1.Deserializer.register("model", defs_1.decode_def);
    // Dispatches events to the subscribed models
    class EventManager {
        constructor(document) {
            this.subscribed_models = new Set();
            this.document = document;
        }
        send_event(bokeh_event) {
            if (bokeh_event.publish) {
                const event = new events_1.MessageSentEvent(this.document, "bokeh_event", bokeh_event);
                this.document._trigger_on_change(event);
            }
            this.document._trigger_on_event(bokeh_event);
        }
        trigger(event) {
            for (const model of this.subscribed_models) {
                if (event.origin != null && event.origin != model) {
                    continue;
                }
                model._process_event(event);
            }
        }
    }
    exports.EventManager = EventManager;
    EventManager.__name__ = "EventManager";
    exports.documents = [];
    exports.DEFAULT_TITLE = "Bokeh Application";
    // This class should match the API of the Python Document class
    // as much as possible.
    class Document {
        constructor(options = {}) {
            this._hold_models_freeze = false;
            this._recompute_timer = null;
            exports.documents.push(this);
            this._init_timestamp = Date.now();
            this._resolver = options.resolver ?? new resolvers_1.ModelResolver(base_1.default_resolver);
            this._title = exports.DEFAULT_TITLE;
            this._roots = [];
            this._all_models = new Map();
            this._new_models = new Set();
            this._all_models_freeze_count = 0;
            this._callbacks = new Map();
            this._document_callbacks = new Map();
            this._message_callbacks = new Map();
            this.event_manager = new EventManager(this);
            this.idle = new signaling_1.Signal0(this, "idle");
            this._idle_roots = new WeakSet();
            this._interactive_timestamp = null;
            this._interactive_plot = null;
            this._recompute_timeout = options.recompute_timeout ?? 30000; /* 30s */
            if (options.roots != null) {
                this._add_roots(...options.roots);
            }
            this.on_message("bokeh_event", (event) => {
                (0, assert_1.assert)(event instanceof bokeh_events_1.ModelEvent);
                this.event_manager.trigger(event);
            });
        }
        [eq_1.equals](that, _cmp) {
            return this == that;
        }
        get all_models() {
            return new Set(this._all_models.values());
        }
        get is_idle() {
            // TODO: models without views, e.g. data models
            for (const root of this._roots) {
                if (!this._idle_roots.has(root)) {
                    return false;
                }
            }
            return true;
        }
        notify_idle(model) {
            this._idle_roots.add(model);
            if (this.is_idle) {
                logging_1.logger.info(`document idle at ${Date.now() - this._init_timestamp} ms`);
                this.event_manager.send_event(new bokeh_events_2.DocumentReady());
                this.idle.emit();
            }
        }
        clear() {
            this._push_all_models_freeze();
            try {
                while (this._roots.length > 0) {
                    this.remove_root(this._roots[0]);
                }
            }
            finally {
                this._pop_all_models_freeze();
            }
        }
        interactive_start(plot, finalize = null) {
            if (this._interactive_plot == null) {
                this._interactive_plot = plot;
                this._interactive_plot.trigger_event(new bokeh_events_2.LODStart());
            }
            this._interactive_finalize = finalize;
            this._interactive_timestamp = Date.now();
        }
        interactive_stop() {
            if (this._interactive_plot != null) {
                this._interactive_plot.trigger_event(new bokeh_events_2.LODEnd());
                if (this._interactive_finalize != null) {
                    this._interactive_finalize();
                }
            }
            this._interactive_plot = null;
            this._interactive_timestamp = null;
            this._interactive_finalize = null;
        }
        interactive_duration() {
            if (this._interactive_timestamp == null) {
                return -1;
            }
            else {
                return Date.now() - this._interactive_timestamp;
            }
        }
        destructively_move(dest_doc) {
            if (dest_doc === this) {
                throw new Error("Attempted to overwrite a document with itself");
            }
            dest_doc.clear();
            // we have to remove ALL roots before adding any
            // to the new doc or else models referenced from multiple
            // roots could be in both docs at once, which isn't allowed.
            const roots = (0, array_1.copy)(this._roots);
            this.clear();
            for (const root of roots) {
                if (root.document != null) {
                    throw new Error(`Somehow we didn't detach ${root}`);
                }
            }
            if (this._all_models.size != 0) {
                throw new Error(`this._all_models still had stuff in it: ${this._all_models}`);
            }
            for (const root of roots) {
                dest_doc.add_root(root);
            }
            dest_doc.set_title(this._title);
        }
        _push_all_models_freeze() {
            if (this._hold_models_freeze) {
                return;
            }
            this._all_models_freeze_count += 1;
        }
        _pop_all_models_freeze() {
            if (this._hold_models_freeze) {
                return;
            }
            this._all_models_freeze_count -= 1;
            if (this._all_models_freeze_count === 0) {
                this._recompute_all_models();
            }
        }
        _cancel_recompute_all_models() {
            if (this._recompute_timer != null) {
                clearTimeout(this._recompute_timer);
                this._recompute_timer = null;
            }
        }
        _schedule_recompute_all_models() {
            const timeout = this._recompute_timeout;
            if (isNaN(timeout) || timeout <= 0) {
                this._recompute_all_models();
            }
            else if (isFinite(timeout)) {
                this._cancel_recompute_all_models();
                this._recompute_timer = setTimeout(() => {
                    this._recompute_all_models();
                }, timeout);
            }
        }
        _recompute_all_models() {
            this._cancel_recompute_all_models();
            let new_all_models_set = new Set();
            for (const r of this._roots) {
                new_all_models_set = sets.union(new_all_models_set, r.references());
            }
            const old_all_models_set = new Set(this._all_models.values());
            const to_detach = sets.difference(old_all_models_set, new_all_models_set);
            const to_attach = sets.difference(new_all_models_set, old_all_models_set);
            const recomputed = new Map();
            for (const model of new_all_models_set) {
                recomputed.set(model.id, model);
            }
            for (const d of to_detach) {
                d.detach_document();
            }
            for (const model of to_attach) {
                model.attach_document(this);
                this._new_models.add(model);
            }
            this._all_models = recomputed;
        }
        partially_update_all_models(value) {
            const refs = new Set();
            has_props_1.HasProps._value_record_references(value, refs, { recursive: false });
            for (const ref of refs) {
                if (!this._all_models.has(ref.id)) {
                    ref.attach_document(this);
                    this._new_models.add(ref);
                    this._all_models.set(ref.id, ref);
                }
            }
            this._schedule_recompute_all_models();
        }
        roots() {
            return this._roots;
        }
        _add_roots(...models) {
            models = models.filter((model) => !this._roots.includes(model));
            if (models.length == 0) {
                return false;
            }
            this._push_all_models_freeze();
            try {
                this._roots.push(...models);
            }
            finally {
                this._pop_all_models_freeze();
            }
            return true;
        }
        _remove_root(model) {
            const i = this._roots.indexOf(model);
            if (i < 0) {
                return false;
            }
            this._push_all_models_freeze();
            try {
                this._roots.splice(i, 1);
            }
            finally {
                this._pop_all_models_freeze();
            }
            return true;
        }
        _set_title(title) {
            const new_title = title != this._title;
            if (new_title) {
                this._title = title;
            }
            return new_title;
        }
        add_root(model, { sync } = {}) {
            if (this._add_roots(model)) {
                const event = new events_1.RootAddedEvent(this, model);
                event.sync = sync ?? true;
                this._trigger_on_change(event);
            }
        }
        remove_root(model, { sync } = {}) {
            if (this._remove_root(model)) {
                const event = new events_1.RootRemovedEvent(this, model);
                event.sync = sync ?? true;
                this._trigger_on_change(event);
            }
        }
        set_title(title, { sync } = {}) {
            if (this._set_title(title)) {
                const event = new events_1.TitleChangedEvent(this, title);
                event.sync = sync ?? true;
                this._trigger_on_change(event);
            }
        }
        title() {
            return this._title;
        }
        get_model_by_id(model_id) {
            return this._all_models.get(model_id) ?? null;
        }
        get_model_by_name(name) {
            const found = [];
            for (const model of this._all_models.values()) {
                if (model instanceof model_1.Model && model.name == name) {
                    found.push(model);
                }
            }
            switch (found.length) {
                case 0:
                    return null;
                case 1:
                    return found[0];
                default:
                    throw new Error(`Multiple models are named '${name}'`);
            }
        }
        on_message(msg_type, callback) {
            const message_callbacks = this._message_callbacks.get(msg_type);
            if (message_callbacks == null) {
                this._message_callbacks.set(msg_type, new Set([callback]));
            }
            else {
                message_callbacks.add(callback);
            }
        }
        remove_on_message(msg_type, callback) {
            this._message_callbacks.get(msg_type)?.delete(callback);
        }
        _trigger_on_message(msg_type, msg_data) {
            const message_callbacks = this._message_callbacks.get(msg_type);
            if (message_callbacks != null) {
                for (const cb of message_callbacks) {
                    cb(msg_data);
                }
            }
        }
        on_change(callback, allow_batches = false) {
            if (!this._callbacks.has(callback)) {
                this._callbacks.set(callback, allow_batches);
            }
        }
        remove_on_change(callback) {
            this._callbacks.delete(callback);
        }
        _trigger_on_change(event) {
            for (const [callback, allow_batches] of this._callbacks) {
                if (!allow_batches && event instanceof events_1.DocumentEventBatch) {
                    for (const ev of event.events) {
                        callback(ev);
                    }
                }
                else {
                    callback(event); // TODO
                }
            }
        }
        _trigger_on_event(event) {
            const callbacks = this._document_callbacks.get(event.event_name);
            if (callbacks != null) {
                for (const callback of callbacks) {
                    void (0, callbacks_1.execute)(callback, this, event);
                }
            }
        }
        on_event(event, ...callbacks) {
            const name = (0, types_1.isString)(event) ? event : event.prototype.event_name;
            const existing = this._document_callbacks.get(name) ?? [];
            const added = callbacks;
            this._document_callbacks.set(name, [...existing, ...added]);
        }
        to_json_string(include_defaults = true) {
            return JSON.stringify(this.to_json(include_defaults));
        }
        to_json(include_defaults = true) {
            const serializer = new serialization_1.Serializer({ include_defaults });
            const roots = serializer.encode(this._roots);
            return {
                version: version_1.version,
                title: this._title,
                roots,
            };
        }
        static from_json_string(s, events) {
            const json = JSON.parse(s);
            return Document.from_json(json, events);
        }
        static _handle_version(json) {
            if (json.version == null) {
                logging_1.logger.warn("'version' field is missing");
            }
            const py_version = json.version ?? "0.0.0";
            const py_ver = version_2.Version.from(py_version);
            const js_ver = version_2.Version.from(version_1.version);
            const message = `new document using Bokeh ${py_version} and BokehJS ${version_1.version}`;
            if ((0, eq_1.is_equal)(py_ver, js_ver)) {
                logging_1.logger.debug(message);
            }
            else {
                logging_1.logger.warn(`Bokeh/BokehJS version mismatch: ${message}`);
            }
        }
        static from_json(doc_json, events) {
            logging_1.logger.debug("Creating Document from JSON");
            Document._handle_version(doc_json);
            const resolver = new resolvers_1.ModelResolver(base_1.default_resolver);
            if (doc_json.defs != null) {
                const deserializer = new deserializer_1.Deserializer(resolver);
                deserializer.decode(doc_json.defs);
            }
            const doc = new Document({ resolver });
            doc._push_all_models_freeze();
            const listener = (event) => events?.push(event);
            doc.on_change(listener, true);
            const deserializer = new deserializer_1.Deserializer(resolver, doc._all_models, (obj) => obj.attach_document(doc));
            const roots = deserializer.decode(doc_json.roots);
            const callbacks = (() => {
                if (doc_json.callbacks != null) {
                    return deserializer.decode(doc_json.callbacks);
                }
                else {
                    return {};
                }
            })();
            doc.remove_on_change(listener);
            for (const [event, event_callbacks] of (0, object_1.entries)(callbacks)) {
                doc.on_event(event, ...event_callbacks);
            }
            for (const root of roots) {
                doc.add_root(root);
            }
            if (doc_json.title != null) {
                doc.set_title(doc_json.title);
            }
            doc._pop_all_models_freeze();
            return doc;
        }
        replace_with_json(json) {
            const replacement = Document.from_json(json);
            replacement.destructively_move(this);
        }
        create_json_patch(events) {
            for (const event of events) {
                if (event.document != this) {
                    throw new Error("Cannot create a patch using events from a different document");
                }
            }
            const references = new Map();
            for (const model of this._all_models.values()) {
                if (!this._new_models.has(model)) {
                    references.set(model, model.ref());
                }
            }
            const serializer = new serialization_1.Serializer({ references, binary: true });
            const patch = { events: serializer.encode(events) };
            this._new_models.clear();
            return patch;
        }
        apply_json_patch(patch, buffers = new Map()) {
            const { _hold_models_freeze } = this;
            this._hold_models_freeze = true;
            try {
                this._apply_json_patch(patch, buffers);
            }
            finally {
                this._hold_models_freeze = _hold_models_freeze;
            }
            this._schedule_recompute_all_models();
        }
        _apply_json_patch(patch, buffers = new Map()) {
            const finalize = (obj) => {
                obj.attach_document(this);
                this._new_models.add(obj);
                this._all_models.set(obj.id, obj);
            };
            const deserializer = new deserializer_1.Deserializer(this._resolver, this._all_models, finalize);
            const events = deserializer.decode(patch.events, buffers);
            for (const event of events) {
                switch (event.kind) {
                    case "MessageSent": {
                        const { msg_type, msg_data } = event;
                        this._trigger_on_message(msg_type, msg_data);
                        break;
                    }
                    case "ModelChanged": {
                        const { model, attr, new: value } = event;
                        model.setv({ [attr]: value }, { sync: false });
                        break;
                    }
                    case "ColumnDataChanged": {
                        const { model, attr, data, cols } = event;
                        if (cols != null) {
                            const new_data = (0, object_1.dict)(data);
                            const current_data = (0, object_1.dict)(model.property(attr).get_value());
                            for (const [name, column] of current_data) {
                                if (!new_data.has(name)) {
                                    new_data.set(name, column);
                                }
                            }
                        }
                        model.setv({ data }, { sync: false, check_eq: false });
                        break;
                    }
                    case "ColumnsStreamed": {
                        const { model, attr, data, rollover } = event;
                        const prop = model.property(attr);
                        model.stream_to(prop, data, rollover, { sync: false });
                        break;
                    }
                    case "ColumnsPatched": {
                        const { model, attr, patches } = event;
                        const prop = model.property(attr);
                        model.patch_to(prop, patches, { sync: false });
                        break;
                    }
                    case "RootAdded": {
                        this.add_root(event.model, { sync: false });
                        break;
                    }
                    case "RootRemoved": {
                        this.remove_root(event.model, { sync: false });
                        break;
                    }
                    case "TitleChanged": {
                        this.set_title(event.title, { sync: false });
                        break;
                    }
                    default: {
                        throw new Error(`unknown patch event type '${event.kind}'`); // XXX
                    }
                }
            }
        }
    }
    exports.Document = Document;
    Document.__name__ = "Document";
},
/* base.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.register_models = register_models;
    const types_1 = require(8) /* ./core/util/types */;
    const object_1 = require(9) /* ./core/util/object */;
    const types_2 = require(8) /* ./core/util/types */;
    const has_props_1 = require(15) /* ./core/has_props */;
    const resolvers_1 = require(46) /* ./core/resolvers */;
    exports.default_resolver = new resolvers_1.ModelResolver(null);
    exports.Models = new Proxy(exports.default_resolver, {
        get(target, name, receiver) {
            if ((0, types_2.isString)(name)) {
                const model = target.get(name);
                if (model != null) {
                    return model;
                }
            }
            return Reflect.get(target, name, receiver);
        },
        has(target, name) {
            if ((0, types_2.isString)(name)) {
                const model = target.get(name);
                if (model != null) {
                    return true;
                }
            }
            return Reflect.has(target, name);
        },
        ownKeys(target) {
            return target.names;
        },
        getOwnPropertyDescriptor(target, name) {
            if ((0, types_2.isString)(name)) {
                const model = target.get(name);
                if (model != null) {
                    return { configurable: true, enumerable: true, writable: false, value: model };
                }
            }
            return Reflect.getOwnPropertyDescriptor(target, name);
        },
    });
    function is_HasProps(obj) {
        return (0, types_1.isObject)(obj) && obj.prototype instanceof has_props_1.HasProps;
    }
    function register_models(models, force = false) {
        for (const model of (0, types_1.isArray)(models) ? models : (0, object_1.values)(models)) {
            if (is_HasProps(model)) {
                exports.default_resolver.register(model, force);
            }
        }
    }
},
/* core/util/types.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.is_undefined = is_undefined;
    exports.is_defined = is_defined;
    exports.is_nullish = is_nullish;
    exports.isBoolean = isBoolean;
    exports.isNumber = isNumber;
    exports.isInteger = isInteger;
    exports.isString = isString;
    exports.isSymbol = isSymbol;
    exports.isPrimitive = isPrimitive;
    exports.isFunction = isFunction;
    exports.isArray = isArray;
    exports.isArrayOf = isArrayOf;
    exports.isArrayableOf = isArrayableOf;
    exports.isTypedArray = isTypedArray;
    exports.isObject = isObject;
    exports.isBasicObject = isBasicObject;
    exports.isPlainObject = isPlainObject;
    exports.isDict = isDict;
    exports.isIterable = isIterable;
    exports.isArrayable = isArrayable;
    exports.is_ArrayBufferLike = is_ArrayBufferLike;
    //     Underscore.js 1.8.3
    //     http://underscorejs.org
    //     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
    //     Underscore may be freely distributed under the MIT license.
    const { toString } = Object.prototype;
    function is_undefined(obj) {
        return typeof obj === "undefined";
    }
    function is_defined(obj) {
        return typeof obj !== "undefined";
    }
    // XXX: use only to work around strict conditional expressions
    function is_nullish(obj) {
        return obj == null;
    }
    function isBoolean(obj) {
        return obj === true || obj === false || toString.call(obj) === "[object Boolean]";
    }
    function isNumber(obj) {
        return toString.call(obj) === "[object Number]";
    }
    function isInteger(obj) {
        return isNumber(obj) && Number.isInteger(obj);
    }
    function isString(obj) {
        return toString.call(obj) === "[object String]";
    }
    function isSymbol(obj) {
        return typeof obj === "symbol";
    }
    function isPrimitive(obj) {
        return obj === null || isBoolean(obj) || isNumber(obj) || isString(obj) || isSymbol(obj);
    }
    function isFunction(obj) {
        const rep = toString.call(obj);
        switch (rep) {
            case "[object Function]":
            case "[object AsyncFunction]":
            case "[object GeneratorFunction]":
            case "[object AsyncGeneratorFunction]":
                return true;
            default:
                return false;
        }
    }
    function isArray(obj) {
        return Array.isArray(obj);
    }
    function isArrayOf(array, predicate) {
        if (!isArray(array)) {
            return false;
        }
        for (const item of array) {
            if (!predicate(item)) {
                return false;
            }
        }
        return true;
    }
    function isArrayableOf(array, predicate) {
        if (!isArrayable(array)) {
            return false;
        }
        for (const item of array) {
            if (!predicate(item)) {
                return false;
            }
        }
        return true;
    }
    function isTypedArray(obj) {
        return ArrayBuffer.isView(obj) && !(obj instanceof DataView);
    }
    function isObject(obj) {
        const tp = typeof obj;
        return tp === "function" || tp === "object" && !!obj;
    }
    function isBasicObject(obj) {
        return isObject(obj) && is_nullish(obj.constructor);
    }
    function isPlainObject(obj) {
        return isObject(obj) && (is_nullish(obj.constructor) || obj.constructor === Object);
    }
    function isDict(obj) {
        return obj instanceof Map || isPlainObject(obj);
    }
    function isIterable(obj) {
        return isObject(obj) && Symbol.iterator in obj;
    }
    function isArrayable(obj) {
        return isIterable(obj) && "length" in obj;
    }
    function is_ArrayBufferLike(obj) {
        // SharedArrayBuffer is only available in cross origin isolated environments, otherwise it's undefined
        return obj instanceof ArrayBuffer || (typeof SharedArrayBuffer !== "undefined" && obj instanceof SharedArrayBuffer);
    }
},
/* core/util/object.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    exports.to_object = to_object;
    exports.keys = keys;
    exports.values = values;
    exports.entries = entries;
    exports.clone = clone;
    exports.merge = merge;
    exports.size = size;
    exports.is_empty = is_empty;
    exports.dict = dict;
    const types_1 = require(8) /* ./types */;
    const array_1 = require(10) /* ./array */;
    exports.assign = Object.assign;
    exports.extend = exports.assign;
    function to_object(obj) {
        return (0, types_1.isPlainObject)(obj) ? obj : Object.fromEntries(obj);
    }
    function keys(obj) {
        return obj instanceof Map ? [...obj.keys()] : Object.keys(obj);
    }
    function values(obj) {
        return obj instanceof Map ? [...obj.values()] : Object.values(obj);
    }
    function entries(obj) {
        return obj instanceof Map ? [...obj.entries()] : Object.entries(obj);
    }
    exports.typed_keys = Object.keys;
    exports.typed_values = Object.values;
    exports.typed_entries = Object.entries;
    function clone(obj) {
        return obj instanceof Map ? new Map(obj) : { ...obj };
    }
    function merge(obj0, obj1) {
        /*
        * Returns an object with the array values for obj1 and obj2 unioned by key.
        */
        const result = new Map();
        const keys = [...obj0.keys(), ...obj1.keys()];
        for (const key of keys) {
            const v0 = obj0.get(key);
            const v1 = obj1.get(key);
            const arr0 = v0 === undefined ? [] : v0;
            const arr1 = v1 === undefined ? [] : v1;
            result.set(key, (0, array_1.union)(arr0, arr1));
        }
        return result;
    }
    function size(obj) {
        return obj instanceof Map ? obj.size : Object.keys(obj).length;
    }
    function is_empty(obj) {
        return size(obj) == 0;
    }
    const { hasOwnProperty } = Object.prototype;
    class PlainObjectProxy {
        constructor(obj) {
            this[_a] = "PlainObjectProxy";
            this.obj = obj;
        }
        clear() {
            for (const key of this.keys()) {
                delete this.obj[key];
            }
        }
        delete(key) {
            const exists = this.has(key);
            if (exists) {
                delete this.obj[key];
            }
            return exists;
        }
        has(key) {
            return hasOwnProperty.call(this.obj, key);
        }
        get(key) {
            return this.has(key) ? this.obj[key] : undefined;
        }
        set(key, value) {
            this.obj[key] = value;
            return this;
        }
        get size() {
            return size(this.obj);
        }
        [(_a = Symbol.toStringTag, Symbol.iterator)]() {
            return this.entries();
        }
        *keys() {
            yield* keys(this.obj);
        }
        *values() {
            yield* values(this.obj);
        }
        *entries() {
            yield* entries(this.obj);
        }
        forEach(callback, that) {
            for (const [key, value] of this.entries()) {
                callback.call(that, value, key, this);
            }
        }
    }
    exports.PlainObjectProxy = PlainObjectProxy;
    PlainObjectProxy.__name__ = "PlainObjectProxy";
    function dict(obj) {
        return (0, types_1.isPlainObject)(obj) ? new PlainObjectProxy(obj) : obj;
    }
},
/* core/util/array.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.head = head;
    exports.last = last;
    exports.copy = copy;
    exports.concat = concat;
    exports.nth = nth;
    exports.zip = zip;
    exports.unzip = unzip;
    exports.range = range;
    exports.linspace = linspace;
    exports.logspace = logspace;
    exports.transpose = transpose;
    exports.argmin = argmin;
    exports.argmax = argmax;
    exports.argsort = argsort;
    exports.uniq = uniq;
    exports.uniq_by = uniq_by;
    exports._union = _union;
    exports.union = union;
    exports.intersection = intersection;
    exports.difference = difference;
    exports.symmetric_difference = symmetric_difference;
    exports.remove_at = remove_at;
    exports.remove = remove;
    exports.remove_by = remove_by;
    exports.clear = clear;
    exports.split = split;
    exports.shuffle = shuffle;
    exports.pairwise = pairwise;
    exports.elementwise = elementwise;
    exports.reversed = reversed;
    exports.repeat = repeat;
    exports.resize = resize;
    //     Underscore.js 1.8.3
    //     http://underscorejs.org
    //     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
    //     Underscore may be freely distributed under the MIT license.
    const math_1 = require(11) /* ./math */;
    const assert_1 = require(12) /* ./assert */;
    const types_1 = require(8) /* ./types */;
    const arrayable_1 = require(13) /* ./arrayable */;
    var arrayable_2 = require(13) /* ./arrayable */;
    __esExport("map", arrayable_2.map);
    __esExport("reduce", arrayable_2.reduce);
    __esExport("min", arrayable_2.min);
    __esExport("min_by", arrayable_2.min_by);
    __esExport("max", arrayable_2.max);
    __esExport("max_by", arrayable_2.max_by);
    __esExport("sum", arrayable_2.sum);
    __esExport("cumsum", arrayable_2.cumsum);
    __esExport("every", arrayable_2.every);
    __esExport("some", arrayable_2.some);
    __esExport("find", arrayable_2.find);
    __esExport("find_last", arrayable_2.find_last);
    __esExport("find_index", arrayable_2.find_index);
    __esExport("find_last_index", arrayable_2.find_last_index);
    __esExport("sorted_index", arrayable_2.sorted_index);
    __esExport("is_empty", arrayable_2.is_empty);
    __esExport("includes", arrayable_2.includes);
    __esExport("contains", arrayable_2.contains);
    __esExport("sort_by", arrayable_2.sort_by);
    const { slice } = Array.prototype;
    function head(array) {
        if (array.length != 0) {
            return array[0];
        }
        else {
            throw new Error("out of bounds access");
        }
    }
    function last(array) {
        if (array.length != 0) {
            return array[array.length - 1];
        }
        else {
            throw new Error("out of bounds access");
        }
    }
    function copy(array) {
        return slice.call(array);
    }
    function concat(arrays) {
        return [].concat(...arrays);
    }
    function nth(array, index) {
        return array[index >= 0 ? index : array.length + index];
    }
    function zip(...arrays) {
        if (arrays.length == 0) {
            return [];
        }
        const n = (0, arrayable_1.min)(arrays.map((a) => a.length));
        const k = arrays.length;
        const result = new Array(n);
        for (let i = 0; i < n; i++) {
            result[i] = new Array(k);
            for (let j = 0; j < k; j++) {
                result[i][j] = arrays[j][i];
            }
        }
        return result;
    }
    function unzip(array) {
        const n = array.length;
        if (n == 0) {
            return [];
        }
        const k = (0, arrayable_1.min)(array.map((a) => a.length));
        const results = Array(k);
        for (let j = 0; j < k; j++) {
            results[j] = new Array(n);
        }
        for (let i = 0; i < n; i++) {
            for (let j = 0; j < k; j++) {
                results[j][i] = array[i][j];
            }
        }
        return results;
    }
    function range(start, stop, step = 1) {
        (0, assert_1.assert)(step > 0, "'step' must be a positive number");
        if (stop == null) {
            stop = start;
            start = 0;
        }
        const { max, ceil, abs } = Math;
        const delta = start <= stop ? step : -step;
        const length = max(ceil(abs(stop - start) / step), 0);
        const range = new Array(length);
        for (let i = 0; i < length; i++, start += delta) {
            range[i] = start;
        }
        return range;
    }
    function linspace(start, stop, num = 100) {
        const step = num == 1 ? 0 : (stop - start) / (num - 1);
        const array = new Array(num);
        for (let i = 0; i < num; i++) {
            array[i] = start + i * step;
        }
        return array;
    }
    function logspace(start, stop, num = 100, base = 10) {
        const step = num == 1 ? 0 : (stop - start) / (num - 1);
        const array = new Array(num);
        for (let i = 0; i < num; i++) {
            array[i] = base ** (start + i * step);
        }
        return array;
    }
    function transpose(array) {
        const rows = array.length;
        const cols = array[0].length;
        const transposed = [];
        for (let j = 0; j < cols; j++) {
            transposed[j] = [];
            for (let i = 0; i < rows; i++) {
                transposed[j][i] = array[i][j];
            }
        }
        return transposed;
    }
    function argmin(array) {
        return (0, arrayable_1.min_by)(range(array.length), (i) => array[i]);
    }
    function argmax(array) {
        return (0, arrayable_1.max_by)(range(array.length), (i) => array[i]);
    }
    /**
     * Return the permutation indices for sorting an array.
     */
    function argsort(array) {
        const indices = Array.from(array.keys());
        indices.sort((a, b) => array[a] - array[b]);
        return indices;
    }
    function uniq(array) {
        const result = new Set();
        for (const value of array) {
            result.add(value);
        }
        return [...result];
    }
    function uniq_by(array, key) {
        const result = [];
        const seen = [];
        for (const value of array) {
            const computed = key(value);
            if (!(0, arrayable_1.includes)(seen, computed)) {
                seen.push(computed);
                result.push(value);
            }
        }
        return result;
    }
    function _union(arrays) {
        const result = new Set();
        for (const array of arrays) {
            for (const value of array) {
                result.add(value);
            }
        }
        return result;
    }
    function union(...arrays) {
        return [..._union(arrays)];
    }
    function intersection(array, ...arrays) {
        const result = [];
        top: for (const item of array) {
            if ((0, arrayable_1.includes)(result, item)) {
                continue;
            }
            for (const other of arrays) {
                if (!(0, arrayable_1.includes)(other, item)) {
                    continue top;
                }
            }
            result.push(item);
        }
        return result;
    }
    function difference(array, ...arrays) {
        const rest = _union(arrays);
        return (0, arrayable_1.filter)(array, (value) => !rest.has(value));
    }
    function symmetric_difference(array0, array1) {
        const set0 = new Set(array0);
        const set1 = new Set(array1);
        const result = [];
        for (const val of set0) {
            if (!set1.has(val)) {
                result.push(val);
            }
        }
        for (const val of set1) {
            if (!set0.has(val)) {
                result.push(val);
            }
        }
        return result;
    }
    function remove_at(array, i) {
        (0, assert_1.assert)((0, types_1.isInteger)(i) && i >= 0);
        const result = copy(array);
        result.splice(i, 1);
        return result;
    }
    function remove(array, item) {
        remove_by(array, (value) => value == item);
    }
    function remove_by(array, key) {
        for (let i = 0; i < array.length;) {
            if (key(array[i])) {
                array.splice(i, 1);
            }
            else {
                i++;
            }
        }
    }
    function clear(array) {
        array.splice(0, array.length);
    }
    function split(array, separator) {
        const chunks = [];
        const n = array.length;
        let i = 0;
        let j = 0;
        while (j < n) {
            if (array[j] === separator) {
                chunks.push(array.slice(i, j));
                i = ++j;
            }
            else {
                ++j;
            }
        }
        chunks.push(array.slice(i));
        return chunks;
    }
    // Shuffle a collection, using the modern version of the
    // [Fisher-Yates shuffle](http://en.wikipedia.org/wiki/Fisher–Yates_shuffle).
    function shuffle(array) {
        const length = array.length;
        const shuffled = new Array(length);
        for (let i = 0; i < length; i++) {
            const rand = (0, math_1.randomIn)(0, i);
            if (rand !== i) {
                shuffled[i] = shuffled[rand];
            }
            shuffled[rand] = array[i];
        }
        return shuffled;
    }
    function pairwise(array, fn) {
        const n = array.length;
        const result = new Array(n - 1);
        for (let i = 0; i < n - 1; i++) {
            result[i] = fn(array[i], array[i + 1]);
        }
        return result;
    }
    function elementwise(array0, array1, fn) {
        const n = Math.min(array0.length, array1.length);
        const result = Array(n);
        for (let i = 0; i < n; i++) {
            result[i] = fn(array0[i], array1[i]);
        }
        return result;
    }
    function reversed(array) {
        const n = array.length;
        const result = new Array(n);
        for (let i = 0; i < n; i++) {
            result[n - i - 1] = array[i];
        }
        return result;
    }
    function repeat(value, n) {
        const result = new Array(n).fill(value);
        return result;
    }
    function resize(array, new_length, fill_value) {
        if (array.length >= new_length) {
            return array.slice(0, new_length);
        }
        else {
            const suffix = new Array(new_length - array.length);
            if (fill_value !== undefined) {
                suffix.fill(fill_value);
            }
            return array.concat(suffix);
        }
    }
},
/* core/util/math.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.angle_norm = angle_norm;
    exports.angle_dist = angle_dist;
    exports.angle_between = angle_between;
    exports.randomIn = randomIn;
    exports.atan2 = atan2;
    exports.radians = radians;
    exports.degrees = degrees;
    exports.compute_angle = compute_angle;
    exports.invert_angle = invert_angle;
    exports.to_radians_coeff = to_radians_coeff;
    exports.minmax = minmax;
    exports.clamp = clamp;
    exports.cycle = cycle;
    exports.log = log;
    exports.gcd = gcd;
    exports.lcm = lcm;
    exports.is_Floating = is_Floating;
    exports.factorial = factorial;
    exports.hermite = hermite;
    exports.eval_poly = eval_poly;
    const types_1 = require(8) /* ./types */;
    const assert_1 = require(12) /* ./assert */;
    const { PI, abs, sign, sqrt } = Math;
    exports.PI = PI;
    exports.abs = abs;
    exports.sqrt = sqrt;
    function angle_norm(angle) {
        if (angle == 0) {
            return 0;
        }
        while (angle <= 0) {
            angle += 2 * PI;
        }
        while (angle > 2 * PI) {
            angle -= 2 * PI;
        }
        return angle;
    }
    function angle_dist(lhs, rhs) {
        return angle_norm(lhs - rhs);
    }
    function angle_between(mid, lhs, rhs, anticlock = false) {
        const d = angle_dist(lhs, rhs);
        if (d == 0) {
            return false;
        }
        if (d == 2 * PI) {
            return true;
        }
        const norm_mid = angle_norm(mid);
        const cond = angle_dist(lhs, norm_mid) <= d && angle_dist(norm_mid, rhs) <= d;
        return !anticlock ? cond : !cond;
    }
    function randomIn(min, max) {
        if (max == null) {
            max = min;
            min = 0;
        }
        return min + Math.floor(Math.random() * (max - min + 1));
    }
    function atan2(start, end) {
        /*
         * Calculate the angle between a line containing start and end points (composed
         * of [x, y] arrays) and the positive x-axis.
         */
        return Math.atan2(end[1] - start[1], end[0] - start[0]);
    }
    function radians(degrees) {
        return degrees * (PI / 180);
    }
    function degrees(radians) {
        return radians / (PI / 180);
    }
    function compute_angle(angle, units, dir = "anticlock") {
        /**
         * Convert math CCW(default)/CW angle with units to CW radians (canvas).
         */
        const sign = dir == "anticlock" ? 1 : -1;
        return -sign * angle * to_radians_coeff(units);
    }
    exports.resolve_angle = compute_angle;
    function invert_angle(angle, units, dir = "anticlock") {
        /**
         * Convert CW radians (canvas) to math CCW(default)/CW angle with units.
         */
        const sign = dir == "anticlock" ? 1 : -1;
        return -sign * angle / to_radians_coeff(units);
    }
    function to_radians_coeff(units) {
        switch (units) {
            case "deg": return PI / 180;
            case "rad": return 1;
            case "grad": return PI / 200;
            case "turn": return 2 * PI;
        }
    }
    function minmax(v0, v1) {
        return v0 <= v1 ? [v0, v1] : [v1, v0];
    }
    function clamp(val, min, max) {
        return val < min ? min : (val > max ? max : val);
    }
    function cycle(val, min, max) {
        if (val > max) {
            return min;
        }
        if (val < min) {
            return max;
        }
        return val;
    }
    function log(x, base = Math.E) {
        return Math.log(x) / Math.log(base);
    }
    function gcd(a, b) {
        a = Math.abs(a);
        b = Math.abs(b);
        while (b != 0) {
            [a, b] = [b, a % b];
        }
        return a;
    }
    function lcm(a, ...rest) {
        for (const b of rest) {
            a = Math.floor((a * b) / gcd(a, b));
        }
        return a;
    }
    exports.float = Symbol("float");
    function is_Floating(obj) {
        return (0, types_1.isObject)(obj) && exports.float in obj;
    }
    class Fraction {
        constructor(numer, denom) {
            (0, assert_1.assert)(denom != 0, "Zero divisor");
            const div = gcd(numer, denom);
            const sgn = sign(numer) * sign(denom);
            this.numer = sgn * abs(numer) / div;
            this.denom = abs(denom) / div;
        }
        [exports.float]() {
            return this.numer / this.denom;
        }
        toString() {
            return `${this.numer}/${this.denom}`;
        }
    }
    exports.Fraction = Fraction;
    Fraction.__name__ = "Fraction";
    exports.float32_epsilon = 1.1920928955078125e-7; // IEEE-754
    function factorial(x) {
        let y = 1;
        for (let i = 2; i <= x; i++) {
            y *= i;
        }
        return y;
    }
    function hermite(n) {
        const poly = new Array(n + 1);
        poly.fill(0);
        const fn = factorial(n);
        for (let k = 0; k <= Math.floor(n / 2); k++) {
            const c = (-1) ** k * fn / (factorial(k) * factorial(n - 2 * k)) * 2 ** (n - 2 * k);
            poly[2 * k] = c;
        }
        return poly;
    }
    function eval_poly(poly, x) {
        const n = poly.length - 1;
        let y = 0;
        let x_n = 1;
        for (let i = n; i >= 0; i--) {
            y += x_n * poly[i];
            x_n *= x;
        }
        return y;
    }
},
/* core/util/assert.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.assert = assert;
    exports.assert_debug = assert_debug;
    exports.unreachable = unreachable;
    class AssertionError extends Error {
    }
    exports.AssertionError = AssertionError;
    AssertionError.__name__ = "AssertionError";
    class UnreachableError extends Error {
    }
    exports.UnreachableError = UnreachableError;
    UnreachableError.__name__ = "UnreachableError";
    function assert(condition, message) {
        if (condition === true || (condition !== false && condition())) {
            return;
        }
        throw new AssertionError(message ?? "Assertion failed");
    }
    function assert_debug(condition, message) {
        if (typeof DEBUG !== "undefined" && DEBUG) {
            assert(condition, message);
        }
    }
    function unreachable(msg) {
        const suffix = msg != null ? `: ${msg}` : "";
        throw new UnreachableError(`unreachable code${suffix}`);
    }
},
/* core/util/arrayable.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.is_empty = is_empty;
    exports.is_sorted = is_sorted;
    exports.copy = copy;
    exports.splice = splice;
    exports.head = head;
    exports.insert = insert;
    exports.append = append;
    exports.prepend = prepend;
    exports.index_of = index_of;
    exports.includes = includes;
    exports.subselect = subselect;
    exports.mul = mul;
    exports.map = map;
    exports.inplace_map = inplace_map;
    exports.filter = filter;
    exports.reduce = reduce;
    exports.sort_by = sort_by;
    exports.minmax2 = minmax2;
    exports.min_by = min_by;
    exports.max_by = max_by;
    exports.sum = sum;
    exports.cumsum = cumsum;
    exports.every = every;
    exports.some = some;
    exports.find = find;
    exports.find_last = find_last;
    exports.bisect_left_by = bisect_left_by;
    exports.bisect_right_by = bisect_right_by;
    exports.bisect_left = bisect_left;
    exports.bisect_right = bisect_right;
    exports.binary_search = binary_search;
    exports.bin_counts = bin_counts;
    exports.interpolate = interpolate;
    exports.left_edge_index = left_edge_index;
    exports.norm = norm;
    const math_1 = require(11) /* ./math */;
    const assert_1 = require(12) /* ./assert */;
    var iterator_1 = require(14) /* ./iterator */;
    __esExport("min", iterator_1.min);
    __esExport("max", iterator_1.max);
    __esExport("minmax", iterator_1.minmax);
    const { floor } = Math;
    function is_empty(array) {
        return array.length == 0;
    }
    function is_sorted(array) {
        const n = array.length;
        if (n == 0) {
            return true;
        }
        let prev = array[0];
        for (let i = 1; i < n; i++) {
            const curr = array[i];
            if (prev <= curr) {
                prev = curr;
            }
            else {
                return false;
            }
        }
        return true;
    }
    function copy(array) {
        if (Array.isArray(array)) {
            return array.slice();
        }
        else {
            return new array.constructor(array);
        }
    }
    function splice(array, start, k, ...items) {
        if (Array.isArray(array)) {
            const result = copy(array);
            if (k === undefined) {
                result.splice(start);
            }
            else {
                result.splice(start, k, ...items);
            }
            return result;
        }
        const len = array.length;
        if (start < 0) {
            start += len;
        }
        if (start < 0) {
            start = 0;
        }
        else if (start > len) {
            start = len;
        }
        if (k == null || k > len - start) {
            k = len - start;
        }
        else if (k < 0) {
            k = 0;
        }
        const n = len - k + items.length;
        const result = new array.constructor(n);
        let i = 0;
        for (; i < start; i++) {
            result[i] = array[i];
        }
        for (const item of items) {
            result[i++] = item;
        }
        for (let j = start + k; j < len; j++) {
            result[i++] = array[j];
        }
        return result;
    }
    function head(array, n) {
        return splice(array, n, array.length - n);
    }
    function insert(array, item, i) {
        return splice(array, i, 0, item);
    }
    function append(array, item) {
        return splice(array, array.length, 0, item);
    }
    function prepend(array, item) {
        return splice(array, 0, 0, item);
    }
    function index_of(array, item) {
        return array.indexOf(item);
    }
    function includes(array, value) {
        return array.indexOf(value) !== -1;
    }
    exports.contains = includes;
    function subselect(array, indices) {
        const n = indices.length;
        const result = new array.constructor(n);
        for (let i = 0; i < n; i++) {
            result[i] = array[indices[i]];
        }
        return result;
    }
    function mul(array, coeff, output) {
        const n = array.length;
        const result = output ?? new array.constructor(n);
        for (let i = 0; i < n; i++) {
            result[i] = array[i] * coeff;
        }
        return result;
    }
    function map(array, fn) {
        const n = array.length;
        const result = new array.constructor(n);
        for (let i = 0; i < n; i++) {
            result[i] = fn(array[i], i, array);
        }
        return result;
    }
    function inplace_map(array, fn, output) {
        const n = array.length;
        const result = output ?? array;
        for (let i = 0; i < n; i++) {
            result[i] = fn(array[i], i);
        }
    }
    function filter(array, pred) {
        const n = array.length;
        const result = new array.constructor(n);
        let k = 0;
        for (let i = 0; i < n; i++) {
            const value = array[i];
            if (pred(value, i, array)) {
                result[k++] = value;
            }
        }
        return head(result, k);
    }
    function reduce(array, fn, initial) {
        const n = array.length;
        if (initial === undefined && n == 0) {
            throw new Error("can't reduce an empty array without an initial value");
        }
        let value;
        let i;
        if (initial === undefined) {
            value = array[0];
            i = 1;
        }
        else {
            value = initial;
            i = 0;
        }
        for (; i < n; i++) {
            value = fn(value, array[i], i, array);
        }
        return value;
    }
    function sort_by(array, key) {
        const tmp = Array.from(array, (value, index) => {
            return { index, key: key(value) };
        });
        tmp.sort((left, right) => {
            const a = left.key;
            const b = right.key;
            if (a !== b) {
                if (a > b) {
                    return 1;
                }
                if (a < b) {
                    return -1;
                }
            }
            return left.index - right.index;
        });
        return map(array, (_, i) => array[tmp[i].index]);
    }
    function minmax2(arr, brr) {
        let a;
        let b;
        let a_min = +Infinity;
        let a_max = -Infinity;
        let b_min = +Infinity;
        let b_max = -Infinity;
        const n = Math.min(arr.length, brr.length);
        for (let i = 0; i < n; i++) {
            a = arr[i];
            b = brr[i];
            if (!isNaN(a) && !isNaN(b)) {
                if (a < a_min) {
                    a_min = a;
                }
                if (a > a_max) {
                    a_max = a;
                }
                if (b < b_min) {
                    b_min = b;
                }
                if (b > b_max) {
                    b_max = b;
                }
            }
        }
        return [a_min, a_max, b_min, b_max];
    }
    function min_by(array, key) {
        if (array.length == 0) {
            throw new Error("min_by() called with an empty array");
        }
        let result = array[0];
        let result_computed = key(result, 0);
        for (let i = 1, length = array.length; i < length; i++) {
            const value = array[i];
            const computed = key(value, i);
            if (computed < result_computed) {
                result = value;
                result_computed = computed;
            }
        }
        return result;
    }
    function max_by(array, key) {
        if (array.length == 0) {
            throw new Error("max_by() called with an empty array");
        }
        let result = array[0];
        let result_computed = key(result, 0);
        for (let i = 1, length = array.length; i < length; i++) {
            const value = array[i];
            const computed = key(value, i);
            if (computed > result_computed) {
                result = value;
                result_computed = computed;
            }
        }
        return result;
    }
    function sum(array) {
        let result = 0;
        for (let i = 0, n = array.length; i < n; i++) {
            result += array[i];
        }
        return result;
    }
    function cumsum(array) {
        const result = new array.constructor(array.length);
        reduce(array, (a, b, i) => result[i] = a + b, 0);
        return result;
    }
    function every(iter, predicate) {
        for (const item of iter) {
            if (!predicate(item)) {
                return false;
            }
        }
        return true;
    }
    function some(iter, predicate) {
        for (const item of iter) {
            if (predicate(item)) {
                return true;
            }
        }
        return false;
    }
    function _find_index(dir) {
        return function (array, predicate) {
            const length = array.length;
            let index = dir > 0 ? 0 : length - 1;
            for (; index >= 0 && index < length; index += dir) {
                if (predicate(array[index])) {
                    return index;
                }
            }
            return -1;
        };
    }
    exports.find_index = _find_index(1);
    exports.find_last_index = _find_index(-1);
    function find(array, predicate) {
        const index = (0, exports.find_index)(array, predicate);
        return index == -1 ? undefined : array[index];
    }
    function find_last(array, predicate) {
        const index = (0, exports.find_last_index)(array, predicate);
        return index == -1 ? undefined : array[index];
    }
    function bisect_left_by(array, value, fn, low = 0, high = array.length) {
        (0, assert_1.assert_debug)(() => is_sorted(array));
        (0, assert_1.assert)(0 <= low && high <= array.length);
        while (low < high) {
            const mid = floor((low + high) / 2);
            if (fn(array[mid]) < value) {
                low = mid + 1;
            }
            else {
                high = mid;
            }
        }
        return low;
    }
    function bisect_right_by(array, value, fn, low = 0, high = array.length) {
        (0, assert_1.assert_debug)(() => is_sorted(array));
        (0, assert_1.assert)(0 <= low && high <= array.length);
        while (low < high) {
            const mid = floor((low + high) / 2);
            if (fn(array[mid]) <= value) {
                low = mid + 1;
            }
            else {
                high = mid;
            }
        }
        return low;
    }
    function bisect_left(array, value, low = 0, high) {
        return bisect_left_by(array, value, (item) => item, low, high);
    }
    function bisect_right(array, value, low = 0, high) {
        return bisect_right_by(array, value, (item) => item, low, high);
    }
    function binary_search(array, value) {
        const i = bisect_left(array, value);
        return i != array.length && array[i] == value ? i : null;
    }
    exports.sorted_index = bisect_left;
    function bin_counts(data, bin_edges) {
        const nbins = bin_edges.length - 1;
        const counts = Array(nbins).fill(0);
        for (let i = 0; i < data.length; i++) {
            const sample = data[i];
            const index = (0, exports.sorted_index)(bin_edges, sample);
            const bin = (0, math_1.clamp)(index - 1, 0, nbins - 1);
            counts[bin] += 1;
        }
        return counts;
    }
    function interpolate(points, x_values, y_values) {
        // Implementation ported from np.interp
        const n = points.length;
        const results = new Array(n);
        for (let i = 0; i < n; i++) {
            const point = points[i];
            if (isNaN(point) || x_values.length == 0) {
                results[i] = NaN;
                continue;
            }
            const index = left_edge_index(point, x_values);
            if (index == -1) {
                results[i] = y_values[0];
            }
            else if (index == x_values.length) {
                results[i] = y_values[y_values.length - 1];
            }
            else if (index == x_values.length - 1 || x_values[index] == point) {
                results[i] = y_values[index];
            }
            else {
                const x0 = x_values[index];
                const y0 = y_values[index];
                const x1 = x_values[index + 1];
                const y1 = y_values[index + 1];
                results[i] = lerp(point, x0, y0, x1, y1);
            }
        }
        return results;
    }
    function lerp(x, x0, y0, x1, y1) {
        const slope = (y1 - y0) / (x1 - x0);
        let res = slope * (x - x0) + y0;
        if (!isFinite(res)) {
            res = slope * (x - x1) + y1;
            if (!isFinite(res) && (y0 == y1)) {
                res = y0;
            }
        }
        return res;
    }
    function left_edge_index(point, intervals) {
        if (point < intervals[0]) {
            return -1;
        }
        if (point > intervals[intervals.length - 1]) {
            return intervals.length;
        }
        if (intervals.length == 1) {
            // Implies point == intervals[0]
            return 0;
        }
        let leftEdgeIndex = 0;
        let rightEdgeIndex = intervals.length - 1;
        while (rightEdgeIndex - leftEdgeIndex != 1) {
            const indexOfNumberToCompare = leftEdgeIndex + Math.floor((rightEdgeIndex - leftEdgeIndex) / 2);
            if (point >= intervals[indexOfNumberToCompare]) {
                leftEdgeIndex = indexOfNumberToCompare;
            }
            else {
                rightEdgeIndex = indexOfNumberToCompare;
            }
        }
        return leftEdgeIndex;
    }
    function norm(array, start, end) {
        const span = end - start;
        return map(array, (x) => (x - start) / span);
    }
},
/* core/util/iterator.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.range = range;
    exports.reverse = reverse;
    exports.enumerate = enumerate;
    exports.take = take;
    exports.skip = skip;
    exports.tail = tail;
    exports.join = join;
    exports.zip = zip;
    exports.interleave = interleave;
    exports.map = map;
    exports.flat_map = flat_map;
    exports.filter = filter;
    exports.no_repeated = no_repeated;
    exports.every = every;
    exports.some = some;
    exports.combinations = combinations;
    exports.subsets = subsets;
    exports.min = min;
    exports.max = max;
    exports.minmax = minmax;
    const assert_1 = require(12) /* ./assert */;
    function* range(start, stop, step = 1) {
        (0, assert_1.assert)(step > 0);
        const { abs, ceil, max } = Math;
        if (stop == null) {
            stop = start;
            start = 0;
        }
        const delta = start <= stop ? step : -step;
        const length = max(ceil(abs(stop - start) / abs(step)), 0);
        for (let i = 0; i < length; i++, start += delta) {
            yield start;
        }
    }
    function* reverse(array) {
        const n = array.length;
        for (let i = 0; i < n; i++) {
            yield array[n - i - 1];
        }
    }
    function* enumerate(seq) {
        let i = 0;
        for (const item of seq) {
            yield [item, i++];
        }
    }
    function* take(seq, n) {
        (0, assert_1.assert)(n >= 0);
        let i = 0;
        for (const item of seq) {
            if (i++ < n) {
                yield item;
            }
            else {
                break;
            }
        }
    }
    function* skip(seq, n) {
        (0, assert_1.assert)(n >= 0);
        for (const value of seq) {
            if (n == 0) {
                yield value;
            }
            else {
                n -= 1;
            }
        }
    }
    function* tail(seq) {
        yield* skip(seq, 1);
    }
    function* join(seq, separator) {
        let first = true;
        for (const entry of seq) {
            if (first) {
                first = false;
            }
            else if (separator != null) {
                yield separator();
            }
            yield* entry;
        }
    }
    function* zip(iterable0, iterable1) {
        const it0 = iterable0[Symbol.iterator]();
        const it1 = iterable1[Symbol.iterator]();
        do {
            const r0 = it0.next();
            const r1 = it1.next();
            if (r0.done === true || r1.done === true) {
                break;
            }
            else {
                yield [r0.value, r1.value];
            }
        } while (true);
    }
    function* interleave(seq, separator) {
        let first = true;
        for (const entry of seq) {
            if (first) {
                first = false;
            }
            else {
                yield separator();
            }
            yield entry;
        }
    }
    function* map(iterable, fn) {
        let i = 0;
        for (const item of iterable) {
            yield fn(item, i++);
        }
    }
    function* flat_map(iterable, fn) {
        let i = 0;
        for (const item of iterable) {
            yield* fn(item, i++);
        }
    }
    function* filter(iterable, fn) {
        let i = 0;
        for (const item of iterable) {
            if (fn(item, i++)) {
                yield item;
            }
        }
    }
    const nothing = Symbol("nothing");
    function* no_repeated(iterable) {
        let last = nothing;
        for (const item of iterable) {
            if (item !== last) {
                yield item;
            }
            last = item;
        }
    }
    function every(iterable, predicate) {
        for (const item of iterable) {
            if (!predicate(item)) {
                return false;
            }
        }
        return true;
    }
    function some(iterable, predicate) {
        for (const item of iterable) {
            if (predicate(item)) {
                return true;
            }
        }
        return false;
    }
    // https://docs.python.org/3.8/library/itertools.html#itertools.combinations
    function* combinations(seq, r) {
        const n = seq.length;
        if (r > n) {
            return;
        }
        const indices = [...range(r)];
        yield indices.map((i) => seq[i]);
        while (true) {
            let k;
            for (const i of range(r - 1, -1)) {
                if (indices[i] != i + n - r) {
                    k = i;
                    break;
                }
            }
            if (k == null) {
                return;
            }
            indices[k] += 1;
            for (const j of range(k + 1, r)) {
                indices[j] = indices[j - 1] + 1;
            }
            yield indices.map((i) => seq[i]);
        }
    }
    function* subsets(seq) {
        for (const k of range(seq.length + 1)) {
            yield* combinations(seq, k);
        }
    }
    function min(iterable) {
        let result = Infinity;
        for (const value of iterable) {
            if (!isNaN(value) && value < result) {
                result = value;
            }
        }
        return result;
    }
    function max(iterable) {
        let result = -Infinity;
        for (const value of iterable) {
            if (!isNaN(value) && value > result) {
                result = value;
            }
        }
        return result;
    }
    function minmax(iterable) {
        let min = +Infinity;
        let max = -Infinity;
        for (const value of iterable) {
            if (!isNaN(value)) {
                if (value < min) {
                    min = value;
                }
                if (value > max) {
                    max = value;
                }
            }
        }
        return [min, max];
    }
},
/* core/has_props.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const signaling_1 = require(16) /* ./signaling */;
    const refs_1 = require(18) /* ./util/refs */;
    const p = tslib_1.__importStar(require(19) /* ./properties */);
    const k = tslib_1.__importStar(require(22) /* ./kinds */);
    const assert_1 = require(12) /* ./util/assert */;
    const string_1 = require(40) /* ./util/string */;
    const object_1 = require(9) /* ./util/object */;
    const types_1 = require(8) /* ./util/types */;
    const serialization_1 = require(33) /* ./serialization */;
    const events_1 = require(41) /* ../document/events */;
    const eq_1 = require(27) /* ./util/eq */;
    const pretty_1 = require(42) /* ./util/pretty */;
    const cloneable_1 = require(32) /* ./util/cloneable */;
    const kinds = tslib_1.__importStar(require(22) /* ./kinds */);
    const vectorization_1 = require(29) /* ./vectorization */;
    const patching_1 = require(43) /* ./patching */;
    const _qualified_names = new WeakMap();
    class HasProps extends (0, signaling_1.Signalable)() {
        get is_syncable() {
            return true;
        }
        get type() {
            return this.constructor.__qualified__;
        }
        static get __qualified__() {
            let qualified = _qualified_names.get(this);
            if (qualified == null) {
                const { __module__, __name__ } = this;
                qualified = __module__ != null ? `${__module__}.${__name__}` : __name__;
                _qualified_names.set(this, qualified);
            }
            return qualified;
        }
        static set __qualified__(qualified) {
            _qualified_names.set(this, qualified);
        }
        get [Symbol.toStringTag]() {
            return this.constructor.__qualified__;
        }
        static _fix_default(default_value, _attr) {
            if (default_value === undefined || default_value === p.unset) {
                return () => p.unset;
            }
            else if ((0, types_1.isFunction)(default_value)) {
                return default_value;
            }
            else if ((0, types_1.isPrimitive)(default_value)) {
                return () => default_value;
            }
            else {
                const cloner = new cloneable_1.Cloner();
                return () => cloner.clone(default_value);
            }
        }
        // TODO: don't use Partial<>, but exclude inherited properties
        static define(obj) {
            for (const [name, prop] of (0, object_1.entries)((0, types_1.isFunction)(obj) ? obj(kinds) : obj)) {
                if (name in this.prototype._props) {
                    throw new Error(`attempted to redefine property '${this.prototype.type}.${name}'`);
                }
                if (name in this.prototype) {
                    throw new Error(`attempted to redefine attribute '${this.prototype.type}.${name}'`);
                }
                Object.defineProperty(this.prototype, name, {
                    // XXX: don't use tail calls in getters/setters due to https://bugs.webkit.org/show_bug.cgi?id=164306
                    get() {
                        const value = this.properties[name].get_value();
                        return value;
                    },
                    set(value) {
                        this.setv({ [name]: value });
                        return this;
                    },
                    configurable: false,
                    enumerable: true,
                });
                const [type, default_value, options = {}] = prop;
                const refined_prop = {
                    type,
                    default_value: this._fix_default(default_value, name),
                    options,
                };
                this.prototype._props = {
                    ...this.prototype._props,
                    [name]: refined_prop,
                };
            }
        }
        static internal(obj) {
            const _object = {};
            for (const [name, prop] of (0, object_1.entries)((0, types_1.isFunction)(obj) ? obj(kinds) : obj)) {
                const [type, default_value, options = {}] = prop;
                _object[name] = [type, default_value, { ...options, internal: true }];
            }
            this.define(_object);
        }
        static mixins(defs) {
            function rename(prefix, mixin) {
                const result = {};
                for (const [name, prop] of (0, object_1.entries)(mixin)) {
                    result[prefix + name] = prop;
                }
                return result;
            }
            const mixin_defs = {};
            const mixins = [];
            for (const def of (0, types_1.isArray)(defs) ? defs : [defs]) {
                if ((0, types_1.isArray)(def)) {
                    const [prefix, mixin] = def;
                    (0, object_1.extend)(mixin_defs, rename(prefix, mixin));
                    mixins.push([prefix, mixin]);
                }
                else {
                    const mixin = def;
                    (0, object_1.extend)(mixin_defs, mixin);
                    mixins.push(["", mixin]);
                }
            }
            this.define(mixin_defs);
            this.prototype._mixins = [...this.prototype._mixins, ...mixins];
        }
        static override(obj) {
            for (const [name, prop] of (0, object_1.entries)(obj)) {
                const default_value = this._fix_default(prop, name);
                if (!(name in this.prototype._props)) {
                    throw new Error(`attempted to override nonexistent '${this.prototype.type}.${name}'`);
                }
                const value = this.prototype._props[name];
                const props = { ...this.prototype._props };
                props[name] = { ...value, default_value };
                this.prototype._props = props;
            }
        }
        static override_options(obj) {
            for (const [name, options] of (0, object_1.entries)(obj)) {
                if (!(name in this.prototype._props)) {
                    throw new Error(`attempted to override nonexistent '${this.prototype.type}.${name}'`);
                }
                const current = this.prototype._props[name];
                const props = {
                    ...this.prototype._props,
                    [name]: { ...current, options: { ...current.options, ...options } },
                };
                this.prototype._props = props;
            }
        }
        static toString() {
            return this.__qualified__;
        }
        toString() {
            return `${this.type}(${this.id})`;
        }
        property(name) {
            if (name in this.properties) {
                return this.properties[name];
            }
            else {
                throw new Error(`unknown property ${this.type}.${name}`);
            }
        }
        /**
         * Gets values of all set properties.
         */
        get attributes() {
            const attrs = {};
            for (const prop of this) {
                if (!prop.is_unset) {
                    attrs[prop.attr] = prop.get_value();
                }
            }
            return attrs;
        }
        /**
         * Gets values of all set and dirty (modified) properties.
         */
        get dirty_attributes() {
            const attrs = {};
            for (const prop of this) {
                if (!prop.is_unset && prop.dirty) {
                    attrs[prop.attr] = prop.get_value();
                }
            }
            return attrs;
        }
        [cloneable_1.clone](cloner) {
            const attrs = new Map();
            for (const prop of this) {
                if (prop.dirty) {
                    attrs.set(prop.attr, cloner.clone(prop.get_value()));
                }
            }
            return new this.constructor(attrs);
        }
        [eq_1.equals](that, cmp) {
            for (const p0 of this) {
                const p1 = that.property(p0.attr);
                if (!cmp.eq(p0.get_value(), p1.get_value())) {
                    return false;
                }
            }
            return true;
        }
        [pretty_1.pretty](printer) {
            const T = printer.token;
            const items = [];
            for (const prop of this) {
                if (prop.dirty) {
                    const value = prop.get_value();
                    items.push(`${prop.attr}${T(":")} ${printer.to_string(value)}`);
                }
            }
            const cls = this.constructor.__qualified__;
            return `${cls}${T("(")}${T("{")}${items.join(`${T(",")} `)}${T("}")}${T(")")}`;
        }
        [serialization_1.serialize](serializer) {
            const ref = this.ref();
            serializer.add_ref(this, ref);
            const attributes = {};
            for (const prop of this) {
                if (prop.syncable && (serializer.include_defaults || prop.dirty) && !(prop.readonly && prop.is_unset)) {
                    const value = prop.get_value();
                    attributes[prop.attr] = serializer.encode(value);
                }
            }
            const { type: name, id } = this;
            const rep = { type: "object", name, id };
            return (0, object_1.is_empty)(attributes) ? rep : { ...rep, attributes };
        }
        constructor(attrs = {}) {
            super();
            this.document = null;
            this.destroyed = new signaling_1.Signal0(this, "destroyed");
            this.change = new signaling_1.Signal0(this, "change");
            this.transformchange = new signaling_1.Signal0(this, "transformchange");
            this.exprchange = new signaling_1.Signal0(this, "exprchange");
            this.streaming = new signaling_1.Signal0(this, "streaming");
            this.patching = new signaling_1.Signal(this, "patching");
            this.properties = {};
            this._watchers = new WeakMap();
            this._pending = false;
            this._changing = false;
            const deferred = (0, types_1.isPlainObject)(attrs) && "id" in attrs;
            this.id = deferred ? attrs.id : (0, string_1.unique_id)();
            for (const [name, { type, default_value, options }] of (0, object_1.entries)(this._props)) {
                let property;
                if (type instanceof p.PropertyAlias) {
                    const property = this.properties[type.attr];
                    if (typeof property === "undefined") {
                        throw new Error(`can't resolve ${type.attr} before ${name} to create an alias`);
                    }
                    Object.defineProperty(this.properties, name, {
                        get: () => property,
                        configurable: false,
                        enumerable: false,
                    });
                }
                else {
                    if (type instanceof k.Kind) {
                        property = new p.PrimitiveProperty(this, name, type, default_value, options);
                    }
                    else {
                        property = new type(this, name, k.Any, default_value, options);
                    }
                    this.properties[name] = property;
                }
            }
            // allowing us to defer initialization when loading many models
            // when loading a bunch of models, we want to do initialization as a second pass
            // because other objects that this one depends on might not be loaded yet
            if (deferred) {
                (0, assert_1.assert)((0, object_1.keys)(attrs).length == 1, "'id' cannot be used together with property initializers");
            }
            else {
                this.initialize_props(attrs);
                this.finalize();
                this.connect_signals();
            }
        }
        initialize_props(vals) {
            const vals_proxy = (0, object_1.dict)(vals);
            const visited = new Set();
            for (const prop of this) {
                const val = vals_proxy.get(prop.attr);
                prop.initialize(val);
                visited.add(prop.attr);
            }
            for (const [attr, val] of vals_proxy) {
                if (!visited.has(attr)) {
                    // either throws for unknown properties or updates aliased properties
                    this.property(attr).set_value(val);
                }
            }
        }
        finalize() {
            this.initialize();
        }
        initialize() { }
        assert_initialized() {
            for (const prop of this) {
                if (prop.syncable && !prop.readonly) {
                    prop.get_value();
                }
            }
        }
        connect_signals() {
            for (const prop of this) {
                if (!(prop instanceof p.VectorSpec || prop instanceof p.ScalarSpec)) {
                    continue;
                }
                if (prop.is_unset) {
                    continue;
                }
                const value = prop.get_value();
                if (value.transform != null) {
                    this.connect(value.transform.change, () => this.transformchange.emit());
                }
                if ((0, vectorization_1.isExpr)(value)) {
                    this.connect(value.expr.change, () => this.exprchange.emit());
                }
            }
        }
        disconnect_signals() {
            signaling_1.Signal.disconnect_receiver(this);
        }
        destroy() {
            this.disconnect_signals();
            this.destroyed.emit();
        }
        // Create a new model with exact attribute values to this one, but new identity.
        clone(attrs) {
            const cloner = new cloneable_1.Cloner();
            const that = cloner.clone(this);
            if (attrs != null) {
                that.setv(attrs);
            }
            return that;
        }
        _clear_watchers() {
            this._watchers = new WeakMap();
        }
        changed_for(obj) {
            const changed = this._watchers.get(obj);
            this._watchers.set(obj, false);
            return changed ?? true;
        }
        // Set a hash of model attributes on the object, firing `"change"`. This is
        // the core primitive operation of a model, updating the data and notifying
        // anyone who needs to know about the change in state. The heart of the beast.
        _setv(changes, options) {
            // Extract attributes and options.
            const check_eq = options.check_eq;
            const changed = new Set();
            const changing = this._changing;
            this._changing = true;
            for (const [prop, value] of changes) {
                if (check_eq === false || prop.is_unset || !(0, eq_1.is_equal)(prop.get_value(), value)) {
                    prop.set_value(value);
                    changed.add(prop);
                }
            }
            // Trigger all relevant attribute changes.
            if (changed.size > 0) {
                this._clear_watchers();
                this._pending = true;
            }
            for (const prop of changed) {
                prop.change.emit();
            }
            // You might be wondering why there's a `while` loop here. Changes can
            // be recursively nested within `"change"` events.
            if (!changing) {
                if (!(options.no_change ?? false)) {
                    while (this._pending) {
                        this._pending = false;
                        this.change.emit();
                    }
                }
                this._pending = false;
                this._changing = false;
            }
            return changed;
        }
        setv(changed_attrs, options = {}) {
            const changes = (0, object_1.entries)(changed_attrs);
            if (changes.length == 0) {
                return;
            }
            if (options.silent ?? false) {
                this._clear_watchers();
                for (const [attr, value] of changes) {
                    this.properties[attr].set_value(value);
                }
                return;
            }
            const changed = new Map();
            const previous = new Map();
            for (const [attr, value] of changes) {
                const prop = this.properties[attr];
                changed.set(prop, value);
                previous.set(prop, prop.is_unset ? undefined : prop.get_value());
            }
            const updated = this._setv(changed, options);
            const { document } = this;
            if (document != null) {
                const changed = [];
                for (const [prop, value] of previous) {
                    if (updated.has(prop)) {
                        changed.push([prop, value, prop.get_value()]);
                    }
                }
                for (const [prop, _, new_value] of changed) {
                    if (prop.may_have_refs) {
                        document.partially_update_all_models(new_value);
                        break;
                    }
                }
                const sync = options.sync ?? true;
                this._push_changes(changed, sync);
            }
        }
        ref() {
            return { id: this.id };
        }
        *[Symbol.iterator]() {
            yield* (0, object_1.values)(this.properties);
        }
        *syncable_properties() {
            for (const prop of this) {
                if (prop.syncable) {
                    yield prop;
                }
            }
        }
        *own_properties() {
            const self = Object.getPrototypeOf(this);
            const base = Object.getPrototypeOf(self);
            const exclude = new Set((0, object_1.keys)(base._props));
            for (const prop of this) {
                if (!exclude.has(prop.attr)) {
                    yield prop;
                }
            }
        }
        // add all references from 'v' to 'result', if recurse
        // is true then descend into refs, if false only
        // descend into non-refs
        static _value_record_references(value, refs, options) {
            if (!(0, types_1.isObject)(value) || !(0, refs_1.may_have_refs)(value)) {
                return;
            }
            const { recursive } = options;
            if (value instanceof _a) {
                if (!refs.has(value)) {
                    refs.add(value);
                    if (recursive) {
                        for (const prop of value.syncable_properties()) {
                            if (!prop.is_unset && prop.may_have_refs) {
                                const value = prop.get_value();
                                _a._value_record_references(value, refs, { recursive });
                            }
                        }
                    }
                }
            }
            else if ((0, types_1.isIterable)(value)) {
                for (const elem of value) {
                    _a._value_record_references(elem, refs, { recursive });
                }
            }
            else if ((0, types_1.isPlainObject)(value)) {
                for (const elem of (0, object_1.values)(value)) {
                    _a._value_record_references(elem, refs, { recursive });
                }
            }
        }
        static references(value, options) {
            const refs = new Set();
            _a._value_record_references(value, refs, options);
            return refs;
        }
        references() {
            return _a.references(this, { recursive: true });
        }
        _doc_attached() { }
        _doc_detached() { }
        attach_document(doc) {
            // This should only be called by the Document implementation to set the document field
            if (this.document != null) {
                if (this.document == doc) {
                    return;
                }
                else {
                    throw new Error("models must be owned by only a single document");
                }
            }
            this.document = doc;
            this._doc_attached();
        }
        detach_document() {
            // This should only be called by the Document implementation to unset the document field
            if (this.document != null) {
                this._doc_detached();
                this.document = null;
            }
        }
        _push_changes(changes, sync) {
            if (!this.is_syncable) {
                return;
            }
            const { document } = this;
            if (document == null) {
                return;
            }
            const events = [];
            for (const [prop, , new_value] of changes) {
                if (prop.syncable) {
                    const event = new events_1.ModelChangedEvent(document, this, prop.attr, new_value);
                    event.sync = sync;
                    events.push(event);
                }
            }
            if (events.length != 0) {
                let event;
                if (events.length == 1) {
                    [event] = events;
                }
                else {
                    event = new events_1.DocumentEventBatch(document, events);
                }
                document._trigger_on_change(event);
            }
        }
        on_change(properties, fn) {
            for (const property of (0, types_1.isArray)(properties) ? properties : [properties]) {
                this.connect(property.change, fn);
            }
        }
        stream_to(prop, new_data, rollover, { sync } = {}) {
            const data = prop.get_value();
            (0, patching_1.stream_to_columns)(data, new_data, rollover);
            this._clear_watchers();
            prop.set_value(data);
            this.streaming.emit();
            if (this.document != null) {
                const event = new events_1.ColumnsStreamedEvent(this.document, this, prop.attr, new_data, rollover);
                event.sync = sync ?? true;
                this.document._trigger_on_change(event);
            }
        }
        patch_to(prop, patches, { sync } = {}) {
            const data = prop.get_value();
            const patched = (0, patching_1.patch_to_columns)(data, patches);
            this._clear_watchers();
            prop.set_value(data);
            this.patching.emit([...patched]);
            if (this.document != null) {
                const event = new events_1.ColumnsPatchedEvent(this.document, this, prop.attr, patches);
                event.sync = sync ?? true;
                this.document._trigger_on_change(event);
            }
        }
    }
    exports.HasProps = HasProps;
    _a = HasProps;
    (() => {
        _a.prototype._props = {};
        _a.prototype._mixins = [];
    })();
},
/* core/signaling.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.Signalable = Signalable;
    // Based on https://github.com/phosphorjs/phosphor/blob/master/packages/signaling/src/index.ts
    const defer_1 = require(17) /* ./util/defer */;
    const array_1 = require(10) /* ./util/array */;
    class Signal {
        constructor(sender, name) {
            this.sender = sender;
            this.name = name;
        }
        connect(slot, context = null) {
            if (!exports.receivers_for_sender.has(this.sender)) {
                exports.receivers_for_sender.set(this.sender, []);
            }
            const receivers = exports.receivers_for_sender.get(this.sender);
            if (find_connection(receivers, this, slot, context) != null) {
                return false;
            }
            const receiver = context ?? slot;
            if (!senders_for_receiver.has(receiver)) {
                senders_for_receiver.set(receiver, []);
            }
            const senders = senders_for_receiver.get(receiver);
            const connection = { signal: this, slot, context };
            receivers.push(connection);
            senders.push(connection);
            return true;
        }
        disconnect(slot, context = null) {
            const receivers = exports.receivers_for_sender.get(this.sender);
            if (receivers == null || receivers.length === 0) {
                return false;
            }
            const connection = find_connection(receivers, this, slot, context);
            if (connection == null) {
                return false;
            }
            const receiver = context ?? slot;
            const senders = senders_for_receiver.get(receiver);
            connection.signal = null;
            schedule_cleanup(receivers);
            schedule_cleanup(senders);
            return true;
        }
        emit(args) {
            const receivers = exports.receivers_for_sender.get(this.sender) ?? [];
            for (const { signal, slot, context } of receivers) {
                if (signal === this) {
                    slot.call(context, args, this.sender);
                }
            }
        }
    }
    exports.Signal = Signal;
    Signal.__name__ = "Signal";
    class Signal0 extends Signal {
        emit() {
            super.emit(undefined);
        }
    }
    exports.Signal0 = Signal0;
    Signal0.__name__ = "Signal0";
    (function (Signal) {
        function disconnect_between(sender, receiver) {
            const receivers = exports.receivers_for_sender.get(sender);
            if (receivers == null || receivers.length === 0) {
                return;
            }
            const senders = senders_for_receiver.get(receiver);
            if (senders == null || senders.length === 0) {
                return;
            }
            for (const connection of senders) {
                if (connection.signal == null) {
                    return;
                }
                if (connection.signal.sender === sender) {
                    connection.signal = null;
                }
            }
            schedule_cleanup(receivers);
            schedule_cleanup(senders);
        }
        Signal.disconnect_between = disconnect_between;
        function disconnect_sender(sender) {
            const receivers = exports.receivers_for_sender.get(sender);
            if (receivers == null || receivers.length === 0) {
                return;
            }
            for (const connection of receivers) {
                if (connection.signal == null) {
                    return;
                }
                const receiver = connection.context ?? connection.slot;
                connection.signal = null;
                schedule_cleanup(senders_for_receiver.get(receiver));
            }
            schedule_cleanup(receivers);
        }
        Signal.disconnect_sender = disconnect_sender;
        function disconnect_receiver(receiver, slot, except_senders) {
            const senders = senders_for_receiver.get(receiver);
            if (senders == null || senders.length === 0) {
                return;
            }
            for (const connection of senders) {
                if (connection.signal == null) {
                    return;
                }
                if (slot != null && connection.slot != slot) {
                    continue;
                }
                const sender = connection.signal.sender;
                if (except_senders != null && except_senders.has(sender)) {
                    continue;
                }
                connection.signal = null;
                schedule_cleanup(exports.receivers_for_sender.get(sender));
            }
            schedule_cleanup(senders);
        }
        Signal.disconnect_receiver = disconnect_receiver;
        function disconnect_all(obj) {
            const receivers = exports.receivers_for_sender.get(obj);
            if (receivers != null && receivers.length !== 0) {
                for (const connection of receivers) {
                    connection.signal = null;
                }
                schedule_cleanup(receivers);
            }
            const senders = senders_for_receiver.get(obj);
            if (senders != null && senders.length !== 0) {
                for (const connection of senders) {
                    connection.signal = null;
                }
                schedule_cleanup(senders);
            }
        }
        Signal.disconnect_all = disconnect_all;
    })(Signal || (exports.Signal = Signal = {}));
    function Signalable() {
        return class {
            connect(signal, slot) {
                return signal.connect(slot, this);
            }
            disconnect(signal, slot) {
                return signal.disconnect(slot, this);
            }
        };
    }
    /** @internal */
    exports.receivers_for_sender = new WeakMap();
    const senders_for_receiver = new WeakMap();
    function find_connection(conns, signal, slot, context) {
        return (0, array_1.find)(conns, conn => conn.signal === signal && conn.slot === slot && conn.context === context);
    }
    const dirty_set = new Set();
    function schedule_cleanup(connections) {
        if (dirty_set.size == 0) {
            void (async () => {
                await (0, defer_1.defer)();
                cleanup_dirty_set();
            })();
        }
        dirty_set.add(connections);
    }
    function cleanup_dirty_set() {
        for (const connections of dirty_set) {
            (0, array_1.remove_by)(connections, (connection) => connection.signal == null);
        }
        dirty_set.clear();
    }
},
/* core/util/defer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.defer = defer;
    exports.delay = delay;
    exports.poll = poll;
    exports.paint = paint;
    exports.idle = idle;
    const channel = new MessageChannel();
    const tasks = new Map();
    channel.port1.onmessage = (event) => {
        const handle = event.data;
        const fn = tasks.get(handle);
        if (fn != null) {
            try {
                fn();
            }
            finally {
                tasks.delete(handle);
            }
        }
    };
    let counter = 1;
    function defer() {
        return new Promise((resolve) => {
            const handle = counter++;
            tasks.set(handle, resolve);
            channel.port2.postMessage(handle);
        });
    }
    function delay(ms) {
        return new Promise((resolve) => setTimeout(resolve, ms));
    }
    async function poll(fn, interval = 50, timeout = 500) {
        while (!fn() && timeout >= 0) {
            await delay(interval);
            timeout -= interval;
        }
    }
    function paint() {
        return new Promise((resolve) => {
            requestAnimationFrame(() => resolve());
        });
    }
    function idle() {
        return new Promise((resolve) => {
            requestIdleCallback(() => resolve());
        });
    }
},
/* core/util/refs.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.is_ref = is_ref;
    exports.is_HasRefs = is_HasRefs;
    exports.may_have_refs = may_have_refs;
    const types_1 = require(8) /* ./types */;
    function is_ref(obj) {
        return (0, types_1.isPlainObject)(obj) && "id" in obj && !("type" in obj);
    }
    exports.has_refs = Symbol("has_refs");
    function _is_HasRefs(v) {
        return exports.has_refs in v;
    }
    function is_HasRefs(v) {
        return (0, types_1.isObject)(v) && _is_HasRefs(v);
    }
    function may_have_refs(obj) {
        if (_is_HasRefs(obj)) {
            return obj[exports.has_refs];
        }
        const type = obj.constructor;
        if (is_HasRefs(type)) {
            return type[exports.has_refs];
        }
        return true;
    }
},
/* core/properties.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.TextBaselineSpec = exports.TextAlignSpec = exports.FontStyleSpec = exports.FontSizeSpec = exports.FontSpec = exports.LineDashSpec = exports.LineCapSpec = exports.LineJoinSpec = exports.MarkerSpec = exports.ExtMarkerType = exports.ArraySpec = exports.NullStringSpec = void 0;
    exports.isSpec = isSpec;
    exports.use_theme = use_theme;
    exports.Alias = Alias;
    const tslib_1 = require(1) /* tslib */;
    const signaling_1 = require(16) /* ./signaling */;
    const logging_1 = require(20) /* ./logging */;
    const enums = tslib_1.__importStar(require(21) /* ./enums */);
    const types_1 = require(25) /* ./types */;
    const array_1 = require(10) /* ./util/array */;
    const arrayable_1 = require(13) /* ./util/arrayable */;
    const math_1 = require(11) /* ./util/math */;
    const color_1 = require(23) /* ./util/color */;
    const platform_1 = require(28) /* ./util/platform */;
    const types_2 = require(8) /* ./util/types */;
    const vectorization_1 = require(29) /* ./vectorization */;
    const settings_1 = require(30) /* ./settings */;
    const kinds_1 = require(22) /* ./kinds */;
    const ndarray_1 = require(31) /* ./util/ndarray */;
    const diagnostics_1 = require(38) /* ./diagnostics */;
    const assert_1 = require(12) /* ./util/assert */;
    const serialization_1 = require(33) /* ./serialization */;
    const uniforms_1 = require(39) /* ./uniforms */;
    __esExport("Uniform", uniforms_1.Uniform);
    __esExport("UniformScalar", uniforms_1.UniformScalar);
    __esExport("UniformVector", uniforms_1.UniformVector);
    function valueToString(value) {
        try {
            return JSON.stringify(value);
        }
        catch {
            return value.toString();
        }
    }
    function isSpec(obj) {
        return (0, types_2.isPlainObject)(obj) &&
            ((obj.value === undefined ? 0 : 1) +
                (obj.field === undefined ? 0 : 1) +
                (obj.expr === undefined ? 0 : 1) == 1); // garbage JS XOR
    }
    let global_theme = null;
    function use_theme(theme = null) {
        global_theme = theme;
    }
    exports.unset = Symbol("unset");
    class UnsetValueError extends Error {
    }
    exports.UnsetValueError = UnsetValueError;
    UnsetValueError.__name__ = "UnsetValueError";
    class Property {
        get syncable() {
            return !this.internal;
        }
        get is_unset() {
            return this._value === exports.unset;
        }
        get initialized() {
            return this._initialized;
        }
        initialize(initial_value = exports.unset) {
            if (this._initialized) {
                throw new Error("already initialized");
            }
            let attr_value = exports.unset;
            if (initial_value !== exports.unset) {
                attr_value = initial_value;
                this._dirty = true;
            }
            else {
                const value = this._default_override();
                if (value !== exports.unset) {
                    attr_value = value;
                }
                else {
                    let themed = false;
                    if (global_theme != null) {
                        const value = global_theme.get(this.obj, this.attr);
                        if (value !== undefined) {
                            attr_value = value;
                            themed = true;
                        }
                    }
                    if (!themed) {
                        attr_value = this.default_value(this.obj);
                    }
                }
            }
            if (attr_value !== exports.unset) {
                if (this.kind.coerce != null) {
                    attr_value = this.kind.coerce(attr_value);
                }
                this._update(attr_value);
            }
            else {
                this._value = exports.unset;
            }
            this._initialized = true;
        }
        get_value() {
            if (this._value !== exports.unset) {
                return this._value;
            }
            else {
                throw new UnsetValueError(`${this.obj}.${this.attr} is unset`);
            }
        }
        set_value(val) {
            if (!this._initialized) {
                this.initialize(val);
            }
            else {
                this._update(val);
                this._dirty = true;
            }
            diagnostics_1.diagnostics.report(this);
        }
        // abstract _intrinsic_default(): T
        _default_override() {
            return exports.unset;
        }
        get dirty() {
            return this._dirty;
        }
        constructor(obj, attr, kind, default_value, options = {}) {
            this._value = exports.unset;
            this._initialized = false;
            this._dirty = false;
            this.obj = obj;
            this.attr = attr;
            this.kind = kind;
            this.default_value = default_value;
            this.change = new signaling_1.Signal0(this.obj, "change");
            this.internal = options.internal ?? false;
            this.readonly = options.readonly ?? false;
            this.convert = options.convert;
            this.on_update = options.on_update;
            this.may_have_refs = kind.may_have_refs();
        }
        //protected abstract _update(attr_value: T): void
        _update(attr_value) {
            this.validate(attr_value);
            if (this.convert != null) {
                const converted = this.convert(attr_value, this.obj);
                if (converted !== undefined) {
                    attr_value = converted;
                }
            }
            this._value = attr_value;
            this.on_update?.(attr_value, this.obj);
        }
        toString() {
            /*${this.name}*/
            return `Prop(${this.obj}.${this.attr}, value: ${valueToString(this._value)})`;
        }
        // ----- customizable policies
        normalize(values) {
            return values;
        }
        validate(value) {
            if (!this.valid(value)) {
                throw new Error(`${this.obj}.${this.attr} given invalid value: ${valueToString(value)}`);
            }
        }
        valid(value) {
            return this.kind.valid(value);
        }
    }
    exports.Property = Property;
    Property.__name__ = "Property";
    class PropertyAlias {
        constructor(attr) {
            this.attr = attr;
        }
    }
    exports.PropertyAlias = PropertyAlias;
    PropertyAlias.__name__ = "PropertyAlias";
    function Alias(attr) {
        return new PropertyAlias(attr);
    }
    //
    // Primitive Properties
    //
    class PrimitiveProperty extends Property {
    }
    exports.PrimitiveProperty = PrimitiveProperty;
    PrimitiveProperty.__name__ = "PrimitiveProperty";
    class Font extends PrimitiveProperty {
        _default_override() {
            return settings_1.settings.dev ? "Bokeh" : exports.unset;
        }
    }
    exports.Font = Font;
    Font.__name__ = "Font";
    //
    // DataSpec properties
    //
    class ScalarSpec extends Property {
        constructor() {
            super(...arguments);
            this._value = exports.unset;
        }
        get_value() {
            if (this._value !== exports.unset) {
                return this._value;
            }
            else {
                throw new Error(`${this.obj}.${this.attr} is unset`);
            }
        }
        _update(attr_value) {
            if (isSpec(attr_value)) {
                this._value = attr_value;
            }
            else {
                this._value = { value: attr_value }; // Value<T>
            }
            if ((0, types_2.isPlainObject)(this._value)) {
                const { _value } = this;
                this._value[serialization_1.serialize] = (serializer) => {
                    const { value, field, expr, transform, units } = _value;
                    return serializer.encode_struct((() => {
                        if (value !== undefined) {
                            return { type: "value", value, transform, units };
                        }
                        else if (field !== undefined) {
                            return { type: "field", field, transform, units };
                        }
                        else {
                            return { type: "expr", expr, transform, units };
                        }
                    })());
                };
            }
            if ((0, vectorization_1.isValue)(this._value)) {
                this.validate(this._value.value);
            }
        }
        materialize(value) {
            return value;
        }
        scalar(value, n) {
            return new uniforms_1.UniformScalar(value, n);
        }
        uniform(source) {
            const obj = this.get_value();
            const n = source.get_length() ?? 1;
            if ((0, vectorization_1.isExpr)(obj)) {
                const { expr, transform } = obj;
                let result = expr.compute(source);
                if (transform != null) {
                    result = transform.compute(result);
                }
                result = this.materialize(result);
                return this.scalar(result, n);
            }
            else {
                const { value, transform } = obj;
                let result = value;
                if (transform != null) {
                    result = transform.compute(result);
                }
                result = this.materialize(result);
                return this.scalar(result, n);
            }
        }
    }
    exports.ScalarSpec = ScalarSpec;
    ScalarSpec.__name__ = "ScalarSpec";
    /** @deprecated */
    class AnyScalar extends ScalarSpec {
    }
    exports.AnyScalar = AnyScalar;
    AnyScalar.__name__ = "AnyScalar";
    class DictScalar extends ScalarSpec {
    }
    exports.DictScalar = DictScalar;
    DictScalar.__name__ = "DictScalar";
    class ColorScalar extends ScalarSpec {
    }
    exports.ColorScalar = ColorScalar;
    ColorScalar.__name__ = "ColorScalar";
    class NumberScalar extends ScalarSpec {
    }
    exports.NumberScalar = NumberScalar;
    NumberScalar.__name__ = "NumberScalar";
    class StringScalar extends ScalarSpec {
    }
    exports.StringScalar = StringScalar;
    StringScalar.__name__ = "StringScalar";
    class NullStringScalar extends ScalarSpec {
    }
    exports.NullStringScalar = NullStringScalar;
    NullStringScalar.__name__ = "NullStringScalar";
    class ArrayScalar extends ScalarSpec {
    }
    exports.ArrayScalar = ArrayScalar;
    ArrayScalar.__name__ = "ArrayScalar";
    class LineJoinScalar extends ScalarSpec {
    }
    exports.LineJoinScalar = LineJoinScalar;
    LineJoinScalar.__name__ = "LineJoinScalar";
    class LineCapScalar extends ScalarSpec {
    }
    exports.LineCapScalar = LineCapScalar;
    LineCapScalar.__name__ = "LineCapScalar";
    class LineDashScalar extends ScalarSpec {
    }
    exports.LineDashScalar = LineDashScalar;
    LineDashScalar.__name__ = "LineDashScalar";
    class FontScalar extends ScalarSpec {
        _default_override() {
            return settings_1.settings.dev ? "Bokeh" : exports.unset;
        }
    }
    exports.FontScalar = FontScalar;
    FontScalar.__name__ = "FontScalar";
    class FontSizeScalar extends ScalarSpec {
    }
    exports.FontSizeScalar = FontSizeScalar;
    FontSizeScalar.__name__ = "FontSizeScalar";
    class FontStyleScalar extends ScalarSpec {
    }
    exports.FontStyleScalar = FontStyleScalar;
    FontStyleScalar.__name__ = "FontStyleScalar";
    class TextAlignScalar extends ScalarSpec {
    }
    exports.TextAlignScalar = TextAlignScalar;
    TextAlignScalar.__name__ = "TextAlignScalar";
    class TextBaselineScalar extends ScalarSpec {
    }
    exports.TextBaselineScalar = TextBaselineScalar;
    TextBaselineScalar.__name__ = "TextBaselineScalar";
    class VectorSpec extends Property {
        constructor() {
            super(...arguments);
            this._value = exports.unset;
        }
        get_value() {
            if (this._value !== exports.unset) {
                return this._value;
            }
            else {
                throw new Error(`${this.obj}.${this.attr} is unset`);
            }
        }
        _update(attr_value) {
            if (isSpec(attr_value)) {
                this._value = attr_value;
            }
            else {
                this._value = { value: attr_value };
            } // Value<T>
            if ((0, types_2.isPlainObject)(this._value)) {
                const { _value } = this;
                this._value[serialization_1.serialize] = (serializer) => {
                    const { value, field, expr, transform, units } = _value;
                    return serializer.encode_struct((() => {
                        if (value !== undefined) {
                            return { type: "value", value, transform, units };
                        }
                        else if (field !== undefined) {
                            return { type: "field", field, transform, units };
                        }
                        else {
                            return { type: "expr", expr, transform, units };
                        }
                    })());
                };
            }
            if ((0, vectorization_1.isValue)(this._value)) {
                this.validate(this._value.value);
            }
        }
        materialize(value) {
            return value;
        }
        v_materialize(values) {
            return values;
        }
        scalar(value, n) {
            return new uniforms_1.UniformScalar(value, n);
        }
        vector(values) {
            return new uniforms_1.UniformVector(values);
        }
        uniform(source) {
            const obj = this.get_value();
            const n = source.get_length() ?? 1;
            if ((0, vectorization_1.isField)(obj)) {
                const { field, transform } = obj;
                let array = source.get_column(field);
                if (array != null) {
                    if (transform != null) {
                        array = transform.v_compute(array);
                    }
                    array = this.v_materialize(array);
                    return this.vector(array);
                }
                else {
                    const message = `attempted to retrieve property array for nonexistent field '${field}'`;
                    if (settings_1.settings.force_fields) {
                        throw new Error(message);
                    }
                    else {
                        logging_1.logger.warn(message);
                    }
                    return this.scalar(null, n);
                }
            }
            else if ((0, vectorization_1.isExpr)(obj)) {
                const { expr, transform } = obj;
                let array = expr.v_compute(source);
                if (transform != null) {
                    array = transform.v_compute(array);
                }
                array = this.v_materialize(array);
                return this.vector(array);
            }
            else if ((0, vectorization_1.isValue)(obj)) {
                const { value, transform } = obj;
                let result = value;
                if (transform != null) {
                    result = transform.compute(result);
                }
                result = this.materialize(result);
                return this.scalar(result, n);
            }
            else {
                (0, assert_1.unreachable)();
            }
        }
        array(source) {
            let array;
            const length = source.get_length() ?? 1;
            const obj = this.get_value();
            if ((0, vectorization_1.isField)(obj)) {
                const { field } = obj;
                const column = source.get_column(field);
                if (column != null) {
                    array = this.normalize(column);
                }
                else {
                    const message = `attempted to retrieve property array for nonexistent field '${field}'`;
                    if (settings_1.settings.force_fields) {
                        throw new Error(message);
                    }
                    else {
                        logging_1.logger.warn(message);
                    }
                    const missing = new Float64Array(length);
                    missing.fill(NaN);
                    array = missing;
                }
            }
            else if ((0, vectorization_1.isExpr)(obj)) {
                const { expr } = obj;
                array = this.normalize(expr.v_compute(source));
            }
            else {
                const value = this.normalize([obj.value])[0];
                if ((0, types_2.isNumber)(value)) {
                    const values = new Float64Array(length);
                    values.fill(value);
                    array = values;
                }
                else {
                    array = (0, array_1.repeat)(value, length);
                }
            }
            const { transform } = obj;
            if (transform != null) {
                array = transform.v_compute(array);
            }
            return array;
        }
    }
    exports.VectorSpec = VectorSpec;
    VectorSpec.__name__ = "VectorSpec";
    class DataSpec extends VectorSpec {
    }
    exports.DataSpec = DataSpec;
    DataSpec.__name__ = "DataSpec";
    class UnitsSpec extends VectorSpec {
        constructor() {
            super(...arguments);
            this._value = exports.unset;
        }
        _update(attr_value) {
            super._update(attr_value);
            if (this._value !== exports.unset) {
                const { units } = this._value;
                if (units != null && !(0, array_1.includes)(this.valid_units, units)) {
                    throw new Error(`units must be one of ${this.valid_units.join(", ")}; got: ${units}`);
                }
            }
        }
        get units() {
            return this._value !== exports.unset ? this._value.units ?? this.default_units : this.default_units;
        }
        set units(units) {
            if (this._value !== exports.unset) {
                if (units != this.default_units) {
                    this._value.units = units;
                }
                else {
                    delete this._value.units;
                }
            }
            else {
                throw new Error(`${this.obj}.${this.attr} is unset`);
            }
        }
    }
    exports.UnitsSpec = UnitsSpec;
    UnitsSpec.__name__ = "UnitsSpec";
    class NumberUnitsSpec extends UnitsSpec {
        array(source) {
            return new Float64Array(super.array(source));
        }
    }
    exports.NumberUnitsSpec = NumberUnitsSpec;
    NumberUnitsSpec.__name__ = "NumberUnitsSpec";
    class BaseCoordinateSpec extends DataSpec {
    }
    exports.BaseCoordinateSpec = BaseCoordinateSpec;
    BaseCoordinateSpec.__name__ = "BaseCoordinateSpec";
    class CoordinateSpec extends BaseCoordinateSpec {
    }
    exports.CoordinateSpec = CoordinateSpec;
    CoordinateSpec.__name__ = "CoordinateSpec";
    class CoordinateSeqSpec extends BaseCoordinateSpec {
    }
    exports.CoordinateSeqSpec = CoordinateSeqSpec;
    CoordinateSeqSpec.__name__ = "CoordinateSeqSpec";
    class CoordinateSeqSeqSeqSpec extends BaseCoordinateSpec {
    }
    exports.CoordinateSeqSeqSeqSpec = CoordinateSeqSeqSeqSpec;
    CoordinateSeqSeqSeqSpec.__name__ = "CoordinateSeqSeqSeqSpec";
    class XCoordinateSpec extends CoordinateSpec {
        constructor() {
            super(...arguments);
            this.dimension = "x";
        }
    }
    exports.XCoordinateSpec = XCoordinateSpec;
    XCoordinateSpec.__name__ = "XCoordinateSpec";
    class YCoordinateSpec extends CoordinateSpec {
        constructor() {
            super(...arguments);
            this.dimension = "y";
        }
    }
    exports.YCoordinateSpec = YCoordinateSpec;
    YCoordinateSpec.__name__ = "YCoordinateSpec";
    class XCoordinateSeqSpec extends CoordinateSeqSpec {
        constructor() {
            super(...arguments);
            this.dimension = "x";
        }
    }
    exports.XCoordinateSeqSpec = XCoordinateSeqSpec;
    XCoordinateSeqSpec.__name__ = "XCoordinateSeqSpec";
    class YCoordinateSeqSpec extends CoordinateSeqSpec {
        constructor() {
            super(...arguments);
            this.dimension = "y";
        }
    }
    exports.YCoordinateSeqSpec = YCoordinateSeqSpec;
    YCoordinateSeqSpec.__name__ = "YCoordinateSeqSpec";
    class XCoordinateSeqSeqSeqSpec extends CoordinateSeqSeqSeqSpec {
        constructor() {
            super(...arguments);
            this.dimension = "x";
        }
    }
    exports.XCoordinateSeqSeqSeqSpec = XCoordinateSeqSeqSeqSpec;
    XCoordinateSeqSeqSeqSpec.__name__ = "XCoordinateSeqSeqSeqSpec";
    class YCoordinateSeqSeqSeqSpec extends CoordinateSeqSeqSeqSpec {
        constructor() {
            super(...arguments);
            this.dimension = "y";
        }
    }
    exports.YCoordinateSeqSeqSeqSpec = YCoordinateSeqSeqSeqSpec;
    YCoordinateSeqSeqSeqSpec.__name__ = "YCoordinateSeqSeqSeqSpec";
    class AngleSpec extends NumberUnitsSpec {
        get default_units() {
            return "rad";
        }
        get valid_units() {
            return [...enums.AngleUnits];
        }
        materialize(value) {
            const coeff = -(0, math_1.to_radians_coeff)(this.units);
            return value * coeff;
        }
        v_materialize(values) {
            const coeff = -(0, math_1.to_radians_coeff)(this.units);
            const result = new Float32Array(values.length);
            (0, arrayable_1.mul)(values, coeff, result); // TODO: in-place?
            return result;
        }
        array(_source) {
            throw new Error("not supported");
        }
    }
    exports.AngleSpec = AngleSpec;
    AngleSpec.__name__ = "AngleSpec";
    class DistanceSpec extends NumberUnitsSpec {
        get default_units() {
            return "data";
        }
        get valid_units() {
            return [...enums.SpatialUnits];
        }
    }
    exports.DistanceSpec = DistanceSpec;
    DistanceSpec.__name__ = "DistanceSpec";
    class NullDistanceSpec extends DistanceSpec {
        materialize(value) {
            return value ?? NaN;
        }
    }
    exports.NullDistanceSpec = NullDistanceSpec;
    NullDistanceSpec.__name__ = "NullDistanceSpec";
    class BooleanSpec extends DataSpec {
        v_materialize(values) {
            return new Uint8Array(values);
        }
        array(source) {
            return new Uint8Array(super.array(source));
        }
    }
    exports.BooleanSpec = BooleanSpec;
    BooleanSpec.__name__ = "BooleanSpec";
    class IntSpec extends DataSpec {
        v_materialize(values) {
            return (0, types_2.isTypedArray)(values) ? values : new Int32Array(values);
        }
        array(source) {
            return new Int32Array(super.array(source));
        }
    }
    exports.IntSpec = IntSpec;
    IntSpec.__name__ = "IntSpec";
    class NumberSpec extends DataSpec {
        v_materialize(values) {
            return (0, types_2.isTypedArray)(values) ? values : new Float64Array(values);
        }
        array(source) {
            return new Float64Array(super.array(source));
        }
    }
    exports.NumberSpec = NumberSpec;
    NumberSpec.__name__ = "NumberSpec";
    class ScreenSizeSpec extends NumberSpec {
        valid(value) {
            return (0, types_2.isNumber)(value) && value >= 0;
        }
    }
    exports.ScreenSizeSpec = ScreenSizeSpec;
    ScreenSizeSpec.__name__ = "ScreenSizeSpec";
    class ColorSpec extends DataSpec {
        materialize(color) {
            return (0, color_1.encode_rgba)((0, color_1.color2rgba)(color));
        }
        v_materialize(colors) {
            if ((0, ndarray_1.is_NDArray)(colors)) {
                if (colors.dtype == "uint32" && colors.dimension == 1) {
                    return (0, platform_1.to_big_endian)(colors);
                }
                else if (colors.dtype == "uint8" && colors.dimension == 1) {
                    const [n] = colors.shape;
                    const array = new types_1.RGBAArray(4 * n);
                    let j = 0;
                    for (const gray of colors) {
                        array[j++] = gray;
                        array[j++] = gray;
                        array[j++] = gray;
                        array[j++] = 255;
                    }
                    return new types_1.ColorArray(array.buffer);
                }
                else if (colors.dtype == "uint8" && colors.dimension == 2) {
                    const [n, d] = colors.shape;
                    if (d == 4) {
                        return new types_1.ColorArray(colors.buffer);
                    }
                    else if (d == 3) {
                        const array = new types_1.RGBAArray(4 * n);
                        for (let i = 0, j = 0; i < d * n;) {
                            array[j++] = colors[i++];
                            array[j++] = colors[i++];
                            array[j++] = colors[i++];
                            array[j++] = 255;
                        }
                        return new types_1.ColorArray(array.buffer);
                    }
                }
                else if ((colors.dtype == "float32" || colors.dtype == "float64") && colors.dimension == 2) {
                    const [n, d] = colors.shape;
                    if (d == 3 || d == 4) {
                        const array = new types_1.RGBAArray(4 * n);
                        for (let i = 0, j = 0; i < d * n;) {
                            array[j++] = colors[i++] * 255;
                            array[j++] = colors[i++] * 255;
                            array[j++] = colors[i++] * 255;
                            array[j++] = (d == 3 ? 1 : colors[i++]) * 255;
                        }
                        return new types_1.ColorArray(array.buffer);
                    }
                }
                else if (colors.dtype == "object" && colors.dimension == 1) {
                    return this._from_css_array(colors);
                }
            }
            else {
                return this._from_css_array(colors);
            }
            throw new Error("invalid color array");
        }
        _from_css_array(colors) {
            const n = colors.length;
            const array = new types_1.RGBAArray(4 * n);
            let j = 0;
            for (const color of colors) {
                const [r, g, b, a] = (0, color_1.color2rgba)(color);
                array[j++] = r;
                array[j++] = g;
                array[j++] = b;
                array[j++] = a;
            }
            return new types_1.ColorArray(array.buffer);
        }
        vector(values) {
            return new uniforms_1.ColorUniformVector(values);
        }
    }
    exports.ColorSpec = ColorSpec;
    ColorSpec.__name__ = "ColorSpec";
    class NDArraySpec extends DataSpec {
    }
    exports.NDArraySpec = NDArraySpec;
    NDArraySpec.__name__ = "NDArraySpec";
    /** @deprecated */
    class AnySpec extends DataSpec {
    }
    exports.AnySpec = AnySpec;
    AnySpec.__name__ = "AnySpec";
    class StringSpec extends DataSpec {
    }
    exports.StringSpec = StringSpec;
    StringSpec.__name__ = "StringSpec";
    class NullStringSpec extends DataSpec {
    }
    exports.NullStringSpec = NullStringSpec;
    NullStringSpec.__name__ = "NullStringSpec";
    class ArraySpec extends DataSpec {
    }
    exports.ArraySpec = ArraySpec;
    ArraySpec.__name__ = "ArraySpec";
    exports.ExtMarkerType = (0, kinds_1.PrefixedStr)("@");
    class MarkerSpec extends DataSpec {
    }
    exports.MarkerSpec = MarkerSpec;
    MarkerSpec.__name__ = "MarkerSpec";
    class LineJoinSpec extends DataSpec {
    }
    exports.LineJoinSpec = LineJoinSpec;
    LineJoinSpec.__name__ = "LineJoinSpec";
    class LineCapSpec extends DataSpec {
    }
    exports.LineCapSpec = LineCapSpec;
    LineCapSpec.__name__ = "LineCapSpec";
    class LineDashSpec extends DataSpec {
    }
    exports.LineDashSpec = LineDashSpec;
    LineDashSpec.__name__ = "LineDashSpec";
    class FontSpec extends DataSpec {
        _default_override() {
            return settings_1.settings.dev ? "Bokeh" : exports.unset;
        }
    }
    exports.FontSpec = FontSpec;
    FontSpec.__name__ = "FontSpec";
    class FontSizeSpec extends DataSpec {
    }
    exports.FontSizeSpec = FontSizeSpec;
    FontSizeSpec.__name__ = "FontSizeSpec";
    class FontStyleSpec extends DataSpec {
    }
    exports.FontStyleSpec = FontStyleSpec;
    FontStyleSpec.__name__ = "FontStyleSpec";
    class TextAlignSpec extends DataSpec {
    }
    exports.TextAlignSpec = TextAlignSpec;
    TextAlignSpec.__name__ = "TextAlignSpec";
    class TextBaselineSpec extends DataSpec {
    }
    exports.TextBaselineSpec = TextBaselineSpec;
    TextBaselineSpec.__name__ = "TextBaselineSpec";
},
/* core/logging.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.set_log_level = set_log_level;
    exports.with_log_level = with_log_level;
    // This is based on https://github.com/pimterry/loglevel
    const types_1 = require(8) /* ./util/types */;
    const object_1 = require(9) /* ./util/object */;
    const version_1 = require(3) /* ../version */;
    const _loggers = {};
    class LogLevel {
        constructor(name, level, method) {
            this.name = name;
            this.level = level;
            this.method = method;
        }
    }
    exports.LogLevel = LogLevel;
    LogLevel.__name__ = "LogLevel";
    class Logger {
        static get levels() {
            return Object.keys(Logger.log_levels);
        }
        static get(name, level = Logger.INFO) {
            if (name.length > 0) {
                if (name in _loggers) {
                    return _loggers[name];
                }
                else {
                    return _loggers[name] = new Logger(name, level);
                }
            }
            else {
                throw new TypeError("Logger.get() expects a non-empty string name and an optional log-level");
            }
        }
        constructor(name, level = Logger.INFO) {
            this._name = name;
            this.set_level(level);
        }
        get level() {
            return this.get_level();
        }
        get_level() {
            return this._log_level;
        }
        set_level(log_level) {
            if (log_level instanceof LogLevel) {
                this._log_level = log_level;
            }
            else if (Logger.log_levels.hasOwnProperty(log_level)) {
                this._log_level = Logger.log_levels[log_level];
            }
            else {
                throw new Error("Logger.set_level() expects a log-level object or a string name of a log-level");
            }
            const prefix = `[${this._name}]`;
            for (const { level, method } of (0, object_1.values)(Logger.log_levels)) {
                if (level < this._log_level.level || this._log_level.level === Logger.OFF.level) {
                    this[method] = function () { };
                }
                else {
                    this[method] = _method_factory(method, prefix);
                }
            }
            this.log = _method_factory("log", prefix);
        }
        log(..._args) { }
        trace(..._args) { }
        debug(..._args) { }
        info(..._args) { }
        warn(..._args) { }
        error(..._args) { }
    }
    exports.Logger = Logger;
    Logger.__name__ = "Logger";
    Logger.TRACE = new LogLevel("trace", 0, "trace");
    Logger.DEBUG = new LogLevel("debug", 1, "debug");
    Logger.INFO = new LogLevel("info", 2, "info");
    Logger.WARN = new LogLevel("warn", 6, "warn");
    Logger.ERROR = new LogLevel("error", 7, "error");
    Logger.FATAL = new LogLevel("fatal", 8, "error");
    Logger.OFF = new LogLevel("off", 9, "log");
    Logger.log_levels = {
        trace: Logger.TRACE,
        debug: Logger.DEBUG,
        info: Logger.INFO,
        warn: Logger.WARN,
        error: Logger.ERROR,
        fatal: Logger.FATAL,
        off: Logger.OFF,
    };
    function _method_factory(method_name, prefix) {
        const method = console[method_name];
        const fn = typeof method != "undefined" ? method : console.log;
        return fn.bind(console, prefix);
    }
    exports.logger = Logger.get(`bokeh ${version_1.version}`);
    function set_log_level(level) {
        const previous_level = exports.logger.level;
        if ((0, types_1.isString)(level) && !(level in Logger.log_levels)) {
            exports.logger.log(`unrecognized logging level '${level}' passed to Bokeh.set_log_level(), ignoring`);
            exports.logger.log(`valid log levels are: ${Logger.levels.join(", ")}`);
        }
        else {
            exports.logger.log(`setting log level to: '${(0, types_1.isString)(level) ? level : level.level}'`);
            exports.logger.set_level(level);
        }
        return previous_level;
    }
    function with_log_level(level, fn) {
        const original = set_log_level(level);
        try {
            fn();
        }
        finally {
            set_log_level(original);
        }
    }
},
/* core/enums.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.ToolName = exports.ToolIcon = exports.WindowAxis = exports.VerticalAlign = exports.UpdateMode = exports.TooltipAttachment = exports.LabelOrientation = exports.TextureRepetition = exports.TextBaseline = exports.TextAlign = exports.TapGesture = exports.TapBehavior = exports.StepMode = exports.StartEnd = exports.SpatialUnits = exports.Sort = exports.SizingMode = exports.Side = exports.SelectionMode = exports.RegionSelectionMode = void 0;
    const kinds_1 = require(22) /* ./kinds */;
    exports.Align = (0, kinds_1.Enum)("start", "center", "end");
    exports.HAlign = (0, kinds_1.Enum)("left", "center", "right");
    exports.VAlign = (0, kinds_1.Enum)("top", "center", "bottom");
    exports.Anchor = (0, kinds_1.Enum)("top_left", "top_center", "top_right", "center_left", "center_center", "center_right", "bottom_left", "bottom_center", "bottom_right", "top", "left", "center", "right", "bottom");
    exports.AngleUnits = (0, kinds_1.Enum)("deg", "rad", "grad", "turn");
    exports.AlternationPolicy = (0, kinds_1.Enum)("none", "even", "odd", "every");
    exports.BoxOrigin = (0, kinds_1.Enum)("corner", "center");
    exports.ButtonType = (0, kinds_1.Enum)("default", "primary", "success", "warning", "danger", "light");
    exports.CalendarPosition = (0, kinds_1.Enum)("auto", "above", "below");
    exports.Clock = (0, kinds_1.Enum)("12h", "24h");
    exports.CoordinateUnits = (0, kinds_1.Enum)("canvas", "screen", "data");
    exports.ContextWhich = (0, kinds_1.Enum)("start", "center", "end", "all");
    exports.Dimension = (0, kinds_1.Enum)("width", "height");
    exports.Dimensions = (0, kinds_1.Enum)("width", "height", "both");
    exports.Direction = (0, kinds_1.Enum)("clock", "anticlock");
    exports.Distribution = (0, kinds_1.Enum)("uniform", "normal");
    exports.Face = (0, kinds_1.Enum)("front", "back");
    exports.FlowMode = (0, kinds_1.Enum)("block", "inline");
    exports.FontStyle = (0, kinds_1.Enum)("normal", "italic", "bold", "bold italic");
    exports.HatchPatternType = (0, kinds_1.Enum)("blank", "dot", "ring", "horizontal_line", "vertical_line", "cross", "horizontal_dash", "vertical_dash", "spiral", "right_diagonal_line", "left_diagonal_line", "diagonal_cross", "right_diagonal_dash", "left_diagonal_dash", "horizontal_wave", "vertical_wave", "criss_cross", " ", ".", "o", "-", "|", "+", '"', ":", "@", "/", "\\", "x", ",", "`", "v", ">", "*");
    exports.BuiltinFormatter = (0, kinds_1.Enum)("raw", "basic", "numeral", "printf", "datetime");
    exports.HTTPMethod = (0, kinds_1.Enum)("POST", "GET");
    exports.HexTileOrientation = (0, kinds_1.Enum)("pointytop", "flattop");
    exports.HoverMode = (0, kinds_1.Enum)("mouse", "hline", "vline");
    exports.ImageOrigin = (0, kinds_1.Enum)("bottom_left", "top_left", "bottom_right", "top_right");
    exports.LatLon = (0, kinds_1.Enum)("lat", "lon");
    exports.LegendClickPolicy = (0, kinds_1.Enum)("none", "hide", "mute");
    exports.LegendLocation = exports.Anchor;
    exports.LineCap = (0, kinds_1.Enum)("butt", "round", "square");
    exports.LineDash = (0, kinds_1.Enum)("solid", "dashed", "dotted", "dotdash", "dashdot");
    exports.LineJoin = (0, kinds_1.Enum)("miter", "round", "bevel");
    exports.LinePolicy = (0, kinds_1.Enum)("prev", "next", "nearest", "interp", "none");
    exports.Location = (0, kinds_1.Enum)("above", "below", "left", "right");
    exports.Logo = (0, kinds_1.Enum)("normal", "grey");
    exports.MapType = (0, kinds_1.Enum)("satellite", "roadmap", "terrain", "hybrid");
    exports.MarkerType = (0, kinds_1.Enum)("asterisk", "circle", "circle_cross", "circle_dot", "circle_x", "circle_y", "cross", "dash", "diamond", "diamond_cross", "diamond_dot", "dot", "hex", "hex_dot", "inverted_triangle", "plus", "square", "square_cross", "square_dot", "square_pin", "square_x", "star", "star_dot", "triangle", "triangle_dot", "triangle_pin", "x", "y");
    exports.MutedPolicy = (0, kinds_1.Enum)("show", "ignore");
    exports.Orientation = (0, kinds_1.Enum)("vertical", "horizontal");
    exports.OutlineShapeName = (0, kinds_1.Enum)("none", "box", "rectangle", "square", "circle", "ellipse", "trapezoid", "parallelogram", "diamond", "triangle");
    exports.OutputBackend = (0, kinds_1.Enum)("canvas", "svg", "webgl");
    exports.PaddingUnits = (0, kinds_1.Enum)("percent", "absolute");
    exports.PanDirection = (0, kinds_1.Enum)("left", "right", "up", "down", "west", "east", "north", "south");
    exports.Place = (0, kinds_1.Enum)("above", "below", "left", "right", "center");
    exports.PointPolicy = (0, kinds_1.Enum)("snap_to_data", "follow_mouse", "none");
    exports.RadiusDimension = (0, kinds_1.Enum)("x", "y", "max", "min");
    exports.RenderLevel = (0, kinds_1.Enum)("image", "underlay", "glyph", "guide", "annotation", "overlay");
    exports.ResetPolicy = (0, kinds_1.Enum)("standard", "event_only");
    exports.ResolutionType = (0, kinds_1.Enum)("microseconds", "milliseconds", "seconds", "minsec", "minutes", "hourmin", "hours", "days", "months", "years");
    exports.RoundingFunction = (0, kinds_1.Enum)("round", "nearest", "floor", "rounddown", "ceil", "roundup");
    exports.ScrollbarPolicy = (0, kinds_1.Enum)("auto", "visible", "hidden");
    exports.RegionSelectionMode = (0, kinds_1.Enum)("replace", "append", "intersect", "subtract", "xor");
    exports.SelectionMode = (0, kinds_1.Enum)(...exports.RegionSelectionMode, "toggle");
    exports.Side = (0, kinds_1.Enum)("above", "below", "left", "right");
    exports.SizingMode = (0, kinds_1.Enum)("stretch_width", "stretch_height", "stretch_both", "scale_width", "scale_height", "scale_both", "fixed", "inherit");
    exports.Sort = (0, kinds_1.Enum)("ascending", "descending");
    exports.SpatialUnits = (0, kinds_1.Enum)("screen", "data");
    exports.StartEnd = (0, kinds_1.Enum)("start", "end");
    exports.StepMode = (0, kinds_1.Enum)("after", "before", "center");
    exports.TapBehavior = (0, kinds_1.Enum)("select", "inspect");
    exports.TapGesture = (0, kinds_1.Enum)("tap", "doubletap");
    exports.TextAlign = (0, kinds_1.Enum)("left", "right", "center");
    exports.TextBaseline = (0, kinds_1.Enum)("top", "middle", "bottom", "alphabetic", "hanging", "ideographic");
    exports.TextureRepetition = (0, kinds_1.Enum)("repeat", "repeat_x", "repeat_y", "no_repeat");
    exports.LabelOrientation = (0, kinds_1.Enum)("vertical", "horizontal", "parallel", "normal");
    exports.TooltipAttachment = (0, kinds_1.Enum)("horizontal", "vertical", "left", "right", "above", "below");
    exports.UpdateMode = (0, kinds_1.Enum)("replace", "append");
    exports.VerticalAlign = (0, kinds_1.Enum)("top", "middle", "bottom");
    exports.WindowAxis = (0, kinds_1.Enum)("none", "x", "y");
    // Keep this in sync with bokehjs/src/less/icons.less
    exports.ToolIcon = (0, kinds_1.Enum)("append_mode", "arrow_down_to_bar", "arrow_up_from_bar", "auto_box_zoom", "bold", "box_edit", "box_select", "box_zoom", "caret_down", "caret_left", "caret_right", "caret_up", "check", "chevron_down", "chevron_left", "chevron_right", "chevron_up", "clear_selection", "copy", "crosshair", "dark_theme", "delete", "freehand_draw", "fullscreen", "help", "hover", "intersect_mode", "invert_selection", "italic", "lasso_select", "light_theme", "line_edit", "maximize", "minimize", "pan", "pin", "point_draw", "pointer", "poly_draw", "poly_edit", "polygon_select", "range", "redo", "replace_mode", "reset", "save", "see_off", "see_on", "settings", "square", "square_check", "subtract_mode", "tap_select", "text_align_center", "text_align_left", "text_align_right", "undo", "unknown", "unpin", "wheel_pan", "wheel_zoom", "x_box_select", "x_box_zoom", "x_grip", "x_pan", "xor_mode", "y_box_select", "y_box_zoom", "y_grip", "y_pan", "zoom_in", "zoom_out");
    exports.ToolName = (0, kinds_1.Enum)("auto_box_zoom", "box_select", "box_zoom", "click", "copy", "crosshair", "doubletap", "examine", "freehand_draw", "fullscreen", "help", "hover", "lasso_select", "pan", "pan_down", "pan_east", "pan_left", "pan_north", "pan_right", "pan_south", "pan_up", "pan_west", "poly_select", "redo", "reset", "save", "tap", "undo", "wheel_zoom", "xbox_select", "xbox_zoom", "xcrosshair", "xpan", "xwheel_pan", "xwheel_zoom", "xzoom_in", "xzoom_out", "ybox_select", "ybox_zoom", "ycrosshair", "ypan", "ywheel_pan", "ywheel_zoom", "yzoom_in", "yzoom_out", "zoom_in", "zoom_out");
},
/* core/kinds.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const tp = tslib_1.__importStar(require(8) /* ./util/types */);
    const color_1 = require(23) /* ./util/color */;
    const object_1 = require(9) /* ./util/object */;
    const refs_1 = require(18) /* ./util/refs */;
    const ESMap = globalThis.Map;
    const ESSet = globalThis.Set;
    const DOMNode = globalThis.Node;
    class Kind {
    }
    exports.Kind = Kind;
    Kind.__name__ = "Kind";
    (function (Kinds) {
        class Primitive extends Kind {
            may_have_refs() {
                return false;
            }
        }
        Primitive.__name__ = "Primitive";
        Kinds.Primitive = Primitive;
        class Any extends Primitive {
            valid(value) {
                return value !== undefined;
            }
            toString() {
                return "Any";
            }
            may_have_refs() {
                return true;
            }
        }
        Any.__name__ = "Any";
        Kinds.Any = Any;
        class Unknown extends Primitive {
            valid(value) {
                return value !== undefined;
            }
            toString() {
                return "Unknown";
            }
            may_have_refs() {
                return true;
            }
        }
        Unknown.__name__ = "Unknown";
        Kinds.Unknown = Unknown;
        class Bool extends Primitive {
            valid(value) {
                return tp.isBoolean(value);
            }
            toString() {
                return "Bool";
            }
        }
        Bool.__name__ = "Bool";
        Kinds.Bool = Bool;
        class Ref extends Kind {
            constructor(obj_type) {
                super();
                this.obj_type = obj_type;
            }
            valid(value) {
                return value instanceof this.obj_type;
            }
            toString() {
                const tp = this.obj_type;
                // NOTE: `__name__` is injected by a compiler transform
                const name = tp.__name__ ?? tp.toString();
                return `Ref(${name})`;
            }
            may_have_refs() {
                const { obj_type } = this;
                return refs_1.has_refs in obj_type ? obj_type[refs_1.has_refs] : true;
            }
        }
        Ref.__name__ = "Ref";
        Kinds.Ref = Ref;
        class AnyRef extends Kind {
            valid(value) {
                return tp.isObject(value);
            }
            toString() {
                return "AnyRef";
            }
            may_have_refs() {
                return true;
            }
        }
        AnyRef.__name__ = "AnyRef";
        Kinds.AnyRef = AnyRef;
        class Float extends Primitive {
            valid(value) {
                return tp.isNumber(value);
            }
            toString() {
                return "Float";
            }
        }
        Float.__name__ = "Float";
        Kinds.Float = Float;
        class Int extends Float {
            valid(value) {
                return super.valid(value) && tp.isInteger(value);
            }
            toString() {
                return "Int";
            }
        }
        Int.__name__ = "Int";
        Kinds.Int = Int;
        class Percent extends Float {
            valid(value) {
                return super.valid(value) && 0 <= value && value <= 1;
            }
            toString() {
                return "Percent";
            }
        }
        Percent.__name__ = "Percent";
        Kinds.Percent = Percent;
        class Or extends Kind {
            constructor(types) {
                super();
                this.types = types;
                this.types = types;
            }
            valid(value) {
                return this.types.some((type) => type.valid(value));
            }
            toString() {
                return `Or(${this.types.map((type) => type.toString()).join(", ")})`;
            }
            may_have_refs() {
                return this.types.some((type) => type.may_have_refs());
            }
        }
        Or.__name__ = "Or";
        Kinds.Or = Or;
        class And extends Kind {
            constructor(type0, type1) {
                super();
                this.types = [type0, type1];
            }
            valid(value) {
                return this.types.some((type) => type.valid(value)); // TODO not sure if this is correct, probably not
            }
            toString() {
                return `And(${this.types.map((type) => type.toString()).join(", ")})`;
            }
            may_have_refs() {
                return this.types.some((type) => type.may_have_refs());
            }
        }
        And.__name__ = "And";
        Kinds.And = And;
        class Tuple extends Kind {
            constructor(types) {
                super();
                this.types = types;
                this.types = types;
            }
            valid(value) {
                if (!tp.isArray(value)) {
                    return false;
                }
                for (let i = 0; i < this.types.length; i++) {
                    const type = this.types[i];
                    const item = value[i];
                    if (!type.valid(item)) {
                        return false;
                    }
                }
                return true;
            }
            toString() {
                return `Tuple(${this.types.map((type) => type.toString()).join(", ")})`;
            }
            may_have_refs() {
                return this.types.some((type) => type.may_have_refs());
            }
        }
        Tuple.__name__ = "Tuple";
        Kinds.Tuple = Tuple;
        class Struct extends Kind {
            constructor(struct_type) {
                super();
                this.struct_type = struct_type;
            }
            valid(value) {
                if (!tp.isPlainObject(value)) {
                    return false;
                }
                const struct_type_proxy = new object_1.PlainObjectProxy(this.struct_type);
                for (const key of (0, object_1.keys)(value)) {
                    if (!struct_type_proxy.has(key)) {
                        return false;
                    }
                }
                for (const [key, item_type] of struct_type_proxy) {
                    const item = value[key];
                    if (!item_type.valid(item)) {
                        return false;
                    }
                }
                return true;
            }
            toString() {
                const items = (0, object_1.typed_entries)(this.struct_type).map(([key, kind]) => `${key.toString()}: ${kind}`).join(", ");
                return `Struct({${items}})`;
            }
            may_have_refs() {
                return (0, object_1.typed_values)(this.struct_type).some((kind) => kind.may_have_refs());
            }
        }
        Struct.__name__ = "Struct";
        Kinds.Struct = Struct;
        class PartialStruct extends Kind {
            constructor(struct_type) {
                super();
                this.struct_type = struct_type;
            }
            valid(value) {
                if (!tp.isPlainObject(value)) {
                    return false;
                }
                const value_proxy = new object_1.PlainObjectProxy(value);
                const struct_type_proxy = new object_1.PlainObjectProxy(this.struct_type);
                for (const key of value_proxy.keys()) {
                    if (!struct_type_proxy.has(key)) {
                        return false;
                    }
                }
                for (const [key, item_type] of struct_type_proxy) {
                    const item = value_proxy.get(key);
                    if (item === undefined) {
                        continue;
                    }
                    if (!item_type.valid(item)) {
                        return false;
                    }
                }
                return true;
            }
            toString() {
                const items = (0, object_1.typed_entries)(this.struct_type).map(([key, kind]) => `${key.toString()}?: ${kind}`).join(", ");
                return `Struct({${items}})`;
            }
            may_have_refs() {
                return (0, object_1.typed_values)(this.struct_type).some((kind) => kind.may_have_refs());
            }
        }
        PartialStruct.__name__ = "PartialStruct";
        Kinds.PartialStruct = PartialStruct;
        class Iterable extends Kind {
            constructor(item_type) {
                super();
                this.item_type = item_type;
            }
            valid(value) {
                return tp.isIterable(value);
            }
            toString() {
                return `Iterable(${this.item_type.toString()})`;
            }
            may_have_refs() {
                return this.item_type.may_have_refs();
            }
        }
        Iterable.__name__ = "Iterable";
        Kinds.Iterable = Iterable;
        class Arrayable extends Kind {
            constructor(item_type) {
                super();
                this.item_type = item_type;
            }
            valid(value) {
                return tp.isArray(value) || tp.isTypedArray(value); // TODO: too specific
            }
            toString() {
                return `Arrayable(${this.item_type.toString()})`;
            }
            may_have_refs() {
                return this.item_type.may_have_refs();
            }
        }
        Arrayable.__name__ = "Arrayable";
        Kinds.Arrayable = Arrayable;
        class List extends Kind {
            constructor(item_type) {
                super();
                this.item_type = item_type;
            }
            valid(value) {
                return tp.isArray(value) && value.every((item) => this.item_type.valid(item));
            }
            toString() {
                return `List(${this.item_type.toString()})`;
            }
            may_have_refs() {
                return this.item_type.may_have_refs();
            }
        }
        List.__name__ = "List";
        Kinds.List = List;
        class NonEmptyList extends List {
            valid(value) {
                return super.valid(value) && value.length != 0;
            }
            toString() {
                return `NonEmptyList(${this.item_type.toString()})`;
            }
        }
        NonEmptyList.__name__ = "NonEmptyList";
        Kinds.NonEmptyList = NonEmptyList;
        class Null extends Primitive {
            valid(value) {
                return value === null;
            }
            toString() {
                return "Null";
            }
        }
        Null.__name__ = "Null";
        Kinds.Null = Null;
        class Nullable extends Kind {
            constructor(base_type) {
                super();
                this.base_type = base_type;
            }
            valid(value) {
                return value === null || this.base_type.valid(value);
            }
            toString() {
                return `Nullable(${this.base_type.toString()})`;
            }
            may_have_refs() {
                return this.base_type.may_have_refs();
            }
        }
        Nullable.__name__ = "Nullable";
        Kinds.Nullable = Nullable;
        class Opt extends Kind {
            constructor(base_type) {
                super();
                this.base_type = base_type;
            }
            valid(value) {
                return value === undefined || this.base_type.valid(value);
            }
            toString() {
                return `Opt(${this.base_type.toString()})`;
            }
            may_have_refs() {
                return this.base_type.may_have_refs();
            }
        }
        Opt.__name__ = "Opt";
        Kinds.Opt = Opt;
        class Bytes extends Kind {
            valid(value) {
                return value instanceof ArrayBuffer;
            }
            toString() {
                return "Bytes";
            }
            may_have_refs() {
                return false;
            }
        }
        Bytes.__name__ = "Bytes";
        Kinds.Bytes = Bytes;
        class Str extends Primitive {
            valid(value) {
                return tp.isString(value);
            }
            toString() {
                return "Str";
            }
        }
        Str.__name__ = "Str";
        Kinds.Str = Str;
        class PrefixedStr extends Primitive {
            constructor(prefix) {
                super();
                this.prefix = prefix;
            }
            valid(value) {
                return tp.isString(value) && value.startsWith(this.prefix);
            }
            toString() {
                return `PrefixedStr('${this.prefix}')`;
            }
        }
        PrefixedStr.__name__ = "PrefixedStr";
        Kinds.PrefixedStr = PrefixedStr;
        class Regex extends Str {
            constructor(regex) {
                super();
                this.regex = regex;
            }
            valid(value) {
                return super.valid(value) && this.regex.test(value);
            }
            toString() {
                return `Regex(${this.regex.toString()})`;
            }
        }
        Regex.__name__ = "Regex";
        Kinds.Regex = Regex;
        class Enum extends Primitive {
            constructor(values) {
                super();
                this.values = new ESSet(values);
            }
            valid(value) {
                return this.values.has(value);
            }
            *[Symbol.iterator]() {
                yield* this.values;
            }
            toString() {
                return `Enum(${[...this.values].map((v) => v.toString()).join(", ")})`;
            }
        }
        Enum.__name__ = "Enum";
        Kinds.Enum = Enum;
        class Dict extends Kind {
            constructor(item_type) {
                super();
                this.item_type = item_type;
            }
            valid(value) {
                if (!(value instanceof ESMap || tp.isPlainObject(value))) {
                    return false;
                }
                for (const item of (0, object_1.values)(value)) {
                    if (!this.item_type.valid(item)) {
                        return false;
                    }
                }
                return true;
            }
            toString() {
                return `Dict(${this.item_type.toString()})`;
            }
            may_have_refs() {
                return this.item_type.may_have_refs();
            }
        }
        Dict.__name__ = "Dict";
        Kinds.Dict = Dict;
        class KeyVal extends Kind {
            constructor(key_type, item_type) {
                super();
                this.key_type = key_type;
                this.item_type = item_type;
            }
            valid(value) {
                if (!(value instanceof ESMap || tp.isPlainObject(value))) {
                    return false;
                }
                for (const [key, item] of (0, object_1.entries)(value)) {
                    if (!this.key_type.valid(key) || !this.item_type.valid(item)) {
                        return false;
                    }
                }
                return true;
            }
            toString() {
                return `KeyVal(${this.key_type.toString()}, ${this.item_type.toString()})`;
            }
            may_have_refs() {
                return this.key_type.may_have_refs() || this.item_type.may_have_refs();
            }
        }
        KeyVal.__name__ = "KeyVal";
        Kinds.KeyVal = KeyVal;
        class Mapping extends Kind {
            constructor(key_type, item_type) {
                super();
                this.key_type = key_type;
                this.item_type = item_type;
            }
            coerce(value) {
                // HACK accommodate for deserialization of {type: "map"}
                if (tp.isPlainObject(value) && (0, object_1.is_empty)(value)) {
                    return new ESMap();
                }
                else {
                    return value;
                }
            }
            valid(value) {
                if (!(value instanceof ESMap)) {
                    return false;
                }
                for (const [key, item] of value.entries()) {
                    if (!(this.key_type.valid(key) && this.item_type.valid(item))) {
                        return false;
                    }
                }
                return true;
            }
            toString() {
                return `Mapping(${this.key_type.toString()}, ${this.item_type.toString()})`;
            }
            may_have_refs() {
                return this.key_type.may_have_refs() || this.item_type.may_have_refs();
            }
        }
        Mapping.__name__ = "Mapping";
        Kinds.Mapping = Mapping;
        class Set extends Kind {
            constructor(item_type) {
                super();
                this.item_type = item_type;
            }
            valid(value) {
                if (!(value instanceof ESSet)) {
                    return false;
                }
                for (const item of value) {
                    if (!this.item_type.valid(item)) {
                        return false;
                    }
                }
                return true;
            }
            toString() {
                return `Set(${this.item_type.toString()})`;
            }
            may_have_refs() {
                return this.item_type.may_have_refs();
            }
        }
        Set.__name__ = "Set";
        Kinds.Set = Set;
        class Color extends Kind {
            valid(value) {
                return (0, color_1.is_Color)(value);
            }
            toString() {
                return "Color";
            }
            may_have_refs() {
                return false;
            }
        }
        Color.__name__ = "Color";
        Kinds.Color = Color;
        class CSSLength extends Str {
            /*
            override valid(value: unknown): value is string {
              return super.valid(value) // TODO: && this._parse(value)
            }
            */
            toString() {
                return "CSSLength";
            }
        }
        CSSLength.__name__ = "CSSLength";
        Kinds.CSSLength = CSSLength;
        class Func extends Kind {
            constructor(args_types, ret_type) {
                super();
                this.args_types = args_types;
                this.ret_type = ret_type;
            }
            valid(value) {
                return tp.isFunction(value);
            }
            toString() {
                const { args_types, ret_type } = this;
                const args = args_types == null ? "?" : args_types.map((type) => type.toString()).join(", ");
                const ret = ret_type == null ? "?" : ret_type.toString();
                return `Func((${args}), ${ret})`;
            }
            may_have_refs() {
                return false;
            }
        }
        Func.__name__ = "Func";
        Kinds.Func = Func;
        class NonNegative extends Kind {
            constructor(base_type) {
                super();
                this.base_type = base_type;
            }
            valid(value) {
                return this.base_type.valid(value) && value >= 0;
            }
            toString() {
                return `NonNegative(${this.base_type.toString()})`;
            }
            may_have_refs() {
                return this.base_type.may_have_refs();
            }
        }
        NonNegative.__name__ = "NonNegative";
        Kinds.NonNegative = NonNegative;
        class Positive extends Kind {
            constructor(base_type) {
                super();
                this.base_type = base_type;
            }
            valid(value) {
                return this.base_type.valid(value) && value > 0;
            }
            toString() {
                return `Positive(${this.base_type.toString()})`;
            }
            may_have_refs() {
                return this.base_type.may_have_refs();
            }
        }
        Positive.__name__ = "Positive";
        Kinds.Positive = Positive;
        class Node extends Kind {
            valid(value) {
                return value instanceof DOMNode;
            }
            toString() {
                return "Node";
            }
            may_have_refs() {
                return false;
            }
        }
        Node.__name__ = "Node";
        Kinds.Node = Node;
    })(exports.Kinds || (exports.Kinds = {}));
    exports.Any = new exports.Kinds.Any();
    exports.Unknown = new exports.Kinds.Unknown();
    exports.Bool = new exports.Kinds.Bool();
    exports.Float = new exports.Kinds.Float();
    exports.Int = new exports.Kinds.Int();
    exports.Bytes = new exports.Kinds.Bytes();
    exports.Str = new exports.Kinds.Str();
    const PrefixedStr = (prefix) => new exports.Kinds.PrefixedStr(prefix);
    exports.PrefixedStr = PrefixedStr;
    const Regex = (regex) => new exports.Kinds.Regex(regex);
    exports.Regex = Regex;
    exports.Null = new exports.Kinds.Null();
    const Nullable = (base_type) => new exports.Kinds.Nullable(base_type);
    exports.Nullable = Nullable;
    const Opt = (base_type) => new exports.Kinds.Opt(base_type);
    exports.Opt = Opt;
    const Or = (...types) => new exports.Kinds.Or(types);
    exports.Or = Or;
    const And = (type0, type1) => new exports.Kinds.And(type0, type1);
    exports.And = And;
    const Tuple = (...types) => new exports.Kinds.Tuple(types);
    exports.Tuple = Tuple;
    const Struct = (struct_type) => new exports.Kinds.Struct(struct_type);
    exports.Struct = Struct;
    const PartialStruct = (struct_type) => new exports.Kinds.PartialStruct(struct_type);
    exports.PartialStruct = PartialStruct;
    const Iterable = (item_type) => new exports.Kinds.Iterable(item_type);
    exports.Iterable = Iterable;
    const Arrayable = (item_type) => new exports.Kinds.Arrayable(item_type);
    exports.Arrayable = Arrayable;
    const List = (item_type) => new exports.Kinds.List(item_type);
    exports.List = List;
    const NonEmptyList = (item_type) => new exports.Kinds.NonEmptyList(item_type);
    exports.NonEmptyList = NonEmptyList;
    const Dict = (item_type) => new exports.Kinds.Dict(item_type);
    exports.Dict = Dict;
    const KeyVal = (key_type, item_type) => new exports.Kinds.KeyVal(key_type, item_type);
    exports.KeyVal = KeyVal;
    const Mapping = (key_type, item_type) => new exports.Kinds.Mapping(key_type, item_type);
    exports.Mapping = Mapping;
    const Set = (item_type) => new exports.Kinds.Set(item_type);
    exports.Set = Set;
    const Enum = (...values) => new exports.Kinds.Enum(values);
    exports.Enum = Enum;
    const Ref = (obj_type) => new exports.Kinds.Ref(obj_type);
    exports.Ref = Ref;
    const AnyRef = () => new exports.Kinds.AnyRef();
    exports.AnyRef = AnyRef;
    const Func = (args_types, ret_type) => new exports.Kinds.Func(args_types, ret_type);
    exports.Func = Func;
    const Func0 = (ret_type) => new exports.Kinds.Func([], ret_type);
    exports.Func0 = Func0;
    exports.Node = new exports.Kinds.Node();
    const NonNegative = (base_type) => new exports.Kinds.NonNegative(base_type);
    exports.NonNegative = NonNegative;
    const Positive = (base_type) => new exports.Kinds.Positive(base_type);
    exports.Positive = Positive;
    exports.Percent = new exports.Kinds.Percent();
    exports.Alpha = exports.Percent;
    exports.Color = new exports.Kinds.Color();
    exports.Auto = (0, exports.Enum)("auto");
    exports.CSSLength = new exports.Kinds.CSSLength();
    exports.FontSize = exports.Str;
    exports.Font = exports.Str;
    exports.Angle = exports.Float;
    // backwards compatibility aliases (these collide with built-in types)
    /** @deprecated */
    exports.Boolean = exports.Bool;
    /** @deprecated */
    exports.String = exports.Str;
    /** @deprecated */
    exports.Number = exports.Float;
    /** @deprecated */
    exports.Array = exports.List;
    /** @deprecated */
    exports.Map = exports.Mapping;
    /** @deprecated */
    exports.Function = exports.Func;
},
/* core/util/color.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.byte = byte;
    exports.transparent = transparent;
    exports.encode_rgba = encode_rgba;
    exports.decode_rgba = decode_rgba;
    exports.color2rgba = color2rgba;
    exports.rgba2css = rgba2css;
    exports.color2css = color2css;
    exports.color2hex = color2hex;
    exports.color2hexrgb = color2hexrgb;
    exports.css4_parse = css4_parse;
    exports.is_Color = is_Color;
    exports.is_dark = is_dark;
    exports.brightness = brightness;
    exports.luminance = luminance;
    const svg_colors_1 = require(24) /* ./svg_colors */;
    const math_1 = require(11) /* ./math */;
    const types_1 = require(8) /* ./types */;
    const { round, sqrt } = Math;
    function byte(v) {
        return (0, math_1.clamp)(round(v), 0, 255);
    }
    function transparent() {
        return [0, 0, 0, 0];
    }
    function encode_rgba([r, g, b, a]) {
        return r << 24 | g << 16 | b << 8 | a;
    }
    function decode_rgba(rgba) {
        const r = (rgba >> 24) & 0xff;
        const g = (rgba >> 16) & 0xff;
        const b = (rgba >> 8) & 0xff;
        const a = rgba & 0xff;
        return [r, g, b, a];
    }
    function color2rgba(color, alpha = 1.0) {
        const [r, g, b, a] = (() => {
            if (color == null) {
                return transparent();
            }
            else if ((0, types_1.isInteger)(color)) {
                return decode_rgba(color);
            }
            else if ((0, types_1.isString)(color)) {
                const [r, g, b, a] = css4_parse(color) ?? transparent();
                return [r, g, b, byte(a * 255)];
            }
            else {
                if (color.length == 2) {
                    const [name, alpha] = color;
                    return color2rgba(name, alpha);
                }
                else {
                    const [r, g, b, a = 1.0] = color;
                    return [r, g, b, byte(a * 255)];
                }
            }
        })();
        return [r, g, b, byte(alpha * a)];
    }
    const _hex_table = {
        0: "0", 1: "1", 2: "2", 3: "3", 4: "4", 5: "5", 6: "6", 7: "7", 8: "8", 9: "9",
        10: "a", 11: "b", 12: "c", 13: "d", 14: "e", 15: "f",
    };
    function hex(v) {
        return _hex_table[v >> 4] + _hex_table[v & 0xf];
    }
    function rgba2css([r, g, b, a]) {
        const alpha = a == 255 ? "" : ` / ${a / 255}`;
        return `rgb(${r} ${g} ${b}${alpha})`;
    }
    function color2css(color, alpha) {
        if ((0, types_1.isString)(color) && (alpha == null || alpha == 1.0)) {
            return color; // passthrough to persist color in its original form
        }
        else {
            const [r, g, b, a] = color2rgba(color, alpha);
            return rgba2css([r, g, b, a]);
        }
    }
    function color2hex(color, alpha) {
        const [r, g, b, a] = color2rgba(color, alpha);
        const rgb = `#${hex(r)}${hex(g)}${hex(b)}`;
        return a == 255 ? rgb : `${rgb}${hex(a)}`;
    }
    function color2hexrgb(color) {
        const [r, g, b] = color2rgba(color);
        return `#${hex(r)}${hex(g)}${hex(b)}`;
    }
    /*
    let _last_color = "transparent"
    let _last_alpha = 1.0
    let _last_rgba = transparent()
    
    export function _color2rgba(color: string | null, alpha: number = 1.0): RGBA {
      if (color == _last_color && alpha == _last_alpha)
        return [..._last_rgba]
    
      const [r, g, b, a] = parsed
      const rgba: RGBA = [r, g, b, a == 255 ? byte(alpha*255) : a]
      _last_color = color
      _last_alpha = alpha
      _last_rgba = rgba
      return rgba
    }
    */
    const rgb_modern = /^rgba?\(\s*(?<r>[^\s,]+?)\s+(?<g>[^\s,]+?)\s+(?<b>[^\s,]+?)(?:\s*\/\s*(?<a>[^\s,]+?))?\s*\)$/;
    const rgb_legacy = /^rgba?\(\s*(?<r>[^\s,]+?)\s*,\s*(?<g>[^\s,]+?)\s*,\s*(?<b>[^\s,]+?)(?:\s*,\s*(?<a>[^\s,]+?))?\s*\)$/;
    const css4_normalize = (() => {
        const canvas = document.createElement("canvas");
        canvas.width = 1;
        canvas.height = 1;
        const ctx = canvas.getContext("2d");
        const gradient = ctx.createLinearGradient(0, 0, 1, 1);
        return (color) => {
            ctx.fillStyle = gradient; // lgtm [js/useless-assignment-to-property]
            ctx.fillStyle = color;
            const style = ctx.fillStyle;
            return style != gradient ? style : null;
        };
    })();
    function css4_parse(color) {
        /**
          Parses CSS4 color strings:
      
          - transparent
          - named color
          - #RRGGBB[AA]
          - #RGB[A]
          - rgb[a](R G B[ / A])
          - rgb[a](R, G, B[, A])
          - other CSS4 syntax (browser dependent)
      
        */
        color = color.trim().toLowerCase();
        if (color == "") {
            return null;
        }
        else if (color == "transparent") {
            return transparent();
        }
        else if ((0, svg_colors_1.is_named_color)(color)) {
            const [r, g, b, a] = decode_rgba(svg_colors_1.named_colors[color]);
            return [r, g, b, a / 255];
        }
        else if (color[0] == "#") {
            const v = Number(`0x${color.substring(1)}`);
            if (isNaN(v)) {
                return null;
            }
            switch (color.length - 1) {
                case 3: {
                    const r = (v >> 8) & 0xf;
                    const g = (v >> 4) & 0xf;
                    const b = (v >> 0) & 0xf;
                    const rr = (r << 4) | r;
                    const gg = (g << 4) | g;
                    const bb = (b << 4) | b;
                    return [rr, gg, bb, 1.0];
                }
                case 4: {
                    const r = (v >> 12) & 0xf;
                    const g = (v >> 8) & 0xf;
                    const b = (v >> 4) & 0xf;
                    const a = (v >> 0) & 0xf;
                    const rr = (r << 4) | r;
                    const gg = (g << 4) | g;
                    const bb = (b << 4) | b;
                    const aa = (a << 4) | a;
                    return [rr, gg, bb, aa / 255];
                }
                case 6: {
                    const rr = (v >> 16) & 0xff;
                    const gg = (v >> 8) & 0xff;
                    const bb = (v >> 0) & 0xff;
                    return [rr, gg, bb, 1.0];
                }
                case 8: {
                    const rr = (v >> 24) & 0xff;
                    const gg = (v >> 16) & 0xff;
                    const bb = (v >> 8) & 0xff;
                    const aa = (v >> 0) & 0xff;
                    return [rr, gg, bb, aa / 255];
                }
            }
        }
        else if (color.startsWith("rgb")) {
            const result = color.match(rgb_modern) ?? color.match(rgb_legacy);
            if (result?.groups != null) {
                let { r, g, b, a = "1" } = result.groups;
                const rp = r.endsWith("%");
                const gp = g.endsWith("%");
                const bp = b.endsWith("%");
                const ap = a.endsWith("%");
                if (!(rp && gp && bp || (!rp && !gp && !bp))) {
                    return null;
                }
                if (rp) {
                    r = r.slice(0, -1);
                }
                if (gp) {
                    g = g.slice(0, -1);
                }
                if (bp) {
                    b = b.slice(0, -1);
                }
                if (ap) {
                    a = a.slice(0, -1);
                }
                let R = Number(r);
                let G = Number(g);
                let B = Number(b);
                let A = Number(a);
                if (isNaN(R + G + B + A)) {
                    return null;
                }
                if (rp) {
                    R = 255 * (R / 100);
                }
                if (gp) {
                    G = 255 * (G / 100);
                }
                if (bp) {
                    B = 255 * (B / 100);
                }
                A = ap ? A / 100 : A;
                R = byte(R);
                G = byte(G);
                B = byte(B);
                return [R, G, B, A];
            }
        }
        else {
            const style = css4_normalize(color);
            if (style != null) {
                return css4_parse(style);
            }
        }
        return null;
    }
    function is_Color(value) {
        if ((0, types_1.isInteger)(value)) {
            return true;
        }
        if ((0, types_1.isString)(value) && css4_parse(value) != null) {
            return true;
        }
        if ((0, types_1.isArray)(value) && (value.length == 3 || value.length == 4)) {
            return true;
        }
        return false;
    }
    function is_dark([r, g, b]) {
        const l = 1 - (0.299 * r + 0.587 * g + 0.114 * b) / 255;
        return l >= 0.6;
    }
    function brightness(color) {
        // Perceived brightness of a color in [0, 1] range.
        // http://alienryderflex.com/hsp.html
        const [r, g, b] = color2rgba(color);
        return sqrt(0.299 * r ** 2 + 0.587 * g ** 2 + 0.114 * b ** 2) / 255;
    }
    function luminance(color) {
        // Relative luminance of a color in [0, 1] range.
        // https://en.wikipedia.org/wiki/Relative_luminance
        const [r, g, b] = color2rgba(color);
        return (0.2126 * r ** 2.2 + 0.7152 * g ** 2.2 + 0.0722 * b ** 2.2) / 255 ** 2.2;
    }
},
/* core/util/svg_colors.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.is_named_color = is_named_color;
    const _named_colors = {
        aliceblue: 0xf0f8ffff,
        antiquewhite: 0xfaebd7ff,
        aqua: 0x00ffffff,
        aquamarine: 0x7fffd4ff,
        azure: 0xf0ffffff,
        beige: 0xf5f5dcff,
        bisque: 0xffe4c4ff,
        black: 0x000000ff,
        blanchedalmond: 0xffebcdff,
        blue: 0x0000ffff,
        blueviolet: 0x8a2be2ff,
        brown: 0xa52a2aff,
        burlywood: 0xdeb887ff,
        cadetblue: 0x5f9ea0ff,
        chartreuse: 0x7fff00ff,
        chocolate: 0xd2691eff,
        coral: 0xff7f50ff,
        cornflowerblue: 0x6495edff,
        cornsilk: 0xfff8dcff,
        crimson: 0xdc143cff,
        cyan: 0x00ffffff,
        darkblue: 0x00008bff,
        darkcyan: 0x008b8bff,
        darkgoldenrod: 0xb8860bff,
        darkgray: 0xa9a9a9ff,
        darkgreen: 0x006400ff,
        darkgrey: 0xa9a9a9ff,
        darkkhaki: 0xbdb76bff,
        darkmagenta: 0x8b008bff,
        darkolivegreen: 0x556b2fff,
        darkorange: 0xff8c00ff,
        darkorchid: 0x9932ccff,
        darkred: 0x8b0000ff,
        darksalmon: 0xe9967aff,
        darkseagreen: 0x8fbc8fff,
        darkslateblue: 0x483d8bff,
        darkslategray: 0x2f4f4fff,
        darkslategrey: 0x2f4f4fff,
        darkturquoise: 0x00ced1ff,
        darkviolet: 0x9400d3ff,
        deeppink: 0xff1493ff,
        deepskyblue: 0x00bfffff,
        dimgray: 0x696969ff,
        dimgrey: 0x696969ff,
        dodgerblue: 0x1e90ffff,
        firebrick: 0xb22222ff,
        floralwhite: 0xfffaf0ff,
        forestgreen: 0x228b22ff,
        fuchsia: 0xff00ffff,
        gainsboro: 0xdcdcdcff,
        ghostwhite: 0xf8f8ffff,
        gold: 0xffd700ff,
        goldenrod: 0xdaa520ff,
        gray: 0x808080ff,
        green: 0x008000ff,
        greenyellow: 0xadff2fff,
        grey: 0x808080ff,
        honeydew: 0xf0fff0ff,
        hotpink: 0xff69b4ff,
        indianred: 0xcd5c5cff,
        indigo: 0x4b0082ff,
        ivory: 0xfffff0ff,
        khaki: 0xf0e68cff,
        lavender: 0xe6e6faff,
        lavenderblush: 0xfff0f5ff,
        lawngreen: 0x7cfc00ff,
        lemonchiffon: 0xfffacdff,
        lightblue: 0xadd8e6ff,
        lightcoral: 0xf08080ff,
        lightcyan: 0xe0ffffff,
        lightgoldenrodyellow: 0xfafad2ff,
        lightgray: 0xd3d3d3ff,
        lightgreen: 0x90ee90ff,
        lightgrey: 0xd3d3d3ff,
        lightpink: 0xffb6c1ff,
        lightsalmon: 0xffa07aff,
        lightseagreen: 0x20b2aaff,
        lightskyblue: 0x87cefaff,
        lightslategray: 0x778899ff,
        lightslategrey: 0x778899ff,
        lightsteelblue: 0xb0c4deff,
        lightyellow: 0xffffe0ff,
        lime: 0x00ff00ff,
        limegreen: 0x32cd32ff,
        linen: 0xfaf0e6ff,
        magenta: 0xff00ffff,
        maroon: 0x800000ff,
        mediumaquamarine: 0x66cdaaff,
        mediumblue: 0x0000cdff,
        mediumorchid: 0xba55d3ff,
        mediumpurple: 0x9370dbff,
        mediumseagreen: 0x3cb371ff,
        mediumslateblue: 0x7b68eeff,
        mediumspringgreen: 0x00fa9aff,
        mediumturquoise: 0x48d1ccff,
        mediumvioletred: 0xc71585ff,
        midnightblue: 0x191970ff,
        mintcream: 0xf5fffaff,
        mistyrose: 0xffe4e1ff,
        moccasin: 0xffe4b5ff,
        navajowhite: 0xffdeadff,
        navy: 0x000080ff,
        oldlace: 0xfdf5e6ff,
        olive: 0x808000ff,
        olivedrab: 0x6b8e23ff,
        orange: 0xffa500ff,
        orangered: 0xff4500ff,
        orchid: 0xda70d6ff,
        palegoldenrod: 0xeee8aaff,
        palegreen: 0x98fb98ff,
        paleturquoise: 0xafeeeeff,
        palevioletred: 0xdb7093ff,
        papayawhip: 0xffefd5ff,
        peachpuff: 0xffdab9ff,
        peru: 0xcd853fff,
        pink: 0xffc0cbff,
        plum: 0xdda0ddff,
        powderblue: 0xb0e0e6ff,
        purple: 0x800080ff,
        rebeccapurple: 0x663399ff,
        red: 0xff0000ff,
        rosybrown: 0xbc8f8fff,
        royalblue: 0x4169e1ff,
        saddlebrown: 0x8b4513ff,
        salmon: 0xfa8072ff,
        sandybrown: 0xf4a460ff,
        seagreen: 0x2e8b57ff,
        seashell: 0xfff5eeff,
        sienna: 0xa0522dff,
        silver: 0xc0c0c0ff,
        skyblue: 0x87ceebff,
        slateblue: 0x6a5acdff,
        slategray: 0x708090ff,
        slategrey: 0x708090ff,
        snow: 0xfffafaff,
        springgreen: 0x00ff7fff,
        steelblue: 0x4682b4ff,
        tan: 0xd2b48cff,
        teal: 0x008080ff,
        thistle: 0xd8bfd8ff,
        tomato: 0xff6347ff,
        turquoise: 0x40e0d0ff,
        violet: 0xee82eeff,
        wheat: 0xf5deb3ff,
        white: 0xffffffff,
        whitesmoke: 0xf5f5f5ff,
        yellow: 0xffff00ff,
        yellowgreen: 0x9acd32ff,
    };
    exports.named_colors = _named_colors;
    function is_named_color(color) {
        return color in exports.named_colors;
    }
},
/* core/types.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.infer_type = infer_type;
    exports.to_screen = to_screen;
    exports.GeneratorFunction = Object.getPrototypeOf(function* () { }).constructor;
    exports.AsyncGeneratorFunction = Object.getPrototypeOf(async function* () { }).constructor;
    exports.ColorArray = Uint32Array;
    exports.RGBAArray = Uint8ClampedArray;
    function infer_type(a0, a1) {
        if (a0 instanceof Float64Array || a0 instanceof Array) {
            return Float64Array;
        }
        if (a1 instanceof Float64Array || a1 instanceof Array) {
            return Float64Array;
        }
        return Float32Array;
    }
    exports.ScreenArray = Float32Array;
    function to_screen(array) {
        if (!(array instanceof Float32Array)) {
            return Float32Array.from(array);
        }
        else {
            return array;
        }
    }
    var bitset_1 = require(26) /* ./util/bitset */;
    __esExport("Indices", bitset_1.BitSet);
},
/* core/util/bitset.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a, _b;
    __esModule();
    const eq_1 = require(27) /* ./eq */;
    const assert_1 = require(12) /* ./assert */;
    const refs_1 = require(18) /* ./refs */;
    class BitSet {
        constructor(size, init = 0) {
            this[_a] = "BitSet";
            this._count = null;
            this.size = size;
            this._nwords = Math.ceil(size / BitSet._word_length);
            if (init == 0 || init == 1) {
                this._array = new Uint32Array(this._nwords);
                if (init == 1) {
                    this._array.fill(0xffffffff);
                }
            }
            else {
                (0, assert_1.assert)(init.length == this._nwords, "Initializer size mismatch");
                this._array = init;
            }
        }
        clone() {
            return new BitSet(this.size, new Uint32Array(this._array));
        }
        [(_a = Symbol.toStringTag, _b = refs_1.has_refs, eq_1.equals)](that, cmp) {
            if (!cmp.eq(this.size, that.size)) {
                return false;
            }
            const { _nwords } = this;
            const trailing = this.size % BitSet._word_length;
            const n = trailing == 0 ? _nwords : _nwords - 1;
            for (let i = 0; i < n; i++) {
                if (this._array[i] != that._array[i]) {
                    return false;
                }
            }
            if (trailing == 0) {
                return true;
            }
            else {
                const msb = 1 << (trailing - 1);
                const mask = (msb - 1) ^ msb;
                return (this._array[n] & mask) == (that._array[n] & mask);
            }
        }
        static all_set(size) {
            return new BitSet(size, 1);
        }
        static all_unset(size) {
            return new BitSet(size, 0);
        }
        static from_indices(size, indices) {
            const bits = new BitSet(size);
            for (const i of indices) {
                bits.set(i);
            }
            return bits;
        }
        static from_booleans(size, booleans) {
            const bits = new BitSet(size);
            let i = 0;
            for (const boolean of booleans) {
                if (i == size) {
                    break;
                }
                if (boolean) {
                    bits.set(i);
                }
                i += 1;
            }
            return bits;
        }
        _check_bounds(k) {
            (0, assert_1.assert)(0 <= k && k < this.size, `Out of bounds: 0 <= ${k} < ${this.size}`);
        }
        get(k) {
            this._check_bounds(k);
            const i = k >>> 5; // Math.floor(k/32)
            const j = k & 0x1f; // k % 32
            return ((this._array[i] >> j) & 0b1) == 0b1;
        }
        set(k, v = true) {
            this._check_bounds(k);
            this._count = null;
            const i = k >>> 5; // Math.floor(k/32)
            const j = k & 0x1f; // k % 32
            if (v) {
                this._array[i] |= 0b1 << j;
            }
            else {
                this._array[i] &= ~(0b1 << j);
            }
        }
        unset(k) {
            this.set(k, false);
        }
        *[Symbol.iterator]() {
            yield* this.ones();
        }
        get count() {
            let count = this._count;
            if (count == null) {
                this._count = count = this._get_count();
            }
            return count;
        }
        _get_count() {
            const { _array, _nwords, size } = this;
            let c = 0;
            for (let k = 0, i = 0; i < _nwords; i++) {
                const word = _array[i];
                if (word == 0) {
                    k += BitSet._word_length;
                }
                else {
                    for (let j = 0; j < BitSet._word_length && k < size; j++, k++) {
                        if (((word >>> j) & 0b1) == 0b1) {
                            c += 1;
                        }
                    }
                }
            }
            return c;
        }
        *ones() {
            const { _array, _nwords, size } = this;
            for (let k = 0, i = 0; i < _nwords; i++) {
                const word = _array[i];
                if (word == 0) {
                    k += BitSet._word_length;
                    continue;
                }
                for (let j = 0; j < BitSet._word_length && k < size; j++, k++) {
                    if (((word >>> j) & 0b1) == 0b1) {
                        yield k;
                    }
                }
            }
        }
        *zeros() {
            const { _array, _nwords, size } = this;
            for (let k = 0, i = 0; i < _nwords; i++) {
                const word = _array[i];
                if (word == 0xffffffff) {
                    k += BitSet._word_length;
                    continue;
                }
                for (let j = 0; j < BitSet._word_length && k < size; j++, k++) {
                    if (((word >>> j) & 0b1) == 0b0) {
                        yield k;
                    }
                }
            }
        }
        _check_size(other) {
            (0, assert_1.assert)(this.size == other.size, `Size mismatch (${this.size} != ${other.size})`);
        }
        invert() {
            for (let i = 0; i < this._nwords; i++) {
                this._array[i] = ~this._array[i] >>> 0;
            }
        }
        add(other) {
            this._check_size(other);
            for (let i = 0; i < this._nwords; i++) {
                this._array[i] |= other._array[i];
            }
        }
        intersect(other) {
            this._check_size(other);
            for (let i = 0; i < this._nwords; i++) {
                this._array[i] &= other._array[i];
            }
        }
        subtract(other) {
            this._check_size(other);
            for (let i = 0; i < this._nwords; i++) {
                const a = this._array[i];
                const b = other._array[i];
                this._array[i] = (a ^ b) & a;
            }
        }
        symmetric_subtract(other) {
            this._check_size(other);
            for (let i = 0; i < this._nwords; i++) {
                this._array[i] ^= other._array[i];
            }
        }
        inversion() {
            const result = this.clone();
            result.invert();
            return result;
        }
        union(other) {
            const result = this.clone();
            result.add(other);
            return result;
        }
        intersection(other) {
            const result = this.clone();
            result.intersect(other);
            return result;
        }
        difference(other) {
            const result = this.clone();
            result.subtract(other);
            return result;
        }
        symmetric_difference(other) {
            const result = this.clone();
            result.symmetric_subtract(other);
            return result;
        }
        select(array) {
            (0, assert_1.assert)(this.size <= array.length, "Size mismatch");
            const n = this.count;
            const result = new array.constructor(n);
            let i = 0;
            for (const j of this) {
                result[i++] = array[j];
            }
            return result;
        }
    }
    exports.BitSet = BitSet;
    BitSet.__name__ = "BitSet";
    BitSet[_b] = false;
    BitSet._word_length = 32;
},
/* core/util/eq.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.is_equal = is_equal;
    exports.is_structurally_equal = is_structurally_equal;
    exports.is_similar = is_similar;
    // Based on Underscore.js 1.8.3 (http://underscorejs.org)
    const types_1 = require(8) /* ./types */;
    const { hasOwnProperty } = Object.prototype;
    exports.equals = Symbol("equals");
    function is_Equatable(obj) {
        return (0, types_1.isObject)(obj) && exports.equals in obj;
    }
    exports.wildcard = Symbol("wildcard");
    const toString = Object.prototype.toString;
    class EqNotImplemented extends Error {
    }
    exports.EqNotImplemented = EqNotImplemented;
    EqNotImplemented.__name__ = "EqNotImplemented";
    class Comparator {
        constructor(options) {
            this.a_stack = [];
            this.b_stack = [];
            this.structural = options?.structural ?? false;
        }
        eq(a, b) {
            if (a === b || Object.is(a, b)) {
                return true;
            }
            if (a === exports.wildcard || b === exports.wildcard) {
                return true;
            }
            if (a == null || b == null) {
                return a === b;
            }
            const class_name = toString.call(a);
            if (class_name != toString.call(b)) {
                return false;
            }
            switch (class_name) {
                case "[object Number]":
                    return this.numbers(a, b);
                case "[object Symbol]":
                    return a === b;
                case "[object RegExp]":
                case "[object String]":
                    return `${a}` == `${b}`;
                case "[object Date]":
                case "[object Boolean]":
                    return +a === +b;
            }
            // Assume equality for cyclic structures. The algorithm for detecting cyclic
            // structures is adapted from ES 5.1 section 15.12.3, abstract operation `JO`.
            // Initializing stack of traversed objects.
            // It's done here since we only need them for objects and arrays comparison.
            const { a_stack, b_stack } = this;
            let length = a_stack.length;
            while (length-- > 0) {
                // Linear search. Performance is inversely proportional to the number of
                // unique nested structures.
                if (a_stack[length] === a) {
                    return b_stack[length] === b;
                }
            }
            a_stack.push(a);
            b_stack.push(b);
            const result = (() => {
                if (is_Equatable(a) && is_Equatable(b)) {
                    return a[exports.equals](b, this);
                }
                switch (class_name) {
                    case "[object Array]":
                    case "[object Uint8Array]":
                    case "[object Int8Array]":
                    case "[object Uint16Array]":
                    case "[object Int16Array]":
                    case "[object Uint32Array]":
                    case "[object Int32Array]":
                    case "[object Float32Array]":
                    case "[object Float64Array]": {
                        return this.arrays(a, b);
                    }
                    case "[object ArrayBuffer]":
                    case "[object SharedArrayBuffer]": {
                        return this.array_buffers(a, b);
                    }
                    case "[object Map]": {
                        return this.maps(a, b);
                    }
                    case "[object Set]": {
                        return this.sets(a, b);
                    }
                    case "[object Object]": {
                        if (a.constructor == b.constructor && (a.constructor == null || a.constructor === Object)) {
                            return this.objects(a, b);
                        }
                    }
                    case "[object Function]": {
                        if (a.constructor == b.constructor && a.constructor === Function) {
                            return this.eq(`${a}`, `${b}`);
                        }
                    }
                }
                if (typeof Node !== "undefined" && a instanceof Node) {
                    return this.nodes(a, b);
                }
                throw new EqNotImplemented(`can't compare objects of type ${class_name}`);
            })();
            a_stack.pop();
            b_stack.pop();
            return result;
        }
        numbers(a, b) {
            return a === b || Object.is(a, b);
        }
        arrays(a, b) {
            const { length } = a;
            if (length != b.length) {
                return false;
            }
            for (let i = 0; i < length; i++) {
                if (!this.eq(a[i], b[i])) {
                    return false;
                }
            }
            return true;
        }
        array_buffers(a, b) {
            // compare array buffers byte-wise; this doesn't allocate any memory
            return this.arrays(new Uint8Array(a), new Uint8Array(b));
        }
        iterables(a, b) {
            const ai = a[Symbol.iterator]();
            const bi = b[Symbol.iterator]();
            while (true) {
                const an = ai.next();
                const bn = bi.next();
                const an_done = an.done ?? false;
                const bn_done = bn.done ?? false;
                if (an_done && bn_done) {
                    return true;
                }
                if (an_done || bn_done) {
                    return false;
                }
                if (!this.eq(an.value, bn.value)) {
                    return false;
                }
            }
        }
        maps(a, b) {
            if (a.size != b.size) {
                return false;
            }
            if (this.structural) {
                return this.iterables(a.entries(), b.entries());
            }
            else {
                for (const [key, val] of a) {
                    if (!b.has(key) || !this.eq(val, b.get(key))) {
                        return false;
                    }
                }
                return true;
            }
        }
        sets(a, b) {
            if (a.size != b.size) {
                return false;
            }
            if (this.structural) {
                return this.iterables(a.entries(), b.entries());
            }
            else {
                for (const key of a) {
                    if (!b.has(key)) {
                        return false;
                    }
                }
                return true;
            }
        }
        objects(a, b) {
            const keys = Object.keys(a);
            if (keys.length != Object.keys(b).length) {
                return false;
            }
            for (const key of keys) {
                if (!hasOwnProperty.call(b, key) || !this.eq(a[key], b[key])) {
                    return false;
                }
            }
            return true;
        }
        nodes(a, b) {
            if (a.nodeType != b.nodeType) {
                return false;
            }
            if (a.textContent != b.textContent) {
                return false;
            }
            if (!this.iterables(a.childNodes, b.childNodes)) {
                return false;
            }
            return true;
        }
    }
    exports.Comparator = Comparator;
    Comparator.__name__ = "Comparator";
    const { abs } = Math;
    class SimilarComparator extends Comparator {
        constructor(tolerance = 1e-4) {
            super();
            this.tolerance = tolerance;
        }
        numbers(a, b) {
            return super.numbers(a, b) || abs(a - b) < this.tolerance;
        }
    }
    exports.SimilarComparator = SimilarComparator;
    SimilarComparator.__name__ = "SimilarComparator";
    function is_equal(a, b) {
        const comparator = new Comparator();
        return comparator.eq(a, b);
    }
    function is_structurally_equal(a, b) {
        const comparator = new Comparator({ structural: true });
        return comparator.eq(a, b);
    }
    function is_similar(a, b, tolerance) {
        const comparator = new SimilarComparator(tolerance);
        return comparator.eq(a, b);
    }
},
/* core/util/platform.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.to_big_endian = to_big_endian;
    exports.is_mobile = (() => {
        return "ontouchstart" in globalThis || (typeof navigator !== "undefined" && navigator.maxTouchPoints > 0);
    })();
    exports.is_little_endian = (() => {
        const buf = new ArrayBuffer(4);
        const buf8 = new Uint8Array(buf);
        const buf32 = new Uint32Array(buf);
        buf32[1] = 0x0a0b0c0d;
        let little_endian = true;
        if (buf8[4] == 0x0a && buf8[5] == 0x0b && buf8[6] == 0x0c && buf8[7] == 0x0d) {
            little_endian = false;
        }
        return little_endian;
    })();
    exports.BYTE_ORDER = exports.is_little_endian ? "little" : "big";
    function to_big_endian(values) {
        if (exports.is_little_endian) {
            const result = new Uint32Array(values.length);
            const view = new DataView(result.buffer);
            let j = 0;
            for (const color of values) {
                view.setUint32(j, color);
                j += 4;
            }
            return result;
        }
        else {
            return values;
        }
    }
},
/* core/vectorization.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.isValue = isValue;
    exports.isField = isField;
    exports.isExpr = isExpr;
    exports.isVectorized = isVectorized;
    const types_1 = require(8) /* ./util/types */;
    const object_1 = require(9) /* ./util/object */;
    function is_of_type(obj, field) {
        if (!(0, types_1.isPlainObject)(obj)) {
            return false;
        }
        if (!(field in obj)) {
            return false;
        }
        let n = (0, object_1.size)(obj) - 1;
        if ("transform" in obj) {
            n -= 1;
        }
        if ("units" in obj) {
            n -= 1;
        }
        return n == 0;
    }
    function isValue(obj) {
        return is_of_type(obj, "value");
    }
    function isField(obj) {
        return is_of_type(obj, "field");
    }
    function isExpr(obj) {
        return is_of_type(obj, "expr");
    }
    function isVectorized(obj) {
        return isValue(obj) || isField(obj) || isExpr(obj);
    }
},
/* core/settings.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    class Settings {
        constructor() {
            this._dev = false;
            this._wireframe = false;
            this._force_webgl = false;
            this._force_fields = false;
        }
        set dev(dev) {
            this._dev = dev;
        }
        get dev() {
            return this._dev;
        }
        set wireframe(wireframe) {
            this._wireframe = wireframe;
        }
        get wireframe() {
            return this._wireframe;
        }
        set force_webgl(force_webgl) {
            this._force_webgl = force_webgl;
        }
        get force_webgl() {
            return this._force_webgl;
        }
        set force_fields(force_fields) {
            this._force_fields = force_fields;
        }
        get force_fields() {
            return this._force_fields;
        }
    }
    exports.Settings = Settings;
    Settings.__name__ = "Settings";
    exports.settings = new Settings();
},
/* core/util/ndarray.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
    __esModule();
    exports.is_NDArray = is_NDArray;
    exports.ndarray = ndarray;
    const types_1 = require(8) /* ./types */;
    const platform_1 = require(28) /* ./platform */;
    const eq_1 = require(27) /* ./eq */;
    const cloneable_1 = require(32) /* ./cloneable */;
    const serialization_1 = require(33) /* ../serialization */;
    const __ndarray__ = Symbol("__ndarray__");
    function encode_NDArray(array, serializer) {
        const encoded = serializer.encode(array.dtype == "object" ? Array.from(array) : array.buffer);
        return {
            type: "ndarray",
            array: encoded,
            order: platform_1.BYTE_ORDER,
            dtype: array.dtype,
            shape: array.shape,
        };
    }
    class BoolNDArray extends Uint8Array {
        constructor(init, shape) {
            super(init); // XXX: typescript bug?
            this[_a] = true;
            this.dtype = "bool";
            this.shape = shape ?? (is_NDArray(init) ? init.shape : [this.length]);
            this.dimension = this.shape.length;
        }
        [(_a = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [cloneable_1.clone](cloner) {
            return new BoolNDArray(this, cloner.clone(this.shape));
        }
        [serialization_1.serialize](serializer) {
            return encode_NDArray(this, serializer);
        }
        get(i) {
            return this[i] == 1;
        }
    }
    exports.BoolNDArray = BoolNDArray;
    BoolNDArray.__name__ = "BoolNDArray";
    class Uint8NDArray extends Uint8Array {
        constructor(init, shape) {
            super(init); // XXX: typescript bug?
            this[_b] = true;
            this.dtype = "uint8";
            this.shape = shape ?? (is_NDArray(init) ? init.shape : [this.length]);
            this.dimension = this.shape.length;
        }
        [(_b = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [cloneable_1.clone](cloner) {
            return new Uint8NDArray(this, cloner.clone(this.shape));
        }
        [serialization_1.serialize](serializer) {
            return encode_NDArray(this, serializer);
        }
        get(i) {
            return this[i];
        }
    }
    exports.Uint8NDArray = Uint8NDArray;
    Uint8NDArray.__name__ = "Uint8NDArray";
    class Int8NDArray extends Int8Array {
        constructor(init, shape) {
            super(init); // XXX: typescript bug?
            this[_c] = true;
            this.dtype = "int8";
            this.shape = shape ?? (is_NDArray(init) ? init.shape : [this.length]);
            this.dimension = this.shape.length;
        }
        [(_c = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [cloneable_1.clone](cloner) {
            return new Int8NDArray(this, cloner.clone(this.shape));
        }
        [serialization_1.serialize](serializer) {
            return encode_NDArray(this, serializer);
        }
        get(i) {
            return this[i];
        }
    }
    exports.Int8NDArray = Int8NDArray;
    Int8NDArray.__name__ = "Int8NDArray";
    class Uint16NDArray extends Uint16Array {
        constructor(init, shape) {
            super(init); // XXX: typescript bug?
            this[_d] = true;
            this.dtype = "uint16";
            this.shape = shape ?? (is_NDArray(init) ? init.shape : [this.length]);
            this.dimension = this.shape.length;
        }
        [(_d = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [cloneable_1.clone](cloner) {
            return new Uint16NDArray(this, cloner.clone(this.shape));
        }
        [serialization_1.serialize](serializer) {
            return encode_NDArray(this, serializer);
        }
        get(i) {
            return this[i];
        }
    }
    exports.Uint16NDArray = Uint16NDArray;
    Uint16NDArray.__name__ = "Uint16NDArray";
    class Int16NDArray extends Int16Array {
        constructor(init, shape) {
            super(init); // XXX: typescript bug?
            this[_e] = true;
            this.dtype = "int16";
            this.shape = shape ?? (is_NDArray(init) ? init.shape : [this.length]);
            this.dimension = this.shape.length;
        }
        [(_e = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [cloneable_1.clone](cloner) {
            return new Int16NDArray(this, cloner.clone(this.shape));
        }
        [serialization_1.serialize](serializer) {
            return encode_NDArray(this, serializer);
        }
        get(i) {
            return this[i];
        }
    }
    exports.Int16NDArray = Int16NDArray;
    Int16NDArray.__name__ = "Int16NDArray";
    class Uint32NDArray extends Uint32Array {
        constructor(init, shape) {
            super(init); // XXX: typescript bug?
            this[_f] = true;
            this.dtype = "uint32";
            this.shape = shape ?? (is_NDArray(init) ? init.shape : [this.length]);
            this.dimension = this.shape.length;
        }
        [(_f = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [cloneable_1.clone](cloner) {
            return new Uint32NDArray(this, cloner.clone(this.shape));
        }
        [serialization_1.serialize](serializer) {
            return encode_NDArray(this, serializer);
        }
        get(i) {
            return this[i];
        }
    }
    exports.Uint32NDArray = Uint32NDArray;
    Uint32NDArray.__name__ = "Uint32NDArray";
    class Int32NDArray extends Int32Array {
        constructor(init, shape) {
            super(init); // XXX: typescript bug?
            this[_g] = true;
            this.dtype = "int32";
            this.shape = shape ?? (is_NDArray(init) ? init.shape : [this.length]);
            this.dimension = this.shape.length;
        }
        [(_g = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [cloneable_1.clone](cloner) {
            return new Int32NDArray(this, cloner.clone(this.shape));
        }
        [serialization_1.serialize](serializer) {
            return encode_NDArray(this, serializer);
        }
        get(i) {
            return this[i];
        }
    }
    exports.Int32NDArray = Int32NDArray;
    Int32NDArray.__name__ = "Int32NDArray";
    class Float32NDArray extends Float32Array {
        constructor(init, shape) {
            super(init); // XXX: typescript bug?
            this[_h] = true;
            this.dtype = "float32";
            this.shape = shape ?? (is_NDArray(init) ? init.shape : [this.length]);
            this.dimension = this.shape.length;
        }
        [(_h = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [cloneable_1.clone](cloner) {
            return new Float32NDArray(this, cloner.clone(this.shape));
        }
        [serialization_1.serialize](serializer) {
            return encode_NDArray(this, serializer);
        }
        get(i) {
            return this[i];
        }
    }
    exports.Float32NDArray = Float32NDArray;
    Float32NDArray.__name__ = "Float32NDArray";
    class Float64NDArray extends Float64Array {
        constructor(init, shape) {
            super(init); // XXX: typescript bug?
            this[_j] = true;
            this.dtype = "float64";
            this.shape = shape ?? (is_NDArray(init) ? init.shape : [this.length]);
            this.dimension = this.shape.length;
        }
        [(_j = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [cloneable_1.clone](cloner) {
            return new Float64NDArray(this, cloner.clone(this.shape));
        }
        [serialization_1.serialize](serializer) {
            return encode_NDArray(this, serializer);
        }
        get(i) {
            return this[i];
        }
    }
    exports.Float64NDArray = Float64NDArray;
    Float64NDArray.__name__ = "Float64NDArray";
    class ObjectNDArray extends Array {
        get shape() {
            return this._shape ?? [this.length];
        }
        get dimension() {
            return this.shape.length;
        }
        constructor(init_, shape) {
            const init = (0, types_1.is_ArrayBufferLike)(init_) ? new Float64Array(init_) : init_;
            const size = (0, types_1.isNumber)(init) ? init : init.length;
            super(size);
            this[_k] = true;
            this.dtype = "object";
            if (!(0, types_1.isNumber)(init)) {
                for (let i = 0; i < init.length; i++) {
                    this[i] = init[i];
                }
            }
            this._shape = shape ?? (is_NDArray(init) ? init.shape : undefined);
        }
        [(_k = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [cloneable_1.clone](cloner) {
            return new ObjectNDArray(this, cloner.clone(this.shape));
        }
        [serialization_1.serialize](serializer) {
            return encode_NDArray(this, serializer);
        }
        get(i) {
            return this[i];
        }
    }
    exports.ObjectNDArray = ObjectNDArray;
    ObjectNDArray.__name__ = "ObjectNDArray";
    function is_NDArray(v) {
        return (0, types_1.isObject)(v) && __ndarray__ in v;
    }
    function ndarray(init, { dtype, shape } = {}) {
        if (dtype == null) {
            dtype = (() => {
                switch (true) {
                    case init instanceof Uint8Array: return "uint8";
                    case init instanceof Int8Array: return "int8";
                    case init instanceof Uint16Array: return "uint16";
                    case init instanceof Int16Array: return "int16";
                    case init instanceof Uint32Array: return "uint32";
                    case init instanceof Int32Array: return "int32";
                    case init instanceof Float32Array: return "float32";
                    case init instanceof Float64Array: return "float64";
                    default: {
                        if ((0, types_1.is_ArrayBufferLike)(init)) {
                            return "float64";
                        }
                        else {
                            return "object";
                        }
                    }
                }
            })();
        }
        switch (dtype) {
            case "bool": return new BoolNDArray(init, shape);
            case "uint8": return new Uint8NDArray(init, shape);
            case "int8": return new Int8NDArray(init, shape);
            case "uint16": return new Uint16NDArray(init, shape);
            case "int16": return new Int16NDArray(init, shape);
            case "uint32": return new Uint32NDArray(init, shape);
            case "int32": return new Int32NDArray(init, shape);
            case "float32": return new Float32NDArray(init, shape);
            case "float64": return new Float64NDArray(init, shape);
            case "object": return new ObjectNDArray(init, shape);
        }
    }
},
/* core/util/cloneable.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.is_Cloneable = is_Cloneable;
    const object_1 = require(9) /* ./object */;
    const types_1 = require(8) /* ./types */;
    exports.clone = Symbol("clone");
    function is_Cloneable(obj) {
        return (0, types_1.isObject)(obj) && exports.clone in obj;
    }
    class CloningError extends Error {
    }
    exports.CloningError = CloningError;
    CloningError.__name__ = "CloningError";
    class Cloner {
        constructor() { }
        clone(obj) {
            if (is_Cloneable(obj)) {
                return obj[exports.clone](this);
            }
            else if ((0, types_1.isPrimitive)(obj) || (0, types_1.isFunction)(obj)) {
                return obj;
            }
            else if ((0, types_1.isArray)(obj)) {
                const n = obj.length;
                const result = new Array(n);
                for (let i = 0; i < n; i++) {
                    const value = obj[i];
                    result[i] = this.clone(value);
                }
                return result;
            }
            else if ((0, types_1.isPlainObject)(obj)) {
                const result = {};
                for (const [key, value] of (0, object_1.entries)(obj)) {
                    result[key] = this.clone(value);
                }
                return result;
            }
            else if (obj instanceof Map) {
                return new Map([...obj].map(([k, v]) => [this.clone(k), this.clone(v)]));
            }
            else if (obj instanceof Set) {
                return new Set([...obj].map((v) => this.clone(v)));
            }
            else {
                throw new CloningError(`${Object.prototype.toString.call(obj)} is not cloneable`);
            }
        }
    }
    exports.Cloner = Cloner;
    Cloner.__name__ = "Cloner";
},
/* core/serialization/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var serializer_1 = require(34) /* ./serializer */;
    __esExport("Serializer", serializer_1.Serializer);
    __esExport("SerializationError", serializer_1.SerializationError);
    __esExport("serialize", serializer_1.serialize);
    var buffer_1 = require(35) /* ./buffer */;
    __esExport("Buffer", buffer_1.Buffer);
    __esExport("Base64Buffer", buffer_1.Base64Buffer);
    tslib_1.__exportStar(require(37) /* ./reps */, exports);
},
/* core/serialization/serializer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const assert_1 = require(12) /* ../util/assert */;
    const object_1 = require(9) /* ../util/object */;
    const types_1 = require(8) /* ../util/types */;
    const iterator_1 = require(14) /* ../util/iterator */;
    const platform_1 = require(28) /* ../util/platform */;
    const buffer_1 = require(35) /* ./buffer */;
    // TypedArray?
    exports.serialize = Symbol("serialize");
    function is_Serializable(obj) {
        return (0, types_1.isObject)(obj) && exports.serialize in obj;
    }
    class SerializationError extends Error {
    }
    exports.SerializationError = SerializationError;
    SerializationError.__name__ = "SerializationError";
    class Serialized {
        constructor(value) {
            this.value = value;
        }
        to_json() {
            return JSON.stringify(this.value);
        }
    }
    Serialized.__name__ = "Serialized";
    class Serializer {
        constructor(options) {
            this._circular = new WeakSet();
            this.binary = options?.binary ?? false;
            this.include_defaults = options?.include_defaults ?? false;
            const references = options?.references;
            this._references = references != null ? new Map(references) : new Map();
        }
        get_ref(obj) {
            return this._references.get(obj);
        }
        add_ref(obj, ref) {
            (0, assert_1.assert)(!this._references.has(obj));
            this._references.set(obj, ref);
        }
        to_serializable(obj) {
            return new Serialized(this.encode(obj));
        }
        encode(obj) {
            const ref = this.get_ref(obj);
            if (ref != null) {
                return ref;
            }
            if (!(0, types_1.isObject)(obj)) {
                return this._encode(obj);
            }
            else {
                if (this._circular.has(obj)) {
                    this.error("circular reference");
                }
                this._circular.add(obj);
                try {
                    return this._encode(obj);
                }
                finally {
                    this._circular.delete(obj);
                }
            }
        }
        _encode(obj) {
            if (is_Serializable(obj)) {
                return obj[exports.serialize](this);
            }
            else if ((0, types_1.isArray)(obj)) {
                const n = obj.length;
                const result = new Array(n);
                for (let i = 0; i < n; i++) {
                    const value = obj[i];
                    result[i] = this.encode(value);
                }
                return result;
            }
            else if ((0, types_1.isTypedArray)(obj)) {
                return this._encode_typed_array(obj);
            }
            else if (obj instanceof ArrayBuffer) {
                const data = this.binary ? new buffer_1.Buffer(obj) : new buffer_1.Base64Buffer(obj);
                return { type: "bytes", data };
            }
            else if ((0, types_1.isPlainObject)(obj)) {
                const items = (0, object_1.entries)(obj);
                if (items.length == 0) {
                    return { type: "map" };
                }
                else {
                    return { type: "map", entries: [...(0, iterator_1.map)(items, ([key, val]) => [this.encode(key), this.encode(val)])] };
                }
            }
            else if (obj === null || (0, types_1.isBoolean)(obj) || (0, types_1.isString)(obj)) {
                return obj;
            }
            else if ((0, types_1.isNumber)(obj)) {
                if (isNaN(obj)) {
                    return { type: "number", value: "nan" };
                }
                else if (!isFinite(obj)) {
                    return { type: "number", value: `${obj < 0 ? "-" : "+"}inf` };
                }
                else {
                    return obj;
                }
            }
            else if (obj instanceof Date) {
                const iso = obj.toISOString();
                return { type: "date", iso };
            }
            else if (obj instanceof Set) {
                if (obj.size == 0) {
                    return { type: "set" };
                }
                else {
                    return { type: "set", entries: [...(0, iterator_1.map)(obj.values(), (val) => this.encode(val))] };
                }
            }
            else if (obj instanceof Map) {
                if (obj.size == 0) {
                    return { type: "map" };
                }
                else {
                    return { type: "map", entries: [...(0, iterator_1.map)(obj.entries(), ([key, val]) => [this.encode(key), this.encode(val)])] };
                }
            }
            else if ((0, types_1.isSymbol)(obj) && obj.description != null) {
                return { type: "symbol", name: obj.description };
            }
            else {
                throw new SerializationError(`${Object.prototype.toString.call(obj)} is not serializable`);
            }
        }
        encode_struct(struct) {
            const result = {};
            for (const [key, val] of (0, object_1.entries)(struct)) {
                if (val !== undefined) {
                    result[key] = this.encode(val);
                }
            }
            return result;
        }
        error(message) {
            throw new SerializationError(message);
        }
        _encode_typed_array(obj) {
            const array = this.encode(obj.buffer);
            const dtype = (() => {
                switch (obj.constructor) {
                    case Uint8Array: return "uint8";
                    case Int8Array: return "int8";
                    case Uint16Array: return "uint16";
                    case Int16Array: return "int16";
                    case Uint32Array: return "uint32";
                    case Int32Array: return "int32";
                    // case BigUint64Array: return "uint64"
                    // case BigInt64Array: return "int64"
                    case Float32Array: return "float32";
                    case Float64Array: return "float64";
                    default:
                        this.error(`can't serialize typed array of type '${obj[Symbol.toStringTag]}'`);
                }
            })();
            return {
                type: "typed_array",
                array,
                order: platform_1.BYTE_ORDER,
                dtype,
            };
        }
    }
    exports.Serializer = Serializer;
    Serializer.__name__ = "Serializer";
},
/* core/serialization/buffer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const buffer_1 = require(36) /* ../util/buffer */;
    const eq_1 = require(27) /* ../util/eq */;
    class Buffer {
        constructor(buffer) {
            this.buffer = buffer;
        }
        to_base64() {
            return (0, buffer_1.buffer_to_base64)(this.buffer);
        }
        [eq_1.equals](that, cmp) {
            return cmp.eq(this.buffer, that.buffer);
        }
    }
    exports.Buffer = Buffer;
    Buffer.__name__ = "Buffer";
    class Base64Buffer extends Buffer {
        toJSON() {
            return this.to_base64();
        }
    }
    exports.Base64Buffer = Base64Buffer;
    Base64Buffer.__name__ = "Base64Buffer";
},
/* core/util/buffer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.buffer_to_base64 = buffer_to_base64;
    exports.base64_to_buffer = base64_to_buffer;
    exports.swap = swap;
    function buffer_to_base64(buffer) {
        const bytes = new Uint8Array(buffer);
        const chars = Array.from(bytes).map((b) => String.fromCharCode(b));
        return btoa(chars.join(""));
    }
    function base64_to_buffer(base64) {
        const binary_string = atob(base64);
        const len = binary_string.length;
        const bytes = new Uint8Array(len);
        for (let i = 0, end = len; i < end; i++) {
            bytes[i] = binary_string.charCodeAt(i);
        }
        return bytes.buffer;
    }
    // NOTE: swap{16,32,64} assume byteOffset == 0
    function swap16(buffer) {
        const x = new Uint8Array(buffer);
        for (let i = 0, end = x.length; i < end; i += 2) {
            const t = x[i];
            x[i] = x[i + 1];
            x[i + 1] = t;
        }
    }
    function swap32(buffer) {
        const x = new Uint8Array(buffer);
        for (let i = 0, end = x.length; i < end; i += 4) {
            let t = x[i];
            x[i] = x[i + 3];
            x[i + 3] = t;
            t = x[i + 1];
            x[i + 1] = x[i + 2];
            x[i + 2] = t;
        }
    }
    function swap64(buffer) {
        const x = new Uint8Array(buffer);
        for (let i = 0, end = x.length; i < end; i += 8) {
            let t = x[i];
            x[i] = x[i + 7];
            x[i + 7] = t;
            t = x[i + 1];
            x[i + 1] = x[i + 6];
            x[i + 6] = t;
            t = x[i + 2];
            x[i + 2] = x[i + 5];
            x[i + 5] = t;
            t = x[i + 3];
            x[i + 3] = x[i + 4];
            x[i + 4] = t;
        }
    }
    function swap(buffer, dtype) {
        switch (dtype) {
            case "uint16":
            case "int16":
                swap16(buffer);
                break;
            case "uint32":
            case "int32":
            case "float32":
                swap32(buffer);
                break;
            case "float64":
                swap64(buffer);
                break;
            case "object":
            case "uint8":
            case "int8":
            case "bool":
                break;
        }
    }
},
/* core/serialization/reps.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
},
/* core/diagnostics.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    class Diagnostics {
        constructor() {
            this.listeners = new Set();
        }
        connect(listener) {
            this.listeners.add(listener);
        }
        disconnect(listener) {
            this.listeners.delete(listener);
        }
        report(obj) {
            for (const listener of this.listeners) {
                listener(obj);
            }
        }
    }
    exports.Diagnostics = Diagnostics;
    Diagnostics.__name__ = "Diagnostics";
    exports.diagnostics = new Diagnostics();
},
/* core/uniforms.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.min = min;
    exports.max = max;
    exports.some = some;
    exports.every = every;
    const tslib_1 = require(1) /* tslib */;
    const eq_1 = require(27) /* ./util/eq */;
    const arrayable = tslib_1.__importStar(require(13) /* ./util/arrayable */);
    class Uniform {
        is_Scalar() {
            return this.is_scalar;
        }
        is_Vector() {
            return !this.is_scalar;
        }
    }
    exports.Uniform = Uniform;
    Uniform.__name__ = "Uniform";
    class UniformScalar extends Uniform {
        constructor(value, length) {
            super();
            this.is_scalar = true;
            this.value = value;
            this.length = length;
        }
        get(_i) {
            return this.value;
        }
        *[Symbol.iterator]() {
            const { length, value } = this;
            for (let i = 0; i < length; i++) {
                yield value;
            }
        }
        select(indices) {
            return new UniformScalar(this.value, indices.count);
        }
        [eq_1.equals](that, cmp) {
            return cmp.eq(this.length, that.length) && cmp.eq(this.value, that.value);
        }
        map(fn) {
            return new UniformScalar(fn(this.value), this.length);
        }
        unique() {
            return [this.value];
        }
    }
    exports.UniformScalar = UniformScalar;
    UniformScalar.__name__ = "UniformScalar";
    class UniformVector extends Uniform {
        constructor(array) {
            super();
            this.is_scalar = false;
            this.array = array;
            this.length = this.array.length;
        }
        get(i) {
            return this.array[i];
        }
        *[Symbol.iterator]() {
            yield* this.array;
        }
        select(indices) {
            const array = indices.select(this.array);
            return new this.constructor(array);
        }
        [eq_1.equals](that, cmp) {
            return cmp.eq(this.length, that.length) && cmp.eq(this.array, that.array);
        }
        map(fn) {
            return new UniformVector(arrayable.map(this.array, fn));
        }
        unique() {
            return [...new Set(this.array)];
        }
    }
    exports.UniformVector = UniformVector;
    UniformVector.__name__ = "UniformVector";
    class ColorUniformVector extends UniformVector {
        constructor(array) {
            super(array);
            this.array = array;
            this._view = new DataView(array.buffer);
        }
        get(i) {
            return this._view.getUint32(4 * i);
        }
        *[Symbol.iterator]() {
            const n = this.length;
            for (let i = 0; i < n; i++) {
                yield this.get(i);
            }
        }
    }
    exports.ColorUniformVector = ColorUniformVector;
    ColorUniformVector.__name__ = "ColorUniformVector";
    function min(u) {
        return u.is_Scalar() ? u.value : arrayable.min(u.array);
    }
    function max(u) {
        return u.is_Scalar() ? u.value : arrayable.max(u.array);
    }
    function some(u, predicate) {
        return u.is_Scalar() ? predicate(u.value) : arrayable.some(u.array, predicate);
    }
    function every(u, predicate) {
        return u.is_Scalar() ? predicate(u.value) : arrayable.every(u.array, predicate);
    }
},
/* core/util/string.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.uuid4 = uuid4;
    exports.unique_id = unique_id;
    exports.escape = escape;
    exports.unescape = unescape;
    exports.use_strict = use_strict;
    exports.to_fixed = to_fixed;
    exports.insert_text_on_position = insert_text_on_position;
    const settings_1 = require(30) /* ../settings */;
    function uuid4() {
        // from ipython project
        // http://www.ietf.org/rfc/rfc4122.txt
        const s = new Array(32);
        const hex_digits = "0123456789ABCDEF";
        for (let i = 0; i < 32; i++) {
            s[i] = hex_digits[Math.floor(Math.random() * 0x10)];
        }
        s[12] = "4"; // bits 12-15 of the time_hi_and_version field to 0010
        s[16] = hex_digits[(s[16].charCodeAt(0) & 0x3) | 0x8]; // bits 6-7 of the clock_seq_hi_and_reserved to 01
        return s.join("");
    }
    let counter = 1000;
    function unique_id(prefix) {
        const id = settings_1.settings.dev ? `j${counter++}` : uuid4();
        if (prefix != null) {
            return `${prefix}-${id}`;
        }
        else {
            return id;
        }
    }
    function escape(s) {
        return s.replace(/(?:[&<>"'`])/g, (ch) => {
            switch (ch) {
                case "&": return "&amp;";
                case "<": return "&lt;";
                case ">": return "&gt;";
                case '"': return "&quot;";
                case "'": return "&#x27;";
                case "`": return "&#x60;";
                default: return ch;
            }
        });
    }
    function unescape(s) {
        return s.replace(/&(amp|lt|gt|quot|#x27|#x60);/g, (_, entity) => {
            switch (entity) {
                case "amp": return "&";
                case "lt": return "<";
                case "gt": return ">";
                case "quot": return '"';
                case "#x27": return "'";
                case "#x60": return "`";
                default: return entity;
            }
        });
    }
    function use_strict(code) {
        return `'use strict';\n${code}`;
    }
    function to_fixed(val, precision) {
        return val.toFixed(precision).replace(/(\.[0-9]*?)0+$/, "$1").replace(/\.$/, "");
    }
    function insert_text_on_position(destination, position, text_to_be_inserted) {
        const result_text = [];
        result_text.push(destination.slice(0, position));
        result_text.push(text_to_be_inserted);
        result_text.push(destination.slice(position));
        return result_text.join("");
    }
},
/* document/events.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const eq_1 = require(27) /* ../core/util/eq */;
    const serialization_1 = require(33) /* ../core/serialization */;
    class DocumentEvent {
        constructor(document) {
            /**
             * Indicates whether this event should be emitted internally within bokehjs,
             * or whether it should also be synchronized with the server, if any session
             * is listening for such events.
             */
            this.sync = true;
            this.document = document;
        }
        get [Symbol.toStringTag]() {
            return this.constructor.__name__;
        }
        [eq_1.equals](that, cmp) {
            return cmp.eq(this.document, that.document);
        }
    }
    exports.DocumentEvent = DocumentEvent;
    DocumentEvent.__name__ = "DocumentEvent";
    class DocumentEventBatch extends DocumentEvent {
        constructor(document, events) {
            super(document);
            this.events = events;
        }
        [eq_1.equals](that, cmp) {
            return super[eq_1.equals](that, cmp) &&
                cmp.eq(this.events, that.events);
        }
    }
    exports.DocumentEventBatch = DocumentEventBatch;
    DocumentEventBatch.__name__ = "DocumentEventBatch";
    class DocumentChangedEvent extends DocumentEvent {
    }
    exports.DocumentChangedEvent = DocumentChangedEvent;
    DocumentChangedEvent.__name__ = "DocumentChangedEvent";
    class MessageSentEvent extends DocumentChangedEvent {
        constructor(document, msg_type, msg_data) {
            super(document);
            this.kind = "MessageSent";
            this.msg_type = msg_type;
            this.msg_data = msg_data;
        }
        [eq_1.equals](that, cmp) {
            return super[eq_1.equals](that, cmp) &&
                cmp.eq(this.msg_type, that.msg_type) &&
                cmp.eq(this.msg_data, that.msg_data);
        }
        [serialization_1.serialize](serializer) {
            return {
                kind: this.kind,
                msg_type: this.msg_type,
                msg_data: serializer.encode(this.msg_data),
            };
        }
    }
    exports.MessageSentEvent = MessageSentEvent;
    MessageSentEvent.__name__ = "MessageSentEvent";
    class ModelChangedEvent extends DocumentChangedEvent {
        constructor(document, model, attr, value) {
            super(document);
            this.kind = "ModelChanged";
            this.model = model;
            this.attr = attr;
            this.value = value;
        }
        [eq_1.equals](that, cmp) {
            return super[eq_1.equals](that, cmp) &&
                cmp.eq(this.model, that.model) &&
                cmp.eq(this.attr, that.attr) &&
                cmp.eq(this.value, that.value);
        }
        [serialization_1.serialize](serializer) {
            return {
                kind: this.kind,
                model: this.model.ref(),
                attr: this.attr,
                new: serializer.encode(this.value),
            };
        }
    }
    exports.ModelChangedEvent = ModelChangedEvent;
    ModelChangedEvent.__name__ = "ModelChangedEvent";
    class ColumnDataChangedEvent extends DocumentChangedEvent {
        constructor(document, model, attr, data, cols) {
            super(document);
            this.kind = "ColumnDataChanged";
            this.model = model;
            this.attr = attr;
            this.data = data;
            this.cols = cols;
        }
        [eq_1.equals](that, cmp) {
            return super[eq_1.equals](that, cmp) &&
                cmp.eq(this.model, that.model) &&
                cmp.eq(this.attr, that.attr) &&
                cmp.eq(this.data, that.data) &&
                cmp.eq(this.cols, that.cols);
        }
        [serialization_1.serialize](serializer) {
            return {
                kind: this.kind,
                model: this.model.ref(),
                attr: this.attr,
                data: serializer.encode(this.data),
                cols: this.cols,
            };
        }
    }
    exports.ColumnDataChangedEvent = ColumnDataChangedEvent;
    ColumnDataChangedEvent.__name__ = "ColumnDataChangedEvent";
    class ColumnsStreamedEvent extends DocumentChangedEvent {
        constructor(document, model, attr, data, rollover) {
            super(document);
            this.kind = "ColumnsStreamed";
            this.model = model;
            this.attr = attr;
            this.data = data;
            this.rollover = rollover;
        }
        [eq_1.equals](that, cmp) {
            return super[eq_1.equals](that, cmp) &&
                cmp.eq(this.model, that.model) &&
                cmp.eq(this.attr, that.attr) &&
                cmp.eq(this.data, that.data) &&
                cmp.eq(this.rollover, that.rollover);
        }
        [serialization_1.serialize](serializer) {
            return {
                kind: this.kind,
                model: this.model.ref(),
                attr: this.attr,
                data: serializer.encode(this.data),
                rollover: this.rollover,
            };
        }
    }
    exports.ColumnsStreamedEvent = ColumnsStreamedEvent;
    ColumnsStreamedEvent.__name__ = "ColumnsStreamedEvent";
    class ColumnsPatchedEvent extends DocumentChangedEvent {
        constructor(document, model, attr, patches) {
            super(document);
            this.kind = "ColumnsPatched";
            this.model = model;
            this.attr = attr;
            this.patches = patches;
        }
        [eq_1.equals](that, cmp) {
            return super[eq_1.equals](that, cmp) &&
                cmp.eq(this.model, that.model) &&
                cmp.eq(this.attr, that.attr) &&
                cmp.eq(this.patches, that.patches);
        }
        [serialization_1.serialize](serializer) {
            return {
                kind: this.kind,
                attr: this.attr,
                model: this.model.ref(),
                patches: serializer.encode(this.patches),
            };
        }
    }
    exports.ColumnsPatchedEvent = ColumnsPatchedEvent;
    ColumnsPatchedEvent.__name__ = "ColumnsPatchedEvent";
    class TitleChangedEvent extends DocumentChangedEvent {
        constructor(document, title) {
            super(document);
            this.kind = "TitleChanged";
            this.title = title;
        }
        [eq_1.equals](that, cmp) {
            return super[eq_1.equals](that, cmp) &&
                cmp.eq(this.title, that.title);
        }
        [serialization_1.serialize](_serializer) {
            return {
                kind: this.kind,
                title: this.title,
            };
        }
    }
    exports.TitleChangedEvent = TitleChangedEvent;
    TitleChangedEvent.__name__ = "TitleChangedEvent";
    class RootAddedEvent extends DocumentChangedEvent {
        constructor(document, model) {
            super(document);
            this.kind = "RootAdded";
            this.model = model;
        }
        [eq_1.equals](that, cmp) {
            return super[eq_1.equals](that, cmp) &&
                cmp.eq(this.model, that.model);
        }
        [serialization_1.serialize](serializer) {
            return {
                kind: this.kind,
                model: serializer.encode(this.model),
            };
        }
    }
    exports.RootAddedEvent = RootAddedEvent;
    RootAddedEvent.__name__ = "RootAddedEvent";
    class RootRemovedEvent extends DocumentChangedEvent {
        constructor(document, model) {
            super(document);
            this.kind = "RootRemoved";
            this.model = model;
        }
        [eq_1.equals](that, cmp) {
            return super[eq_1.equals](that, cmp) &&
                cmp.eq(this.model, that.model);
        }
        [serialization_1.serialize](_serializer) {
            return {
                kind: this.kind,
                model: this.model.ref(),
            };
        }
    }
    exports.RootRemovedEvent = RootRemovedEvent;
    RootRemovedEvent.__name__ = "RootRemovedEvent";
},
/* core/util/pretty.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.to_string = to_string;
    const types_1 = require(8) /* ./types */;
    const object_1 = require(9) /* ./object */;
    exports.pretty = Symbol("pretty");
    function is_Printable(obj) {
        return (0, types_1.isObject)(obj) && exports.pretty in obj;
    }
    class Printer {
        constructor(options) {
            this.visited = new Set();
            this.precision = options?.precision;
        }
        to_string(obj) {
            if ((0, types_1.isObject)(obj)) {
                if (this.visited.has(obj)) {
                    return "<circular>";
                }
                else {
                    this.visited.add(obj);
                }
            }
            if (is_Printable(obj)) {
                return obj[exports.pretty](this);
            }
            else if ((0, types_1.isBoolean)(obj)) {
                return this.boolean(obj);
            }
            else if ((0, types_1.isNumber)(obj)) {
                return this.number(obj);
            }
            else if ((0, types_1.isString)(obj)) {
                return this.string(obj);
            }
            else if ((0, types_1.isArray)(obj)) {
                return this.array(obj);
            }
            else if ((0, types_1.isIterable)(obj)) {
                return this.iterable(obj);
            }
            else if ((0, types_1.isPlainObject)(obj)) {
                return this.object(obj);
            }
            else if ((0, types_1.isSymbol)(obj)) {
                return this.symbol(obj);
            }
            else if (obj instanceof ArrayBuffer) {
                return this.array_buffer(obj);
            }
            else {
                return `${obj}`;
            }
        }
        token(val) {
            return val;
        }
        boolean(val) {
            return `${val}`;
        }
        number(val) {
            if (this.precision != null) {
                return val.toFixed(this.precision);
            }
            else {
                return `${val}`;
            }
        }
        string(val) {
            const sq = val.includes("'");
            const dq = val.includes('"');
            if (sq && dq) {
                return `\`${val.replace(/`/g, "\\`")}\``;
            }
            else if (dq) {
                return `'${val}'`;
            }
            else {
                return `"${val}"`;
            }
        }
        symbol(val) {
            return val.toString();
        }
        array(obj) {
            const T = this.token;
            const items = [];
            for (const entry of obj) {
                items.push(this.to_string(entry));
            }
            return `${T("[")}${items.join(`${T(",")} `)}${T("]")}`;
        }
        iterable(obj) {
            const T = this.token;
            const tag = Object(obj)[Symbol.toStringTag] ?? "Object";
            const items = this.array(obj);
            return `${tag}${T("(")}${items}${T(")")}`;
        }
        object(obj) {
            const T = this.token;
            const items = [];
            for (const [key, val] of (0, object_1.entries)(obj)) {
                items.push(`${key}${T(":")} ${this.to_string(val)}`);
            }
            return `${T("{")}${items.join(`${T(",")} `)}${T("}")}`;
        }
        array_buffer(obj) {
            return `ArrayBuffer(#${obj.byteLength})`;
        }
    }
    exports.Printer = Printer;
    Printer.__name__ = "Printer";
    function to_string(obj, options) {
        const printer = new Printer(options);
        return printer.to_string(obj);
    }
},
/* core/patching.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.stream_to_column = stream_to_column;
    exports.slice = slice;
    exports.patch_to_column = patch_to_column;
    exports.stream_to_columns = stream_to_columns;
    exports.patch_to_columns = patch_to_columns;
    const tslib_1 = require(1) /* tslib */;
    const types_1 = require(8) /* ./util/types */;
    const object_1 = require(9) /* ./util/object */;
    const set_1 = require(44) /* ./util/set */;
    const typed_array = tslib_1.__importStar(require(45) /* ./util/typed_array */);
    // exported for testing
    function stream_to_column(col, new_col, rollover) {
        if ((0, types_1.isArray)(col) && (0, types_1.isArray)(new_col)) {
            const result = col.concat(new_col);
            if (rollover != null && result.length > rollover) {
                return result.slice(-rollover);
            }
            else {
                return result;
            }
        }
        const total_len = col.length + new_col.length;
        // handle rollover case for typed arrays
        if (rollover != null && total_len > rollover) {
            const start = total_len - rollover;
            const end = col.length;
            // resize col if it is shorter than the rollover length
            const result = (() => {
                if (col.length < rollover) {
                    const ctor = (() => {
                        if ((0, types_1.isTypedArray)(col)) {
                            return col.constructor;
                        }
                        else if ((0, types_1.isTypedArray)(new_col)) {
                            return new_col.constructor;
                        }
                        else {
                            throw new Error("unsupported array types");
                        }
                    })();
                    const result = new ctor(rollover);
                    result.set(col, 0);
                    return result;
                }
                else {
                    return col;
                }
            })();
            // shift values in original col to accommodate new_col
            for (let i = start, endi = end; i < endi; i++) {
                result[i - start] = result[i];
            }
            // update end values in col with new_col
            for (let i = 0, endi = new_col.length; i < endi; i++) {
                result[i + (end - start)] = new_col[i];
            }
            return result;
        }
        else {
            const col_ = (() => {
                if ((0, types_1.isTypedArray)(col)) {
                    return col;
                }
                else if ((0, types_1.isTypedArray)(new_col)) {
                    return new new_col.constructor(col);
                }
                else {
                    throw new Error("unsupported array types");
                }
            })();
            return typed_array.concat(col_, new_col);
        }
    }
    // exported for testing
    function slice(ind, length) {
        let start, step, stop;
        if ((0, types_1.isNumber)(ind)) {
            start = ind;
            stop = ind + 1;
            step = 1;
        }
        else {
            start = ind.start != null ? ind.start : 0;
            stop = ind.stop != null ? ind.stop : length;
            step = ind.step != null ? ind.step : 1;
        }
        return [start, stop, step];
    }
    // exported for testing
    function patch_to_column(col, patch) {
        const patched = new Set();
        let patched_range = false;
        for (const [ind, val] of patch) {
            // make the single index case look like the length-3 multi-index case
            let shape;
            let item;
            let index;
            let value;
            if ((0, types_1.isArray)(ind)) {
                const [i] = ind;
                patched.add(i);
                shape = col[i].shape;
                item = col[i];
                value = val;
                // this is basically like NumPy's "newaxis", inserting an empty dimension
                // makes length 2 and 3 multi-index cases uniform, so that the same code
                // can handle both
                if (ind.length === 2) {
                    shape = [1, shape[0]];
                    index = [ind[0], 0, ind[1]];
                }
                else {
                    index = ind;
                }
            }
            else {
                if ((0, types_1.isNumber)(ind)) {
                    value = [val];
                    patched.add(ind);
                }
                else {
                    value = val;
                    patched_range = true;
                }
                index = [0, 0, ind];
                shape = [1, col.length];
                item = col;
            }
            // now this one nested loop handles all cases
            let flat_index = 0;
            const [istart, istop, istep] = slice(index[1], shape[0]);
            const [jstart, jstop, jstep] = slice(index[2], shape[1]);
            for (let i = istart; i < istop; i += istep) {
                for (let j = jstart; j < jstop; j += jstep) {
                    if (patched_range) {
                        patched.add(j);
                    }
                    item[i * shape[1] + j] = value[flat_index];
                    flat_index++;
                }
            }
        }
        return patched;
    }
    function stream_to_columns(old_data, new_data, rollover) {
        const data = (0, object_1.dict)(old_data);
        for (const [name, new_column] of (0, object_1.dict)(new_data)) {
            const old_column = data.get(name) ?? [];
            data.set(name, stream_to_column(old_column, new_column, rollover));
        }
    }
    function patch_to_columns(old_data, patches) {
        const data = (0, object_1.dict)(old_data);
        let patched = new Set();
        for (const [name, patch] of (0, object_1.dict)(patches)) {
            const old_column = data.get(name) ?? [];
            patched = (0, set_1.union)(patched, patch_to_column(old_column, patch)); // XXX: any
        }
        return patched;
    }
},
/* core/util/set.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.union = union;
    exports.intersection = intersection;
    exports.difference = difference;
    function union(...sets) {
        const result = new Set();
        for (const set of sets) {
            for (const item of set) {
                result.add(item);
            }
        }
        return result;
    }
    function intersection(set, ...sets) {
        const result = new Set();
        top: for (const item of set) {
            for (const other of sets) {
                if (!other.has(item)) {
                    continue top;
                }
            }
            result.add(item);
        }
        return result;
    }
    function difference(set, ...sets) {
        const result = new Set(set);
        for (const item of union(...sets)) {
            result.delete(item);
        }
        return result;
    }
},
/* core/util/typed_array.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.concat = concat;
    function concat(array0, ...arrays) {
        let n = array0.length;
        for (const array of arrays) {
            n += array.length;
        }
        const result = new array0.constructor(n);
        result.set(array0, 0);
        let i = array0.length;
        for (const array of arrays) {
            result.set(array, i);
            i += array.length;
        }
        return result;
    }
},
/* core/resolvers.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    class ModelResolver {
        constructor(parent, models = []) {
            this._known_models = new Map();
            this.parent = parent;
            for (const model of models) {
                this.register(model);
            }
        }
        get(name) {
            return this._known_models.get(name) ?? this.parent?.get(name) ?? null;
        }
        register(model, force = false) {
            const name = model.__qualified__;
            if (force || this.get(name) == null) {
                this._known_models.set(name, model);
            }
            else {
                console.warn(`Model '${name}' was already registered with this resolver`);
            }
        }
        get names() {
            return [...this._known_models.keys()].sort();
        }
    }
    exports.ModelResolver = ModelResolver;
    ModelResolver.__name__ = "ModelResolver";
},
/* core/serialization/deserializer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const logging_1 = require(20) /* ../logging */;
    const refs_1 = require(18) /* ../util/refs */;
    const ndarray_1 = require(31) /* ../util/ndarray */;
    const object_1 = require(9) /* ../util/object */;
    const array_1 = require(10) /* ../util/array */;
    const platform_1 = require(28) /* ../util/platform */;
    const buffer_1 = require(36) /* ../util/buffer */;
    const types_1 = require(8) /* ../util/types */;
    const slice_1 = require(48) /* ../util/slice */;
    const _decoders = new Map();
    class DeserializationError extends Error {
    }
    exports.DeserializationError = DeserializationError;
    DeserializationError.__name__ = "DeserializationError";
    class Deserializer {
        static register(type, decoder) {
            if (!_decoders.has(type)) {
                _decoders.set(type, decoder);
            }
            else {
                throw new Error(`'${type}' already registered for decoding`);
            }
        }
        constructor(resolver, references = new Map(), finalize) {
            this._decoding = false;
            this._buffers = new Map();
            this._finalizable = new Set();
            this.resolver = resolver;
            this.references = references;
            this.finalize = finalize;
        }
        decode(obj /*AnyVal*/, buffers) {
            if (buffers != null) {
                for (const [id, buffer] of buffers) {
                    this._buffers.set(id, buffer);
                }
            }
            if (this._decoding) {
                return this._decode(obj);
            }
            this._decoding = true;
            let finalizable;
            const decoded = (() => {
                try {
                    return this._decode(obj);
                }
                finally {
                    finalizable = new Set(this._finalizable);
                    this._decoding = false;
                    this._buffers.clear();
                    this._finalizable.clear();
                }
            })();
            for (const instance of finalizable) {
                this.finalize?.(instance);
                instance.finalize();
                instance.assert_initialized();
            }
            // `connect_signals` has to be executed last because it may rely on properties
            // of dependencies that are initialized only in `finalize`. It's a problem
            // that appears when there are circular references, e.g. as in
            // CDS -> CustomJS (on data change) -> GlyphRenderer (in args) -> CDS.
            for (const instance of finalizable) {
                instance.connect_signals();
            }
            return decoded;
        }
        _decode(obj /*AnyVal*/) {
            if ((0, types_1.isArray)(obj)) {
                return this._decode_plain_array(obj);
            }
            else if ((0, types_1.isPlainObject)(obj)) {
                if ((0, types_1.isString)(obj.type)) {
                    const decoder = _decoders.get(obj.type);
                    if (decoder != null) {
                        return decoder(obj, this);
                    }
                    switch (obj.type) {
                        case "ref":
                            return this._decode_ref(obj);
                        case "symbol":
                            return this._decode_symbol(obj);
                        case "number":
                            return this._decode_number(obj);
                        case "array":
                            return this._decode_array(obj);
                        case "set":
                            return this._decode_set(obj);
                        case "map":
                            return this._decode_map(obj);
                        case "bytes":
                            return this._decode_bytes(obj);
                        case "slice":
                            return this._decode_slice(obj);
                        case "date":
                            return this._decode_date(obj);
                        case "value":
                            return this._decode_value(obj);
                        case "field":
                            return this._decode_field(obj);
                        case "expr":
                            return this._decode_expr(obj);
                        case "typed_array":
                            return this._decode_typed_array(obj);
                        case "ndarray":
                            return this._decode_ndarray(obj);
                        case "object": {
                            if ((0, types_1.isString)(obj.id)) {
                                return this._decode_object_ref(obj);
                            }
                            else {
                                return this._decode_object(obj);
                            }
                        }
                        default: {
                            this.error(`unable to decode an object of type '${obj.type}'`);
                        }
                    }
                }
                else if ((0, types_1.isString)(obj.id)) {
                    return this._decode_ref(obj);
                }
                else {
                    return this._decode_plain_object(obj);
                }
            }
            else {
                return obj;
            }
        }
        _decode_symbol(obj) {
            this.error(`can't resolve named symbol '${obj.name}'`); // TODO: implement symbol resolution
        }
        _decode_number(obj) {
            if ("value" in obj) {
                const { value } = obj;
                if ((0, types_1.isString)(value)) {
                    switch (value) {
                        case "nan": return NaN;
                        case "+inf": return +Infinity;
                        case "-inf": return -Infinity;
                    }
                }
                else if ((0, types_1.isNumber)(value)) {
                    return value;
                }
            }
            this.error(`invalid number representation '${obj}'`);
        }
        _decode_plain_array(obj) {
            return (0, array_1.map)(obj, (item) => this._decode(item));
        }
        _decode_plain_object(obj) {
            const decoded = {};
            for (const [key, val] of (0, object_1.entries)(obj)) {
                decoded[key] = this._decode(val);
            }
            return decoded;
        }
        _decode_array(obj) {
            const decoded = [];
            for (const entry of obj.entries ?? []) {
                decoded.push(this._decode(entry));
            }
            return decoded;
        }
        _decode_set(obj) {
            const decoded = new Set();
            for (const entry of obj.entries ?? []) {
                decoded.add(this._decode(entry));
            }
            return decoded;
        }
        _decode_map(obj) {
            const entries = (0, array_1.map)(obj.entries ?? [], ([key, val]) => [this._decode(key), this._decode(val)]);
            const is_plain = entries.every(([key, _val]) => (0, types_1.isString)(key));
            // An empty container will result in a plain object, not a Map, thus in the case of
            // kinds.Mapping property type, one needs to accommodate for this in all instances.
            // Fortunately there are few of these scattered across `src/lib/models/`. See HACK
            // in `Mapping.coerce()` in `core/util/kinds`.
            if (is_plain) {
                return Object.fromEntries(entries);
            }
            else {
                return new Map(entries);
            }
        }
        _decode_bytes(obj) {
            const { data } = obj;
            if ((0, refs_1.is_ref)(data)) {
                const buffer = this._buffers.get(data.id);
                if (buffer != null) {
                    return buffer;
                }
                else {
                    this.error(`buffer for id=${data.id} not found`);
                }
            }
            else if ((0, types_1.isString)(data)) {
                return (0, buffer_1.base64_to_buffer)(data);
            }
            else {
                return data.buffer;
            }
        }
        _decode_slice(obj) {
            const start = this._decode(obj.start);
            const stop = this._decode(obj.stop);
            const step = this._decode(obj.step);
            return new slice_1.Slice({ start, stop, step });
        }
        _decode_date(obj) {
            const iso = this._decode(obj.iso);
            return new Date(iso);
        }
        _decode_value(obj) {
            const value = this._decode(obj.value);
            const transform = obj.transform != null ? this._decode(obj.transform) : undefined;
            const units = obj.units != null ? this._decode(obj.units) : undefined;
            return { value, transform, units };
        }
        _decode_field(obj) {
            const field = this._decode(obj.field);
            const transform = obj.transform != null ? this._decode(obj.transform) : undefined;
            const units = obj.units != null ? this._decode(obj.units) : undefined;
            return { field, transform, units };
        }
        _decode_expr(obj) {
            const expr = this._decode(obj.expr);
            const transform = obj.transform != null ? this._decode(obj.transform) : undefined;
            const units = obj.units != null ? this._decode(obj.units) : undefined;
            return { expr, transform, units };
        }
        _decode_typed_array(obj) {
            const { array, order, dtype } = obj;
            const buffer = this._decode(array);
            if (order != platform_1.BYTE_ORDER) {
                (0, buffer_1.swap)(buffer, dtype);
            }
            switch (dtype) {
                case "uint8": return new Uint8Array(buffer);
                case "int8": return new Int8Array(buffer);
                case "uint16": return new Uint16Array(buffer);
                case "int16": return new Int16Array(buffer);
                case "uint32": return new Uint32Array(buffer);
                case "int32": return new Int32Array(buffer);
                // case "uint64": return new BigInt64Array(buffer)
                // case "int64":  return new BigInt64Array(buffer)
                case "float32": return new Float32Array(buffer);
                case "float64": return new Float64Array(buffer);
                default:
                    this.error(`unsupported dtype '${dtype}'`);
            }
        }
        _decode_ndarray(obj) {
            const { array, order, dtype, shape } = obj;
            const decoded = this._decode(array);
            if (decoded instanceof ArrayBuffer && order != platform_1.BYTE_ORDER) {
                (0, buffer_1.swap)(decoded, dtype);
            }
            return (0, ndarray_1.ndarray)(decoded /*XXX*/, { dtype, shape });
        }
        _decode_object(obj) {
            const { name: type, attributes } = obj;
            const cls = this._resolve_type(type);
            if (attributes != null) {
                return new cls(this._decode(attributes));
            }
            else {
                return new cls();
            }
        }
        _decode_ref(obj) {
            const instance = this.references.get(obj.id);
            if (instance != null) {
                return instance;
            }
            else {
                this.error(`reference ${obj.id} isn't known`);
            }
        }
        _decode_object_ref(obj) {
            const { id, name: type, attributes } = obj;
            const ref = this.references.get(id);
            if (ref != null) {
                if (ref.type == type) {
                    const decoded_attributes = this._decode(attributes ?? {});
                    ref.setv(decoded_attributes, { sync: false });
                    return ref;
                }
                else {
                    this.error(`type mismatch for an existing reference '${ref}', expected '${type}'`);
                }
            }
            else {
                const cls = this._resolve_type(type);
                const instance = new cls({ id });
                this.references.set(id, instance);
                const decoded_attributes = this._decode(attributes ?? {});
                instance.initialize_props(decoded_attributes);
                this._finalizable.add(instance);
                return instance;
            }
        }
        error(message) {
            throw new DeserializationError(message);
        }
        warning(message) {
            logging_1.logger.warn(message);
        }
        _resolve_type(type) {
            const cls = this.resolver.get(type);
            if (cls != null) {
                return cls;
            }
            else {
                this.error(`could not resolve type '${type}', which could be due to a widget or a custom model not being registered before first usage`);
            }
        }
    }
    exports.Deserializer = Deserializer;
    Deserializer.__name__ = "Deserializer";
},
/* core/util/slice.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const serialization_1 = require(33) /* ../serialization */;
    class Slice {
        constructor({ start, stop, step } = {}) {
            this.start = start ?? null;
            this.stop = stop ?? null;
            this.step = step ?? null;
        }
        [serialization_1.serialize](serializer) {
            return {
                type: "slice",
                start: serializer.encode(this.start),
                stop: serializer.encode(this.stop),
                step: serializer.encode(this.step),
            };
        }
    }
    exports.Slice = Slice;
    Slice.__name__ = "Slice";
},
/* core/util/version.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const eq_1 = require(27) /* ./eq */;
    const version_re = /^(?<major>\d+)\.(?<minor>\d+)\.(?<patch>\d+)(?:(?<type>-dev\.|-rc\.|.dev|rc)(?<revision>\d+))?(?:\+(?<build>\d+)\..+)?$/;
    (function (ReleaseType) {
        ReleaseType[ReleaseType["Dev"] = 0] = "Dev";
        ReleaseType[ReleaseType["Candidate"] = 1] = "Candidate";
        ReleaseType[ReleaseType["Release"] = 2] = "Release";
    })(exports.ReleaseType || (exports.ReleaseType = {}));
    class Version {
        constructor(major, minor, patch, type = exports.ReleaseType.Release, revision = 0, build = 0) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
            this.type = type;
            this.revision = revision;
            this.build = build;
        }
        static from(version) {
            return parse_version(version);
        }
        toString() {
            const { major, minor, patch, type, revision, build } = this;
            let version = `${major}.${minor}.${patch}`;
            switch (type) {
                case exports.ReleaseType.Dev: version += `-dev.${revision}`;
                case exports.ReleaseType.Candidate: version += `-rc.${revision}`;
                case exports.ReleaseType.Release:
            }
            if (build != 0) {
                version += `+${build}`;
            }
            return version;
        }
        [eq_1.equals](that) {
            // ignore build field, because bokehjs doesn't provide it
            const { major, minor, patch, type, revision } = this;
            return major == that.major &&
                minor == that.minor &&
                patch == that.patch &&
                type == that.type &&
                revision == that.revision;
        }
    }
    exports.Version = Version;
    Version.__name__ = "Version";
    function parse_version(version) {
        const result = version_re.exec(version);
        if (result == null || result.groups == null) {
            return null;
        }
        const { groups } = result;
        const major = Number(groups.major);
        const minor = Number(groups.minor);
        const patch = Number(groups.patch);
        const type = (() => {
            switch (groups.type) {
                case "-dev.":
                case ".dev": return exports.ReleaseType.Dev;
                case "-rc.":
                case "rc": return exports.ReleaseType.Candidate;
                default: return exports.ReleaseType.Release;
            }
        })();
        // typeof due to bad stdlib typings or enable exactOptionalPropertyTypes
        const revision = typeof groups.revision == "undefined" ? 0 : Number(groups.revision);
        const build = typeof groups.build == "undefined" ? 0 : Number(groups.build);
        return new Version(major, minor, patch, type, revision, build);
    }
},
/* core/util/callbacks.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.execute = execute;
    exports.execute_sync = execute_sync;
    const types_1 = require(8) /* ./types */;
    function execute(cb, obj, ...args) {
        if ((0, types_1.isFunction)(cb)) {
            return cb(obj, ...args);
        }
        else {
            return cb.execute(obj, ...args);
        }
    }
    function execute_sync(cb, obj, ...args) {
        if ((0, types_1.isFunction)(cb)) {
            return cb(obj, ...args);
        }
        else {
            return cb.execute_sync(obj, ...args);
        }
    }
},
/* model.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const has_props_1 = require(15) /* ./core/has_props */;
    const types_1 = require(8) /* ./core/util/types */;
    const object_1 = require(9) /* ./core/util/object */;
    const eq_1 = require(27) /* ./core/util/eq */;
    const logging_1 = require(20) /* ./core/logging */;
    const callbacks_1 = require(50) /* ./core/util/callbacks */;
    class Model extends has_props_1.HasProps {
        get is_syncable() {
            return this.syncable;
        }
        [eq_1.equals](that, cmp) {
            return (cmp.structural ? true : cmp.eq(this.id, that.id)) && super[eq_1.equals](that, cmp);
        }
        constructor(attrs) {
            super(attrs);
        }
        initialize() {
            super.initialize();
            this._js_callbacks = new Map();
        }
        connect_signals() {
            super.connect_signals();
            this._update_property_callbacks();
            this.connect(this.properties.js_property_callbacks.change, () => this._update_property_callbacks());
            this.connect(this.properties.js_event_callbacks.change, () => this._update_event_callbacks());
            this.connect(this.properties.subscribed_events.change, () => this._update_event_callbacks());
        }
        /*protected*/ _process_event(event) {
            for (const callback of (0, object_1.dict)(this.js_event_callbacks).get(event.event_name) ?? []) {
                void (0, callbacks_1.execute)(callback, event);
            }
            if (this.document != null && this.subscribed_events.has(event.event_name)) {
                this.document.event_manager.send_event(event);
            }
        }
        trigger_event(event) {
            if (this.document != null) {
                event.origin = this;
                this.document.event_manager.trigger(event);
            }
        }
        _update_event_callbacks() {
            if (this.document == null) {
                logging_1.logger.warn("WARNING: Document not defined for updating event callbacks");
                return;
            }
            this.document.event_manager.subscribed_models.add(this);
        }
        _update_property_callbacks() {
            const signal_for = (event) => {
                const [evt, attr = null] = event.split(":");
                return attr != null ? this.properties[attr][evt] : this[evt];
            };
            for (const [event, callbacks] of this._js_callbacks) {
                const signal = signal_for(event);
                for (const cb of callbacks) {
                    this.disconnect(signal, cb);
                }
            }
            this._js_callbacks.clear();
            for (const [event, callbacks] of (0, object_1.dict)(this.js_property_callbacks)) {
                const wrappers = callbacks.map((cb) => () => (0, callbacks_1.execute)(cb, this));
                this._js_callbacks.set(event, wrappers);
                const signal = signal_for(event);
                for (const cb of wrappers) {
                    this.connect(signal, cb);
                }
            }
        }
        _doc_attached() {
            super._doc_attached();
            if (this.js_event_callbacks.size != 0 || this.subscribed_events.size != 0) {
                this._update_event_callbacks();
            }
        }
        _doc_detached() {
            super._doc_detached();
            this.document?.event_manager.subscribed_models.delete(this);
        }
        select(selector) {
            if ((0, types_1.isString)(selector)) {
                return [...this.references()].filter((ref) => ref instanceof _a && ref.name === selector);
            }
            else if ((0, types_1.isPlainObject)(selector) && "type" in selector) {
                return [...this.references()].filter((ref) => ref.type == selector.type);
            }
            else if (selector.prototype instanceof has_props_1.HasProps) {
                return [...this.references()].filter((ref) => ref instanceof selector);
            }
            else {
                throw new Error(`invalid selector ${selector}`);
            }
        }
        select_one(selector) {
            const result = this.select(selector);
            switch (result.length) {
                case 0:
                    return null;
                case 1:
                    return result[0];
                default:
                    throw new Error(`found multiple objects matching the given selector ${selector}`);
            }
        }
        get_one(selector) {
            const result = this.select_one(selector);
            if (result != null) {
                return result;
            }
            else {
                throw new Error(`could not find any objects matching the given selector ${selector}`);
            }
        }
        on_event(event, callback) {
            const name = (0, types_1.isString)(event) ? event : event.prototype.event_name;
            const js_event_callbacks = (0, object_1.dict)(this.js_event_callbacks);
            const callbacks = js_event_callbacks.get(name) ?? [];
            js_event_callbacks.set(name, [...callbacks, callback]);
        }
    }
    exports.Model = Model;
    _a = Model;
    Model.__name__ = "Model";
    (() => {
        _a.define(({ Any, Unknown, Bool, Str, List, Set, Dict, Nullable }) => ({
            tags: [List(Unknown), []],
            name: [Nullable(Str), null],
            js_property_callbacks: [Dict(List(Any /*TODO*/)), {}],
            js_event_callbacks: [Dict(List(Any /*TODO*/)), {}],
            subscribed_events: [Set(Str), new globalThis.Set()],
            syncable: [Bool, true],
        }));
    })();
},
/* document/defs.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.decode_def = decode_def;
    const tslib_1 = require(1) /* tslib */;
    const model_1 = require(51) /* ../model */;
    const kinds = tslib_1.__importStar(require(22) /* ../core/kinds */);
    const types_1 = require(8) /* ../core/util/types */;
    const object_1 = require(9) /* ../core/util/object */;
    function decode_def(def, deserializer) {
        var _a;
        function kind_of(ref) {
            if ((0, types_1.isString)(ref)) {
                switch (ref) {
                    case "Any": return kinds.Any;
                    case "Unknown": return kinds.Unknown;
                    case "Bool": return kinds.Bool;
                    case "Float": return kinds.Float;
                    case "Int": return kinds.Int;
                    case "Bytes": return kinds.Bytes;
                    case "Str": return kinds.Str;
                    case "Null": return kinds.Null;
                }
            }
            else {
                switch (ref[0]) {
                    case "Regex": {
                        const [, regex, flags] = ref;
                        return kinds.Regex(new RegExp(regex, flags));
                    }
                    case "Nullable": {
                        const [, sub_ref] = ref;
                        return kinds.Nullable(kind_of(sub_ref));
                    }
                    case "Or": {
                        const [, sub_ref, ...sub_refs] = ref;
                        return kinds.Or(kind_of(sub_ref), ...sub_refs.map(kind_of));
                    }
                    case "Tuple": {
                        const [, sub_ref, ...sub_refs] = ref;
                        return kinds.Tuple(kind_of(sub_ref), ...sub_refs.map(kind_of));
                    }
                    case "List": {
                        const [, sub_ref] = ref;
                        return kinds.List(kind_of(sub_ref));
                    }
                    case "Struct": {
                        const [, ...entry_refs] = ref;
                        const entries = entry_refs.map(([key, val_ref]) => [key, kind_of(val_ref)]);
                        return kinds.Struct((0, object_1.to_object)(entries));
                    }
                    case "Dict": {
                        const [, val_ref] = ref;
                        return kinds.Dict(kind_of(val_ref));
                    }
                    case "Mapping": {
                        const [, key_ref, val_ref] = ref;
                        return kinds.Mapping(kind_of(key_ref), kind_of(val_ref));
                    }
                    case "Enum": {
                        const [, ...items] = ref;
                        return kinds.Enum(...items);
                    }
                    case "Ref": {
                        const [, model_ref] = ref;
                        const model = deserializer.resolver.get(model_ref.id);
                        if (model != null) {
                            return kinds.Ref(model);
                        }
                        else {
                            throw new Error(`${model_ref.id} wasn't defined before referencing it`);
                        }
                    }
                    case "AnyRef": {
                        return kinds.AnyRef();
                    }
                }
            }
        }
        const base = (() => {
            const name = def.extends?.id ?? "Model";
            if (name == "Model") {
                // TODO: support base classes in general
                return model_1.Model;
            }
            const base = deserializer.resolver.get(name);
            if (base != null) {
                return base;
            }
            else {
                throw new Error(`base model ${name} of ${def.name} is not defined`);
            }
        })();
        const model = (_a = class extends base {
        },
            tslib_1.__setFunctionName(_a, "model"),
            _a.__qualified__ = def.name,
            _a);
        function decode(value) {
            if (value === undefined) {
                return value;
            }
            else {
                return deserializer.decode(value);
            }
        }
        for (const prop of def.properties ?? []) {
            const kind = kind_of(prop.kind);
            model.define({ [prop.name]: [kind, decode(prop.default)] });
        }
        for (const prop of def.overrides ?? []) {
            model.override({ [prop.name]: decode(prop.default) });
        }
        deserializer.resolver.register(model);
        return model;
    }
},
/* core/bokeh_events.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1, _2, _3, _4, _5;
    __esModule();
    exports.server_event = server_event;
    var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    };
    const model_1 = require(51) /* ../model */;
    const types_1 = require(8) /* ./util/types */;
    const assert_1 = require(12) /* ./util/assert */;
    const serialization_1 = require(33) /* ./serialization */;
    const deserializer_1 = require(47) /* ./serialization/deserializer */;
    const eq_1 = require(27) /* ./util/eq */;
    deserializer_1.Deserializer.register("event", (rep, deserializer) => {
        const cls = deserializable_events.get(rep.name);
        if (cls !== undefined && cls.from_values != null) {
            const values = deserializer.decode(rep.values);
            (0, assert_1.assert)((0, types_1.isPlainObject)(values));
            return cls.from_values(values);
        }
        else {
            deserializer.error(`deserialization of '${rep.name}' event is not supported`);
        }
    });
    function event(event_name) {
        return (cls) => {
            cls.prototype.event_name = event_name;
        };
    }
    const deserializable_events = new Map();
    /**
     * Marks and registers a class as a one way (server -> client) event.
     */
    function server_event(event_name) {
        return (cls) => {
            if (deserializable_events.has(event_name)) {
                throw new Error(`'${event_name}' event is already registered`);
            }
            deserializable_events.set(event_name, cls);
            cls.prototype.event_name = event_name;
            cls.prototype.publish = false;
        };
    }
    class BokehEvent {
        [serialization_1.serialize](serializer) {
            const { event_name: name, event_values } = this;
            const values = serializer.encode(event_values);
            return { type: "event", name, values };
        }
        [eq_1.equals](that, cmp) {
            return this.event_name == that.event_name && cmp.eq(this.event_values, that.event_values);
        }
    }
    exports.BokehEvent = BokehEvent;
    _a = BokehEvent;
    BokehEvent.__name__ = "BokehEvent";
    (() => {
        _a.prototype.publish = true;
    })();
    class ModelEvent extends BokehEvent {
        constructor() {
            super(...arguments);
            this.origin = null;
        }
        get event_values() {
            return { model: this.origin };
        }
    }
    exports.ModelEvent = ModelEvent;
    ModelEvent.__name__ = "ModelEvent";
    class UserEvent extends ModelEvent {
        constructor(values) {
            super();
            this.values = values;
        }
        get event_values() {
            return { ...super.event_values, ...this.values };
        }
        static from_values(values) {
            const origin = (() => {
                if ("model" in values) {
                    const { model } = values;
                    (0, assert_1.assert)(model === null || model instanceof model_1.Model);
                    delete values.model;
                    return model;
                }
                else {
                    return null;
                }
            })();
            const event = new this(values);
            event.origin = origin;
            return event;
        }
    }
    exports.UserEvent = UserEvent;
    UserEvent.__name__ = "UserEvent";
    class DocumentEvent extends BokehEvent {
    }
    exports.DocumentEvent = DocumentEvent;
    DocumentEvent.__name__ = "DocumentEvent";
    let DocumentReady = (_b = class DocumentReady extends DocumentEvent {
        get event_values() {
            return {};
        }
    },
        _b.__name__ = "DocumentReady",
        _b);
    exports.DocumentReady = DocumentReady;
    exports.DocumentReady = DocumentReady = __decorate([
        event("document_ready")
    ], DocumentReady);
    class ConnectionEvent extends DocumentEvent {
    }
    exports.ConnectionEvent = ConnectionEvent;
    ConnectionEvent.__name__ = "ConnectionEvent";
    class ConnectionLost extends ConnectionEvent {
        constructor() {
            super(...arguments);
            this.timestamp = new Date();
        }
        get event_values() {
            const { timestamp } = this;
            return { timestamp };
        }
    }
    exports.ConnectionLost = ConnectionLost;
    _c = ConnectionLost;
    ConnectionLost.__name__ = "ConnectionLost";
    (() => {
        _c.prototype.event_name = "connection_lost";
        _c.prototype.publish = false;
    })();
    let AxisClick = (_d = class AxisClick extends ModelEvent {
        constructor(model, value) {
            super();
            this.model = model;
            this.value = value;
        }
        get event_values() {
            const { value } = this;
            return { ...super.event_values, value };
        }
    },
        _d.__name__ = "AxisClick",
        _d);
    exports.AxisClick = AxisClick;
    exports.AxisClick = AxisClick = __decorate([
        event("axis_click")
    ], AxisClick);
    let ButtonClick = (_e = class ButtonClick extends ModelEvent {
    },
        _e.__name__ = "ButtonClick",
        _e);
    exports.ButtonClick = ButtonClick;
    exports.ButtonClick = ButtonClick = __decorate([
        event("button_click")
    ], ButtonClick);
    let LegendItemClick = (_f = class LegendItemClick extends ModelEvent {
        constructor(model, item) {
            super();
            this.model = model;
            this.item = item;
        }
        get event_values() {
            const { item } = this;
            return { ...super.event_values, item };
        }
    },
        _f.__name__ = "LegendItemClick",
        _f);
    exports.LegendItemClick = LegendItemClick;
    exports.LegendItemClick = LegendItemClick = __decorate([
        event("legend_item_click")
    ], LegendItemClick);
    let MenuItemClick = (_g = class MenuItemClick extends ModelEvent {
        constructor(item) {
            super();
            this.item = item;
        }
        get event_values() {
            const { item } = this;
            return { ...super.event_values, item };
        }
    },
        _g.__name__ = "MenuItemClick",
        _g);
    exports.MenuItemClick = MenuItemClick;
    exports.MenuItemClick = MenuItemClick = __decorate([
        event("menu_item_click")
    ], MenuItemClick);
    let ValueSubmit = (_h = class ValueSubmit extends ModelEvent {
        constructor(value) {
            super();
            this.value = value;
        }
        get event_values() {
            const { value } = this;
            return { ...super.event_values, value };
        }
    },
        _h.__name__ = "ValueSubmit",
        _h);
    exports.ValueSubmit = ValueSubmit;
    exports.ValueSubmit = ValueSubmit = __decorate([
        event("value_submit")
    ], ValueSubmit);
    // A UIEvent is an event originating on a canvas this includes.
    // DOM events such as keystrokes as well as hammer, LOD, and range events.
    class UIEvent extends ModelEvent {
    }
    exports.UIEvent = UIEvent;
    UIEvent.__name__ = "UIEvent";
    let LODStart = (_j = class LODStart extends UIEvent {
    },
        _j.__name__ = "LODStart",
        _j);
    exports.LODStart = LODStart;
    exports.LODStart = LODStart = __decorate([
        event("lodstart")
    ], LODStart);
    let LODEnd = (_k = class LODEnd extends UIEvent {
    },
        _k.__name__ = "LODEnd",
        _k);
    exports.LODEnd = LODEnd;
    exports.LODEnd = LODEnd = __decorate([
        event("lodend")
    ], LODEnd);
    let RangesUpdate = (_l = class RangesUpdate extends UIEvent {
        constructor(x0, x1, y0, y1) {
            super();
            this.x0 = x0;
            this.x1 = x1;
            this.y0 = y0;
            this.y1 = y1;
        }
        get event_values() {
            const { x0, x1, y0, y1 } = this;
            return { ...super.event_values, x0, x1, y0, y1 };
        }
    },
        _l.__name__ = "RangesUpdate",
        _l);
    exports.RangesUpdate = RangesUpdate;
    exports.RangesUpdate = RangesUpdate = __decorate([
        event("rangesupdate")
    ], RangesUpdate);
    let SelectionGeometry = (_m = class SelectionGeometry extends UIEvent {
        constructor(geometry, final) {
            super();
            this.geometry = geometry;
            this.final = final;
        }
        get event_values() {
            const { geometry, final } = this;
            return { ...super.event_values, geometry, final };
        }
    },
        _m.__name__ = "SelectionGeometry",
        _m);
    exports.SelectionGeometry = SelectionGeometry;
    exports.SelectionGeometry = SelectionGeometry = __decorate([
        event("selectiongeometry")
    ], SelectionGeometry);
    let Reset = (_o = class Reset extends UIEvent {
    },
        _o.__name__ = "Reset",
        _o);
    exports.Reset = Reset;
    exports.Reset = Reset = __decorate([
        event("reset")
    ], Reset);
    class PointEvent extends UIEvent {
        constructor(sx, sy, x, y, modifiers) {
            super();
            this.sx = sx;
            this.sy = sy;
            this.x = x;
            this.y = y;
            this.modifiers = modifiers;
        }
        get event_values() {
            const { sx, sy, x, y, modifiers } = this;
            return { ...super.event_values, sx, sy, x, y, modifiers };
        }
    }
    exports.PointEvent = PointEvent;
    PointEvent.__name__ = "PointEvent";
    let Pan = (_p = class Pan extends PointEvent {
        /* TODO: direction: -1 | 1 */
        constructor(sx, sy, x, y, delta_x, delta_y, modifiers) {
            super(sx, sy, x, y, modifiers);
            this.delta_x = delta_x;
            this.delta_y = delta_y;
        }
        get event_values() {
            const { delta_x, delta_y /*, direction*/ } = this;
            return { ...super.event_values, delta_x, delta_y /*, direction*/ };
        }
    },
        _p.__name__ = "Pan",
        _p);
    exports.Pan = Pan;
    exports.Pan = Pan = __decorate([
        event("pan")
    ], Pan);
    let Pinch = (_q = class Pinch extends PointEvent {
        constructor(sx, sy, x, y, scale, modifiers) {
            super(sx, sy, x, y, modifiers);
            this.scale = scale;
        }
        get event_values() {
            const { scale } = this;
            return { ...super.event_values, scale };
        }
    },
        _q.__name__ = "Pinch",
        _q);
    exports.Pinch = Pinch;
    exports.Pinch = Pinch = __decorate([
        event("pinch")
    ], Pinch);
    let Rotate = (_r = class Rotate extends PointEvent {
        constructor(sx, sy, x, y, rotation, modifiers) {
            super(sx, sy, x, y, modifiers);
            this.rotation = rotation;
        }
        get event_values() {
            const { rotation } = this;
            return { ...super.event_values, rotation };
        }
    },
        _r.__name__ = "Rotate",
        _r);
    exports.Rotate = Rotate;
    exports.Rotate = Rotate = __decorate([
        event("rotate")
    ], Rotate);
    let MouseWheel = (_s = class MouseWheel extends PointEvent {
        constructor(sx, sy, x, y, delta, modifiers) {
            super(sx, sy, x, y, modifiers);
            this.delta = delta;
        }
        get event_values() {
            const { delta } = this;
            return { ...super.event_values, delta };
        }
    },
        _s.__name__ = "MouseWheel",
        _s);
    exports.MouseWheel = MouseWheel;
    exports.MouseWheel = MouseWheel = __decorate([
        event("wheel")
    ], MouseWheel);
    let MouseMove = (_t = class MouseMove extends PointEvent {
    },
        _t.__name__ = "MouseMove",
        _t);
    exports.MouseMove = MouseMove;
    exports.MouseMove = MouseMove = __decorate([
        event("mousemove")
    ], MouseMove);
    let MouseEnter = (_u = class MouseEnter extends PointEvent {
    },
        _u.__name__ = "MouseEnter",
        _u);
    exports.MouseEnter = MouseEnter;
    exports.MouseEnter = MouseEnter = __decorate([
        event("mouseenter")
    ], MouseEnter);
    let MouseLeave = (_v = class MouseLeave extends PointEvent {
    },
        _v.__name__ = "MouseLeave",
        _v);
    exports.MouseLeave = MouseLeave;
    exports.MouseLeave = MouseLeave = __decorate([
        event("mouseleave")
    ], MouseLeave);
    let Tap = (_w = class Tap extends PointEvent {
    },
        _w.__name__ = "Tap",
        _w);
    exports.Tap = Tap;
    exports.Tap = Tap = __decorate([
        event("tap")
    ], Tap);
    let DoubleTap = (_x = class DoubleTap extends PointEvent {
    },
        _x.__name__ = "DoubleTap",
        _x);
    exports.DoubleTap = DoubleTap;
    exports.DoubleTap = DoubleTap = __decorate([
        event("doubletap")
    ], DoubleTap);
    let Press = (_y = class Press extends PointEvent {
    },
        _y.__name__ = "Press",
        _y);
    exports.Press = Press;
    exports.Press = Press = __decorate([
        event("press")
    ], Press);
    let PressUp = (_z = class PressUp extends PointEvent {
    },
        _z.__name__ = "PressUp",
        _z);
    exports.PressUp = PressUp;
    exports.PressUp = PressUp = __decorate([
        event("pressup")
    ], PressUp);
    let PanStart = (_0 = class PanStart extends PointEvent {
    },
        _0.__name__ = "PanStart",
        _0);
    exports.PanStart = PanStart;
    exports.PanStart = PanStart = __decorate([
        event("panstart")
    ], PanStart);
    let PanEnd = (_1 = class PanEnd extends PointEvent {
    },
        _1.__name__ = "PanEnd",
        _1);
    exports.PanEnd = PanEnd;
    exports.PanEnd = PanEnd = __decorate([
        event("panend")
    ], PanEnd);
    let PinchStart = (_2 = class PinchStart extends PointEvent {
    },
        _2.__name__ = "PinchStart",
        _2);
    exports.PinchStart = PinchStart;
    exports.PinchStart = PinchStart = __decorate([
        event("pinchstart")
    ], PinchStart);
    let PinchEnd = (_3 = class PinchEnd extends PointEvent {
    },
        _3.__name__ = "PinchEnd",
        _3);
    exports.PinchEnd = PinchEnd;
    exports.PinchEnd = PinchEnd = __decorate([
        event("pinchend")
    ], PinchEnd);
    let RotateStart = (_4 = class RotateStart extends PointEvent {
    },
        _4.__name__ = "RotateStart",
        _4);
    exports.RotateStart = RotateStart;
    exports.RotateStart = RotateStart = __decorate([
        event("rotatestart")
    ], RotateStart);
    let RotateEnd = (_5 = class RotateEnd extends PointEvent {
    },
        _5.__name__ = "RotateEnd",
        _5);
    exports.RotateEnd = RotateEnd;
    exports.RotateEnd = RotateEnd = __decorate([
        event("rotateend")
    ], RotateEnd);
},
/* embed/standalone.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.add_document_standalone = add_document_standalone;
    const document_1 = require(5) /* ../document */;
    const view_manager_1 = require(55) /* ../core/view_manager */;
    const dom_view_1 = require(57) /* ../core/dom_view */;
    const types_1 = require(8) /* ../core/util/types */;
    const assert_1 = require(12) /* ../core/util/assert */;
    // A map from the root model IDs to their views.
    exports.index = new Proxy(new view_manager_1.ViewManager(), {
        get(manager, property) {
            if ((0, types_1.isString)(property)) {
                const view = manager.get_by_id(property);
                if (view != null) {
                    return view;
                }
            }
            return Reflect.get(manager, property);
        },
        has(manager, property) {
            if ((0, types_1.isString)(property)) {
                const view = manager.get_by_id(property);
                if (view != null) {
                    return true;
                }
            }
            return Reflect.has(manager, property);
        },
        ownKeys(manager) {
            return manager.roots.map((root) => root.model.id);
        },
        getOwnPropertyDescriptor(manager, property) {
            if ((0, types_1.isString)(property)) {
                const view = manager.get_by_id(property);
                if (view != null) {
                    return { configurable: true, enumerable: true, writable: false, value: view };
                }
            }
            return Reflect.getOwnPropertyDescriptor(manager, property);
        },
    });
    async function add_document_standalone(document, element, roots = [], use_for_title = false) {
        // this is a LOCAL index of views used only by this particular rendering
        // call, so we can remove the views we create.
        (0, assert_1.assert)(document.views_manager == null);
        const views = new view_manager_1.ViewManager([], exports.index);
        document.views_manager = views;
        async function render_view(model) {
            const view = await views.build_view(model);
            if (view instanceof dom_view_1.DOMView) {
                const i = document.roots().indexOf(model);
                const root_el = roots[i] ?? element;
                view.build(root_el);
            }
            exports.index.add(view);
        }
        async function render_model(model) {
            if (model.default_view != null) {
                await render_view(model);
            }
            else {
                document.notify_idle(model);
            }
        }
        function unrender_model(model) {
            const view = views.get(model);
            view?.remove();
        }
        for (const model of document.roots()) {
            await render_model(model);
        }
        if (use_for_title) {
            window.document.title = document.title();
        }
        document.on_change((event) => {
            if (event instanceof document_1.RootAddedEvent) {
                void render_model(event.model);
            }
            else if (event instanceof document_1.RootRemovedEvent) {
                unrender_model(event.model);
            }
            else if (use_for_title && event instanceof document_1.TitleChangedEvent) {
                window.document.title = event.title;
            }
        });
        return views;
    }
},
/* core/view_manager.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const build_views_1 = require(56) /* ./build_views */;
    class AbstractViewQuery {
        *all_views() {
            yield* this.query(() => true);
        }
        *query(fn) {
            const visited = new Set();
            function* descend(view) {
                if (visited.has(view)) {
                    return;
                }
                visited.add(view);
                if (fn(view)) {
                    yield view;
                }
                for (const child of view.children()) {
                    yield* descend(child);
                }
            }
            for (const view of this) {
                yield* descend(view);
            }
        }
        query_one(fn) {
            for (const view of this.query(fn)) {
                return view;
            }
            return null;
        }
        *find(model) {
            yield* this.query((view) => view.model == model);
        }
        *find_by_id(id) {
            yield* this.query((view) => view.model.id == id);
        }
        find_one(model) {
            for (const view of this.find(model)) {
                return view;
            }
            return null;
        }
        find_one_by_id(id) {
            for (const view of this.find_by_id(id)) {
                return view;
            }
            return null;
        }
        get_one(model) {
            const view = this.find_one(model);
            if (view != null) {
                return view;
            }
            else {
                throw new Error(`cannot find a view for ${model}`);
            }
        }
        get_one_by_id(id) {
            const view = this.find_one_by_id(id);
            if (view != null) {
                return view;
            }
            else {
                throw new Error(`cannot find a view for a model with '${id}' identity`);
            }
        }
        find_all(model) {
            return [...this.find(model)];
        }
        find_all_by_id(id) {
            return [...this.find_by_id(id)];
        }
        select(models) {
            return models.map((model) => this.find_one(model)).filter((view) => view != null);
        }
    }
    AbstractViewQuery.__name__ = "AbstractViewQuery";
    class ViewQuery extends AbstractViewQuery {
        constructor(view) {
            super();
            this.view = view;
        }
        *[Symbol.iterator]() {
            yield this.view;
        }
        toString() {
            return `ViewQuery(${this.view})`;
        }
    }
    exports.ViewQuery = ViewQuery;
    ViewQuery.__name__ = "ViewQuery";
    class ViewManager extends AbstractViewQuery {
        constructor(roots = [], global) {
            super();
            this.global = global;
            this._roots = new Set(roots);
        }
        toString() {
            const views = [...this._roots].map((view) => `${view}`).join(", ");
            return `ViewManager(${views})`;
        }
        async build_view(model, parent = null) {
            const view = await (0, build_views_1.build_view)(model, { owner: this, parent });
            if (parent == null) {
                this.add(view);
            }
            return view;
        }
        get(model) {
            for (const view of this._roots) {
                if (view.model == model) {
                    return view;
                }
            }
            return null;
        }
        get_by_id(id) {
            for (const view of this._roots) {
                if (view.model.id == id) {
                    return view;
                }
            }
            return null;
        }
        add(view) {
            this._roots.add(view);
            this.global?.add(view);
        }
        delete(view) {
            this._roots.delete(view);
            this.global?.delete(view);
        }
        remove(view) {
            this.delete(view);
        }
        clear() {
            for (const view of this) {
                view.remove();
            }
        }
        /* TODO (TS 5.2)
        [Symbol.dispose](): void {
          this.clear()
        }
        */
        get roots() {
            return [...this._roots];
        }
        *[Symbol.iterator]() {
            yield* this._roots;
        }
    }
    exports.ViewManager = ViewManager;
    ViewManager.__name__ = "ViewManager";
},
/* core/build_views.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.build_view = build_view;
    exports.build_views = build_views;
    exports.remove_views = remove_views;
    exports.traverse_views = traverse_views;
    const array_1 = require(10) /* ./util/array */;
    const assert_1 = require(12) /* ./util/assert */;
    async function _build_view(view_cls, model, options) {
        (0, assert_1.assert)(view_cls != null, "model doesn't implement a view");
        const view = new view_cls({ ...options, model });
        view.initialize();
        await view.lazy_initialize();
        return view;
    }
    async function build_view(model, options = { parent: null }, cls = (model) => model.default_view) {
        const view = await _build_view(cls(model), model, options);
        view.connect_signals();
        return view;
    }
    async function build_views(view_storage, models, options = { parent: null }, cls = (model) => model.default_view) {
        const to_remove = (0, array_1.difference)([...view_storage.keys()], models);
        const removed_views = [];
        for (const model of to_remove) {
            const view = view_storage.get(model);
            if (view != null) {
                view_storage.delete(model);
                removed_views.push(view);
                view.remove();
            }
        }
        const created_views = [];
        const new_models = models.filter((model) => !view_storage.has(model));
        for (const model of new_models) {
            const view = await _build_view(cls(model), model, options);
            view_storage.set(model, view);
            created_views.push(view);
        }
        for (const view of created_views) {
            view.connect_signals();
        }
        return {
            created: created_views,
            removed: removed_views,
        };
    }
    function remove_views(view_storage) {
        for (const [model, view] of view_storage) {
            view.remove();
            view_storage.delete(model);
        }
    }
    function traverse_views(views, fn) {
        const visited = new Set();
        const queue = [...views];
        while (true) {
            const view = queue.shift();
            if (view === undefined) {
                break;
            }
            if (visited.has(view)) {
                continue;
            }
            visited.add(view);
            queue.push(...view.children());
            fn(view);
        }
    }
},
/* core/dom_view.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const view_1 = require(58) /* ./view */;
    const dom_1 = require(63) /* ./dom */;
    const types_1 = require(8) /* ./util/types */;
    const assert_1 = require(12) /* ./util/assert */;
    const base_css_1 = tslib_1.__importDefault(require(66) /* ../styles/base.css */);
    class DOMView extends view_1.View {
        constructor() {
            super(...arguments);
            this._was_built = false;
        }
        get bbox() {
            return undefined;
        }
        serializable_state() {
            const state = super.serializable_state();
            const { bbox } = this;
            return bbox != null ? { ...state, bbox: bbox.round() } : state;
        }
        get children_el() {
            return this.shadow_el ?? this.el;
        }
        initialize() {
            super.initialize();
            this.el = this._create_element();
        }
        remove() {
            this.el.remove();
            super.remove();
        }
        stylesheets() {
            return [];
        }
        css_classes() {
            return [];
        }
        rerender() {
            this.render();
            this.r_after_render();
        }
        render_to(target) {
            this.render();
            target.appendChild(this.el);
        }
        after_render() {
            this.reposition();
        }
        r_after_render() {
            for (const child_view of this.children()) {
                if (child_view instanceof DOMView) {
                    child_view.r_after_render();
                }
            }
            this.after_render();
            this._was_built = true;
        }
        _create_element() {
            return (0, dom_1.create_element)(this.constructor.tag_name, {});
        }
        reposition(_displayed) { }
        /**
         * Build a top-level DOM view (e.g. during embedding).
         */
        build(target) {
            (0, assert_1.assert)(this.is_root);
            this.render_to(target);
            this.r_after_render();
            this.notify_finished();
        }
        /**
         * Define where to render this element or let the parent decide.
         *
         * This is useful when creating "floating" components or adding
         * components to canvas' layers.
         */
        rendering_target() {
            return null;
        }
    }
    exports.DOMView = DOMView;
    DOMView.__name__ = "DOMView";
    DOMView.tag_name = "div";
    class DOMElementView extends DOMView {
        initialize() {
            super.initialize();
            this.class_list = new dom_1.ClassList(this.el.classList);
        }
        get self_target() {
            return this.el;
        }
    }
    exports.DOMElementView = DOMElementView;
    DOMElementView.__name__ = "DOMElementView";
    class DOMComponentView extends DOMElementView {
        constructor() {
            super(...arguments);
            this._base_style = new dom_1.InlineStyleSheet(base_css_1.default, "base");
            this._css_vars = new dom_1.InlineStyleSheet("", "vars");
            this._applied_html_attributes = [];
            this._applied_stylesheets = [];
            this._applied_css_classes = [];
        }
        get self_target() {
            return this.shadow_el;
        }
        initialize() {
            super.initialize();
            this.shadow_el = this.el.attachShadow({ mode: "open" });
        }
        stylesheets() {
            return [...super.stylesheets(), this._base_style];
        }
        /**
         * Baseline stylesheets, e.g. imported CSS modules.
         */
        static_stylesheets() {
            return this.stylesheets();
        }
        /**
         * Stylesheets computed by the component.
         */
        computed_stylesheets() {
            return [this._css_vars];
        }
        /**
         * Other stylesheets, e.g. provided by user.
         */
        user_stylesheets() {
            return [];
        }
        empty() {
            (0, dom_1.empty)(this.shadow_el);
            this.class_list.clear();
            this._applied_css_classes = [];
            this._applied_stylesheets = [];
            for (const stylesheet of this.computed_stylesheets()) {
                if (!stylesheet.persistent) {
                    stylesheet.clear();
                }
            }
        }
        render() {
            this.empty();
            this._update_stylesheets();
            this._apply_html_attributes();
        }
        _apply_html_attributes() {
            this._update_css_classes();
        }
        reposition(_displayed) {
            this._update_css_variables(); // TODO remove this when node invalidation is implemented
        }
        *_stylesheets() {
            yield* this.static_stylesheets();
            yield* this.computed_stylesheets();
            yield* this.user_stylesheets();
        }
        *_css_classes() {
            yield `bk-${this.model.type.replace(/\./g, "-")}`;
            yield* this.css_classes();
        }
        *_css_variables() { }
        _apply_stylesheets(stylesheets) {
            const resolved_stylesheets = stylesheets.map((style) => (0, types_1.isString)(style) ? new dom_1.InlineStyleSheet(style) : style);
            this._applied_stylesheets.push(...resolved_stylesheets);
            resolved_stylesheets.forEach((stylesheet) => stylesheet.install(this.shadow_el));
        }
        _apply_css_classes(classes) {
            this._applied_css_classes.push(...classes);
            this.class_list.add(...classes);
        }
        _update_stylesheets() {
            this._applied_stylesheets.forEach((stylesheet) => stylesheet.uninstall());
            this._applied_stylesheets = [];
            this._apply_stylesheets([...this._stylesheets()]);
        }
        _update_css_classes() {
            this.class_list.remove(this._applied_css_classes);
            this._applied_css_classes = [];
            this._apply_css_classes([...this._css_classes()]);
        }
        _update_css_variables() {
            const vars = [];
            for (const [name, value] of this._css_variables()) {
                const full_name = name.startsWith("--") ? name : `--${name}`;
                vars.push(`${full_name}: ${value};\n`);
            }
            if (vars.length == 0) {
                this._css_vars.clear();
            }
            else {
                this._css_vars.replace(`:host {\n${vars}}`);
            }
        }
    }
    exports.DOMComponentView = DOMComponentView;
    DOMComponentView.__name__ = "DOMComponentView";
},
/* core/view.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const has_props_1 = require(15) /* ./has_props */;
    const signaling_1 = require(16) /* ./signaling */;
    const types_1 = require(8) /* ./util/types */;
    const node_1 = require(59) /* ../models/coordinates/node */;
    const xy_1 = require(61) /* ../models/coordinates/xy */;
    const indexed_1 = require(62) /* ../models/coordinates/indexed */;
    const view_manager_1 = require(55) /* ./view_manager */;
    const eq_1 = require(27) /* ./util/eq */;
    class View {
        get ready() {
            return this._ready;
        }
        _await_ready(promise) {
            this._ready = this._ready.then(() => promise);
            if (this.root != this) {
                this.root._ready = this.root._ready.then(() => this._ready);
            }
        }
        connect(signal, slot) {
            let new_slot = this._slots.get(slot);
            if (new_slot == null) {
                new_slot = (args, sender) => {
                    this._await_ready(Promise.resolve(slot.call(this, args, sender)));
                };
                this._slots.set(slot, new_slot);
            }
            return signal.connect(new_slot, this);
        }
        disconnect(signal, slot) {
            return signal.disconnect(slot, this);
        }
        constructor(options) {
            this.removed = new signaling_1.Signal0(this, "removed");
            this.views = new view_manager_1.ViewQuery(this);
            this._ready = Promise.resolve(undefined);
            /** @internal */
            this._slots = new WeakMap();
            this._destroyed = false;
            this._has_finished = false;
            this._idle_notified = false;
            const { model, parent, owner } = options;
            this.model = model;
            this.parent = parent;
            if (parent == null) {
                this.root = this;
                this.owner = owner ?? new view_manager_1.ViewManager([this]);
            }
            else {
                this.root = parent.root;
                this.owner = this.root.owner;
            }
        }
        initialize() { }
        async lazy_initialize() { }
        remove() {
            this.disconnect_signals();
            this.owner.remove(this);
            this.removed.emit();
            this._destroyed = true;
        }
        get is_destroyed() {
            return this._destroyed;
        }
        toString() {
            return `${this.model.type}View(${this.model.id})`;
        }
        [eq_1.equals](that, _cmp) {
            return Object.is(this, that);
        }
        *children() { }
        mark_finished() {
            this._has_finished = true;
        }
        /**
         * Mark as finished even if e.g. external resources were not loaded yet.
         */
        force_finished() {
            this.mark_finished();
        }
        finish() {
            this.mark_finished();
            this.notify_finished();
        }
        notify_finished() {
            if (!this.is_root) {
                this.root.notify_finished();
            }
            else {
                if (!this._idle_notified && this.has_finished()) {
                    const { document } = this.model;
                    if (document != null) {
                        this._idle_notified = true;
                        document.notify_idle(this.model);
                    }
                }
            }
        }
        serializable_children() {
            return [...this.children()].filter((view) => view.model.is_syncable);
        }
        serializable_state() {
            const children = this.serializable_children()
                .map((view) => view.serializable_state())
                .filter((item) => item.bbox != null && item.bbox.is_valid && !item.bbox.is_empty); // TODO move this to a common base class for UI views
            return {
                type: this.model.type,
                children,
            };
        }
        get is_root() {
            return this.parent == null;
        }
        has_finished() {
            return this._has_finished;
        }
        get is_idle() {
            return this.has_finished();
        }
        connect_signals() { }
        disconnect_signals() {
            signaling_1.Signal.disconnect_receiver(this);
        }
        on_change(properties, fn) {
            for (const property of (0, types_1.isArray)(properties) ? properties : [properties]) {
                this.connect(property.change, fn);
            }
        }
        on_transitive_change(property, fn, { recursive = false, signal = (obj) => obj.change } = {}) {
            const collect = () => {
                const value = property.is_unset ? [] : property.get_value();
                return has_props_1.HasProps.references(value, { recursive });
            };
            const connect = (models) => {
                for (const model of models) {
                    this.connect(signal(model), () => fn());
                }
            };
            const disconnect = (models) => {
                for (const model of models) {
                    this.disconnect(signal(model), () => fn());
                }
            };
            let models = collect();
            connect(models);
            this.on_change(property, () => {
                disconnect(models);
                models = collect();
                connect(models);
                fn();
            });
        }
        cursor(_sx, _sy) {
            return null;
        }
        resolve_frame() {
            return null;
        }
        resolve_canvas() {
            return null;
        }
        resolve_plot() {
            return null;
        }
        resolve_target(target) {
            if ((0, types_1.isString)(target)) {
                const ascend = (fn) => {
                    let obj = this;
                    while (obj != null) {
                        const view = fn(obj);
                        if (view != null) {
                            return view;
                        }
                        else {
                            obj = obj.parent;
                        }
                    }
                    return null;
                };
                switch (target) {
                    case "parent": return this.parent;
                    case "frame": return ascend((view) => view.resolve_frame());
                    case "canvas": return ascend((view) => view.resolve_canvas());
                    case "plot": return ascend((view) => view.resolve_plot());
                }
            }
            else {
                const queue = [this.root];
                while (true) {
                    const child = queue.shift();
                    if (child == null) {
                        break;
                    }
                    else if (child.model == target) {
                        return child;
                    }
                    else {
                        queue.push(...child.children());
                    }
                }
                return null;
            }
        }
        resolve_symbol(_node) {
            return { x: NaN, y: NaN };
        }
        resolve_node(node) {
            const target = this.resolve_target(node.target);
            if (target != null) {
                return target.resolve_symbol(node);
            }
            else {
                return { x: NaN, y: NaN };
            }
        }
        resolve_coordinate(coord) {
            if (coord instanceof xy_1.XY) {
                let obj = this;
                while (obj != null && obj.resolve_xy == null) {
                    obj = obj.parent;
                }
                return obj?.resolve_xy?.(coord) ?? { x: NaN, y: NaN };
            }
            else if (coord instanceof indexed_1.Indexed) {
                let obj = this;
                while (obj != null && obj.resolve_indexed == null) {
                    obj = obj.parent;
                }
                return obj?.resolve_indexed?.(coord) ?? { x: NaN, y: NaN };
            }
            else if (coord instanceof node_1.Node) {
                return this.resolve_node(coord);
            }
            else {
                return { x: NaN, y: NaN };
            }
        }
        resolve_as_xy(coord) {
            const value = this.resolve_coordinate(coord);
            return (0, types_1.isNumber)(value) ? { x: NaN, y: NaN } : value;
        }
        resolve_as_scalar(coord, dim) {
            const value = this.resolve_coordinate(coord);
            return (0, types_1.isNumber)(value) ? value : value[dim];
        }
    }
    exports.View = View;
    View.__name__ = "View";
},
/* models/coordinates/node.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const coordinate_1 = require(60) /* ./coordinate */;
    const model_1 = require(51) /* ../../model */;
    const kinds_1 = require(22) /* ../../core/kinds */;
    exports.ImplicitTarget = (0, kinds_1.Enum)("canvas", "plot", "frame", "parent");
    exports.NodeTarget = (0, kinds_1.Or)((0, kinds_1.Ref)(model_1.Model), exports.ImplicitTarget);
    class BoxNodes {
        constructor(target, frozen = false) {
            this._left = null;
            this._right = null;
            this._top = null;
            this._bottom = null;
            this.target = target;
            this.frozen = frozen;
        }
        _node(symbol) {
            const { target, frozen } = this;
            const node = new Node({ target, symbol });
            if (frozen) {
                this[`_${symbol}`] = node;
            }
            return node;
        }
        get left() {
            return this._left ?? this._node("left");
        }
        get right() {
            return this._right ?? this._node("right");
        }
        get top() {
            return this._top ?? this._node("top");
        }
        get bottom() {
            return this._bottom ?? this._node("bottom");
        }
        freeze() {
            return new BoxNodes(this.target, true);
        }
    }
    exports.BoxNodes = BoxNodes;
    BoxNodes.__name__ = "BoxNodes";
    class Node extends coordinate_1.Coordinate {
        constructor(attrs) {
            super(attrs);
        }
        static get frame() {
            return this._frame_nodes;
        }
        static get canvas() {
            return this._canvas_nodes;
        }
    }
    exports.Node = Node;
    _a = Node;
    Node.__name__ = "Node";
    (() => {
        _a.define(({ Str, Int }) => ({
            target: [exports.NodeTarget],
            symbol: [Str],
            offset: [Int, 0],
        }));
    })();
    Node._frame_nodes = new BoxNodes("frame");
    Node._canvas_nodes = new BoxNodes("canvas");
},
/* models/coordinates/coordinate.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const model_1 = require(51) /* ../../model */;
    class Coordinate extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Coordinate = Coordinate;
    Coordinate.__name__ = "Coordinate";
},
/* models/coordinates/xy.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const coordinate_1 = require(60) /* ./coordinate */;
    class XY extends coordinate_1.Coordinate {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.XY = XY;
    _a = XY;
    XY.__name__ = "XY";
    (() => {
        _a.define(({ Float }) => ({
            x: [Float],
            y: [Float],
        }));
    })();
},
/* models/coordinates/indexed.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const coordinate_1 = require(60) /* ./coordinate */;
    class Indexed extends coordinate_1.Coordinate {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Indexed = Indexed;
    _a = Indexed;
    Indexed.__name__ = "Indexed";
    (() => {
        _a.define(({ Int, AnyRef }) => ({
            index: [Int],
            renderer: [AnyRef()],
        }));
    })();
},
/* core/dom.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.textarea = exports.template = exports.td = exports.tbody = exports.table = exports.sup = exports.summary = exports.sub = exports.style = exports.strong = exports.span = exports.source = exports.small = exports.slot = exports.select = exports.section = exports.search = exports.script = exports.samp = exports.s = exports.ruby = exports.rt = exports.rp = exports.q = exports.progress = exports.pre = exports.picture = exports.p = exports.output = exports.option = exports.optgroup = exports.ol = exports.object = exports.noscript = exports.nav = exports.meter = exports.meta = exports.menu = exports.mark = exports.map = exports.main = exports.link = exports.li = exports.legend = exports.label = exports.kbd = exports.ins = exports.input = exports.img = exports.iframe = void 0;
    exports.supports_adopted_stylesheets = exports.GlobalImportedStyleSheet = exports.ImportedStyleSheet = exports.GlobalInlineStyleSheet = exports.InlineStyleSheet = exports.StyleSheet = exports.MouseButton = exports.ClassList = exports.wbr = exports.video = exports.ul = exports.u = exports.track = exports.tr = exports.title = exports.time = exports.thead = exports.th = exports.tfoot = void 0;
    exports.create_element = create_element;
    exports.createSVGElement = createSVGElement;
    exports.text = text;
    exports.nbsp = nbsp;
    exports.prepend = prepend;
    exports.empty = empty;
    exports.contains = contains;
    exports.display = display;
    exports.undisplay = undisplay;
    exports.show = show;
    exports.hide = hide;
    exports.offset_bbox = offset_bbox;
    exports.parent = parent;
    exports.extents = extents;
    exports.size = size;
    exports.scroll_size = scroll_size;
    exports.outer_size = outer_size;
    exports.content_size = content_size;
    exports.bounding_box = bounding_box;
    exports.box_size = box_size;
    exports.position = position;
    exports.classes = classes;
    exports.toggle_attribute = toggle_attribute;
    exports.dom_ready = dom_ready;
    exports.px = px;
    exports.has_focus = has_focus;
    const types_1 = require(8) /* ./util/types */;
    const object_1 = require(9) /* ./util/object */;
    const bbox_1 = require(64) /* ./util/bbox */;
    const css_1 = require(65) /* ./css */;
    const logging_1 = require(20) /* ./logging */;
    const _element = (tag) => {
        return (attrs = {}, ...children) => {
            const element = document.createElement(tag);
            if (!(0, types_1.isPlainObject)(attrs)) {
                children = [attrs, ...children];
                attrs = {};
            }
            else {
                attrs = { ...attrs };
            }
            if (attrs.class != null) {
                const classes = (() => {
                    if ((0, types_1.isString)(attrs.class)) {
                        return attrs.class.split(/\s+/);
                    }
                    else {
                        return attrs.class;
                    }
                })();
                for (const cls of classes) {
                    if (cls != null) {
                        element.classList.add(cls);
                    }
                }
                delete attrs.class;
            }
            if (attrs.style != null) {
                if ((0, types_1.isString)(attrs.style)) {
                    element.setAttribute("style", attrs.style);
                }
                else {
                    (0, css_1.apply_styles)(element.style, attrs.style);
                }
                delete attrs.style;
            }
            if (attrs.data != null) {
                for (const [key, data] of (0, object_1.entries)(attrs.data)) {
                    if (data != null) {
                        element.dataset[key] = data;
                    }
                }
                delete attrs.data;
            }
            for (const [attr, value] of (0, object_1.entries)(attrs)) {
                if (value == null) {
                    continue;
                }
                else if ((0, types_1.isBoolean)(value)) {
                    element.toggleAttribute(attr, value);
                }
                else if ((0, types_1.isNumber)(value)) {
                    element.setAttribute(attr, `${value}`);
                }
                else if ((0, types_1.isString)(value)) {
                    element.setAttribute(attr, value);
                }
                else {
                    logging_1.logger.warn(`unable to set attribute: ${attr} = ${value}`);
                }
            }
            function append(child) {
                if ((0, types_1.isString)(child)) {
                    element.append(document.createTextNode(child));
                }
                else if (child instanceof Node) {
                    element.append(child);
                }
                else if (child instanceof NodeList || child instanceof HTMLCollection) {
                    element.append(...child);
                }
                else if (child != null && child !== false) {
                    throw new Error(`expected a DOM element, string, false or null, got ${JSON.stringify(child)}`);
                }
            }
            for (const child of children) {
                if ((0, types_1.isArray)(child)) {
                    for (const _child of child) {
                        append(_child);
                    }
                }
                else {
                    append(child);
                }
            }
            return element;
        };
    };
    function create_element(tag, attrs, ...children) {
        return _element(tag)(attrs, ...children);
    }
    exports.a = _element("a");
    exports.abbr = _element("abbr");
    exports.address = _element("address");
    exports.area = _element("area");
    exports.article = _element("article");
    exports.aside = _element("aside");
    exports.audio = _element("audio");
    exports.b = _element("b");
    exports.base = _element("base");
    exports.bdi = _element("bdi");
    exports.bdo = _element("bdo");
    exports.blockquote = _element("blockquote");
    exports.body = _element("body");
    exports.br = _element("br");
    exports.button = _element("button");
    exports.canvas = _element("canvas");
    exports.caption = _element("caption");
    exports.cite = _element("cite");
    exports.code = _element("code");
    exports.col = _element("col");
    exports.colgroup = _element("colgroup");
    exports.data = _element("data");
    exports.datalist = _element("datalist");
    exports.dd = _element("dd");
    exports.del = _element("del");
    exports.details = _element("details");
    exports.dfn = _element("dfn");
    exports.dialog = _element("dialog");
    exports.div = _element("div");
    exports.dl = _element("dl");
    exports.dt = _element("dt");
    exports.em = _element("em");
    exports.embed = _element("embed");
    exports.fieldset = _element("fieldset");
    exports.figcaption = _element("figcaption");
    exports.figure = _element("figure");
    exports.footer = _element("footer");
    exports.form = _element("form");
    exports.h1 = _element("h1");
    exports.h2 = _element("h2");
    exports.h3 = _element("h3");
    exports.h4 = _element("h4");
    exports.h5 = _element("h5");
    exports.h6 = _element("h6");
    exports.head = _element("head");
    exports.header = _element("header");
    exports.hgroup = _element("hgroup");
    exports.hr = _element("hr");
    exports.html = _element("html");
    exports.i = _element("i");
    exports.iframe = _element("iframe");
    exports.img = _element("img");
    exports.input = _element("input");
    exports.ins = _element("ins");
    exports.kbd = _element("kbd");
    exports.label = _element("label");
    exports.legend = _element("legend");
    exports.li = _element("li");
    exports.link = _element("link");
    exports.main = _element("main");
    exports.map = _element("map");
    exports.mark = _element("mark");
    exports.menu = _element("menu");
    exports.meta = _element("meta");
    exports.meter = _element("meter");
    exports.nav = _element("nav");
    exports.noscript = _element("noscript");
    exports.object = _element("object");
    exports.ol = _element("ol");
    exports.optgroup = _element("optgroup");
    exports.option = _element("option");
    exports.output = _element("output");
    exports.p = _element("p");
    exports.picture = _element("picture");
    exports.pre = _element("pre");
    exports.progress = _element("progress");
    exports.q = _element("q");
    exports.rp = _element("rp");
    exports.rt = _element("rt");
    exports.ruby = _element("ruby");
    exports.s = _element("s");
    exports.samp = _element("samp");
    exports.script = _element("script");
    exports.search = _element("search");
    exports.section = _element("section");
    exports.select = _element("select");
    exports.slot = _element("slot");
    exports.small = _element("small");
    exports.source = _element("source");
    exports.span = _element("span");
    exports.strong = _element("strong");
    exports.style = _element("style");
    exports.sub = _element("sub");
    exports.summary = _element("summary");
    exports.sup = _element("sup");
    exports.table = _element("table");
    exports.tbody = _element("tbody");
    exports.td = _element("td");
    exports.template = _element("template");
    exports.textarea = _element("textarea");
    exports.tfoot = _element("tfoot");
    exports.th = _element("th");
    exports.thead = _element("thead");
    exports.time = _element("time");
    exports.title = _element("title");
    exports.tr = _element("tr");
    exports.track = _element("track");
    exports.u = _element("u");
    exports.ul = _element("ul");
    exports.video = _element("video");
    exports.wbr = _element("wbr");
    function createSVGElement(tag, attrs = null, ...children) {
        const element = document.createElementNS("http://www.w3.org/2000/svg", tag);
        for (const [attr, value] of (0, object_1.entries)(attrs ?? {})) {
            if (value == null || value === false) {
                continue;
            }
            element.setAttribute(attr, value);
        }
        function append(child) {
            if ((0, types_1.isString)(child)) {
                element.appendChild(document.createTextNode(child));
            }
            else if (child instanceof Node) {
                element.appendChild(child);
            }
            else if (child instanceof NodeList || child instanceof HTMLCollection) {
                for (const el of child) {
                    element.appendChild(el);
                }
            }
            else if (child != null && child !== false) {
                throw new Error(`expected a DOM element, string, false or null, got ${JSON.stringify(child)}`);
            }
        }
        for (const child of children) {
            if ((0, types_1.isArray)(child)) {
                for (const _child of child) {
                    append(_child);
                }
            }
            else {
                append(child);
            }
        }
        return element;
    }
    function text(str) {
        return document.createTextNode(str);
    }
    function nbsp() {
        return text("\u00a0");
    }
    function prepend(element, ...nodes) {
        const first = element.firstChild;
        for (const node of nodes) {
            element.insertBefore(node, first);
        }
    }
    function empty(node, attrs = false) {
        let child;
        while ((child = node.firstChild) != null) {
            node.removeChild(child);
        }
        if (attrs && node instanceof Element) {
            for (const attr of node.attributes) {
                node.removeAttributeNode(attr);
            }
        }
    }
    function contains(element, child) {
        /**
         * Like Node.contains(), but traverses Shadow DOM boundaries.
         */
        let current = child;
        while (current.parentNode != null) {
            const parent = current.parentNode;
            if (parent == element) {
                return true;
            }
            else if (parent instanceof ShadowRoot) {
                current = parent.host;
            }
            else {
                current = parent;
            }
        }
        return false;
    }
    function display(element, display = true) {
        element.style.display = display ? "" : "none";
    }
    function undisplay(element) {
        element.style.display = "none";
    }
    function show(element) {
        element.style.visibility = "";
    }
    function hide(element) {
        element.style.visibility = "hidden";
    }
    function offset_bbox(element) {
        const { top, left, width, height } = element.getBoundingClientRect();
        return new bbox_1.BBox({
            left: left + scrollX - document.documentElement.clientLeft,
            top: top + scrollY - document.documentElement.clientTop,
            width,
            height,
        });
    }
    function parent(el, selector) {
        let node = el;
        while ((node = node.parentElement) != null) {
            if (node.matches(selector)) {
                return node;
            }
        }
        return null;
    }
    function num(value) {
        const num = parseFloat(value);
        return isFinite(num) ? num : 0;
    }
    function extents(el) {
        const style = getComputedStyle(el);
        return {
            border: {
                top: num(style.borderTopWidth),
                bottom: num(style.borderBottomWidth),
                left: num(style.borderLeftWidth),
                right: num(style.borderRightWidth),
            },
            margin: {
                top: num(style.marginTop),
                bottom: num(style.marginBottom),
                left: num(style.marginLeft),
                right: num(style.marginRight),
            },
            padding: {
                top: num(style.paddingTop),
                bottom: num(style.paddingBottom),
                left: num(style.paddingLeft),
                right: num(style.paddingRight),
            },
        };
    }
    function size(el) {
        const rect = el.getBoundingClientRect();
        return {
            width: Math.ceil(rect.width),
            height: Math.ceil(rect.height),
        };
    }
    function scroll_size(el) {
        return {
            width: Math.ceil(el.scrollWidth),
            height: Math.ceil(el.scrollHeight),
        };
    }
    function outer_size(el) {
        const { margin: { left, right, top, bottom } } = extents(el);
        const { width, height } = size(el);
        return {
            width: Math.ceil(width + left + right),
            height: Math.ceil(height + top + bottom),
        };
    }
    function content_size(el) {
        const { left, top } = el.getBoundingClientRect();
        const { padding } = extents(el);
        let width = 0;
        let height = 0;
        for (const child of (el.shadowRoot ?? el).children) {
            const rect = child.getBoundingClientRect();
            width = Math.max(width, Math.ceil(rect.left - left - padding.left + rect.width));
            height = Math.max(height, Math.ceil(rect.top - top - padding.top + rect.height));
        }
        return { width, height };
    }
    function bounding_box(el) {
        const { x, y, width, height } = el.getBoundingClientRect();
        return new bbox_1.BBox({ x, y, width, height });
    }
    function box_size(el) {
        const { width, height } = el.getBoundingClientRect();
        return { width, height };
    }
    function position(el, box, margin) {
        const { style } = el;
        style.left = `${box.x}px`;
        style.top = `${box.y}px`;
        style.width = `${box.width}px`;
        style.height = `${box.height}px`;
        if (margin == null) {
            style.margin = "";
        }
        else {
            const { top, right, bottom, left } = margin;
            style.margin = `${top}px ${right}px ${bottom}px ${left}px`;
        }
    }
    class ClassList {
        constructor(class_list) {
            this.class_list = class_list;
        }
        get values() {
            const values = [];
            for (let i = 0; i < this.class_list.length; i++) {
                const item = this.class_list.item(i);
                if (item != null) {
                    values.push(item);
                }
            }
            return values;
        }
        has(cls) {
            return this.class_list.contains(cls);
        }
        add(...classes) {
            for (const cls of classes) {
                this.class_list.add(cls);
            }
            return this;
        }
        remove(...classes) {
            for (const cls of classes) {
                if ((0, types_1.isArray)(cls)) {
                    cls.forEach((cls) => this.class_list.remove(cls));
                }
                else {
                    this.class_list.remove(cls);
                }
            }
            return this;
        }
        clear() {
            for (const cls of this.values) {
                this.class_list.remove(cls);
            }
            return this;
        }
        toggle(cls, activate) {
            return this.class_list.toggle(cls, activate);
        }
    }
    exports.ClassList = ClassList;
    ClassList.__name__ = "ClassList";
    function classes(el) {
        return new ClassList(el.classList);
    }
    function toggle_attribute(el, attr, state) {
        if (state == null) {
            state = !el.hasAttribute(attr);
        }
        if (state) {
            el.setAttribute(attr, "true");
        }
        else {
            el.removeAttribute(attr);
        }
    }
    (function (MouseButton) {
        MouseButton[MouseButton["None"] = 0] = "None";
        MouseButton[MouseButton["Primary"] = 1] = "Primary";
        MouseButton[MouseButton["Secondary"] = 2] = "Secondary";
        MouseButton[MouseButton["Auxiliary"] = 4] = "Auxiliary";
        MouseButton[MouseButton["Left"] = 1] = "Left";
        MouseButton[MouseButton["Right"] = 2] = "Right";
        MouseButton[MouseButton["Middle"] = 4] = "Middle";
    })(exports.MouseButton || (exports.MouseButton = {}));
    class StyleSheet {
        install(el) {
            el.append(this.el);
        }
        uninstall() {
            this.el.remove();
        }
    }
    exports.StyleSheet = StyleSheet;
    StyleSheet.__name__ = "StyleSheet";
    class InlineStyleSheet extends StyleSheet {
        constructor(css, id, persistent = false) {
            super();
            this.el = (0, exports.style)();
            this.persistent = persistent;
            if ((0, types_1.isString)(css)) {
                this._update(css);
            }
            else if (css != null) {
                this._update((0, css_1.compose_stylesheet)(css));
            }
            if (id != null) {
                this.el.dataset.css = id;
            }
        }
        get css() {
            return this.el.textContent ?? "";
        }
        _update(css) {
            this.el.textContent = css;
        }
        clear() {
            this.replace("");
        }
        _to_css(css, styles) {
            if (styles == null) {
                return css;
            }
            else {
                return (0, css_1.compose_stylesheet)({ [css]: styles });
            }
        }
        replace(css, styles) {
            this._update(this._to_css(css, styles));
        }
        prepend(css, styles) {
            this._update(`${this._to_css(css, styles)}\n${this.css}`);
        }
        append(css, styles) {
            this._update(`${this.css}\n${this._to_css(css, styles)}`);
        }
        remove() {
            this.el.remove();
        }
    }
    exports.InlineStyleSheet = InlineStyleSheet;
    InlineStyleSheet.__name__ = "InlineStyleSheet";
    class GlobalInlineStyleSheet extends InlineStyleSheet {
        install() {
            if (!this.el.isConnected) {
                document.head.appendChild(this.el);
            }
        }
    }
    exports.GlobalInlineStyleSheet = GlobalInlineStyleSheet;
    GlobalInlineStyleSheet.__name__ = "GlobalInlineStyleSheet";
    class ImportedStyleSheet extends StyleSheet {
        constructor(url) {
            super();
            this.el = (0, exports.link)({ rel: "stylesheet", href: url });
        }
        replace(url) {
            this.el.href = url;
        }
        remove() {
            this.el.remove();
        }
    }
    exports.ImportedStyleSheet = ImportedStyleSheet;
    ImportedStyleSheet.__name__ = "ImportedStyleSheet";
    class GlobalImportedStyleSheet extends ImportedStyleSheet {
        install() {
            if (!this.el.isConnected) {
                document.head.appendChild(this.el);
            }
        }
    }
    exports.GlobalImportedStyleSheet = GlobalImportedStyleSheet;
    GlobalImportedStyleSheet.__name__ = "GlobalImportedStyleSheet";
    async function dom_ready() {
        if (document.readyState == "loading") {
            return new Promise((resolve, _reject) => {
                document.addEventListener("DOMContentLoaded", () => resolve(), { once: true });
            });
        }
    }
    function px(value) {
        return (0, types_1.isNumber)(value) ? `${value}px` : value;
    }
    exports.supports_adopted_stylesheets = "adoptedStyleSheets" in ShadowRoot.prototype;
    function has_focus(el) {
        const root = el.getRootNode();
        if (root instanceof ShadowRoot || root instanceof Document) {
            return root.activeElement === el;
        }
        else {
            return false;
        }
    }
},
/* core/util/bbox.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.empty = empty;
    exports.full = full;
    exports.x_range = x_range;
    exports.y_range = y_range;
    exports.positive_x = positive_x;
    exports.negative_x = negative_x;
    exports.positive_y = positive_y;
    exports.negative_y = negative_y;
    exports.union = union;
    exports.isXY = isXY;
    const types_1 = require(25) /* ../types */;
    const eq_1 = require(27) /* ./eq */;
    const arrayable_1 = require(13) /* ./arrayable */;
    const types_2 = require(8) /* ./types */;
    const { min, max, round } = Math;
    function empty() {
        return {
            x0: Infinity,
            y0: Infinity,
            x1: -Infinity,
            y1: -Infinity,
        };
    }
    function full() {
        return {
            x0: -Infinity,
            y0: -Infinity,
            x1: Infinity,
            y1: Infinity,
        };
    }
    function x_range(x0, x1) {
        return {
            x0,
            y0: -Infinity,
            x1,
            y1: Infinity,
        };
    }
    function y_range(y0, y1) {
        return {
            x0: -Infinity,
            y0,
            x1: Infinity,
            y1,
        };
    }
    function positive_x() {
        return x_range(Number.MIN_VALUE, Infinity);
    }
    function negative_x() {
        return x_range(-Infinity, -Number.MIN_VALUE);
    }
    function positive_y() {
        return y_range(Number.MIN_VALUE, Infinity);
    }
    function negative_y() {
        return y_range(-Infinity, -Number.MIN_VALUE);
    }
    function _min(a, b) {
        if (isNaN(a)) {
            return b;
        }
        else if (isNaN(b)) {
            return a;
        }
        else {
            return min(a, b);
        }
    }
    function _max(a, b) {
        if (isNaN(a)) {
            return b;
        }
        else if (isNaN(b)) {
            return a;
        }
        else {
            return max(a, b);
        }
    }
    function union(a, b) {
        return {
            x0: _min(a.x0, b.x0),
            x1: _max(a.x1, b.x1),
            y0: _min(a.y0, b.y0),
            y1: _max(a.y1, b.y1),
        };
    }
    function isXY(obj) {
        return (0, types_2.isPlainObject)(obj) && "x" in obj && "y" in obj;
    }
    class BBox {
        constructor(box, correct = false) {
            if (box == null) {
                this.x0 = 0;
                this.y0 = 0;
                this.x1 = 0;
                this.y1 = 0;
            }
            else if ("x0" in box) {
                const { x0, y0, x1, y1 } = box;
                if (!isFinite(x0 + y0 + x1 + y1)) {
                    this.x0 = NaN;
                    this.y0 = NaN;
                    this.x1 = NaN;
                    this.y1 = NaN;
                }
                else {
                    if (!(x0 <= x1 && y0 <= y1)) {
                        throw new Error(`invalid bbox {x0: ${x0}, y0: ${y0}, x1: ${x1}, y1: ${y1}}`);
                    }
                    this.x0 = x0;
                    this.y0 = y0;
                    this.x1 = x1;
                    this.y1 = y1;
                }
            }
            else if ("x" in box) {
                const { x, y, width, height, origin = "top_left" } = box;
                if (!(width >= 0 && height >= 0)) {
                    throw new Error(`invalid bbox {x: ${x}, y: ${y}, width: ${width}, height: ${height}}`);
                }
                const base_origin = (() => {
                    switch (origin) {
                        case "left": return "center_left";
                        case "right": return "center_right";
                        case "top": return "top_center";
                        case "bottom": return "bottom_center";
                        case "center": return "center_center";
                        default: return origin;
                    }
                })();
                const [y_align, x_align] = base_origin.split("_", 2);
                const y_coeff = (() => {
                    switch (y_align) {
                        case "top": return 0.0;
                        case "center": return 0.5;
                        case "bottom": return 1.0;
                    }
                })();
                const x_coeff = (() => {
                    switch (x_align) {
                        case "left": return 0.0;
                        case "center": return 0.5;
                        case "right": return 1.0;
                    }
                })();
                const d_width = x_coeff * width;
                const d_height = y_coeff * height;
                const x0 = x - d_width;
                const y0 = y - d_height;
                const x1 = x0 + width;
                const y1 = y0 + height;
                this.x0 = x0;
                this.y0 = y0;
                this.x1 = x1;
                this.y1 = y1;
            }
            else {
                let left, right;
                let top, bottom;
                if ("width" in box) {
                    if ("left" in box) {
                        left = box.left;
                        right = left + box.width;
                    }
                    else if ("right" in box) {
                        right = box.right;
                        left = right - box.width;
                    }
                    else {
                        const w2 = box.width / 2;
                        left = box.hcenter - w2;
                        right = box.hcenter + w2;
                    }
                }
                else {
                    left = box.left;
                    right = box.right;
                }
                if ("height" in box) {
                    if ("top" in box) {
                        top = box.top;
                        bottom = top + box.height;
                    }
                    else if ("bottom" in box) {
                        bottom = box.bottom;
                        top = bottom - box.height;
                    }
                    else {
                        const h2 = box.height / 2;
                        top = box.vcenter - h2;
                        bottom = box.vcenter + h2;
                    }
                }
                else {
                    top = box.top;
                    bottom = box.bottom;
                }
                if (left > right || top > bottom) {
                    if (correct) {
                        if (left > right) {
                            left = right;
                        }
                        if (top > bottom) {
                            top = bottom;
                        }
                    }
                    else {
                        throw new Error(`invalid bbox {left: ${left}, top: ${top}, right: ${right}, bottom: ${bottom}}`);
                    }
                }
                this.x0 = left;
                this.y0 = top;
                this.x1 = right;
                this.y1 = bottom;
            }
        }
        static from_lrtb({ left, right, top, bottom }) {
            return new BBox({
                x0: min(left, right),
                y0: min(top, bottom),
                x1: max(left, right),
                y1: max(top, bottom),
            });
        }
        static from_rect({ x0, y0, x1, y1 }) {
            return new BBox({
                x0: min(x0, x1),
                y0: min(y0, y1),
                x1: max(x0, x1),
                y1: max(y0, y1),
            });
        }
        static empty() {
            return new BBox({ x0: 0, y0: 0, x1: 0, y1: 0 });
        }
        static invalid() {
            return new BBox({ x0: NaN, y0: NaN, x1: NaN, y1: NaN });
        }
        clone() {
            return new BBox(this);
        }
        equals(that) {
            return this.x0 == that.x0 && this.y0 == that.y0 &&
                this.x1 == that.x1 && this.y1 == that.y1;
        }
        [eq_1.equals](that, cmp) {
            return cmp.eq(this.x0, that.x0) && cmp.eq(this.y0, that.y0) &&
                cmp.eq(this.x1, that.x1) && cmp.eq(this.y1, that.y1);
        }
        toString() {
            return `BBox({left: ${this.left}, top: ${this.top}, width: ${this.width}, height: ${this.height}})`;
        }
        get is_valid() {
            const { x0, x1, y0, y1 } = this;
            return isFinite(x0 + x1 + y0 + y1);
        }
        get is_empty() {
            const { x0, x1, y0, y1 } = this;
            return x0 == 0 && x1 == 0 && y0 == 0 && y1 == 0;
        }
        get left() {
            return this.x0;
        }
        get top() {
            return this.y0;
        }
        get right() {
            return this.x1;
        }
        get bottom() {
            return this.y1;
        }
        get p0() {
            return { x: this.x0, y: this.y0 };
        }
        get p1() {
            return { x: this.x1, y: this.y1 };
        }
        get x() {
            return this.x0;
        }
        get y() {
            return this.y0;
        }
        get width() {
            return this.x1 - this.x0;
        }
        get height() {
            return this.y1 - this.y0;
        }
        get size() {
            return { width: this.width, height: this.height };
        }
        get rect() {
            const { x0, y0, x1, y1 } = this;
            return {
                p0: { x: x0, y: y0 },
                p1: { x: x1, y: y0 },
                p2: { x: x1, y: y1 },
                p3: { x: x0, y: y1 },
            };
        }
        get box() {
            const { x, y, width, height } = this;
            return { x, y, width, height };
        }
        get lrtb() {
            const { left, right, top, bottom } = this;
            return { left, right, top, bottom };
        }
        get args() {
            const { x, y, width, height } = this;
            return [x, y, width, height];
        }
        get x_range() {
            return { start: this.x0, end: this.x1 };
        }
        get y_range() {
            return { start: this.y0, end: this.y1 };
        }
        get h_range() {
            return this.x_range;
        }
        get v_range() {
            return this.y_range;
        }
        get ranges() {
            return [this.x_range, this.y_range];
        }
        get aspect() {
            return this.width / this.height;
        }
        get x_center() {
            return (this.left + this.right) / 2;
        }
        get y_center() {
            return (this.top + this.bottom) / 2;
        }
        get hcenter() {
            return this.x_center;
        }
        get vcenter() {
            return this.y_center;
        }
        get area() {
            return this.width * this.height;
        }
        resolve(symbol) {
            switch (symbol) {
                case "top_left": return this.top_left;
                case "top_center": return this.top_center;
                case "top_right": return this.top_right;
                case "center_left": return this.center_left;
                case "center_center": return this.center_center;
                case "center_right": return this.center_right;
                case "bottom_left": return this.bottom_left;
                case "bottom_center": return this.bottom_center;
                case "bottom_right": return this.bottom_right;
                case "center": return this.center;
                case "top": return this.top;
                case "left": return this.left;
                case "right": return this.right;
                case "bottom": return this.bottom;
                case "width": return this.width;
                case "height": return this.height;
                default: return { x: NaN, y: NaN };
            }
        }
        get top_left() {
            return { x: this.left, y: this.top };
        }
        get top_center() {
            return { x: this.hcenter, y: this.top };
        }
        get top_right() {
            return { x: this.right, y: this.top };
        }
        get center_left() {
            return { x: this.left, y: this.vcenter };
        }
        get center_center() {
            return { x: this.hcenter, y: this.vcenter };
        }
        get center_right() {
            return { x: this.right, y: this.vcenter };
        }
        get bottom_left() {
            return { x: this.left, y: this.bottom };
        }
        get bottom_center() {
            return { x: this.hcenter, y: this.bottom };
        }
        get bottom_right() {
            return { x: this.right, y: this.bottom };
        }
        get center() {
            return { x: this.hcenter, y: this.vcenter };
        }
        round() {
            return new BBox({
                x0: round(this.x0),
                x1: round(this.x1),
                y0: round(this.y0),
                y1: round(this.y1),
            });
        }
        relative() {
            const { width, height } = this;
            return new BBox({ x: 0, y: 0, width, height });
        }
        relative_to(to) {
            const { x, y, width, height } = this;
            return new BBox({ x: x - to.x, y: y - to.y, width, height });
        }
        translate(tx, ty) {
            const { x, y, width, height } = this;
            return new BBox({ x: tx + x, y: ty + y, width, height });
        }
        scale(factor) {
            return new BBox({
                x0: this.x0 * factor,
                x1: this.x1 * factor,
                y0: this.y0 * factor,
                y1: this.y1 * factor,
            });
        }
        relativize(x, y) {
            return [x - this.x, y - this.y];
        }
        contains(x, y) {
            return this.x0 <= x && x <= this.x1 && this.y0 <= y && y <= this.y1;
        }
        clip(x, y) {
            if (x < this.x0) {
                x = this.x0;
            }
            else if (x > this.x1) {
                x = this.x1;
            }
            if (y < this.y0) {
                y = this.y0;
            }
            else if (y > this.y1) {
                y = this.y1;
            }
            return [x, y];
        }
        grow_by(size) {
            return new BBox({
                left: this.left - size,
                right: this.right + size,
                top: this.top - size,
                bottom: this.bottom + size,
            });
        }
        shrink_by(size) {
            return new BBox({
                left: this.left + size,
                right: this.right - size,
                top: this.top + size,
                bottom: this.bottom - size,
            }, true);
        }
        union(that) {
            return new BBox({
                x0: min(this.x0, that.x0),
                y0: min(this.y0, that.y0),
                x1: max(this.x1, that.x1),
                y1: max(this.y1, that.y1),
            });
        }
        intersection(that) {
            if (!this.intersects(that)) {
                return null;
            }
            else {
                return new BBox({
                    x0: max(this.x0, that.x0),
                    y0: max(this.y0, that.y0),
                    x1: min(this.x1, that.x1),
                    y1: min(this.y1, that.y1),
                });
            }
        }
        intersects(that) {
            return !(that.x1 < this.x0 || that.x0 > this.x1 ||
                that.y1 < this.y0 || that.y0 > this.y1);
        }
        get x_percent() {
            const self = this;
            return this._x_percent ?? (this._x_percent = {
                compute(x) {
                    return self.left + x * self.width;
                },
                invert(sx) {
                    return (sx - self.left) / self.width;
                },
                v_compute(xs) {
                    const { left, width } = self;
                    return new types_1.ScreenArray((0, arrayable_1.map)(xs, (x) => left + x * width));
                },
                v_invert(sxs) {
                    const { left, width } = self;
                    return (0, arrayable_1.map)(sxs, (sx) => (sx - left) / width);
                },
                get source_range() {
                    return self.x_range;
                },
                get target_range() {
                    return self.x_range;
                },
            });
        }
        get y_percent() {
            const self = this;
            return this._y_percent ?? (this._y_percent = {
                compute(y) {
                    return self.top + y * self.height;
                },
                invert(sy) {
                    return (sy - self.top) / self.height;
                },
                v_compute(ys) {
                    const { top, height } = self;
                    return new types_1.ScreenArray((0, arrayable_1.map)(ys, (y) => top + y * height));
                },
                v_invert(sys) {
                    const { top, height } = self;
                    return (0, arrayable_1.map)(sys, (sy) => (sy - top) / height);
                },
                get source_range() {
                    return self.y_range;
                },
                get target_range() {
                    return self.y_range;
                },
            });
        }
        get x_screen() {
            const self = this;
            return this._x_screen ?? (this._x_screen = {
                compute(x) {
                    return self.left + x;
                },
                invert(sx) {
                    return sx - self.left;
                },
                v_compute(xs) {
                    const { left } = self;
                    return new types_1.ScreenArray((0, arrayable_1.map)(xs, (x) => left + x));
                },
                v_invert(sxs) {
                    const { left } = self;
                    return (0, arrayable_1.map)(sxs, (sx) => sx - left);
                },
                get source_range() {
                    return self.x_range;
                },
                get target_range() {
                    return self.x_range;
                },
            });
        }
        get y_screen() {
            const self = this;
            return this._y_screen ?? (this._y_screen = {
                compute(y) {
                    return self.top + y;
                },
                invert(sy) {
                    return sy - self.top;
                },
                v_compute(ys) {
                    const { top } = self;
                    return new types_1.ScreenArray((0, arrayable_1.map)(ys, (y) => top + y));
                },
                v_invert(sys) {
                    const { top } = self;
                    return (0, arrayable_1.map)(sys, (sy) => sy - top);
                },
                get source_range() {
                    return self.y_range;
                },
                get target_range() {
                    return self.y_range;
                },
            });
        }
        get x_view() {
            const self = this;
            return this._x_view ?? (this._x_view = {
                compute(x) {
                    return self.left + x;
                },
                invert(sx) {
                    return sx - self.left;
                },
                v_compute(xs) {
                    const { left } = self;
                    return new types_1.ScreenArray((0, arrayable_1.map)(xs, (x) => left + x));
                },
                v_invert(sxs) {
                    const { left } = self;
                    return (0, arrayable_1.map)(sxs, (sx) => sx - left);
                },
                get source_range() {
                    return self.x_range;
                },
                get target_range() {
                    return self.x_range;
                },
            });
        }
        get y_view() {
            const self = this;
            return this._y_view ?? (this._y_view = {
                compute(y) {
                    return self.bottom - y;
                },
                invert(sy) {
                    return self.bottom - sy;
                },
                v_compute(ys) {
                    const { bottom } = self;
                    return new types_1.ScreenArray((0, arrayable_1.map)(ys, (y) => bottom - y));
                },
                v_invert(sys) {
                    const { bottom } = self;
                    return (0, arrayable_1.map)(sys, (sy) => bottom - sy);
                },
                get source_range() {
                    return self.y_range;
                },
                get target_range() {
                    return { start: self.bottom, end: self.top };
                },
            });
        }
        get xview() {
            return this.x_view;
        }
        get yview() {
            return this.y_view;
        }
    }
    exports.BBox = BBox;
    BBox.__name__ = "BBox";
},
/* core/css.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.apply_styles = apply_styles;
    exports.compose_stylesheet = compose_stylesheet;
    const logging_1 = require(20) /* ./logging */;
    const object_1 = require(9) /* ./util/object */;
    const types_1 = require(8) /* ./util/types */;
    const _style_decl = document.createElement("div").style;
    function _css_name(attr) {
        if (attr.startsWith("--")) {
            return attr;
        }
        const name = attr.replaceAll(/_/g, "-").replaceAll(/[A-Z]/g, (c) => `-${c.toLowerCase()}`);
        // XXX hasOwnProperty() doesn't work for unknown reasons (e.g. in Firefox)
        if (name in _style_decl) {
            return name;
        }
        const webkit_name = `-webkit-${name}`;
        if (webkit_name in _style_decl) {
            return webkit_name;
        }
        const moz_name = `-moz-${name}`;
        if (moz_name in _style_decl) {
            return moz_name;
        }
        logging_1.logger.warn(`unknown CSS property '${attr}'`);
        return null;
    }
    function* _iter_styles(styles) {
        if ((0, types_1.isPlainObject)(styles) || styles instanceof Map) {
            for (const [key, val] of (0, object_1.entries)(styles)) {
                const name = _css_name(key);
                if (name != null) {
                    yield [name, val];
                }
            }
        }
        else {
            for (const prop of styles.own_properties()) {
                if (prop.dirty) {
                    const name = _css_name(prop.attr);
                    if (name != null) {
                        yield [name, prop.get_value()];
                    }
                }
            }
        }
    }
    function apply_styles(declaration, styles) {
        for (const [name, value] of _iter_styles(styles)) {
            if ((0, types_1.isString)(value)) {
                declaration.setProperty(name, value);
            }
            else {
                declaration.removeProperty(name);
            }
        }
    }
    function compose_stylesheet(stylesheet) {
        const css = [];
        for (const [selector, styles] of (0, object_1.entries)(stylesheet)) {
            css.push(`${selector} {`);
            for (const [name, value] of _iter_styles(styles)) {
                if ((0, types_1.isString)(value) && value.length != 0) {
                    css.push(`  ${name}: ${value};`);
                }
            }
            css.push("}");
        }
        return css.join("\n");
    }
},
/* styles/base.css.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = `:host{--base-font:var(--bokeh-base-font, Helvetica, Arial, sans-serif);--mono-font:var(--bokeh-mono-font, monospace);--font-size:var(--bokeh-font-size, 12px);--line-height:calc(20 / 14);--line-height-computed:calc(var(--font-size) * var(--line-height));--border-radius:4px;--padding-vertical:6px;--padding-horizontal:12px;--bokeh-top-level:10000;--background-color:#ffffff;--hover-color:#f9f9f9;--disabled-color:#808080;--border-color:#cccccc;--divider-color:#e5e5e5;--shortcut-color:#808080;--highlight-color:#26aae1;--active-bg:#c2d5f7;--active-fg:#3b80f0;--inactive-bg:#e5e5e5;--inactive-fg:#adadad;--icon-color:var(--bokeh-icon-color, #a1a6a9);--icon-color-disabled:var(--bokeh-icon-color-disabled, #d4d9db);--box-shadow:2px 4px 8px rgba(0, 0, 0, 0.175);}:host{box-sizing:border-box;font-family:var(--base-font);font-size:var(--font-size);line-height:var(--line-height);}*,*:before,*:after{box-sizing:inherit;font-family:inherit;}pre,code,tt{font-family:var(--mono-font);margin:0;}`;
},
/* embed/server.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports._get_ws_url = _get_ws_url;
    exports.add_document_from_session = add_document_from_session;
    const connection_1 = require(68) /* ../client/connection */;
    const logging_1 = require(20) /* ../core/logging */;
    const standalone_1 = require(54) /* ./standalone */;
    // @internal
    function _get_ws_url(app_path, absolute_url) {
        // if in an `srcdoc` iframe, try to get the absolute URL
        // from the `data-absolute-url` attribute if not passed explicitly
        if (absolute_url === undefined && _is_frame_HTMLElement(frameElement) && frameElement.dataset.absoluteUrl !== undefined) {
            absolute_url = frameElement.dataset.absoluteUrl;
        }
        let loc;
        if (absolute_url != null) {
            loc = document.createElement("a");
            loc.href = absolute_url;
        }
        else {
            loc = window.location;
        }
        const protocol = loc.protocol == "https:" ? "wss:" : "ws:";
        if (app_path != null) {
            if (app_path == "/") {
                app_path = "";
            }
        }
        else {
            app_path = loc.pathname.replace(/\/+$/, "");
        }
        return `${protocol}//${loc.host}${app_path}/ws`;
    }
    function _is_frame_HTMLElement(frame) {
        // `frameElement` is a delicate construct; it allows the document inside the frame to access
        // some (but not all) properties of the parent element in which the frame document is embedded.
        // Because it lives in a different DOM context than the frame's `window`, we cannot just use
        // `frameElement instanceof HTMLIFrameElement`; we could use `window.parent.HTMLIFrameElement`
        // but this can be blocked by CORS policy and throw an exception.
        if (frame === null) {
            return false;
        }
        if (frame.tagName.toUpperCase() === "IFRAME") {
            return true;
        }
        return false;
    }
    const _sessions = new Map();
    function _get_session(websocket_url, token, args_string) {
        const session_id = (0, connection_1.parse_token)(token).session_id;
        if (!_sessions.has(websocket_url)) {
            _sessions.set(websocket_url, new Map());
        }
        const subsessions = _sessions.get(websocket_url);
        if (!subsessions.has(session_id)) {
            subsessions.set(session_id, (0, connection_1.pull_session)(websocket_url, token, args_string));
        }
        return subsessions.get(session_id);
    }
    // Fill element with the roots from token
    async function add_document_from_session(websocket_url, token, element, roots = [], use_for_title = false) {
        const args_string = window.location.search.substring(1);
        let session;
        try {
            session = await _get_session(websocket_url, token, args_string);
        }
        catch (error) {
            const session_id = (0, connection_1.parse_token)(token).session_id;
            logging_1.logger.error(`Failed to load Bokeh session ${session_id}: ${error}`);
            throw error;
        }
        return (0, standalone_1.add_document_standalone)(session.document, element, roots, use_for_title);
    }
},
/* client/connection.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.parse_token = parse_token;
    exports.pull_session = pull_session;
    const logging_1 = require(20) /* ../core/logging */;
    const document_1 = require(5) /* ../document */;
    const message_1 = require(69) /* ../protocol/message */;
    const receiver_1 = require(70) /* ../protocol/receiver */;
    const session_1 = require(71) /* ./session */;
    exports.DEFAULT_SERVER_WEBSOCKET_URL = "ws://localhost:5006/ws";
    exports.DEFAULT_TOKEN = "eyJzZXNzaW9uX2lkIjogImRlZmF1bHQifQ";
    let _connection_count = 0;
    function parse_token(token) {
        let payload = token.split(".")[0];
        const mod = payload.length % 4;
        if (mod != 0) {
            payload = payload + "=".repeat(4 - mod);
        }
        return JSON.parse(atob(payload.replace(/_/g, "/").replace(/-/g, "+")));
    }
    class ClientConnection {
        constructor(url = exports.DEFAULT_SERVER_WEBSOCKET_URL, token = exports.DEFAULT_TOKEN, args_string = null) {
            this._number = _connection_count++;
            this.socket = null;
            this.session = null;
            this.closed_permanently = false;
            this._current_handler = null;
            this._pending_replies = new Map();
            this._pending_messages = [];
            this._receiver = new receiver_1.Receiver();
            this.url = url;
            this.token = token;
            this.args_string = args_string;
            this.id = parse_token(token).session_id.split(".")[0];
            logging_1.logger.debug(`Creating websocket ${this._number} to '${this.url}' session '${this.id}'`);
        }
        async connect() {
            if (this.closed_permanently) {
                throw new Error("Cannot connect() a closed ClientConnection");
            }
            if (this.socket != null) {
                throw new Error("Already connected");
            }
            this._current_handler = null;
            this._pending_replies.clear();
            this._pending_messages = [];
            try {
                let versioned_url = `${this.url}`;
                if (this.args_string != null && this.args_string.length > 0) {
                    versioned_url += `?${this.args_string}`;
                }
                this.socket = new WebSocket(versioned_url, ["bokeh", this.token]);
                return new Promise((resolve, reject) => {
                    // "arraybuffer" gives us binary data we can look at;
                    // if we just needed an opaque blob we could use "blob"
                    this.socket.binaryType = "arraybuffer";
                    this.socket.onopen = () => this._on_open(resolve, reject);
                    this.socket.onmessage = (event) => this._on_message(event);
                    this.socket.onclose = (event) => this._on_close(event, reject);
                    this.socket.onerror = () => this._on_error(reject);
                });
            }
            catch (error) {
                logging_1.logger.error(`websocket creation failed to url: ${this.url}`);
                logging_1.logger.error(` - ${error}`);
                throw error;
            }
        }
        close() {
            if (!this.closed_permanently) {
                logging_1.logger.debug(`Permanently closing websocket connection ${this._number}`);
                this.closed_permanently = true;
                if (this.socket != null) {
                    this.socket.close(1000, `close method called on ClientConnection ${this._number}`);
                }
                this.session._connection_closed();
            }
        }
        _schedule_reconnect(milliseconds) {
            const retry = () => {
                // TODO commented code below until we fix reconnection to repull
                // the document when required. Otherwise, we get a lot of
                // confusing errors that are causing trouble when debugging.
                /*
                if (this.closed_permanently) {
                */
                if (!this.closed_permanently) {
                    logging_1.logger.info(`Websocket connection ${this._number} disconnected, will not attempt to reconnect`);
                    this.session?.notify_connection_lost();
                }
                return;
                /*
                } else {
                  logger.debug(`Attempting to reconnect websocket ${this._number}`)
                  this.connect()
                }
                */
            };
            setTimeout(retry, milliseconds);
        }
        send(message) {
            if (this.socket != null) {
                message.send(this.socket);
            }
            else {
                logging_1.logger.error("not connected so cannot send", message);
            }
        }
        async send_with_reply(message) {
            const reply = await new Promise((resolve, reject) => {
                this._pending_replies.set(message.msgid(), { resolve, reject });
                this.send(message);
            });
            if (reply.msgtype() == "ERROR") {
                throw new Error(`Error reply ${reply.content.text}`);
            }
            else {
                return reply;
            }
        }
        async _pull_doc_json() {
            const message = message_1.Message.create("PULL-DOC-REQ", {}, {});
            const reply = await this.send_with_reply(message);
            if (!("doc" in reply.content)) {
                throw new Error("No 'doc' field in PULL-DOC-REPLY");
            }
            return reply.content.doc;
        }
        async _repull_session_doc(resolve, reject) {
            logging_1.logger.debug(this.session != null ? "Repulling session" : "Pulling session for first time");
            try {
                const doc_json = await this._pull_doc_json();
                if (this.session == null) {
                    if (this.closed_permanently) {
                        logging_1.logger.debug("Got new document after connection was already closed");
                        reject(new Error("The connection has been closed"));
                    }
                    else {
                        const events = [];
                        const document = document_1.Document.from_json(doc_json, events);
                        this.session = new session_1.ClientSession(this, document);
                        // Send back change events that happened during model initialization.
                        for (const event of events) {
                            document._trigger_on_change(event);
                        }
                        for (const msg of this._pending_messages) {
                            this.session.handle(msg);
                        }
                        this._pending_messages = [];
                        logging_1.logger.debug("Created a new session from new pulled doc");
                        resolve(this.session);
                    }
                }
                else {
                    this.session.document.replace_with_json(doc_json);
                    logging_1.logger.debug("Updated existing session with new pulled doc");
                    // Since the session already exists, we don't need to call `resolve` again.
                }
            }
            catch (error) {
                console.trace(error);
                logging_1.logger.error(`Failed to repull session ${error}`);
                reject(error instanceof Error ? error : `${error}`);
            }
        }
        _on_open(resolve, reject) {
            logging_1.logger.info(`Websocket connection ${this._number} is now open`);
            this._current_handler = (message) => {
                this._awaiting_ack_handler(message, resolve, reject);
            };
        }
        _on_message(event) {
            if (this._current_handler == null) {
                logging_1.logger.error("Got a message with no current handler set");
            }
            try {
                this._receiver.consume(event.data);
            }
            catch (e) {
                this._close_bad_protocol(`${e}`);
            }
            const msg = this._receiver.message;
            if (msg != null) {
                const problem = msg.problem();
                if (problem != null) {
                    this._close_bad_protocol(problem);
                }
                this._current_handler(msg);
            }
        }
        _on_close(event, reject) {
            logging_1.logger.info(`Lost websocket ${this._number} connection, ${event.code} (${event.reason})`);
            this.socket = null;
            this._pending_replies.forEach((pr) => pr.reject("Disconnected"));
            this._pending_replies.clear();
            if (!this.closed_permanently) {
                this._schedule_reconnect(2000);
            }
            reject(new Error(`Lost websocket connection, ${event.code} (${event.reason})`));
        }
        _on_error(reject) {
            logging_1.logger.debug(`Websocket error on socket ${this._number}`);
            const msg = "Could not open websocket";
            logging_1.logger.error(`Failed to connect to Bokeh server: ${msg}`);
            reject(new Error(msg));
        }
        _close_bad_protocol(detail) {
            logging_1.logger.error(`Closing connection: ${detail}`);
            if (this.socket != null) {
                this.socket.close(1002, detail);
            } // 1002 = protocol error
        }
        _awaiting_ack_handler(message, resolve, reject) {
            if (message.msgtype() === "ACK") {
                this._current_handler = (message) => this._steady_state_handler(message);
                // Reload any sessions
                void this._repull_session_doc(resolve, reject);
            }
            else {
                this._close_bad_protocol("First message was not an ACK");
            }
        }
        _steady_state_handler(message) {
            const reqid = message.reqid();
            const pr = this._pending_replies.get(reqid);
            if (pr != null) {
                this._pending_replies.delete(reqid);
                pr.resolve(message);
            }
            else if (this.session != null) {
                this.session.handle(message);
            }
            else if (message.msgtype() != "PATCH-DOC") {
                // This branch can be executed only before we get the document.
                // When we get the document, all of the patches will already be incorporated.
                // In general, it's not possible to apply patches received before the document,
                // since they may change some models that were removed before serving the document.
                this._pending_messages.push(message);
            }
        }
    }
    exports.ClientConnection = ClientConnection;
    ClientConnection.__name__ = "ClientConnection";
    function pull_session(url, token, args_string) {
        const connection = new ClientConnection(url, token, args_string);
        return connection.connect();
    }
},
/* protocol/message.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const serialization_1 = require(33) /* ../core/serialization */;
    const string_1 = require(40) /* ../core/util/string */;
    const assert_1 = require(12) /* ../core/util/assert */;
    class Message {
        get buffers() {
            return this._buffers;
        }
        constructor(header, metadata, content) {
            this._buffers = new Map();
            this.header = header;
            this.metadata = metadata;
            this.content = content;
        }
        static assemble(header_json, metadata_json, content_json) {
            const header = JSON.parse(header_json);
            const metadata = JSON.parse(metadata_json);
            const content = JSON.parse(content_json);
            return new Message(header, metadata, content);
        }
        assemble_buffer(buf_header, buf_payload) {
            const nb = this.header.num_buffers ?? 0;
            if (nb <= this._buffers.size) {
                throw new Error(`too many buffers received, expecting ${nb}`);
            }
            const { id } = JSON.parse(buf_header);
            this._buffers.set(id, buf_payload);
        }
        static create(msgtype, metadata, content) {
            const header = Message.create_header(msgtype);
            return new Message(header, metadata, content);
        }
        static create_header(msgtype) {
            return {
                msgid: (0, string_1.unique_id)(),
                msgtype,
            };
        }
        complete() {
            const { num_buffers } = this.header;
            return num_buffers == null || this._buffers.size == num_buffers;
        }
        send(socket) {
            (0, assert_1.assert)(this.header.num_buffers == null);
            const buffers = [];
            const content_json = JSON.stringify(this.content, (_, val) => {
                if (val instanceof serialization_1.Buffer) {
                    const ref = { id: `${buffers.length}` };
                    buffers.push([ref, val.buffer]);
                    return ref;
                }
                else {
                    return val;
                }
            });
            const num_buffers = buffers.length;
            if (num_buffers > 0) {
                this.header.num_buffers = num_buffers;
            }
            const header_json = JSON.stringify(this.header);
            const metadata_json = JSON.stringify(this.metadata);
            socket.send(header_json);
            socket.send(metadata_json);
            socket.send(content_json);
            for (const [ref, buffer] of buffers) {
                socket.send(JSON.stringify(ref));
                socket.send(buffer);
            }
        }
        msgid() {
            return this.header.msgid;
        }
        msgtype() {
            return this.header.msgtype;
        }
        reqid() {
            return this.header.reqid;
        }
        // return the reason we should close on bad protocol, if there is one
        problem() {
            if (!("msgid" in this.header)) {
                return "No msgid in header";
            }
            else if (!("msgtype" in this.header)) {
                return "No msgtype in header";
            }
            else {
                return null;
            }
        }
    }
    exports.Message = Message;
    Message.__name__ = "Message";
},
/* protocol/receiver.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const message_1 = require(69) /* ./message */;
    const types_1 = require(8) /* ../core/util/types */;
    const assert_1 = require(12) /* ../core/util/assert */;
    class Receiver {
        constructor() {
            this.message = null;
            this._partial = null;
            this._fragments = [];
            this._buf_header = null;
            this._current_consumer = this._HEADER;
        }
        consume(fragment) {
            this._current_consumer(fragment);
        }
        _HEADER(fragment) {
            this._assume_text(fragment);
            this.message = null;
            this._partial = null;
            this._fragments = [fragment];
            this._buf_header = null;
            this._current_consumer = this._METADATA;
        }
        _METADATA(fragment) {
            this._assume_text(fragment);
            this._fragments.push(fragment);
            this._current_consumer = this._CONTENT;
        }
        _CONTENT(fragment) {
            this._assume_text(fragment);
            this._fragments.push(fragment);
            const [header_json, metadata_json, content_json] = this._fragments;
            (0, assert_1.assert)(header_json != null && metadata_json != null && content_json != null);
            this._partial = message_1.Message.assemble(header_json, metadata_json, content_json);
            this._check_complete();
        }
        _BUFFER_HEADER(fragment) {
            this._assume_text(fragment);
            this._buf_header = fragment;
            this._current_consumer = this._BUFFER_PAYLOAD;
        }
        _BUFFER_PAYLOAD(fragment) {
            this._assume_binary(fragment);
            (0, assert_1.assert)(this._partial != null && this._buf_header != null);
            this._partial.assemble_buffer(this._buf_header, fragment);
            this._check_complete();
        }
        _assume_text(fragment) {
            if (!(0, types_1.isString)(fragment)) {
                throw new Error("Expected text fragment but received binary fragment");
            }
        }
        _assume_binary(fragment) {
            if (!(fragment instanceof ArrayBuffer)) {
                throw new Error("Expected binary fragment but received text fragment");
            }
        }
        _check_complete() {
            if (this._partial.complete()) {
                this.message = this._partial;
                this._current_consumer = this._HEADER;
            }
            else {
                this._current_consumer = this._BUFFER_HEADER;
            }
        }
    }
    exports.Receiver = Receiver;
    Receiver.__name__ = "Receiver";
},
/* client/session.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const document_1 = require(5) /* ../document */;
    const bokeh_events_1 = require(53) /* ../core/bokeh_events */;
    const message_1 = require(69) /* ../protocol/message */;
    const logging_1 = require(20) /* ../core/logging */;
    class ClientSession {
        constructor(_connection, document) {
            this._document_listener = (event) => {
                this._document_changed(event);
            };
            this._connection = _connection;
            this.document = document;
            this.document.on_change(this._document_listener, true);
        }
        // XXX: this is only needed in tests
        get id() {
            return this._connection.id;
        }
        handle(message) {
            const msgtype = message.msgtype();
            switch (msgtype) {
                case "PATCH-DOC": {
                    this._handle_patch(message);
                    break;
                }
                case "OK": {
                    this._handle_ok(message);
                    break;
                }
                case "ERROR": {
                    this._handle_error(message);
                    break;
                }
                default:
                    logging_1.logger.debug(`Doing nothing with message '${msgtype}'`);
            }
        }
        notify_connection_lost() {
            this.document.event_manager.send_event(new bokeh_events_1.ConnectionLost());
        }
        close() {
            this._connection.close();
        }
        /*protected*/ _connection_closed() {
            this.document.remove_on_change(this._document_listener);
        }
        // Sends a request to the server for info about the server, such as its Bokeh
        // version. Returns a promise, the value of the promise is a free-form dictionary
        // of server details.
        async request_server_info() {
            const message = message_1.Message.create("SERVER-INFO-REQ", {}, {});
            const reply = await this._connection.send_with_reply(message);
            return reply.content;
        }
        // Sends some request to the server (no guarantee about which one) and returns
        // a promise which is completed when the server replies. The purpose of this
        // is that if you wait for the promise to be completed, you know the server
        // has processed the request. This is useful when writing tests because once
        // the server has processed this request it should also have processed any
        // events or requests you sent previously, which means you can check for the
        // results of that processing without a race condition. (This assumes the
        // server processes events in sequence, which it mostly has to semantically,
        // since reordering events might change the final state.)
        async force_roundtrip() {
            await this.request_server_info();
        }
        _document_changed(event) {
            const events = (() => {
                const events = event instanceof document_1.DocumentEventBatch ? (event.sync ? event.events : []) : [event];
                return events.filter((event) => event.sync);
            })();
            if (events.length == 0) {
                return;
            }
            const patch = this.document.create_json_patch(events);
            // TODO (havocp) the connection may be closed here, which will
            // cause this send to throw an error - need to deal with it more cleanly.
            const message = message_1.Message.create("PATCH-DOC", {}, patch);
            this._connection.send(message);
        }
        _handle_patch(message) {
            this.document.apply_json_patch(message.content, message.buffers);
        }
        _handle_ok(message) {
            logging_1.logger.trace(`Unhandled OK reply to ${message.reqid()}`);
        }
        _handle_error(message) {
            logging_1.logger.error(`Unhandled ERROR reply to ${message.reqid()}: ${message.content.text}`);
        }
    }
    exports.ClientSession = ClientSession;
    ClientSession.__name__ = "ClientSession";
},
/* embed/dom.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports._resolve_element = _resolve_element;
    exports._resolve_root_elements = _resolve_root_elements;
    const dom_1 = require(63) /* ../core/dom */;
    const types_1 = require(8) /* ../core/util/types */;
    function _get_element(target) {
        let element = (0, types_1.isString)(target) ? document.getElementById(target) : target;
        if (element == null) {
            throw new Error(`Error rendering Bokeh model: could not find ${(0, types_1.isString)(target) ? `#${target}` : target} HTML tag`);
        }
        if (!(0, dom_1.contains)(document.body, element)) {
            throw new Error(`Error rendering Bokeh model: element ${(0, types_1.isString)(target) ? `#${target}` : target} must be under <body>`);
        }
        // If autoload script, replace script tag with div for embedding.
        if (element instanceof HTMLElement && element.tagName == "SCRIPT") {
            const root_el = (0, dom_1.div)();
            element.replaceWith(root_el);
            element = root_el;
        }
        return element;
    }
    function _resolve_element(item) {
        const { elementid } = item;
        if (elementid != null) {
            return _get_element(elementid);
        }
        else {
            return document.body;
        }
    }
    function _resolve_root_elements(item) {
        const roots = [];
        if (item.root_ids != null && item.roots != null) {
            for (const root_id of item.root_ids) {
                roots.push(_get_element(item.roots[root_id]));
            }
        }
        return roots;
    }
},
/* embed/notebook.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.embed_items_notebook = embed_items_notebook;
    const document_1 = require(5) /* ../document */;
    const receiver_1 = require(70) /* ../protocol/receiver */;
    const logging_1 = require(20) /* ../core/logging */;
    const object_1 = require(9) /* ../core/util/object */;
    const standalone_1 = require(54) /* ./standalone */;
    const dom_1 = require(72) /* ./dom */;
    // This exists to allow the @bokeh/jupyter_bokeh extension to store the
    // notebook kernel so that _init_comms can register the comms target.
    // This has to be available at Bokeh.embed.kernels in JupyterLab.
    exports.kernels = {};
    function _handle_notebook_comms(receiver, comm_msg) {
        if (comm_msg.buffers.length > 0) {
            receiver.consume(comm_msg.buffers[0].buffer);
        }
        else {
            receiver.consume(comm_msg.content.data);
        }
        const msg = receiver.message;
        if (msg != null) {
            this.apply_json_patch(msg.content, msg.buffers);
        }
    }
    function _init_comms(target, doc) {
        if (typeof Jupyter !== "undefined" && Jupyter.notebook.kernel != null) {
            logging_1.logger.info(`Registering Jupyter comms for target ${target}`);
            const comm_manager = Jupyter.notebook.kernel.comm_manager;
            try {
                comm_manager.register_target(target, (comm) => {
                    logging_1.logger.info(`Registering Jupyter comms for target ${target}`);
                    const r = new receiver_1.Receiver();
                    comm.on_msg(_handle_notebook_comms.bind(doc, r));
                });
            }
            catch (e) {
                logging_1.logger.warn(`Jupyter comms failed to register. push_notebook() will not function. (exception reported: ${e})`);
            }
        }
        else if (doc.roots()[0].id in exports.kernels) {
            logging_1.logger.info(`Registering JupyterLab comms for target ${target}`);
            const kernel = exports.kernels[doc.roots()[0].id];
            try {
                kernel.registerCommTarget(target, (comm) => {
                    logging_1.logger.info(`Registering JupyterLab comms for target ${target}`);
                    const r = new receiver_1.Receiver();
                    comm.onMsg = _handle_notebook_comms.bind(doc, r);
                });
            }
            catch (e) {
                logging_1.logger.warn(`Jupyter comms failed to register. push_notebook() will not function. (exception reported: ${e})`);
            }
        }
        else if (typeof google != "undefined" && google.colab.kernel != null) {
            logging_1.logger.info(`Registering Google Colab comms for target ${target}`);
            const comm_manager = google.colab.kernel.comms;
            try {
                comm_manager.registerTarget(target, async (comm) => {
                    logging_1.logger.info(`Registering Google Colab comms for target ${target}`);
                    const r = new receiver_1.Receiver();
                    for await (const message of comm.messages) {
                        const content = { data: message.data };
                        const buffers = [];
                        for (const buffer of message.buffers ?? []) {
                            buffers.push(new DataView(buffer));
                        }
                        const msg = { content, buffers };
                        _handle_notebook_comms.bind(doc)(r, msg);
                    }
                });
            }
            catch (e) {
                logging_1.logger.warn(`Google Colab comms failed to register. push_notebook() will not function. (exception reported: ${e})`);
            }
        }
        else {
            console.warn("Jupyter notebooks comms not available. push_notebook() will not function. If running JupyterLab ensure the latest @bokeh/jupyter_bokeh extension is installed. In an exported notebook this warning is expected.");
        }
    }
    async function embed_items_notebook(docs_json, render_items) {
        if ((0, object_1.size)(docs_json) != 1) {
            throw new Error("embed_items_notebook expects exactly one document in docs_json");
        }
        const document = document_1.Document.from_json((0, object_1.values)(docs_json)[0]);
        for (const item of render_items) {
            if (item.notebook_comms_target != null) {
                _init_comms(item.notebook_comms_target, document);
            }
            const element = (0, dom_1._resolve_element)(item);
            const roots = (0, dom_1._resolve_root_elements)(item);
            await (0, standalone_1.add_document_standalone)(document, element, roots);
            for (const root of roots) {
                if (root instanceof HTMLElement) {
                    root.removeAttribute("id");
                }
            }
        }
    }
},
/* protocol/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    tslib_1.__exportStar(require(69) /* ./message */, exports);
    tslib_1.__exportStar(require(70) /* ./receiver */, exports);
},
/* safely.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.safely = safely;
    // Keep this code as terse and as close to vanila JS as possible. If we
    // arrived here, it means we should trust no one and need to act properly.
    function _burst_into_flames(error) {
        // Make box
        const box = document.createElement("div");
        box.style.backgroundColor = "#f2dede";
        box.style.border = "1px solid #a94442";
        box.style.borderRadius = "4px";
        box.style.display = "inline-block";
        box.style.fontFamily = "sans-serif";
        box.style.marginTop = "5px";
        box.style.minWidth = "200px";
        box.style.padding = "5px 5px 5px 10px";
        box.classList.add("bokeh-error-box-into-flames");
        // Make button
        const button = document.createElement("span");
        button.style.backgroundColor = "#a94442";
        button.style.borderRadius = "0px 4px 0px 0px";
        button.style.color = "white";
        button.style.cursor = "pointer";
        button.style.cssFloat = "right";
        button.style.fontSize = "0.8em";
        button.style.margin = "-6px -6px 0px 0px";
        button.style.padding = "2px 5px 4px 5px";
        button.title = "close";
        button.setAttribute("aria-label", "close");
        button.appendChild(document.createTextNode("x"));
        button.addEventListener("click", () => body.removeChild(box));
        // Make title
        const title = document.createElement("h3");
        title.style.color = "#a94442";
        title.style.margin = "8px 0px 0px 0px";
        title.style.padding = "0px";
        title.appendChild(document.createTextNode("Bokeh Error"));
        // Make message
        const message = document.createElement("pre");
        message.style.whiteSpace = "unset";
        message.style.overflowX = "auto";
        message.appendChild(document.createTextNode(error));
        // Add pieces to box
        box.appendChild(button);
        box.appendChild(title);
        box.appendChild(message);
        // Put box in doc
        const body = document.getElementsByTagName("body")[0];
        body.insertBefore(box, body.firstChild);
    }
    function safely(fn, silent = false) {
        try {
            return fn();
        }
        catch (error) {
            const text = error instanceof Error && error.stack != null ? error.stack : `${error}`;
            _burst_into_flames(text);
            if (!silent) {
                throw error;
            }
            else {
                return;
            }
        }
    }
},
/* models/main.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const base_1 = require(7) /* ../base */;
    const AllModels = tslib_1.__importStar(require(77) /* ./ */);
    (0, base_1.register_models)(AllModels);
    const DOMModels = tslib_1.__importStar(require(547) /* ./dom */);
    (0, base_1.register_models)(DOMModels);
},
/* models/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    tslib_1.__exportStar(require(78) /* ./annotations */, exports);
    tslib_1.__exportStar(require(266) /* ./axes */, exports);
    tslib_1.__exportStar(require(319) /* ./callbacks */, exports);
    tslib_1.__exportStar(require(329) /* ./canvas */, exports);
    tslib_1.__exportStar(require(334) /* ./comparisons */, exports);
    tslib_1.__exportStar(require(338) /* ./coordinates */, exports);
    tslib_1.__exportStar(require(339) /* ./expressions */, exports);
    tslib_1.__exportStar(require(348) /* ./filters */, exports);
    tslib_1.__exportStar(require(242) /* ./formatters */, exports);
    tslib_1.__exportStar(require(357) /* ./glyphs */, exports);
    tslib_1.__exportStar(require(401) /* ./graphics */, exports);
    tslib_1.__exportStar(require(402) /* ./graphs */, exports);
    tslib_1.__exportStar(require(406) /* ./grids */, exports);
    tslib_1.__exportStar(require(408) /* ./layouts */, exports);
    tslib_1.__exportStar(require(271) /* ./mappers */, exports);
    tslib_1.__exportStar(require(431) /* ./misc */, exports);
    tslib_1.__exportStar(require(433) /* ./text */, exports);
    tslib_1.__exportStar(require(434) /* ./transforms */, exports);
    tslib_1.__exportStar(require(443) /* ./plots */, exports);
    tslib_1.__exportStar(require(460) /* ./policies */, exports);
    tslib_1.__exportStar(require(461) /* ./random */, exports);
    tslib_1.__exportStar(require(256) /* ./ranges */, exports);
    tslib_1.__exportStar(require(463) /* ./renderers */, exports);
    tslib_1.__exportStar(require(254) /* ./scales */, exports);
    tslib_1.__exportStar(require(466) /* ./selections */, exports);
    tslib_1.__exportStar(require(467) /* ./selectors */, exports);
    tslib_1.__exportStar(require(472) /* ./sources */, exports);
    tslib_1.__exportStar(require(200) /* ./tickers */, exports);
    tslib_1.__exportStar(require(477) /* ./tiles */, exports);
    tslib_1.__exportStar(require(486) /* ./textures */, exports);
    tslib_1.__exportStar(require(490) /* ./ui */, exports);
    tslib_1.__exportStar(require(501) /* ./tools */, exports);
},
/* models/annotations/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var area_visuals_1 = require(79) /* ./area_visuals */;
    __esExport("AreaVisuals", area_visuals_1.AreaVisuals);
    var annotation_1 = require(81) /* ./annotation */;
    __esExport("Annotation", annotation_1.Annotation);
    var arrow_1 = require(126) /* ./arrow */;
    __esExport("Arrow", arrow_1.Arrow);
    var arrow_head_1 = require(168) /* ./arrow_head */;
    __esExport("ArrowHead", arrow_head_1.ArrowHead);
    var arrow_head_2 = require(168) /* ./arrow_head */;
    __esExport("OpenHead", arrow_head_2.OpenHead);
    var arrow_head_3 = require(168) /* ./arrow_head */;
    __esExport("NormalHead", arrow_head_3.NormalHead);
    var arrow_head_4 = require(168) /* ./arrow_head */;
    __esExport("TeeHead", arrow_head_4.TeeHead);
    var arrow_head_5 = require(168) /* ./arrow_head */;
    __esExport("VeeHead", arrow_head_5.VeeHead);
    var base_color_bar_1 = require(170) /* ./base_color_bar */;
    __esExport("BaseColorBar", base_color_bar_1.BaseColorBar);
    var band_1 = require(261) /* ./band */;
    __esExport("Band", band_1.Band);
    var box_annotation_1 = require(263) /* ./box_annotation */;
    __esExport("BoxAnnotation", box_annotation_1.BoxAnnotation);
    __esExport("BoxInteractionHandles", box_annotation_1.BoxInteractionHandles);
    var color_bar_1 = require(265) /* ./color_bar */;
    __esExport("ColorBar", color_bar_1.ColorBar);
    var contour_color_bar_1 = require(281) /* ./contour_color_bar */;
    __esExport("ContourColorBar", contour_color_bar_1.ContourColorBar);
    var label_1 = require(282) /* ./label */;
    __esExport("Label", label_1.Label);
    var label_set_1 = require(283) /* ./label_set */;
    __esExport("LabelSet", label_set_1.LabelSet);
    var legend_1 = require(284) /* ./legend */;
    __esExport("Legend", legend_1.Legend);
    var legend_item_1 = require(285) /* ./legend_item */;
    __esExport("LegendItem", legend_item_1.LegendItem);
    var poly_annotation_1 = require(287) /* ./poly_annotation */;
    __esExport("PolyAnnotation", poly_annotation_1.PolyAnnotation);
    var scale_bar_1 = require(288) /* ./scale_bar */;
    __esExport("ScaleBar", scale_bar_1.ScaleBar);
    var dimensional_1 = require(289) /* ./dimensional */;
    __esExport("Metric", dimensional_1.Metric);
    __esExport("ReciprocalMetric", dimensional_1.ReciprocalMetric);
    __esExport("MetricLength", dimensional_1.MetricLength);
    __esExport("ReciprocalMetricLength", dimensional_1.ReciprocalMetricLength);
    __esExport("ImperialLength", dimensional_1.ImperialLength);
    __esExport("Angular", dimensional_1.Angular);
    var slope_1 = require(290) /* ./slope */;
    __esExport("Slope", slope_1.Slope);
    var span_1 = require(291) /* ./span */;
    __esExport("Span", span_1.Span);
    var text_annotation_1 = require(172) /* ./text_annotation */;
    __esExport("TextAnnotation", text_annotation_1.TextAnnotation);
    var title_1 = require(171) /* ./title */;
    __esExport("Title", title_1.Title);
    var toolbar_panel_1 = require(292) /* ./toolbar_panel */;
    __esExport("ToolbarPanel", toolbar_panel_1.ToolbarPanel);
    var whisker_1 = require(313) /* ./whisker */;
    __esExport("Whisker", whisker_1.Whisker);
    tslib_1.__exportStar(require(314) /* ./html */, exports);
},
/* models/annotations/area_visuals.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const model_1 = require(51) /* ../../model */;
    const mixins = tslib_1.__importStar(require(80) /* ../../core/property_mixins */);
    class AreaVisuals extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
        clone(attrs) {
            return super.clone(attrs);
        }
    }
    exports.AreaVisuals = AreaVisuals;
    _a = AreaVisuals;
    AreaVisuals.__name__ = "AreaVisuals";
    (() => {
        _a.mixins([
            mixins.Line,
            mixins.Fill,
            mixins.Hatch,
            ["hover_", mixins.Line],
            ["hover_", mixins.Fill],
            ["hover_", mixins.Hatch],
        ]);
    })();
},
/* core/property_mixins.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.attrs_of = attrs_of;
    const tslib_1 = require(1) /* tslib */;
    const p = tslib_1.__importStar(require(19) /* ./properties */);
    const enums_1 = require(21) /* ./enums */;
    const k = tslib_1.__importStar(require(22) /* ./kinds */);
    const object_1 = require(9) /* ./util/object */;
    const types_1 = require(8) /* ./util/types */;
    exports.Line = {
        line_color: [k.Nullable(k.Color), "black"],
        line_alpha: [k.Alpha, 1.0],
        line_width: [k.Float, 1],
        line_join: [enums_1.LineJoin, "bevel"],
        line_cap: [enums_1.LineCap, "butt"],
        line_dash: [k.Or(enums_1.LineDash, k.Array(k.Float)), []],
        line_dash_offset: [k.Float, 0],
    };
    exports.Fill = {
        fill_color: [k.Nullable(k.Color), "gray"],
        fill_alpha: [k.Alpha, 1.0],
    };
    exports.Image = {
        global_alpha: [k.Alpha, 1.0],
    };
    exports.Hatch = {
        hatch_color: [k.Nullable(k.Color), "black"],
        hatch_alpha: [k.Alpha, 1.0],
        hatch_scale: [k.Float, 12.0],
        hatch_pattern: [k.Nullable(k.Or(enums_1.HatchPatternType, k.Str)), null],
        hatch_weight: [k.Float, 1.0],
        hatch_extra: [k.Dict(k.AnyRef()), {}], // XXX: recursive imports
    };
    exports.Text = {
        text_color: [k.Nullable(k.Color), "#444444"],
        text_outline_color: [k.Nullable(k.Color), null],
        text_alpha: [k.Alpha, 1.0],
        text_font: [p.Font, "helvetica"],
        text_font_size: [k.FontSize, "16px"],
        text_font_style: [enums_1.FontStyle, "normal"],
        text_align: [enums_1.TextAlign, "left"],
        text_baseline: [enums_1.TextBaseline, "bottom"],
        text_line_height: [k.Float, 1.2],
    };
    exports.LineScalar = {
        line_color: [p.ColorScalar, "black"],
        line_alpha: [p.NumberScalar, 1.0],
        line_width: [p.NumberScalar, 1],
        line_join: [p.LineJoinScalar, "bevel"],
        line_cap: [p.LineCapScalar, "butt"],
        line_dash: [p.LineDashScalar, []],
        line_dash_offset: [p.NumberScalar, 0],
    };
    exports.FillScalar = {
        fill_color: [p.ColorScalar, "gray"],
        fill_alpha: [p.NumberScalar, 1.0],
    };
    exports.ImageScalar = {
        global_alpha: [p.NumberScalar, 1.0],
    };
    exports.HatchScalar = {
        hatch_color: [p.ColorScalar, "black"],
        hatch_alpha: [p.NumberScalar, 1.0],
        hatch_scale: [p.NumberScalar, 12.0],
        hatch_pattern: [p.NullStringScalar, null],
        hatch_weight: [p.NumberScalar, 1.0],
        hatch_extra: [p.DictScalar, {}],
    };
    exports.TextScalar = {
        text_color: [p.ColorScalar, "#444444"],
        text_outline_color: [p.ColorScalar, null],
        text_alpha: [p.NumberScalar, 1.0],
        text_font: [p.FontScalar, "helvetica"],
        text_font_size: [p.FontSizeScalar, "16px"],
        text_font_style: [p.FontStyleScalar, "normal"],
        text_align: [p.TextAlignScalar, "left"],
        text_baseline: [p.TextBaselineScalar, "bottom"],
        text_line_height: [p.NumberScalar, 1.2],
    };
    exports.LineVector = {
        line_color: [p.ColorSpec, "black"],
        line_alpha: [p.NumberSpec, 1.0],
        line_width: [p.NumberSpec, 1],
        line_join: [p.LineJoinSpec, "bevel"],
        line_cap: [p.LineCapSpec, "butt"],
        line_dash: [p.LineDashSpec, []],
        line_dash_offset: [p.NumberSpec, 0],
    };
    exports.FillVector = {
        fill_color: [p.ColorSpec, "gray"],
        fill_alpha: [p.NumberSpec, 1.0],
    };
    exports.ImageVector = {
        global_alpha: [p.NumberSpec, 1.0],
    };
    exports.HatchVector = {
        hatch_color: [p.ColorSpec, "black"],
        hatch_alpha: [p.NumberSpec, 1.0],
        hatch_scale: [p.NumberSpec, 12.0],
        hatch_pattern: [p.NullStringSpec, null],
        hatch_weight: [p.NumberSpec, 1.0],
        hatch_extra: [p.DictScalar, {}],
    };
    exports.TextVector = {
        text_color: [p.ColorSpec, "#444444"],
        text_outline_color: [p.ColorSpec, null],
        text_alpha: [p.NumberSpec, 1.0],
        text_font: [p.FontSpec, "helvetica"],
        text_font_size: [p.FontSizeSpec, "16px"],
        text_font_style: [p.FontStyleSpec, "normal"],
        text_align: [p.TextAlignSpec, "left"],
        text_baseline: [p.TextBaselineSpec, "bottom"],
        text_line_height: [p.NumberSpec, 1.2],
    };
    function attrs_of(model, prefix, mixin, new_prefix = false) {
        const attrs = {};
        for (const attr of (0, object_1.keys)(mixin)) {
            const prefixed_attr = `${prefix}${attr}`;
            const value = model[prefixed_attr];
            const new_attr = (() => {
                if ((0, types_1.isString)(new_prefix)) {
                    return `${new_prefix}${attr}`;
                }
                else if (new_prefix) {
                    return prefixed_attr;
                }
                else {
                    return attr;
                }
            })();
            attrs[new_attr] = value;
        }
        return attrs;
    }
},
/* models/annotations/annotation.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const composite_renderer_1 = require(82) /* ../renderers/composite_renderer */;
    class AnnotationView extends composite_renderer_1.CompositeRendererView {
        get bbox() {
            return super.bbox ?? this.layout?.bbox;
        }
        get_size() {
            if (this.displayed) {
                const { width, height } = this._get_size();
                return { width: Math.round(width), height: Math.round(height) };
            }
            else {
                return { width: 0, height: 0 };
            }
        }
        _get_size() {
            throw new Error("not implemented");
        }
        connect_signals() {
            super.connect_signals();
            const p = this.model.properties;
            this.on_change(p.visible, () => {
                if (this.layout != null) {
                    this.layout.visible = this.model.visible;
                    this.plot_view.request_layout();
                }
            });
        }
        get needs_clip() {
            return this.layout == null; // TODO: change this, when center layout is fully implemented
        }
    }
    exports.AnnotationView = AnnotationView;
    AnnotationView.__name__ = "AnnotationView";
    class Annotation extends composite_renderer_1.CompositeRenderer {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Annotation = Annotation;
    _a = Annotation;
    Annotation.__name__ = "Annotation";
    (() => {
        _a.override({
            level: "annotation",
        });
    })();
},
/* models/renderers/composite_renderer.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const renderer_1 = require(83) /* ./renderer */;
    const ui_element_1 = require(111) /* ../ui/ui_element */;
    const dom_node_1 = require(125) /* ../dom/dom_node */;
    const build_views_1 = require(56) /* ../../core/build_views */;
    const kinds_1 = require(22) /* ../../core/kinds */;
    // TODO UIElement needs to inherit from DOMNode
    const ElementLike = (0, kinds_1.Or)((0, kinds_1.Ref)(ui_element_1.UIElement), (0, kinds_1.Ref)(dom_node_1.DOMNode));
    class CompositeRendererView extends renderer_1.RendererView {
        constructor() {
            super(...arguments);
            this._renderer_views = new Map();
            this._element_views = new Map();
            this._computed_renderers = [];
            this._computed_elements = [];
            this._has_rendered_elements = false;
        }
        get renderer_views() {
            return this.model.renderers.map((renderer) => this._renderer_views.get(renderer));
        }
        get element_views() {
            return this.model.elements.map((element) => this._element_views.get(element));
        }
        *children() {
            yield* super.children();
            yield* this.renderer_views;
            yield* this.element_views;
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            await this._build_renderers();
            await this._build_elements();
        }
        get computed_renderers() {
            return [...this.model.renderers, ...this._computed_renderers];
        }
        get computed_renderer_views() {
            return this.computed_renderers.map((item) => this._renderer_views.get(item)).filter((rv) => rv != null);
        }
        async _build_renderers() {
            return await (0, build_views_1.build_views)(this._renderer_views, this.computed_renderers, { parent: this.plot_view });
        }
        get computed_elements() {
            return [...this.model.elements, ...this._computed_elements];
        }
        get computed_element_views() {
            return this.computed_elements.map((item) => this._element_views.get(item)).filter((ev) => ev != null);
        }
        async _build_elements() {
            return await (0, build_views_1.build_views)(this._element_views, this.computed_elements, { parent: this.plot_view });
        }
        async _update_renderers() {
            await this._build_renderers();
        }
        async _update_elements() {
            const { created } = await this._build_elements();
            const created_elements = new Set(created);
            // First remove and then either reattach existing elements or render and
            // attach new elements, so that the order of children is consistent, while
            // avoiding expensive re-rendering of existing views.
            for (const element_view of this.element_views) {
                element_view.el.remove();
            }
            for (const element_view of this.element_views) {
                const is_new = created_elements.has(element_view);
                const target = element_view.rendering_target() ?? this.shadow_el;
                if (is_new) {
                    element_view.render_to(target);
                }
                else {
                    target.append(element_view.el);
                }
            }
            this.r_after_render();
        }
        remove() {
            (0, build_views_1.remove_views)(this._renderer_views);
            (0, build_views_1.remove_views)(this._element_views);
            super.remove();
        }
        connect_signals() {
            super.connect_signals();
            const { renderers, elements } = this.model.properties;
            this.on_change(renderers, async () => {
                await this._update_renderers();
            });
            this.on_change(elements, async () => {
                await this._update_elements();
            });
        }
        paint(ctx) {
            if (!this._has_rendered_elements) {
                for (const element_view of this.element_views) {
                    const target = element_view.rendering_target() ?? this.shadow_el;
                    element_view.render_to(target);
                }
                this._has_rendered_elements = true;
            }
            super.paint(ctx);
            if (this.displayed && this.is_renderable) {
                for (const renderer of this.computed_renderer_views) {
                    renderer.paint(ctx);
                }
            }
            const { displayed } = this;
            for (const element_view of this.element_views) {
                element_view.reposition(displayed);
            }
        }
        has_finished() {
            if (!super.has_finished()) {
                return false;
            }
            for (const renderer_view of this.renderer_views) {
                if (!renderer_view.has_finished()) {
                    return false;
                }
            }
            for (const element_view of this.element_views) {
                if (!element_view.has_finished()) {
                    return false;
                }
            }
            return true;
        }
    }
    exports.CompositeRendererView = CompositeRendererView;
    CompositeRendererView.__name__ = "CompositeRendererView";
    class CompositeRenderer extends renderer_1.Renderer {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.CompositeRenderer = CompositeRenderer;
    _a = CompositeRenderer;
    CompositeRenderer.__name__ = "CompositeRenderer";
    (() => {
        _a.define(({ List, Ref }) => ({
            renderers: [List(Ref(renderer_1.Renderer)), []],
            elements: [List(ElementLike), []],
        }));
    })();
},
/* models/renderers/renderer.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const styled_element_1 = require(84) /* ../ui/styled_element */;
    const build_views_1 = require(56) /* ../../core/build_views */;
    const visuals = tslib_1.__importStar(require(87) /* ../../core/visuals */);
    const enums_1 = require(21) /* ../../core/enums */;
    const types_1 = require(8) /* ../../core/util/types */;
    const assert_1 = require(12) /* ../../core/util/assert */;
    const coordinate_mapping_1 = require(95) /* ../coordinates/coordinate_mapping */;
    const menu_1 = require(110) /* ../ui/menus/menu */;
    const renderer_group_1 = require(124) /* ./renderer_group */;
    const dom_1 = require(63) /* ../../core/dom */;
    class RendererView extends styled_element_1.StyledElementView {
        constructor() {
            super(...arguments);
            this._panel = null;
            this.position = new dom_1.InlineStyleSheet("", "position");
            this._context_menu = null;
            this._custom_coordinates = null;
        }
        get panel() {
            return this._panel;
        }
        set panel(panel) {
            this._panel = panel;
        }
        computed_stylesheets() {
            return [...super.computed_stylesheets(), this.position];
        }
        rendering_target() {
            return this.plot_view.canvas_view.underlays_el;
        }
        get context_menu() {
            return this._context_menu;
        }
        get coordinates() {
            const { _coordinates } = this;
            if (_coordinates != null) {
                return _coordinates;
            }
            else {
                return this._coordinates = this._initialize_coordinates();
            }
        }
        set coordinates(custom_coordinates) {
            this._custom_coordinates = custom_coordinates;
        }
        initialize() {
            super.initialize();
            this.visuals = new visuals.Visuals(this);
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            const { context_menu } = this.model;
            if (context_menu != null) {
                this._context_menu = await (0, build_views_1.build_view)(context_menu, { parent: this.plot_view });
            }
        }
        remove() {
            this._context_menu?.remove();
            super.remove();
        }
        connect_signals() {
            super.connect_signals();
            const { group } = this.model;
            if (group != null) {
                this.on_change(group.properties.visible, () => {
                    this.model.visible = group.visible;
                });
            }
            const { x_range_name, y_range_name } = this.model.properties;
            this.on_change([x_range_name, y_range_name], () => delete this._coordinates);
            this.connect(this.plot_view.frame.model.change, () => delete this._coordinates);
        }
        _initialize_coordinates() {
            if (this._custom_coordinates != null) {
                return this._custom_coordinates;
            }
            const { coordinates } = this.model;
            const { frame } = this.plot_view;
            if (coordinates != null) {
                return coordinates.get_transform(frame);
            }
            else {
                const { x_range_name, y_range_name } = this.model;
                const x_scale = frame.x_scales.get(x_range_name);
                const y_scale = frame.y_scales.get(y_range_name);
                (0, assert_1.assert)(x_scale != null, `missing '${x_range_name}' range`);
                (0, assert_1.assert)(y_scale != null, `missing '${y_range_name}' range`);
                return new coordinate_mapping_1.CoordinateTransform(x_scale, y_scale);
            }
        }
        get plot_view() {
            return this.parent;
        }
        get plot_model() {
            return this.parent.model;
        }
        get layer() {
            const { overlays, primary } = this.canvas;
            return this.model.level == "overlay" ? overlays : primary;
        }
        get canvas() {
            return this.plot_view.canvas_view;
        }
        request_paint() {
            this.plot_view.request_paint(this);
        }
        request_layout() {
            this.plot_view.request_layout();
        }
        notify_finished() {
            this.plot_view.notify_finished();
        }
        notify_finished_after_paint() {
            this.plot_view.notify_finished_after_paint();
        }
        get needs_clip() {
            return false;
        }
        get has_webgl() {
            return false;
        }
        /*
        get visible(): boolean {
          const {visible, group} = this.model
          return !visible ? false : (group?.visible ?? true)
        }
        */
        get displayed() {
            return this.model.visible;
        }
        get is_renderable() {
            return true;
        }
        get is_dual_renderer() {
            return false;
        }
        paint(ctx) {
            // It would be better to update geometry (the internal layout) only when
            // necessary, but conditions for that are not clear, so for now update
            // at every paint.
            this.update_geometry();
            this.compute_geometry();
            this.update_position();
            if (this.displayed && this.is_renderable) {
                this._paint(ctx);
            }
            this.mark_finished();
        }
        renderer_view(_renderer) {
            return undefined;
        }
        /**
         * Geometry setup that doesn't change between paints.
         */
        update_geometry() { }
        /**
         * Geometry setup that changes between paints.
         */
        compute_geometry() { }
        /**
         * Updates the position of the associated DOM element.
         */
        update_position() {
            const { bbox, position } = this;
            if (bbox != null && bbox.is_valid) {
                if (this.panel != null) {
                    position.replace(`
        :host {
          position: relative;
          width:    ${bbox.width}px;
          height:   ${bbox.height}px;
        }
        `);
                }
                else {
                    position.replace(`
        :host {
          position: absolute;
          left:     ${bbox.left}px;
          top:      ${bbox.top}px;
          width:    ${bbox.width}px;
          height:   ${bbox.height}px;
        }
        `);
                }
            }
            else {
                position.replace(`
      :host {
        display: none;
      }
      `);
            }
        }
        resolve_frame() {
            return this.plot_view.frame; // TODO CartesianFrameView (PR #13286)
        }
        resolve_canvas() {
            return this.plot_view.canvas;
        }
        resolve_plot() {
            return this.plot_view;
        }
        resolve_symbol(node) {
            const target = this;
            const { bbox } = target;
            if (bbox == null) {
                return { x: NaN, y: NaN };
            }
            else {
                const value = bbox.resolve(node.symbol);
                const { offset } = node;
                if ((0, types_1.isNumber)(value)) {
                    return value + offset;
                }
                else {
                    const { x, y } = value;
                    return { x: x + offset, y: y + offset };
                }
            }
        }
        get attribution() {
            return null;
        }
    }
    exports.RendererView = RendererView;
    RendererView.__name__ = "RendererView";
    class Renderer extends styled_element_1.StyledElement {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Renderer = Renderer;
    _a = Renderer;
    Renderer.__name__ = "Renderer";
    (() => {
        _a.define(({ Bool, Str, Ref, Nullable }) => ({
            group: [Nullable(Ref(renderer_group_1.RendererGroup)), null],
            level: [enums_1.RenderLevel, "image"],
            visible: [Bool, true],
            x_range_name: [Str, "default"],
            y_range_name: [Str, "default"],
            coordinates: [Nullable(Ref(coordinate_mapping_1.CoordinateMapping)), null],
            propagate_hover: [Bool, false],
            context_menu: [Nullable(Ref(menu_1.Menu)), null],
        }));
    })();
},
/* models/ui/styled_element.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const model_1 = require(51) /* ../../model */;
    const node_1 = require(59) /* ../coordinates/node */;
    const styles_1 = require(85) /* ../dom/styles */;
    const stylesheets_1 = require(86) /* ../dom/stylesheets */;
    const dom_view_1 = require(57) /* ../../core/dom_view */;
    const css_1 = require(65) /* ../../core/css */;
    const dom_1 = require(63) /* ../../core/dom */;
    const object_1 = require(9) /* ../../core/util/object */;
    const types_1 = require(8) /* ../../core/util/types */;
    const kinds_1 = require(22) /* ../../core/kinds */;
    exports.StylesLike = (0, kinds_1.Or)((0, kinds_1.Dict)((0, kinds_1.Nullable)(kinds_1.Str)), (0, kinds_1.Ref)(styles_1.Styles)); // TODO: add validation for CSSStyles
    exports.StyleSheets = (0, kinds_1.List)((0, kinds_1.Or)((0, kinds_1.Ref)(stylesheets_1.StyleSheet), kinds_1.Str, (0, kinds_1.Dict)(exports.StylesLike)));
    exports.CSSVariables = (0, kinds_1.Dict)((0, kinds_1.Or)((0, kinds_1.Ref)(node_1.Node), kinds_1.Str));
    class StyledElementView extends dom_view_1.DOMComponentView {
        constructor() {
            super(...arguments);
            /**
             * Computed styles applied to self.
             */
            this.style = new dom_1.InlineStyleSheet("", "style"); // TODO rename to `self_style`
            /**
             * Computed styles append by the parent.
             */
            this.parent_style = new dom_1.InlineStyleSheet("", "parent", true);
        }
        computed_stylesheets() {
            return [...super.computed_stylesheets(), this.style, this.parent_style];
        }
        connect_signals() {
            super.connect_signals();
            const { html_attributes, html_id, styles, css_classes, css_variables, stylesheets } = this.model.properties;
            this.on_change([html_attributes, html_id, css_classes, styles], () => this._apply_html_attributes());
            this.on_transitive_change(css_variables, () => this._apply_html_attributes());
            this.on_transitive_change(stylesheets, () => this._update_stylesheets());
        }
        *_css_classes() {
            yield* super._css_classes();
            yield* this.model.css_classes;
        }
        *_css_variables() {
            yield* super._css_variables();
            for (const [key, val] of (0, object_1.entries)(this.model.css_variables)) {
                if (val instanceof node_1.Node) {
                    const value = this.resolve_coordinate(val);
                    if ((0, types_1.isNumber)(value)) {
                        yield [key, `${value}px`];
                    }
                    else if ((0, types_1.isString)(value)) {
                        yield [key, value];
                    }
                }
                else {
                    yield [key, val];
                }
            }
        }
        user_stylesheets() {
            return [...super.user_stylesheets(), ...this._user_stylesheets()];
        }
        *_user_stylesheets() {
            for (const stylesheet of this.model.stylesheets) {
                if (stylesheet instanceof stylesheets_1.StyleSheet) {
                    yield stylesheet.underlying();
                }
                else {
                    yield new dom_1.InlineStyleSheet(stylesheet);
                }
            }
        }
        _apply_html_attributes() {
            for (const key of this._applied_html_attributes) {
                this.el.removeAttribute(key);
            }
            this._applied_html_attributes = [];
            this._update_css_classes();
            for (const [key, val] of (0, object_1.entries)(this.model.html_attributes)) {
                if (key == "class") {
                    const classes = val.split(/ +/);
                    this._applied_css_classes.push(...classes);
                    this.class_list.add(...classes);
                }
                else {
                    this.el.setAttribute(key, val);
                    this._applied_html_attributes.push(key);
                }
            }
            const id = this.model.html_id;
            if (id != null) {
                this.el.setAttribute("id", id);
                this._applied_html_attributes.push("id");
            }
            this._apply_styles();
            this._update_css_variables();
        }
        _apply_styles() {
            (0, css_1.apply_styles)(this.el.style, this.model.styles);
        }
    }
    exports.StyledElementView = StyledElementView;
    StyledElementView.__name__ = "StyledElementView";
    class StyledElement extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.StyledElement = StyledElement;
    _a = StyledElement;
    StyledElement.__name__ = "StyledElement";
    (() => {
        _a.define({
            html_attributes: [(0, kinds_1.Dict)(kinds_1.Str), {}],
            html_id: [(0, kinds_1.Nullable)(kinds_1.Str), null],
            css_classes: [(0, kinds_1.List)(kinds_1.Str), []],
            css_variables: [exports.CSSVariables, {}],
            styles: [exports.StylesLike, {}],
            stylesheets: [exports.StyleSheets, []],
        });
    })();
},
/* models/dom/styles.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const model_1 = require(51) /* ../../model */;
    class Styles extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Styles = Styles;
    _a = Styles;
    Styles.__name__ = "Styles";
    (() => {
        _a.define(({ Str, Nullable }) => ({
            align_content: [Nullable(Str), null],
            align_items: [Nullable(Str), null],
            align_self: [Nullable(Str), null],
            alignment_baseline: [Nullable(Str), null],
            all: [Nullable(Str), null],
            animation: [Nullable(Str), null],
            animation_delay: [Nullable(Str), null],
            animation_direction: [Nullable(Str), null],
            animation_duration: [Nullable(Str), null],
            animation_fill_mode: [Nullable(Str), null],
            animation_iteration_count: [Nullable(Str), null],
            animation_name: [Nullable(Str), null],
            animation_play_state: [Nullable(Str), null],
            animation_timing_function: [Nullable(Str), null],
            aspect_ratio: [Nullable(Str), null],
            backface_visibility: [Nullable(Str), null],
            background: [Nullable(Str), null],
            background_attachment: [Nullable(Str), null],
            background_clip: [Nullable(Str), null],
            background_color: [Nullable(Str), null],
            background_image: [Nullable(Str), null],
            background_origin: [Nullable(Str), null],
            background_position: [Nullable(Str), null],
            background_position_x: [Nullable(Str), null],
            background_position_y: [Nullable(Str), null],
            background_repeat: [Nullable(Str), null],
            background_size: [Nullable(Str), null],
            baseline_shift: [Nullable(Str), null],
            block_size: [Nullable(Str), null],
            border: [Nullable(Str), null],
            border_block_end: [Nullable(Str), null],
            border_block_end_color: [Nullable(Str), null],
            border_block_end_style: [Nullable(Str), null],
            border_block_end_width: [Nullable(Str), null],
            border_block_start: [Nullable(Str), null],
            border_block_start_color: [Nullable(Str), null],
            border_block_start_style: [Nullable(Str), null],
            border_block_start_width: [Nullable(Str), null],
            border_bottom: [Nullable(Str), null],
            border_bottom_color: [Nullable(Str), null],
            border_bottom_left_radius: [Nullable(Str), null],
            border_bottom_right_radius: [Nullable(Str), null],
            border_bottom_style: [Nullable(Str), null],
            border_bottom_width: [Nullable(Str), null],
            border_collapse: [Nullable(Str), null],
            border_color: [Nullable(Str), null],
            border_image: [Nullable(Str), null],
            border_image_outset: [Nullable(Str), null],
            border_image_repeat: [Nullable(Str), null],
            border_image_slice: [Nullable(Str), null],
            border_image_source: [Nullable(Str), null],
            border_image_width: [Nullable(Str), null],
            border_inline_end: [Nullable(Str), null],
            border_inline_end_color: [Nullable(Str), null],
            border_inline_end_style: [Nullable(Str), null],
            border_inline_end_width: [Nullable(Str), null],
            border_inline_start: [Nullable(Str), null],
            border_inline_start_color: [Nullable(Str), null],
            border_inline_start_style: [Nullable(Str), null],
            border_inline_start_width: [Nullable(Str), null],
            border_left: [Nullable(Str), null],
            border_left_color: [Nullable(Str), null],
            border_left_style: [Nullable(Str), null],
            border_left_width: [Nullable(Str), null],
            border_radius: [Nullable(Str), null],
            border_right: [Nullable(Str), null],
            border_right_color: [Nullable(Str), null],
            border_right_style: [Nullable(Str), null],
            border_right_width: [Nullable(Str), null],
            border_spacing: [Nullable(Str), null],
            border_style: [Nullable(Str), null],
            border_top: [Nullable(Str), null],
            border_top_color: [Nullable(Str), null],
            border_top_left_radius: [Nullable(Str), null],
            border_top_right_radius: [Nullable(Str), null],
            border_top_style: [Nullable(Str), null],
            border_top_width: [Nullable(Str), null],
            border_width: [Nullable(Str), null],
            bottom: [Nullable(Str), null],
            box_shadow: [Nullable(Str), null],
            box_sizing: [Nullable(Str), null],
            break_after: [Nullable(Str), null],
            break_before: [Nullable(Str), null],
            break_inside: [Nullable(Str), null],
            caption_side: [Nullable(Str), null],
            caret_color: [Nullable(Str), null],
            clear: [Nullable(Str), null],
            clip: [Nullable(Str), null],
            clip_path: [Nullable(Str), null],
            clip_rule: [Nullable(Str), null],
            color: [Nullable(Str), null],
            color_interpolation: [Nullable(Str), null],
            color_interpolation_filters: [Nullable(Str), null],
            column_count: [Nullable(Str), null],
            column_fill: [Nullable(Str), null],
            column_gap: [Nullable(Str), null],
            column_rule: [Nullable(Str), null],
            column_rule_color: [Nullable(Str), null],
            column_rule_style: [Nullable(Str), null],
            column_rule_width: [Nullable(Str), null],
            column_span: [Nullable(Str), null],
            column_width: [Nullable(Str), null],
            columns: [Nullable(Str), null],
            content: [Nullable(Str), null],
            counter_increment: [Nullable(Str), null],
            counter_reset: [Nullable(Str), null],
            cursor: [Nullable(Str), null],
            direction: [Nullable(Str), null],
            display: [Nullable(Str), null],
            dominant_baseline: [Nullable(Str), null],
            empty_cells: [Nullable(Str), null],
            fill: [Nullable(Str), null],
            fill_opacity: [Nullable(Str), null],
            fill_rule: [Nullable(Str), null],
            filter: [Nullable(Str), null],
            flex: [Nullable(Str), null],
            flex_basis: [Nullable(Str), null],
            flex_direction: [Nullable(Str), null],
            flex_flow: [Nullable(Str), null],
            flex_grow: [Nullable(Str), null],
            flex_shrink: [Nullable(Str), null],
            flex_wrap: [Nullable(Str), null],
            float: [Nullable(Str), null],
            flood_color: [Nullable(Str), null],
            flood_opacity: [Nullable(Str), null],
            font: [Nullable(Str), null],
            font_family: [Nullable(Str), null],
            font_feature_settings: [Nullable(Str), null],
            font_kerning: [Nullable(Str), null],
            font_size: [Nullable(Str), null],
            font_size_adjust: [Nullable(Str), null],
            font_stretch: [Nullable(Str), null],
            font_style: [Nullable(Str), null],
            font_synthesis: [Nullable(Str), null],
            font_variant: [Nullable(Str), null],
            font_variant_caps: [Nullable(Str), null],
            font_variant_east_asian: [Nullable(Str), null],
            font_variant_ligatures: [Nullable(Str), null],
            font_variant_numeric: [Nullable(Str), null],
            font_variant_position: [Nullable(Str), null],
            font_weight: [Nullable(Str), null],
            gap: [Nullable(Str), null],
            glyph_orientation_vertical: [Nullable(Str), null],
            grid: [Nullable(Str), null],
            grid_area: [Nullable(Str), null],
            grid_auto_columns: [Nullable(Str), null],
            grid_auto_flow: [Nullable(Str), null],
            grid_auto_rows: [Nullable(Str), null],
            grid_column: [Nullable(Str), null],
            grid_column_end: [Nullable(Str), null],
            grid_column_gap: [Nullable(Str), null],
            grid_column_start: [Nullable(Str), null],
            grid_gap: [Nullable(Str), null],
            grid_row: [Nullable(Str), null],
            grid_row_end: [Nullable(Str), null],
            grid_row_gap: [Nullable(Str), null],
            grid_row_start: [Nullable(Str), null],
            grid_template: [Nullable(Str), null],
            grid_template_areas: [Nullable(Str), null],
            grid_template_columns: [Nullable(Str), null],
            grid_template_rows: [Nullable(Str), null],
            height: [Nullable(Str), null],
            hyphens: [Nullable(Str), null],
            image_orientation: [Nullable(Str), null],
            image_rendering: [Nullable(Str), null],
            inline_size: [Nullable(Str), null],
            justify_content: [Nullable(Str), null],
            justify_items: [Nullable(Str), null],
            justify_self: [Nullable(Str), null],
            left: [Nullable(Str), null],
            letter_spacing: [Nullable(Str), null],
            lighting_color: [Nullable(Str), null],
            line_break: [Nullable(Str), null],
            line_height: [Nullable(Str), null],
            list_style: [Nullable(Str), null],
            list_style_image: [Nullable(Str), null],
            list_style_position: [Nullable(Str), null],
            list_style_type: [Nullable(Str), null],
            margin: [Nullable(Str), null],
            margin_block_end: [Nullable(Str), null],
            margin_block_start: [Nullable(Str), null],
            margin_bottom: [Nullable(Str), null],
            margin_inline_end: [Nullable(Str), null],
            margin_inline_start: [Nullable(Str), null],
            margin_left: [Nullable(Str), null],
            margin_right: [Nullable(Str), null],
            margin_top: [Nullable(Str), null],
            marker: [Nullable(Str), null],
            marker_end: [Nullable(Str), null],
            marker_mid: [Nullable(Str), null],
            marker_start: [Nullable(Str), null],
            mask: [Nullable(Str), null],
            mask_composite: [Nullable(Str), null],
            mask_image: [Nullable(Str), null],
            mask_position: [Nullable(Str), null],
            mask_repeat: [Nullable(Str), null],
            mask_size: [Nullable(Str), null],
            mask_type: [Nullable(Str), null],
            max_block_size: [Nullable(Str), null],
            max_height: [Nullable(Str), null],
            max_inline_size: [Nullable(Str), null],
            max_width: [Nullable(Str), null],
            min_block_size: [Nullable(Str), null],
            min_height: [Nullable(Str), null],
            min_inline_size: [Nullable(Str), null],
            min_width: [Nullable(Str), null],
            object_fit: [Nullable(Str), null],
            object_position: [Nullable(Str), null],
            opacity: [Nullable(Str), null],
            order: [Nullable(Str), null],
            orphans: [Nullable(Str), null],
            outline: [Nullable(Str), null],
            outline_color: [Nullable(Str), null],
            outline_offset: [Nullable(Str), null],
            outline_style: [Nullable(Str), null],
            outline_width: [Nullable(Str), null],
            overflow: [Nullable(Str), null],
            overflow_anchor: [Nullable(Str), null],
            overflow_wrap: [Nullable(Str), null],
            overflow_x: [Nullable(Str), null],
            overflow_y: [Nullable(Str), null],
            overscroll_behavior: [Nullable(Str), null],
            overscroll_behavior_block: [Nullable(Str), null],
            overscroll_behavior_inline: [Nullable(Str), null],
            overscroll_behavior_x: [Nullable(Str), null],
            overscroll_behavior_y: [Nullable(Str), null],
            padding: [Nullable(Str), null],
            padding_block_end: [Nullable(Str), null],
            padding_block_start: [Nullable(Str), null],
            padding_bottom: [Nullable(Str), null],
            padding_inline_end: [Nullable(Str), null],
            padding_inline_start: [Nullable(Str), null],
            padding_left: [Nullable(Str), null],
            padding_right: [Nullable(Str), null],
            padding_top: [Nullable(Str), null],
            page_break_after: [Nullable(Str), null],
            page_break_before: [Nullable(Str), null],
            page_break_inside: [Nullable(Str), null],
            paint_order: [Nullable(Str), null],
            perspective: [Nullable(Str), null],
            perspective_origin: [Nullable(Str), null],
            place_content: [Nullable(Str), null],
            place_items: [Nullable(Str), null],
            place_self: [Nullable(Str), null],
            pointer_events: [Nullable(Str), null],
            position: [Nullable(Str), null],
            quotes: [Nullable(Str), null],
            resize: [Nullable(Str), null],
            right: [Nullable(Str), null],
            rotate: [Nullable(Str), null],
            row_gap: [Nullable(Str), null],
            ruby_align: [Nullable(Str), null],
            ruby_position: [Nullable(Str), null],
            scale: [Nullable(Str), null],
            scroll_behavior: [Nullable(Str), null],
            shape_rendering: [Nullable(Str), null],
            stop_color: [Nullable(Str), null],
            stop_opacity: [Nullable(Str), null],
            stroke: [Nullable(Str), null],
            stroke_dasharray: [Nullable(Str), null],
            stroke_dashoffset: [Nullable(Str), null],
            stroke_linecap: [Nullable(Str), null],
            stroke_linejoin: [Nullable(Str), null],
            stroke_miterlimit: [Nullable(Str), null],
            stroke_opacity: [Nullable(Str), null],
            stroke_width: [Nullable(Str), null],
            tab_size: [Nullable(Str), null],
            table_layout: [Nullable(Str), null],
            text_align: [Nullable(Str), null],
            text_align_last: [Nullable(Str), null],
            text_anchor: [Nullable(Str), null],
            text_combine_upright: [Nullable(Str), null],
            text_decoration: [Nullable(Str), null],
            text_decoration_color: [Nullable(Str), null],
            text_decoration_line: [Nullable(Str), null],
            text_decoration_style: [Nullable(Str), null],
            text_emphasis: [Nullable(Str), null],
            text_emphasis_color: [Nullable(Str), null],
            text_emphasis_position: [Nullable(Str), null],
            text_emphasis_style: [Nullable(Str), null],
            text_indent: [Nullable(Str), null],
            text_justify: [Nullable(Str), null],
            text_orientation: [Nullable(Str), null],
            text_overflow: [Nullable(Str), null],
            text_rendering: [Nullable(Str), null],
            text_shadow: [Nullable(Str), null],
            text_transform: [Nullable(Str), null],
            text_underline_position: [Nullable(Str), null],
            top: [Nullable(Str), null],
            touch_action: [Nullable(Str), null],
            transform: [Nullable(Str), null],
            transform_box: [Nullable(Str), null],
            transform_origin: [Nullable(Str), null],
            transform_style: [Nullable(Str), null],
            transition: [Nullable(Str), null],
            transition_delay: [Nullable(Str), null],
            transition_duration: [Nullable(Str), null],
            transition_property: [Nullable(Str), null],
            transition_timing_function: [Nullable(Str), null],
            translate: [Nullable(Str), null],
            unicode_bidi: [Nullable(Str), null],
            user_select: [Nullable(Str), null],
            vertical_align: [Nullable(Str), null],
            visibility: [Nullable(Str), null],
            white_space: [Nullable(Str), null],
            widows: [Nullable(Str), null],
            width: [Nullable(Str), null],
            will_change: [Nullable(Str), null],
            word_break: [Nullable(Str), null],
            word_spacing: [Nullable(Str), null],
            word_wrap: [Nullable(Str), null],
            writing_mode: [Nullable(Str), null],
            z_index: [Nullable(Str), null],
        }));
    })();
},
/* models/dom/stylesheets.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a, _b;
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const model_1 = require(51) /* ../../model */;
    const dom = tslib_1.__importStar(require(63) /* ../../core/dom */);
    class StyleSheet extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.StyleSheet = StyleSheet;
    StyleSheet.__name__ = "StyleSheet";
    class InlineStyleSheet extends StyleSheet {
        constructor(attrs) {
            super(attrs);
        }
        underlying() {
            return new dom.InlineStyleSheet(this.css);
        }
    }
    exports.InlineStyleSheet = InlineStyleSheet;
    _a = InlineStyleSheet;
    InlineStyleSheet.__name__ = "InlineStyleSheet";
    (() => {
        _a.define(({ Str }) => ({
            css: [Str],
        }));
    })();
    class ImportedStyleSheet extends StyleSheet {
        constructor(attrs) {
            super(attrs);
        }
        underlying() {
            return new dom.ImportedStyleSheet(this.url);
        }
    }
    exports.ImportedStyleSheet = ImportedStyleSheet;
    _b = ImportedStyleSheet;
    ImportedStyleSheet.__name__ = "ImportedStyleSheet";
    (() => {
        _b.define(({ Str }) => ({
            url: [Str],
        }));
    })();
    class GlobalInlineStyleSheet extends InlineStyleSheet {
        constructor(attrs) {
            super(attrs);
            this._underlying = null;
        }
        underlying() {
            if (this._underlying == null) {
                this._underlying = new dom.GlobalInlineStyleSheet(this.css);
            }
            return this._underlying;
        }
    }
    exports.GlobalInlineStyleSheet = GlobalInlineStyleSheet;
    GlobalInlineStyleSheet.__name__ = "GlobalInlineStyleSheet";
    class GlobalImportedStyleSheet extends ImportedStyleSheet {
        constructor(attrs) {
            super(attrs);
            this._underlying = null;
        }
        underlying() {
            if (this._underlying == null) {
                this._underlying = new dom.GlobalImportedStyleSheet(this.url);
            }
            return this._underlying;
        }
    }
    exports.GlobalImportedStyleSheet = GlobalImportedStyleSheet;
    GlobalImportedStyleSheet.__name__ = "GlobalImportedStyleSheet";
},
/* core/visuals/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const line_1 = require(88) /* ./line */;
    __esExport("Line", line_1.Line);
    __esExport("LineScalar", line_1.LineScalar);
    __esExport("LineVector", line_1.LineVector);
    const fill_1 = require(90) /* ./fill */;
    __esExport("Fill", fill_1.Fill);
    __esExport("FillScalar", fill_1.FillScalar);
    __esExport("FillVector", fill_1.FillVector);
    const text_1 = require(91) /* ./text */;
    __esExport("Text", text_1.Text);
    __esExport("TextScalar", text_1.TextScalar);
    __esExport("TextVector", text_1.TextVector);
    const hatch_1 = require(92) /* ./hatch */;
    __esExport("Hatch", hatch_1.Hatch);
    __esExport("HatchScalar", hatch_1.HatchScalar);
    __esExport("HatchVector", hatch_1.HatchVector);
    const image_1 = require(94) /* ./image */;
    __esExport("Image", image_1.Image);
    __esExport("ImageScalar", image_1.ImageScalar);
    __esExport("ImageVector", image_1.ImageVector);
    const mixins = tslib_1.__importStar(require(80) /* ../property_mixins */);
    const visual_1 = require(89) /* ./visual */;
    __esExport("VisualProperties", visual_1.VisualProperties);
    __esExport("VisualUniforms", visual_1.VisualUniforms);
    class Visuals {
        *[Symbol.iterator]() {
            yield* this._visuals;
        }
        constructor(view) {
            this._visuals = [];
            for (const [prefix, mixin] of view.model._mixins) {
                const visual = (() => {
                    switch (mixin) {
                        case mixins.Line: return new line_1.Line(view, prefix);
                        case mixins.LineScalar: return new line_1.LineScalar(view, prefix);
                        case mixins.LineVector: return new line_1.LineVector(view, prefix);
                        case mixins.Fill: return new fill_1.Fill(view, prefix);
                        case mixins.FillScalar: return new fill_1.FillScalar(view, prefix);
                        case mixins.FillVector: return new fill_1.FillVector(view, prefix);
                        case mixins.Text: return new text_1.Text(view, prefix);
                        case mixins.TextScalar: return new text_1.TextScalar(view, prefix);
                        case mixins.TextVector: return new text_1.TextVector(view, prefix);
                        case mixins.Hatch: return new hatch_1.Hatch(view, prefix);
                        case mixins.HatchScalar: return new hatch_1.HatchScalar(view, prefix);
                        case mixins.HatchVector: return new hatch_1.HatchVector(view, prefix);
                        case mixins.Image: return new image_1.Image(view, prefix);
                        case mixins.ImageScalar: return new image_1.ImageScalar(view, prefix);
                        case mixins.ImageVector: return new image_1.ImageVector(view, prefix);
                        default:
                            throw new Error("unknown visual");
                    }
                })();
                if (visual instanceof visual_1.VisualProperties) {
                    visual.update();
                }
                this._visuals.push(visual);
                Object.defineProperty(this, prefix + visual.type, {
                    get() {
                        return visual;
                    },
                    configurable: false,
                    enumerable: true,
                });
            }
        }
    }
    exports.Visuals = Visuals;
    Visuals.__name__ = "Visuals";
},
/* core/visuals/line.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.resolve_line_dash = resolve_line_dash;
    const tslib_1 = require(1) /* tslib */;
    const visual_1 = require(89) /* ./visual */;
    const mixins = tslib_1.__importStar(require(80) /* ../property_mixins */);
    const enums_1 = require(21) /* ../enums */;
    const color_1 = require(23) /* ../util/color */;
    const types_1 = require(8) /* ../util/types */;
    function resolve_line_dash(line_dash) {
        if ((0, types_1.isArray)(line_dash)) {
            return line_dash;
        }
        else {
            switch (line_dash) {
                case "solid": return [];
                case "dashed": return [6];
                case "dotted": return [2, 4];
                case "dotdash": return [2, 4, 6, 4];
                case "dashdot": return [6, 4, 2, 4];
                default:
                    return line_dash.split(" ").map(Number).filter(types_1.isInteger);
            }
        }
    }
    class Line extends visual_1.VisualProperties {
        get doit() {
            const color = this.get_line_color();
            const alpha = this.get_line_alpha();
            const width = this.get_line_width();
            return !(color == null || alpha == 0 || width == 0);
        }
        apply(ctx, path) {
            const { doit } = this;
            if (doit) {
                this.set_value(ctx);
                if (path != null) {
                    ctx.stroke(path);
                }
                else {
                    ctx.stroke();
                }
            }
            return doit;
        }
        values() {
            return {
                color: this.get_line_color(),
                alpha: this.get_line_alpha(),
                width: this.get_line_width(),
                join: this.get_line_join(),
                cap: this.get_line_cap(),
                dash: this.get_line_dash(),
                offset: this.get_line_dash_offset(),
            };
        }
        computed_values() {
            const color = this.get_line_color();
            const alpha = this.get_line_alpha();
            return {
                color: (0, color_1.color2css)(color, alpha),
                width: this.get_line_width(),
                join: this.get_line_join(),
                cap: this.get_line_cap(),
                dash: this.get_line_dash(),
                offset: this.get_line_dash_offset(),
            };
        }
        set_value(ctx) {
            const { color, width, join, cap, dash, offset } = this.computed_values();
            ctx.strokeStyle = color;
            ctx.lineWidth = width;
            ctx.lineJoin = join;
            ctx.lineCap = cap;
            ctx.setLineDash(resolve_line_dash(dash));
            ctx.lineDashOffset = offset;
        }
        get_line_color() {
            const css_color = this._get_css_value("line-color");
            if (css_color != "") {
                return css_color;
            }
            return this.line_color.get_value();
        }
        get_line_alpha() {
            const css_alpha = this._get_css_value("line-alpha");
            if (css_alpha != "") {
                const alpha = Number(css_alpha);
                if (isFinite(alpha)) {
                    return alpha;
                }
            }
            return this.line_alpha.get_value();
        }
        get_line_width() {
            const css_width = this._get_css_value("line-width");
            if (css_width != "") {
                const width = Number(css_width);
                if (isFinite(width)) {
                    return width;
                }
            }
            return this.line_width.get_value();
        }
        get_line_join() {
            const css_join = this._get_css_value("line-join");
            if (enums_1.LineJoin.valid(css_join)) {
                return css_join;
            }
            return this.line_join.get_value();
        }
        get_line_cap() {
            const css_cap = this._get_css_value("line-cap");
            if (enums_1.LineCap.valid(css_cap)) {
                return css_cap;
            }
            return this.line_cap.get_value();
        }
        get_line_dash() {
            const css_dash = this._get_css_value("line-dash");
            if (enums_1.LineDash.valid(css_dash)) {
                return css_dash;
            }
            return this.line_dash.get_value();
        }
        get_line_dash_offset() {
            const css_dash_offset = this._get_css_value("line-dash-offset");
            if (css_dash_offset != "") {
                const dash_offset = Number(css_dash_offset);
                if (isFinite(dash_offset)) {
                    return dash_offset;
                }
            }
            return this.line_dash_offset.get_value();
        }
    }
    exports.Line = Line;
    Line.__name__ = "Line";
    class LineScalar extends visual_1.VisualUniforms {
        get doit() {
            const color = this.line_color.value;
            const alpha = this.line_alpha.value;
            const width = this.line_width.value;
            return !(color == 0 || alpha == 0 || width == 0);
        }
        apply(ctx, path) {
            const { doit } = this;
            if (doit) {
                this.set_value(ctx);
                if (path != null) {
                    ctx.stroke(path);
                }
                else {
                    ctx.stroke();
                }
            }
            return doit;
        }
        values() {
            return {
                color: this.line_color.value,
                alpha: this.line_alpha.value,
                width: this.line_width.value,
                join: this.line_join.value,
                cap: this.line_cap.value,
                dash: this.line_dash.value,
                offset: this.line_dash_offset.value,
            };
        }
        set_value(ctx) {
            const color = this.line_color.value;
            const alpha = this.line_alpha.value;
            ctx.strokeStyle = (0, color_1.color2css)(color, alpha);
            ctx.lineWidth = this.line_width.value;
            ctx.lineJoin = this.line_join.value;
            ctx.lineCap = this.line_cap.value;
            ctx.setLineDash(resolve_line_dash(this.line_dash.value));
            ctx.lineDashOffset = this.line_dash_offset.value;
        }
    }
    exports.LineScalar = LineScalar;
    LineScalar.__name__ = "LineScalar";
    class LineVector extends visual_1.VisualUniforms {
        get doit() {
            const { line_color } = this;
            if (line_color.is_Scalar() && line_color.value == 0) {
                return false;
            }
            const { line_alpha } = this;
            if (line_alpha.is_Scalar() && line_alpha.value == 0) {
                return false;
            }
            const { line_width } = this;
            if (line_width.is_Scalar() && line_width.value == 0) {
                return false;
            }
            return true;
        }
        v_doit(i) {
            if (this.line_color.get(i) == 0) {
                return false;
            }
            if (this.line_alpha.get(i) == 0) {
                return false;
            }
            if (this.line_width.get(i) == 0) {
                return false;
            }
            return true;
        }
        apply(ctx, i, path) {
            const doit = this.v_doit(i);
            if (doit) {
                this.set_vectorize(ctx, i);
                if (path != null) {
                    ctx.stroke(path);
                }
                else {
                    ctx.stroke();
                }
            }
            return doit;
        }
        values(i) {
            return {
                color: this.line_color.get(i),
                alpha: this.line_alpha.get(i),
                width: this.line_width.get(i),
                join: this.line_join.get(i),
                cap: this.line_cap.get(i),
                dash: this.line_dash.get(i),
                offset: this.line_dash_offset.get(i),
            };
        }
        set_vectorize(ctx, i) {
            const color = this.line_color.get(i);
            const alpha = this.line_alpha.get(i);
            const width = this.line_width.get(i);
            const join = this.line_join.get(i);
            const cap = this.line_cap.get(i);
            const dash = this.line_dash.get(i);
            const offset = this.line_dash_offset.get(i);
            ctx.strokeStyle = (0, color_1.color2css)(color, alpha);
            ctx.lineWidth = width;
            ctx.lineJoin = join;
            ctx.lineCap = cap;
            ctx.setLineDash(resolve_line_dash(dash));
            ctx.lineDashOffset = offset;
        }
    }
    exports.LineVector = LineVector;
    LineVector.__name__ = "LineVector";
    Line.prototype.type = "line";
    Line.prototype.attrs = Object.keys(mixins.Line);
    LineScalar.prototype.type = "line";
    LineScalar.prototype.attrs = Object.keys(mixins.LineScalar);
    LineVector.prototype.type = "line";
    LineVector.prototype.attrs = Object.keys(mixins.LineVector);
},
/* core/visuals/visual.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const global_css_prefix = "--bk-";
    class VisualProperties {
        *[Symbol.iterator]() {
            yield* this._props;
        }
        constructor(obj, prefix = "") {
            this.obj = obj;
            this.prefix = prefix;
            this.css_prefix = `${global_css_prefix}${prefix.replaceAll("_", "-")}`;
            const self = this;
            this._props = [];
            for (const attr of this.attrs) {
                const prop = obj.model.properties[prefix + attr];
                prop.change.connect(() => this.update());
                self[attr] = prop;
                this._props.push(prop);
            }
        }
        update() { }
        _get_css_value(name) {
            const style = getComputedStyle(this.obj.el);
            return style.getPropertyValue(`${this.css_prefix}${name}`);
        }
    }
    exports.VisualProperties = VisualProperties;
    VisualProperties.__name__ = "VisualProperties";
    class VisualUniforms {
        *[Symbol.iterator]() {
            for (const attr of this.attrs) {
                yield this.obj.model.properties[this.prefix + attr];
            }
        }
        constructor(obj, prefix = "") {
            this.obj = obj;
            this.prefix = prefix;
            for (const attr of this.attrs) {
                Object.defineProperty(this, attr, {
                    get() {
                        return obj[prefix + attr];
                    },
                });
            }
        }
        update() { }
    }
    exports.VisualUniforms = VisualUniforms;
    VisualUniforms.__name__ = "VisualUniforms";
},
/* core/visuals/fill.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const visual_1 = require(89) /* ./visual */;
    const mixins = tslib_1.__importStar(require(80) /* ../property_mixins */);
    const color_1 = require(23) /* ../util/color */;
    class Fill extends visual_1.VisualProperties {
        get doit() {
            const color = this.get_fill_color();
            const alpha = this.get_fill_alpha();
            return !(color == null || alpha == 0);
        }
        apply(ctx, path_or_rule, rule = "nonzero") {
            const { doit } = this;
            if (doit) {
                this.set_value(ctx);
                if (path_or_rule instanceof Path2D) {
                    const path = path_or_rule;
                    ctx.fill(path, rule);
                }
                else {
                    ctx.fill(path_or_rule ?? rule);
                }
            }
            return doit;
        }
        values() {
            return {
                color: this.get_fill_color(),
                alpha: this.get_fill_alpha(),
            };
        }
        computed_values() {
            const color = this.get_fill_color();
            const alpha = this.get_fill_alpha();
            return {
                color: (0, color_1.color2css)(color, alpha),
            };
        }
        set_value(ctx) {
            const { color } = this.computed_values();
            ctx.fillStyle = color;
        }
        get_fill_color() {
            const css_color = this._get_css_value("fill-color");
            if (css_color != "") {
                return css_color;
            }
            return this.fill_color.get_value();
        }
        get_fill_alpha() {
            const css_alpha = this._get_css_value("fill-alpha");
            if (css_alpha != "") {
                const alpha = Number(css_alpha);
                if (isFinite(alpha)) {
                    return alpha;
                }
            }
            return this.fill_alpha.get_value();
        }
    }
    exports.Fill = Fill;
    Fill.__name__ = "Fill";
    class FillScalar extends visual_1.VisualUniforms {
        get doit() {
            const color = this.fill_color.value;
            const alpha = this.fill_alpha.value;
            return !(color == 0 || alpha == 0);
        }
        apply(ctx, path_or_rule, rule = "nonzero") {
            const { doit } = this;
            if (doit) {
                this.set_value(ctx);
                if (path_or_rule instanceof Path2D) {
                    const path = path_or_rule;
                    ctx.fill(path, rule);
                }
                else {
                    ctx.fill(path_or_rule ?? rule);
                }
            }
            return doit;
        }
        values() {
            return {
                color: this.fill_color.value,
                alpha: this.fill_alpha.value,
            };
        }
        set_value(ctx) {
            const color = this.fill_color.value;
            const alpha = this.fill_alpha.value;
            ctx.fillStyle = (0, color_1.color2css)(color, alpha);
        }
    }
    exports.FillScalar = FillScalar;
    FillScalar.__name__ = "FillScalar";
    class FillVector extends visual_1.VisualUniforms {
        get doit() {
            const { fill_color } = this;
            if (fill_color.is_Scalar() && fill_color.value == 0) {
                return false;
            }
            const { fill_alpha } = this;
            if (fill_alpha.is_Scalar() && fill_alpha.value == 0) {
                return false;
            }
            return true;
        }
        v_doit(i) {
            if (this.fill_color.get(i) == 0) {
                return false;
            }
            if (this.fill_alpha.get(i) == 0) {
                return false;
            }
            return true;
        }
        apply(ctx, i, path_or_rule, rule = "nonzero") {
            const doit = this.v_doit(i);
            if (doit) {
                this.set_vectorize(ctx, i);
                if (path_or_rule instanceof Path2D) {
                    const path = path_or_rule;
                    ctx.fill(path, rule);
                }
                else {
                    ctx.fill(path_or_rule ?? rule);
                }
            }
            return doit;
        }
        values(i) {
            return {
                color: this.fill_color.get(i),
                alpha: this.fill_alpha.get(i),
            };
        }
        set_vectorize(ctx, i) {
            const color = this.fill_color.get(i);
            const alpha = this.fill_alpha.get(i);
            ctx.fillStyle = (0, color_1.color2css)(color, alpha);
        }
    }
    exports.FillVector = FillVector;
    FillVector.__name__ = "FillVector";
    Fill.prototype.type = "fill";
    Fill.prototype.attrs = Object.keys(mixins.Fill);
    FillScalar.prototype.type = "fill";
    FillScalar.prototype.attrs = Object.keys(mixins.FillScalar);
    FillVector.prototype.type = "fill";
    FillVector.prototype.attrs = Object.keys(mixins.FillVector);
},
/* core/visuals/text.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const visual_1 = require(89) /* ./visual */;
    const mixins = tslib_1.__importStar(require(80) /* ../property_mixins */);
    const enums_1 = require(21) /* ../enums */;
    const color_1 = require(23) /* ../util/color */;
    const _font_cache = new Map();
    function load_font(font, obj) {
        const objs = _font_cache.get(font);
        if (objs == null) {
            const objs = new WeakSet([obj]);
            _font_cache.set(font, objs);
        }
        else if (!objs.has(obj)) {
            objs.add(obj);
        }
        else {
            return;
        }
        const { fonts } = document;
        if (!fonts.check(font)) {
            void fonts.load(font).then(() => obj.request_paint());
        }
    }
    class Text extends visual_1.VisualProperties {
        get doit() {
            const color = this.get_text_color();
            const alpha = this.get_text_alpha();
            return !(color == null || alpha == 0);
        }
        update() {
            if (!this.doit) {
                return;
            }
            const font = this.font_value();
            load_font(font, this.obj);
        }
        values() {
            return {
                color: this.get_text_color(),
                outline_color: this.get_text_outline_color(),
                alpha: this.get_text_alpha(),
                font: this.get_text_font(),
                font_size: this.get_text_font_size(),
                font_style: this.get_text_font_style(),
                align: this.get_text_align(),
                baseline: this.get_text_baseline(),
                line_height: this.get_text_line_height(),
            };
        }
        computed_values() {
            const color = this.get_text_color();
            const outline_color = this.get_text_outline_color();
            const alpha = this.get_text_alpha();
            return {
                color: (0, color_1.color2css)(color, alpha),
                outline_color: (0, color_1.color2css)(outline_color, alpha),
                font: this.font_value(),
                text_align: this.get_text_align(),
                text_baseline: this.get_text_baseline(),
                line_height: this.get_text_line_height(),
            };
        }
        set_value(ctx) {
            const { color, outline_color, font, text_align, text_baseline, } = this.computed_values();
            ctx.fillStyle = color;
            ctx.strokeStyle = outline_color;
            ctx.font = font;
            ctx.textAlign = text_align;
            ctx.textBaseline = text_baseline;
        }
        font_value() {
            const style = this.get_text_font_style();
            const size = this.get_text_font_size();
            const face = this.get_text_font();
            return `${style} ${size} ${face}`;
        }
        get_text_color() {
            const css_color = this._get_css_value("text-color");
            if (css_color != "") {
                return css_color;
            }
            return this.text_color.get_value();
        }
        get_text_outline_color() {
            const css_color = this._get_css_value("text-outline-color");
            if (css_color != "") {
                return css_color;
            }
            return this.text_outline_color.get_value();
        }
        get_text_alpha() {
            const css_alpha = this._get_css_value("text-alpha");
            if (css_alpha != "") {
                const alpha = Number(css_alpha);
                if (isFinite(alpha)) {
                    return alpha;
                }
            }
            return this.text_alpha.get_value();
        }
        get_text_font() {
            const css_font = this._get_css_value("text-font");
            if (css_font != "") {
                return css_font;
            }
            return this.text_font.get_value();
        }
        get_text_font_size() {
            const css_font_size = this._get_css_value("text-font-size");
            if (css_font_size != "") {
                return css_font_size;
            }
            return this.text_font_size.get_value();
        }
        get_text_font_style() {
            const css_font_style = this._get_css_value("text-font-style");
            if (enums_1.FontStyle.valid(css_font_style)) {
                return css_font_style;
            }
            return this.text_font_style.get_value();
        }
        get_text_align() {
            const css_align = this._get_css_value("text-align");
            if (enums_1.TextAlign.valid(css_align)) {
                return css_align;
            }
            return this.text_align.get_value();
        }
        get_text_baseline() {
            const css_baseline = this._get_css_value("text-baseline");
            if (enums_1.TextBaseline.valid(css_baseline)) {
                return css_baseline;
            }
            return this.text_baseline.get_value();
        }
        get_text_line_height() {
            const css_line_height = this._get_css_value("line-height");
            if (css_line_height != "") {
                const line_height = Number(css_line_height);
                if (isFinite(line_height)) {
                    return line_height;
                }
            }
            return this.text_line_height.get_value();
        }
    }
    exports.Text = Text;
    Text.__name__ = "Text";
    class TextScalar extends visual_1.VisualUniforms {
        get doit() {
            const color = this.text_color.value;
            const alpha = this.text_alpha.value;
            return !(color == 0 || alpha == 0);
        }
        update() {
            if (!this.doit) {
                return;
            }
            const font = this.font_value();
            load_font(font, this.obj);
        }
        values() {
            return {
                color: this.text_color.value,
                outline_color: this.text_outline_color.value,
                alpha: this.text_alpha.value,
                font: this.text_font.value,
                font_size: this.text_font_size.value,
                font_style: this.text_font_style.value,
                align: this.text_align.value,
                baseline: this.text_baseline.value,
                line_height: this.text_line_height.value,
            };
        }
        set_value(ctx) {
            const color = this.text_color.value;
            const alpha = this.text_alpha.value;
            const outline_color = this.text_outline_color.value;
            const font = this.font_value();
            const align = this.text_align.value;
            const baseline = this.text_baseline.value;
            ctx.fillStyle = (0, color_1.color2css)(color, alpha);
            ctx.strokeStyle = (0, color_1.color2css)(outline_color, alpha);
            ctx.font = font;
            ctx.textAlign = align;
            ctx.textBaseline = baseline;
        }
        font_value() {
            const style = this.text_font_style.value;
            const size = this.text_font_size.value;
            const face = this.text_font.value;
            return `${style} ${size} ${face}`;
        }
    }
    exports.TextScalar = TextScalar;
    TextScalar.__name__ = "TextScalar";
    class TextVector extends visual_1.VisualUniforms {
        _assert_font(i) {
            const font = this.font_value(i);
            load_font(font, this.obj);
        }
        values(i) {
            this._assert_font(i);
            return {
                color: this.text_color.get(i),
                outline_color: this.text_outline_color.get(i),
                alpha: this.text_alpha.get(i),
                font: this.text_font.get(i),
                font_size: this.text_font_size.get(i),
                font_style: this.text_font_style.get(i),
                align: this.text_align.get(i),
                baseline: this.text_baseline.get(i),
                line_height: this.text_line_height.get(i),
            };
        }
        get doit() {
            const { text_color } = this;
            if (text_color.is_Scalar() && text_color.value == 0) {
                return false;
            }
            const { text_alpha } = this;
            if (text_alpha.is_Scalar() && text_alpha.value == 0) {
                return false;
            }
            return true;
        }
        v_doit(i) {
            if (this.text_color.get(i) == 0) {
                return false;
            }
            if (this.text_alpha.get(i) == 0) {
                return false;
            }
            return true;
        }
        apply(ctx, i) {
            const doit = this.v_doit(i);
            if (doit) {
                this.set_vectorize(ctx, i);
            }
            return doit;
        }
        set_vectorize(ctx, i) {
            this._assert_font(i);
            const color = this.text_color.get(i);
            const outline_color = this.text_outline_color.get(i);
            const alpha = this.text_alpha.get(i);
            const font = this.font_value(i);
            const align = this.text_align.get(i);
            const baseline = this.text_baseline.get(i);
            ctx.fillStyle = (0, color_1.color2css)(color, alpha);
            ctx.strokeStyle = (0, color_1.color2css)(outline_color, alpha);
            ctx.font = font;
            ctx.textAlign = align;
            ctx.textBaseline = baseline;
        }
        font_value(i) {
            const style = this.text_font_style.get(i);
            const size = this.text_font_size.get(i);
            const face = this.text_font.get(i);
            return `${style} ${size} ${face}`;
        }
    }
    exports.TextVector = TextVector;
    TextVector.__name__ = "TextVector";
    Text.prototype.type = "text";
    Text.prototype.attrs = Object.keys(mixins.Text);
    TextScalar.prototype.type = "text";
    TextScalar.prototype.attrs = Object.keys(mixins.TextScalar);
    TextVector.prototype.type = "text";
    TextVector.prototype.attrs = Object.keys(mixins.TextVector);
},
/* core/visuals/hatch.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const visual_1 = require(89) /* ./visual */;
    const patterns_1 = require(93) /* ./patterns */;
    const p = tslib_1.__importStar(require(19) /* ../properties */);
    const mixins = tslib_1.__importStar(require(80) /* ../property_mixins */);
    const object_1 = require(9) /* ../util/object */;
    class Hatch extends visual_1.VisualProperties {
        constructor() {
            super(...arguments);
            this._update_iteration = 0;
        }
        update() {
            this._update_iteration++;
            this._hatch_image = null;
            if (!this.doit) {
                return;
            }
            const color = this.get_hatch_color();
            const alpha = this.get_hatch_alpha();
            const scale = this.get_hatch_scale();
            const pattern = this.get_hatch_pattern();
            const weight = this.get_hatch_weight();
            const finalize = (image) => {
                this._hatch_image = image;
            };
            const textures = (0, object_1.dict)(this.get_hatch_extra());
            const texture = textures.get(pattern);
            if (texture != null) {
                const image = texture.get_pattern(color, alpha, scale, weight);
                if (image instanceof Promise) {
                    const { _update_iteration } = this;
                    void image.then((image) => {
                        if (this._update_iteration == _update_iteration) {
                            finalize(image);
                            this.obj.request_paint();
                        }
                    });
                }
                else {
                    finalize(image);
                }
            }
            else {
                const layer = this.obj.canvas.create_layer();
                const image = (0, patterns_1.get_pattern)(layer, pattern, color, alpha, scale, weight);
                finalize(image);
            }
        }
        get doit() {
            const color = this.get_hatch_color();
            const alpha = this.get_hatch_alpha();
            const pattern = this.get_hatch_pattern();
            return !(color == null || alpha == 0 || pattern == " " || pattern == "blank" || pattern == null);
        }
        apply(ctx, path_or_rule, rule = "nonzero") {
            const { doit } = this;
            if (doit) {
                this.set_value(ctx);
                ctx.layer.undo_transform(() => {
                    if (path_or_rule instanceof Path2D) {
                        const path = path_or_rule;
                        ctx.fill(path, rule);
                    }
                    else {
                        ctx.fill(path_or_rule ?? rule);
                    }
                });
            }
            return doit;
        }
        set_value(ctx) {
            const pattern = this.pattern(ctx);
            ctx.fillStyle = pattern ?? "transparent";
        }
        pattern(ctx) {
            const image = this._hatch_image;
            if (image == null) {
                return null;
            }
            else {
                return ctx.createPattern(image, this.repetition());
            }
        }
        repetition() {
            const pattern = this.get_hatch_pattern();
            const textures = (0, object_1.dict)(this.get_hatch_extra());
            const texture = textures.get(pattern);
            if (texture == null) {
                return "repeat";
            }
            else {
                switch (texture.repetition) {
                    case "repeat": return "repeat";
                    case "repeat_x": return "repeat-x";
                    case "repeat_y": return "repeat-y";
                    case "no_repeat": return "no-repeat";
                }
            }
        }
        get_hatch_color() {
            const css_color = this._get_css_value("hatch-color");
            if (css_color != "") {
                return css_color;
            }
            return this.hatch_color.get_value();
        }
        get_hatch_alpha() {
            const css_alpha = this._get_css_value("hatch-alpha");
            if (css_alpha != "") {
                const alpha = Number(css_alpha);
                if (isFinite(alpha)) {
                    return alpha;
                }
            }
            return this.hatch_alpha.get_value();
        }
        get_hatch_scale() {
            const css_scale = this._get_css_value("hatch-scale");
            if (css_scale != "") {
                const scale = Number(css_scale);
                if (isFinite(scale)) {
                    return scale;
                }
            }
            return this.hatch_scale.get_value();
        }
        get_hatch_pattern() {
            const css_pattern = this._get_css_value("hatch-pattern");
            if (css_pattern != "") {
                if (css_pattern == "none") {
                    return null;
                }
                else {
                    return css_pattern;
                }
            }
            return this.hatch_pattern.get_value();
        }
        get_hatch_weight() {
            const css_weight = this._get_css_value("hatch-weight");
            if (css_weight != "") {
                const weight = Number(css_weight);
                if (isFinite(weight)) {
                    return weight;
                }
            }
            return this.hatch_weight.get_value();
        }
        get_hatch_extra() {
            return this.hatch_extra.get_value();
        }
    }
    exports.Hatch = Hatch;
    Hatch.__name__ = "Hatch";
    class HatchScalar extends visual_1.VisualUniforms {
        constructor() {
            super(...arguments);
            this._static_doit = false;
            this._update_iteration = 0;
        }
        _compute_static_doit() {
            const color = this.hatch_color.value;
            const alpha = this.hatch_alpha.value;
            const pattern = this.hatch_pattern.value;
            return !(color == 0 || alpha == 0 || pattern == " " || pattern == "blank" || pattern == null);
        }
        update() {
            this._update_iteration++;
            const n = this.hatch_color.length;
            this._hatch_image = new p.UniformScalar(null, n);
            this._static_doit = this._compute_static_doit();
            if (!this._static_doit) {
                return;
            }
            const color = this.hatch_color.value;
            const alpha = this.hatch_alpha.value;
            const scale = this.hatch_scale.value;
            const pattern = this.hatch_pattern.value;
            const weight = this.hatch_weight.value;
            const finalize = (image) => {
                this._hatch_image = new p.UniformScalar(image, n);
            };
            const textures = (0, object_1.dict)(this.hatch_extra.value);
            const texture = textures.get(pattern);
            if (texture != null) {
                const image = texture.get_pattern(color, alpha, scale, weight);
                if (image instanceof Promise) {
                    const { _update_iteration } = this;
                    void image.then((image) => {
                        if (this._update_iteration == _update_iteration) {
                            finalize(image);
                            this.obj.request_paint();
                        }
                    });
                }
                else {
                    finalize(image);
                }
            }
            else {
                const layer = this.obj.canvas.create_layer();
                const image = (0, patterns_1.get_pattern)(layer, pattern, color, alpha, scale, weight);
                finalize(image);
            }
        }
        get doit() {
            return this._static_doit;
        }
        apply(ctx, path_or_rule, rule = "nonzero") {
            const { doit } = this;
            if (doit) {
                this.set_value(ctx);
                ctx.layer.undo_transform(() => {
                    if (path_or_rule instanceof Path2D) {
                        const path = path_or_rule;
                        ctx.fill(path, rule);
                    }
                    else {
                        ctx.fill(path_or_rule ?? rule);
                    }
                });
            }
            return doit;
        }
        set_value(ctx) {
            ctx.fillStyle = this.pattern(ctx) ?? "transparent";
        }
        pattern(ctx) {
            const image = this._hatch_image.value;
            if (image == null) {
                return null;
            }
            else {
                return ctx.createPattern(image, this.repetition());
            }
        }
        repetition() {
            const pattern = this.hatch_pattern.value;
            if (pattern != null) {
                const textures = (0, object_1.dict)(this.hatch_extra.value);
                const texture = textures.get(pattern);
                if (texture != null) {
                    switch (texture.repetition) {
                        case "repeat": return "repeat";
                        case "repeat_x": return "repeat-x";
                        case "repeat_y": return "repeat-y";
                        case "no_repeat": return "no-repeat";
                    }
                }
            }
            return "repeat";
        }
    }
    exports.HatchScalar = HatchScalar;
    HatchScalar.__name__ = "HatchScalar";
    class HatchVector extends visual_1.VisualUniforms {
        constructor() {
            super(...arguments);
            this._static_doit = false;
            this._update_iteration = 0;
        }
        _compute_static_doit() {
            const { hatch_color } = this;
            if (hatch_color.is_Scalar() && hatch_color.value == 0) {
                return false;
            }
            const { hatch_alpha } = this;
            if (hatch_alpha.is_Scalar() && hatch_alpha.value == 0) {
                return false;
            }
            const { hatch_pattern } = this;
            if (hatch_pattern.is_Scalar()) {
                const pattern = hatch_pattern.value;
                if (pattern == " " || pattern == "blank" || pattern == null) {
                    return false;
                }
            }
            return true;
        }
        update() {
            this._update_iteration++;
            const n = this.hatch_color.length;
            this._hatch_image = new p.UniformScalar(null, n);
            this._static_doit = this._compute_static_doit();
            if (!this._static_doit) {
                return;
            }
            const resolve_image = (pattern, color, alpha, scale, weight, finalize) => {
                const textures = (0, object_1.dict)(this.hatch_extra.value);
                const texture = textures.get(pattern);
                if (texture != null) {
                    const image = texture.get_pattern(color, alpha, scale, weight);
                    if (image instanceof Promise) {
                        const { _update_iteration } = this;
                        void image.then((image) => {
                            if (this._update_iteration == _update_iteration) {
                                finalize(image);
                                this.obj.request_paint();
                            }
                        });
                    }
                    else {
                        finalize(image);
                    }
                }
                else {
                    const layer = this.obj.canvas.create_layer();
                    const image = (0, patterns_1.get_pattern)(layer, pattern, color, alpha, scale, weight);
                    finalize(image);
                }
            };
            if (this.hatch_color.is_Scalar() &&
                this.hatch_alpha.is_Scalar() &&
                this.hatch_scale.is_Scalar() &&
                this.hatch_pattern.is_Scalar() &&
                this.hatch_weight.is_Scalar()) {
                const color = this.hatch_color.value;
                const alpha = this.hatch_alpha.value;
                const scale = this.hatch_scale.value;
                const pattern = this.hatch_pattern.value;
                const weight = this.hatch_weight.value;
                resolve_image(pattern, color, alpha, scale, weight, (image) => {
                    this._hatch_image = new p.UniformScalar(image, n);
                });
            }
            else {
                const images = new Array(n);
                images.fill(null);
                this._hatch_image = new p.UniformVector(images);
                for (let i = 0; i < n; i++) {
                    const color = this.hatch_color.get(i);
                    const alpha = this.hatch_alpha.get(i);
                    const scale = this.hatch_scale.get(i);
                    const pattern = this.hatch_pattern.get(i);
                    const weight = this.hatch_weight.get(i);
                    resolve_image(pattern, color, alpha, scale, weight, (image) => {
                        images[i] = image;
                    });
                }
            }
        }
        get doit() {
            return this._static_doit;
        }
        v_doit(i) {
            if (!this.doit) {
                return false;
            }
            if (this.hatch_color.get(i) == 0) {
                return false;
            }
            if (this.hatch_alpha.get(i) == 0) {
                return false;
            }
            const pattern = this.hatch_pattern.get(i);
            if (pattern == " " || pattern == "blank" || pattern == null) {
                return false;
            }
            return true;
        }
        apply(ctx, i, path_or_rule, rule = "nonzero") {
            const doit = this.v_doit(i);
            if (doit) {
                this.set_vectorize(ctx, i);
                ctx.layer.undo_transform(() => {
                    if (path_or_rule instanceof Path2D) {
                        const path = path_or_rule;
                        ctx.fill(path, rule);
                    }
                    else {
                        ctx.fill(path_or_rule ?? rule);
                    }
                });
            }
            return doit;
        }
        set_vectorize(ctx, i) {
            ctx.fillStyle = this.pattern(ctx, i) ?? "transparent";
        }
        pattern(ctx, i) {
            const image = this._hatch_image.get(i);
            if (image == null) {
                return null;
            }
            else {
                return ctx.createPattern(image, this.repetition(i));
            }
        }
        repetition(i) {
            const pattern = this.hatch_pattern.get(i);
            if (pattern != null) {
                const textures = (0, object_1.dict)(this.hatch_extra.value);
                const texture = textures.get(pattern);
                if (texture != null) {
                    switch (texture.repetition) {
                        case "repeat": return "repeat";
                        case "repeat_x": return "repeat-x";
                        case "repeat_y": return "repeat-y";
                        case "no_repeat": return "no-repeat";
                    }
                }
            }
            return "repeat";
        }
    }
    exports.HatchVector = HatchVector;
    HatchVector.__name__ = "HatchVector";
    Hatch.prototype.type = "hatch";
    Hatch.prototype.attrs = Object.keys(mixins.Hatch);
    HatchScalar.prototype.type = "hatch";
    HatchScalar.prototype.attrs = Object.keys(mixins.HatchScalar);
    HatchVector.prototype.type = "hatch";
    HatchVector.prototype.attrs = Object.keys(mixins.HatchVector);
},
/* core/visuals/patterns.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.get_pattern = get_pattern;
    const logging_1 = require(20) /* ../logging */;
    const color_1 = require(23) /* ../util/color */;
    function _horz(ctx, h, h2) {
        ctx.moveTo(0, h2 + 0.5);
        ctx.lineTo(h, h2 + 0.5);
        ctx.stroke();
    }
    function _vert(ctx, h, h2) {
        ctx.moveTo(h2 + 0.5, 0);
        ctx.lineTo(h2 + 0.5, h);
        ctx.stroke();
    }
    function _x(ctx, h) {
        ctx.moveTo(0, h);
        ctx.lineTo(h, 0);
        ctx.stroke();
        ctx.moveTo(0, 0);
        ctx.lineTo(h, h);
        ctx.stroke();
    }
    exports.hatch_aliases = {
        " ": "blank",
        ".": "dot",
        o: "ring",
        "-": "horizontal_line",
        "|": "vertical_line",
        "+": "cross",
        "\"": "horizontal_dash",
        ":": "vertical_dash",
        "@": "spiral",
        "/": "right_diagonal_line",
        "\\": "left_diagonal_line",
        x: "diagonal_cross",
        ",": "right_diagonal_dash",
        "`": "left_diagonal_dash",
        v: "horizontal_wave",
        ">": "vertical_wave",
        "*": "criss_cross",
    };
    function get_pattern(layer, pattern, color, alpha, scale, weight) {
        layer.resize(scale, scale);
        layer.prepare();
        create_hatch_canvas(layer.ctx, pattern, color, alpha, scale, weight);
        return layer.canvas;
    }
    function create_hatch_canvas(ctx, hatch_pattern, hatch_color, hatch_alpha, hatch_scale, hatch_weight) {
        const h = hatch_scale;
        const h2 = h / 2;
        const h4 = h2 / 2;
        const color = (0, color_1.color2css)(hatch_color, hatch_alpha);
        ctx.strokeStyle = color;
        ctx.fillStyle = color;
        ctx.lineCap = "square";
        ctx.lineWidth = hatch_weight;
        switch (exports.hatch_aliases[hatch_pattern] ?? hatch_pattern) {
            // we should not need these if code conditions on hatch.doit, but
            // include them here just for completeness
            case "blank":
                break;
            case "dot":
                ctx.arc(h2, h2, h2 / 2, 0, 2 * Math.PI, true);
                ctx.fill();
                break;
            case "ring":
                ctx.arc(h2, h2, h2 / 2, 0, 2 * Math.PI, true);
                ctx.stroke();
                break;
            case "horizontal_line":
                _horz(ctx, h, h2);
                break;
            case "vertical_line":
                _vert(ctx, h, h2);
                break;
            case "cross":
                _horz(ctx, h, h2);
                _vert(ctx, h, h2);
                break;
            case "horizontal_dash":
                _horz(ctx, h2, h2);
                break;
            case "vertical_dash":
                _vert(ctx, h2, h2);
                break;
            case "spiral": {
                const h30 = h / 30;
                ctx.moveTo(h2, h2);
                for (let i = 0; i < 360; i++) {
                    const angle = 0.1 * i;
                    const x = h2 + (h30 * angle) * Math.cos(angle);
                    const y = h2 + (h30 * angle) * Math.sin(angle);
                    ctx.lineTo(x, y);
                }
                ctx.stroke();
                break;
            }
            case "right_diagonal_line":
                ctx.moveTo(-h4 + 0.5, h);
                ctx.lineTo(h4 + 0.5, 0);
                ctx.stroke();
                ctx.moveTo(h4 + 0.5, h);
                ctx.lineTo(3 * h4 + 0.5, 0);
                ctx.stroke();
                ctx.moveTo(3 * h4 + 0.5, h);
                ctx.lineTo(5 * h4 + 0.5, 0);
                ctx.stroke();
                break;
            case "left_diagonal_line":
                ctx.moveTo(h4 + 0.5, h);
                ctx.lineTo(-h4 + 0.5, 0);
                ctx.stroke();
                ctx.moveTo(3 * h4 + 0.5, h);
                ctx.lineTo(h4 + 0.5, 0);
                ctx.stroke();
                ctx.moveTo(5 * h4 + 0.5, h);
                ctx.lineTo(3 * h4 + 0.5, 0);
                ctx.stroke();
                break;
            case "diagonal_cross":
                _x(ctx, h);
                break;
            case "right_diagonal_dash":
                ctx.moveTo(h4 + 0.5, 3 * h4 + 0.5);
                ctx.lineTo(3 * h4 + 0.5, h4 + 0.5);
                ctx.stroke();
                break;
            case "left_diagonal_dash":
                ctx.moveTo(h4 + 0.5, h4 + 0.5);
                ctx.lineTo(3 * h4 + 0.5, 3 * h4 + 0.5);
                ctx.stroke();
                break;
            case "horizontal_wave":
                ctx.moveTo(0, h4);
                ctx.lineTo(h2, 3 * h4);
                ctx.lineTo(h, h4);
                ctx.stroke();
                break;
            case "vertical_wave":
                ctx.moveTo(h4, 0);
                ctx.lineTo(3 * h4, h2);
                ctx.lineTo(h4, h);
                ctx.stroke();
                break;
            case "criss_cross":
                _x(ctx, h);
                _horz(ctx, h, h2);
                _vert(ctx, h, h2);
                break;
            default:
                logging_1.logger.warn(`unknown hatch pattern: ${hatch_pattern}`);
        }
    }
},
/* core/visuals/image.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const visual_1 = require(89) /* ./visual */;
    const mixins = tslib_1.__importStar(require(80) /* ../property_mixins */);
    class Image extends visual_1.VisualProperties {
        get doit() {
            const alpha = this.global_alpha.get_value();
            return !(alpha == 0);
        }
        apply(ctx) {
            const { doit } = this;
            if (doit) {
                this.set_value(ctx);
            }
            return doit;
        }
        values() {
            return {
                global_alpha: this.global_alpha.get_value(),
            };
        }
        set_value(ctx) {
            const alpha = this.global_alpha.get_value();
            ctx.globalAlpha = alpha;
        }
    }
    exports.Image = Image;
    Image.__name__ = "Image";
    class ImageScalar extends visual_1.VisualUniforms {
        get doit() {
            const alpha = this.global_alpha.value;
            return !(alpha == 0);
        }
        apply(ctx) {
            const { doit } = this;
            if (doit) {
                this.set_value(ctx);
            }
            return doit;
        }
        values() {
            return {
                global_alpha: this.global_alpha.value,
            };
        }
        set_value(ctx) {
            const alpha = this.global_alpha.value;
            ctx.globalAlpha = alpha;
        }
    }
    exports.ImageScalar = ImageScalar;
    ImageScalar.__name__ = "ImageScalar";
    class ImageVector extends visual_1.VisualUniforms {
        get doit() {
            const { global_alpha } = this;
            if (global_alpha.is_Scalar() && global_alpha.value == 0) {
                return false;
            }
            return true;
        }
        v_doit(i) {
            if (this.global_alpha.get(i) == 0) {
                return false;
            }
            return true;
        }
        apply(ctx, i) {
            const doit = this.v_doit(i);
            if (doit) {
                this.set_vectorize(ctx, i);
            }
            return doit;
        }
        values(i) {
            return {
                alpha: this.global_alpha.get(i),
            };
        }
        set_vectorize(ctx, i) {
            const alpha = this.global_alpha.get(i);
            ctx.globalAlpha = alpha;
        }
    }
    exports.ImageVector = ImageVector;
    ImageVector.__name__ = "ImageVector";
    Image.prototype.type = "image";
    Image.prototype.attrs = Object.keys(mixins.Image);
    ImageScalar.prototype.type = "image";
    ImageScalar.prototype.attrs = Object.keys(mixins.ImageScalar);
    ImageVector.prototype.type = "image";
    ImageVector.prototype.attrs = Object.keys(mixins.ImageVector);
},
/* models/coordinates/coordinate_mapping.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const model_1 = require(51) /* ../../model */;
    const scale_1 = require(96) /* ../scales/scale */;
    const linear_scale_1 = require(101) /* ../scales/linear_scale */;
    const log_scale_1 = require(103) /* ../scales/log_scale */;
    const categorical_scale_1 = require(104) /* ../scales/categorical_scale */;
    const composite_scale_1 = require(105) /* ../scales/composite_scale */;
    const range_1 = require(98) /* ../ranges/range */;
    const data_range1d_1 = require(106) /* ../ranges/data_range1d */;
    const factor_range_1 = require(109) /* ../ranges/factor_range */;
    class CoordinateTransform {
        constructor(x_scale, y_scale) {
            this.x_scale = x_scale;
            this.y_scale = y_scale;
            this.x_source = this.x_scale.source_range;
            this.y_source = this.y_scale.source_range;
            this.ranges = [this.x_source, this.y_source];
            this.scales = [this.x_scale, this.y_scale];
        }
        map_to_screen(xs, ys) {
            const sxs = this.x_scale.v_compute(xs);
            const sys = this.y_scale.v_compute(ys);
            return [sxs, sys];
        }
        map_from_screen(sxs, sys) {
            const xs = this.x_scale.v_invert(sxs);
            const ys = this.y_scale.v_invert(sys);
            return [xs, ys];
        }
    }
    exports.CoordinateTransform = CoordinateTransform;
    CoordinateTransform.__name__ = "CoordinateTransform";
    class CoordinateMapping extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
        get x_ranges() {
            return new Map([["default", this.x_source]]);
        }
        get y_ranges() {
            return new Map([["default", this.y_source]]);
        }
        _get_scale(range, scale, target) {
            const factor_range = range instanceof factor_range_1.FactorRange;
            const categorical_scale = scale instanceof categorical_scale_1.CategoricalScale;
            if (factor_range != categorical_scale) {
                throw new Error(`Range ${range.type} is incompatible is Scale ${scale.type}`);
            }
            if (scale instanceof log_scale_1.LogScale && range instanceof data_range1d_1.DataRange1d) {
                range.scale_hint = "log";
            }
            const derived_scale = scale.clone();
            derived_scale.setv({ source_range: range, target_range: target });
            return derived_scale;
        }
        get_transform(frame) {
            const { x_source, x_scale, x_target } = this;
            const x_source_scale = this._get_scale(x_source, x_scale, x_target);
            const { y_source, y_scale, y_target } = this;
            const y_source_scale = this._get_scale(y_source, y_scale, y_target);
            const xscale = new composite_scale_1.CompositeScale({
                source_scale: x_source_scale, source_range: x_source_scale.source_range,
                target_scale: frame.x_scale, target_range: frame.x_target,
            });
            const yscale = new composite_scale_1.CompositeScale({
                source_scale: y_source_scale, source_range: y_source_scale.source_range,
                target_scale: frame.y_scale, target_range: frame.y_target,
            });
            return new CoordinateTransform(xscale, yscale);
        }
    }
    exports.CoordinateMapping = CoordinateMapping;
    _a = CoordinateMapping;
    CoordinateMapping.__name__ = "CoordinateMapping";
    (() => {
        _a.define(({ Ref }) => ({
            x_source: [Ref(range_1.Range), () => new data_range1d_1.DataRange1d()],
            y_source: [Ref(range_1.Range), () => new data_range1d_1.DataRange1d()],
            x_scale: [Ref(scale_1.Scale), () => new linear_scale_1.LinearScale()],
            y_scale: [Ref(scale_1.Scale), () => new linear_scale_1.LinearScale()],
            x_target: [Ref(range_1.Range)],
            y_target: [Ref(range_1.Range)],
        }));
    })();
},
/* models/scales/scale.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const transform_1 = require(97) /* ../transforms/transform */;
    const range_1 = require(98) /* ../ranges/range */;
    const range1d_1 = require(99) /* ../ranges/range1d */;
    const types_1 = require(25) /* ../../core/types */;
    class Scale extends transform_1.Transform {
        constructor(attrs) {
            super(attrs);
        }
        compute(x) {
            return this.s_compute(x);
        }
        v_compute(xs) {
            const result = new types_1.ScreenArray(xs.length);
            const { s_compute } = this;
            for (let i = 0; i < xs.length; i++) {
                result[i] = s_compute(xs[i]);
            }
            return result;
        }
        invert(sx) {
            return this.s_invert(sx);
        }
        v_invert(sxs) {
            const result = new Float64Array(sxs.length);
            const { s_invert } = this;
            for (let i = 0; i < sxs.length; i++) {
                result[i] = s_invert(sxs[i]);
            }
            return result;
        }
        r_compute(x0, x1) {
            const { s_compute } = this;
            if (this.target_range.is_reversed) {
                return [s_compute(x1), s_compute(x0)];
            }
            else {
                return [s_compute(x0), s_compute(x1)];
            }
        }
        r_invert(sx0, sx1) {
            const { s_invert } = this;
            if (this.target_range.is_reversed) {
                return [s_invert(sx1), s_invert(sx0)];
            }
            else {
                return [s_invert(sx0), s_invert(sx1)];
            }
        }
    }
    exports.Scale = Scale;
    _a = Scale;
    Scale.__name__ = "Scale";
    (() => {
        _a.internal(({ Ref }) => ({
            source_range: [Ref(range_1.Range)],
            target_range: [Ref(range1d_1.Range1d)],
        }));
    })();
},
/* models/transforms/transform.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const model_1 = require(51) /* ../../model */;
    class Transform extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Transform = Transform;
    Transform.__name__ = "Transform";
},
/* models/ranges/range.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const model_1 = require(51) /* ../../model */;
    const kinds_1 = require(22) /* ../../core/kinds */;
    const iterator_1 = require(14) /* ../../core/util/iterator */;
    const Bounds = (0, kinds_1.Nullable)((0, kinds_1.Or)((0, kinds_1.Tuple)((0, kinds_1.Nullable)(kinds_1.Float), (0, kinds_1.Nullable)(kinds_1.Float)), kinds_1.Auto));
    class Range extends model_1.Model {
        constructor(attrs) {
            super(attrs);
            this.have_updated_interactively = false;
            /** @internal */
            this.frames = new Set();
        }
        get computed_bounds() {
            return this._computed_bounds;
        }
        get is_reversed() {
            return this.start > this.end;
        }
        get is_valid() {
            return isFinite(this.min) && isFinite(this.max);
        }
        get interval() {
            return [this.start, this.end];
        }
        get span() {
            return Math.abs(this.end - this.start);
        }
        get linked_plots() {
            return new Set((0, iterator_1.map)(this.frames, (frame) => frame.parent));
        }
    }
    exports.Range = Range;
    _a = Range;
    Range.__name__ = "Range";
    (() => {
        _a.define(({ Float, Nullable }) => ({
            bounds: [Bounds, null, {
                    on_update(bounds, obj) {
                        const [lower, upper] = bounds == "auto" || bounds == null ? [null, null] : bounds;
                        obj._computed_bounds = [lower ?? -Infinity, upper ?? Infinity];
                    },
                }],
            min_interval: [Nullable(Float), null],
            max_interval: [Nullable(Float), null],
        }));
    })();
},
/* models/ranges/range1d.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const numerical_range_1 = require(100) /* ./numerical_range */;
    class Range1d extends numerical_range_1.NumericalRange {
        constructor(attrs) {
            super(attrs);
        }
        _set_auto_bounds() {
            if (this.bounds == "auto") {
                const min = Math.min(this._reset_start, this._reset_end);
                const max = Math.max(this._reset_start, this._reset_end);
                this._computed_bounds = [min, max];
            }
        }
        initialize() {
            super.initialize();
            this._set_auto_bounds();
        }
        get min() {
            return Math.min(this.start, this.end);
        }
        get max() {
            return Math.max(this.start, this.end);
        }
        reset() {
            this._set_auto_bounds();
            const { _reset_start, _reset_end } = this;
            if (this.start != _reset_start || this.end != _reset_end) {
                this.setv({ start: _reset_start, end: _reset_end });
            }
            else {
                this.change.emit();
            }
        }
        map(fn) {
            return new _a({ start: fn(this.start), end: fn(this.end) });
        }
        widen(v) {
            let { start, end } = this;
            if (this.is_reversed) {
                start += v;
                end -= v;
            }
            else {
                start -= v;
                end += v;
            }
            return new _a({ start, end });
        }
    }
    exports.Range1d = Range1d;
    _a = Range1d;
    Range1d.__name__ = "Range1d";
    (() => {
        _a.define(({ Float, Nullable }) => ({
            reset_start: [Nullable(Float), null, {
                    on_update(reset_start, self) {
                        self._reset_start = reset_start ?? self.start;
                    },
                }],
            reset_end: [Nullable(Float), null, {
                    on_update(reset_end, self) {
                        self._reset_end = reset_end ?? self.end;
                    },
                }],
        }));
        _a.override({
            start: 0,
            end: 1,
        });
    })();
},
/* models/ranges/numerical_range.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const range_1 = require(98) /* ./range */;
    const p = tslib_1.__importStar(require(19) /* ../../core/properties */);
    const math_1 = require(11) /* ../../core/util/math */;
    class NumericalRange extends range_1.Range {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.NumericalRange = NumericalRange;
    _a = NumericalRange;
    NumericalRange.__name__ = "NumericalRange";
    (() => {
        _a.define(({ Float }) => ({
            start: [Float, p.unset, {
                    convert(value, obj) {
                        const [lower, upper] = obj.computed_bounds;
                        return (0, math_1.clamp)(value, lower, upper);
                    },
                }],
            end: [Float, p.unset, {
                    convert(value, obj) {
                        const [lower, upper] = obj.computed_bounds;
                        return (0, math_1.clamp)(value, lower, upper);
                    },
                }],
        }));
    })();
},
/* models/scales/linear_scale.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const continuous_scale_1 = require(102) /* ./continuous_scale */;
    class LinearScale extends continuous_scale_1.ContinuousScale {
        constructor(attrs) {
            super(attrs);
        }
        get s_compute() {
            const [factor, offset] = this._linear_compute_state();
            return (x) => factor * x + offset;
        }
        get s_invert() {
            const [factor, offset] = this._linear_compute_state();
            return (sx) => (sx - offset) / factor;
        }
        /*protected*/ _linear_compute_state() {
            //
            //  (t1 - t0)       (t1 - t0)
            //  --------- * x - --------- * s0 + t0
            //  (s1 - s0)       (s1 - s0)
            //
            // [  factor  ]     [    offset    ]
            //
            const source_start = this.source_range.start;
            const source_end = this.source_range.end;
            const target_start = this.target_range.start;
            const target_end = this.target_range.end;
            const factor = (target_end - target_start) / (source_end - source_start);
            const offset = -(factor * source_start) + target_start;
            return [factor, offset];
        }
    }
    exports.LinearScale = LinearScale;
    LinearScale.__name__ = "LinearScale";
},
/* models/scales/continuous_scale.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const scale_1 = require(96) /* ./scale */;
    class ContinuousScale extends scale_1.Scale {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.ContinuousScale = ContinuousScale;
    ContinuousScale.__name__ = "ContinuousScale";
},
/* models/scales/log_scale.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const continuous_scale_1 = require(102) /* ./continuous_scale */;
    class LogScale extends continuous_scale_1.ContinuousScale {
        constructor(attrs) {
            super(attrs);
        }
        get s_compute() {
            const [factor, offset, inter_factor, inter_offset] = this._compute_state();
            return (x) => {
                if (inter_factor == 0) {
                    return 0;
                }
                else {
                    const _x = (Math.log(x) - inter_offset) / inter_factor;
                    return isFinite(_x) ? _x * factor + offset : NaN;
                }
            };
        }
        get s_invert() {
            const [factor, offset, inter_factor, inter_offset] = this._compute_state();
            return (xprime) => {
                const value = (xprime - offset) / factor;
                return Math.exp(inter_factor * value + inter_offset);
            };
        }
        _get_safe_factor(orig_start, orig_end) {
            let start = orig_start < 0 ? 0 : orig_start;
            let end = orig_end < 0 ? 0 : orig_end;
            if (start == end) {
                if (start == 0) {
                    [start, end] = [1, 10];
                }
                else {
                    const log_val = Math.log10(start);
                    start = 10 ** Math.floor(log_val);
                    if (Math.ceil(log_val) != Math.floor(log_val)) {
                        end = 10 ** Math.ceil(log_val);
                    }
                    else {
                        end = 10 ** (Math.ceil(log_val) + 1);
                    }
                }
            }
            return [start, end];
        }
        /*protected*/ _compute_state() {
            const source_start = this.source_range.start;
            const source_end = this.source_range.end;
            const target_start = this.target_range.start;
            const target_end = this.target_range.end;
            const screen_range = target_end - target_start;
            const [start, end] = this._get_safe_factor(source_start, source_end);
            let inter_factor;
            let inter_offset;
            if (start == 0) {
                inter_factor = Math.log(end);
                inter_offset = 0;
            }
            else {
                inter_factor = Math.log(end / start);
                inter_offset = Math.log(start);
            }
            const factor = screen_range;
            const offset = target_start;
            return [factor, offset, inter_factor, inter_offset];
        }
    }
    exports.LogScale = LogScale;
    LogScale.__name__ = "LogScale";
},
/* models/scales/categorical_scale.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const scale_1 = require(96) /* ./scale */;
    const linear_scale_1 = require(101) /* ./linear_scale */;
    const { _linear_compute_state } = linear_scale_1.LinearScale.prototype;
    class CategoricalScale extends scale_1.Scale {
        constructor(attrs) {
            super(attrs);
        }
        get s_compute() {
            const [factor, offset] = _linear_compute_state.call(this);
            const range = this.source_range;
            return (x) => factor * range.synthetic(x) + offset;
        }
        get s_invert() {
            const [factor, offset] = _linear_compute_state.call(this);
            return (sx) => (sx - offset) / factor;
        }
    }
    exports.CategoricalScale = CategoricalScale;
    CategoricalScale.__name__ = "CategoricalScale";
},
/* models/scales/composite_scale.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const scale_1 = require(96) /* ../scales/scale */;
    const arrayable_1 = require(13) /* ../../core/util/arrayable */;
    class CompositeScale extends scale_1.Scale {
        constructor(attrs) {
            super(attrs);
        }
        get s_compute() {
            const source_compute = this.source_scale.s_compute;
            const target_compute = this.target_scale.s_compute;
            return (x) => target_compute(source_compute(x));
        }
        get s_invert() {
            const source_invert = this.source_scale.s_invert;
            const target_invert = this.target_scale.s_invert;
            return (sx) => source_invert(target_invert(sx));
        }
        compute(x) {
            return this.s_compute(x);
        }
        v_compute(xs) {
            const { s_compute } = this;
            return (0, arrayable_1.map)(xs, s_compute); // XXX
        }
        invert(sx) {
            return this.s_invert(sx);
        }
        v_invert(sxs) {
            const { s_invert } = this;
            return (0, arrayable_1.map)(sxs, s_invert); // XXX
        }
    }
    exports.CompositeScale = CompositeScale;
    _a = CompositeScale;
    CompositeScale.__name__ = "CompositeScale";
    (() => {
        _a.define(({ Ref }) => ({
            source_scale: [Ref(scale_1.Scale)],
            target_scale: [Ref(scale_1.Scale)],
        }));
    })();
},
/* models/ranges/data_range1d.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    exports.is_auto_ranged = is_auto_ranged;
    const tslib_1 = require(1) /* tslib */;
    const data_range_1 = require(107) /* ./data_range */;
    const enums_1 = require(21) /* ../../core/enums */;
    const iterator_1 = require(14) /* ../../core/util/iterator */;
    const math_1 = require(11) /* ../../core/util/math */;
    const logging_1 = require(20) /* ../../core/logging */;
    const bbox = tslib_1.__importStar(require(64) /* ../../core/util/bbox */);
    const util_1 = require(108) /* ../util */;
    exports.auto_ranged = Symbol("auto_ranged");
    function is_auto_ranged(r) {
        return exports.auto_ranged in r;
    }
    class DataRange1d extends data_range_1.DataRange {
        constructor(attrs) {
            super(attrs);
            this.have_updated_interactively = false;
        }
        initialize() {
            super.initialize();
            this._initial_start = isNaN(this.start) ? null : this.start;
            this._initial_end = isNaN(this.end) ? null : this.end;
            this._initial_range_padding = this.range_padding;
            this._initial_range_padding_units = this.range_padding_units;
            this._initial_follow = this.follow;
            this._initial_follow_interval = this.follow_interval;
            this._initial_default_span = this.default_span;
            this._plot_bounds = new Map();
        }
        get min() {
            return Math.min(this.start, this.end);
        }
        get max() {
            return Math.max(this.start, this.end);
        }
        computed_renderers() {
            // TODO (bev) check that renderers actually configured with this range
            const { renderers } = this;
            const all_renderers = (0, iterator_1.flat_map)(this.linked_plots, (plot) => plot.auto_ranged_renderers.map((r) => r.model));
            return (0, util_1.compute_renderers)(renderers.length == 0 ? "auto" : renderers, [...all_renderers]);
        }
        /*protected*/ _compute_plot_bounds(renderers, bounds) {
            let result = bbox.empty();
            for (const r of renderers) {
                const rect = bounds.get(r);
                if (rect != null && (r.visible || !this.only_visible)) {
                    result = bbox.union(result, rect);
                }
            }
            return result;
        }
        adjust_bounds_for_aspect(bounds, ratio) {
            const result = bbox.empty();
            let width = bounds.x1 - bounds.x0;
            if (width <= 0) {
                width = 1.0;
            }
            let height = bounds.y1 - bounds.y0;
            if (height <= 0) {
                height = 1.0;
            }
            const xcenter = 0.5 * (bounds.x1 + bounds.x0);
            const ycenter = 0.5 * (bounds.y1 + bounds.y0);
            if (width < ratio * height) {
                width = ratio * height;
            }
            else {
                height = width / ratio;
            }
            result.x1 = xcenter + 0.5 * width;
            result.x0 = xcenter - 0.5 * width;
            result.y1 = ycenter + 0.5 * height;
            result.y0 = ycenter - 0.5 * height;
            return result;
        }
        /*protected*/ _compute_min_max(plot_bounds, dimension) {
            let overall = bbox.empty();
            for (const [plot, rect] of plot_bounds) {
                if (plot.model.visible) {
                    overall = bbox.union(overall, rect);
                }
            }
            let min, max;
            if (dimension == 0) {
                [min, max] = [overall.x0, overall.x1];
            }
            else {
                [min, max] = [overall.y0, overall.y1];
            }
            return [min, max];
        }
        /*protected*/ _compute_range(min, max) {
            const { range_padding } = this;
            const min_interval = this.min_interval ?? 0;
            const max_interval = this.max_interval ?? Infinity;
            let start, end;
            if (this._initial_start != null) {
                min = this._initial_start;
            }
            if (this._initial_end != null) {
                max = this._initial_end;
            }
            if (this.scale_hint == "log") {
                if (isNaN(min) || !isFinite(min) || min <= 0) {
                    if (isNaN(max) || !isFinite(max) || max <= 0) {
                        min = 0.1;
                    }
                    else {
                        min = max / 100;
                    }
                    logging_1.logger.warn(`could not determine minimum data value for log axis, DataRange1d using value ${min}`);
                }
                if (isNaN(max) || !isFinite(max) || max <= 0) {
                    if (isNaN(min) || !isFinite(min) || min <= 0) {
                        max = 10;
                    }
                    else {
                        max = min * 100;
                    }
                    logging_1.logger.warn(`could not determine maximum data value for log axis, DataRange1d using value ${max}`);
                }
                let center, span;
                if (max == min) {
                    span = this.default_span + 0.001;
                    center = Math.log10(min);
                }
                else {
                    let log_min, log_max;
                    if (this.range_padding_units == "percent") {
                        log_min = Math.log10(min);
                        log_max = Math.log10(max);
                        span = (log_max - log_min) * (1 + range_padding);
                    }
                    else {
                        log_min = Math.log10(min - range_padding);
                        log_max = Math.log10(max + range_padding);
                        span = log_max - log_min;
                    }
                    center = (log_min + log_max) / 2.0;
                }
                span = (0, math_1.clamp)(span, min_interval, max_interval);
                start = 10 ** (center - span / 2.0);
                end = 10 ** (center + span / 2.0);
            }
            else {
                let span;
                if (max == min) {
                    span = this.default_span;
                }
                else {
                    if (this.range_padding_units == "percent") {
                        span = (max - min) * (1 + range_padding);
                    }
                    else {
                        span = (max - min) + 2 * range_padding;
                    }
                }
                span = (0, math_1.clamp)(span, min_interval, max_interval);
                const center = (max + min) / 2.0;
                start = center - span / 2.0;
                end = center + span / 2.0;
            }
            let follow_sign = +1;
            if (this.flipped) {
                [start, end] = [end, start];
                follow_sign = -1;
            }
            const follow_interval = this.follow_interval;
            if (follow_interval != null && Math.abs(start - end) > follow_interval) {
                if (this.follow == "start") {
                    end = start + follow_sign * follow_interval;
                }
                else if (this.follow == "end") {
                    start = end - follow_sign * follow_interval;
                }
            }
            return [start, end];
        }
        update(bounds, dimension, plot, ratio) {
            if (this.have_updated_interactively) {
                return;
            }
            const renderers = this.computed_renderers();
            // update the raw data bounds for all renderers we care about
            let total_bounds = this._compute_plot_bounds(renderers, bounds);
            if (ratio != null) {
                total_bounds = this.adjust_bounds_for_aspect(total_bounds, ratio);
            }
            this._plot_bounds.set(plot, total_bounds);
            // compute the min/mix for our specified dimension
            const [min, max] = this._compute_min_max(this._plot_bounds.entries(), dimension);
            // derive start, end from bounds and data range config
            let [start, end] = this._compute_range(min, max);
            if (this._initial_start != null) {
                if (this.scale_hint == "log") {
                    if (this._initial_start > 0) {
                        start = this._initial_start;
                    }
                }
                else {
                    start = this._initial_start;
                }
            }
            if (this._initial_end != null) {
                if (this.scale_hint == "log") {
                    if (this._initial_end > 0) {
                        end = this._initial_end;
                    }
                }
                else {
                    end = this._initial_end;
                }
            }
            let needs_emit = false;
            if (this.bounds == "auto") {
                this._computed_bounds = [start, end];
                needs_emit = true;
            }
            // only trigger updates when there are changes
            const [_start, _end] = [this.start, this.end];
            if (start != _start || end != _end) {
                const new_range = {};
                if (start != _start) {
                    new_range.start = start;
                }
                if (end != _end) {
                    new_range.end = end;
                }
                this.setv(new_range);
                needs_emit = false;
            }
            if (needs_emit) {
                this.change.emit();
            }
        }
        reset() {
            this.have_updated_interactively = false;
            // change events silenced as PlotView.update_dataranges triggers property callbacks
            this.setv({
                range_padding: this._initial_range_padding,
                range_padding_units: this._initial_range_padding_units,
                follow: this._initial_follow,
                follow_interval: this._initial_follow_interval,
                default_span: this._initial_default_span,
            }, { silent: true });
            this.change.emit();
        }
    }
    exports.DataRange1d = DataRange1d;
    _a = DataRange1d;
    DataRange1d.__name__ = "DataRange1d";
    (() => {
        _a.define(({ Bool, Float, Nullable }) => ({
            range_padding: [Float, 0.1],
            range_padding_units: [enums_1.PaddingUnits, "percent"],
            flipped: [Bool, false],
            follow: [Nullable(enums_1.StartEnd), null],
            follow_interval: [Nullable(Float), null],
            default_span: [Float, 2.0],
            only_visible: [Bool, false],
        }));
        _a.internal(({ Enum }) => ({
            scale_hint: [Enum("log", "auto"), "auto"],
        }));
    })();
},
/* models/ranges/data_range.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const numerical_range_1 = require(100) /* ./numerical_range */;
    class DataRange extends numerical_range_1.NumericalRange {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.DataRange = DataRange;
    _a = DataRange;
    DataRange.__name__ = "DataRange";
    (() => {
        _a.define(({ List, AnyRef, Or, Auto }) => ({
            renderers: [Or(List(AnyRef()), Auto), []],
        }));
        _a.override({
            start: NaN,
            end: NaN,
        });
    })();
},
/* models/util.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.compute_renderers = compute_renderers;
    function compute_renderers(renderers, all_renderers) {
        return renderers == "auto" ? all_renderers : renderers ?? [];
    }
},
/* models/ranges/factor_range.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    exports.map_one_level = map_one_level;
    exports.map_two_levels = map_two_levels;
    exports.map_three_levels = map_three_levels;
    const tslib_1 = require(1) /* tslib */;
    const range_1 = require(98) /* ./range */;
    const enums_1 = require(21) /* ../../core/enums */;
    const kinds_1 = require(22) /* ../../core/kinds */;
    const p = tslib_1.__importStar(require(19) /* ../../core/properties */);
    const signaling_1 = require(16) /* ../../core/signaling */;
    const types_1 = require(25) /* ../../core/types */;
    const array_1 = require(10) /* ../../core/util/array */;
    const types_2 = require(8) /* ../../core/util/types */;
    exports.Factor = (0, kinds_1.Or)(kinds_1.Str, (0, kinds_1.Tuple)(kinds_1.Str, kinds_1.Str), (0, kinds_1.Tuple)(kinds_1.Str, kinds_1.Str, kinds_1.Str));
    exports.FactorSeq = (0, kinds_1.Or)((0, kinds_1.List)(kinds_1.Str), (0, kinds_1.List)((0, kinds_1.Tuple)(kinds_1.Str, kinds_1.Str)), (0, kinds_1.List)((0, kinds_1.Tuple)(kinds_1.Str, kinds_1.Str, kinds_1.Str)));
    function map_one_level(factors, padding, offset = 0) {
        const mapping = new Map();
        for (let i = 0; i < factors.length; i++) {
            const factor = factors[i];
            if (mapping.has(factor)) {
                throw new Error(`duplicate factor or subfactor: ${factor}`);
            }
            mapping.set(factor, { value: 0.5 + i * (1 + padding) + offset });
        }
        const inner_padding = (factors.length - 1) * padding;
        return { mapping, inner_padding };
    }
    function map_two_levels(factors, outer_pad, factor_pad, offset = 0) {
        const mapping = new Map();
        const tops = new Map();
        for (const [f0, f1] of factors) {
            const top = tops.get(f0) ?? [];
            tops.set(f0, [...top, f1]);
        }
        let suboffset = offset;
        let total_subpad = 0;
        for (const [f0, top] of tops) {
            const n = top.length;
            const sub = map_one_level(top, factor_pad, suboffset);
            total_subpad += sub.inner_padding;
            const subtot = (0, array_1.sum)(top.map((f1) => sub.mapping.get(f1).value));
            mapping.set(f0, { value: subtot / n, mapping: sub.mapping });
            suboffset += n + outer_pad + sub.inner_padding;
        }
        const inner_padding = (tops.size - 1) * outer_pad + total_subpad;
        return { mapping, tops: [...mapping.keys()], inner_padding };
    }
    function map_three_levels(factors, outer_pad, inner_pad, factor_pad, offset = 0) {
        const mapping = new Map();
        const tops = new Map();
        for (const [f0, f1, f2] of factors) {
            const top = tops.get(f0) ?? [];
            tops.set(f0, [...top, [f1, f2]]);
        }
        let suboffset = offset;
        let total_subpad = 0;
        for (const [f0, top] of tops) {
            const n = top.length;
            const sub = map_two_levels(top, inner_pad, factor_pad, suboffset);
            total_subpad += sub.inner_padding;
            const subtot = (0, array_1.sum)(top.map(([f1]) => sub.mapping.get(f1).value));
            mapping.set(f0, { value: subtot / n, mapping: sub.mapping });
            suboffset += n + outer_pad + sub.inner_padding;
        }
        const mids = [];
        for (const [f0, L2] of mapping) {
            for (const f1 of L2.mapping.keys()) {
                mids.push([f0, f1]);
            }
        }
        const inner_padding = (tops.size - 1) * outer_pad + total_subpad;
        return { mapping, tops: [...mapping.keys()], mids, inner_padding };
    }
    const is_l1 = (x) => (0, types_2.isString)(x);
    const is_l2 = (x) => (0, types_2.isArray)(x) && x.length == 2 && (0, types_2.isString)(x[0]) && (0, types_2.isString)(x[1]);
    const is_l3 = (x) => (0, types_2.isArray)(x) && x.length == 3 && (0, types_2.isString)(x[0]) && (0, types_2.isString)(x[1]) && (0, types_2.isString)(x[2]);
    class FactorMapper {
        constructor({ levels, mapping, tops = null, mids = null, inner_padding }) {
            this.levels = levels;
            this.mapping = mapping;
            this.tops = tops;
            this.mids = mids;
            this.inner_padding = inner_padding;
        }
        static compute_levels(factors) {
            if ((0, array_1.every)(factors, is_l1)) {
                return 1;
            }
            if ((0, array_1.every)(factors, is_l2)) {
                return 2;
            }
            if ((0, array_1.every)(factors, is_l3)) {
                return 3;
            }
            throw TypeError("factor levels are inconsistent");
        }
        static for(range) {
            switch (this.compute_levels(range.factors)) {
                case 1: {
                    return new L1FactorMapper(range);
                }
                case 2: {
                    return new L2FactorMapper(range);
                }
                case 3: {
                    return new L3FactorMapper(range);
                }
            }
        }
        map(x) {
            if ((0, types_2.isNumber)(x)) {
                return x;
            }
            const [boxed, offset] = (() => {
                if ((0, types_2.isString)(x)) {
                    return [[x], 0];
                }
                const last = x[x.length - 1];
                if ((0, types_2.isNumber)(last)) {
                    return [x.slice(0, -1), last];
                }
                return [x, 0];
            })();
            if (boxed.length > this.levels) {
                throw new Error(`Attempted to map ${boxed.length} levels of factors with an L${this.levels}FactorMap`);
            }
            return this.lookup_value(boxed) + offset;
        }
        lookup_value(x) {
            return this.lookup_entry(x)?.value ?? NaN;
        }
    }
    exports.FactorMapper = FactorMapper;
    FactorMapper.__name__ = "FactorMapper";
    class L1FactorMapper extends FactorMapper {
        constructor(range) {
            const { factors, factor_padding } = range;
            const spec = map_one_level(factors, factor_padding);
            super({ levels: 1, ...spec });
        }
        lookup_entry(x) {
            const [f0] = x;
            return this.mapping.get(f0) ?? null;
        }
    }
    L1FactorMapper.__name__ = "L1FactorMapper";
    class L2FactorMapper extends FactorMapper {
        constructor(range) {
            const { factors, group_padding, factor_padding } = range;
            const spec = map_two_levels(factors, group_padding, factor_padding);
            super({ levels: 2, ...spec });
        }
        lookup_entry(x) {
            if (x.length == 1) {
                const [f0] = x;
                return this.mapping.get(f0) ?? null;
            }
            else {
                const [f0, f1] = x;
                return this.mapping.get(f0)?.mapping.get(f1) ?? null;
            }
        }
    }
    L2FactorMapper.__name__ = "L2FactorMapper";
    class L3FactorMapper extends FactorMapper {
        constructor(range) {
            const { factors, group_padding, subgroup_padding, factor_padding } = range;
            const spec = map_three_levels(factors, group_padding, subgroup_padding, factor_padding);
            super({ levels: 3, ...spec });
        }
        lookup_entry(x) {
            if (x.length == 1) {
                const [f0] = x;
                return this.mapping.get(f0) ?? null;
            }
            else if (x.length == 2) {
                const [f0, f1] = x;
                return this.mapping.get(f0)?.mapping.get(f1) ?? null;
            }
            else {
                const [f0, f1, f2] = x;
                return this.mapping.get(f0)?.mapping.get(f1)?.mapping.get(f2) ?? null;
            }
        }
    }
    L3FactorMapper.__name__ = "L3FactorMapper";
    class FactorRange extends range_1.Range {
        constructor(attrs) {
            super(attrs);
            this.invalidate_synthetic = new signaling_1.Signal0(this, "invalidate_synthetic");
        }
        get min() {
            return this.start;
        }
        get max() {
            return this.end;
        }
        initialize() {
            super.initialize();
            this.configure();
        }
        connect_signals() {
            super.connect_signals();
            this.connect(this.properties.factors.change, () => this.reset());
            this.connect(this.properties.factor_padding.change, () => this.reset());
            this.connect(this.properties.group_padding.change, () => this.reset());
            this.connect(this.properties.subgroup_padding.change, () => this.reset());
            this.connect(this.properties.range_padding.change, () => this.reset());
            this.connect(this.properties.range_padding_units.change, () => this.reset());
        }
        reset() {
            this.configure();
            this.invalidate_synthetic.emit();
        }
        /** Convert a categorical factor into a synthetic coordinate. */
        synthetic(x) {
            return this.mapper.map(x);
        }
        /** Convert an array of categorical factors into synthetic coordinates. */
        v_synthetic(xs) {
            return types_1.ScreenArray.from(xs, (x) => this.synthetic(x));
        }
        /** Convert a synthetic coordinate into a categorical factor. */
        factor(x) {
            for (const f of this.factors) {
                const v = this.mapper.map(f);
                if (x >= (v - 0.5) && x < (v + 0.5)) {
                    return f;
                }
            }
            return null;
        }
        compute_bounds(inner_padding) {
            const interval = this.factors.length + inner_padding;
            const padding = (() => {
                switch (this.range_padding_units) {
                    case "percent": {
                        return interval * this.range_padding / 2;
                    }
                    case "absolute": {
                        return this.range_padding;
                    }
                }
            })();
            return [-padding, interval + padding];
        }
        configure() {
            this.mapper = FactorMapper.for(this);
            const [start, end] = this.compute_bounds(this.mapper.inner_padding);
            this.setv({ start, end }, { silent: true });
            if (this.bounds == "auto") {
                this._computed_bounds = [start, end];
            }
        }
    }
    exports.FactorRange = FactorRange;
    _a = FactorRange;
    FactorRange.__name__ = "FactorRange";
    (() => {
        _a.define(({ Float }) => ({
            factors: [exports.FactorSeq, []],
            factor_padding: [Float, 0],
            subgroup_padding: [Float, 0.8],
            group_padding: [Float, 1.4],
            range_padding: [Float, 0],
            range_padding_units: [enums_1.PaddingUnits, "percent"],
            start: [Float, p.unset, { readonly: true }],
            end: [Float, p.unset, { readonly: true }],
        }));
    })();
},
/* models/ui/menus/menu.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const ui_element_1 = require(111) /* ../ui_element */;
    const menu_item_1 = require(117) /* ./menu_item */;
    const divider_item_1 = require(120) /* ./divider_item */;
    const resolve_1 = require(121) /* ../../common/resolve */;
    const types_1 = require(8) /* ../../../core/util/types */;
    const dom_1 = require(63) /* ../../../core/dom */;
    const kinds_1 = require(22) /* ../../../core/kinds */;
    const build_views_1 = require(56) /* ../../../core/build_views */;
    const array_1 = require(10) /* ../../../core/util/array */;
    const callbacks_1 = require(50) /* ../../../core/util/callbacks */;
    const menus_css_1 = tslib_1.__importStar(require(122) /* ../../../styles/menus.css */), menus = menus_css_1;
    const icons_css_1 = tslib_1.__importDefault(require(123) /* ../../../styles/icons.css */);
    function to_val(val) {
        return (0, types_1.isFunction)(val) ? val() : val;
    }
    exports.MenuItemLike = (0, kinds_1.Or)((0, kinds_1.Ref)(menu_item_1.MenuItem), (0, kinds_1.Ref)(divider_item_1.DividerItem), kinds_1.Null);
    class MenuView extends ui_element_1.UIElementView {
        constructor() {
            super(...arguments);
            this._menu_views = new Map();
            this._menu_items = [];
            this._open = false;
            this._item_click = (item) => {
                if (!to_val(item.disabled)) {
                    const { action } = item;
                    if (action != null) {
                        void (0, callbacks_1.execute)(action, this.model, { item });
                    }
                    this.hide();
                }
            };
            this._on_mousedown = (event) => {
                if (event.composedPath().includes(this.el)) {
                    return;
                }
                if (this.prevent_hide?.(event) ?? false) {
                    return;
                }
                this.hide();
            };
            this._on_keydown = (event) => {
                switch (event.key) {
                    case "Escape": {
                        this.hide();
                        break;
                    }
                    default:
                }
            };
            this._on_blur = () => {
                this.hide();
            };
        }
        *children() {
            yield* super.children();
            yield* this._menu_views.values();
        }
        get menu_items() {
            const items = this._menu_items;
            const { reversed } = this.model;
            return reversed ? (0, array_1.reversed)(items) : items;
        }
        _compute_menu_items() {
            return this.model.items;
        }
        _update_menu_items() {
            this._menu_items = this._compute_menu_items();
        }
        get is_empty() {
            return this.menu_items.length == 0;
        }
        initialize() {
            super.initialize();
            this._update_menu_items();
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            const menus = this.menu_items
                .filter((item) => item instanceof menu_item_1.MenuItem)
                .map((item) => item.menu)
                .filter((menu) => menu != null);
            await (0, build_views_1.build_views)(this._menu_views, menus, { parent: this });
        }
        connect_signals() {
            super.connect_signals();
            const { items } = this.model.properties;
            this.on_change(items, () => this._update_menu_items());
        }
        get is_open() {
            return this._open;
        }
        remove() {
            this._unlisten();
            (0, build_views_1.remove_views)(this._menu_views);
            super.remove();
        }
        _listen() {
            document.addEventListener("mousedown", this._on_mousedown);
            document.addEventListener("keydown", this._on_keydown);
            window.addEventListener("blur", this._on_blur);
        }
        _unlisten() {
            document.removeEventListener("mousedown", this._on_mousedown);
            document.removeEventListener("keydown", this._on_keydown);
            window.removeEventListener("blur", this._on_blur);
        }
        stylesheets() {
            return [...super.stylesheets(), menus_css_1.default, icons_css_1.default];
        }
        render() {
            super.render();
            const items = this.menu_items;
            const entries = [];
            if (items.length == 0) {
                return;
            }
            for (const item of items) {
                if (item instanceof menu_item_1.MenuItem) {
                    const check_el = (0, dom_1.div)({ class: menus.check });
                    const label_el = (0, dom_1.div)({ class: menus.label }, item.label);
                    const shortcut_el = (0, dom_1.div)({ class: menus.shortcut }, item.shortcut);
                    const chevron_el = (0, dom_1.div)({ class: menus.chevron });
                    const icon_el = (() => {
                        const { icon } = item;
                        if (icon != null) {
                            const icon_el = (0, dom_1.div)({ class: menus.icon });
                            (0, resolve_1.apply_icon)(icon_el, icon);
                            return icon_el;
                        }
                        else {
                            return null;
                        }
                    })();
                    const item_el = (0, dom_1.div)({ class: menus.item, title: item.tooltip, tabIndex: 0 }, check_el, icon_el, label_el, shortcut_el, chevron_el);
                    const has_menu = item.menu != null && !this._menu_views.get(item.menu).is_empty;
                    item_el.classList.toggle(menus.menu, has_menu);
                    item_el.classList.toggle(menus.disabled, to_val(item.disabled));
                    if (item.checked != null) {
                        item_el.classList.add(menus.checkable);
                        item_el.classList.toggle(menus.checked, to_val(item.checked));
                    }
                    const show_submenu = (item) => {
                        if (item.menu != null) {
                            const menu_view = this._menu_views.get(item.menu);
                            menu_view._show_submenu(item_el);
                        }
                    };
                    const hide_submenu = (item) => {
                        if (item.menu != null) {
                            const menu_view = this._menu_views.get(item.menu);
                            menu_view.hide();
                        }
                    };
                    function is_target(event) {
                        const { currentTarget, target } = event;
                        return currentTarget instanceof Node && target instanceof Node && currentTarget.contains(target);
                    }
                    item_el.addEventListener("click", (event) => {
                        if (is_target(event)) {
                            this._item_click(item);
                        }
                        else {
                            this.hide();
                        }
                    });
                    item_el.addEventListener("keydown", (event) => {
                        // TODO https://github.com/bokeh/bokeh/issues/14241
                        switch (event.key) {
                            case "Enter": {
                                this._item_click(item);
                                break;
                            }
                            case "ArrowDown": {
                                break;
                            }
                            case "ArrowUp": {
                                break;
                            }
                            case "ArrowLeft": {
                                break;
                            }
                            case "ArrowRight": {
                                break;
                            }
                            default:
                        }
                    });
                    const { menu } = item;
                    if (menu != null) {
                        item_el.addEventListener("pointerenter", () => {
                            show_submenu(item);
                        });
                        item_el.addEventListener("pointerleave", () => {
                            hide_submenu(item);
                        });
                    }
                    this.shadow_el.append(item_el);
                    entries.push({ item, el: item_el });
                }
                else {
                    const item_el = (0, dom_1.div)({ class: menus.divider });
                    this.shadow_el.append(item_el);
                }
            }
        }
        _show_submenu(target) {
            if (this.is_empty) {
                this.hide();
                return;
            }
            this.render();
            target.append(this.el);
            const { style } = this.el;
            style.left = "100%";
            style.top = "0";
            this._listen();
            this._open = true;
        }
        show(at) {
            if (this.is_empty) {
                this.hide();
                return false;
            }
            const { parent } = this;
            if (parent == null) {
                // TODO position: fixed
                this.hide();
                return false;
            }
            this.render();
            const target = parent.el.shadowRoot ?? parent.el;
            target.append(this.el);
            const { style } = this.el;
            style.left = (0, dom_1.px)(at.x);
            style.top = (0, dom_1.px)(at.y);
            this._listen();
            this._open = true;
            return true;
        }
        hide() {
            if (this._open) {
                this._open = false;
                this._unlisten();
                this.el.remove();
            }
        }
    }
    exports.MenuView = MenuView;
    MenuView.__name__ = "MenuView";
    class Menu extends ui_element_1.UIElement {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Menu = Menu;
    _a = Menu;
    Menu.__name__ = "Menu";
    (() => {
        _a.prototype.default_view = MenuView;
        _a.define(({ Bool, List }) => ({
            items: [List(exports.MenuItemLike), []],
            reversed: [Bool, false],
        }));
    })();
},
/* models/ui/ui_element.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const styled_element_1 = require(84) /* ./styled_element */;
    const build_views_1 = require(56) /* ../../core/build_views */;
    const dom_1 = require(63) /* ../../core/dom */;
    const canvas_1 = require(112) /* ../../core/util/canvas */;
    const bbox_1 = require(64) /* ../../core/util/bbox */;
    const types_1 = require(8) /* ../../core/util/types */;
    const defer_1 = require(17) /* ../../core/util/defer */;
    const ui_css_1 = tslib_1.__importDefault(require(116) /* ../../styles/ui.css */);
    const { round, floor } = Math;
    class UIElementView extends styled_element_1.StyledElementView {
        constructor() {
            super(...arguments);
            this.display = new dom_1.InlineStyleSheet("", "display");
            this._bbox = new bbox_1.BBox();
            this._context_menu = null;
            this._resized = false;
            this._is_displayed = false;
        }
        computed_stylesheets() {
            return [...super.computed_stylesheets(), this.display];
        }
        stylesheets() {
            return [...super.stylesheets(), ui_css_1.default];
        }
        update_style() {
            this.style.clear();
        }
        box_sizing() {
            return {
                width_policy: "auto", height_policy: "auto",
                width: null, height: null,
                aspect_ratio: null,
            };
        }
        get bbox() {
            return this._bbox;
        }
        update_bbox() {
            return this._update_bbox();
        }
        _update_bbox() {
            const displayed = (() => {
                // Consider using Element.checkVisibility() in the future.
                // https://w3c.github.io/csswg-drafts/cssom-view-1/#dom-element-checkvisibility
                if (!this.el.isConnected) {
                    return false;
                }
                else if (this.el.offsetParent != null) {
                    return true;
                }
                else {
                    const { position, display } = getComputedStyle(this.el);
                    return position == "fixed" && display != "none";
                }
            })();
            const bbox = !displayed ? new bbox_1.BBox() : (() => {
                const self = this.el.getBoundingClientRect();
                const { left, top } = (() => {
                    if (this.parent != null) {
                        const parent = this.parent.el.getBoundingClientRect();
                        return {
                            left: self.left - parent.left,
                            top: self.top - parent.top,
                        };
                    }
                    else {
                        return { left: 0, top: 0 };
                    }
                })();
                return new bbox_1.BBox({
                    left: round(left),
                    top: round(top),
                    width: floor(self.width),
                    height: floor(self.height),
                });
            })();
            const changed = !this._bbox.equals(bbox);
            this._bbox = bbox;
            this._is_displayed = displayed;
            return changed;
        }
        /**
         * Allows to provide a context dependent menu when `UIElement.context_menu` is `"auto"`.
         */
        _provide_context_menu() {
            return null;
        }
        initialize() {
            super.initialize();
            this._resize_observer = new ResizeObserver((_entries) => this.after_resize());
            this._resize_observer.observe(this.el, { box: "border-box" });
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            const menu = (() => {
                const { context_menu } = this.model;
                if (context_menu == "auto") {
                    return this._provide_context_menu();
                }
                else {
                    return context_menu;
                }
            })();
            if (menu != null) {
                this._context_menu = await (0, build_views_1.build_view)(menu, { parent: this });
            }
        }
        connect_signals() {
            super.connect_signals();
            const { visible } = this.model.properties;
            this.on_change(visible, () => this._update_visible());
            this.el.addEventListener("contextmenu", (event) => this.show_context_menu(event));
        }
        get_context_menu(_xy) {
            return this._context_menu;
        }
        show_context_menu(event) {
            if (!event.shiftKey) {
                const rect = this.el.getBoundingClientRect();
                const x = event.x - rect.x;
                const y = event.y - rect.y;
                const context_menu = this.get_context_menu({ x, y });
                if (context_menu != null) {
                    if (context_menu.show({ x, y })) {
                        event.stopPropagation();
                        event.preventDefault();
                    }
                }
            }
        }
        remove() {
            this._resize_observer.disconnect();
            this._context_menu?.remove();
            super.remove();
        }
        _after_resize() { }
        after_resize() {
            this._resized = true;
            if (this.update_bbox()) {
                this._after_resize();
            }
            this.finish();
        }
        render() {
            super.render();
            this._apply_visible();
        }
        _after_render() {
            this.update_style();
            this.update_bbox();
        }
        after_render() {
            super.after_render();
            this._after_render();
            if (!this._has_finished) {
                // If not displayed, then after_resize() will not be called.
                if (!this.is_displayed) {
                    this.force_finished();
                }
                else {
                    // In case after_resize() wasn't called (see regression test for issue
                    // #9113), then wait one macro task and consider this view finished.
                    void (0, defer_1.defer)().then(() => {
                        if (!this._resized) {
                            this.finish();
                        }
                    });
                }
            }
        }
        get is_displayed() {
            return this._is_displayed;
        }
        _apply_visible() {
            if (this.model.visible) {
                this.display.clear();
            }
            else {
                this.display.replace(":host { display: none; }");
            }
        }
        _update_visible() {
            this._apply_visible();
        }
        export(type = "auto", hidpi = true) {
            const output_backend = type == "auto" || type == "png" ? "canvas" : "svg";
            const canvas = new canvas_1.CanvasLayer(output_backend, hidpi);
            const { width, height } = this.bbox;
            canvas.resize(width, height);
            return canvas;
        }
        resolve_symbol(node) {
            const value = this.bbox.resolve(node.symbol);
            const { offset } = node;
            if ((0, types_1.isNumber)(value)) {
                return value + offset;
            }
            else {
                const { x, y } = value;
                return { x: x + offset, y: y + offset };
            }
        }
    }
    exports.UIElementView = UIElementView;
    UIElementView.__name__ = "UIElementView";
    class UIElement extends styled_element_1.StyledElement {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.UIElement = UIElement;
    _a = UIElement;
    UIElement.__name__ = "UIElement";
    (() => {
        _a.define(({ Bool, AnyRef, Nullable, Or, Auto }) => ({
            visible: [Bool, true],
            context_menu: [Nullable(Or(AnyRef(), Auto)), null],
        }));
    })();
},
/* core/util/canvas.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const svg_1 = require(113) /* ./svg */;
    const bbox_1 = require(64) /* ./bbox */;
    const dom_1 = require(63) /* ../dom */;
    class CanvasLayer {
        get canvas() {
            return this._canvas;
        }
        get ctx() {
            return this._ctx;
        }
        get el() {
            return this._el;
        }
        get pixel_ratio() {
            return this._pixel_ratio;
        }
        constructor(backend, hidpi) {
            this._pixel_ratio = 1;
            this.bbox = new bbox_1.BBox();
            this.backend = backend;
            this.hidpi = hidpi;
            switch (backend) {
                case "webgl":
                case "canvas": {
                    this._el = this._canvas = (0, dom_1.canvas)({ class: "bk-layer" });
                    const ctx = this.canvas.getContext("2d");
                    if (ctx == null) {
                        throw new Error("unable to obtain 2D rendering context");
                    }
                    this._ctx = ctx;
                    if (hidpi) {
                        this._pixel_ratio = devicePixelRatio;
                    }
                    break;
                }
                case "svg": {
                    const ctx = new svg_1.SVGRenderingContext2D();
                    this._ctx = ctx;
                    this._canvas = ctx.get_svg();
                    this._el = (0, dom_1.div)({ class: "bk-layer" });
                    const shadow_el = this._el.attachShadow({ mode: "open" });
                    shadow_el.appendChild(this._canvas);
                    break;
                }
            }
            Object.assign(this._ctx, {
                layer: this,
                rect_bbox(bbox) {
                    const { x, y, width, height } = bbox;
                    this.rect(x, y, width, height);
                },
            });
        }
        get pixel_ratio_changed() {
            if (this.hidpi && (this.backend == "canvas" || this.backend == "webgl")) {
                return this.pixel_ratio != devicePixelRatio;
            }
            else {
                return false;
            }
        }
        resize(width, height) {
            const size_changed = this.bbox.width != width || this.bbox.height != height;
            const { pixel_ratio_changed } = this;
            if (!size_changed && !pixel_ratio_changed) {
                return;
            }
            if (pixel_ratio_changed) {
                this._pixel_ratio = devicePixelRatio;
            }
            this.bbox = new bbox_1.BBox({ left: 0, top: 0, width, height });
            const { target } = this;
            target.width = width * this.pixel_ratio;
            target.height = height * this.pixel_ratio;
        }
        get target() {
            return this._ctx instanceof svg_1.SVGRenderingContext2D ? this._ctx : this.canvas;
        }
        undo_transform(fn) {
            const { ctx } = this;
            const current_transform = ctx.getTransform();
            ctx.resetTransform();
            try {
                fn(ctx);
            }
            finally {
                ctx.setTransform(current_transform);
            }
        }
        prepare() {
            const { ctx, hidpi, pixel_ratio } = this;
            ctx.save();
            if (hidpi) {
                ctx.scale(pixel_ratio, pixel_ratio);
                ctx.translate(0.5, 0.5);
            }
            this.clear();
            return ctx;
        }
        clear() {
            const { x, y, width, height } = this.bbox;
            this.ctx.clearRect(x, y, width, height);
        }
        finish() {
            this.ctx.restore();
        }
        to_blob() {
            const { _canvas } = this;
            if (_canvas instanceof HTMLCanvasElement) {
                return new Promise((resolve, reject) => {
                    _canvas.toBlob((blob) => blob != null ? resolve(blob) : reject(), "image/png");
                });
            }
            else {
                const ctx = this._ctx;
                const svg = ctx.get_serialized_svg(true);
                const blob = new Blob([svg], { type: "image/svg+xml" });
                return Promise.resolve(blob);
            }
        }
    }
    exports.CanvasLayer = CanvasLayer;
    CanvasLayer.__name__ = "CanvasLayer";
},
/* core/util/svg.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    /**
     * Based on https://github.com/gliffy/canvas2svg
     */
    const affine_1 = require(114) /* ./affine */;
    const types_1 = require(8) /* ./types */;
    const color_1 = require(23) /* ./color */;
    const object_1 = require(9) /* ./object */;
    const random_1 = require(115) /* ./random */;
    const math_1 = require(11) /* ./math */;
    const dom_1 = require(63) /* ../dom */;
    // helper function to map named to numbered entities
    function createNamedToNumberedLookup(input, radix) {
        const lookup = new Map();
        const items = input.split(",");
        radix = radix ?? 10;
        // Map from named to numbered entities.
        for (let i = 0; i < items.length; i += 2) {
            const entity = `&${items[i + 1]};`;
            const base10 = parseInt(items[i], radix);
            lookup.set(entity, `&#${base10};`);
        }
        // FF and IE need to create a regex from hex values ie &nbsp; == \xa0
        lookup.set("\\xa0", "&#160;");
        return lookup;
    }
    // helper function to map canvas-textAlign to svg-textAnchor
    function getTextAnchor(textAlign) {
        // TODO: support rtl languages
        const mapping = { left: "start", right: "end", center: "middle", start: "start", end: "end" };
        return textAlign in mapping ? mapping[textAlign] : mapping.start;
    }
    // helper function to map canvas-textBaseline to svg-dominantBaseline
    function getDominantBaseline(textBaseline) {
        // INFO: not supported in all browsers
        const mapping = { alphabetic: "alphabetic", hanging: "hanging", top: "text-before-edge", bottom: "text-after-edge", middle: "central" };
        return textBaseline in mapping ? mapping[textBaseline] : mapping.alphabetic;
    }
    // Unpack entities lookup where the numbers are in radix 32 to reduce the size
    // entity mapping courtesy of tinymce
    const namedEntities = createNamedToNumberedLookup("50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy," +
        "5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute," +
        "5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34," +
        "5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil," +
        "68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde," +
        "6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute," +
        "6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml," +
        "75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc," +
        "7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash," +
        "7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta," +
        "sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu," +
        "st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi," +
        "t9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota," +
        "tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau," +
        "u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip," +
        "81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym," +
        "8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr," +
        "8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod," +
        "8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup," +
        "8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4," +
        "nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob," +
        "rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0," +
        "Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm," +
        "80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger," +
        "811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro", 32);
    // Some basic mappings for attributes and default values.
    const STYLES = {
        strokeStyle: {
            svgAttr: "stroke", // corresponding svg attribute
            canvas: "#000000", // canvas default
            svg: "none", // svg default
            apply: "stroke", // apply on stroke() or fill()
        },
        fillStyle: {
            svgAttr: "fill",
            canvas: "#000000",
            svg: null, // svg default is black, but we need to special case this to handle canvas stroke without fill
            apply: "fill",
        },
        lineCap: {
            svgAttr: "stroke-linecap",
            canvas: "butt",
            svg: "butt",
            apply: "stroke",
        },
        lineJoin: {
            svgAttr: "stroke-linejoin",
            canvas: "miter",
            svg: "miter",
            apply: "stroke",
        },
        miterLimit: {
            svgAttr: "stroke-miterlimit",
            canvas: 10,
            svg: 4,
            apply: "stroke",
        },
        lineWidth: {
            svgAttr: "stroke-width",
            canvas: 1,
            svg: 1,
            apply: "stroke",
        },
        globalAlpha: {
            svgAttr: "opacity",
            canvas: 1,
            svg: 1,
            apply: "fill stroke",
        },
        shadowColor: {
            canvas: "#000000",
        },
        shadowOffsetX: {
            canvas: 0,
        },
        shadowOffsetY: {
            canvas: 0,
        },
        shadowBlur: {
            canvas: 0,
        },
        lineDash: {
            svgAttr: "stroke-dasharray",
            canvas: [],
            svg: null,
            apply: "stroke",
        },
        lineDashOffset: {
            svgAttr: "stroke-dashoffset",
            canvas: 0,
            svg: 0,
            apply: "stroke",
        },
        direction: {
            canvas: "inherit",
        },
        font: {
            // font converts to multiple svg attributes, there is custom logic for this
            canvas: "10px sans-serif",
        },
        fontKerning: {
            canvas: "auto",
        },
        fontStretch: {
            canvas: "normal",
        },
        fontVariantCaps: {
            canvas: "normal",
        },
        letterSpacing: {
            canvas: "0px",
        },
        textAlign: {
            canvas: "start",
        },
        textBaseline: {
            canvas: "alphabetic",
        },
        textRendering: {
            canvas: "auto",
        },
        wordSpacing: {
            canvas: "0px",
        },
    };
    function is_VideoFrame(image) {
        return typeof VideoFrame !== "undefined" && image instanceof VideoFrame;
    }
    function width_height(image) {
        if (is_VideoFrame(image)) {
            return [image.codedWidth, image.codedHeight]; // TODO not sure if this makes any sense
        }
        else {
            function to_number(val) {
                return (0, types_1.isNumber)(val) ? val : val.baseVal.value;
            }
            const { width, height } = image;
            return [to_number(width), to_number(height)];
        }
    }
    class CanvasGradient {
        constructor(gradientNode, ctx) {
            this.__root = gradientNode;
            this.__ctx = ctx;
        }
        /**
         * Adds a color stop to the gradient root
         */
        addColorStop(offset, color) {
            if (this.__root.nodeName === "linearGradient" &&
                this.__root.getAttribute("x1") === this.__root.getAttribute("x2") &&
                this.__root.getAttribute("y1") === this.__root.getAttribute("y2")) {
                return;
            }
            if (this.__root.nodeName === "radialGradient" &&
                this.__root.getAttribute("cx") === this.__root.getAttribute("fx") &&
                this.__root.getAttribute("cy") === this.__root.getAttribute("fy") &&
                this.__root.getAttribute("r") === this.__root.getAttribute("r0")) {
                return;
            }
            const stop = this.__ctx.__createElement("stop");
            stop.setAttribute("offset", `${offset}`);
            if (color.indexOf("rgba") !== -1) {
                // separate alpha value, since webkit can't handle it
                const regex = /rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi;
                const matches = regex.exec(color);
                const [, r, g, b, a] = matches;
                stop.setAttribute("stop-color", `rgb(${r},${g},${b})`);
                stop.setAttribute("stop-opacity", a);
            }
            else {
                stop.setAttribute("stop-color", color);
            }
            this.__root.appendChild(stop);
        }
    }
    CanvasGradient.__name__ = "CanvasGradient";
    class CanvasPattern {
        constructor(pattern, ctx) {
            this.__root = pattern;
            this.__ctx = ctx;
        }
        setTransform(_transform) {
            throw new Error("not implemented");
        }
    }
    CanvasPattern.__name__ = "CanvasPattern";
    class SVGRenderingContext2D {
        get canvas() {
            // XXX: point back to this instance
            return this;
        }
        get width() {
            return this._width;
        }
        set width(width) {
            this._width = width;
            this.__root.setAttribute("width", `${width}`);
        }
        get height() {
            return this._height;
        }
        set height(height) {
            this._height = height;
            this.__root.setAttribute("height", `${height}`);
        }
        constructor(options) {
            this.__currentDefaultPath = "";
            this.__currentPosition = null;
            this.globalAlpha = 1.0;
            this._transform = new affine_1.AffineTransform();
            this._clip_path = null;
            this.__document = options?.document ?? document;
            // allow passing in an existing context to wrap around
            // if a context is passed in, we know a canvas already exist
            if (options?.ctx != null) {
                this.__ctx = options.ctx;
            }
            else {
                this.__canvas = this.__document.createElement("canvas");
                this.__ctx = this.__canvas.getContext("2d");
            }
            this.reset();
            // the root svg element
            this.__root = this.__document.createElementNS("http://www.w3.org/2000/svg", "svg");
            this.__root.setAttribute("version", "1.1");
            this.__root.setAttribute("xmlns", "http://www.w3.org/2000/svg");
            this.__currentElement = this.__root;
            this.width = options?.width ?? 500;
            this.height = options?.height ?? 500;
            // make sure we don't generate the same ids in defs
            this.__ids = new Set();
            // defs tag
            this.__defs = this.__document.createElementNS("http://www.w3.org/2000/svg", "defs");
            this.__root.appendChild(this.__defs);
        }
        // helper function that generates a random string
        _random_string() {
            const chars = "ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz";
            let str;
            do {
                str = SVGRenderingContext2D.__random.choices(12, chars).join("");
            } while (this.__ids.has(str));
            return str;
        }
        /**
         * Creates the specified svg element
         */
        __createElement(elementName, properties = {}, resetFill = false) {
            const element = this.__document.createElementNS("http://www.w3.org/2000/svg", elementName);
            if (resetFill) {
                // if fill or stroke is not specified, the svg element should not display. By default SVG's fill is black.
                element.setAttribute("fill", "none");
                element.setAttribute("stroke", "none");
            }
            const keys = Object.keys(properties);
            for (const key of keys) {
                element.setAttribute(key, `${properties[key]}`);
            }
            return element;
        }
        /**
         * Applies default canvas styles to the context
         */
        __setDefaultStyles() {
            // default 2d canvas context properties see:http://www.w3.org/TR/2dcontext/
            for (const [key, val] of (0, object_1.typed_entries)(STYLES)) {
                this[key] = val.canvas;
            }
        }
        /**
         * Applies styles on restore
         */
        __applyStyleState(style_state) {
            for (const [key, val] of (0, object_1.typed_entries)(style_state)) {
                this[key] = val;
            }
        }
        /**
         * Gets the current style state
         */
        __getStyleState() {
            const style_state = {};
            for (const [key, _val] of (0, object_1.typed_entries)(STYLES)) {
                style_state[key] = this[key];
            }
            return style_state;
        }
        /**
         * Apples the current styles to the current SVG element. On "ctx.fill" or "ctx.stroke"
         */
        __applyStyleToCurrentElement(type) {
            const currentElement = this.__currentElement;
            /*
            const currentStyleGroup = this.__currentElementsToStyle
            if (currentStyleGroup != null) {
              currentElement.setAttribute(type, "")
              currentElement = currentStyleGroup.element
              for (const node of currentStyleGroup.children) {
                node.setAttribute(type, "")
              }
            }
            */
            for (const [key, style] of (0, object_1.typed_entries)(STYLES)) {
                const value = this[key];
                if (style.apply != null && style.apply.includes(type)) {
                    if (value instanceof CanvasPattern) {
                        for (const def of [...value.__ctx.__defs.childNodes]) {
                            if (def instanceof Element) {
                                const id = def.getAttribute("id");
                                this.__ids.add(id);
                                this.__defs.appendChild(def);
                            }
                        }
                        const id = value.__root.getAttribute("id");
                        currentElement.setAttribute(style.apply, `url(#${id})`);
                    }
                    else if (value instanceof CanvasGradient) {
                        const id = value.__root.getAttribute("id");
                        currentElement.setAttribute(style.apply, `url(#${id})`);
                    }
                    else if (style.svg !== value) {
                        if ((style.svgAttr === "stroke" || style.svgAttr === "fill") && (0, types_1.isString)(value) && value.indexOf("rgb") !== -1) {
                            // convert CSS4 -> CSS3 and separate alpha value, since illustrator can't handle it
                            const [r, g, b, a] = (0, color_1.css4_parse)(value) ?? (0, color_1.transparent)();
                            const opacity = a * this.globalAlpha;
                            currentElement.setAttribute(style.svgAttr, `rgb(${r},${g},${b})`);
                            currentElement.setAttribute(`${style.svgAttr}-opacity`, `${opacity}`);
                        }
                        else {
                            let attr = style.svgAttr;
                            if (key === "globalAlpha") {
                                attr = `${type}-${style.svgAttr}`;
                                if (currentElement.getAttribute(attr) != null) {
                                    // fill-opacity or stroke-opacity has already been set by stroke or fill.
                                    continue;
                                }
                            }
                            // otherwise only update attribute if right type, and not svg default
                            currentElement.setAttribute(attr, `${value}`);
                        }
                    }
                }
            }
        }
        /**
          * Returns the serialized value of the svg so far
          * @param fixNamedEntities - Standalone SVG doesn't support named entities, which document.createTextNode encodes.
          *                           If true, we attempt to find all named entities and encode it as a numeric entity.
          * @return serialized svg
          */
        get_serialized_svg(fixNamedEntities = false) {
            let serialized = new XMLSerializer().serializeToString(this.__root);
            if (fixNamedEntities) {
                // loop over each named entity and replace with the proper equivalent.
                for (const [key, value] of namedEntities) {
                    const regexp = new RegExp(key, "gi");
                    if (regexp.test(serialized)) {
                        serialized = serialized.replace(regexp, value);
                    }
                }
            }
            return serialized;
        }
        get_svg() {
            return this.__root;
        }
        /**
          * Will generate a group tag.
          */
        save() {
            this.__stack.push({
                transform: this._transform,
                clip_path: this._clip_path,
                attributes: this.__getStyleState(),
            });
            this._transform = this._transform.clone();
        }
        /**
          * Sets current element to parent, or just root if already root
          */
        restore() {
            if (this.__stack.length == 0) {
                return;
            }
            const { transform, clip_path, attributes } = this.__stack.pop();
            this._transform = transform;
            this._clip_path = clip_path;
            this.__applyStyleState(attributes);
        }
        isContextLost() {
            return false;
        }
        reset() {
            this.__setDefaultStyles();
            this.__stack = [];
        }
        _apply_transform(element, transform = this._transform) {
            if (!transform.is_identity) {
                element.setAttribute("transform", transform.toString());
            }
        }
        _apply_global_alpha(element) {
            if (this.globalAlpha != 1.0) {
                element.setAttribute("opacity", `${this.globalAlpha}`);
            }
        }
        _apply_clip_path(element) {
            if (this._clip_path != null) {
                element.setAttribute("clip-path", this._clip_path);
            }
        }
        /**
          *  scales the current element
          */
        scale(x, y) {
            if (!isFinite(x) || (y != null && !isFinite(y))) {
                return;
            }
            this._transform.scale(x, y ?? x);
        }
        /**
          * rotates the current element
          */
        rotate(angle) {
            if (!isFinite(angle)) {
                return;
            }
            this._transform.rotate(angle);
        }
        /**
          * translates the current element
          */
        translate(x, y) {
            if (!isFinite(x + y)) {
                return;
            }
            this._transform.translate(x, y);
        }
        /**
          * applies a transform to the current element
          */
        transform(a, b, c, d, e, f) {
            if (!isFinite(a + b + c + d + e + f)) {
                return;
            }
            this._transform.transform(a, b, c, d, e, f);
        }
        /**
          * Create a new Path Element
          */
        beginPath() {
            // Note that there is only one current default path, it is not part of the drawing state.
            // See also: https://html.spec.whatwg.org/multipage/scripting.html#current-default-path
            this.__currentDefaultPath = "";
            this.__currentPosition = null;
            this.__init_element();
        }
        __init_element() {
            const path = this.__createElement("path", {}, true);
            this.__root.appendChild(path);
            this.__currentElement = path;
        }
        /**
          * Helper function to apply currentDefaultPath to current path element
          */
        __applyCurrentDefaultPath() {
            const currentElement = this.__currentElement;
            if (currentElement.nodeName === "path") {
                currentElement.setAttribute("d", this.__currentDefaultPath);
            }
            else {
                console.error("Attempted to apply path command to node", currentElement.nodeName);
            }
        }
        /**
          * Helper function to add path command
          */
        __addPathCommand(x, y, path) {
            const separator = this.__currentDefaultPath == "" ? "" : " ";
            this.__currentDefaultPath += separator + path;
            this.__currentPosition = { x, y };
        }
        get _hasCurrentDefaultPath() {
            return this.__currentDefaultPath != "";
        }
        /**
          * Adds the move command to the current path element,
          * if the currentPathElement is not empty create a new path element
          */
        moveTo(x, y) {
            if (!isFinite(x + y)) {
                return;
            }
            const currentElement = this.__currentElement;
            if (currentElement.nodeName !== "path") {
                this.beginPath();
            }
            // creates a new subpath with the given point
            const [tx, ty] = this._transform.apply(x, y);
            this.__addPathCommand(tx, ty, `M ${tx} ${ty}`);
        }
        /**
          * Closes the current path
          */
        closePath() {
            if (this._hasCurrentDefaultPath) {
                this.__addPathCommand(NaN, NaN, "Z");
            }
        }
        /**
          * Adds a line to command
          */
        lineTo(x, y) {
            if (!isFinite(x + y)) {
                return;
            }
            if (!this._hasCurrentDefaultPath) {
                this.moveTo(x, y);
            }
            else {
                const [tx, ty] = this._transform.apply(x, y);
                this.__addPathCommand(tx, ty, `L ${tx} ${ty}`);
            }
        }
        /**
          * Add a bezier command
          */
        bezierCurveTo(cp1x, cp1y, cp2x, cp2y, x, y) {
            if (!isFinite(cp1x + cp1y + cp2x + cp2y + x + y)) {
                return;
            }
            const [tx, ty] = this._transform.apply(x, y);
            const [tcp1x, tcp1y] = this._transform.apply(cp1x, cp1y);
            const [tcp2x, tcp2y] = this._transform.apply(cp2x, cp2y);
            this.__addPathCommand(tx, ty, `C ${tcp1x} ${tcp1y} ${tcp2x} ${tcp2y} ${tx} ${ty}`);
        }
        /**
          * Adds a quadratic curve to command
          */
        quadraticCurveTo(cpx, cpy, x, y) {
            if (!isFinite(cpx + cpy + x + y)) {
                return;
            }
            const [tx, ty] = this._transform.apply(x, y);
            const [tcpx, tcpy] = this._transform.apply(cpx, cpy);
            this.__addPathCommand(tx, ty, `Q ${tcpx} ${tcpy} ${tx} ${ty}`);
        }
        /**
          * Adds the arcTo to the current path
          *
          * @see http://www.w3.org/TR/2015/WD-2dcontext-20150514/#dom-context-2d-arcto
          */
        arcTo(x1, y1, x2, y2, radius) {
            if (!isFinite(x1 + y1 + x2 + y2 + radius)) {
                return;
            }
            // Let the point (x0, y0) be the last point in the subpath.
            if (this.__currentPosition == null) {
                return;
            }
            // Issue #12699.
            // this.__currentPosition has already been transformed using this._transform.
            // Arguments to this function have not been transformed, so to compare the two need
            // to inverse transform this.__currentPosition.
            const inverse = this._transform.inverse();
            const [x0, y0] = inverse.apply(this.__currentPosition.x, this.__currentPosition.y);
            // Negative values for radius must cause the implementation to throw an IndexSizeError exception.
            if (radius < 0) {
                throw new Error(`IndexSizeError: The radius provided (${radius}) is negative.`);
            }
            // If the point (x0, y0) is equal to the point (x1, y1),
            // or if the point (x1, y1) is equal to the point (x2, y2),
            // or if the radius radius is zero,
            // then the method must add the point (x1, y1) to the subpath,
            // and connect that point to the previous point (x0, y0) by a straight line.
            if (((x0 === x1) && (y0 === y1)) || ((x1 === x2) && (y1 === y2)) || (radius === 0)) {
                this.lineTo(x1, y1);
                return;
            }
            function normalize([x, y]) {
                const len = Math.sqrt(x ** 2 + y ** 2);
                return [x / len, y / len];
            }
            // Otherwise, if the points (x0, y0), (x1, y1), and (x2, y2) all lie on a single straight line,
            // then the method must add the point (x1, y1) to the subpath,
            // and connect that point to the previous point (x0, y0) by a straight line.
            const unit_vec_p1_p0 = normalize([x0 - x1, y0 - y1]);
            const unit_vec_p1_p2 = normalize([x2 - x1, y2 - y1]);
            if (unit_vec_p1_p0[0] * unit_vec_p1_p2[1] === unit_vec_p1_p0[1] * unit_vec_p1_p2[0]) {
                this.lineTo(x1, y1);
                return;
            }
            // Otherwise, let The Arc be the shortest arc given by circumference of the circle that has radius radius,
            // and that has one point tangent to the half-infinite line that crosses the point (x0, y0) and ends at the point (x1, y1),
            // and that has a different point tangent to the half-infinite line that ends at the point (x1, y1), and crosses the point (x2, y2).
            // The points at which this circle touches these two lines are called the start and end tangent points respectively.
            // note that both vectors are unit vectors, so the length is 1
            const cos = (unit_vec_p1_p0[0] * unit_vec_p1_p2[0] + unit_vec_p1_p0[1] * unit_vec_p1_p2[1]);
            const theta = Math.acos(Math.abs(cos));
            // Calculate origin
            const unit_vec_p1_origin = normalize([
                unit_vec_p1_p0[0] + unit_vec_p1_p2[0],
                unit_vec_p1_p0[1] + unit_vec_p1_p2[1],
            ]);
            const len_p1_origin = radius / Math.sin(theta / 2);
            const x = x1 + len_p1_origin * unit_vec_p1_origin[0];
            const y = y1 + len_p1_origin * unit_vec_p1_origin[1];
            // Calculate start angle and end angle
            // rotate 90deg clockwise (note that y axis points to its down)
            const unit_vec_origin_start_tangent = [
                -unit_vec_p1_p0[1],
                unit_vec_p1_p0[0],
            ];
            // rotate 90deg counter clockwise (note that y axis points to its down)
            const unit_vec_origin_end_tangent = [
                unit_vec_p1_p2[1],
                -unit_vec_p1_p2[0],
            ];
            function getAngle(vector) {
                // get angle (clockwise) between vector and (1, 0)
                const x = vector[0];
                const y = vector[1];
                if (y >= 0) { // note that y axis points to its down
                    return Math.acos(x);
                }
                else {
                    return -Math.acos(x);
                }
            }
            const startAngle = getAngle(unit_vec_origin_start_tangent);
            const endAngle = getAngle(unit_vec_origin_end_tangent);
            // Connect the point (x0, y0) to the start tangent point by a straight line
            this.lineTo(x + unit_vec_origin_start_tangent[0] * radius, y + unit_vec_origin_start_tangent[1] * radius);
            // Connect the start tangent point to the end tangent point by arc
            // and adding the end tangent point to the subpath.
            this.arc(x, y, radius, startAngle, endAngle);
        }
        /**
          * Sets the stroke property on the current element
          */
        stroke() {
            if (this.__currentElement.nodeName === "path") {
                this.__currentElement.setAttribute("paint-order", "fill");
            }
            this.__applyCurrentDefaultPath();
            this.__applyStyleToCurrentElement("stroke");
            if (this._clip_path != null) {
                this.__currentElement.setAttribute("clip-path", this._clip_path);
            }
        }
        fill(path_or_fill_rule, fill_rule) {
            let path = null;
            if (path_or_fill_rule instanceof Path2D) {
                path = path_or_fill_rule;
            }
            else if (fill_rule == null) {
                fill_rule = path_or_fill_rule;
            }
            else {
                throw new Error("invalid arguments");
            }
            if (path != null) {
                throw new Error("not implemented");
            }
            // XXX: hack (?) to allow fill and hatch visuals on same canvas path
            if (this.__currentElement.getAttribute("fill") != "none") {
                this.__init_element();
            }
            if (this.__currentElement.nodeName === "path") {
                this.__currentElement.setAttribute("paint-order", "stroke");
            }
            this.__applyCurrentDefaultPath();
            this.__applyStyleToCurrentElement("fill");
            if (fill_rule != null && fill_rule != "nonzero") { // don't apply the default
                this.__currentElement.setAttribute("fill-rule", fill_rule);
            }
            if (this._clip_path != null) {
                this.__currentElement.setAttribute("clip-path", this._clip_path);
            }
        }
        /**
          *  Adds a rectangle to the path.
          */
        rect(x, y, width, height) {
            if (!isFinite(x + y + width + height)) {
                return;
            }
            this.moveTo(x, y);
            this.lineTo(x + width, y);
            this.lineTo(x + width, y + height);
            this.lineTo(x, y + height);
            this.lineTo(x, y);
            this.closePath();
        }
        /**
          * adds a rectangle element
          */
        fillRect(x, y, width, height) {
            if (!isFinite(x + y + width + height)) {
                return;
            }
            this.beginPath();
            this.rect(x, y, width, height);
            this.fill();
        }
        /**
          * Draws a rectangle with no fill
          * @param x
          * @param y
          * @param width
          * @param height
          */
        strokeRect(x, y, width, height) {
            if (!isFinite(x + y + width + height)) {
                return;
            }
            this.beginPath();
            this.rect(x, y, width, height);
            this.stroke();
        }
        /**
          * Clear entire canvas:
          * 1. save current transforms
          * 2. remove all the childNodes of the root g element
          */
        __clearCanvas() {
            (0, dom_1.empty)(this.__defs);
            (0, dom_1.empty)(this.__root);
            this.__root.appendChild(this.__defs);
            this.__currentElement = this.__root;
        }
        /**
          * "Clears" a canvas by just drawing a white rectangle in the current group.
          */
        clearRect(x, y, width, height) {
            if (!isFinite(x + y + width + height)) {
                return;
            }
            if (x === 0 && y === 0 && width === this.width && height === this.height) {
                this.__clearCanvas();
                return;
            }
            const rect = this.__createElement("rect", { x, y, width, height, fill: "#FFFFFF" }, true);
            this._apply_transform(rect);
            this.__root.appendChild(rect);
        }
        roundRect(_x, _y, _w, _h, _radii) {
            throw new Error("not implemented");
        }
        /**
          * Adds a linear gradient to a defs tag.
          * Returns a canvas gradient object that has a reference to it's parent def
          */
        createLinearGradient(x1, y1, x2, y2) {
            if (!isFinite(x1 + y1 + x2 + y2)) {
                throw new Error("The provided double value is non-finite");
            }
            const [tx1, ty1] = this._transform.apply(x1, y1);
            const [tx2, ty2] = this._transform.apply(x2, y2);
            const grad = this.__createElement("linearGradient", {
                id: this._random_string(),
                x1: `${tx1}px`,
                x2: `${tx2}px`,
                y1: `${ty1}px`,
                y2: `${ty2}px`,
                gradientUnits: "userSpaceOnUse",
            }, false);
            this.__defs.appendChild(grad);
            return new CanvasGradient(grad, this);
        }
        /**
          * Adds a radial gradient to a defs tag.
          * Returns a canvas gradient object that has a reference to it's parent def
          */
        createRadialGradient(x0, y0, r0, x1, y1, r1) {
            if (!isFinite(x0 + y0 + r0 + x1 + y1 + r1)) {
                throw new Error("The provided double value is non-finite");
            }
            const [tx0, ty0] = this._transform.apply(x0, y0);
            const [tx1, ty1] = this._transform.apply(x1, y1);
            const grad = this.__createElement("radialGradient", {
                id: this._random_string(),
                cx: `${tx1}px`,
                cy: `${ty1}px`,
                r: `${r1}px`,
                r0: `${r0}px`,
                fx: `${tx0}px`,
                fy: `${ty0}px`,
                gradientUnits: "userSpaceOnUse",
            }, false);
            this.__defs.appendChild(grad);
            return new CanvasGradient(grad, this);
        }
        createConicGradient(_start_angle, _x, _y) {
            throw Error("not implemented");
        }
        /**
          * Parses the font string and returns svg mapping
          */
        __parseFont() {
            const regex = /^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-,\'\"\sa-z0-9]+?)\s*$/i;
            const [, style, decoration, weight, size, , family] = regex.exec(this.font); // XXX: RegExpExecArray is incorrecdt
            const data = {
                style: style ?? "normal",
                size: size ?? "10px",
                family: family ?? "sans-serif",
                weight: weight ?? "normal",
                decoration: decoration ?? "normal",
            };
            return data;
        }
        /**
          * Fills or strokes text
          */
        __applyText(text, x, y, action) {
            const font = this.__parseFont();
            const text_el = this.__createElement("text", {
                "font-family": font.family,
                "font-size": font.size,
                "font-style": font.style,
                "font-weight": font.weight,
                "text-decoration": font.decoration,
                x,
                y,
                "text-anchor": getTextAnchor(this.textAlign),
                "dominant-baseline": getDominantBaseline(this.textBaseline),
            }, true);
            text_el.appendChild(this.__document.createTextNode(text));
            this._apply_transform(text_el);
            this.__currentElement = text_el;
            this.__applyStyleToCurrentElement(action);
            const el = (() => {
                if (this._clip_path != null) {
                    const g = this.__createElement("g");
                    g.setAttribute("clip-path", this._clip_path);
                    g.appendChild(text_el);
                    return g;
                }
                else {
                    return text_el;
                }
            })();
            this.__root.appendChild(el);
        }
        /**
          * Creates a text element, in position x,y
          */
        fillText(text, x, y) {
            if (!isFinite(x + y)) {
                return;
            }
            this.__applyText(text, x, y, "fill");
        }
        /**
          * Strokes text
          */
        strokeText(text, x, y) {
            if (!isFinite(x + y)) {
                return;
            }
            this.__applyText(text, x, y, "stroke");
        }
        /**
          * No need to implement this for svg.
          */
        measureText(text) {
            this.__ctx.font = this.font;
            return this.__ctx.measureText(text);
        }
        arc(x, y, radius, start_angle, end_angle, counterclockwise = false) {
            this.ellipse(x, y, radius, radius, 0, start_angle, end_angle, counterclockwise);
        }
        ellipse(x, y, radius_x, radius_y, rotation, start_angle, end_angle, counterclockwise = false) {
            if (!isFinite(x + y + radius_x + radius_y + rotation + start_angle + end_angle)) {
                return;
            }
            if (radius_x < 0 || radius_y < 0) {
                throw new DOMException("IndexSizeError, radius can't be negative");
            }
            const initial_diff = counterclockwise ? end_angle - start_angle : start_angle - end_angle;
            start_angle = start_angle % (2 * Math.PI);
            end_angle = end_angle % (2 * Math.PI);
            const transform = new affine_1.AffineTransform().translate(x, y).rotate(rotation);
            const dx = radius_x * Math.cos(start_angle);
            const dy = radius_y * Math.sin(start_angle);
            const [start_x, start_y] = transform.apply(dx, dy);
            this.lineTo(start_x, start_y);
            // Canvas ellipse defines rotation in radians and SVG elliptical arc is defined in degrees
            const rotation_in_degrees = rotation * 180 / Math.PI;
            const sweep_flag = counterclockwise ? 0 : 1;
            /**
             * Check if need to draw full ellipse (issue #11475). When testing if angular difference is
             * equal to an integer multiple of 2*pi radians, need to account for float64 to float32 rounding
             * error on both the start and end angles, hence the factor of 2. Do not assume full circle if
             * start and end angles are close, but test here depends on combination of sign of angular
             * difference and wedge direction (clockwise/counterclockwise) to obtain the same results as on
             * canvas.
             */
            if (Math.abs(start_angle - end_angle) < 2 * math_1.float32_epsilon &&
                !(Math.abs(initial_diff) < 2 * math_1.float32_epsilon && initial_diff < 0)) {
                // Draw full ellipse. SVG elliptical arc cannot do this, so instead use two semi ellipses.
                const [tstart_x, tstart_y] = this._transform.apply(start_x, start_y);
                const dx = radius_x * Math.cos(start_angle + Math.PI);
                const dy = radius_y * Math.sin(start_angle + Math.PI);
                const [mid_x, mid_y] = transform.apply(dx, dy);
                const [tmid_x, tmid_y] = this._transform.apply(mid_x, mid_y);
                this.__addPathCommand(tstart_x, tstart_y, `A ${radius_x} ${radius_y} ${rotation_in_degrees} 0 ${sweep_flag} ${tmid_x} ${tmid_y} A ${radius_x} ${radius_y} ${rotation_in_degrees} 0 ${sweep_flag} ${tstart_x} ${tstart_y}`);
            }
            else {
                // Draw partial ellipse only.
                const dx = radius_x * Math.cos(end_angle);
                const dy = radius_y * Math.sin(end_angle);
                const [end_x, end_y] = transform.apply(dx, dy);
                let diff = end_angle - start_angle;
                // https://github.com/gliffy/canvas2svg/issues/4
                if (diff < 0) {
                    diff += 2 * Math.PI;
                }
                const large_arc_flag = (counterclockwise !== diff > Math.PI) ? 1 : 0; // imitation xor
                const [tend_x, tend_y] = this._transform.apply(end_x, end_y);
                this.__addPathCommand(tend_x, tend_y, `A ${radius_x} ${radius_y} ${rotation_in_degrees} ${large_arc_flag} ${sweep_flag} ${tend_x} ${tend_y}`);
            }
        }
        clip(path_or_fill_rule, fill_rule) {
            let path = null;
            if (path_or_fill_rule instanceof Path2D) {
                path = path_or_fill_rule;
            }
            else if (fill_rule == null) {
                fill_rule = path_or_fill_rule;
            }
            else {
                throw new Error("invalid arguments");
            }
            if (path != null) {
                throw new Error("not implemented");
            }
            const clip_path = this.__createElement("clipPath");
            const id = this._random_string();
            this.__applyCurrentDefaultPath();
            if (fill_rule != null) {
                this.__currentElement.setAttribute("clip-rule", fill_rule);
            }
            clip_path.setAttribute("id", id);
            clip_path.appendChild(this.__currentElement);
            this.__defs.appendChild(clip_path);
            this._clip_path = `url(#${id})`;
        }
        /**
          * Draws a canvas, image or mock context to this canvas.
          * Note that all svg dom manipulation uses node.childNodes rather than node.children for IE support.
          * http://www.whatwg.org/specs/web-apps/current-work/multipage/the-canvas-element.html#dom-context-2d-drawimage
          */
        drawImage(image, ...args) {
            let dx, dy;
            let dw, dh;
            let sx, sy;
            let sw, sh;
            if (args.length == 2) {
                [dx, dy] = args;
                if (!isFinite(dx + dy)) {
                    return;
                }
                sx = 0;
                sy = 0;
                const [w, h] = width_height(image);
                dw = sw = w;
                dh = sh = h;
            }
            else if (args.length == 4) {
                [dx, dy, dw, dh] = args;
                if (!isFinite(dx + dy + dw + dh)) {
                    return;
                }
                sx = 0;
                sy = 0;
                const [w, h] = width_height(image);
                sw = w;
                sh = h;
            }
            else if (args.length === 8) {
                [sx, sy, sw, sh, dx, dy, dw, dh] = args;
                if (!isFinite(sx + sy + sw + sh + dx + dy + dw + dh)) {
                    return;
                }
            }
            else {
                throw new Error(`Invalid number of arguments passed to drawImage: ${arguments.length}`);
            }
            // parent, svg, defs, group, currentElement, svgImage, canvas, context, id
            const parent = this.__root;
            const transform = this._transform.clone().translate(dx, dy);
            if (image instanceof SVGRenderingContext2D || image instanceof SVGSVGElement) {
                // In the future we may want to clone nodes instead.
                // also I'm currently ignoring dw, dh, sw, sh, sx, sy for a mock context.
                const svg_node = image instanceof SVGSVGElement ? image : image.get_svg();
                const svg = svg_node.cloneNode(true);
                let scope;
                if (transform.is_identity && this.globalAlpha == 1.0 && this._clip_path == null) {
                    scope = parent;
                }
                else {
                    scope = this.__createElement("g");
                    parent.appendChild(scope);
                    // `transform` affects `clip-path`, so if both are present, then apply
                    // them separately in `clip-path`, `transform` order.
                    if (this._clip_path != null) {
                        this._apply_clip_path(scope);
                        if (!transform.is_identity) {
                            const outer = scope;
                            scope = this.__createElement("g");
                            outer.appendChild(scope);
                        }
                    }
                    this._apply_transform(scope, transform);
                    this._apply_global_alpha(scope);
                }
                for (const child of [...svg.childNodes]) {
                    if (child instanceof SVGDefsElement) {
                        for (const def of [...child.childNodes]) {
                            if (def instanceof Element) {
                                const id = def.getAttribute("id");
                                this.__ids.add(id);
                                this.__defs.appendChild(def.cloneNode(true));
                            }
                        }
                    }
                    else {
                        scope.appendChild(child.cloneNode(true));
                    }
                }
            }
            else if (image instanceof HTMLImageElement || image instanceof SVGImageElement) {
                const svgImage = this.__createElement("image");
                svgImage.setAttribute("width", `${dw}`);
                svgImage.setAttribute("height", `${dh}`);
                svgImage.setAttribute("preserveAspectRatio", "none");
                if (this.globalAlpha != 1.0) {
                    svgImage.setAttribute("opacity", `${this.globalAlpha}`);
                }
                if (sx != 0 || sy != 0 || sw !== image.width || sh !== image.height) {
                    // crop the image using a temporary canvas
                    const canvas = this.__document.createElement("canvas");
                    canvas.width = dw;
                    canvas.height = dh;
                    const context = canvas.getContext("2d");
                    context.drawImage(image, sx, sy, sw, sh, 0, 0, dw, dh);
                    image = canvas;
                }
                this._apply_transform(svgImage, transform);
                const url = image instanceof HTMLCanvasElement ? image.toDataURL() : image.getAttribute("src");
                svgImage.setAttribute("href", url);
                if (this._clip_path != null) {
                    const scope = this.__createElement("g");
                    scope.setAttribute("clip-path", this._clip_path);
                    scope.appendChild(svgImage);
                    parent.appendChild(scope);
                }
                else {
                    parent.appendChild(svgImage);
                }
            }
            else if (image instanceof HTMLCanvasElement) {
                const svgImage = this.__createElement("image");
                svgImage.setAttribute("width", `${dw}`);
                svgImage.setAttribute("height", `${dh}`);
                svgImage.setAttribute("preserveAspectRatio", "none");
                if (this.globalAlpha != 1.0) {
                    svgImage.setAttribute("opacity", `${this.globalAlpha}`);
                }
                // draw canvas onto temporary canvas so that smoothing can be handled
                const canvas = this.__document.createElement("canvas");
                canvas.width = dw;
                canvas.height = dh;
                const context = canvas.getContext("2d");
                context.imageSmoothingEnabled = false;
                context.drawImage(image, sx, sy, sw, sh, 0, 0, dw, dh);
                image = canvas;
                this._apply_transform(svgImage, transform);
                svgImage.setAttribute("href", image.toDataURL());
                if (this._clip_path != null) {
                    const scope = this.__createElement("g");
                    scope.setAttribute("clip-path", this._clip_path);
                    scope.appendChild(svgImage);
                    parent.appendChild(scope);
                }
                else {
                    parent.appendChild(svgImage);
                }
            }
        }
        /**
          * Generates a pattern tag
          */
        createPattern(image, _repetition) {
            const pattern = this.__document.createElementNS("http://www.w3.org/2000/svg", "pattern");
            const id = this._random_string();
            const [width, height] = width_height(image);
            pattern.setAttribute("id", id);
            pattern.setAttribute("width", `${width}`);
            pattern.setAttribute("height", `${height}`);
            pattern.setAttribute("patternUnits", "userSpaceOnUse");
            if (image instanceof HTMLCanvasElement || image instanceof HTMLImageElement || image instanceof SVGImageElement) {
                const img = this.__document.createElementNS("http://www.w3.org/2000/svg", "image");
                const url = image instanceof HTMLCanvasElement ? image.toDataURL() : image.getAttribute("src");
                img.setAttribute("href", url);
                pattern.appendChild(img);
                this.__defs.appendChild(pattern);
            }
            else if (image instanceof SVGRenderingContext2D) {
                for (const child of [...image.__root.childNodes]) {
                    if (!(child instanceof SVGDefsElement)) {
                        pattern.appendChild(child.cloneNode(true));
                    }
                }
                //pattern.appendChild(image.__root.childNodes[1])
                this.__defs.appendChild(pattern);
            }
            else if (image instanceof SVGSVGElement) {
                for (const child of [...image.childNodes]) {
                    if (!(child instanceof SVGDefsElement)) {
                        pattern.appendChild(child.cloneNode(true));
                    }
                }
                //pattern.appendChild(image.__root.childNodes[1])
                this.__defs.appendChild(pattern);
            }
            else {
                throw new Error("unsupported");
            }
            return new CanvasPattern(pattern, this);
        }
        getLineDash() {
            const { lineDash } = this;
            if ((0, types_1.isString)(lineDash)) {
                return lineDash.split(",").map((v) => parseInt(v));
            }
            else if (lineDash == null) {
                return [];
            }
            else {
                return lineDash;
            }
        }
        setLineDash(segments) {
            if (segments.length > 0) {
                this.lineDash = segments.join(",");
            }
            else {
                this.lineDash = null;
            }
        }
        getTransform() {
            return this._transform.to_DOMMatrix();
        }
        setTransform(...args) {
            let matrix;
            if ((0, types_1.isNumber)(args[0])) {
                matrix = new DOMMatrix(args);
            }
            else if (args[0] instanceof DOMMatrix) {
                matrix = args[0];
            }
            else {
                matrix = new DOMMatrix(Object.values(args[0] == null));
            }
            this._transform = affine_1.AffineTransform.from_DOMMatrix(matrix);
        }
        resetTransform() {
            this._transform = new affine_1.AffineTransform();
        }
        isPointInPath(..._args) {
            throw new Error("not implemented");
        }
        isPointInStroke(..._args) {
            throw new Error("not implemented");
        }
        createImageData(..._args) {
            throw new Error("not implemented");
        }
        getImageData(_sx, _sy, _sw, _sh) {
            throw new Error("not implemented");
        }
        putImageData(..._args) {
            throw new Error("not implemented");
        }
        drawFocusIfNeeded(..._args) {
            throw new Error("not implemented");
        }
        scrollPathIntoView(..._args) {
            throw new Error("not implemented");
        }
    }
    exports.SVGRenderingContext2D = SVGRenderingContext2D;
    SVGRenderingContext2D.__name__ = "SVGRenderingContext2D";
    //__currentElementsToStyle: {element: SVGElement, children: SVGElement[]} | null = null
    SVGRenderingContext2D.__random = random_1.random;
},
/* core/util/affine.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.rotate_around = rotate_around;
    const eq_1 = require(27) /* ./eq */;
    const { sin, cos } = Math;
    class AffineTransform {
        constructor(a = 1, b = 0, c = 0, d = 1, e = 0, f = 0) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
        }
        toString() {
            const { a, b, c, d, e, f } = this;
            return `matrix(${a}, ${b}, ${c}, ${d}, ${e}, ${f})`;
        }
        static from_DOMMatrix(matrix) {
            const { a, b, c, d, e, f } = matrix;
            return new AffineTransform(a, b, c, d, e, f);
        }
        to_DOMMatrix() {
            const { a, b, c, d, e, f } = this;
            return new DOMMatrix([a, b, c, d, e, f]);
        }
        clone() {
            const { a, b, c, d, e, f } = this;
            return new AffineTransform(a, b, c, d, e, f);
        }
        [eq_1.equals](that, cmp) {
            return (cmp.eq(this.a, that.a) &&
                cmp.eq(this.b, that.b) &&
                cmp.eq(this.c, that.c) &&
                cmp.eq(this.d, that.d) &&
                cmp.eq(this.e, that.e) &&
                cmp.eq(this.f, that.f));
        }
        reset() {
            this.a = 1;
            this.b = 0;
            this.c = 0;
            this.d = 1;
            this.e = 0;
            this.f = 0;
        }
        get is_identity() {
            const { a, b, c, d, e, f } = this;
            return a == 1 && b == 0 && c == 0 && d == 1 && e == 0 && f == 0;
        }
        apply_point(p) {
            const [x, y] = this.apply(p.x, p.y);
            return { x, y };
        }
        apply_rect(rect) {
            const p0 = this.apply_point(rect.p0);
            const p1 = this.apply_point(rect.p1);
            const p2 = this.apply_point(rect.p2);
            const p3 = this.apply_point(rect.p3);
            return { p0, p1, p2, p3 };
        }
        apply(x, y) {
            const { a, b, c, d, e, f } = this;
            return [
                a * x + c * y + e,
                b * x + d * y + f,
            ];
        }
        iv_apply(xs, ys) {
            const { a, b, c, d, e, f } = this;
            const n = xs.length;
            for (let i = 0; i < n; i++) {
                const x = xs[i];
                const y = ys[i];
                xs[i] = a * x + c * y + e;
                ys[i] = b * x + d * y + f;
            }
        }
        transform(A, B, C, D, E, F) {
            const { a, b, c, d, e, f } = this;
            this.a = a * A + c * B;
            this.c = a * C + c * D;
            this.e = a * E + c * F + e;
            this.b = b * A + d * B;
            this.d = b * C + d * D;
            this.f = b * E + d * F + f;
            return this;
        }
        translate(tx, ty) {
            return this.transform(1, 0, 0, 1, tx, ty);
        }
        scale(cx, cy) {
            return this.transform(cx, 0, 0, cy, 0, 0);
        }
        skew(sx, sy) {
            return this.transform(1, sy, sx, 1, 0, 0);
        }
        rotate(angle) {
            if (angle == 0) {
                return this;
            }
            const s = sin(angle);
            const c = cos(angle);
            return this.transform(c, s, -s, c, 0, 0);
        }
        rotate_ccw(angle) {
            return this.rotate(-angle);
        }
        rotate_around(x, y, angle) {
            this.translate(x, y);
            this.rotate(angle);
            this.translate(-x, -y);
            return this;
        }
        translate_x(tx) {
            return this.translate(tx, 0);
        }
        translate_y(ty) {
            return this.translate(0, ty);
        }
        flip() {
            return this.scale(-1, -1);
        }
        flip_x() {
            return this.scale(1, -1);
        }
        flip_y() {
            return this.scale(-1, 1);
        }
        inverse() {
            return AffineTransform.from_DOMMatrix(this.to_DOMMatrix().inverse());
        }
    }
    exports.AffineTransform = AffineTransform;
    AffineTransform.__name__ = "AffineTransform";
    function rotate_around(point, center, angle) {
        if (angle == 0) {
            return point;
        }
        else {
            const tr = new AffineTransform();
            tr.rotate_around(center.x, center.y, angle);
            const [x, y] = tr.apply(point.x, point.y);
            return { x, y };
        }
    }
},
/* core/util/random.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const { PI, log, sin, cos, sqrt, floor } = Math;
    exports.MAX_INT32 = 2147483647;
    class AbstractRandom {
        float() {
            return (this.integer() - 1) / (exports.MAX_INT32 - 1);
        }
        floats(n, a = 0, b = 1) {
            const result = new Array(n);
            for (let i = 0; i < n; i++) {
                result[i] = a + this.float() * (b - a);
            }
            return result;
        }
        choices(n, items) {
            const k = items.length;
            const result = new Array(n);
            for (let i = 0; i < n; i++) {
                result[i] = items[this.integer() % k];
            }
            return result;
        }
        uniform(loc, scale) {
            return loc + (this.float() - 0.5) * scale;
        }
        uniforms(loc, scale, size) {
            return Float64Array.from({ length: size }, () => this.uniform(loc, scale));
        }
        normal(loc, scale) {
            return this.normals(loc, scale, 1)[0];
        }
        normals(loc, scale, size) {
            const [mu, sigma] = [loc, scale];
            const array = new Float64Array(size);
            for (let i = 0; i < size; i += 2) {
                // Box-Muller transform from uniform to normal distribution.
                const u = this.float();
                const v = this.float();
                const common = sqrt(-2.0 * log(u));
                array[i] = mu + sigma * (common * cos(2.0 * PI * v));
                if (i + 1 < size) {
                    array[i + 1] = mu + sigma * (common * sin(2.0 * PI * v));
                }
            }
            return array;
        }
    }
    exports.AbstractRandom = AbstractRandom;
    AbstractRandom.__name__ = "AbstractRandom";
    class SystemRandom extends AbstractRandom {
        integer() {
            return floor(Math.random() * exports.MAX_INT32);
        }
    }
    exports.SystemRandom = SystemRandom;
    SystemRandom.__name__ = "SystemRandom";
    // Park-Miller LCG
    class LCGRandom extends AbstractRandom {
        constructor(seed) {
            super();
            this._seed = seed % exports.MAX_INT32;
            if (this._seed <= 0) {
                this._seed += exports.MAX_INT32 - 1;
            }
        }
        integer() {
            this._seed = (48271 * this._seed) % exports.MAX_INT32;
            return this._seed;
        }
    }
    exports.LCGRandom = LCGRandom;
    LCGRandom.__name__ = "LCGRandom";
    class Random extends LCGRandom {
    } // for compatibility
    exports.Random = Random;
    Random.__name__ = "Random";
    exports.random = new Random(Date.now());
},
/* styles/ui.css.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = `:host{position:relative;}`;
},
/* models/ui/menus/menu_item.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const model_1 = require(51) /* ../../../model */;
    const kinds_1 = require(118) /* ../../common/kinds */;
    const callback_1 = require(119) /* ../../callbacks/callback */;
    class MenuItem extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.MenuItem = MenuItem;
    _a = MenuItem;
    MenuItem.__name__ = "MenuItem";
    (() => {
        _a.define(({ Bool, Str, Nullable, AnyRef, Ref, Func, Func0, Or }) => ({
            checked: [Nullable(Or(Bool, Func0(Bool))), null],
            icon: [Nullable(kinds_1.IconLike), null],
            label: [Str],
            tooltip: [Nullable(Str), null],
            shortcut: [Nullable(Str), null],
            menu: [Nullable(AnyRef()), null],
            disabled: [Or(Bool, Func0(Bool)), false],
            action: [Nullable(Or(Ref(callback_1.Callback), Func())), null],
        }));
    })();
},
/* models/common/kinds.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const kinds_1 = require(22) /* ../../core/kinds */;
    const enums = tslib_1.__importStar(require(21) /* ../../core/enums */);
    exports.Length = (0, kinds_1.NonNegative)(kinds_1.Int);
    const XY = (type) => (0, kinds_1.PartialStruct)({ x: type, y: type });
    const LRTB = (type) => (0, kinds_1.PartialStruct)({ left: type, right: type, top: type, bottom: type });
    exports.HAnchor = (0, kinds_1.Or)(enums.Align, enums.HAlign, kinds_1.Percent);
    exports.VAnchor = (0, kinds_1.Or)(enums.Align, enums.VAlign, kinds_1.Percent);
    exports.Anchor = (0, kinds_1.Or)(enums.Anchor, (0, kinds_1.Tuple)(exports.HAnchor, exports.VAnchor));
    exports.AutoAnchor = (0, kinds_1.Or)(kinds_1.Auto, enums.Anchor, (0, kinds_1.Tuple)((0, kinds_1.Or)(exports.HAnchor, kinds_1.Auto), (0, kinds_1.Or)(exports.VAnchor, kinds_1.Auto)));
    exports.TextAnchor = (0, kinds_1.Or)(exports.Anchor, kinds_1.Auto);
    exports.Padding = ((0, kinds_1.Or)(exports.Length, (0, kinds_1.Tuple)(exports.Length, exports.Length), XY(exports.Length), (0, kinds_1.Tuple)(exports.Length, exports.Length, exports.Length, exports.Length), LRTB(exports.Length)));
    exports.BorderRadius = ((0, kinds_1.Or)(exports.Length, (0, kinds_1.Tuple)(exports.Length, exports.Length, exports.Length, exports.Length), (0, kinds_1.PartialStruct)({
        top_left: exports.Length,
        top_right: exports.Length,
        bottom_right: exports.Length,
        bottom_left: exports.Length,
    })));
    exports.Index = (0, kinds_1.NonNegative)(kinds_1.Int);
    exports.Span = (0, kinds_1.NonNegative)(kinds_1.Int);
    const GridChild = (child) => (0, kinds_1.Tuple)((0, kinds_1.Ref)(child), exports.Index, exports.Index, (0, kinds_1.Opt)(exports.Span), (0, kinds_1.Opt)(exports.Span));
    exports.GridChild = GridChild;
    exports.GridSpacing = (0, kinds_1.Or)(exports.Length, (0, kinds_1.Tuple)(exports.Length, exports.Length));
    exports.TrackAlign = (0, kinds_1.Enum)("start", "center", "end", "auto");
    exports.TrackSize = kinds_1.Str;
    exports.TrackSizing = (0, kinds_1.PartialStruct)({ size: exports.TrackSize, align: exports.TrackAlign });
    exports.TrackSizingLike = (0, kinds_1.Or)(exports.TrackSize, exports.TrackSizing);
    exports.TracksSizing = (0, kinds_1.Or)(exports.TrackSizingLike, (0, kinds_1.List)(exports.TrackSizingLike), (0, kinds_1.Mapping)(kinds_1.Int, exports.TrackSizingLike));
    exports.IconLike = (0, kinds_1.Or)(enums.ToolIcon, (0, kinds_1.PrefixedStr)("--"), (0, kinds_1.PrefixedStr)("."), (0, kinds_1.PrefixedStr)("data:image"));
},
/* models/callbacks/callback.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const model_1 = require(51) /* ../../model */;
    class Callback extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Callback = Callback;
    Callback.__name__ = "Callback";
},
/* models/ui/menus/divider_item.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const model_1 = require(51) /* ../../../model */;
    class DividerItem extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.DividerItem = DividerItem;
    DividerItem.__name__ = "DividerItem";
},
/* models/common/resolve.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.normalized_anchor = normalized_anchor;
    exports.anchor = anchor;
    exports.text_anchor = text_anchor;
    exports.padding = padding;
    exports.border_radius = border_radius;
    exports.apply_icon = apply_icon;
    const enums_1 = require(21) /* ../../core/enums */;
    const types_1 = require(8) /* ../../core/util/types */;
    const assert_1 = require(12) /* ../../core/util/assert */;
    const logging_1 = require(20) /* ../../core/logging */;
    function normalized_anchor(anchor) {
        if (anchor == "auto") {
            return { x: "auto", y: "auto" };
        }
        const normalized = (() => {
            switch (anchor) {
                case "top": return "top_center";
                case "bottom": return "bottom_center";
                case "left": return "center_left";
                case "center": return "center_center";
                case "right": return "center_right";
                default: return anchor;
            }
        })();
        if ((0, types_1.isString)(normalized)) {
            const [y, x] = normalized.split("_");
            return { x, y };
        }
        else {
            const [x, y] = normalized;
            return { x, y };
        }
    }
    function anchor(anchor) {
        const { x, y } = normalized_anchor(anchor);
        const x_anchor = (() => {
            switch (x) {
                case "start":
                case "left": return 0.0;
                case "center": return 0.5;
                case "end":
                case "right": return 1.0;
                default: return x;
            }
        })();
        const y_anchor = (() => {
            switch (y) {
                case "start":
                case "top": return 0.0;
                case "center": return 0.5;
                case "end":
                case "bottom": return 1.0;
                default: return y;
            }
        })();
        return { x: x_anchor, y: y_anchor };
    }
    function text_anchor(text_anchor, align, baseline) {
        if (text_anchor != "auto") {
            return anchor(text_anchor);
        }
        else {
            const x_anchor = (() => {
                switch (align) {
                    case "left": return "start";
                    case "center": return "center";
                    case "right": return "end";
                }
            })();
            const y_anchor = (() => {
                switch (baseline) {
                    case "alphabetic":
                    case "ideographic":
                    case "hanging":
                        return "center";
                    case "top": return "start";
                    case "middle": return "center";
                    case "bottom": return "end";
                }
            })();
            return anchor([x_anchor, y_anchor]);
        }
    }
    function padding(padding) {
        if ((0, types_1.isNumber)(padding)) {
            return { left: padding, right: padding, top: padding, bottom: padding };
        }
        else if ((0, types_1.isPlainObject)(padding)) {
            if ("x" in padding || "y" in padding) {
                const { x = 0, y = 0 } = padding;
                return { left: x, right: x, top: y, bottom: y };
            }
            else if ("left" in padding || "right" in padding || "top" in padding || "bottom" in padding) {
                const { left = 0, right = 0, top = 0, bottom = 0 } = padding;
                return { left, right, top, bottom };
            }
            else {
                (0, assert_1.unreachable)(); // TODO: TypeScript 4.9
            }
        }
        else {
            if (padding.length == 2) {
                const [x = 0, y = 0] = padding;
                return { left: x, right: x, top: y, bottom: y };
            }
            else {
                const [left = 0, right = 0, top = 0, bottom = 0] = padding;
                return { left, right, top, bottom };
            }
        }
    }
    function border_radius(border_radius) {
        if ((0, types_1.isNumber)(border_radius)) {
            return {
                top_left: border_radius,
                top_right: border_radius,
                bottom_right: border_radius,
                bottom_left: border_radius,
            };
        }
        else if ((0, types_1.isPlainObject)(border_radius)) {
            return {
                top_left: border_radius.top_left ?? 0,
                top_right: border_radius.top_right ?? 0,
                bottom_right: border_radius.bottom_right ?? 0,
                bottom_left: border_radius.bottom_left ?? 0,
            };
        }
        else {
            const [top_left = 0, top_right = 0, bottom_right = 0, bottom_left = 0] = border_radius;
            return { top_left, top_right, bottom_right, bottom_left };
        }
    }
    function apply_icon(el, icon) {
        if (icon.startsWith("data:image")) {
            const url = `url("${encodeURI(icon)}")`;
            el.style.backgroundImage = url;
        }
        else if (icon.startsWith("--")) {
            el.style.backgroundImage = `var(${icon})`;
        }
        else if (icon.startsWith(".")) {
            const cls = icon.substring(1);
            el.classList.add(cls);
        }
        else if (enums_1.ToolIcon.valid(icon)) {
            const cls = `bk-tool-icon-${icon.replace(/_/g, "-")}`;
            el.classList.add(cls);
        }
        else {
            logging_1.logger.warn(`unable to resolve icon: ${icon}`);
        }
    }
},
/* styles/menus.css.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.item = "bk-item";
    exports.divider = "bk-divider";
    exports.check = "bk-check";
    exports.icon = "bk-icon";
    exports.label = "bk-label";
    exports.shortcut = "bk-shortcut";
    exports.chevron = "bk-chevron";
    exports.disabled = "bk-disabled";
    exports.menu = "bk-menu";
    exports.checkable = "bk-checkable";
    exports.checked = "bk-checked";
    exports.default = `:host{position:absolute;display:inline-grid;grid-template-columns:repeat(5, max-content);grid-template-rows:auto;user-select:none;-webkit-user-select:none;cursor:pointer;width:auto;height:auto;z-index:var(--bokeh-top-level);font-size:var(--font-size);background-color:var(--background-color);border:1px solid var(--border-color);border-radius:var(--border-radius);box-shadow:var(--box-shadow);}.bk-item,.bk-divider{position:relative;display:grid;grid-template-columns:subgrid;grid-column:span 5;align-items:center;}.bk-check{grid-column:1;}.bk-icon{grid-column:2;}.bk-label{grid-column:3;}.bk-shortcut{grid-column:4;}.bk-chevron{grid-column:5;}.bk-divider{cursor:default;overflow:hidden;background-color:var(--divider-color);height:1px;margin:1px 5px;}.bk-item{padding:0.5em;}.bk-item:hover{background-color:var(--hover-color);}.bk-item:focus,.bk-item:focus-visible{outline:1px dotted var(--highlight-color);outline-offset:-1px;}.bk-item::-moz-focus-inner{border:0;}.bk-item.bk-disabled{color:var(--disabled-color);cursor:not-allowed;}.bk-item.bk-disabled .bk-icon{color:var(--icon-color-disabled);}.bk-item:first-of-type{border-top-left-radius:var(--border-radius);border-top-right-radius:var(--border-radius);}.bk-item:last-of-type{border-bottom-left-radius:var(--border-radius);border-bottom-right-radius:var(--border-radius);}.bk-icon{position:relative;width:16px;height:16px;mask-size:100% 100%;-webkit-mask-size:100% 100%;mask-position:center center;-webkit-mask-position:center center;mask-repeat:no-repeat;-webkit-mask-repeat:no-repeat;background-size:100% 100%;background-origin:border-box;background-position:center center;background-repeat:no-repeat;}.bk-label{padding:0 0.5em;}.bk-shortcut{text-align:right;font-size:90%;color:var(--shortcut-color);}.bk-chevron{background-color:var(--icon-color);mask-image:var(--bokeh-icon-caret-right);-webkit-mask-image:var(--bokeh-icon-caret-right);mask-size:100% 100%;-webkit-mask-size:100% 100%;mask-position:center center;-webkit-mask-position:center center;mask-repeat:no-repeat;-webkit-mask-repeat:no-repeat;width:12px;height:12px;}.bk-item:not(.bk-menu) .bk-chevron{display:none;}.bk-item.bk-checkable .bk-check{width:16px;height:16px;}.bk-item.bk-checkable.bk-checked .bk-check{background-color:var(--icon-color);mask-image:var(--bokeh-icon-check);-webkit-mask-image:var(--bokeh-icon-check);mask-size:100% 100%;-webkit-mask-size:100% 100%;mask-position:center center;-webkit-mask-position:center center;mask-repeat:no-repeat;-webkit-mask-repeat:no-repeat;}`;
},
/* styles/icons.css.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.tool_icon_dark_theme = exports.tool_icon_light_theme = exports.tool_icon_list = exports.tool_icon_square_check = exports.tool_icon_square = exports.tool_icon_check = exports.tool_icon_text_align_right = exports.tool_icon_text_align_center = exports.tool_icon_text_align_left = exports.tool_icon_italic = exports.tool_icon_bold = exports.tool_icon_delete = exports.tool_icon_pointer = exports.tool_icon_unpin = exports.tool_icon_pin = exports.tool_icon_maximize = exports.tool_icon_minimize = exports.tool_icon_arrow_up_from_bar = exports.tool_icon_arrow_down_to_bar = exports.tool_icon_y_grip = exports.tool_icon_x_grip = exports.tool_icon_see_off = exports.tool_icon_see_on = exports.tool_icon_caret_right = exports.tool_icon_caret_left = exports.tool_icon_caret_down = exports.tool_icon_caret_up = exports.tool_icon_chevron_right = exports.tool_icon_chevron_left = void 0;
    exports.tool_icon_copy = "bk-tool-icon-copy";
    exports.tool_icon_open = "bk-tool-icon-open";
    exports.tool_icon_replace_mode = "bk-tool-icon-replace-mode";
    exports.tool_icon_toggle_mode = "bk-tool-icon-toggle-mode";
    exports.tool_icon_append_mode = "bk-tool-icon-append-mode";
    exports.tool_icon_intersect_mode = "bk-tool-icon-intersect-mode";
    exports.tool_icon_subtract_mode = "bk-tool-icon-subtract-mode";
    exports.tool_icon_xor_mode = "bk-tool-icon-xor-mode";
    exports.tool_icon_invert_selection = "bk-tool-icon-invert-selection";
    exports.tool_icon_clear_selection = "bk-tool-icon-clear-selection";
    exports.tool_icon_box_select = "bk-tool-icon-box-select";
    exports.tool_icon_x_box_select = "bk-tool-icon-x-box-select";
    exports.tool_icon_y_box_select = "bk-tool-icon-y-box-select";
    exports.tool_icon_box_zoom = "bk-tool-icon-box-zoom";
    exports.tool_icon_x_box_zoom = "bk-tool-icon-x-box-zoom";
    exports.tool_icon_y_box_zoom = "bk-tool-icon-y-box-zoom";
    exports.tool_icon_auto_box_zoom = "bk-tool-icon-auto-box-zoom";
    exports.tool_icon_zoom_in = "bk-tool-icon-zoom-in";
    exports.tool_icon_zoom_out = "bk-tool-icon-zoom-out";
    exports.tool_icon_help = "bk-tool-icon-help";
    exports.tool_icon_hover = "bk-tool-icon-hover";
    exports.tool_icon_crosshair = "bk-tool-icon-crosshair";
    exports.tool_icon_lasso_select = "bk-tool-icon-lasso-select";
    exports.tool_icon_pan = "bk-tool-icon-pan";
    exports.tool_icon_x_pan = "bk-tool-icon-x-pan";
    exports.tool_icon_y_pan = "bk-tool-icon-y-pan";
    exports.tool_icon_pan_left = "bk-tool-icon-pan-left";
    exports.tool_icon_pan_right = "bk-tool-icon-pan-right";
    exports.tool_icon_pan_up = "bk-tool-icon-pan-up";
    exports.tool_icon_pan_down = "bk-tool-icon-pan-down";
    exports.tool_icon_range = "bk-tool-icon-range";
    exports.tool_icon_polygon_select = "bk-tool-icon-polygon-select";
    exports.tool_icon_redo = "bk-tool-icon-redo";
    exports.tool_icon_reset = "bk-tool-icon-reset";
    exports.tool_icon_save = "bk-tool-icon-save";
    exports.tool_icon_tap_select = "bk-tool-icon-tap-select";
    exports.tool_icon_undo = "bk-tool-icon-undo";
    exports.tool_icon_wheel_pan = "bk-tool-icon-wheel-pan";
    exports.tool_icon_wheel_zoom = "bk-tool-icon-wheel-zoom";
    exports.tool_icon_box_edit = "bk-tool-icon-box-edit";
    exports.tool_icon_freehand_draw = "bk-tool-icon-freehand-draw";
    exports.tool_icon_poly_draw = "bk-tool-icon-poly-draw";
    exports.tool_icon_point_draw = "bk-tool-icon-point-draw";
    exports.tool_icon_poly_edit = "bk-tool-icon-poly-edit";
    exports.tool_icon_line_edit = "bk-tool-icon-line-edit";
    exports.tool_icon_settings = "bk-tool-icon-settings";
    exports.tool_icon_unknown = "bk-tool-icon-unknown";
    exports.tool_icon_fullscreen = "bk-tool-icon-fullscreen";
    exports.tool_icon_chevron_up = "bk-tool-icon-chevron-up";
    exports.tool_icon_chevron_down = "bk-tool-icon-chevron-down";
    exports.tool_icon_chevron_left = "bk-tool-icon-chevron-left";
    exports.tool_icon_chevron_right = "bk-tool-icon-chevron-right";
    exports.tool_icon_caret_up = "bk-tool-icon-caret-up";
    exports.tool_icon_caret_down = "bk-tool-icon-caret-down";
    exports.tool_icon_caret_left = "bk-tool-icon-caret-left";
    exports.tool_icon_caret_right = "bk-tool-icon-caret-right";
    exports.tool_icon_see_on = "bk-tool-icon-see-on";
    exports.tool_icon_see_off = "bk-tool-icon-see-off";
    exports.tool_icon_x_grip = "bk-tool-icon-x-grip";
    exports.tool_icon_y_grip = "bk-tool-icon-y-grip";
    exports.tool_icon_arrow_down_to_bar = "bk-tool-icon-arrow-down-to-bar";
    exports.tool_icon_arrow_up_from_bar = "bk-tool-icon-arrow-up-from-bar";
    exports.tool_icon_minimize = "bk-tool-icon-minimize";
    exports.tool_icon_maximize = "bk-tool-icon-maximize";
    exports.tool_icon_pin = "bk-tool-icon-pin";
    exports.tool_icon_unpin = "bk-tool-icon-unpin";
    exports.tool_icon_pointer = "bk-tool-icon-pointer";
    exports.tool_icon_delete = "bk-tool-icon-delete";
    exports.tool_icon_bold = "bk-tool-icon-bold";
    exports.tool_icon_italic = "bk-tool-icon-italic";
    exports.tool_icon_text_align_left = "bk-tool-icon-text-align-left";
    exports.tool_icon_text_align_center = "bk-tool-icon-text-align-center";
    exports.tool_icon_text_align_right = "bk-tool-icon-text-align-right";
    exports.tool_icon_check = "bk-tool-icon-check";
    exports.tool_icon_square = "bk-tool-icon-square";
    exports.tool_icon_square_check = "bk-tool-icon-square-check";
    exports.tool_icon_list = "bk-tool-icon-list";
    exports.tool_icon_light_theme = "bk-tool-icon-light-theme";
    exports.tool_icon_dark_theme = "bk-tool-icon-dark-theme";
    exports.default = `.bk-tool-icon-copy{background-color:var(--icon-color);mask-image:var(--bokeh-icon-copy);-webkit-mask-image:var(--bokeh-icon-copy);}.bk-tool-icon-open{background-color:var(--icon-color);mask-image:var(--bokeh-icon-open);-webkit-mask-image:var(--bokeh-icon-open);}.bk-tool-icon-replace-mode{background-image:var(--bokeh-icon-replace-mode, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxokK3gniQAAAHpJREFUWMNjXLhsJcNAAiaGAQajDhhwB7DgEP+PxmeksvjgDwFcLmYkUh2hkBj8IcBIZXsYh1w2/I8v3sgAOM0bLYhGc8GgrwuICgldfQO88pcvXvg/aOuCUQeM5oLRuoCFCJcTbOMh5XOiW0JDNhdQS3y0IBp1ABwAAF8KGrhC1Eg6AAAAAElFTkSuQmCC"));}.bk-tool-icon-toggle-mode{background-image:var(--bokeh-icon-toggle-mode, url("data:image/png;base64,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"));}.bk-tool-icon-append-mode{background-image:var(--bokeh-icon-append-mode, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxkZWD04WwAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAAAoUlEQVRYw+1WQQ6AIAwrhO8Y/bIXEz9jIMSDr8ETCUEPQzA4pMeFLKNbu4l5WR0CDOMEALBGIzMuQIBEZQjPgP9JLjwTfBjY9sO9lZsFA9IafZng3BlIyVefgd8XQFZBAWe8jfNxwsDhir6rzoCiPiy1K+J8/FRQemv2XfAdFcQ9znU4Viqg9ta1qYJ+D1BnAIBrkgGVOrXNqUA9rbyZm/AEzFh4jEeY/soAAAAASUVORK5CYII="));}.bk-tool-icon-intersect-mode{background-image:var(--bokeh-icon-intersect-mode, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxkrkOpp2wAAAPhJREFUWMPtV1EKwjAMTUavI3oawR/vtn5srJdREfzwMvHHQlcT2mpdMzFfWxiP5r2+JMN+mAiCOB72CABgR1cln4oOGocJnuMTSxWk8jMm7OggYkYXA9gPE3uyd8NXHONJ+eYMdE/NqCJmEZ5ZqlJJ4sUksKN7cYSaPoCZFWR1QI+Xm1fBACU63Cw22x0AAJxudwrffVwvZ+JmQdAHZkw0d4EpAMCw8k87pMdbnwtizQumJYv3nwV6XOA1qbUT/oQLUJgFRbsiNwFVucBIlyR3p0tdMp+XmFjfLKi1LatyAXtCRjPWBdL3Ke3VuACJKFfDr/xFN2fgAR/Go0qaLlmEAAAAAElFTkSuQmCC"));}.bk-tool-icon-subtract-mode{background-image:var(--bokeh-icon-subtract-mode, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxgsF5XNOQAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAABFUlEQVRYw9VWUQqDMAxNpWfxQxD1MoP97G7zQ5mH2RTZYLtM9lWoMbXtxLXNX4OG9r28l4hrd0PQoqxqAACYpxH25C/nkwCHyCBwSPoS09k1T5Fo+4EiExcC4v584xGFmyIXHBLRISAVZyZufUPVa4rcrwmPDgr93ylo+2GliLRUYHK6th/o/6r7nfLpqaCsagEA8Hh9FmcNKeRmgeYDC+SCq0B6FFi8/BcV6BdR9cL3gCv3ijPKOacsn3rBEcjmaVxpfGcg4wHxzgJJnc6241Hn23DERFRAu1bNcWa3Q0uXi62XR6sCaWoSejbtdLYmU3kTEunNgj0bUbQqYG/IcMaqwPS9jftoVCAQ0ZVDJwf0zQdH4AsyW6fpQu4YegAAAABJRU5ErkJggg=="));}.bk-tool-icon-xor-mode{background-image:var(--bokeh-icon-xor-mode, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAQAAADZc7J/AAAAAmJLR0QA/4ePzL8AAACXSURBVEjH3VXBCcAwCDxLxgl0oM7nQEL3sa9ASLQIqS3UT4SIOfXOECsAADsAwb1/ECbbsGilvdKfli9OgmUEdGo8uKb0QIZ6PUvrwfcJzCn0zGtM9fx1BKzzFMTgvRf3jBZGs1TnxeVNwUIxxsqrWmBNYmJptewBBuZMwas3uiP+sA+8i8i2rpSlRg7+FaxZCHpFpu/EC1y3NtihGuwKAAAAAElFTkSuQmCC"));}.bk-tool-icon-invert-selection{background-image:var(--bokeh-icon-invert-selection, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAQAAADZc7J/AAAAAmJLR0QA/4ePzL8AAAC2SURBVEjH7VVJEoQwCGysPMeqPCjv40FU+R/moCbMmEWNenFygUug6aYTmhRdZwBeX8ClVJboCRDN5SN4zc8gkBaCtaONKZ+vB0JEcT0HtmvtBALS+rnatAEAF/KcCroThXKZRAP0J3IUT25bpG33m1TwBCCqQOY9IKtCDsVkiOxQQdR6we2dlR+ws7FMYQObKsgJFUyB8Wtev2W+hYB1dtoxFa4mMaJQqb6PDRmPeIH+X1t/gQ8PhzjuVbw+wwAAAABJRU5ErkJggg=="));}.bk-tool-icon-clear-selection{background-image:var(--bokeh-icon-clear-selection, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUGEhcuan3d3wAAAoRJREFUWMPtlzFP3EAQhd+b3TNSzg0N5TWXLkJQUUaKhIQ4fgP/g5ArrriE/I3opEgRrZtIVJR0FJQ010SioUmEZHtnUpwN9gWHGA5BJCy58MraffvmfZ41v3z9hqe8BE98vQh4cgG+Ydzmnrng8efvQJNi/uN7dznx/B3ggtfhf4ehNdUttRzBDIm/2VTiiWCG1HK0nc+3UWtq8BQIiEEakEQOADBIA4QCQmBqoHBhFNR27ikQSmGdYCdTqCpEHMDZmEKRWUBEv1gBDg5SzRJnpopILWICgWuRYflLamuzxB2BmtYqSRIka5VWU8QduXO+1hRc5YZu5GAwmP2ZJzND0IBu5HCV2+NQcAhAVRsnC2IbPzPdSjzd6to6VtfWkXi6YLaVWr7xoAwkfpb8MnC3SH7rKSMBe4M0jA/OTicFIbtCGRIyNbURhcf3ErCd6YwA1m0HgAxhw1NGQnlXBHG4kylVlSJuH0RfIP2CkL2I/qS1gIAAQiBl1QwFggIHtyxgrxK5PgyfC0JWKoT0HLh8LwoietB4TYKaIl7yeNURxB05UtMxDOcVQlZIrlRKdK6m47gjR/fuBRQihyLArtNeJD50Izcx2Eczu7iFkIug4VM3cpOr3MKDekFED0fWUHv9Zq0kpLnridjhY3XDg7NTN0jDrhO3X7O9Wg7wwyANu4mnayNg3gmbu0tCNoUyBNGv2l4rB9EXynA7082FOxAQLhU6rQVO9T2AvWowFToNCJcPORGxIRcnpjZSKATSU9NxvOQnAPArDSaQoUKnNI4iufkGtD4P3EHIcWZhz4HLceSOyrR3Izf5memPAL2cX3yhAkonysZVaWLBkd9dw1Ivv2a/AYPkK+ty1U1DAAAAAElFTkSuQmCC"));}.bk-tool-icon-box-select{background-color:var(--icon-color);mask-image:var(--bokeh-icon-box-select);-webkit-mask-image:var(--bokeh-icon-box-select);}.bk-tool-icon-x-box-select{background-color:var(--icon-color);mask-image:var(--bokeh-icon-x-box-select);-webkit-mask-image:var(--bokeh-icon-x-box-select);}.bk-tool-icon-y-box-select{background-color:var(--icon-color);mask-image:var(--bokeh-icon-y-box-select);-webkit-mask-image:var(--bokeh-icon-y-box-select);}.bk-tool-icon-box-zoom{background-color:var(--icon-color);mask-image:var(--bokeh-icon-box-zoom);-webkit-mask-image:var(--bokeh-icon-box-zoom);}.bk-tool-icon-x-box-zoom{background-color:var(--icon-color);mask-image:var(--bokeh-icon-x-box-zoom);-webkit-mask-image:var(--bokeh-icon-x-box-zoom);}.bk-tool-icon-y-box-zoom{background-color:var(--icon-color);mask-image:var(--bokeh-icon-y-box-zoom);-webkit-mask-image:var(--bokeh-icon-y-box-zoom);}.bk-tool-icon-auto-box-zoom{background-color:var(--icon-color);mask-image:var(--bokeh-icon-auto-box-zoom);-webkit-mask-image:var(--bokeh-icon-auto-box-zoom);}.bk-tool-icon-zoom-in{background-color:var(--icon-color);mask-image:var(--bokeh-icon-zoom-in);-webkit-mask-image:var(--bokeh-icon-zoom-in);}.bk-tool-icon-zoom-out{background-color:var(--icon-color);mask-image:var(--bokeh-icon-zoom-out);-webkit-mask-image:var(--bokeh-icon-zoom-out);}.bk-tool-icon-help{background-color:var(--icon-color);mask-image:var(--bokeh-icon-help);-webkit-mask-image:var(--bokeh-icon-help);}.bk-tool-icon-hover{background-color:var(--icon-color);mask-image:var(--bokeh-icon-hover);-webkit-mask-image:var(--bokeh-icon-hover);}.bk-tool-icon-crosshair{background-color:var(--icon-color);mask-image:var(--bokeh-icon-crosshair);-webkit-mask-image:var(--bokeh-icon-crosshair);}.bk-tool-icon-lasso-select{background-color:var(--icon-color);mask-image:var(--bokeh-icon-lasso-select);-webkit-mask-image:var(--bokeh-icon-lasso-select);}.bk-tool-icon-pan{background-color:var(--icon-color);mask-image:var(--bokeh-icon-pan);-webkit-mask-image:var(--bokeh-icon-pan);}.bk-tool-icon-x-pan{background-color:var(--icon-color);mask-image:var(--bokeh-icon-x-pan);-webkit-mask-image:var(--bokeh-icon-x-pan);}.bk-tool-icon-y-pan{background-color:var(--icon-color);mask-image:var(--bokeh-icon-y-pan);-webkit-mask-image:var(--bokeh-icon-y-pan);}.bk-tool-icon-pan-left{background-color:var(--icon-color);mask-image:var(--bokeh-icon-pan-left);-webkit-mask-image:var(--bokeh-icon-pan-left);}.bk-tool-icon-pan-right{background-color:var(--icon-color);mask-image:var(--bokeh-icon-pan-right);-webkit-mask-image:var(--bokeh-icon-pan-right);}.bk-tool-icon-pan-up{background-color:var(--icon-color);mask-image:var(--bokeh-icon-pan-up);-webkit-mask-image:var(--bokeh-icon-pan-up);}.bk-tool-icon-pan-down{background-color:var(--icon-color);mask-image:var(--bokeh-icon-pan-down);-webkit-mask-image:var(--bokeh-icon-pan-down);}.bk-tool-icon-range{background-image:var(--bokeh-icon-range, url("data:image/png;base64,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"));}.bk-tool-icon-polygon-select{background-image:var(--bokeh-icon-polygon-select, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjc1OfiVKAAAAe1JREFUWMPt1r9rU1EUB/DPK0XbqphFHETo4OCiFhwF0V1KHbRSROLqon+AUMVRRFBwEbRFMBiV+mMW/wIxi5OD1kERRVKRJHUwLvfBTZrU5OWBGXLgQu7Jfe98z/ec7z0vKa88b2q1BDtRHdAPBaylm1NzsxsOjPnPNt6WSWprbft+/c3I3zOAjhT1Y4+fvcjEQJIXnVECSa+AhqIHqlHH5lWCZoe+Gk4GRgDG86j9SAUdlDBSQaZhlOkuHyoVdJmsw98D1S5fM4NYM1LCpqM+Lwa240oLgmZzpVZvzKT75VLZcqksSZKWlQeAy/iORVwIvh31xvotvK7VG3Px4aWHj3Jl4C2uYSvq+Bn8v6LLbaVWb9zsBiKLCvbiNG7gLm7jAYqbPHMJMziZ9lsKoh8GtqCEVVzHftwJn+TFHp4/hg8BSCYVfMOZoPEv2NZGdy9WCGUr9toDR3E2/H4V6nwRe/BmgN65H1ZhvMuB3XiKIyFoGefwO6ysVkUlrNUNsyAK/jli533Q+Y8cJFvAeXyMS1CI/jiMr/gUtD2LQwMGr4R3p7bY3oQHQ5b38CT4D2AXXg6YcQXHpyYnlqKsi5iOAVSwL9zd7zJ09r+Cpwq72omFMazjT9Dnibym0dTkRDUKrrgwH7MwXVyYB38BstaGDfLUTsgAAAAASUVORK5CYII="));}.bk-tool-icon-redo{background-color:var(--icon-color);mask-image:var(--bokeh-icon-redo);-webkit-mask-image:var(--bokeh-icon-redo);}.bk-tool-icon-reset{background-color:var(--icon-color);mask-image:var(--bokeh-icon-reset);-webkit-mask-image:var(--bokeh-icon-reset);}.bk-tool-icon-save{background-color:var(--icon-color);mask-image:var(--bokeh-icon-save);-webkit-mask-image:var(--bokeh-icon-save);}.bk-tool-icon-tap-select{background-color:var(--icon-color);mask-image:var(--bokeh-icon-tap-select);-webkit-mask-image:var(--bokeh-icon-tap-select);}.bk-tool-icon-undo{background-color:var(--icon-color);mask-image:var(--bokeh-icon-undo);-webkit-mask-image:var(--bokeh-icon-undo);}.bk-tool-icon-wheel-pan{background-image:var(--bokeh-icon-wheel-pan, url("data:image/png;base64,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"));}.bk-tool-icon-wheel-zoom{background-image:var(--bokeh-icon-wheel-zoom, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgskILvMJQAABTtJREFUWMPdl1+MXVUVxn/fPvf2zrSFmUKnoBCUdjRoVaIxEpO2JhilMYBCtBQS2hejpg1Uo2NUrIFAoyGmtiE+GHwQGtvQJhqDmKYRBv+URFsFDNCSptH60DJTO3dKnX/33rM/H7rvsDu9M20fDMaVnGTvtb69z7fWXmvtc/TEzqd4OyXwNsv/FwFJQVI/sA14SZKRLOlPkr5TrVYXHz70quYkEEK4TtI2YAgYkrQthHDdhV5uuw+43/ZrwCbgRttgY/tjtrc0m83X3/f+D6ydnJhYcB4BSZcBA7aP2d4ELAGW2N5k+xgwkDB0IH19CGGH7R8B1aQeAf4KvAw0ku4K2zu7uru3ApdPEyiKohd4TNKjtjt5h6RHgccSNrddbvuHtm9Jqoak7xVF8WFgdavV+pSk5cCObNmXgK++85prCj3z28HKqZMnH7D9YAY4BvwujT8BvCuL1INX9vVt+dfwcCvNb7f9q2RuSfrGvWu/sL2Nf3LX7pzvj4ENSGBPVarVd4fRkZFltjdmoMGiKO4IIWwIIWwoiuIOYDDzeOPoyMiyFLkum7WJCMDztrcrTTrIRuAQZ6NcK1utL4dWq/VZoC8BhqvV6l1lWb4YYxyLMY6VZflitVq9CxhOmL60hhCKeYiV7WMKIXw9jT1HpXw3c+bOAKzOjJubzebJrKQCQLPZPClpc7bP6rMYKtjXth2OMf7tIkr11Wz8oQDc1Fb09vY+kQw1YAuwJY2nbUluAnCWpKkaFl6IQIzxivaR2SYA89sJVK/Xp2x32R6w/a30DNjuqtfrU0ArYecDCEqgLqm94T0dEm9mBG7PxkdDlkBnkhebgIezNQ8nHcCZPL9ijE1Jf/bZZoPtzbavmqNZLbf9tSxq+yoduuJ+SZ+zXSZyBXCqU+d8fvC5yRUrV+0G2j3g2hDCLyXd/+Su3QdnvP/zCuH72LWsgf2k0oHlH2c2odlkxcpVEdgr6aDtjyb8x20/J+mA7T9I6rL9SWA5dne2/GdXLl58qNJh398An85yTMA+4DOz8Dgu6Zu2dwJXJ91ltm8Gbp7Fgb+EEB4aHhpq5CEtACqVyr3AC0AlPS8k3TSmQ2YPhhBuS/1/LpmS9JTtNTHGfwBU2uUALARotVqniqJYH2Pck85pfavVaufAwnQvnHc0McaDKVptebN94QAnJB0EdtjekydyZXqjs/0ZgLIs/w6sy8bnYGYJ63pgERKC05JutT1kOwITwL9tvzlzUQUYB+Zjs2DBgu6xsbGJZHstByZbezregcBXeCsEz1bnzXt5anLyzLq71zDLxTRdVgemdx0fv2e2w5thO5DbiqL4oKT3ZKpnpyYnz+SY2ZpTAPZmJfdIrVZbNBNUq9UW2X4kU+2dcf53Aj1pj2PA7y/6m1DS00A9za9uNBq7iqJYBuoGdRdFsazRaOzKSqye1rTbaa/tlbYrqXQP2X4FIA9/J1l39xrC0v7+w5IeB8XkwS1lWe6TGJAYKMty31tfO4qSHl/a3384I3CDpI+kzC4lnRfrue6GytEjR8oQwlY73gC0L4qlth/q0M1/LYWtR48cKQF6enrC6dOnVwGLEpnxnp7en4+O1i/tszzGOCTpPmB7ahb57QUwBWyXdF+McWg6MScmuoA8OX8xOlpvXGz422XYTsB/SnpA0h7bX5R0WzI9HUL4qe2XbI+dk3xl+V7gxoztD5jRI+YK/zkEEokx2/uB/RdzIfUtueqVN04cXwF8G3iHY3z9Urw/j8ClyhsnjrcS2Vv/J/8NLxT+/zqBTkcxU/cfEkyEAu3kmjAAAAAASUVORK5CYII="));}.bk-tool-icon-box-edit{background-image:var(--bokeh-icon-box-edit, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4QfHjM1QAAAGRJREFUWMNjXLhsJcNAAiaGAQYsDAwM/+lsJ+OgCwGsLqMB+D8o08CoA0YdMOqAUQewDFQdMBoFIyoN/B/U7YFRB7DQIc7xyo9GwbBMA4xDqhxgISH1klXbDYk0QOseEeOgDgEAIS0JQleje6IAAAAASUVORK5CYII="));}.bk-tool-icon-freehand-draw{background-image:var(--bokeh-icon-freehand-draw, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADTElEQVRYCeWWTWwMYRjH/88721X1lZJIGxJxcEE4OOiBgzjXWh8TJKR76kWacOBGxdEJIdk4VChZI/phidRBHMRRIr7DSUiaSCRFRM3u88gz+o7Z6bBTdjmYZPf9eJ55fv/5zzvvDPC/H9QsA66Olo9Ga+/MdR+Ljm2/KQIULsz9FqItGdOfJKLhApLgVkiSCGODjWit7QpKWy+TNrFeXvzKVUT8NiTVaIgDcbiCFJ7GiT8WkARXAdYBK0Lbhi/CenArRNskuM7/tgNp4ArQ42dwjf3WY5gWTqC7O/NbNn2Xkfw/YwdSw/We14HP2IEZwX+y9cZ9SH0LmgFP7UCz4KkENBNeV0Cz4b8U8DfgKiDxMWwUXETqLvJpCQpXZfawbzS7t9v5pL19cHBwfja7YA0y/lyCM0+E5hv5+piZXwKYcF23as+37bTXsQVqgkL0p/34fHR7DcBtbetFsBmGDwMOJCggYG55yw7dMlk6DuC1Bdu2RsCU9TYWQq2IoGbsreZ5NzvEqfSBsIsIy8OTbcdgiRHeh4o8AFAEwDakbY2AaCCpH7V9aGhoUUUy3UyVbkPYFuYLDlUZH8XBpwxkK0Dbgxg5HcVi0ent7a0RULMIozaHBSMfF9b2SzdutFcFB2FkwMIJOG6qfteXOa1nHZ48tyefuwyfT9s6wtzZ3t7eZse2DR2I228TtHXzuWCx9g8MtK5cuHCZTH4tiHEOa4xFngvTyS8f35d6enomiCi4/foEXBkZaQuukChL4FYA2Whd7YcC4gEdW3CpdL3LtGAVCVYJywEyTpAuJKeMOKXZs/Bw947C50KhUFOG4cwz35cjWNBlHGeD53n3xsfHP/T19U1qciggar8Fa4I3PHobIotBWBtc2hSiChyZxVzM53Pv7FVH6Tp3uVy+g0r1ImD2GjIrQGYIxjnfuXTZGICS5k/bBwJoubwEFX4TLah9EXomJGMA3za+f9913Yl4TnzsDQ+vE6YTZOjHh4ngibstt1pzQwd04F0bPStEBpXqRoBeQ/AKghfBnOEKgS+Q7z91Xfdz/HGKg8Ox7z8iYD9z6wqTkZFgnvhMGP9VZ2or1XVkPM9z0mytSfVsHa1RLBZbLoyNzUnK+ydz3wC6I9x+lwbngwAAAABJRU5ErkJggg=="));}.bk-tool-icon-poly-draw{background-image:var(--bokeh-icon-poly-draw, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjglo9eZgwAAAc5JREFUWMPt1zFrU1EUB/DfS4OmVTGDIChCP4BgnQXRxVHqIJUupp9AB8VBQcRBQUXIB9DWQoMRiXZzcnQSA34A7aAuHSJKkgo2LvfBrU3aJnlYkBy4vHcP557zP/9z3r33JdXa647N0kHSZd5Nn0rSxc8G3cXp85sMcnZZ8vge3osZ+l3vB8CWFA0iL14t79h210swAjACMAIwAjACkB90D/8/GchI9ve4nPwTBh5E9ws7OepzGWb9EddSn51Op9ZstadSg4VK1UKlKkmSDSMLALewiuNh/hVJq71Wxttmqz0dG88vPc+MgWP4grvYG3SLOBrZFFFrttqPe4HIDxh4GSei+98iSlusuYopXEAjBtEPA3tQwUpwluAbDm4TPJUz+BTW9l2Ce6G7L0X/Bw8D3T/7SKKIDzHg7QCcxjvcQAEtXAnrrg/RP0/DKPbqgcN4iVOR7gcO4dcQgRuoh7HSqwlP4n20m63jJu5n8MkWMYfP3UowhzdR8FU8w9iQwevBdyq3/27CMRzAE5yLuvsRLg+ZcR1nJ8YL81HWJUzGAPaFZwe/Q5MdyYDyNHgjzO90YyGHtVDncuiJchaHw8R4oREFV5qdiVmYLM3OgD9k5209/atmIAAAAABJRU5ErkJggg=="));}.bk-tool-icon-point-draw{background-image:var(--bokeh-icon-point-draw, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEiERGWPELgAAA4RJREFUWMO1lr1uG1cQhb9ztdRSP7AF1QxgwKlcuZSqRC9gWUUUINWqTh5AnaFOnVPEteQmRuhCURqWsSqqc9IolREXdEvQBElxtdw7KURSFEVKu4w8wAKLxdw9Z+bMnRmZGXfZ29//II8th4WwGVNyIoQLYB5vxA9Caq04iUd9A+7ZlsNC2I7TdSd2hZXMJKlnTqp9jtl/GBaqoyQ0noFKpUIzBicYYc+DEFpxkglc4oVJa5gvDn8v1xV2irG3FM4NSVwjUKlUaMcpJhCGmSEJQ6QGD8M5WnHCd8+f3QCXpPLx8WNwv0j6Bm9FMK7FJ3WBE+R/2t7c/GBmFvSBrzRTCsyTDjXrxUgEMtpxynJYmJoBJ4VAybwVARgvL7Oik0okCodnKpVKX7P0leiVMb0VvbJT+upznK4vh0GIeQwwQStJkHQD3MwsCALTJRG7Qrdrj5m/djgYaIa0hlkRdJk26XEgC9txurccBtVW3IudBImmZuACUP+ZlIDBt9FKcubYNTcAH/X0RYM1E7utJPlqe+uZzPxUcEkiSS4sTT95n15Mud0xWC0o2PAWOCdK3KYZlFxfM+tHOcnMzNr1es18ug+cgsVjP4yBU/Ppfrter1m/+l0+zYygML1xRVHU7TSb1cSzBzoBzszsH+AMdJJ49jrNZjWKou6wBnwOzcyndBpNbuueURR1Dw8Pq35p9cc5p/Dy9Dypt7jXrtdGwQECS9NPhr6Gq6txUzNigE6zydLK6lTw12/KT4FGFEUfJX2YJNONq5tVs4ODA7sD/DnwJ/BoADZuE3tHFs12dna6d4C/BI6AlbyzI8ii2TTw12/KK33gb2cdXsNZoAntbZC2SeO4c9592k/5eNQbiwvFd1kJuFGwLJr1wSPg/SwpvyFBHufOeXcFeAlE97U/uCxOY+P3b+Bn4B3Q+L8EdJfD4a+/AbC4UBzPxiPg3wlHZquB28Cn2IuR9x3gr3uV4DbwfvSDOvi4uFA8BDZmIRHkjHpS9Ht9iRqd8+5G3g05mAGcQbsdiX5QJ428G7Kygo8XYdb1/K4NWVmjzkNge2sz84bs+ELmpDDLtqWsNZBXgvmw8CTtpWVMT7x5YWBjLARnwZfKQNYN2U2LPvrh+5nBt7c2M2/It9bArCTKR8eZN+SJ13AScPnoODeRdqNenH+wul5w2gUr2WUjMFAt8bZ/0axX/wNnv4H8vTFb1QAAAABJRU5ErkJggg=="));}.bk-tool-icon-poly-edit{background-image:var(--bokeh-icon-poly-edit, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gELFi46qJmxxAAABV9JREFUWMOdl19vFFUYxn9n9u9sCyylUIzWUoMQBAWCMdEEIt6xIRQSLIEKtvHe6AcA4yeQb7CAUNJy0daLeomJN8SEULAC2kBBapBKoLvbmdl/c14vdmY7u91tF95kknPOnHmf95znPc97Ro2OTeBbdjFDT3c32ZxVHUOE9kSMB0/m6ExuoJn1H+ur6Y+OTfD50SMN5168OgrAlyf7CfuD+z7+iDs3p8hkLUQ0iFQ/yFl5Nm/qonfHVva+s32Zw9GxCYILsZ08tpNfBhbs+1YN4OH9+7huGdECSBVfqUosbsllfmauBqiR+cCNwOr7AEo8pPHJnymXykhg5fUWjoQpl0vVvhZhbSzGoUOHqgBlt6B6uruj2Zy1E9jo0fhfeyL2x4Mnc8VErK0KUEOB64JSyptfG4RSytsJjUJVxw2lsFy3urL9nx1Qd25ObctkrVMi+jQivd7U2ZyV/3Hzpq7h3h1b/7p9Y0o8v8rwAbTWrGpSocN/FGDlbAI0Rl23PCBan0Ok158H9Ipwzi25A/Mzc9Gl/BYx/E4kYqC1NKRARNAaDCNUM27Z+Zr+ouXs0q4+LSLBHPYCFkTkC6uU39kwCdsS7WRKmaYUiAhdnZ3MPX2K4+QjQI+C94A93rMzm8ltMwyDeDzWjMZeEb2pYQDdW3vITU2jtUZ5QThOPgm8C7wP7J15OPsBsB3oWpGnVWisCeDS1VHj4vBI92+/3tgB7Ab2AruAXiDBK5oIOkhtkEYRNRuJhObrd8Dl9ewf4D5wG7hVLpen29vb5wzD+BrkbBMaL3d1dk5nsrnlFDTTFWAWmAZueWD3gCemGde2k2fw1Al1YXhEvjozoO49eczdqekrWmsc2zlrmvEKOGoW1GUjFLqSk2KpJrCLwyMCPAP+BO54QL8DM6YZX/ClsP9YnwKkXnIBP4jdIpJRpdJTCYdMwwi98KU0Hjc/dDILNyUcwTCWdOSMJ0TRmBktGRhLugu0xyLk7CIqVNm+0bGJptl1YXikD0grpY4Rjc4a8Fbgdab/6OGbAJeCUuyJnnHmZH9pbSyGuBXV8NUwlUpR1EWyixmSyTWEwqGlJ2Swbo2JXbAAfgDGgGQA9I1A9t1tlq0AxrXxn0ilUpw4fhQqYkH/sT41OTnJJwf2s6FjI5mshdYa7bqVR2uezr9MJmJt14FvGrh/O9D+e6UkM/xyCuCqEKCYnJyUTKFQrZDHjxzGshwWLQcRsOz8Hi85P23id0ug/XilAMLBmm4tPGdoaKjSH5+oAGrhwvBI9SjZTn4QSK9yenoD7dlrExPoJlXW8G8ytpNHxRKk02lGxsdRKFwXLNvx5yY94HQLGhGk4LFCYQSqaE0AwWM1eOoEbR0dKBSW7bC4mKuffxs4D/wCLKwQQPAUzIkslfp6cVomROWSolh0GjldAM4nzDi2k9/i5UAzC9aKfwNJ3zgJg9YEvN6+C7SHgKm69+sD7RfNnKTTaZRPQfAut4oFV//IS7gkcB34VlVo8kGzphlfB+DU+TfNGBpZtRastvrvARJmfMF28ge9sc2B9/PNnCilMIDwK6y8/ow/Ai4kvILTljAXvDvEvrqKSUs60KolzPjBxspavQD2tKqCAGF/Ba+xE/Wbilu54wZV8NEKF5fXzQHl/bh4hUsE0WAXSlDMYcQSrQXgCmsTseXHsJkNnjqBFGwKJaHsKlxtUHYVhbLCzr1kaOA4bcn1y1Swmb+iLpJKpVrfgdpfsiVVCYcgluwgnU7jEgJ4s5UkLFtWYyHyEg0/N1q1tmQH+YXnAMFr97Nmv3p+0QsHQRsF8qpBOE5+rb9Nkaj50tVQKjqh4OU3GNL/1/So3vuUgbAAAAAASUVORK5CYII="));}.bk-tool-icon-line-edit{background-image:var(--bokeh-icon-line-edit, url("data:image/png;base64,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"));}.bk-tool-icon-settings{background-color:var(--icon-color);mask-image:var(--bokeh-icon-settings);-webkit-mask-image:var(--bokeh-icon-settings);}.bk-tool-icon-unknown{background-color:var(--icon-color);mask-image:var(--bokeh-icon-unknown);-webkit-mask-image:var(--bokeh-icon-unknown);}.bk-tool-icon-fullscreen{background-color:var(--icon-color);mask-image:var(--bokeh-icon-fullscreen);-webkit-mask-image:var(--bokeh-icon-fullscreen);}.bk-tool-icon-chevron-up{background-color:var(--icon-color);mask-image:var(--bokeh-icon-chevron-up);-webkit-mask-image:var(--bokeh-icon-chevron-up);}.bk-tool-icon-chevron-down{background-color:var(--icon-color);mask-image:var(--bokeh-icon-chevron-down);-webkit-mask-image:var(--bokeh-icon-chevron-down);}.bk-tool-icon-chevron-left{background-color:var(--icon-color);mask-image:var(--bokeh-icon-chevron-left);-webkit-mask-image:var(--bokeh-icon-chevron-left);}.bk-tool-icon-chevron-right{background-color:var(--icon-color);mask-image:var(--bokeh-icon-chevron-right);-webkit-mask-image:var(--bokeh-icon-chevron-right);}.bk-tool-icon-caret-up{background-color:var(--icon-color);mask-image:var(--bokeh-icon-caret-up);-webkit-mask-image:var(--bokeh-icon-caret-up);}.bk-tool-icon-caret-down{background-color:var(--icon-color);mask-image:var(--bokeh-icon-caret-down);-webkit-mask-image:var(--bokeh-icon-caret-down);}.bk-tool-icon-caret-left{background-color:var(--icon-color);mask-image:var(--bokeh-icon-caret-left);-webkit-mask-image:var(--bokeh-icon-caret-left);}.bk-tool-icon-caret-right{background-color:var(--icon-color);mask-image:var(--bokeh-icon-caret-right);-webkit-mask-image:var(--bokeh-icon-caret-right);}.bk-tool-icon-see-on{background-color:var(--icon-color);mask-image:var(--bokeh-icon-see-on);-webkit-mask-image:var(--bokeh-icon-see-on);}.bk-tool-icon-see-off{background-color:var(--icon-color);mask-image:var(--bokeh-icon-see-off);-webkit-mask-image:var(--bokeh-icon-see-off);}.bk-tool-icon-x-grip{background-color:var(--icon-color);mask-image:var(--bokeh-icon-y-grip);-webkit-mask-image:var(--bokeh-icon-y-grip);}.bk-tool-icon-y-grip{background-color:var(--icon-color);mask-image:var(--bokeh-icon-y-grip);-webkit-mask-image:var(--bokeh-icon-y-grip);}.bk-tool-icon-arrow-down-to-bar{background-color:var(--icon-color);mask-image:var(--bokeh-icon-arrow-down-to-bar);-webkit-mask-image:var(--bokeh-icon-arrow-down-to-bar);}.bk-tool-icon-arrow-up-from-bar{background-color:var(--icon-color);mask-image:var(--bokeh-icon-arrow-up-from-bar);-webkit-mask-image:var(--bokeh-icon-arrow-up-from-bar);}.bk-tool-icon-minimize{background-color:var(--icon-color);mask-image:var(--bokeh-icon-minimize);-webkit-mask-image:var(--bokeh-icon-minimize);}.bk-tool-icon-maximize{background-color:var(--icon-color);mask-image:var(--bokeh-icon-maximize);-webkit-mask-image:var(--bokeh-icon-maximize);}.bk-tool-icon-pin{background-color:var(--icon-color);mask-image:var(--bokeh-icon-pin);-webkit-mask-image:var(--bokeh-icon-pin);}.bk-tool-icon-unpin{background-color:var(--icon-color);mask-image:var(--bokeh-icon-unpin);-webkit-mask-image:var(--bokeh-icon-unpin);}.bk-tool-icon-pointer{background-color:var(--icon-color);mask-image:var(--bokeh-icon-hand-pointing);-webkit-mask-image:var(--bokeh-icon-hand-pointing);}.bk-tool-icon-delete{background-color:var(--icon-color);mask-image:var(--bokeh-icon-trash);-webkit-mask-image:var(--bokeh-icon-trash);}.bk-tool-icon-bold{background-color:var(--icon-color);mask-image:var(--bokeh-icon-bold);-webkit-mask-image:var(--bokeh-icon-bold);}.bk-tool-icon-italic{background-color:var(--icon-color);mask-image:var(--bokeh-icon-italic);-webkit-mask-image:var(--bokeh-icon-italic);}.bk-tool-icon-text-align-left{background-color:var(--icon-color);mask-image:var(--bokeh-icon-text-align-left);-webkit-mask-image:var(--bokeh-icon-text-align-left);}.bk-tool-icon-text-align-center{background-color:var(--icon-color);mask-image:var(--bokeh-icon-text-align-center);-webkit-mask-image:var(--bokeh-icon-text-align-center);}.bk-tool-icon-text-align-right{background-color:var(--icon-color);mask-image:var(--bokeh-icon-text-align-right);-webkit-mask-image:var(--bokeh-icon-text-align-right);}.bk-tool-icon-check{background-color:var(--icon-color);mask-image:var(--bokeh-icon-check);-webkit-mask-image:var(--bokeh-icon-check);}.bk-tool-icon-square{background-color:var(--icon-color);mask-image:var(--bokeh-icon-square);-webkit-mask-image:var(--bokeh-icon-square);}.bk-tool-icon-square-check{background-color:var(--icon-color);mask-image:var(--bokeh-icon-square-check);-webkit-mask-image:var(--bokeh-icon-square-check);}.bk-tool-icon-list{background-color:var(--icon-color);mask-image:var(--bokeh-icon-list);-webkit-mask-image:var(--bokeh-icon-list);}.bk-tool-icon-light-theme{background-color:var(--icon-color);mask-image:var(--bokeh-icon-light-theme);-webkit-mask-image:var(--bokeh-icon-light-theme);}.bk-tool-icon-dark-theme{background-color:var(--icon-color);mask-image:var(--bokeh-icon-dark-theme);-webkit-mask-image:var(--bokeh-icon-dark-theme);}:host{--bokeh-icon-question-mark:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M8%208a3.5%203%200%200%201%203.5%20-3h1a3.5%203%200%200%201%203.5%203a3%203%200%200%201%20-2%203a3%204%200%200%200%20-2%204%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2212%22%20y1%3D%2219%22%20x2%3D%2212%22%20y2%3D%2219.01%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-help:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2212%22%20cy%3D%2212%22%20r%3D%229%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2212%22%20y1%3D%2217%22%20x2%3D%2212%22%20y2%3D%2217.01%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2013.5a1.5%201.5%200%200%201%201%20-1.5a2.6%202.6%200%201%200%20-3%20-4%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-x:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%206l-12%2012%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%206l12%2012%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-settings:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M10.325%204.317c.426%20-1.756%202.924%20-1.756%203.35%200a1.724%201.724%200%200%200%202.573%201.066c1.543%20-.94%203.31%20.826%202.37%202.37a1.724%201.724%200%200%200%201.065%202.572c1.756%20.426%201.756%202.924%200%203.35a1.724%201.724%200%200%200%20-1.066%202.573c.94%201.543%20-.826%203.31%20-2.37%202.37a1.724%201.724%200%200%200%20-2.572%201.065c-.426%201.756%20-2.924%201.756%20-3.35%200a1.724%201.724%200%200%200%20-2.573%20-1.066c-1.543%20.94%20-3.31%20-.826%20-2.37%20-2.37a1.724%201.724%200%200%200%20-1.065%20-2.572c-1.756%20-.426%20-1.756%20-2.924%200%20-3.35a1.724%201.724%200%200%200%201.066%20-2.573c-.94%20-1.543%20.826%20-3.31%202.37%20-2.37c1%20.608%202.296%20.07%202.572%20-1.065z%22%3E%3C%2Fpath%3E%0A%20%20%3Ccircle%20cx%3D%2212%22%20cy%3D%2212%22%20r%3D%223%22%3E%3C%2Fcircle%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-unknown:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M14%203v4a1%201%200%200%200%201%201h4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M17%2021h-10a2%202%200%200%201%20-2%20-2v-14a2%202%200%200%201%202%20-2h7l5%205v11a2%202%200%200%201%20-2%202z%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2017v.01%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2014a1.5%201.5%200%201%200%20-1.14%20-2.474%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-fullscreen:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Crect%20x%3D%223%22%20y%3D%2216%22%20width%3D%225%22%20height%3D%225%22%20rx%3D%221%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%2012v-6a2%202%200%200%201%202%20-2h12a2%202%200%200%201%202%202v12a2%202%200%200%201%20-2%202h-6%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%208h4v4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M16%208l-5%205%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-save:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%2017v2a2%202%200%200%200%202%202h12a2%202%200%200%200%202%20-2v-2%22%20%2F%3E%0A%20%20%3Cpolyline%20points%3D%227%2011%2012%2016%2017%2011%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2212%22%20y1%3D%224%22%20x2%3D%2212%22%20y2%3D%2216%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-copy:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Crect%20x%3D%228%22%20y%3D%228%22%20width%3D%2212%22%20height%3D%2212%22%20rx%3D%222%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M16%208v-2a2%202%200%200%200%20-2%20-2h-8a2%202%200%200%200%20-2%202v8a2%202%200%200%200%202%202h2%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-open:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20fill%3D%22none%22%20stroke%3D%22currentColor%22%20stroke-width%3D%222%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M9%204h3l2%202h5a2%202%200%200%201%202%202v7a2%202%200%200%201%20-2%202h-10a2%202%200%200%201%20-2%20-2v-9a2%202%200%200%201%202%20-2%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M17%2017v2a2%202%200%200%201%20-2%202h-10a2%202%200%200%201%20-2%20-2v-9a2%202%200%200%201%202%20-2h2%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-tap-select:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cline%20x1%3D%223%22%20y1%3D%2212%22%20x2%3D%226%22%20y2%3D%2212%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2212%22%20y1%3D%223%22%20x2%3D%2212%22%20y2%3D%226%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%227.8%22%20y1%3D%227.8%22%20x2%3D%225.6%22%20y2%3D%225.6%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2216.2%22%20y1%3D%227.8%22%20x2%3D%2218.4%22%20y2%3D%225.6%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%227.8%22%20y1%3D%2216.2%22%20x2%3D%225.6%22%20y2%3D%2218.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2012l9%203l-4%202l-2%204l-3%20-9%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-lasso-select:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4.028%2013.252c-.657%20-.972%20-1.028%20-2.078%20-1.028%20-3.252c0%20-3.866%204.03%20-7%209%20-7s9%203.134%209%207s-4.03%207%20-9%207c-1.913%200%20-3.686%20-.464%20-5.144%20-1.255%22%20%2F%3E%0A%20%20%3Ccircle%20cx%3D%225%22%20cy%3D%2215%22%20r%3D%222%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M5%2017c0%201.42%20.316%202.805%201%204%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-pan:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%209l3%203l-3%203%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%209l-3%203l3%203%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M9%2018l3%203l3%20-3%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%206l-3%20-3l-3%203%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2012h9%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%2012h9%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2012v9%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%203v9%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-x-pan:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%209l3%203l-3%203%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%209l-3%203l3%203%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2012h9%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%2012h9%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-y-pan:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M9%2018l3%203l3%20-3%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%206l-3%20-3l-3%203%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2012v9%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%203v9%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-pan-left:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20fill%3D%22none%22%20stroke%3D%22currentColor%22%20stroke-width%3D%222%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M20%2015h-8v3.586a1%201%200%200%201%20-1.707%20.707l-6.586%20-6.586a1%201%200%200%201%200%20-1.414l6.586%20-6.586a1%201%200%200%201%201.707%20.707v3.586h8a1%201%200%200%201%201%201v4a1%201%200%200%201%20-1%201z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-pan-right:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20fill%3D%22none%22%20stroke%3D%22currentColor%22%20stroke-width%3D%222%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%209h8v-3.586a1%201%200%200%201%201.707%20-.707l6.586%206.586a1%201%200%200%201%200%201.414l-6.586%206.586a1%201%200%200%201%20-1.707%20-.707v-3.586h-8a1%201%200%200%201%20-1%20-1v-4a1%201%200%200%201%201%20-1z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-pan-up:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20fill%3D%22none%22%20stroke%3D%22currentColor%22%20stroke-width%3D%222%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M9%2020v-8h-3.586a1%201%200%200%201%20-.707%20-1.707l6.586%20-6.586a1%201%200%200%201%201.414%200l6.586%206.586a1%201%200%200%201%20-.707%201.707h-3.586v8a1%201%200%200%201%20-1%201h-4a1%201%200%200%201%20-1%20-1z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-pan-down:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20fill%3D%22none%22%20stroke%3D%22currentColor%22%20stroke-width%3D%222%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M15%204v8h3.586a1%201%200%200%201%20.707%201.707l-6.586%206.586a1%201%200%200%201%20-1.414%200l-6.586%20-6.586a1%201%200%200%201%20.707%20-1.707h3.586v-8a1%201%200%200%201%201%20-1h4a1%201%200%200%201%201%201z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-box-select:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%206v-1a1%201%200%200%201%201%20-1h1m5%200h2m5%200h1a1%201%200%200%201%201%201v1m0%205v2m0%205v1a1%201%200%200%201%20-1%201h-1m-5%200h-2m-5%200h-1a1%201%200%200%201%20-1%20-1v-1m0%20-5v-2%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-x-box-select:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M17%2013l-4%204%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M13%2013l4%204%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%206v-1a1%201%200%200%201%201%20-1h1m5%200h2m5%200h1a1%201%200%200%201%201%201v1m0%205v2m0%205v1a1%201%200%200%201%20-1%201h-1m-5%200h-2m-5%200h-1a1%201%200%200%201%20-1%20-1v-1m0%20-5v-2%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-y-box-select:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M13%2013l2%202l2%20-2%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%2015v2.5%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%206v-1a1%201%200%200%201%201%20-1h1m5%200h2m5%200h1a1%201%200%200%201%201%201v1m0%205v2m0%205v1a1%201%200%200%201%20-1%201h-1m-5%200h-2m-5%200h-1a1%201%200%200%201%20-1%20-1v-1m0%20-5v-2%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-box-zoom:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2215%22%20cy%3D%2215%22%20r%3D%225%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M22%2022l-3%20-3%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%2018h-1a2%202%200%200%201%20-2%20-2v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%2011v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%206v-1a2%202%200%200%201%202%20-2h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M10%203h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%203h1a2%202%200%200%201%202%202v1%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-x-box-zoom:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M17%2013l-4%204%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M13%2013l4%204%22%20%2F%3E%0A%20%20%3Ccircle%20cx%3D%2215%22%20cy%3D%2215%22%20r%3D%225%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M22%2022l-3%20-3%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%2018h-1a2%202%200%200%201%20-2%20-2v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%2011v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%206v-1a2%202%200%200%201%202%20-2h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M10%203h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%203h1a2%202%200%200%201%202%202v1%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-y-box-zoom:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M13%2013l2%202l2%20-2%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%2015v2.5%22%20%2F%3E%0A%20%20%3Ccircle%20cx%3D%2215%22%20cy%3D%2215%22%20r%3D%225%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M22%2022l-3%20-3%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%2018h-1a2%202%200%200%201%20-2%20-2v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%2011v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%206v-1a2%202%200%200%201%202%20-2h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M10%203h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%203h1a2%202%200%200%201%202%202v1%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-auto-box-zoom:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2215%22%20cy%3D%2215%22%20r%3D%225%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M22%2022l-3%20-3%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%2018h-1a2%202%200%200%201%20-2%20-2v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%2011v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%206v-1a2%202%200%200%201%202%20-2h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M10%203h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%203h1a2%202%200%200%201%202%202v1%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-zoom-in:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2210%22%20cy%3D%2210%22%20r%3D%227%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%227%22%20y1%3D%2210%22%20x2%3D%2213%22%20y2%3D%2210%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2210%22%20y1%3D%227%22%20x2%3D%2210%22%20y2%3D%2213%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2221%22%20y1%3D%2221%22%20x2%3D%2215%22%20y2%3D%2215%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-zoom-out:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2210%22%20cy%3D%2210%22%20r%3D%227%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%227%22%20y1%3D%2210%22%20x2%3D%2213%22%20y2%3D%2210%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2221%22%20y1%3D%2221%22%20x2%3D%2215%22%20y2%3D%2215%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-undo:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M9%2013l-4%20-4l4%20-4m-4%204h11a4%204%200%200%201%200%208h-1%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-redo:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M15%2013l4%20-4l-4%20-4m4%204h-11a4%204%200%200%200%200%208h1%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-reset:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M20%2011a8.1%208.1%200%200%200%20-15.5%20-2m-.5%20-4v4h4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%2013a8.1%208.1%200%200%200%2015.5%202m.5%204v-4h-4%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-hover:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M12%2020l-3%20-3h-2a3%203%200%200%201%20-3%20-3v-6a3%203%200%200%201%203%20-3h10a3%203%200%200%201%203%203v6a3%203%200%200%201%20-3%203h-2l-3%203%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%228%22%20y1%3D%229%22%20x2%3D%2216%22%20y2%3D%229%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%228%22%20y1%3D%2213%22%20x2%3D%2214%22%20y2%3D%2213%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-crosshair:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2212%22%20cy%3D%2212%22%20r%3D%229%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M20%2012h-4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%2012h4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2020v-4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%204v4%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-chevron-up:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpolyline%20points%3D%226%2015%2012%209%2018%2015%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-chevron-down:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpolyline%20points%3D%226%209%2012%2015%2018%209%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-chevron-left:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpolyline%20points%3D%2215%206%209%2012%2015%2018%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-chevron-right:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpolyline%20points%3D%229%206%2015%2012%209%2018%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-caret-up:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22currentColor%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%2015l-6%20-6l-6%206h12%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-caret-down:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22currentColor%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%2015l-6%20-6l-6%206h12%22%20transform%3D%22rotate(180%2012%2012)%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-caret-left:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22currentColor%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%2015l-6%20-6l-6%206h12%22%20transform%3D%22rotate(270%2012%2012)%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-caret-right:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22currentColor%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%2015l-6%20-6l-6%206h12%22%20transform%3D%22rotate(90%2012%2012)%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-see-on:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2212%22%20cy%3D%2212%22%20r%3D%222%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M22%2012c-2.667%204.667%20-6%207%20-10%207s-7.333%20-2.333%20-10%20-7c2.667%20-4.667%206%20-7%2010%20-7s7.333%202.333%2010%207%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-see-off:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cline%20x1%3D%223%22%20y1%3D%223%22%20x2%3D%2221%22%20y2%3D%2221%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M10.584%2010.587a2%202%200%200%200%202.828%202.83%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M9.363%205.365a9.466%209.466%200%200%201%202.637%20-.365c4%200%207.333%202.333%2010%207c-.778%201.361%20-1.612%202.524%20-2.503%203.488m-2.14%201.861c-1.631%201.1%20-3.415%201.651%20-5.357%201.651c-4%200%20-7.333%20-2.333%20-10%20-7c1.369%20-2.395%202.913%20-4.175%204.632%20-5.341%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-cursor-rotate:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%3E%0A%20%20%3Cg%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%20%20%3Cg%20stroke-width%3D%224%22%20stroke%3D%22white%22%3E%0A%20%20%20%20%20%20%3Cpath%20d%3D%22M9%204.55a8%208%200%200%201%206%2014.9m0%20-4.45v5h5%22%20%2F%3E%0A%20%20%20%20%3C%2Fg%3E%0A%20%20%20%20%3Cg%20stroke-width%3D%222%22%20stroke%3D%22black%22%3E%0A%20%20%20%20%20%20%3Cpath%20d%3D%22M9%204.55a8%208%200%200%201%206%2014.9m0%20-4.45v5h5%22%20%2F%3E%0A%20%20%20%20%3C%2Fg%3E%0A%20%20%3C%2Fg%3E%0A%3C%2Fsvg%3E%0A") 12 12, auto;--bokeh-icon-x-grip:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M5%209m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M5%2015m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M12%209m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M12%2015m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M19%209m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M19%2015m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-y-grip:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M9%205m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M9%2012m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M9%2019m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M15%205m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M15%2012m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M15%2019m-1%200a1%201%200%201%200%202%200a1%201%200%201%200%20-2%200%22%3E%3C%2Fpath%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-arrow-down-to-bar:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%2020l16%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M12%2014l0%20-10%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M12%2014l4%20-4%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M12%2014l-4%20-4%22%3E%3C%2Fpath%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-arrow-up-from-bar:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M12%204l0%2010%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M12%204l4%204%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M12%204l-4%204%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M4%2020l16%200%22%3E%3C%2Fpath%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-minimize:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M15%2019v-2a2%202%200%200%201%202%20-2h2%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M15%205v2a2%202%200%200%200%202%202h2%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M5%2015h2a2%202%200%200%201%202%202v2%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M5%209h2a2%202%200%200%200%202%20-2v-2%22%3E%3C%2Fpath%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-maximize:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%208v-2a2%202%200%200%201%202%20-2h2%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M4%2016v2a2%202%200%200%200%202%202h2%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M16%204h2a2%202%200%200%201%202%202v2%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M16%2020h2a2%202%200%200%200%202%20-2v-2%22%3E%3C%2Fpath%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-pin:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M15%204.5l-4%204l-4%201.5l-1.5%201.5l7%207l1.5%20-1.5l1.5%20-4l4%20-4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M9%2015l-4.5%204.5%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M14.5%204l5.5%205.5%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-unpin:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M3%203l18%2018%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%204.5l-3.249%203.249m-2.57%201.433l-2.181%20.818l-1.5%201.5l7%207l1.5%20-1.5l.82%20-2.186m1.43%20-2.563l3.25%20-3.251%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M9%2015l-4.5%204.5%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M14.5%204l5.5%205.5%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-hand-pointing:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M8%2013v-8.5a1.5%201.5%200%200%201%203%200v7.5%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M11%2011.5v-2a1.5%201.5%200%201%201%203%200v2.5%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M14%2010.5a1.5%201.5%200%200%201%203%200v1.5%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M17%2011.5a1.5%201.5%200%200%201%203%200v4.5a6%206%200%200%201%20-6%206h-2h.208a6%206%200%200%201%20-5.012%20-2.7a69.74%2069.74%200%200%201%20-.196%20-.3c-.312%20-.479%20-1.407%20-2.388%20-3.286%20-5.728a1.5%201.5%200%200%201%20.536%20-2.022a1.867%201.867%200%200%201%202.28%20.28l1.47%201.47%22%3E%3C%2Fpath%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-trash:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%207l16%200%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M10%2011l0%206%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M14%2011l0%206%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M5%207l1%2012a2%202%200%200%200%202%202h8a2%202%200%200%200%202%20-2l1%20-12%22%3E%3C%2Fpath%3E%0A%20%20%3Cpath%20d%3D%22M9%207v-3a1%201%200%200%201%201%20-1h4a1%201%200%200%201%201%201v3%22%3E%3C%2Fpath%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-bold:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M7%205h6a3.5%203.5%200%200%201%200%207h-6z%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M13%2012h1a3.5%203.5%200%200%201%200%207h-7v-7%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-italic:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M11%205l6%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M7%2019l6%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M14%205l-4%2014%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-text-align-left:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%206l16%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%2012l10%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%2018l14%200%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-text-align-center:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%206l16%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M8%2012l8%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%2018l12%200%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-text-align-right:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%206l16%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M10%2012l10%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%2018l14%200%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-check:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M5%2012l5%205l10%20-10%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-square:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M3%203m0%202a2%202%200%200%201%202%20-2h14a2%202%200%200%201%202%202v14a2%202%200%200%201%20-2%202h-14a2%202%200%200%201%20-2%20-2z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-square-check:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M3%203m0%202a2%202%200%200%201%202%20-2h14a2%202%200%200%201%202%202v14a2%202%200%200%201%20-2%202h-14a2%202%200%200%201%20-2%20-2z%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M9%2012l2%202l4%20-4%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-list:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20fill%3D%22none%22%20stroke%3D%22currentColor%22%20stroke-width%3D%222%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M9%206l11%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M9%2012l11%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M9%2018l11%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M5%206l0%20.01%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M5%2012l0%20.01%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M5%2018l0%20.01%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-light-theme:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20fill%3D%22none%22%20stroke%3D%22currentColor%22%20stroke-width%3D%222%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M12%2012m-4%200a4%204%200%201%200%208%200a4%204%200%201%200%20-8%200%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%2012h1m8%20-9v1m8%208h1m-9%208v1m-6.4%20-15.4l.7%20.7m12.1%20-.7l-.7%20.7m0%2011.4l.7%20.7m-12.1%20-.7l-.7%20.7%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-dark-theme:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20fill%3D%22none%22%20stroke%3D%22currentColor%22%20stroke-width%3D%222%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M12%203c.132%200%20.263%200%20.393%200a7.5%207.5%200%200%200%207.92%2012.446a9%209%200%201%201%20-8.313%20-12.454z%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");}`;
},
/* models/renderers/renderer_group.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const model_1 = require(51) /* ../../model */;
    class RendererGroup extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.RendererGroup = RendererGroup;
    _a = RendererGroup;
    RendererGroup.__name__ = "RendererGroup";
    (() => {
        _a.define(({ Bool }) => ({
            visible: [Bool, true],
        }));
    })();
},
/* models/dom/dom_node.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const dom_view_1 = require(57) /* ../../core/dom_view */;
    const model_1 = require(51) /* ../../model */;
    class DOMNodeView extends dom_view_1.DOMView {
    }
    exports.DOMNodeView = DOMNodeView;
    DOMNodeView.__name__ = "DOMNodeView";
    class DOMNode extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.DOMNode = DOMNode;
    DOMNode.__name__ = "DOMNode";
    DOMNode.__module__ = "bokeh.models.dom";
},
/* models/annotations/arrow.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const data_annotation_1 = require(127) /* ./data_annotation */;
    const arrow_head_1 = require(168) /* ./arrow_head */;
    const property_mixins_1 = require(80) /* ../../core/property_mixins */;
    const enums_1 = require(21) /* ../../core/enums */;
    const types_1 = require(25) /* ../../core/types */;
    const build_views_1 = require(56) /* ../../core/build_views */;
    const types_2 = require(25) /* ../../core/types */;
    const p = tslib_1.__importStar(require(19) /* ../../core/properties */);
    const math_1 = require(11) /* ../../core/util/math */;
    class ArrowView extends data_annotation_1.DataAnnotationView {
        *children() {
            yield* super.children();
            const { start, end } = this;
            if (start != null) {
                yield start;
            }
            if (end != null) {
                yield end;
            }
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            const { start, end } = this.model;
            if (start != null) {
                this.start = await (0, build_views_1.build_view)(start, { parent: this });
            }
            if (end != null) {
                this.end = await (0, build_views_1.build_view)(end, { parent: this });
            }
        }
        set_data(source) {
            super.set_data(source);
            const indices = types_2.Indices.all_set(this._x_start.length);
            this.start?.set_data(source, indices);
            this.end?.set_data(source, indices);
        }
        remove() {
            this.start?.remove();
            this.end?.remove();
            super.remove();
        }
        map_data() {
            const { frame } = this.plot_view;
            const [sx_start, sy_start] = (() => {
                switch (this.model.start_units) {
                    case "canvas": {
                        return [
                            new types_1.ScreenArray(this._x_start),
                            new types_1.ScreenArray(this._y_start),
                        ];
                    }
                    case "screen": {
                        return [
                            frame.bbox.xview.v_compute(this._x_start),
                            frame.bbox.yview.v_compute(this._y_start),
                        ];
                    }
                    case "data": {
                        return [
                            this.coordinates.x_scale.v_compute(this._x_start),
                            this.coordinates.y_scale.v_compute(this._y_start),
                        ];
                    }
                }
            })();
            const [sx_end, sy_end] = (() => {
                switch (this.model.end_units) {
                    case "canvas": {
                        return [
                            new types_1.ScreenArray(this._x_end),
                            new types_1.ScreenArray(this._y_end),
                        ];
                    }
                    case "screen": {
                        return [
                            frame.bbox.xview.v_compute(this._x_end),
                            frame.bbox.yview.v_compute(this._y_end),
                        ];
                    }
                    case "data": {
                        return [
                            this.coordinates.x_scale.v_compute(this._x_end),
                            this.coordinates.y_scale.v_compute(this._y_end),
                        ];
                    }
                }
            })();
            this._sx_start = sx_start;
            this._sy_start = sy_start;
            this._sx_end = sx_end;
            this._sy_end = sy_end;
            const n = sx_start.length;
            const angles = this._angles = new types_1.ScreenArray(n);
            for (let i = 0; i < n; i++) {
                // arrow head runs orthogonal to arrow body (???)
                angles[i] = Math.PI / 2 + (0, math_1.atan2)([sx_start[i], sy_start[i]], [sx_end[i], sy_end[i]]);
            }
        }
        _paint_data(ctx) {
            const { start, end } = this;
            const { _sx_start, _sy_start, _sx_end, _sy_end, _angles } = this;
            const { x, y, width, height } = this.plot_view.frame.bbox;
            for (let i = 0, n = _sx_start.length; i < n; i++) {
                if (end != null) {
                    ctx.save();
                    ctx.translate(_sx_end[i], _sy_end[i]);
                    ctx.rotate(_angles[i]);
                    end.paint(ctx, i);
                    ctx.restore();
                }
                if (start != null) {
                    ctx.save();
                    ctx.translate(_sx_start[i], _sy_start[i]);
                    ctx.rotate(_angles[i] + Math.PI);
                    start.paint(ctx, i);
                    ctx.restore();
                }
                if (!this.visuals.line.doit) {
                    continue;
                }
                ctx.save();
                if (start != null || end != null) {
                    ctx.beginPath();
                    ctx.rect(x, y, width, height);
                    if (end != null) {
                        ctx.save();
                        ctx.translate(_sx_end[i], _sy_end[i]);
                        ctx.rotate(_angles[i]);
                        end.clip(ctx, i);
                        ctx.restore();
                    }
                    if (start != null) {
                        ctx.save();
                        ctx.translate(_sx_start[i], _sy_start[i]);
                        ctx.rotate(_angles[i] + Math.PI);
                        start.clip(ctx, i);
                        ctx.restore();
                    }
                    ctx.closePath();
                    ctx.clip();
                }
                ctx.beginPath();
                ctx.moveTo(_sx_start[i], _sy_start[i]);
                ctx.lineTo(_sx_end[i], _sy_end[i]);
                this.visuals.line.apply(ctx, i);
                ctx.restore();
            }
        }
    }
    exports.ArrowView = ArrowView;
    ArrowView.__name__ = "ArrowView";
    class Arrow extends data_annotation_1.DataAnnotation {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Arrow = Arrow;
    _a = Arrow;
    Arrow.__name__ = "Arrow";
    (() => {
        _a.prototype.default_view = ArrowView;
        _a.mixins(property_mixins_1.LineVector);
        _a.define(({ Ref, Nullable }) => ({
            x_start: [p.XCoordinateSpec, { field: "x_start" }],
            y_start: [p.YCoordinateSpec, { field: "y_start" }],
            start_units: [enums_1.CoordinateUnits, "data"],
            start: [Nullable(Ref(arrow_head_1.ArrowHead)), null],
            x_end: [p.XCoordinateSpec, { field: "x_end" }],
            y_end: [p.YCoordinateSpec, { field: "y_end" }],
            end_units: [enums_1.CoordinateUnits, "data"],
            end: [Nullable(Ref(arrow_head_1.ArrowHead)), () => new arrow_head_1.OpenHead()],
        }));
    })();
},
/* models/annotations/data_annotation.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const annotation_1 = require(81) /* ./annotation */;
    const columnar_data_source_1 = require(128) /* ../sources/columnar_data_source */;
    const column_data_source_1 = require(133) /* ../sources/column_data_source */;
    const projections_1 = require(134) /* ../../core/util/projections */;
    const p = tslib_1.__importStar(require(19) /* ../../core/properties */);
    class DataAnnotationView extends annotation_1.AnnotationView {
        constructor() {
            super(...arguments);
            this._initial_set_data = false;
        }
        connect_signals() {
            super.connect_signals();
            const update = () => {
                this.set_data(this.model.source);
                this._rerender();
            };
            this.connect(this.model.change, update);
            this.connect(this.model.source.streaming, update);
            this.connect(this.model.source.patching, update);
            this.connect(this.model.source.change, update);
        }
        _rerender() {
            this.request_paint();
        }
        set_data(source) {
            const self = this;
            for (const prop of this.model) {
                if (!(prop instanceof p.VectorSpec || prop instanceof p.ScalarSpec)) {
                    continue;
                }
                if (prop instanceof p.BaseCoordinateSpec) {
                    const array = prop.array(source);
                    self[`_${prop.attr}`] = array;
                }
                else {
                    const uniform = prop.uniform(source);
                    self[`${prop.attr}`] = uniform;
                }
            }
            if (this.plot_model.use_map) {
                if (self._x != null) {
                    projections_1.inplace.project_xy(self._x, self._y);
                }
                if (self._xs != null) {
                    projections_1.inplace.project_xsys(self._xs, self._ys);
                }
            }
            for (const visual of this.visuals) {
                visual.update();
            }
        }
        _paint(ctx) {
            if (!this._initial_set_data) {
                this.set_data(this.model.source);
                this._initial_set_data = true;
            }
            this.map_data();
            this._paint_data(ctx);
        }
    }
    exports.DataAnnotationView = DataAnnotationView;
    DataAnnotationView.__name__ = "DataAnnotationView";
    class DataAnnotation extends annotation_1.Annotation {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.DataAnnotation = DataAnnotation;
    _a = DataAnnotation;
    DataAnnotation.__name__ = "DataAnnotation";
    (() => {
        _a.define(({ Ref }) => ({
            source: [Ref(columnar_data_source_1.ColumnarDataSource), () => new column_data_source_1.ColumnDataSource()],
        }));
    })();
},
/* models/sources/columnar_data_source.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const logging_1 = require(20) /* ../../core/logging */;
    const selection_manager_1 = require(129) /* ../../core/selection_manager */;
    const signaling_1 = require(16) /* ../../core/signaling */;
    const assert_1 = require(12) /* ../../core/util/assert */;
    const array_1 = require(10) /* ../../core/util/array */;
    const ndarray_1 = require(31) /* ../../core/util/ndarray */;
    const object_1 = require(9) /* ../../core/util/object */;
    const types_1 = require(8) /* ../../core/util/types */;
    const interaction_policy_1 = require(131) /* ../selections/interaction_policy */;
    const selection_1 = require(130) /* ../selections/selection */;
    const data_source_1 = require(132) /* ./data_source */;
    class ColumnarDataSource extends data_source_1.DataSource {
        get_array(key) {
            const data = (0, object_1.dict)(this.data);
            let column = data.get(key);
            if (column == null) {
                data.set(key, column = []);
            }
            else if (!(0, types_1.isArray)(column)) {
                data.set(key, column = Array.from(column));
            }
            return column;
        }
        constructor(attrs) {
            super(attrs);
            this.selection_manager = new selection_manager_1.SelectionManager(this);
        }
        initialize() {
            super.initialize();
            this._select = new signaling_1.Signal0(this, "select");
            this.inspect = new signaling_1.Signal(this, "inspect");
        }
        get inferred_defaults() {
            const defaults = new Map();
            for (const [name, array] of (0, object_1.entries)(this.data)) {
                const value = (() => {
                    if ((0, ndarray_1.is_NDArray)(array)) {
                        switch (array.dtype) {
                            case "bool":
                                return false;
                            case "uint8":
                            case "int8":
                            case "uint16":
                            case "int16":
                            case "uint32":
                            case "int32":
                            case "float32":
                            case "float64":
                                return 0;
                            case "object":
                                return null;
                        }
                    }
                    else if ((0, types_1.isArray)(array) && array.length != 0) {
                        const [item] = array;
                        if (item === null) {
                            return null;
                        }
                        else if ((0, types_1.isBoolean)(item)) {
                            return false;
                        }
                        else if ((0, types_1.isNumber)(item)) {
                            return 0;
                        }
                        else if ((0, types_1.isString)(item)) {
                            return "";
                        }
                        else if ((0, types_1.isArray)(item)) {
                            return [];
                        }
                    }
                    return undefined;
                })();
                if (value !== undefined) {
                    defaults.set(name, value);
                }
            }
            return defaults;
        }
        get(name) {
            const column = this.get_column(name);
            (0, assert_1.assert)(column != null, `unknown column '${name}' in ${this}`);
            return column;
        }
        set(name, column) {
            (0, object_1.dict)(this.data).set(name, column);
        }
        get_column(name) {
            const data = (0, object_1.dict)(this.data);
            return data.get(name) ?? null;
        }
        columns() {
            // return the column names in this data source
            return (0, object_1.keys)(this.data);
        }
        get_length(soft = true) {
            const lengths = (0, array_1.uniq)((0, object_1.values)(this.data).map((v) => (0, ndarray_1.is_NDArray)(v) ? v.shape[0] : v.length));
            switch (lengths.length) {
                case 0: {
                    return null; // XXX: don't guess, treat on case-by-case basis
                }
                case 1: {
                    return lengths[0];
                }
                default: {
                    const msg = "data source has columns of inconsistent lengths";
                    if (soft) {
                        logging_1.logger.warn(msg);
                        return lengths.sort()[0];
                    }
                    else {
                        throw new Error(msg);
                    }
                }
            }
        }
        get length() {
            return this.get_length() ?? 0;
        }
        clear() {
            const data = (0, object_1.clone)(this.data);
            const proxy = (0, object_1.dict)(data);
            for (const [name, column] of proxy) {
                const empty = new column.constructor(0);
                proxy.set(name, empty);
            }
            this.data = data;
        }
        stream(new_data, rollover, { sync } = {}) {
            this.stream_to(this.properties.data, new_data, rollover, { sync });
        }
        patch(patches, { sync } = {}) {
            this.patch_to(this.properties.data, patches, { sync });
        }
    }
    exports.ColumnarDataSource = ColumnarDataSource;
    _a = ColumnarDataSource;
    ColumnarDataSource.__name__ = "ColumnarDataSource";
    (() => {
        _a.define(({ Ref, Dict, Unknown }) => ({
            default_values: [Dict(Unknown), {}],
            selection_policy: [Ref(interaction_policy_1.SelectionPolicy), () => new interaction_policy_1.UnionRenderers()],
        }));
        _a.internal(({ AnyRef }) => ({
            inspected: [AnyRef(), () => new selection_1.Selection()],
        }));
    })();
},
/* core/selection_manager.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const selection_1 = require(130) /* ../models/selections/selection */;
    // XXX: this is needed to cut circular dependency between this, models/renderers/* and models/sources/*
    function is_GlyphRendererView(renderer_view) {
        return renderer_view.model.type == "GlyphRenderer";
    }
    function is_GraphRendererView(renderer_view) {
        return renderer_view.model.type == "GraphRenderer";
    }
    class SelectionManager {
        constructor(source) {
            this.inspectors = new Map();
            this.source = source;
        }
        select(renderer_views, geometry, final, mode = "replace") {
            // divide renderers into glyph_renderers or graph_renderers
            const glyph_renderer_views = [];
            const graph_renderer_views = [];
            for (const r of renderer_views) {
                if (is_GlyphRendererView(r)) {
                    glyph_renderer_views.push(r);
                }
                else if (is_GraphRendererView(r)) {
                    graph_renderer_views.push(r);
                }
            }
            let did_hit = false;
            // graph renderer case
            for (const r of graph_renderer_views) {
                const hit_test_result = r.model.selection_policy.hit_test(geometry, r);
                did_hit = did_hit || r.model.selection_policy.do_selection(hit_test_result, r.model, final, mode);
            }
            // glyph renderers
            if (glyph_renderer_views.length > 0) {
                const hit_test_result = this.source.selection_policy.hit_test(geometry, glyph_renderer_views);
                did_hit = did_hit || this.source.selection_policy.do_selection(hit_test_result, this.source, final, mode);
            }
            return did_hit;
        }
        inspect(renderer_view, geometry) {
            let did_hit = false;
            if (is_GlyphRendererView(renderer_view)) {
                const hit_test_result = renderer_view.hit_test(geometry);
                if (hit_test_result != null) {
                    did_hit = !hit_test_result.is_empty();
                    const inspection = this.get_or_create_inspector(renderer_view.model);
                    inspection.update(hit_test_result, true, "replace");
                    this.source.setv({ inspected: inspection }, { silent: true });
                    this.source.inspect.emit([renderer_view.model, { geometry }]);
                }
            }
            else if (is_GraphRendererView(renderer_view)) {
                const hit_test_result = renderer_view.model.inspection_policy.hit_test(geometry, renderer_view);
                did_hit = renderer_view.model.inspection_policy.do_inspection(hit_test_result, geometry, renderer_view, false, "replace");
            }
            return did_hit;
        }
        invert(rview) {
            const n = this.source.get_length();
            if (n == null) {
                return;
            }
            this.source.selected.invert(n);
            if (rview != null) {
                this.get_or_create_inspector(rview.model).invert(n);
            }
        }
        clear(rview) {
            this.source.selected.clear();
            if (rview != null) {
                this.get_or_create_inspector(rview.model).clear();
            }
        }
        get_or_create_inspector(renderer) {
            let selection = this.inspectors.get(renderer);
            if (selection == null) {
                selection = new selection_1.Selection();
                this.inspectors.set(renderer, selection);
            }
            return selection;
        }
    }
    exports.SelectionManager = SelectionManager;
    SelectionManager.__name__ = "SelectionManager";
},
/* models/selections/selection.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const model_1 = require(51) /* ../../model */;
    const array_1 = require(10) /* ../../core/util/array */;
    const object_1 = require(9) /* ../../core/util/object */;
    const kinds_1 = require(22) /* ../../core/kinds */;
    const arrayable_1 = require(13) /* ../../core/util/arrayable */;
    exports.OpaqueIndices = (0, kinds_1.Arrayable)(kinds_1.Int);
    exports.MultiIndices = (0, kinds_1.Mapping)(kinds_1.Int, exports.OpaqueIndices);
    class Selection extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
        get_view() {
            return this.view;
        }
        get selected_glyph() {
            return this.selected_glyphs.length > 0 ? this.selected_glyphs[0] : null;
        }
        add_to_selected_glyphs(glyph) {
            this.selected_glyphs.push(glyph);
        }
        update(selection, _final = true, mode = "replace") {
            switch (mode) {
                case "replace": {
                    this.update_through_replacement(selection);
                    break;
                }
                case "toggle": {
                    this.update_through_toggle(selection);
                    break;
                }
                case "append": {
                    this.update_through_union(selection);
                    break;
                }
                case "intersect": {
                    this.update_through_intersection(selection);
                    break;
                }
                case "subtract": {
                    this.update_through_subtraction(selection);
                    break;
                }
                case "xor": {
                    this.update_through_symmetric_difference(selection);
                    break;
                }
            }
        }
        // TODO `size` wouldn't be needed if `indices` was an instance of
        // `Indices` class, instead of an array of numbers. Then also we
        // could just call `.invert()` on the class.
        invert(size) {
            const indices = new Set(this.indices);
            const inversion = [];
            for (let i = 0; i < size; i++) {
                if (!indices.has(i)) {
                    inversion.push(i);
                }
            }
            this.indices = inversion;
            // this.line_indices
            // this.multiline_indices
            // this.image_indices
        }
        clear() {
            this.indices = [];
            this.line_indices = [];
            this.multiline_indices = new Map();
            this.image_indices = [];
            this.view = null;
            this.selected_glyphs = [];
        }
        map(mapper) {
            return new _a({
                ...this.attributes,
                indices: (0, arrayable_1.map)(this.indices, mapper),
                // NOTE: line_indices don't support subset indexing
                multiline_indices: new Map((0, arrayable_1.map)([...this.multiline_indices.entries()], ([index, line_indices]) => [mapper(index), line_indices])),
                image_indices: this.image_indices.map((image_index) => ({ ...image_index, index: mapper(image_index.index) })),
            });
        }
        is_empty() {
            return this.indices.length == 0 && this.line_indices.length == 0 && this.image_indices.length == 0;
        }
        _union_image_indices(...collection) {
            const is = new Map();
            const js = new Map();
            const result = [];
            for (const indices of collection) {
                for (const image_index of indices) {
                    const { index, i, j } = image_index;
                    const iis = is.get(index);
                    const ijs = js.get(index);
                    if (iis != null && ijs != null) {
                        if (!iis.has(i) || !ijs.has(j)) {
                            result.push(image_index);
                            iis.add(i);
                            ijs.add(j);
                        }
                    }
                    else {
                        result.push(image_index);
                        is.set(index, new Set([i]));
                        js.set(index, new Set([j]));
                    }
                }
            }
            return result;
        }
        update_through_replacement(other) {
            this.indices = other.indices;
            this.line_indices = other.line_indices;
            this.multiline_indices = other.multiline_indices;
            this.image_indices = other.image_indices;
            this.view = other.view;
            this.selected_glyphs = other.selected_glyphs;
        }
        update_through_toggle(other) {
            // note the order of arguments when comparing with update_through_subtraction()
            this.indices = (0, array_1.difference)(other.indices, this.indices);
            // TODO: think through and fix any logic below
            this.selected_glyphs = (0, array_1.union)(other.selected_glyphs, this.selected_glyphs);
            this.line_indices = (0, array_1.union)(other.line_indices, this.line_indices);
            this.image_indices = this._union_image_indices(this.image_indices, other.image_indices); // TODO
            this.view = other.view;
            this.multiline_indices = (0, object_1.merge)(other.multiline_indices, this.multiline_indices);
        }
        update_through_union(other) {
            this.indices = (0, array_1.union)(this.indices, other.indices);
            this.selected_glyphs = (0, array_1.union)(other.selected_glyphs, this.selected_glyphs);
            this.line_indices = (0, array_1.union)(other.line_indices, this.line_indices);
            this.image_indices = this._union_image_indices(this.image_indices, other.image_indices); // TODO
            this.view = other.view;
            this.multiline_indices = (0, object_1.merge)(other.multiline_indices, this.multiline_indices);
        }
        update_through_intersection(other) {
            this.indices = (0, array_1.intersection)(this.indices, other.indices);
            // TODO: think through and fix any logic below
            this.selected_glyphs = (0, array_1.union)(other.selected_glyphs, this.selected_glyphs);
            this.line_indices = (0, array_1.union)(other.line_indices, this.line_indices);
            this.image_indices = this._union_image_indices(this.image_indices, other.image_indices); // TODO
            this.view = other.view;
            this.multiline_indices = (0, object_1.merge)(other.multiline_indices, this.multiline_indices);
        }
        update_through_subtraction(other) {
            this.indices = (0, array_1.difference)(this.indices, other.indices);
            // TODO: think through and fix any logic below
            this.selected_glyphs = (0, array_1.union)(other.selected_glyphs, this.selected_glyphs);
            this.line_indices = (0, array_1.union)(other.line_indices, this.line_indices);
            this.image_indices = this._union_image_indices(this.image_indices, other.image_indices); // TODO
            this.view = other.view;
            this.multiline_indices = (0, object_1.merge)(other.multiline_indices, this.multiline_indices);
        }
        update_through_symmetric_difference(other) {
            this.indices = (0, array_1.symmetric_difference)(this.indices, other.indices);
            // TODO: think through and fix any logic below
            this.selected_glyphs = (0, array_1.union)(other.selected_glyphs, this.selected_glyphs);
            this.line_indices = (0, array_1.union)(other.line_indices, this.line_indices);
            this.image_indices = this._union_image_indices(this.image_indices, other.image_indices); // TODO
            this.view = other.view;
            this.multiline_indices = (0, object_1.merge)(other.multiline_indices, this.multiline_indices);
        }
    }
    exports.Selection = Selection;
    _a = Selection;
    Selection.__name__ = "Selection";
    (() => {
        _a.define(({ Int, List, Struct }) => ({
            indices: [exports.OpaqueIndices, []],
            line_indices: [exports.OpaqueIndices, []],
            multiline_indices: [exports.MultiIndices, new Map()],
            image_indices: [List(Struct({ index: Int, i: Int, j: Int, flat_index: Int })), []],
        }));
        _a.internal(({ List, AnyRef, Nullable }) => ({
            selected_glyphs: [List(AnyRef()), []],
            view: [Nullable(AnyRef()), null],
        }));
    })();
},
/* models/selections/interaction_policy.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const model_1 = require(51) /* ../../model */;
    class SelectionPolicy extends model_1.Model {
        do_selection(hit_test_result, source, final, mode) {
            if (hit_test_result == null) {
                return false;
            }
            else {
                source.selected.update(hit_test_result, final, mode);
                source._select.emit();
                return !source.selected.is_empty();
            }
        }
    }
    exports.SelectionPolicy = SelectionPolicy;
    SelectionPolicy.__name__ = "SelectionPolicy";
    class IntersectRenderers extends SelectionPolicy {
        hit_test(geometry, renderer_views) {
            const hit_test_result_renderers = [];
            for (const r of renderer_views) {
                const result = r.hit_test(geometry);
                if (result != null) {
                    hit_test_result_renderers.push(result);
                }
            }
            if (hit_test_result_renderers.length > 0) {
                const hit_test_result = hit_test_result_renderers[0];
                for (const hit_test_result_other of hit_test_result_renderers) {
                    hit_test_result.update_through_intersection(hit_test_result_other);
                }
                return hit_test_result;
            }
            else {
                return null;
            }
        }
    }
    exports.IntersectRenderers = IntersectRenderers;
    IntersectRenderers.__name__ = "IntersectRenderers";
    class UnionRenderers extends SelectionPolicy {
        hit_test(geometry, renderer_views) {
            const hit_test_result_renderers = [];
            for (const r of renderer_views) {
                const result = r.hit_test(geometry);
                if (result != null) {
                    hit_test_result_renderers.push(result);
                }
            }
            if (hit_test_result_renderers.length > 0) {
                const hit_test_result = hit_test_result_renderers[0];
                for (const hit_test_result_other of hit_test_result_renderers) {
                    hit_test_result.update_through_union(hit_test_result_other);
                }
                return hit_test_result;
            }
            else {
                return null;
            }
        }
    }
    exports.UnionRenderers = UnionRenderers;
    UnionRenderers.__name__ = "UnionRenderers";
},
/* models/sources/data_source.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const model_1 = require(51) /* ../../model */;
    const selection_1 = require(130) /* ../selections/selection */;
    class DataSource extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.DataSource = DataSource;
    _a = DataSource;
    DataSource.__name__ = "DataSource";
    (() => {
        _a.define(({ Ref }) => ({
            selected: [Ref(selection_1.Selection), () => new selection_1.Selection(), { readonly: true }],
        }));
    })();
},
/* models/sources/column_data_source.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const columnar_data_source_1 = require(128) /* ./columnar_data_source */;
    class ColumnDataSource extends columnar_data_source_1.ColumnarDataSource {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.ColumnDataSource = ColumnDataSource;
    _a = ColumnDataSource;
    ColumnDataSource.__name__ = "ColumnDataSource";
    (() => {
        _a.define(({ Unknown, Dict, Arrayable }) => ({
            data: [Dict(Arrayable(Unknown)), {}],
        }));
    })();
},
/* core/util/projections.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.clip_mercator = clip_mercator;
    exports.in_bounds = in_bounds;
    exports.project_xy = project_xy;
    exports.project_xsys = project_xsys;
    const tslib_1 = require(1) /* tslib */;
    const core_1 = tslib_1.__importDefault(require(135) /* proj4/lib/core */);
    const Proj_1 = tslib_1.__importDefault(require(136) /* proj4/lib/Proj */);
    const types_1 = require(25) /* ../types */;
    const mercator = new Proj_1.default("GOOGLE");
    const wgs84 = new Proj_1.default("WGS84");
    const _wgs84_mercator = (0, core_1.default)(wgs84, mercator);
    exports.wgs84_mercator = {
        compute(x, y) {
            if (isFinite(x) && isFinite(y)) {
                return _wgs84_mercator.forward([x, y]);
            }
            else {
                return [NaN, NaN];
            }
        },
        invert(merc_x, merc_y) {
            if (isFinite(merc_x) && isFinite(merc_y)) {
                return _wgs84_mercator.inverse([merc_x, merc_y]);
            }
            else {
                return [NaN, NaN];
            }
        },
    };
    const mercator_bounds = {
        lon: [-20026376.39, 20026376.39],
        lat: [-20048966.10, 20048966.10],
    };
    const latlon_bounds = {
        lon: [-180, 180],
        lat: [-85.06, 85.06],
    };
    const { min, max } = Math;
    function clip_mercator(low, high, dimension) {
        const [vmin, vmax] = mercator_bounds[dimension];
        return [max(low, vmin), min(high, vmax)];
    }
    function in_bounds(value, dimension) {
        const [min, max] = latlon_bounds[dimension];
        return min < value && value < max;
    }
    (function (inplace) {
        function project_xy(x, y, merc_x, merc_y) {
            const n = min(x.length, y.length);
            merc_x = merc_x ?? x;
            merc_y = merc_y ?? y;
            for (let i = 0; i < n; i++) {
                const xi = x[i];
                const yi = y[i];
                const [merc_xi, merc_yi] = exports.wgs84_mercator.compute(xi, yi);
                merc_x[i] = merc_xi;
                merc_y[i] = merc_yi;
            }
        }
        inplace.project_xy = project_xy;
        function project_xsys(xs, ys, merc_xs, merc_ys) {
            const n = min(xs.length, ys.length);
            merc_xs = merc_xs ?? xs;
            merc_ys = merc_ys ?? ys;
            for (let i = 0; i < n; i++) {
                project_xy(xs[i], ys[i], merc_xs[i], merc_ys[i]);
            }
        }
        inplace.project_xsys = project_xsys;
    })(exports.inplace || (exports.inplace = {}));
    function project_xy(x, y) {
        const n = min(x.length, y.length);
        const ArrayType = (0, types_1.infer_type)(x, y);
        const merc_x = new ArrayType(n);
        const merc_y = new ArrayType(n);
        exports.inplace.project_xy(x, y, merc_x, merc_y);
        return [merc_x, merc_y];
    }
    function project_xsys(xs, ys) {
        const n = min(xs.length, ys.length);
        const merc_xs = new Array(n);
        const merc_ys = new Array(n);
        for (let i = 0; i < n; i++) {
            const [merc_x, merc_y] = project_xy(xs[i], ys[i]);
            merc_xs[i] = merc_x;
            merc_ys[i] = merc_y;
        }
        return [merc_xs, merc_ys];
    }
},
/* proj4/lib/core.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const Proj_1 = tslib_1.__importDefault(require(136) /* ./Proj */);
    const transform_1 = tslib_1.__importDefault(require(162) /* ./transform */);
    var wgs84 = (0, Proj_1.default)('WGS84');
    function transformer(from, to, coords, enforceAxis) {
        var transformedArray, out, keys;
        if (Array.isArray(coords)) {
            transformedArray = (0, transform_1.default)(from, to, coords, enforceAxis) || { x: NaN, y: NaN };
            if (coords.length > 2) {
                if ((typeof from.name !== 'undefined' && from.name === 'geocent') || (typeof to.name !== 'undefined' && to.name === 'geocent')) {
                    if (typeof transformedArray.z === 'number') {
                        return [transformedArray.x, transformedArray.y, transformedArray.z].concat(coords.splice(3));
                    }
                    else {
                        return [transformedArray.x, transformedArray.y, coords[2]].concat(coords.splice(3));
                    }
                }
                else {
                    return [transformedArray.x, transformedArray.y].concat(coords.splice(2));
                }
            }
            else {
                return [transformedArray.x, transformedArray.y];
            }
        }
        else {
            out = (0, transform_1.default)(from, to, coords, enforceAxis);
            keys = Object.keys(coords);
            if (keys.length === 2) {
                return out;
            }
            keys.forEach(function (key) {
                if ((typeof from.name !== 'undefined' && from.name === 'geocent') || (typeof to.name !== 'undefined' && to.name === 'geocent')) {
                    if (key === 'x' || key === 'y' || key === 'z') {
                        return;
                    }
                }
                else {
                    if (key === 'x' || key === 'y') {
                        return;
                    }
                }
                out[key] = coords[key];
            });
            return out;
        }
    }
    function checkProj(item) {
        if (item instanceof Proj_1.default) {
            return item;
        }
        if (item.oProj) {
            return item.oProj;
        }
        return (0, Proj_1.default)(item);
    }
    function proj4(fromProj, toProj, coord) {
        fromProj = checkProj(fromProj);
        var single = false;
        var obj;
        if (typeof toProj === 'undefined') {
            toProj = fromProj;
            fromProj = wgs84;
            single = true;
        }
        else if (typeof toProj.x !== 'undefined' || Array.isArray(toProj)) {
            coord = toProj;
            toProj = fromProj;
            fromProj = wgs84;
            single = true;
        }
        toProj = checkProj(toProj);
        if (coord) {
            return transformer(fromProj, toProj, coord);
        }
        else {
            obj = {
                forward: function (coords, enforceAxis) {
                    return transformer(fromProj, toProj, coords, enforceAxis);
                },
                inverse: function (coords, enforceAxis) {
                    return transformer(toProj, fromProj, coords, enforceAxis);
                }
            };
            if (single) {
                obj.oProj = toProj;
            }
            return obj;
        }
    }
    exports.default = proj4;
},
/* proj4/lib/Proj.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const parseCode_1 = tslib_1.__importDefault(require(137) /* ./parseCode */);
    const extend_1 = tslib_1.__importDefault(require(148) /* ./extend */);
    const projections_1 = tslib_1.__importDefault(require(149) /* ./projections */);
    const deriveConstants_1 = require(157) /* ./deriveConstants */;
    const Datum_1 = tslib_1.__importDefault(require(159) /* ./constants/Datum */);
    const datum_1 = tslib_1.__importDefault(require(160) /* ./datum */);
    const match_1 = tslib_1.__importDefault(require(144) /* ./match */);
    const nadgrid_1 = require(161) /* ./nadgrid */;
    function Projection(srsCode, callback) {
        if (!(this instanceof Projection)) {
            return new Projection(srsCode);
        }
        callback = callback || function (error) {
            if (error) {
                throw error;
            }
        };
        var json = (0, parseCode_1.default)(srsCode);
        if (typeof json !== 'object') {
            callback(srsCode);
            return;
        }
        var ourProj = Projection.projections.get(json.projName);
        if (!ourProj) {
            callback(srsCode);
            return;
        }
        if (json.datumCode && json.datumCode !== 'none') {
            var datumDef = (0, match_1.default)(Datum_1.default, json.datumCode);
            if (datumDef) {
                json.datum_params = json.datum_params || (datumDef.towgs84 ? datumDef.towgs84.split(',') : null);
                json.ellps = datumDef.ellipse;
                json.datumName = datumDef.datumName ? datumDef.datumName : json.datumCode;
            }
        }
        json.k0 = json.k0 || 1.0;
        json.axis = json.axis || 'enu';
        json.ellps = json.ellps || 'wgs84';
        json.lat1 = json.lat1 || json.lat0; // Lambert_Conformal_Conic_1SP, for example, needs this
        var sphere_ = (0, deriveConstants_1.sphere)(json.a, json.b, json.rf, json.ellps, json.sphere);
        var ecc = (0, deriveConstants_1.eccentricity)(sphere_.a, sphere_.b, sphere_.rf, json.R_A);
        var nadgrids = (0, nadgrid_1.getNadgrids)(json.nadgrids);
        var datumObj = json.datum || (0, datum_1.default)(json.datumCode, json.datum_params, sphere_.a, sphere_.b, ecc.es, ecc.ep2, nadgrids);
        (0, extend_1.default)(this, json); // transfer everything over from the projection because we don't know what we'll need
        (0, extend_1.default)(this, ourProj); // transfer all the methods from the projection
        // copy the 4 things over we calculated in deriveConstants.sphere
        this.a = sphere_.a;
        this.b = sphere_.b;
        this.rf = sphere_.rf;
        this.sphere = sphere_.sphere;
        // copy the 3 things we calculated in deriveConstants.eccentricity
        this.es = ecc.es;
        this.e = ecc.e;
        this.ep2 = ecc.ep2;
        // add in the datum object
        this.datum = datumObj;
        // init the projection
        this.init();
        // legecy callback from back in the day when it went to spatialreference.org
        callback(null, this);
    }
    Projection.projections = projections_1.default;
    Projection.projections.start();
    exports.default = Projection;
},
/* proj4/lib/parseCode.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const defs_1 = tslib_1.__importDefault(require(138) /* ./defs */);
    const wkt_parser_1 = tslib_1.__importDefault(require(145) /* wkt-parser */);
    const projString_1 = tslib_1.__importDefault(require(140) /* ./projString */);
    const match_1 = tslib_1.__importDefault(require(144) /* ./match */);
    function testObj(code) {
        return typeof code === 'string';
    }
    function testDef(code) {
        return code in defs_1.default;
    }
    var codeWords = ['PROJECTEDCRS', 'PROJCRS', 'GEOGCS', 'GEOCCS', 'PROJCS', 'LOCAL_CS', 'GEODCRS', 'GEODETICCRS', 'GEODETICDATUM', 'ENGCRS', 'ENGINEERINGCRS'];
    function testWKT(code) {
        return codeWords.some(function (word) {
            return code.indexOf(word) > -1;
        });
    }
    var codes = ['3857', '900913', '3785', '102113'];
    function checkMercator(item) {
        var auth = (0, match_1.default)(item, 'authority');
        if (!auth) {
            return;
        }
        var code = (0, match_1.default)(auth, 'epsg');
        return code && codes.indexOf(code) > -1;
    }
    function checkProjStr(item) {
        var ext = (0, match_1.default)(item, 'extension');
        if (!ext) {
            return;
        }
        return (0, match_1.default)(ext, 'proj4');
    }
    function testProj(code) {
        return code[0] === '+';
    }
    function parse(code) {
        if (testObj(code)) {
            //check to see if this is a WKT string
            if (testDef(code)) {
                return defs_1.default[code];
            }
            if (testWKT(code)) {
                var out = (0, wkt_parser_1.default)(code);
                // test of spetial case, due to this being a very common and often malformed
                if (checkMercator(out)) {
                    return defs_1.default['EPSG:3857'];
                }
                var maybeProjStr = checkProjStr(out);
                if (maybeProjStr) {
                    return (0, projString_1.default)(maybeProjStr);
                }
                return out;
            }
            if (testProj(code)) {
                return (0, projString_1.default)(code);
            }
        }
        else {
            return code;
        }
    }
    exports.default = parse;
},
/* proj4/lib/defs.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const global_1 = tslib_1.__importDefault(require(139) /* ./global */);
    const projString_1 = tslib_1.__importDefault(require(140) /* ./projString */);
    const wkt_parser_1 = tslib_1.__importDefault(require(145) /* wkt-parser */);
    function defs(name) {
        /*global console*/
        var that = this;
        if (arguments.length === 2) {
            var def = arguments[1];
            if (typeof def === 'string') {
                if (def.charAt(0) === '+') {
                    defs[name] = (0, projString_1.default)(arguments[1]);
                }
                else {
                    defs[name] = (0, wkt_parser_1.default)(arguments[1]);
                }
            }
            else {
                defs[name] = def;
            }
        }
        else if (arguments.length === 1) {
            if (Array.isArray(name)) {
                return name.map(function (v) {
                    if (Array.isArray(v)) {
                        defs.apply(that, v);
                    }
                    else {
                        defs(v);
                    }
                });
            }
            else if (typeof name === 'string') {
                if (name in defs) {
                    return defs[name];
                }
            }
            else if ('EPSG' in name) {
                defs['EPSG:' + name.EPSG] = name;
            }
            else if ('ESRI' in name) {
                defs['ESRI:' + name.ESRI] = name;
            }
            else if ('IAU2000' in name) {
                defs['IAU2000:' + name.IAU2000] = name;
            }
            else {
                console.log(name);
            }
            return;
        }
    }
    (0, global_1.default)(defs);
    exports.default = defs;
},
/* proj4/lib/global.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = default_1;
    function default_1(defs) {
        defs('EPSG:4326', "+title=WGS 84 (long/lat) +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees");
        defs('EPSG:4269', "+title=NAD83 (long/lat) +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees");
        defs('EPSG:3857', "+title=WGS 84 / Pseudo-Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs");
        defs.WGS84 = defs['EPSG:4326'];
        defs['EPSG:3785'] = defs['EPSG:3857']; // maintain backward compat, official code is 3857
        defs.GOOGLE = defs['EPSG:3857'];
        defs['EPSG:900913'] = defs['EPSG:3857'];
        defs['EPSG:102113'] = defs['EPSG:3857'];
    }
},
/* proj4/lib/projString.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = default_1;
    const tslib_1 = require(1) /* tslib */;
    const values_1 = require(141) /* ./constants/values */;
    const PrimeMeridian_1 = tslib_1.__importDefault(require(142) /* ./constants/PrimeMeridian */);
    const units_1 = tslib_1.__importDefault(require(143) /* ./constants/units */);
    const match_1 = tslib_1.__importDefault(require(144) /* ./match */);
    function default_1(defData) {
        var self = {};
        var paramObj = defData.split('+').map(function (v) {
            return v.trim();
        }).filter(function (a) {
            return a;
        }).reduce(function (p, a) {
            var split = a.split('=');
            split.push(true);
            p[split[0].toLowerCase()] = split[1];
            return p;
        }, {});
        var paramName, paramVal, paramOutname;
        var params = {
            proj: 'projName',
            datum: 'datumCode',
            rf: function (v) {
                self.rf = parseFloat(v);
            },
            lat_0: function (v) {
                self.lat0 = v * values_1.D2R;
            },
            lat_1: function (v) {
                self.lat1 = v * values_1.D2R;
            },
            lat_2: function (v) {
                self.lat2 = v * values_1.D2R;
            },
            lat_ts: function (v) {
                self.lat_ts = v * values_1.D2R;
            },
            lon_0: function (v) {
                self.long0 = v * values_1.D2R;
            },
            lon_1: function (v) {
                self.long1 = v * values_1.D2R;
            },
            lon_2: function (v) {
                self.long2 = v * values_1.D2R;
            },
            alpha: function (v) {
                self.alpha = parseFloat(v) * values_1.D2R;
            },
            gamma: function (v) {
                self.rectified_grid_angle = parseFloat(v);
            },
            lonc: function (v) {
                self.longc = v * values_1.D2R;
            },
            x_0: function (v) {
                self.x0 = parseFloat(v);
            },
            y_0: function (v) {
                self.y0 = parseFloat(v);
            },
            k_0: function (v) {
                self.k0 = parseFloat(v);
            },
            k: function (v) {
                self.k0 = parseFloat(v);
            },
            a: function (v) {
                self.a = parseFloat(v);
            },
            b: function (v) {
                self.b = parseFloat(v);
            },
            r: function (v) {
                self.a = self.b = parseFloat(v);
            },
            r_a: function () {
                self.R_A = true;
            },
            zone: function (v) {
                self.zone = parseInt(v, 10);
            },
            south: function () {
                self.utmSouth = true;
            },
            towgs84: function (v) {
                self.datum_params = v.split(",").map(function (a) {
                    return parseFloat(a);
                });
            },
            to_meter: function (v) {
                self.to_meter = parseFloat(v);
            },
            units: function (v) {
                self.units = v;
                var unit = (0, match_1.default)(units_1.default, v);
                if (unit) {
                    self.to_meter = unit.to_meter;
                }
            },
            from_greenwich: function (v) {
                self.from_greenwich = v * values_1.D2R;
            },
            pm: function (v) {
                var pm = (0, match_1.default)(PrimeMeridian_1.default, v);
                self.from_greenwich = (pm ? pm : parseFloat(v)) * values_1.D2R;
            },
            nadgrids: function (v) {
                if (v === '@null') {
                    self.datumCode = 'none';
                }
                else {
                    self.nadgrids = v;
                }
            },
            axis: function (v) {
                var legalAxis = "ewnsud";
                if (v.length === 3 && legalAxis.indexOf(v.substr(0, 1)) !== -1 && legalAxis.indexOf(v.substr(1, 1)) !== -1 && legalAxis.indexOf(v.substr(2, 1)) !== -1) {
                    self.axis = v;
                }
            },
            approx: function () {
                self.approx = true;
            }
        };
        for (paramName in paramObj) {
            paramVal = paramObj[paramName];
            if (paramName in params) {
                paramOutname = params[paramName];
                if (typeof paramOutname === 'function') {
                    paramOutname(paramVal);
                }
                else {
                    self[paramOutname] = paramVal;
                }
            }
            else {
                self[paramName] = paramVal;
            }
        }
        if (typeof self.datumCode === 'string' && self.datumCode !== "WGS84") {
            self.datumCode = self.datumCode.toLowerCase();
        }
        return self;
    }
},
/* proj4/lib/constants/values.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.PJD_3PARAM = 1;
    exports.PJD_7PARAM = 2;
    exports.PJD_GRIDSHIFT = 3;
    exports.PJD_WGS84 = 4; // WGS84 or equivalent
    exports.PJD_NODATUM = 5; // WGS84 or equivalent
    exports.SRS_WGS84_SEMIMAJOR = 6378137.0; // only used in grid shift transforms
    exports.SRS_WGS84_SEMIMINOR = 6356752.314; // only used in grid shift transforms
    exports.SRS_WGS84_ESQUARED = 0.0066943799901413165; // only used in grid shift transforms
    exports.SEC_TO_RAD = 4.84813681109535993589914102357e-6;
    exports.HALF_PI = Math.PI / 2;
    // ellipoid pj_set_ell.c
    exports.SIXTH = 0.1666666666666666667;
    /* 1/6 */
    exports.RA4 = 0.04722222222222222222;
    /* 17/360 */
    exports.RA6 = 0.02215608465608465608;
    exports.EPSLN = 1.0e-10;
    // you'd think you could use Number.EPSILON above but that makes
    // Mollweide get into an infinate loop.
    exports.D2R = 0.01745329251994329577;
    exports.R2D = 57.29577951308232088;
    exports.FORTPI = Math.PI / 4;
    exports.TWO_PI = Math.PI * 2;
    // SPI is slightly greater than Math.PI, so values that exceed the -180..180
    // degree range by a tiny amount don't get wrapped. This prevents points that
    // have drifted from their original location along the 180th meridian (due to
    // floating point error) from changing their sign.
    exports.SPI = 3.14159265359;
},
/* proj4/lib/constants/PrimeMeridian.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var exports$1 = {};
    exports.default = exports$1;
    exports$1.greenwich = 0.0; //"0dE",
    exports$1.lisbon = -9.131906111111; //"9d07'54.862\"W",
    exports$1.paris = 2.337229166667; //"2d20'14.025\"E",
    exports$1.bogota = -74.080916666667; //"74d04'51.3\"W",
    exports$1.madrid = -3.687938888889; //"3d41'16.58\"W",
    exports$1.rome = 12.452333333333; //"12d27'8.4\"E",
    exports$1.bern = 7.439583333333; //"7d26'22.5\"E",
    exports$1.jakarta = 106.807719444444; //"106d48'27.79\"E",
    exports$1.ferro = -17.666666666667; //"17d40'W",
    exports$1.brussels = 4.367975; //"4d22'4.71\"E",
    exports$1.stockholm = 18.058277777778; //"18d3'29.8\"E",
    exports$1.athens = 23.7163375; //"23d42'58.815\"E",
    exports$1.oslo = 10.722916666667; //"10d43'22.5\"E"
},
/* proj4/lib/constants/units.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = {
        ft: { to_meter: 0.3048 },
        'us-ft': { to_meter: 1200 / 3937 }
    };
},
/* proj4/lib/match.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = match;
    var ignoredChar = /[\s_\-\/\(\)]/g;
    function match(obj, key) {
        if (obj[key]) {
            return obj[key];
        }
        var keys = Object.keys(obj);
        var lkey = key.toLowerCase().replace(ignoredChar, '');
        var i = -1;
        var testkey, processedKey;
        while (++i < keys.length) {
            testkey = keys[i];
            processedKey = testkey.toLowerCase().replace(ignoredChar, '');
            if (processedKey === lkey) {
                return obj[testkey];
            }
        }
    }
},
/* wkt-parser/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = default_1;
    const tslib_1 = require(1) /* tslib */;
    var D2R = 0.01745329251994329577;
    const parser_1 = tslib_1.__importDefault(require(146) /* ./parser */);
    const process_1 = require(147) /* ./process */;
    function rename(obj, params) {
        var outName = params[0];
        var inName = params[1];
        if (!(outName in obj) && (inName in obj)) {
            obj[outName] = obj[inName];
            if (params.length === 3) {
                obj[outName] = params[2](obj[outName]);
            }
        }
    }
    function d2r(input) {
        return input * D2R;
    }
    function cleanWKT(wkt) {
        if (wkt.type === 'GEOGCS') {
            wkt.projName = 'longlat';
        }
        else if (wkt.type === 'LOCAL_CS') {
            wkt.projName = 'identity';
            wkt.local = true;
        }
        else {
            if (typeof wkt.PROJECTION === 'object') {
                wkt.projName = Object.keys(wkt.PROJECTION)[0];
            }
            else {
                wkt.projName = wkt.PROJECTION;
            }
        }
        if (wkt.AXIS) {
            var axisOrder = '';
            for (var i = 0, ii = wkt.AXIS.length; i < ii; ++i) {
                var axis = [wkt.AXIS[i][0].toLowerCase(), wkt.AXIS[i][1].toLowerCase()];
                if (axis[0].indexOf('north') !== -1 || ((axis[0] === 'y' || axis[0] === 'lat') && axis[1] === 'north')) {
                    axisOrder += 'n';
                }
                else if (axis[0].indexOf('south') !== -1 || ((axis[0] === 'y' || axis[0] === 'lat') && axis[1] === 'south')) {
                    axisOrder += 's';
                }
                else if (axis[0].indexOf('east') !== -1 || ((axis[0] === 'x' || axis[0] === 'lon') && axis[1] === 'east')) {
                    axisOrder += 'e';
                }
                else if (axis[0].indexOf('west') !== -1 || ((axis[0] === 'x' || axis[0] === 'lon') && axis[1] === 'west')) {
                    axisOrder += 'w';
                }
            }
            if (axisOrder.length === 2) {
                axisOrder += 'u';
            }
            if (axisOrder.length === 3) {
                wkt.axis = axisOrder;
            }
        }
        if (wkt.UNIT) {
            wkt.units = wkt.UNIT.name.toLowerCase();
            if (wkt.units === 'metre') {
                wkt.units = 'meter';
            }
            if (wkt.UNIT.convert) {
                if (wkt.type === 'GEOGCS') {
                    if (wkt.DATUM && wkt.DATUM.SPHEROID) {
                        wkt.to_meter = wkt.UNIT.convert * wkt.DATUM.SPHEROID.a;
                    }
                }
                else {
                    wkt.to_meter = wkt.UNIT.convert;
                }
            }
        }
        var geogcs = wkt.GEOGCS;
        if (wkt.type === 'GEOGCS') {
            geogcs = wkt;
        }
        if (geogcs) {
            //if(wkt.GEOGCS.PRIMEM&&wkt.GEOGCS.PRIMEM.convert){
            //  wkt.from_greenwich=wkt.GEOGCS.PRIMEM.convert*D2R;
            //}
            if (geogcs.DATUM) {
                wkt.datumCode = geogcs.DATUM.name.toLowerCase();
            }
            else {
                wkt.datumCode = geogcs.name.toLowerCase();
            }
            if (wkt.datumCode.slice(0, 2) === 'd_') {
                wkt.datumCode = wkt.datumCode.slice(2);
            }
            if (wkt.datumCode === 'new_zealand_geodetic_datum_1949' || wkt.datumCode === 'new_zealand_1949') {
                wkt.datumCode = 'nzgd49';
            }
            if (wkt.datumCode === 'wgs_1984' || wkt.datumCode === 'world_geodetic_system_1984') {
                if (wkt.PROJECTION === 'Mercator_Auxiliary_Sphere') {
                    wkt.sphere = true;
                }
                wkt.datumCode = 'wgs84';
            }
            if (wkt.datumCode.slice(-6) === '_ferro') {
                wkt.datumCode = wkt.datumCode.slice(0, -6);
            }
            if (wkt.datumCode.slice(-8) === '_jakarta') {
                wkt.datumCode = wkt.datumCode.slice(0, -8);
            }
            if (~wkt.datumCode.indexOf('belge')) {
                wkt.datumCode = 'rnb72';
            }
            if (geogcs.DATUM && geogcs.DATUM.SPHEROID) {
                wkt.ellps = geogcs.DATUM.SPHEROID.name.replace('_19', '').replace(/[Cc]larke\_18/, 'clrk');
                if (wkt.ellps.toLowerCase().slice(0, 13) === 'international') {
                    wkt.ellps = 'intl';
                }
                wkt.a = geogcs.DATUM.SPHEROID.a;
                wkt.rf = parseFloat(geogcs.DATUM.SPHEROID.rf, 10);
            }
            if (geogcs.DATUM && geogcs.DATUM.TOWGS84) {
                wkt.datum_params = geogcs.DATUM.TOWGS84;
            }
            if (~wkt.datumCode.indexOf('osgb_1936')) {
                wkt.datumCode = 'osgb36';
            }
            if (~wkt.datumCode.indexOf('osni_1952')) {
                wkt.datumCode = 'osni52';
            }
            if (~wkt.datumCode.indexOf('tm65')
                || ~wkt.datumCode.indexOf('geodetic_datum_of_1965')) {
                wkt.datumCode = 'ire65';
            }
            if (wkt.datumCode === 'ch1903+') {
                wkt.datumCode = 'ch1903';
            }
            if (~wkt.datumCode.indexOf('israel')) {
                wkt.datumCode = 'isr93';
            }
        }
        if (wkt.b && !isFinite(wkt.b)) {
            wkt.b = wkt.a;
        }
        function toMeter(input) {
            var ratio = wkt.to_meter || 1;
            return input * ratio;
        }
        var renamer = function (a) {
            return rename(wkt, a);
        };
        var list = [
            ['standard_parallel_1', 'Standard_Parallel_1'],
            ['standard_parallel_1', 'Latitude of 1st standard parallel'],
            ['standard_parallel_2', 'Standard_Parallel_2'],
            ['standard_parallel_2', 'Latitude of 2nd standard parallel'],
            ['false_easting', 'False_Easting'],
            ['false_easting', 'False easting'],
            ['false-easting', 'Easting at false origin'],
            ['false_northing', 'False_Northing'],
            ['false_northing', 'False northing'],
            ['false_northing', 'Northing at false origin'],
            ['central_meridian', 'Central_Meridian'],
            ['central_meridian', 'Longitude of natural origin'],
            ['central_meridian', 'Longitude of false origin'],
            ['latitude_of_origin', 'Latitude_Of_Origin'],
            ['latitude_of_origin', 'Central_Parallel'],
            ['latitude_of_origin', 'Latitude of natural origin'],
            ['latitude_of_origin', 'Latitude of false origin'],
            ['scale_factor', 'Scale_Factor'],
            ['k0', 'scale_factor'],
            ['latitude_of_center', 'Latitude_Of_Center'],
            ['latitude_of_center', 'Latitude_of_center'],
            ['lat0', 'latitude_of_center', d2r],
            ['longitude_of_center', 'Longitude_Of_Center'],
            ['longitude_of_center', 'Longitude_of_center'],
            ['longc', 'longitude_of_center', d2r],
            ['x0', 'false_easting', toMeter],
            ['y0', 'false_northing', toMeter],
            ['long0', 'central_meridian', d2r],
            ['lat0', 'latitude_of_origin', d2r],
            ['lat0', 'standard_parallel_1', d2r],
            ['lat1', 'standard_parallel_1', d2r],
            ['lat2', 'standard_parallel_2', d2r],
            ['azimuth', 'Azimuth'],
            ['alpha', 'azimuth', d2r],
            ['srsCode', 'name']
        ];
        list.forEach(renamer);
        if (!wkt.long0 && wkt.longc && (wkt.projName === 'Albers_Conic_Equal_Area' || wkt.projName === 'Lambert_Azimuthal_Equal_Area')) {
            wkt.long0 = wkt.longc;
        }
        if (!wkt.lat_ts && wkt.lat1 && (wkt.projName === 'Stereographic_South_Pole' || wkt.projName === 'Polar Stereographic (variant B)')) {
            wkt.lat0 = d2r(wkt.lat1 > 0 ? 90 : -90);
            wkt.lat_ts = wkt.lat1;
        }
        else if (!wkt.lat_ts && wkt.lat0 && wkt.projName === 'Polar_Stereographic') {
            wkt.lat_ts = wkt.lat0;
            wkt.lat0 = d2r(wkt.lat0 > 0 ? 90 : -90);
        }
    }
    function default_1(wkt) {
        var lisp = (0, parser_1.default)(wkt);
        var type = lisp.shift();
        var name = lisp.shift();
        lisp.unshift(['name', name]);
        lisp.unshift(['type', type]);
        var obj = {};
        (0, process_1.sExpr)(lisp, obj);
        cleanWKT(obj);
        return obj;
    }
},
/* wkt-parser/parser.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = parseString;
    var NEUTRAL = 1;
    var KEYWORD = 2;
    var NUMBER = 3;
    var QUOTED = 4;
    var AFTERQUOTE = 5;
    var ENDED = -1;
    var whitespace = /\s/;
    var latin = /[A-Za-z]/;
    var keyword = /[A-Za-z84_]/;
    var endThings = /[,\]]/;
    var digets = /[\d\.E\-\+]/;
    // const ignoredChar = /[\s_\-\/\(\)]/g;
    function Parser(text) {
        if (typeof text !== 'string') {
            throw new Error('not a string');
        }
        this.text = text.trim();
        this.level = 0;
        this.place = 0;
        this.root = null;
        this.stack = [];
        this.currentObject = null;
        this.state = NEUTRAL;
    }
    Parser.prototype.readCharicter = function () {
        var char = this.text[this.place++];
        if (this.state !== QUOTED) {
            while (whitespace.test(char)) {
                if (this.place >= this.text.length) {
                    return;
                }
                char = this.text[this.place++];
            }
        }
        switch (this.state) {
            case NEUTRAL:
                return this.neutral(char);
            case KEYWORD:
                return this.keyword(char);
            case QUOTED:
                return this.quoted(char);
            case AFTERQUOTE:
                return this.afterquote(char);
            case NUMBER:
                return this.number(char);
            case ENDED:
                return;
        }
    };
    Parser.prototype.afterquote = function (char) {
        if (char === '"') {
            this.word += '"';
            this.state = QUOTED;
            return;
        }
        if (endThings.test(char)) {
            this.word = this.word.trim();
            this.afterItem(char);
            return;
        }
        throw new Error('havn\'t handled "' + char + '" in afterquote yet, index ' + this.place);
    };
    Parser.prototype.afterItem = function (char) {
        if (char === ',') {
            if (this.word !== null) {
                this.currentObject.push(this.word);
            }
            this.word = null;
            this.state = NEUTRAL;
            return;
        }
        if (char === ']') {
            this.level--;
            if (this.word !== null) {
                this.currentObject.push(this.word);
                this.word = null;
            }
            this.state = NEUTRAL;
            this.currentObject = this.stack.pop();
            if (!this.currentObject) {
                this.state = ENDED;
            }
            return;
        }
    };
    Parser.prototype.number = function (char) {
        if (digets.test(char)) {
            this.word += char;
            return;
        }
        if (endThings.test(char)) {
            this.word = parseFloat(this.word);
            this.afterItem(char);
            return;
        }
        throw new Error('havn\'t handled "' + char + '" in number yet, index ' + this.place);
    };
    Parser.prototype.quoted = function (char) {
        if (char === '"') {
            this.state = AFTERQUOTE;
            return;
        }
        this.word += char;
        return;
    };
    Parser.prototype.keyword = function (char) {
        if (keyword.test(char)) {
            this.word += char;
            return;
        }
        if (char === '[') {
            var newObjects = [];
            newObjects.push(this.word);
            this.level++;
            if (this.root === null) {
                this.root = newObjects;
            }
            else {
                this.currentObject.push(newObjects);
            }
            this.stack.push(this.currentObject);
            this.currentObject = newObjects;
            this.state = NEUTRAL;
            return;
        }
        if (endThings.test(char)) {
            this.afterItem(char);
            return;
        }
        throw new Error('havn\'t handled "' + char + '" in keyword yet, index ' + this.place);
    };
    Parser.prototype.neutral = function (char) {
        if (latin.test(char)) {
            this.word = char;
            this.state = KEYWORD;
            return;
        }
        if (char === '"') {
            this.word = '';
            this.state = QUOTED;
            return;
        }
        if (digets.test(char)) {
            this.word = char;
            this.state = NUMBER;
            return;
        }
        if (endThings.test(char)) {
            this.afterItem(char);
            return;
        }
        throw new Error('havn\'t handled "' + char + '" in neutral yet, index ' + this.place);
    };
    Parser.prototype.output = function () {
        while (this.place < this.text.length) {
            this.readCharicter();
        }
        if (this.state === ENDED) {
            return this.root;
        }
        throw new Error('unable to parse string "' + this.text + '". State is ' + this.state);
    };
    function parseString(txt) {
        var parser = new Parser(txt);
        return parser.output();
    }
},
/* wkt-parser/process.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.sExpr = sExpr;
    function mapit(obj, key, value) {
        if (Array.isArray(key)) {
            value.unshift(key);
            key = null;
        }
        var thing = key ? {} : obj;
        var out = value.reduce(function (newObj, item) {
            sExpr(item, newObj);
            return newObj;
        }, thing);
        if (key) {
            obj[key] = out;
        }
    }
    function sExpr(v, obj) {
        if (!Array.isArray(v)) {
            obj[v] = true;
            return;
        }
        var key = v.shift();
        if (key === 'PARAMETER') {
            key = v.shift();
        }
        if (v.length === 1) {
            if (Array.isArray(v[0])) {
                obj[key] = {};
                sExpr(v[0], obj[key]);
                return;
            }
            obj[key] = v[0];
            return;
        }
        if (!v.length) {
            obj[key] = true;
            return;
        }
        if (key === 'TOWGS84') {
            obj[key] = v;
            return;
        }
        if (key === 'AXIS') {
            if (!(key in obj)) {
                obj[key] = [];
            }
            obj[key].push(v);
            return;
        }
        if (!Array.isArray(key)) {
            obj[key] = {};
        }
        var i;
        switch (key) {
            case 'UNIT':
            case 'PRIMEM':
            case 'VERT_DATUM':
                obj[key] = {
                    name: v[0].toLowerCase(),
                    convert: v[1]
                };
                if (v.length === 3) {
                    sExpr(v[2], obj[key]);
                }
                return;
            case 'SPHEROID':
            case 'ELLIPSOID':
                obj[key] = {
                    name: v[0],
                    a: v[1],
                    rf: v[2]
                };
                if (v.length === 4) {
                    sExpr(v[3], obj[key]);
                }
                return;
            case 'PROJECTEDCRS':
            case 'PROJCRS':
            case 'GEOGCS':
            case 'GEOCCS':
            case 'PROJCS':
            case 'LOCAL_CS':
            case 'GEODCRS':
            case 'GEODETICCRS':
            case 'GEODETICDATUM':
            case 'EDATUM':
            case 'ENGINEERINGDATUM':
            case 'VERT_CS':
            case 'VERTCRS':
            case 'VERTICALCRS':
            case 'COMPD_CS':
            case 'COMPOUNDCRS':
            case 'ENGINEERINGCRS':
            case 'ENGCRS':
            case 'FITTED_CS':
            case 'LOCAL_DATUM':
            case 'DATUM':
                v[0] = ['name', v[0]];
                mapit(obj, key, v);
                return;
            default:
                i = -1;
                while (++i < v.length) {
                    if (!Array.isArray(v[i])) {
                        return sExpr(v, obj[key]);
                    }
                }
                return mapit(obj, key, v);
        }
    }
},
/* proj4/lib/extend.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = default_1;
    function default_1(destination, source) {
        destination = destination || {};
        var value, property;
        if (!source) {
            return destination;
        }
        for (property in source) {
            value = source[property];
            if (value !== undefined) {
                destination[property] = value;
            }
        }
        return destination;
    }
},
/* proj4/lib/projections.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.add = add;
    exports.get = get;
    exports.start = start;
    const tslib_1 = require(1) /* tslib */;
    const merc_1 = tslib_1.__importDefault(require(150) /* ./projections/merc */);
    const longlat_1 = tslib_1.__importDefault(require(156) /* ./projections/longlat */);
    var projs = [merc_1.default, longlat_1.default];
    var names = {};
    var projStore = [];
    function add(proj, i) {
        var len = projStore.length;
        if (!proj.names) {
            console.log(i);
            return true;
        }
        projStore[len] = proj;
        proj.names.forEach(function (n) {
            names[n.toLowerCase()] = len;
        });
        return this;
    }
    function get(name) {
        if (!name) {
            return false;
        }
        var n = name.toLowerCase();
        if (typeof names[n] !== 'undefined' && projStore[names[n]]) {
            return projStore[names[n]];
        }
    }
    function start() {
        projs.forEach(add);
    }
    exports.default = {
        start: start,
        add: add,
        get: get
    };
},
/* proj4/lib/projections/merc.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.init = init;
    exports.forward = forward;
    exports.inverse = inverse;
    const tslib_1 = require(1) /* tslib */;
    const msfnz_1 = tslib_1.__importDefault(require(151) /* ../common/msfnz */);
    const adjust_lon_1 = tslib_1.__importDefault(require(152) /* ../common/adjust_lon */);
    const tsfnz_1 = tslib_1.__importDefault(require(154) /* ../common/tsfnz */);
    const phi2z_1 = tslib_1.__importDefault(require(155) /* ../common/phi2z */);
    const values_1 = require(141) /* ../constants/values */;
    function init() {
        var con = this.b / this.a;
        this.es = 1 - con * con;
        if (!('x0' in this)) {
            this.x0 = 0;
        }
        if (!('y0' in this)) {
            this.y0 = 0;
        }
        this.e = Math.sqrt(this.es);
        if (this.lat_ts) {
            if (this.sphere) {
                this.k0 = Math.cos(this.lat_ts);
            }
            else {
                this.k0 = (0, msfnz_1.default)(this.e, Math.sin(this.lat_ts), Math.cos(this.lat_ts));
            }
        }
        else {
            if (!this.k0) {
                if (this.k) {
                    this.k0 = this.k;
                }
                else {
                    this.k0 = 1;
                }
            }
        }
    }
    /* Mercator forward equations--mapping lat,long to x,y
      --------------------------------------------------*/
    function forward(p) {
        var lon = p.x;
        var lat = p.y;
        // convert to radians
        if (lat * values_1.R2D > 90 && lat * values_1.R2D < -90 && lon * values_1.R2D > 180 && lon * values_1.R2D < -180) {
            return null;
        }
        var x, y;
        if (Math.abs(Math.abs(lat) - values_1.HALF_PI) <= values_1.EPSLN) {
            return null;
        }
        else {
            if (this.sphere) {
                x = this.x0 + this.a * this.k0 * (0, adjust_lon_1.default)(lon - this.long0);
                y = this.y0 + this.a * this.k0 * Math.log(Math.tan(values_1.FORTPI + 0.5 * lat));
            }
            else {
                var sinphi = Math.sin(lat);
                var ts = (0, tsfnz_1.default)(this.e, lat, sinphi);
                x = this.x0 + this.a * this.k0 * (0, adjust_lon_1.default)(lon - this.long0);
                y = this.y0 - this.a * this.k0 * Math.log(ts);
            }
            p.x = x;
            p.y = y;
            return p;
        }
    }
    /* Mercator inverse equations--mapping x,y to lat/long
      --------------------------------------------------*/
    function inverse(p) {
        var x = p.x - this.x0;
        var y = p.y - this.y0;
        var lon, lat;
        if (this.sphere) {
            lat = values_1.HALF_PI - 2 * Math.atan(Math.exp(-y / (this.a * this.k0)));
        }
        else {
            var ts = Math.exp(-y / (this.a * this.k0));
            lat = (0, phi2z_1.default)(this.e, ts);
            if (lat === -9999) {
                return null;
            }
        }
        lon = (0, adjust_lon_1.default)(this.long0 + x / (this.a * this.k0));
        p.x = lon;
        p.y = lat;
        return p;
    }
    exports.names = ["Mercator", "Popular Visualisation Pseudo Mercator", "Mercator_1SP", "Mercator_Auxiliary_Sphere", "merc"];
    exports.default = {
        init: init,
        forward: forward,
        inverse: inverse,
        names: exports.names
    };
},
/* proj4/lib/common/msfnz.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = default_1;
    function default_1(eccent, sinphi, cosphi) {
        var con = eccent * sinphi;
        return cosphi / (Math.sqrt(1 - con * con));
    }
},
/* proj4/lib/common/adjust_lon.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = default_1;
    const tslib_1 = require(1) /* tslib */;
    const values_1 = require(141) /* ../constants/values */;
    const sign_1 = tslib_1.__importDefault(require(153) /* ./sign */);
    function default_1(x) {
        return (Math.abs(x) <= values_1.SPI) ? x : (x - ((0, sign_1.default)(x) * values_1.TWO_PI));
    }
},
/* proj4/lib/common/sign.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = default_1;
    function default_1(x) {
        return x < 0 ? -1 : 1;
    }
},
/* proj4/lib/common/tsfnz.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = default_1;
    const values_1 = require(141) /* ../constants/values */;
    function default_1(eccent, phi, sinphi) {
        var con = eccent * sinphi;
        var com = 0.5 * eccent;
        con = Math.pow(((1 - con) / (1 + con)), com);
        return (Math.tan(0.5 * (values_1.HALF_PI - phi)) / con);
    }
},
/* proj4/lib/common/phi2z.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = default_1;
    const values_1 = require(141) /* ../constants/values */;
    function default_1(eccent, ts) {
        var eccnth = 0.5 * eccent;
        var con, dphi;
        var phi = values_1.HALF_PI - 2 * Math.atan(ts);
        for (var i = 0; i <= 15; i++) {
            con = eccent * Math.sin(phi);
            dphi = values_1.HALF_PI - 2 * Math.atan(ts * (Math.pow(((1 - con) / (1 + con)), eccnth))) - phi;
            phi += dphi;
            if (Math.abs(dphi) <= 0.0000000001) {
                return phi;
            }
        }
        //console.log("phi2z has NoConvergence");
        return -9999;
    }
},
/* proj4/lib/projections/longlat.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.init = init;
    exports.forward = identity;
    exports.inverse = identity;
    function init() {
        //no-op for longlat
    }
    function identity(pt) {
        return pt;
    }
    exports.names = ["longlat", "identity"];
    exports.default = {
        init: init,
        forward: identity,
        inverse: identity,
        names: exports.names
    };
},
/* proj4/lib/deriveConstants.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.eccentricity = eccentricity;
    exports.sphere = sphere;
    const tslib_1 = require(1) /* tslib */;
    const values_1 = require(141) /* ./constants/values */;
    const Ellipsoid_1 = tslib_1.__importStar(require(158) /* ./constants/Ellipsoid */);
    const match_1 = tslib_1.__importDefault(require(144) /* ./match */);
    function eccentricity(a, b, rf, R_A) {
        var a2 = a * a; // used in geocentric
        var b2 = b * b; // used in geocentric
        var es = (a2 - b2) / a2; // e ^ 2
        var e = 0;
        if (R_A) {
            a *= 1 - es * (values_1.SIXTH + es * (values_1.RA4 + es * values_1.RA6));
            a2 = a * a;
            es = 0;
        }
        else {
            e = Math.sqrt(es); // eccentricity
        }
        var ep2 = (a2 - b2) / b2; // used in geocentric
        return {
            es: es,
            e: e,
            ep2: ep2
        };
    }
    function sphere(a, b, rf, ellps, sphere) {
        if (!a) { // do we have an ellipsoid?
            var ellipse = (0, match_1.default)(Ellipsoid_1.default, ellps);
            if (!ellipse) {
                ellipse = Ellipsoid_1.WGS84;
            }
            a = ellipse.a;
            b = ellipse.b;
            rf = ellipse.rf;
        }
        if (rf && !b) {
            b = (1.0 - 1.0 / rf) * a;
        }
        if (rf === 0 || Math.abs(a - b) < values_1.EPSLN) {
            sphere = true;
            b = a;
        }
        return {
            a: a,
            b: b,
            rf: rf,
            sphere: sphere
        };
    }
},
/* proj4/lib/constants/Ellipsoid.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var exports$1 = {};
    exports.default = exports$1;
    exports$1.MERIT = {
        a: 6378137.0,
        rf: 298.257,
        ellipseName: "MERIT 1983"
    };
    exports$1.SGS85 = {
        a: 6378136.0,
        rf: 298.257,
        ellipseName: "Soviet Geodetic System 85"
    };
    exports$1.GRS80 = {
        a: 6378137.0,
        rf: 298.257222101,
        ellipseName: "GRS 1980(IUGG, 1980)"
    };
    exports$1.IAU76 = {
        a: 6378140.0,
        rf: 298.257,
        ellipseName: "IAU 1976"
    };
    exports$1.airy = {
        a: 6377563.396,
        b: 6356256.910,
        ellipseName: "Airy 1830"
    };
    exports$1.APL4 = {
        a: 6378137,
        rf: 298.25,
        ellipseName: "Appl. Physics. 1965"
    };
    exports$1.NWL9D = {
        a: 6378145.0,
        rf: 298.25,
        ellipseName: "Naval Weapons Lab., 1965"
    };
    exports$1.mod_airy = {
        a: 6377340.189,
        b: 6356034.446,
        ellipseName: "Modified Airy"
    };
    exports$1.andrae = {
        a: 6377104.43,
        rf: 300.0,
        ellipseName: "Andrae 1876 (Den., Iclnd.)"
    };
    exports$1.aust_SA = {
        a: 6378160.0,
        rf: 298.25,
        ellipseName: "Australian Natl & S. Amer. 1969"
    };
    exports$1.GRS67 = {
        a: 6378160.0,
        rf: 298.2471674270,
        ellipseName: "GRS 67(IUGG 1967)"
    };
    exports$1.bessel = {
        a: 6377397.155,
        rf: 299.1528128,
        ellipseName: "Bessel 1841"
    };
    exports$1.bess_nam = {
        a: 6377483.865,
        rf: 299.1528128,
        ellipseName: "Bessel 1841 (Namibia)"
    };
    exports$1.clrk66 = {
        a: 6378206.4,
        b: 6356583.8,
        ellipseName: "Clarke 1866"
    };
    exports$1.clrk80 = {
        a: 6378249.145,
        rf: 293.4663,
        ellipseName: "Clarke 1880 mod."
    };
    exports$1.clrk80ign = {
        a: 6378249.2,
        b: 6356515,
        rf: 293.4660213,
        ellipseName: "Clarke 1880 (IGN)"
    };
    exports$1.clrk58 = {
        a: 6378293.645208759,
        rf: 294.2606763692654,
        ellipseName: "Clarke 1858"
    };
    exports$1.CPM = {
        a: 6375738.7,
        rf: 334.29,
        ellipseName: "Comm. des Poids et Mesures 1799"
    };
    exports$1.delmbr = {
        a: 6376428.0,
        rf: 311.5,
        ellipseName: "Delambre 1810 (Belgium)"
    };
    exports$1.engelis = {
        a: 6378136.05,
        rf: 298.2566,
        ellipseName: "Engelis 1985"
    };
    exports$1.evrst30 = {
        a: 6377276.345,
        rf: 300.8017,
        ellipseName: "Everest 1830"
    };
    exports$1.evrst48 = {
        a: 6377304.063,
        rf: 300.8017,
        ellipseName: "Everest 1948"
    };
    exports$1.evrst56 = {
        a: 6377301.243,
        rf: 300.8017,
        ellipseName: "Everest 1956"
    };
    exports$1.evrst69 = {
        a: 6377295.664,
        rf: 300.8017,
        ellipseName: "Everest 1969"
    };
    exports$1.evrstSS = {
        a: 6377298.556,
        rf: 300.8017,
        ellipseName: "Everest (Sabah & Sarawak)"
    };
    exports$1.fschr60 = {
        a: 6378166.0,
        rf: 298.3,
        ellipseName: "Fischer (Mercury Datum) 1960"
    };
    exports$1.fschr60m = {
        a: 6378155.0,
        rf: 298.3,
        ellipseName: "Fischer 1960"
    };
    exports$1.fschr68 = {
        a: 6378150.0,
        rf: 298.3,
        ellipseName: "Fischer 1968"
    };
    exports$1.helmert = {
        a: 6378200.0,
        rf: 298.3,
        ellipseName: "Helmert 1906"
    };
    exports$1.hough = {
        a: 6378270.0,
        rf: 297.0,
        ellipseName: "Hough"
    };
    exports$1.intl = {
        a: 6378388.0,
        rf: 297.0,
        ellipseName: "International 1909 (Hayford)"
    };
    exports$1.kaula = {
        a: 6378163.0,
        rf: 298.24,
        ellipseName: "Kaula 1961"
    };
    exports$1.lerch = {
        a: 6378139.0,
        rf: 298.257,
        ellipseName: "Lerch 1979"
    };
    exports$1.mprts = {
        a: 6397300.0,
        rf: 191.0,
        ellipseName: "Maupertius 1738"
    };
    exports$1.new_intl = {
        a: 6378157.5,
        b: 6356772.2,
        ellipseName: "New International 1967"
    };
    exports$1.plessis = {
        a: 6376523.0,
        rf: 6355863.0,
        ellipseName: "Plessis 1817 (France)"
    };
    exports$1.krass = {
        a: 6378245.0,
        rf: 298.3,
        ellipseName: "Krassovsky, 1942"
    };
    exports$1.SEasia = {
        a: 6378155.0,
        b: 6356773.3205,
        ellipseName: "Southeast Asia"
    };
    exports$1.walbeck = {
        a: 6376896.0,
        b: 6355834.8467,
        ellipseName: "Walbeck"
    };
    exports$1.WGS60 = {
        a: 6378165.0,
        rf: 298.3,
        ellipseName: "WGS 60"
    };
    exports$1.WGS66 = {
        a: 6378145.0,
        rf: 298.25,
        ellipseName: "WGS 66"
    };
    exports$1.WGS7 = {
        a: 6378135.0,
        rf: 298.26,
        ellipseName: "WGS 72"
    };
    exports.WGS84 = exports$1.WGS84 = {
        a: 6378137.0,
        rf: 298.257223563,
        ellipseName: "WGS 84"
    };
    exports$1.sphere = {
        a: 6370997.0,
        b: 6370997.0,
        ellipseName: "Normal Sphere (r=6370997)"
    };
},
/* proj4/lib/constants/Datum.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var exports$1 = {};
    exports.default = exports$1;
    exports$1.wgs84 = {
        towgs84: "0,0,0",
        ellipse: "WGS84",
        datumName: "WGS84"
    };
    exports$1.ch1903 = {
        towgs84: "674.374,15.056,405.346",
        ellipse: "bessel",
        datumName: "swiss"
    };
    exports$1.ggrs87 = {
        towgs84: "-199.87,74.79,246.62",
        ellipse: "GRS80",
        datumName: "Greek_Geodetic_Reference_System_1987"
    };
    exports$1.nad83 = {
        towgs84: "0,0,0",
        ellipse: "GRS80",
        datumName: "North_American_Datum_1983"
    };
    exports$1.nad27 = {
        nadgrids: "@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",
        ellipse: "clrk66",
        datumName: "North_American_Datum_1927"
    };
    exports$1.potsdam = {
        towgs84: "598.1,73.7,418.2,0.202,0.045,-2.455,6.7",
        ellipse: "bessel",
        datumName: "Potsdam Rauenberg 1950 DHDN"
    };
    exports$1.carthage = {
        towgs84: "-263.0,6.0,431.0",
        ellipse: "clark80",
        datumName: "Carthage 1934 Tunisia"
    };
    exports$1.hermannskogel = {
        towgs84: "577.326,90.129,463.919,5.137,1.474,5.297,2.4232",
        ellipse: "bessel",
        datumName: "Hermannskogel"
    };
    exports$1.militargeographische_institut = {
        towgs84: "577.326,90.129,463.919,5.137,1.474,5.297,2.4232",
        ellipse: "bessel",
        datumName: "Militar-Geographische Institut"
    };
    exports$1.osni52 = {
        towgs84: "482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",
        ellipse: "airy",
        datumName: "Irish National"
    };
    exports$1.ire65 = {
        towgs84: "482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",
        ellipse: "mod_airy",
        datumName: "Ireland 1965"
    };
    exports$1.rassadiran = {
        towgs84: "-133.63,-157.5,-158.62",
        ellipse: "intl",
        datumName: "Rassadiran"
    };
    exports$1.nzgd49 = {
        towgs84: "59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",
        ellipse: "intl",
        datumName: "New Zealand Geodetic Datum 1949"
    };
    exports$1.osgb36 = {
        towgs84: "446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",
        ellipse: "airy",
        datumName: "Airy 1830"
    };
    exports$1.s_jtsk = {
        towgs84: "589,76,480",
        ellipse: 'bessel',
        datumName: 'S-JTSK (Ferro)'
    };
    exports$1.beduaram = {
        towgs84: '-106,-87,188',
        ellipse: 'clrk80',
        datumName: 'Beduaram'
    };
    exports$1.gunung_segara = {
        towgs84: '-403,684,41',
        ellipse: 'bessel',
        datumName: 'Gunung Segara Jakarta'
    };
    exports$1.rnb72 = {
        towgs84: "106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1",
        ellipse: "intl",
        datumName: "Reseau National Belge 1972"
    };
},
/* proj4/lib/datum.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const values_1 = require(141) /* ./constants/values */;
    function datum(datumCode, datum_params, a, b, es, ep2, nadgrids) {
        var out = {};
        if (datumCode === undefined || datumCode === 'none') {
            out.datum_type = values_1.PJD_NODATUM;
        }
        else {
            out.datum_type = values_1.PJD_WGS84;
        }
        if (datum_params) {
            out.datum_params = datum_params.map(parseFloat);
            if (out.datum_params[0] !== 0 || out.datum_params[1] !== 0 || out.datum_params[2] !== 0) {
                out.datum_type = values_1.PJD_3PARAM;
            }
            if (out.datum_params.length > 3) {
                if (out.datum_params[3] !== 0 || out.datum_params[4] !== 0 || out.datum_params[5] !== 0 || out.datum_params[6] !== 0) {
                    out.datum_type = values_1.PJD_7PARAM;
                    out.datum_params[3] *= values_1.SEC_TO_RAD;
                    out.datum_params[4] *= values_1.SEC_TO_RAD;
                    out.datum_params[5] *= values_1.SEC_TO_RAD;
                    out.datum_params[6] = (out.datum_params[6] / 1000000.0) + 1.0;
                }
            }
        }
        if (nadgrids) {
            out.datum_type = values_1.PJD_GRIDSHIFT;
            out.grids = nadgrids;
        }
        out.a = a; //datum object also uses these values
        out.b = b;
        out.es = es;
        out.ep2 = ep2;
        return out;
    }
    exports.default = datum;
},
/* proj4/lib/nadgrid.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = nadgrid;
    exports.getNadgrids = getNadgrids;
    var loadedNadgrids = {};
    /**
     * Load a binary NTv2 file (.gsb) to a key that can be used in a proj string like +nadgrids=<key>. Pass the NTv2 file
     * as an ArrayBuffer.
     */
    function nadgrid(key, data) {
        var view = new DataView(data);
        var isLittleEndian = detectLittleEndian(view);
        var header = readHeader(view, isLittleEndian);
        var subgrids = readSubgrids(view, header, isLittleEndian);
        var nadgrid = { header: header, subgrids: subgrids };
        loadedNadgrids[key] = nadgrid;
        return nadgrid;
    }
    /**
     * Given a proj4 value for nadgrids, return an array of loaded grids
     */
    function getNadgrids(nadgrids) {
        // Format details: http://proj.maptools.org/gen_parms.html
        if (nadgrids === undefined) {
            return null;
        }
        var grids = nadgrids.split(',');
        return grids.map(parseNadgridString);
    }
    function parseNadgridString(value) {
        if (value.length === 0) {
            return null;
        }
        var optional = value[0] === '@';
        if (optional) {
            value = value.slice(1);
        }
        if (value === 'null') {
            return { name: 'null', mandatory: !optional, grid: null, isNull: true };
        }
        return {
            name: value,
            mandatory: !optional,
            grid: loadedNadgrids[value] || null,
            isNull: false
        };
    }
    function secondsToRadians(seconds) {
        return (seconds / 3600) * Math.PI / 180;
    }
    function detectLittleEndian(view) {
        var nFields = view.getInt32(8, false);
        if (nFields === 11) {
            return false;
        }
        nFields = view.getInt32(8, true);
        if (nFields !== 11) {
            console.warn('Failed to detect nadgrid endian-ness, defaulting to little-endian');
        }
        return true;
    }
    function readHeader(view, isLittleEndian) {
        return {
            nFields: view.getInt32(8, isLittleEndian),
            nSubgridFields: view.getInt32(24, isLittleEndian),
            nSubgrids: view.getInt32(40, isLittleEndian),
            shiftType: decodeString(view, 56, 56 + 8).trim(),
            fromSemiMajorAxis: view.getFloat64(120, isLittleEndian),
            fromSemiMinorAxis: view.getFloat64(136, isLittleEndian),
            toSemiMajorAxis: view.getFloat64(152, isLittleEndian),
            toSemiMinorAxis: view.getFloat64(168, isLittleEndian),
        };
    }
    function decodeString(view, start, end) {
        return String.fromCharCode.apply(null, new Uint8Array(view.buffer.slice(start, end)));
    }
    function readSubgrids(view, header, isLittleEndian) {
        var gridOffset = 176;
        var grids = [];
        for (var i = 0; i < header.nSubgrids; i++) {
            var subHeader = readGridHeader(view, gridOffset, isLittleEndian);
            var nodes = readGridNodes(view, gridOffset, subHeader, isLittleEndian);
            var lngColumnCount = Math.round(1 + (subHeader.upperLongitude - subHeader.lowerLongitude) / subHeader.longitudeInterval);
            var latColumnCount = Math.round(1 + (subHeader.upperLatitude - subHeader.lowerLatitude) / subHeader.latitudeInterval);
            // Proj4 operates on radians whereas the coordinates are in seconds in the grid
            grids.push({
                ll: [secondsToRadians(subHeader.lowerLongitude), secondsToRadians(subHeader.lowerLatitude)],
                del: [secondsToRadians(subHeader.longitudeInterval), secondsToRadians(subHeader.latitudeInterval)],
                lim: [lngColumnCount, latColumnCount],
                count: subHeader.gridNodeCount,
                cvs: mapNodes(nodes)
            });
            gridOffset += 176 + subHeader.gridNodeCount * 16;
        }
        return grids;
    }
    function mapNodes(nodes) {
        return nodes.map(function (r) { return [secondsToRadians(r.longitudeShift), secondsToRadians(r.latitudeShift)]; });
    }
    function readGridHeader(view, offset, isLittleEndian) {
        return {
            name: decodeString(view, offset + 8, offset + 16).trim(),
            parent: decodeString(view, offset + 24, offset + 24 + 8).trim(),
            lowerLatitude: view.getFloat64(offset + 72, isLittleEndian),
            upperLatitude: view.getFloat64(offset + 88, isLittleEndian),
            lowerLongitude: view.getFloat64(offset + 104, isLittleEndian),
            upperLongitude: view.getFloat64(offset + 120, isLittleEndian),
            latitudeInterval: view.getFloat64(offset + 136, isLittleEndian),
            longitudeInterval: view.getFloat64(offset + 152, isLittleEndian),
            gridNodeCount: view.getInt32(offset + 168, isLittleEndian)
        };
    }
    function readGridNodes(view, offset, gridHeader, isLittleEndian) {
        var nodesOffset = offset + 176;
        var gridRecordLength = 16;
        var gridShiftRecords = [];
        for (var i = 0; i < gridHeader.gridNodeCount; i++) {
            var record = {
                latitudeShift: view.getFloat32(nodesOffset + i * gridRecordLength, isLittleEndian),
                longitudeShift: view.getFloat32(nodesOffset + i * gridRecordLength + 4, isLittleEndian),
                latitudeAccuracy: view.getFloat32(nodesOffset + i * gridRecordLength + 8, isLittleEndian),
                longitudeAccuracy: view.getFloat32(nodesOffset + i * gridRecordLength + 12, isLittleEndian),
            };
            gridShiftRecords.push(record);
        }
        return gridShiftRecords;
    }
},
/* proj4/lib/transform.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = transform;
    const tslib_1 = require(1) /* tslib */;
    const values_1 = require(141) /* ./constants/values */;
    const datum_transform_1 = tslib_1.__importDefault(require(163) /* ./datum_transform */);
    const adjust_axis_1 = tslib_1.__importDefault(require(165) /* ./adjust_axis */);
    const Proj_1 = tslib_1.__importDefault(require(136) /* ./Proj */);
    const toPoint_1 = tslib_1.__importDefault(require(166) /* ./common/toPoint */);
    const checkSanity_1 = tslib_1.__importDefault(require(167) /* ./checkSanity */);
    function checkNotWGS(source, dest) {
        return ((source.datum.datum_type === values_1.PJD_3PARAM || source.datum.datum_type === values_1.PJD_7PARAM || source.datum.datum_type === values_1.PJD_GRIDSHIFT) && dest.datumCode !== 'WGS84') ||
            ((dest.datum.datum_type === values_1.PJD_3PARAM || dest.datum.datum_type === values_1.PJD_7PARAM || dest.datum.datum_type === values_1.PJD_GRIDSHIFT) && source.datumCode !== 'WGS84');
    }
    function transform(source, dest, point, enforceAxis) {
        var wgs84;
        if (Array.isArray(point)) {
            point = (0, toPoint_1.default)(point);
        }
        else {
            // Clone the point object so inputs don't get modified
            point = {
                x: point.x,
                y: point.y,
                z: point.z,
                m: point.m
            };
        }
        var hasZ = point.z !== undefined;
        (0, checkSanity_1.default)(point);
        // Workaround for datum shifts towgs84, if either source or destination projection is not wgs84
        if (source.datum && dest.datum && checkNotWGS(source, dest)) {
            wgs84 = new Proj_1.default('WGS84');
            point = transform(source, wgs84, point, enforceAxis);
            source = wgs84;
        }
        // DGR, 2010/11/12
        if (enforceAxis && source.axis !== 'enu') {
            point = (0, adjust_axis_1.default)(source, false, point);
        }
        // Transform source points to long/lat, if they aren't already.
        if (source.projName === 'longlat') {
            point = {
                x: point.x * values_1.D2R,
                y: point.y * values_1.D2R,
                z: point.z || 0
            };
        }
        else {
            if (source.to_meter) {
                point = {
                    x: point.x * source.to_meter,
                    y: point.y * source.to_meter,
                    z: point.z || 0
                };
            }
            point = source.inverse(point); // Convert Cartesian to longlat
            if (!point) {
                return;
            }
        }
        // Adjust for the prime meridian if necessary
        if (source.from_greenwich) {
            point.x += source.from_greenwich;
        }
        // Convert datums if needed, and if possible.
        point = (0, datum_transform_1.default)(source.datum, dest.datum, point);
        if (!point) {
            return;
        }
        // Adjust for the prime meridian if necessary
        if (dest.from_greenwich) {
            point = {
                x: point.x - dest.from_greenwich,
                y: point.y,
                z: point.z || 0
            };
        }
        if (dest.projName === 'longlat') {
            // convert radians to decimal degrees
            point = {
                x: point.x * values_1.R2D,
                y: point.y * values_1.R2D,
                z: point.z || 0
            };
        }
        else { // else project
            point = dest.forward(point);
            if (dest.to_meter) {
                point = {
                    x: point.x / dest.to_meter,
                    y: point.y / dest.to_meter,
                    z: point.z || 0
                };
            }
        }
        // DGR, 2010/11/12
        if (enforceAxis && dest.axis !== 'enu') {
            return (0, adjust_axis_1.default)(dest, true, point);
        }
        if (point && !hasZ) {
            delete point.z;
        }
        return point;
    }
},
/* proj4/lib/datum_transform.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = default_1;
    exports.applyGridShift = applyGridShift;
    const tslib_1 = require(1) /* tslib */;
    const values_1 = require(141) /* ./constants/values */;
    const datumUtils_1 = require(164) /* ./datumUtils */;
    const adjust_lon_1 = tslib_1.__importDefault(require(152) /* ./common/adjust_lon */);
    function checkParams(type) {
        return (type === values_1.PJD_3PARAM || type === values_1.PJD_7PARAM);
    }
    function default_1(source, dest, point) {
        // Short cut if the datums are identical.
        if ((0, datumUtils_1.compareDatums)(source, dest)) {
            return point; // in this case, zero is sucess,
            // whereas cs_compare_datums returns 1 to indicate TRUE
            // confusing, should fix this
        }
        // Explicitly skip datum transform by setting 'datum=none' as parameter for either source or dest
        if (source.datum_type === values_1.PJD_NODATUM || dest.datum_type === values_1.PJD_NODATUM) {
            return point;
        }
        // If this datum requires grid shifts, then apply it to geodetic coordinates.
        var source_a = source.a;
        var source_es = source.es;
        if (source.datum_type === values_1.PJD_GRIDSHIFT) {
            var gridShiftCode = applyGridShift(source, false, point);
            if (gridShiftCode !== 0) {
                return undefined;
            }
            source_a = values_1.SRS_WGS84_SEMIMAJOR;
            source_es = values_1.SRS_WGS84_ESQUARED;
        }
        var dest_a = dest.a;
        var dest_b = dest.b;
        var dest_es = dest.es;
        if (dest.datum_type === values_1.PJD_GRIDSHIFT) {
            dest_a = values_1.SRS_WGS84_SEMIMAJOR;
            dest_b = values_1.SRS_WGS84_SEMIMINOR;
            dest_es = values_1.SRS_WGS84_ESQUARED;
        }
        // Do we need to go through geocentric coordinates?
        if (source_es === dest_es && source_a === dest_a && !checkParams(source.datum_type) && !checkParams(dest.datum_type)) {
            return point;
        }
        // Convert to geocentric coordinates.
        point = (0, datumUtils_1.geodeticToGeocentric)(point, source_es, source_a);
        // Convert between datums
        if (checkParams(source.datum_type)) {
            point = (0, datumUtils_1.geocentricToWgs84)(point, source.datum_type, source.datum_params);
        }
        if (checkParams(dest.datum_type)) {
            point = (0, datumUtils_1.geocentricFromWgs84)(point, dest.datum_type, dest.datum_params);
        }
        point = (0, datumUtils_1.geocentricToGeodetic)(point, dest_es, dest_a, dest_b);
        if (dest.datum_type === values_1.PJD_GRIDSHIFT) {
            var destGridShiftResult = applyGridShift(dest, true, point);
            if (destGridShiftResult !== 0) {
                return undefined;
            }
        }
        return point;
    }
    function applyGridShift(source, inverse, point) {
        if (source.grids === null || source.grids.length === 0) {
            console.log('Grid shift grids not found');
            return -1;
        }
        var input = { x: -point.x, y: point.y };
        var output = { x: Number.NaN, y: Number.NaN };
        var onlyMandatoryGrids = false;
        var attemptedGrids = [];
        outer: for (var i = 0; i < source.grids.length; i++) {
            var grid = source.grids[i];
            attemptedGrids.push(grid.name);
            if (grid.isNull) {
                output = input;
                break;
            }
            onlyMandatoryGrids = grid.mandatory;
            if (grid.grid === null) {
                if (grid.mandatory) {
                    console.log("Unable to find mandatory grid '" + grid.name + "'");
                    return -1;
                }
                continue;
            }
            var subgrids = grid.grid.subgrids;
            for (var j = 0, jj = subgrids.length; j < jj; j++) {
                var subgrid = subgrids[j];
                // skip tables that don't match our point at all
                var epsilon = (Math.abs(subgrid.del[1]) + Math.abs(subgrid.del[0])) / 10000.0;
                var minX = subgrid.ll[0] - epsilon;
                var minY = subgrid.ll[1] - epsilon;
                var maxX = subgrid.ll[0] + (subgrid.lim[0] - 1) * subgrid.del[0] + epsilon;
                var maxY = subgrid.ll[1] + (subgrid.lim[1] - 1) * subgrid.del[1] + epsilon;
                if (minY > input.y || minX > input.x || maxY < input.y || maxX < input.x) {
                    continue;
                }
                output = applySubgridShift(input, inverse, subgrid);
                if (!isNaN(output.x)) {
                    break outer;
                }
            }
        }
        if (isNaN(output.x)) {
            console.log("Failed to find a grid shift table for location '" +
                -input.x * values_1.R2D + " " + input.y * values_1.R2D + " tried: '" + attemptedGrids + "'");
            return -1;
        }
        point.x = -output.x;
        point.y = output.y;
        return 0;
    }
    function applySubgridShift(pin, inverse, ct) {
        var val = { x: Number.NaN, y: Number.NaN };
        if (isNaN(pin.x)) {
            return val;
        }
        var tb = { x: pin.x, y: pin.y };
        tb.x -= ct.ll[0];
        tb.y -= ct.ll[1];
        tb.x = (0, adjust_lon_1.default)(tb.x - Math.PI) + Math.PI;
        var t = nadInterpolate(tb, ct);
        if (inverse) {
            if (isNaN(t.x)) {
                return val;
            }
            t.x = tb.x - t.x;
            t.y = tb.y - t.y;
            var i = 9, tol = 1e-12;
            var dif, del;
            do {
                del = nadInterpolate(t, ct);
                if (isNaN(del.x)) {
                    console.log("Inverse grid shift iteration failed, presumably at grid edge.  Using first approximation.");
                    break;
                }
                dif = { x: tb.x - (del.x + t.x), y: tb.y - (del.y + t.y) };
                t.x += dif.x;
                t.y += dif.y;
            } while (i-- && Math.abs(dif.x) > tol && Math.abs(dif.y) > tol);
            if (i < 0) {
                console.log("Inverse grid shift iterator failed to converge.");
                return val;
            }
            val.x = (0, adjust_lon_1.default)(t.x + ct.ll[0]);
            val.y = t.y + ct.ll[1];
        }
        else {
            if (!isNaN(t.x)) {
                val.x = pin.x + t.x;
                val.y = pin.y + t.y;
            }
        }
        return val;
    }
    function nadInterpolate(pin, ct) {
        var t = { x: pin.x / ct.del[0], y: pin.y / ct.del[1] };
        var indx = { x: Math.floor(t.x), y: Math.floor(t.y) };
        var frct = { x: t.x - 1.0 * indx.x, y: t.y - 1.0 * indx.y };
        var val = { x: Number.NaN, y: Number.NaN };
        var inx;
        if (indx.x < 0 || indx.x >= ct.lim[0]) {
            return val;
        }
        if (indx.y < 0 || indx.y >= ct.lim[1]) {
            return val;
        }
        inx = (indx.y * ct.lim[0]) + indx.x;
        var f00 = { x: ct.cvs[inx][0], y: ct.cvs[inx][1] };
        inx++;
        var f10 = { x: ct.cvs[inx][0], y: ct.cvs[inx][1] };
        inx += ct.lim[0];
        var f11 = { x: ct.cvs[inx][0], y: ct.cvs[inx][1] };
        inx--;
        var f01 = { x: ct.cvs[inx][0], y: ct.cvs[inx][1] };
        var m11 = frct.x * frct.y, m10 = frct.x * (1.0 - frct.y), m00 = (1.0 - frct.x) * (1.0 - frct.y), m01 = (1.0 - frct.x) * frct.y;
        val.x = (m00 * f00.x + m10 * f10.x + m01 * f01.x + m11 * f11.x);
        val.y = (m00 * f00.y + m10 * f10.y + m01 * f01.y + m11 * f11.y);
        return val;
    }
},
/* proj4/lib/datumUtils.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.compareDatums = compareDatums;
    exports.geodeticToGeocentric = geodeticToGeocentric;
    exports.geocentricToGeodetic = geocentricToGeodetic;
    exports.geocentricToWgs84 = geocentricToWgs84;
    exports.geocentricFromWgs84 = geocentricFromWgs84;
    const values_1 = require(141) /* ./constants/values */;
    function compareDatums(source, dest) {
        if (source.datum_type !== dest.datum_type) {
            return false; // false, datums are not equal
        }
        else if (source.a !== dest.a || Math.abs(source.es - dest.es) > 0.000000000050) {
            // the tolerance for es is to ensure that GRS80 and WGS84
            // are considered identical
            return false;
        }
        else if (source.datum_type === values_1.PJD_3PARAM) {
            return (source.datum_params[0] === dest.datum_params[0] && source.datum_params[1] === dest.datum_params[1] && source.datum_params[2] === dest.datum_params[2]);
        }
        else if (source.datum_type === values_1.PJD_7PARAM) {
            return (source.datum_params[0] === dest.datum_params[0] && source.datum_params[1] === dest.datum_params[1] && source.datum_params[2] === dest.datum_params[2] && source.datum_params[3] === dest.datum_params[3] && source.datum_params[4] === dest.datum_params[4] && source.datum_params[5] === dest.datum_params[5] && source.datum_params[6] === dest.datum_params[6]);
        }
        else {
            return true; // datums are equal
        }
    } // cs_compare_datums()
    /*
     * The function Convert_Geodetic_To_Geocentric converts geodetic coordinates
     * (latitude, longitude, and height) to geocentric coordinates (X, Y, Z),
     * according to the current ellipsoid parameters.
     *
     *    Latitude  : Geodetic latitude in radians                     (input)
     *    Longitude : Geodetic longitude in radians                    (input)
     *    Height    : Geodetic height, in meters                       (input)
     *    X         : Calculated Geocentric X coordinate, in meters    (output)
     *    Y         : Calculated Geocentric Y coordinate, in meters    (output)
     *    Z         : Calculated Geocentric Z coordinate, in meters    (output)
     *
     */
    function geodeticToGeocentric(p, es, a) {
        var Longitude = p.x;
        var Latitude = p.y;
        var Height = p.z ? p.z : 0; //Z value not always supplied
        var Rn; /*  Earth radius at location  */
        var Sin_Lat; /*  Math.sin(Latitude)  */
        var Sin2_Lat; /*  Square of Math.sin(Latitude)  */
        var Cos_Lat; /*  Math.cos(Latitude)  */
        /*
         ** Don't blow up if Latitude is just a little out of the value
         ** range as it may just be a rounding issue.  Also removed longitude
         ** test, it should be wrapped by Math.cos() and Math.sin().  NFW for PROJ.4, Sep/2001.
         */
        if (Latitude < -values_1.HALF_PI && Latitude > -1.001 * values_1.HALF_PI) {
            Latitude = -values_1.HALF_PI;
        }
        else if (Latitude > values_1.HALF_PI && Latitude < 1.001 * values_1.HALF_PI) {
            Latitude = values_1.HALF_PI;
        }
        else if (Latitude < -values_1.HALF_PI) {
            /* Latitude out of range */
            //..reportError('geocent:lat out of range:' + Latitude);
            return { x: -Infinity, y: -Infinity, z: p.z };
        }
        else if (Latitude > values_1.HALF_PI) {
            /* Latitude out of range */
            return { x: Infinity, y: Infinity, z: p.z };
        }
        if (Longitude > Math.PI) {
            Longitude -= (2 * Math.PI);
        }
        Sin_Lat = Math.sin(Latitude);
        Cos_Lat = Math.cos(Latitude);
        Sin2_Lat = Sin_Lat * Sin_Lat;
        Rn = a / (Math.sqrt(1.0e0 - es * Sin2_Lat));
        return {
            x: (Rn + Height) * Cos_Lat * Math.cos(Longitude),
            y: (Rn + Height) * Cos_Lat * Math.sin(Longitude),
            z: ((Rn * (1 - es)) + Height) * Sin_Lat
        };
    } // cs_geodetic_to_geocentric()
    function geocentricToGeodetic(p, es, a, b) {
        /* local defintions and variables */
        /* end-criterium of loop, accuracy of sin(Latitude) */
        var genau = 1e-12;
        var genau2 = (genau * genau);
        var maxiter = 30;
        var P; /* distance between semi-minor axis and location */
        var RR; /* distance between center and location */
        var CT; /* sin of geocentric latitude */
        var ST; /* cos of geocentric latitude */
        var RX;
        var RK;
        var RN; /* Earth radius at location */
        var CPHI0; /* cos of start or old geodetic latitude in iterations */
        var SPHI0; /* sin of start or old geodetic latitude in iterations */
        var CPHI; /* cos of searched geodetic latitude */
        var SPHI; /* sin of searched geodetic latitude */
        var SDPHI; /* end-criterium: addition-theorem of sin(Latitude(iter)-Latitude(iter-1)) */
        var iter; /* # of continous iteration, max. 30 is always enough (s.a.) */
        var X = p.x;
        var Y = p.y;
        var Z = p.z ? p.z : 0.0; //Z value not always supplied
        var Longitude;
        var Latitude;
        var Height;
        P = Math.sqrt(X * X + Y * Y);
        RR = Math.sqrt(X * X + Y * Y + Z * Z);
        /*      special cases for latitude and longitude */
        if (P / a < genau) {
            /*  special case, if P=0. (X=0., Y=0.) */
            Longitude = 0.0;
            /*  if (X,Y,Z)=(0.,0.,0.) then Height becomes semi-minor axis
             *  of ellipsoid (=center of mass), Latitude becomes PI/2 */
            if (RR / a < genau) {
                Latitude = values_1.HALF_PI;
                Height = -b;
                return {
                    x: p.x,
                    y: p.y,
                    z: p.z
                };
            }
        }
        else {
            /*  ellipsoidal (geodetic) longitude
             *  interval: -PI < Longitude <= +PI */
            Longitude = Math.atan2(Y, X);
        }
        /* --------------------------------------------------------------
         * Following iterative algorithm was developped by
         * "Institut for Erdmessung", University of Hannover, July 1988.
         * Internet: www.ife.uni-hannover.de
         * Iterative computation of CPHI,SPHI and Height.
         * Iteration of CPHI and SPHI to 10**-12 radian resp.
         * 2*10**-7 arcsec.
         * --------------------------------------------------------------
         */
        CT = Z / RR;
        ST = P / RR;
        RX = 1.0 / Math.sqrt(1.0 - es * (2.0 - es) * ST * ST);
        CPHI0 = ST * (1.0 - es) * RX;
        SPHI0 = CT * RX;
        iter = 0;
        /* loop to find sin(Latitude) resp. Latitude
         * until |sin(Latitude(iter)-Latitude(iter-1))| < genau */
        do {
            iter++;
            RN = a / Math.sqrt(1.0 - es * SPHI0 * SPHI0);
            /*  ellipsoidal (geodetic) height */
            Height = P * CPHI0 + Z * SPHI0 - RN * (1.0 - es * SPHI0 * SPHI0);
            RK = es * RN / (RN + Height);
            RX = 1.0 / Math.sqrt(1.0 - RK * (2.0 - RK) * ST * ST);
            CPHI = ST * (1.0 - RK) * RX;
            SPHI = CT * RX;
            SDPHI = SPHI * CPHI0 - CPHI * SPHI0;
            CPHI0 = CPHI;
            SPHI0 = SPHI;
        } while (SDPHI * SDPHI > genau2 && iter < maxiter);
        /*      ellipsoidal (geodetic) latitude */
        Latitude = Math.atan(SPHI / Math.abs(CPHI));
        return {
            x: Longitude,
            y: Latitude,
            z: Height
        };
    } // cs_geocentric_to_geodetic()
    /****************************************************************/
    // pj_geocentic_to_wgs84( p )
    //  p = point to transform in geocentric coordinates (x,y,z)
    /** point object, nothing fancy, just allows values to be
        passed back and forth by reference rather than by value.
        Other point classes may be used as long as they have
        x and y properties, which will get modified in the transform method.
    */
    function geocentricToWgs84(p, datum_type, datum_params) {
        if (datum_type === values_1.PJD_3PARAM) {
            // if( x[io] === HUGE_VAL )
            //    continue;
            return {
                x: p.x + datum_params[0],
                y: p.y + datum_params[1],
                z: p.z + datum_params[2],
            };
        }
        else if (datum_type === values_1.PJD_7PARAM) {
            var Dx_BF = datum_params[0];
            var Dy_BF = datum_params[1];
            var Dz_BF = datum_params[2];
            var Rx_BF = datum_params[3];
            var Ry_BF = datum_params[4];
            var Rz_BF = datum_params[5];
            var M_BF = datum_params[6];
            // if( x[io] === HUGE_VAL )
            //    continue;
            return {
                x: M_BF * (p.x - Rz_BF * p.y + Ry_BF * p.z) + Dx_BF,
                y: M_BF * (Rz_BF * p.x + p.y - Rx_BF * p.z) + Dy_BF,
                z: M_BF * (-Ry_BF * p.x + Rx_BF * p.y + p.z) + Dz_BF
            };
        }
    } // cs_geocentric_to_wgs84
    /****************************************************************/
    // pj_geocentic_from_wgs84()
    //  coordinate system definition,
    //  point to transform in geocentric coordinates (x,y,z)
    function geocentricFromWgs84(p, datum_type, datum_params) {
        if (datum_type === values_1.PJD_3PARAM) {
            //if( x[io] === HUGE_VAL )
            //    continue;
            return {
                x: p.x - datum_params[0],
                y: p.y - datum_params[1],
                z: p.z - datum_params[2],
            };
        }
        else if (datum_type === values_1.PJD_7PARAM) {
            var Dx_BF = datum_params[0];
            var Dy_BF = datum_params[1];
            var Dz_BF = datum_params[2];
            var Rx_BF = datum_params[3];
            var Ry_BF = datum_params[4];
            var Rz_BF = datum_params[5];
            var M_BF = datum_params[6];
            var x_tmp = (p.x - Dx_BF) / M_BF;
            var y_tmp = (p.y - Dy_BF) / M_BF;
            var z_tmp = (p.z - Dz_BF) / M_BF;
            //if( x[io] === HUGE_VAL )
            //    continue;
            return {
                x: x_tmp + Rz_BF * y_tmp - Ry_BF * z_tmp,
                y: -Rz_BF * x_tmp + y_tmp + Rx_BF * z_tmp,
                z: Ry_BF * x_tmp - Rx_BF * y_tmp + z_tmp
            };
        } //cs_geocentric_from_wgs84()
    }
},
/* proj4/lib/adjust_axis.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = default_1;
    function default_1(crs, denorm, point) {
        var xin = point.x, yin = point.y, zin = point.z || 0.0;
        var v, t, i;
        var out = {};
        for (i = 0; i < 3; i++) {
            if (denorm && i === 2 && point.z === undefined) {
                continue;
            }
            if (i === 0) {
                v = xin;
                if ("ew".indexOf(crs.axis[i]) !== -1) {
                    t = 'x';
                }
                else {
                    t = 'y';
                }
            }
            else if (i === 1) {
                v = yin;
                if ("ns".indexOf(crs.axis[i]) !== -1) {
                    t = 'y';
                }
                else {
                    t = 'x';
                }
            }
            else {
                v = zin;
                t = 'z';
            }
            switch (crs.axis[i]) {
                case 'e':
                    out[t] = v;
                    break;
                case 'w':
                    out[t] = -v;
                    break;
                case 'n':
                    out[t] = v;
                    break;
                case 's':
                    out[t] = -v;
                    break;
                case 'u':
                    if (point[t] !== undefined) {
                        out.z = v;
                    }
                    break;
                case 'd':
                    if (point[t] !== undefined) {
                        out.z = -v;
                    }
                    break;
                default:
                    //console.log("ERROR: unknow axis ("+crs.axis[i]+") - check definition of "+crs.projName);
                    return null;
            }
        }
        return out;
    }
},
/* proj4/lib/common/toPoint.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = default_1;
    function default_1(array) {
        var out = {
            x: array[0],
            y: array[1]
        };
        if (array.length > 2) {
            out.z = array[2];
        }
        if (array.length > 3) {
            out.m = array[3];
        }
        return out;
    }
},
/* proj4/lib/checkSanity.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = default_1;
    function default_1(point) {
        checkCoord(point.x);
        checkCoord(point.y);
    }
    function checkCoord(num) {
        if (typeof Number.isFinite === 'function') {
            if (Number.isFinite(num)) {
                return;
            }
            throw new TypeError('coordinates must be finite numbers');
        }
        if (typeof num !== 'number' || num !== num || !isFinite(num)) {
            throw new TypeError('coordinates must be finite numbers');
        }
    }
},
/* models/annotations/arrow_head.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a, _b, _c, _d, _e;
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const marking_1 = require(169) /* ../graphics/marking */;
    const property_mixins_1 = require(80) /* ../../core/property_mixins */;
    const p = tslib_1.__importStar(require(19) /* ../../core/properties */);
    class ArrowHeadView extends marking_1.MarkingView {
    }
    exports.ArrowHeadView = ArrowHeadView;
    ArrowHeadView.__name__ = "ArrowHeadView";
    class ArrowHead extends marking_1.Marking {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.ArrowHead = ArrowHead;
    _a = ArrowHead;
    ArrowHead.__name__ = "ArrowHead";
    (() => {
        _a.define(() => ({
            size: [p.NumberSpec, 25],
        }));
    })();
    class OpenHeadView extends ArrowHeadView {
        clip(ctx, i) {
            this.visuals.line.set_vectorize(ctx, i);
            const size_i = this.size.get(i);
            ctx.moveTo(0.5 * size_i, size_i);
            ctx.lineTo(0.5 * size_i, -2);
            ctx.lineTo(-0.5 * size_i, -2);
            ctx.lineTo(-0.5 * size_i, size_i);
            ctx.lineTo(0, 0);
            ctx.lineTo(0.5 * size_i, size_i);
        }
        paint(ctx, i) {
            const size_i = this.size.get(i);
            ctx.beginPath();
            ctx.moveTo(0.5 * size_i, size_i);
            ctx.lineTo(0, 0);
            ctx.lineTo(-0.5 * size_i, size_i);
            this.visuals.line.apply(ctx, i);
        }
    }
    exports.OpenHeadView = OpenHeadView;
    OpenHeadView.__name__ = "OpenHeadView";
    class OpenHead extends ArrowHead {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.OpenHead = OpenHead;
    _b = OpenHead;
    OpenHead.__name__ = "OpenHead";
    (() => {
        _b.prototype.default_view = OpenHeadView;
        _b.mixins(property_mixins_1.LineVector);
    })();
    class NormalHeadView extends ArrowHeadView {
        clip(ctx, i) {
            this.visuals.line.set_vectorize(ctx, i);
            const size_i = this.size.get(i);
            ctx.moveTo(0.5 * size_i, size_i);
            ctx.lineTo(0.5 * size_i, -2);
            ctx.lineTo(-0.5 * size_i, -2);
            ctx.lineTo(-0.5 * size_i, size_i);
            ctx.lineTo(0.5 * size_i, size_i);
        }
        paint(ctx, i) {
            const size_i = this.size.get(i);
            ctx.beginPath();
            ctx.moveTo(0.5 * size_i, size_i);
            ctx.lineTo(0, 0);
            ctx.lineTo(-0.5 * size_i, size_i);
            ctx.closePath();
            this.visuals.fill.apply(ctx, i);
            this.visuals.hatch.apply(ctx, i);
            this.visuals.line.apply(ctx, i);
        }
    }
    exports.NormalHeadView = NormalHeadView;
    NormalHeadView.__name__ = "NormalHeadView";
    class NormalHead extends ArrowHead {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.NormalHead = NormalHead;
    _c = NormalHead;
    NormalHead.__name__ = "NormalHead";
    (() => {
        _c.prototype.default_view = NormalHeadView;
        _c.mixins([property_mixins_1.LineVector, property_mixins_1.FillVector, property_mixins_1.HatchVector]);
        _c.override({
            fill_color: "black",
        });
    })();
    class VeeHeadView extends ArrowHeadView {
        clip(ctx, i) {
            this.visuals.line.set_vectorize(ctx, i);
            const size_i = this.size.get(i);
            ctx.moveTo(0.5 * size_i, size_i);
            ctx.lineTo(0.5 * size_i, -2);
            ctx.lineTo(-0.5 * size_i, -2);
            ctx.lineTo(-0.5 * size_i, size_i);
            ctx.lineTo(0, 0.5 * size_i);
            ctx.lineTo(0.5 * size_i, size_i);
        }
        paint(ctx, i) {
            const size_i = this.size.get(i);
            ctx.beginPath();
            ctx.moveTo(0.5 * size_i, size_i);
            ctx.lineTo(0, 0);
            ctx.lineTo(-0.5 * size_i, size_i);
            ctx.lineTo(0, 0.5 * size_i);
            ctx.closePath();
            this.visuals.fill.apply(ctx, i);
            this.visuals.hatch.apply(ctx, i);
            this.visuals.line.apply(ctx, i);
        }
    }
    exports.VeeHeadView = VeeHeadView;
    VeeHeadView.__name__ = "VeeHeadView";
    class VeeHead extends ArrowHead {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.VeeHead = VeeHead;
    _d = VeeHead;
    VeeHead.__name__ = "VeeHead";
    (() => {
        _d.prototype.default_view = VeeHeadView;
        _d.mixins([property_mixins_1.LineVector, property_mixins_1.FillVector, property_mixins_1.HatchVector]);
        _d.override({
            fill_color: "black",
        });
    })();
    class TeeHeadView extends ArrowHeadView {
        paint(ctx, i) {
            const size_i = this.size.get(i);
            ctx.beginPath();
            ctx.moveTo(0.5 * size_i, 0);
            ctx.lineTo(-0.5 * size_i, 0);
            this.visuals.line.apply(ctx, i);
        }
        clip(_ctx, _i) { }
    }
    exports.TeeHeadView = TeeHeadView;
    TeeHeadView.__name__ = "TeeHeadView";
    class TeeHead extends ArrowHead {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.TeeHead = TeeHead;
    _e = TeeHead;
    TeeHead.__name__ = "TeeHead";
    (() => {
        _e.prototype.default_view = TeeHeadView;
        _e.mixins(property_mixins_1.LineVector);
    })();
},
/* models/graphics/marking.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const model_1 = require(51) /* ../../model */;
    const dom_view_1 = require(57) /* ../../core/dom_view */;
    const visuals = tslib_1.__importStar(require(87) /* ../../core/visuals */);
    const p = tslib_1.__importStar(require(19) /* ../../core/properties */);
    class MarkingView extends dom_view_1.DOMComponentView {
        initialize() {
            super.initialize();
            this.visuals = new visuals.Visuals(this);
        }
        request_paint() {
            this.parent.request_paint();
        }
        get canvas() {
            return this.parent.canvas;
        }
        set_data(source, indices) {
            const self = this;
            for (const prop of this.model) {
                if (!(prop instanceof p.VectorSpec || prop instanceof p.ScalarSpec)) {
                    continue;
                }
                const uniform = prop.uniform(source).select(indices);
                self[`${prop.attr}`] = uniform;
            }
        }
    }
    exports.MarkingView = MarkingView;
    MarkingView.__name__ = "MarkingView";
    class Marking extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Marking = Marking;
    _a = Marking;
    Marking.__name__ = "Marking";
    (() => {
        _a.define(({}) => ({}));
    })();
},
/* models/annotations/base_color_bar.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const annotation_1 = require(81) /* ./annotation */;
    const title_1 = require(171) /* ./title */;
    const cartesian_frame_1 = require(186) /* ../canvas/cartesian_frame */;
    const axis_1 = require(189) /* ../axes/axis */;
    const linear_axis_1 = require(194) /* ../axes/linear_axis */;
    const ticker_1 = require(191) /* ../tickers/ticker */;
    const tickers_1 = require(200) /* ../tickers */;
    const tick_formatter_1 = require(192) /* ../formatters/tick_formatter */;
    const formatters_1 = require(242) /* ../formatters */;
    const labeling_1 = require(193) /* ../policies/labeling */;
    const scales_1 = require(254) /* ../scales */;
    const ranges_1 = require(256) /* ../ranges */;
    const base_text_1 = require(176) /* ../text/base_text */;
    const enums_1 = require(21) /* ../../core/enums */;
    const mixins = tslib_1.__importStar(require(80) /* ../../core/property_mixins */);
    const layout_1 = require(257) /* ../../core/layout */;
    const alignments_1 = require(258) /* ../../core/layout/alignments */;
    const border_1 = require(260) /* ../../core/layout/border */;
    const side_panel_1 = require(173) /* ../../core/layout/side_panel */;
    const build_views_1 = require(56) /* ../../core/build_views */;
    const bbox_1 = require(64) /* ../../core/util/bbox */;
    const types_1 = require(8) /* ../../core/util/types */;
    const MINOR_DIM = 25;
    const MAJOR_DIM_MIN_SCALAR = 0.3;
    const MAJOR_DIM_MAX_SCALAR = 0.8;
    class BaseColorBarView extends annotation_1.AnnotationView {
        get orientation() {
            return this._orientation;
        }
        *children() {
            yield* super.children();
            yield this._axis_view;
            yield this._title_view;
        }
        initialize() {
            super.initialize();
            const { ticker, formatter } = this.model;
            this._ticker = ticker != "auto" ? ticker : this._create_ticker();
            this._formatter = formatter != "auto" ? formatter : this._create_formatter();
            this._major_range = this._create_major_range();
            this._major_scale = this._create_major_scale();
            this._minor_range = new ranges_1.Range1d({ start: 0, end: 1 });
            this._minor_scale = new scales_1.LinearScale();
            // configure some frame, update when the layout is known
            this._frame = new cartesian_frame_1.CartesianFrame({
                x_scale: this._major_scale,
                y_scale: this._minor_scale,
                x_range: this._major_range,
                y_range: this._minor_range,
            });
            this._axis = this._create_axis();
            this._apply_axis_properties();
            this._title = new title_1.Title();
            this._apply_title_properties();
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            const self = this;
            const parent = {
                get parent() {
                    return self.parent;
                },
                get root() {
                    return self.root;
                },
                get frame() {
                    return self._frame_view;
                },
                get frame_view() {
                    return self._frame_view;
                },
                get canvas_view() {
                    return self.parent.canvas_view;
                },
                request_layout() {
                    // force re-layout; not ideal but ColorBar's layout doesn't fully
                    // participate in has_size_changed to detect if layout is needed
                    self.layout.dirty = true;
                    self.parent.request_layout();
                },
                request_paint() {
                    self.parent.request_paint(self);
                },
                notify_finished_after_paint() {
                    self.parent.notify_finished_after_paint();
                },
            };
            this._frame_view = await (0, build_views_1.build_view)(this._frame, { parent });
            this._axis_view = await (0, build_views_1.build_view)(this._axis, { parent });
            this._title_view = await (0, build_views_1.build_view)(this._title, { parent });
        }
        remove() {
            this._title_view.remove();
            this._axis_view.remove();
            super.remove();
        }
        _apply_axis_properties() {
            const attrs = {
                ticker: this._ticker,
                formatter: this._formatter,
                major_label_standoff: this.model.label_standoff,
                axis_line_color: null,
                major_tick_in: this.model.major_tick_in,
                major_tick_out: this.model.major_tick_out,
                minor_tick_in: this.model.minor_tick_in,
                minor_tick_out: this.model.minor_tick_out,
                major_label_overrides: this.model.major_label_overrides,
                major_label_policy: this.model.major_label_policy,
                // TODO: this needs strict typing
                ...mixins.attrs_of(this.model, "major_label_", mixins.Text, true),
                ...mixins.attrs_of(this.model, "major_tick_", mixins.Line, true),
                ...mixins.attrs_of(this.model, "minor_tick_", mixins.Line, true),
            };
            this._axis.setv(attrs);
        }
        _apply_title_properties() {
            const attrs = {
                text: this.model.title ?? "",
                standoff: this.model.title_standoff,
                // TODO: this needs strict typing
                ...mixins.attrs_of(this.model, "title_", mixins.Text, false),
            };
            this._title.setv(attrs);
        }
        connect_signals() {
            super.connect_signals();
            this.connect(this.model.change, () => {
                this._apply_title_properties();
                this._apply_axis_properties();
                // TODO?: this.plot_view.invalidate_layout()
            });
            this.connect(this._ticker.change, () => this.request_paint());
            this.connect(this._formatter.change, () => this.request_paint());
        }
        _update_frame() {
            const [x_scale, y_scale, x_range, y_range] = (() => {
                if (this.orientation == "horizontal") {
                    return [this._major_scale, this._minor_scale, this._major_range, this._minor_range];
                }
                else {
                    return [this._minor_scale, this._major_scale, this._minor_range, this._major_range];
                }
            })();
            this._frame.setv({ x_scale, y_scale, x_range, y_range });
        }
        update_layout() {
            const { location, width: w, height: h, padding, margin } = this.model;
            const [valign, halign] = (() => {
                if ((0, types_1.isString)(location)) {
                    switch (location) {
                        case "top_left":
                            return ["start", "start"];
                        case "top":
                        case "top_center":
                            return ["start", "center"];
                        case "top_right":
                            return ["start", "end"];
                        case "bottom_left":
                            return ["end", "start"];
                        case "bottom":
                        case "bottom_center":
                            return ["end", "center"];
                        case "bottom_right":
                            return ["end", "end"];
                        case "left":
                        case "center_left":
                            return ["center", "start"];
                        case "center":
                        case "center_center":
                            return ["center", "center"];
                        case "right":
                        case "center_right":
                            return ["center", "end"];
                    }
                }
                else {
                    return ["end", "start"];
                } // "bottom_left"
            })();
            const orientation = this._orientation = (() => {
                const { orientation } = this.model;
                if (orientation == "auto") {
                    if (this.panel != null) {
                        return this.panel.is_horizontal ? "horizontal" : "vertical";
                    }
                    else {
                        if (halign == "start" || halign == "end" || ( /*halign == "center" &&*/valign == "center")) {
                            return "vertical";
                        }
                        else {
                            return "horizontal";
                        }
                    }
                }
                else {
                    return orientation;
                }
            })();
            this._update_frame();
            const center_panel = new alignments_1.NodeLayout();
            const top_panel = new alignments_1.VStack();
            const bottom_panel = new alignments_1.VStack();
            const left_panel = new alignments_1.HStack();
            const right_panel = new alignments_1.HStack();
            center_panel.absolute = true;
            top_panel.absolute = true;
            bottom_panel.absolute = true;
            left_panel.absolute = true;
            right_panel.absolute = true;
            center_panel.on_resize((bbox) => this._frame_view.set_geometry(bbox));
            const layout = new border_1.BorderLayout();
            this._inner_layout = layout;
            layout.absolute = true;
            layout.center_panel = center_panel;
            layout.top_panel = top_panel;
            layout.bottom_panel = bottom_panel;
            layout.left_panel = left_panel;
            layout.right_panel = right_panel;
            const padding_box = { left: padding, right: padding, top: padding, bottom: padding };
            const margin_box = (() => {
                if (this.panel == null) {
                    if ((0, types_1.isString)(location)) {
                        return { left: margin, right: margin, top: margin, bottom: margin };
                    }
                    else {
                        const [left, bottom] = location;
                        return { left, right: margin, top: margin, bottom };
                    }
                }
                else {
                    /**
                     * XXX: alignment is broken in Grid, which is used to govern positioning of a ColorBar
                     * in side panels. Earlier attempts at fixing this failed and resulted in a multitude
                     * or regressions in various places in the layout. So instead of this, let's assume that
                     * the positioning is always at "start" regardless of configuration, and fix this here
                     * by manually computing "center" and "end" alignment.
                     */
                    if ((0, types_1.isString)(location)) {
                        layout.fixup_geometry = (outer, inner) => {
                            const origin = outer;
                            if (orientation == "horizontal") {
                                const { top, width, height } = outer;
                                if (halign == "end") {
                                    const { right } = this.layout.bbox;
                                    outer = new bbox_1.BBox({ right, top, width, height });
                                }
                                else if (halign == "center") {
                                    const { hcenter } = this.layout.bbox;
                                    outer = new bbox_1.BBox({ hcenter: Math.round(hcenter), top, width, height });
                                }
                            }
                            else {
                                const { left, width, height } = outer;
                                if (valign == "end") {
                                    const { bottom } = this.layout.bbox;
                                    outer = new bbox_1.BBox({ left, bottom, width, height });
                                }
                                else if (valign == "center") {
                                    const { vcenter } = this.layout.bbox;
                                    outer = new bbox_1.BBox({ left, vcenter: Math.round(vcenter), width, height });
                                }
                            }
                            if (inner != null) {
                                const dh = outer.left - origin.left;
                                const dv = outer.top - origin.top;
                                const { left, top, width, height } = inner;
                                inner = new bbox_1.BBox({ left: left + dh, top: top + dv, width, height });
                            }
                            return [outer, inner];
                        };
                        return undefined;
                    }
                    else {
                        const [left, bottom] = location;
                        layout.fixup_geometry = (outer, inner) => {
                            const origin = outer;
                            const grid = this.layout.bbox;
                            const { width, height } = outer;
                            outer = new bbox_1.BBox({ left: grid.left + left, bottom: grid.bottom - bottom, width, height });
                            if (inner != null) {
                                const dh = outer.left - origin.left;
                                const dv = outer.top - origin.top;
                                const { left, top, width, height } = inner;
                                inner = new bbox_1.BBox({ left: left + dh, top: top + dv, width, height });
                            }
                            return [outer, inner];
                        };
                        return { left, right: 0, top: 0, bottom };
                    }
                }
            })();
            layout.padding = padding_box;
            let major_policy;
            let major_size;
            let min_major_size;
            let max_major_size;
            if (this.panel != null) {
                major_policy = "max";
                major_size = undefined;
                min_major_size = undefined;
                max_major_size = undefined;
            }
            else {
                if ((orientation == "horizontal" ? w : h) == "auto") {
                    major_policy = "fixed";
                    const major_size_factor = this._get_major_size_factor();
                    if (major_size_factor != null) {
                        major_size = major_size_factor * MINOR_DIM;
                    }
                    min_major_size = { percent: MAJOR_DIM_MIN_SCALAR };
                    max_major_size = { percent: MAJOR_DIM_MAX_SCALAR };
                }
                else {
                    major_policy = "fit";
                    major_size = undefined;
                }
            }
            if (orientation == "horizontal") {
                const width = w == "auto" ? undefined : w;
                const height = h == "auto" ? MINOR_DIM : h;
                layout.set_sizing({
                    width_policy: major_policy, height_policy: "min",
                    width: major_size, min_width: min_major_size, max_width: max_major_size,
                    halign, valign, margin: margin_box,
                });
                layout.center_panel.set_sizing({ width_policy: w == "auto" ? "fit" : "fixed", height_policy: "fixed", width, height });
            }
            else {
                const width = w == "auto" ? MINOR_DIM : w;
                const height = h == "auto" ? undefined : h;
                layout.set_sizing({
                    width_policy: "min", height_policy: major_policy,
                    height: major_size, min_height: min_major_size, max_height: max_major_size,
                    halign, valign, margin: margin_box,
                });
                layout.center_panel.set_sizing({ width_policy: "fixed", height_policy: h == "auto" ? "fit" : "fixed", width, height });
            }
            top_panel.set_sizing({ width_policy: "fit", height_policy: "min" });
            bottom_panel.set_sizing({ width_policy: "fit", height_policy: "min" });
            left_panel.set_sizing({ width_policy: "min", height_policy: "fit" });
            right_panel.set_sizing({ width_policy: "min", height_policy: "fit" });
            const { _title_view } = this;
            if (orientation == "horizontal") {
                _title_view.panel = new side_panel_1.SidePanel("above");
                _title_view.update_layout();
                top_panel.children.push(_title_view.layout);
            }
            else {
                _title_view.panel = new side_panel_1.SidePanel("left");
                _title_view.update_layout();
                left_panel.children.push(_title_view.layout);
            }
            const { panel } = this;
            const side = (() => {
                if (panel != null && orientation == panel.orientation) {
                    return panel.side;
                }
                else {
                    return orientation == "horizontal" ? "below" : "right";
                }
            })();
            const stack = (() => {
                switch (side) {
                    case "above":
                        return top_panel;
                    case "below":
                        return bottom_panel;
                    case "left":
                        return left_panel;
                    case "right":
                        return right_panel;
                }
            })();
            const { _axis_view } = this;
            _axis_view.panel = new side_panel_1.SidePanel(side);
            _axis_view.update_layout();
            if (_axis_view.layout != null) {
                stack.children.push(_axis_view.layout);
            }
            if (this.panel != null) {
                const outer = new layout_1.Grid([{ layout, row: 0, col: 0 }]);
                outer.absolute = true;
                if (orientation == "horizontal") {
                    outer.set_sizing({ width_policy: "max", height_policy: "min" });
                }
                else {
                    outer.set_sizing({ width_policy: "min", height_policy: "max" });
                }
                this.layout = outer;
            }
            else {
                this.layout = this._inner_layout;
            }
            const { visible } = this.model;
            this.layout.sizing.visible = visible;
        }
        _create_axis() {
            return new linear_axis_1.LinearAxis();
        }
        _create_formatter() {
            return new formatters_1.BasicTickFormatter();
        }
        _create_major_range() {
            return new ranges_1.Range1d({ start: 0, end: 1 });
        }
        _create_major_scale() {
            return new scales_1.LinearScale();
        }
        _create_ticker() {
            return new tickers_1.BasicTicker();
        }
        _get_major_size_factor() {
            return null;
        }
        _paint(ctx) {
            ctx.save();
            this._paint_bbox(ctx, this._inner_layout.bbox);
            this._paint_colors(ctx, this._inner_layout.center_panel.bbox);
            this._title_view.paint(ctx);
            this._axis_view.paint(ctx);
            ctx.restore();
        }
        _paint_bbox(ctx, bbox) {
            const { x, y } = bbox;
            let { width, height } = bbox;
            // XXX: shrink outline region by 1px to make right and bottom lines visible
            // if they are on the edge of the canvas.
            if (x + width >= this.parent.canvas_view.bbox.width) {
                width -= 1;
            }
            if (y + height >= this.parent.canvas_view.bbox.height) {
                height -= 1;
            }
            ctx.save();
            ctx.beginPath();
            ctx.rect(x, y, width, height);
            this.visuals.background_fill.apply(ctx);
            this.visuals.background_hatch.apply(ctx);
            this.visuals.border_line.apply(ctx);
            ctx.restore();
        }
    }
    exports.BaseColorBarView = BaseColorBarView;
    BaseColorBarView.__name__ = "BaseColorBarView";
    class BaseColorBar extends annotation_1.Annotation {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.BaseColorBar = BaseColorBar;
    _a = BaseColorBar;
    BaseColorBar.__name__ = "BaseColorBar";
    (() => {
        _a.mixins([
            ["major_label_", mixins.Text],
            ["title_", mixins.Text],
            ["major_tick_", mixins.Line],
            ["minor_tick_", mixins.Line],
            ["border_", mixins.Line],
            ["bar_", mixins.Line],
            ["background_", mixins.Fill],
            ["background_", mixins.Hatch],
        ]);
        _a.define(({ Alpha, Float, Str, Tuple, Or, Ref, Auto, Nullable }) => ({
            location: [Or(enums_1.Anchor, Tuple(Float, Float)), "top_right"],
            orientation: [Or(enums_1.Orientation, Auto), "auto"],
            title: [Nullable(Or(Str, Ref(base_text_1.BaseText))), null],
            title_standoff: [Float, 2],
            width: [Or(Float, Auto), "auto"],
            height: [Or(Float, Auto), "auto"],
            scale_alpha: [Alpha, 1.0],
            ticker: [Or(Ref(ticker_1.Ticker), Auto), "auto"],
            formatter: [Or(Ref(tick_formatter_1.TickFormatter), Auto), "auto"],
            major_label_overrides: [axis_1.LabelOverrides, new Map()],
            major_label_policy: [Ref(labeling_1.LabelingPolicy), () => new labeling_1.NoOverlap()],
            label_standoff: [Float, 5],
            margin: [Float, 30],
            padding: [Float, 10],
            major_tick_in: [Float, 5],
            major_tick_out: [Float, 0],
            minor_tick_in: [Float, 0],
            minor_tick_out: [Float, 0],
        }));
        _a.override({
            background_fill_color: "#ffffff",
            background_fill_alpha: 0.95,
            bar_line_color: null,
            border_line_color: null,
            major_label_text_font_size: "11px",
            major_tick_line_color: "#ffffff",
            minor_tick_line_color: null,
            title_text_font_size: "13px",
            title_text_font_style: "italic",
        });
    })();
},
/* models/annotations/title.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const text_annotation_1 = require(172) /* ./text_annotation */;
    const enums_1 = require(21) /* ../../core/enums */;
    const resolve = tslib_1.__importStar(require(121) /* ../common/resolve */);
    class TitleView extends text_annotation_1.TextAnnotationView {
        _get_position() {
            const hmargin = this.model.offset;
            const vmargin = this.model.standoff / 2;
            const { align, vertical_align } = this.model;
            let sx, sy;
            const { bbox } = this.layout;
            switch (this.panel.side) {
                case "above":
                case "below": {
                    switch (vertical_align) {
                        case "top":
                            sy = bbox.top + vmargin;
                            break;
                        case "middle":
                            sy = bbox.vcenter;
                            break;
                        case "bottom":
                            sy = bbox.bottom - vmargin;
                            break;
                    }
                    switch (align) {
                        case "left":
                            sx = bbox.left + hmargin;
                            break;
                        case "center":
                            sx = bbox.hcenter;
                            break;
                        case "right":
                            sx = bbox.right - hmargin;
                            break;
                    }
                    break;
                }
                case "left": {
                    switch (vertical_align) {
                        case "top":
                            sx = bbox.left + vmargin;
                            break;
                        case "middle":
                            sx = bbox.hcenter;
                            break;
                        case "bottom":
                            sx = bbox.right - vmargin;
                            break;
                    }
                    switch (align) {
                        case "left":
                            sy = bbox.bottom - hmargin;
                            break;
                        case "center":
                            sy = bbox.vcenter;
                            break;
                        case "right":
                            sy = bbox.top + hmargin;
                            break;
                    }
                    break;
                }
                case "right": {
                    switch (vertical_align) {
                        case "top":
                            sx = bbox.right - vmargin;
                            break;
                        case "middle":
                            sx = bbox.hcenter;
                            break;
                        case "bottom":
                            sx = bbox.left + vmargin;
                            break;
                    }
                    switch (align) {
                        case "left":
                            sy = bbox.top + hmargin;
                            break;
                        case "center":
                            sy = bbox.vcenter;
                            break;
                        case "right":
                            sy = bbox.bottom - hmargin;
                            break;
                    }
                    break;
                }
            }
            return { sx, sy };
        }
        get anchor() {
            const { align, vertical_align } = this.model;
            return resolve.text_anchor("auto", align, vertical_align);
        }
        get origin() {
            return this._get_position();
        }
        get angle() {
            return this.panel.get_label_angle_heuristic("parallel");
        }
        _get_size() {
            const offset = (value) => {
                // XXX: The magic 2px is for backwards compatibility. This will be removed at
                // some point, but currently there is no point breaking half of visual tests.
                return value == 0 ? 0 : 2 + value + this.model.standoff;
            };
            const { width, height } = super._get_size();
            if (this.panel.is_horizontal) {
                return { width, height: offset(height) };
            }
            else {
                return { width: offset(width), height };
            }
        }
    }
    exports.TitleView = TitleView;
    TitleView.__name__ = "TitleView";
    class Title extends text_annotation_1.TextAnnotation {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Title = Title;
    _a = Title;
    Title.__name__ = "Title";
    (() => {
        _a.prototype.default_view = TitleView;
        _a.define(({ Float }) => ({
            vertical_align: [enums_1.VerticalAlign, "bottom"],
            align: [enums_1.TextAlign, "left"],
            offset: [Float, 0],
            standoff: [Float, 10],
        }));
        _a.override({
            text_font_size: "13px",
            text_font_style: "bold",
            text_line_height: 1.0,
        });
    })();
},
/* models/annotations/text_annotation.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const annotation_1 = require(81) /* ./annotation */;
    const side_panel_1 = require(173) /* ../../core/layout/side_panel */;
    const base_text_1 = require(176) /* ../text/base_text */;
    const build_views_1 = require(56) /* ../../core/build_views */;
    const types_1 = require(8) /* ../../core/util/types */;
    const utils_1 = require(177) /* ../text/utils */;
    const kinds_1 = require(118) /* ../common/kinds */;
    const resolve = tslib_1.__importStar(require(121) /* ../common/resolve */);
    const bbox_1 = require(64) /* ../../core/util/bbox */;
    const painting_1 = require(185) /* ../common/painting */;
    const mixins = tslib_1.__importStar(require(80) /* ../../core/property_mixins */);
    class TextAnnotationView extends annotation_1.AnnotationView {
        *children() {
            yield* super.children();
            yield this._text_view;
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            await this._init_text();
        }
        async _init_text() {
            const { text } = this.model;
            const _text = (0, types_1.isString)(text) ? (0, utils_1.parse_delimited_string)(text) : text;
            this._text_view = await (0, build_views_1.build_view)(_text, { parent: this });
        }
        update_layout() {
            const { panel } = this;
            if (panel != null) {
                this.layout = new side_panel_1.SideLayout(panel, () => this.get_size(), false);
            }
            else {
                this.layout = undefined;
            }
        }
        connect_signals() {
            super.connect_signals();
            const { text } = this.model.properties;
            this.on_change(text, async () => {
                this._text_view.remove();
                await this._init_text();
            });
            this.connect(this.model.change, () => this.request_paint());
        }
        remove() {
            this._text_view.remove();
            super.remove();
        }
        has_finished() {
            if (!super.has_finished()) {
                return false;
            }
            if (!this._text_view.has_finished()) {
                return false;
            }
            return true;
        }
        get displayed() {
            return super.displayed && this._text_view.model.text != "" && this.visuals.text.doit;
        }
        get padding() {
            return resolve.padding(this.model.padding);
        }
        get border_radius() {
            return resolve.border_radius(this.model.border_radius);
        }
        _get_size() {
            if (!this.displayed) {
                return { width: 0, height: 0 };
            }
            const graphics = this._text_view.graphics();
            graphics.angle = this.angle;
            graphics.align = "auto";
            graphics.visuals = this.visuals.text.values();
            const size = graphics.size();
            const { padding } = this;
            const width = size.width + padding.left + padding.right;
            const height = size.height + padding.top + padding.bottom;
            return { width, height };
        }
        compute_geometry() {
            super.compute_geometry();
            const text_box = this._text_view.graphics();
            text_box.position = { sx: 0, sy: 0, x_anchor: "left", y_anchor: "top" };
            text_box.angle = 0; // needs reset because text_box is self-referential
            text_box.align = "auto";
            text_box.visuals = this.visuals.text.values();
            const size = text_box.size();
            const { sx, sy } = this.origin;
            const { anchor, padding, border_radius, angle } = this;
            const width = size.width + padding.left + padding.right;
            const height = size.height + padding.top + padding.bottom;
            this._text_box = text_box;
            this._rect = { sx, sy, width, height, angle, anchor, padding, border_radius };
        }
        _paint(ctx) {
            const { sx, sy, width, height, angle, anchor, padding, border_radius } = this._rect;
            const label = this._text_box;
            const dx = anchor.x * width;
            const dy = anchor.y * height;
            ctx.translate(sx, sy);
            ctx.rotate(angle);
            ctx.translate(-dx, -dy);
            const { background_fill, background_hatch, border_line, text } = this.visuals;
            if (background_fill.doit || background_hatch.doit || border_line.doit) {
                ctx.beginPath();
                const bbox = new bbox_1.BBox({ x: 0, y: 0, width, height });
                (0, painting_1.round_rect)(ctx, bbox, border_radius);
                background_fill.apply(ctx);
                background_hatch.apply(ctx);
                border_line.apply(ctx);
            }
            if (text.doit) {
                const { left, top } = padding;
                ctx.translate(left, top);
                label.paint(ctx);
                ctx.translate(-left, -top);
            }
            ctx.translate(dx, dy);
            ctx.rotate(-angle);
            ctx.translate(-sx, -sy);
        }
    }
    exports.TextAnnotationView = TextAnnotationView;
    TextAnnotationView.__name__ = "TextAnnotationView";
    class TextAnnotation extends annotation_1.Annotation {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.TextAnnotation = TextAnnotation;
    _a = TextAnnotation;
    TextAnnotation.__name__ = "TextAnnotation";
    (() => {
        _a.mixins([
            mixins.Text,
            ["border_", mixins.Line],
            ["background_", mixins.Fill],
            ["background_", mixins.Hatch],
        ]);
        _a.define(({ Str, Or, Ref }) => ({
            text: [Or(Str, Ref(base_text_1.BaseText)), ""],
            padding: [kinds_1.Padding, 0],
            border_radius: [kinds_1.BorderRadius, 0],
        }));
        _a.override({
            border_line_color: null,
            background_fill_color: null,
        });
    })();
},
/* core/layout/side_panel.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const types_1 = require(174) /* ./types */;
    const layoutable_1 = require(175) /* ./layoutable */;
    const types_2 = require(8) /* ../util/types */;
    // This table lays out the rules for configuring the baseline, alignment, etc. of
    // title text, based on it's location and orientation
    //
    // side    orient        baseline   align     angle   normal-dist
    // ------------------------------------------------------------------------------
    // above   parallel      bottom     center    0       height
    //         normal        middle     left      -90     width
    //         horizontal    bottom     center    0       height
    //         [angle > 0]   middle     left              width * sin + height * cos
    //         [angle < 0]   middle     right             width * sin + height * cos
    //
    // below   parallel      top        center    0       height
    //         normal        middle     right     90      width
    //         horizontal    top        center    0       height
    //         [angle > 0]   middle     right             width * sin + height * cos
    //         [angle < 0]   middle     left              width * sin + height * cos
    //
    // left    parallel      bottom     center    90      height
    //         normal        middle     right     0       width
    //         horizontal    middle     right     0       width
    //         [angle > 0]   middle     right             width * cos + height * sin
    //         [angle < 0]   middle     right             width * cos + height + sin
    //
    // right   parallel      bottom     center   -90      height
    //         normal        middle     left     0        width
    //         horizontal    middle     left     0        width
    //         [angle > 0]   middle     left              width * cos + height * sin
    //         [angle < 0]   middle     left              width * cos + height + sin
    const pi2 = Math.PI / 2;
    const _angle_lookup = {
        above: {
            parallel: 0,
            normal: -pi2,
            horizontal: 0,
            vertical: -pi2,
        },
        below: {
            parallel: 0,
            normal: pi2,
            horizontal: 0,
            vertical: pi2,
        },
        left: {
            parallel: -pi2,
            normal: 0,
            horizontal: 0,
            vertical: -pi2,
        },
        right: {
            parallel: pi2,
            normal: 0,
            horizontal: 0,
            vertical: pi2,
        },
    };
    const _vertical_align_lookup = {
        above: {
            parallel: "bottom",
            normal: "center",
            horizontal: "bottom",
            vertical: "center",
        },
        below: {
            parallel: "top",
            normal: "center",
            horizontal: "top",
            vertical: "center",
        },
        left: {
            parallel: "bottom",
            normal: "center",
            horizontal: "center",
            vertical: "bottom",
        },
        right: {
            parallel: "bottom",
            normal: "center",
            horizontal: "center",
            vertical: "bottom",
        },
    };
    const _align_lookup = {
        above: {
            parallel: "center",
            normal: "left",
            horizontal: "center",
            vertical: "left",
        },
        below: {
            parallel: "center",
            normal: "left",
            horizontal: "center",
            vertical: "left",
        },
        left: {
            parallel: "center",
            normal: "right",
            horizontal: "right",
            vertical: "center",
        },
        right: {
            parallel: "center",
            normal: "left",
            horizontal: "left",
            vertical: "center",
        },
    };
    const _align_lookup_negative = {
        above: "right",
        below: "left",
        left: "right",
        right: "left",
    };
    const _align_lookup_positive = {
        above: "left",
        below: "right",
        left: "right",
        right: "left",
    };
    class SidePanel {
        constructor(side, face) {
            this.side = side;
            this.face = (() => {
                if (face != null && face != "auto") {
                    return face;
                }
                else {
                    switch (this.side) {
                        case "left":
                        case "above":
                            return "front";
                        case "right":
                        case "below":
                            return "back";
                    }
                }
            })();
            this.dimension = this.side == "above" || this.side == "below" ? 0 : 1;
            this.orientation = this.dimension == 0 ? "horizontal" : "vertical";
            this.is_horizontal = this.dimension == 0;
            this.is_vertical = this.dimension == 1;
            this.normals = (() => {
                const sign = this.face == "front" ? -1 : 1;
                switch (this.side) {
                    case "left": return [sign, 0];
                    case "right": return [sign, 0];
                    case "above": return [0, sign];
                    case "below": return [0, sign];
                }
            })();
        }
        get face_adjusted_side() {
            const { side, face } = this;
            switch (side) {
                case "left":
                case "right":
                    return face == "front" ? "left" : "right";
                case "above":
                case "below":
                    return face == "front" ? "above" : "below";
            }
        }
        get_label_text_heuristics(orient) {
            const side = this.face_adjusted_side;
            if ((0, types_2.isString)(orient)) {
                return {
                    vertical_align: _vertical_align_lookup[side][orient],
                    align: _align_lookup[side][orient],
                };
            }
            else {
                return {
                    vertical_align: "center",
                    align: (orient < 0 ? _align_lookup_negative : _align_lookup_positive)[side],
                };
            }
        }
        get_label_angle_heuristic(orient) {
            if ((0, types_2.isString)(orient)) {
                const side = this.face_adjusted_side;
                return _angle_lookup[side][orient];
            }
            else {
                return -orient;
            }
        }
    }
    exports.SidePanel = SidePanel;
    SidePanel.__name__ = "SidePanel";
    class SideLayout extends layoutable_1.ContentLayoutable {
        constructor(panel, get_size, rotate = false) {
            super();
            this.panel = panel;
            this.get_size = get_size;
            this.rotate = rotate;
            if (this.panel.is_horizontal) {
                this.set_sizing({ width_policy: "max", height_policy: "fixed" });
            }
            else {
                this.set_sizing({ width_policy: "fixed", height_policy: "max" });
            }
        }
        _content_size() {
            const { width, height } = this.get_size();
            if (!this.rotate || this.panel.is_horizontal) {
                return new types_1.Sizeable({ width, height });
            }
            else {
                return new types_1.Sizeable({ width: height, height: width });
            }
        }
        has_size_changed() {
            const { width, height } = this._content_size();
            if (this.panel.is_horizontal) {
                return this.bbox.height != height;
            }
            else {
                return this.bbox.width != width;
            }
        }
    }
    exports.SideLayout = SideLayout;
    SideLayout.__name__ = "SideLayout";
},
/* core/layout/types.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const kinds_1 = require(22) /* ../kinds */;
    const { min, max } = Math;
    class Sizeable {
        constructor(size = {}) {
            this.width = size.width != null ? size.width : 0;
            this.height = size.height != null ? size.height : 0;
        }
        bounded_to({ width, height }) {
            return new Sizeable({
                width: this.width == Infinity && width != null ? width : this.width,
                height: this.height == Infinity && height != null ? height : this.height,
            });
        }
        expanded_to({ width, height }) {
            return new Sizeable({
                width: width != Infinity ? max(this.width, width) : this.width,
                height: height != Infinity ? max(this.height, height) : this.height,
            });
        }
        expand_to({ width, height }) {
            this.width = max(this.width, width);
            this.height = max(this.height, height);
        }
        narrowed_to({ width, height }) {
            return new Sizeable({
                width: min(this.width, width),
                height: min(this.height, height),
            });
        }
        narrow_to({ width, height }) {
            this.width = min(this.width, width);
            this.height = min(this.height, height);
        }
        grow_by({ left, right, top, bottom }) {
            const width = this.width + left + right;
            const height = this.height + top + bottom;
            return new Sizeable({ width, height });
        }
        shrink_by({ left, right, top, bottom }) {
            const width = max(this.width - left - right, 0);
            const height = max(this.height - top - bottom, 0);
            return new Sizeable({ width, height });
        }
        map(w_fn, h_fn) {
            return new Sizeable({
                width: w_fn(this.width),
                height: (h_fn != null ? h_fn : w_fn)(this.height),
            });
        }
    }
    exports.Sizeable = Sizeable;
    Sizeable.__name__ = "Sizeable";
    exports.SizingPolicy = (0, kinds_1.Enum)("fixed", "fit", "min", "max");
},
/* core/layout/layoutable.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const types_1 = require(174) /* ./types */;
    const bbox_1 = require(64) /* ../util/bbox */;
    const types_2 = require(8) /* ../util/types */;
    const assert_1 = require(12) /* ../util/assert */;
    const { abs, min, max, round } = Math;
    class Layoutable {
        constructor() {
            this.absolute = false;
            this.position = { left: 0, top: 0 };
            this._bbox = new bbox_1.BBox();
            this._inner_bbox = new bbox_1.BBox();
            this._sizing = null;
            this._dirty = false;
            this._handlers = [];
        }
        *[Symbol.iterator]() { }
        get bbox() {
            return this._bbox;
        }
        get inner_bbox() {
            return this._inner_bbox;
        }
        get sizing() {
            (0, assert_1.assert)(this._sizing != null);
            return this._sizing;
        }
        set dirty(dirty) {
            this._dirty = dirty;
        }
        get dirty() {
            return this._dirty;
        }
        get visible() {
            return this.sizing.visible;
        }
        set visible(visible) {
            if (this.sizing.visible != visible) {
                this.sizing.visible = visible;
                this._dirty = true;
            }
        }
        set_sizing(sizing = {}) {
            const width_policy = sizing.width_policy ?? "fit";
            const width = sizing.width;
            const min_width = sizing.min_width;
            const max_width = sizing.max_width;
            const height_policy = sizing.height_policy ?? "fit";
            const height = sizing.height;
            const min_height = sizing.min_height;
            const max_height = sizing.max_height;
            const aspect = sizing.aspect;
            const margin = sizing.margin ?? { top: 0, right: 0, bottom: 0, left: 0 };
            const visible = sizing.visible ?? true;
            const halign = sizing.halign ?? "start";
            const valign = sizing.valign ?? "start";
            this._sizing = {
                width_policy, min_width, width, max_width,
                height_policy, min_height, height, max_height,
                aspect,
                margin,
                visible,
                halign,
                valign,
                size: { width, height },
            };
            this._init();
        }
        _init() { }
        _set_geometry(outer, inner) {
            this._bbox = outer;
            this._inner_bbox = inner;
        }
        set_geometry(outer, inner) {
            const { fixup_geometry } = this;
            if (fixup_geometry != null) {
                [outer, inner] = fixup_geometry(outer, inner);
            }
            this._set_geometry(outer, inner ?? outer);
            for (const handler of this._handlers) {
                handler(this._bbox, this._inner_bbox);
            }
        }
        on_resize(handler) {
            this._handlers.push(handler);
        }
        is_width_expanding() {
            return this.sizing.width_policy == "max";
        }
        is_height_expanding() {
            return this.sizing.height_policy == "max";
        }
        apply_aspect(viewport, { width, height }) {
            const { aspect } = this.sizing;
            if (aspect != null) {
                const { width_policy, height_policy } = this.sizing;
                const gt = (width, height) => {
                    const policies = { max: 4, fit: 3, min: 2, fixed: 1 };
                    return policies[width] > policies[height];
                };
                if (width_policy != "fixed" && height_policy != "fixed") {
                    if (width_policy == height_policy) {
                        const w_width = width;
                        const w_height = round(width / aspect);
                        const h_width = round(height * aspect);
                        const h_height = height;
                        const w_diff = abs(viewport.width - w_width) + abs(viewport.height - w_height);
                        const h_diff = abs(viewport.width - h_width) + abs(viewport.height - h_height);
                        if (w_diff <= h_diff) {
                            width = w_width;
                            height = w_height;
                        }
                        else {
                            width = h_width;
                            height = h_height;
                        }
                    }
                    else if (gt(width_policy, height_policy)) {
                        height = round(width / aspect);
                    }
                    else {
                        width = round(height * aspect);
                    }
                }
                else if (width_policy == "fixed") {
                    height = round(width / aspect);
                }
                else if (height_policy == "fixed") {
                    width = round(height * aspect);
                }
            }
            return { width, height };
        }
        measure(viewport_size) {
            if (this._sizing == null) {
                this.set_sizing();
            }
            if (!this.sizing.visible) {
                return { width: 0, height: 0 };
            }
            const exact_width = (width) => {
                return this.sizing.width_policy == "fixed" && this.sizing.width != null ? this.sizing.width : width;
            };
            const exact_height = (height) => {
                return this.sizing.height_policy == "fixed" && this.sizing.height != null ? this.sizing.height : height;
            };
            const viewport = new types_1.Sizeable(viewport_size)
                .shrink_by(this.sizing.margin)
                .map(exact_width, exact_height);
            const computed = this._measure(viewport);
            const clipped = this.clip_size(computed, viewport);
            const width = exact_width(clipped.width);
            const height = exact_height(clipped.height);
            const size = this.apply_aspect(viewport, { width, height });
            return { ...computed, ...size };
        }
        compute(viewport = {}) {
            const size_hint = this.measure({
                width: viewport.width != null && this.is_width_expanding() ? viewport.width : Infinity,
                height: viewport.height != null && this.is_height_expanding() ? viewport.height : Infinity,
            });
            const { width, height } = size_hint;
            const { left, top } = this.position;
            const outer = new bbox_1.BBox({ left, top, width, height });
            let inner = undefined;
            if (size_hint.inner != null) {
                const { left, top, right, bottom } = size_hint.inner;
                inner = new bbox_1.BBox({ left, top, right: width - right, bottom: height - bottom });
            }
            this.set_geometry(outer, inner);
        }
        get xview() {
            return this.bbox.xview;
        }
        get yview() {
            return this.bbox.yview;
        }
        clip_size(size, viewport) {
            function clip(size, vsize, min_size, max_size) {
                if (min_size == null) {
                    min_size = 0;
                }
                else if (!(0, types_2.isNumber)(min_size)) {
                    min_size = round(min_size.percent * vsize);
                }
                if (max_size == null) {
                    max_size = Infinity;
                }
                else if (!(0, types_2.isNumber)(max_size)) {
                    max_size = round(max_size.percent * vsize);
                }
                return max(min_size, min(size, max_size));
            }
            return {
                width: clip(size.width, viewport.width, this.sizing.min_width, this.sizing.max_width),
                height: clip(size.height, viewport.height, this.sizing.min_height, this.sizing.max_height),
            };
        }
        has_size_changed() {
            const { _dirty } = this;
            this._dirty = false;
            return _dirty;
        }
    }
    exports.Layoutable = Layoutable;
    Layoutable.__name__ = "Layoutable";
    class ContentLayoutable extends Layoutable {
        _measure(viewport) {
            const content_size = this._content_size();
            const bounds = viewport
                .bounded_to(this.sizing.size)
                .bounded_to(content_size);
            const width = (() => {
                switch (this.sizing.width_policy) {
                    case "fixed":
                        return this.sizing.width != null ? this.sizing.width : content_size.width;
                    case "min":
                        return content_size.width;
                    case "fit":
                        return bounds.width;
                    case "max":
                        return max(content_size.width, bounds.width);
                }
            })();
            const height = (() => {
                switch (this.sizing.height_policy) {
                    case "fixed":
                        return this.sizing.height != null ? this.sizing.height : content_size.height;
                    case "min":
                        return content_size.height;
                    case "fit":
                        return bounds.height;
                    case "max":
                        return max(content_size.height, bounds.height);
                }
            })();
            return { width, height };
        }
    }
    exports.ContentLayoutable = ContentLayoutable;
    ContentLayoutable.__name__ = "ContentLayoutable";
    class TextLayout extends ContentLayoutable {
        constructor(text) {
            super();
            this.text = text;
        }
        _content_size() {
            return new types_1.Sizeable(this.text.size());
        }
    }
    exports.TextLayout = TextLayout;
    TextLayout.__name__ = "TextLayout";
    class FixedLayout extends ContentLayoutable {
        constructor(size = {}) {
            super();
            this.size = size;
        }
        _content_size() {
            return new types_1.Sizeable(this.size);
        }
    }
    exports.FixedLayout = FixedLayout;
    FixedLayout.__name__ = "FixedLayout";
},
/* models/text/base_text.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a;
    __esModule();
    const model_1 = require(51) /* ../../model */;
    const view_1 = require(58) /* ../../core/view */;
    class BaseTextView extends view_1.View {
    }
    exports.BaseTextView = BaseTextView;
    BaseTextView.__name__ = "BaseTextView";
    class BaseText extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.BaseText = BaseText;
    _a = BaseText;
    BaseText.__name__ = "BaseText";
    (() => {
        _a.define(({ Str }) => ({
            text: [Str],
        }));
    })();
},
/* models/text/utils.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.parse_delimited_string = parse_delimited_string;
    const math_text_1 = require(178) /* ./math_text */;
    const plain_text_1 = require(184) /* ./plain_text */;
    const array_1 = require(10) /* ../../core/util/array */;
    const delimiters = [
        { start: "$$", end: "$$", inline: false },
        { start: "\\\[", end: "\\\]", inline: false },
        { start: "\\\(", end: "\\\)", inline: true },
    ];
    function add_backslash(m) {
        return m.split("").map(s => `\\${s}`).join("");
    }
    function parse_delimited_string(text) {
        const matches = [];
        for (const delim of delimiters) {
            const start = add_backslash(delim.start);
            const end = add_backslash(delim.end);
            const re = new RegExp(`${start}([^]*?)${end}`, "gm");
            for (const match of text.matchAll(re)) {
                const { index } = match;
                const [outer, inner] = match;
                matches.push({ index, outer, inner, delim });
            }
        }
        if (matches.length > 0) {
            if (matches.length == 1) {
                const [match] = matches;
                const start = match.index;
                const end = match.outer.length;
                if (start == 0 && end == text.length) {
                    const tex_string = match.inner;
                    return new math_text_1.TeX({ text: tex_string, inline: match.delim.inline });
                }
            }
            let tex_string = "";
            let end = 0;
            for (const match of (0, array_1.sort_by)(matches, (match) => match.index)) {
                const start = match.index;
                if (end <= start) {
                    tex_string += start != 0 ? `\\text{${text.slice(end, start)}}${match.inner}` : `${match.inner}`;
                    end = start + match.outer.length;
                }
            }
            tex_string += end < text.length ? `\\text{${text.slice(end)}}` : "";
            return new math_text_1.TeX({ text: tex_string, inline: false });
        }
        else {
            return new plain_text_1.PlainText({ text });
        }
    }
},
/* models/text/math_text.js */ function _(require, module, exports, __esModule, __esExport) {
    var _a, _b, _c;
    __esModule();
    const object_1 = require(9) /* ../../core/util/object */;
    const types_1 = require(8) /* ../../core/util/types */;
    const image_1 = require(179) /* ../../core/util/image */;
    const color_1 = require(23) /* ../../core/util/color */;
    const graphics_1 = require(180) /* ../../core/graphics */;
    const text_1 = require(181) /* ../../core/util/text */;
    const string_1 = require(40) /* ../../core/util/string */;
    const affine_1 = require(114) /* ../../core/util/affine */;
    const bbox_1 = require(64) /* ../../core/util/bbox */;
    const base_text_1 = require(176) /* ./base_text */;
    const providers_1 = require(182) /* ./providers */;
    /**
     * Helper class for rendering MathText into Canvas
     */
    class MathTextView extends base_text_1.BaseTextView {
        constructor() {
            super(...arguments);
            this._position = { sx: 0, sy: 0 };
            // Align does nothing, needed to maintain compatibility with TextBox,
            // to align you need to use TeX Macros.
            // http://docs.mathjax.org/en/latest/input/tex/macros/index.html?highlight=align
            this.align = "left";
            this._x_anchor = "left";
            this._y_anchor = "center";
            this._base_font_size = 13; // the same as :host's font-size (13px)
            this.font_size_scale = 1.0;
            this.svg_image = null;
        }
        graphics() {
            return this;
        }
        // Same for infer_text_height
        infer_text_height() {
            return "ascent_descent";
        }
        set base_font_size(v) {
            if (v != null) {
                this._base_font_size = v;
            }
        }
        get base_font_size() {
            return this._base_font_size;
        }
        _rect() {
            const { width, height } = this._size();
            const { x, y } = this._computed_position();
            const bbox = new bbox_1.BBox({ x, y, width, height });
            return bbox.rect;
        }
        set position(p) {
            this._position = p;
        }
        get position() {
            return this._position;
        }
        get text() {
            return this.model.text;
        }
        get provider() {
            return providers_1.default_provider;
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            if (this.provider.status == "not_started") {
                await this.provider.fetch();
            }
        }
        connect_signals() {
            super.connect_signals();
            this.on_change(this.model.properties.text, () => this.load_image());
        }
        set visuals(v) {
            const color = v.color;
            const alpha = v.alpha;
            const style = v.font_style;
            let size = v.font_size;
            const face = v.font;
            const { font_size_scale, _base_font_size } = this;
            const res = (0, text_1.parse_css_font_size)(size);
            if (res != null) {
                let { value, unit } = res;
                value *= font_size_scale;
                if (unit == "em" && _base_font_size != 0) {
                    value *= _base_font_size;
                    unit = "px";
                }
                size = `${value}${unit}`;
            }
            const font = `${style} ${size} ${face}`;
            this.font = font;
            this.color = (0, color_1.color2css)(color, alpha);
            const align = v.align;
            //this._visual_align = align
            this._x_anchor = align;
            const baseline = v.baseline;
            this._y_anchor = (() => {
                switch (baseline) {
                    case "top": return "top";
                    case "middle": return "center";
                    case "bottom": return "bottom";
                    default: return "baseline";
                }
            })();
        }
        /**
         * Calculates position of element after considering
         * anchor and dimensions
         */
        _computed_position() {
            const { width, height } = this._size();
            const { sx, sy, x_anchor = this._x_anchor, y_anchor = this._y_anchor } = this.position;
            const metrics = (0, text_1.font_metrics)(this.font);
            const x = sx - (() => {
                if ((0, types_1.isNumber)(x_anchor)) {
                    return x_anchor * width;
                }
                else {
                    switch (x_anchor) {
                        case "left": return 0;
                        case "center": return 0.5 * width;
                        case "right": return width;
                    }
                }
            })();
            const y = sy - (() => {
                if ((0, types_1.isNumber)(y_anchor)) {
                    return y_anchor * height;
                }
                else {
                    switch (y_anchor) {
                        case "top":
                            if (metrics.height > height) {
                                return (height - (-this.valign - metrics.descent) - metrics.height);
                            }
                            else {
                                return 0;
                            }
                        case "center": return 0.5 * height;
                        case "bottom":
                            if (metrics.height > height) {
                                return (height + metrics.descent + this.valign);
                            }
                            else {
                                return height;
                            }
                        case "baseline": return 0.5 * height;
                    }
                }
            })();
            return { x, y };
        }
        /**
         * Uses the width, height and given angle to calculate the size
        */
        size() {
            const { width, height } = this._size();
            const { angle } = this;
            if (angle == null || angle == 0) {
                return { width, height };
            }
            else {
                const c = Math.cos(Math.abs(angle));
                const s = Math.sin(Math.abs(angle));
                return {
                    width: Math.abs(width * c + height * s),
                    height: Math.abs(width * s + height * c),
                };
            }
        }
        get_image_dimensions() {
            const fmetrics = (0, text_1.font_metrics)(this.font);
            // XXX: perhaps use getComputedStyle()?
            const svg_styles = this.svg_element.getAttribute("style")?.split(";");
            if (svg_styles != null) {
                const rules_map = new Map();
                svg_styles.forEach(property => {
                    const [rule, value] = property.split(":");
                    if (rule.trim() != "") {
                        rules_map.set(rule.trim(), value.trim());
                    }
                });
                const v_align = (0, text_1.parse_css_length)(rules_map.get("vertical-align"));
                if (v_align?.unit == "ex") {
                    this.valign = v_align.value * fmetrics.x_height;
                }
                else if (v_align?.unit == "px") {
                    this.valign = v_align.value;
                }
            }
            const ex = (() => {
                const width = this.svg_element.getAttribute("width");
                const height = this.svg_element.getAttribute("height");
                return {
                    width: width != null && width.endsWith("ex") ? parseFloat(width) : 1,
                    height: height != null && height.endsWith("ex") ? parseFloat(height) : 1,
                };
            })();
            return {
                width: fmetrics.x_height * ex.width,
                height: fmetrics.x_height * ex.height,
            };
        }
        get truncated_text() {
            return this.model.text.length > 6
                ? `${this.model.text.substring(0, 6)}...`
                : this.model.text;
        }
        _size() {
            if (this.svg_image == null) {
                if (this.provider.status == "failed" || this.provider.status == "not_started") {
                    return {
                        width: (0, graphics_1.text_width)(this.truncated_text, this.font),
                        height: (0, text_1.font_metrics)(this.font).height,
                    };
                }
                else {
                    return { width: this._base_font_size, height: this._base_font_size };
                }
            }
            const fmetrics = (0, text_1.font_metrics)(this.font);
            let { width, height } = this.get_image_dimensions();
            height = Math.max(height, fmetrics.height);
            const w_scale = this.width?.unit == "%" ? this.width.value : 1;
            const h_scale = this.height?.unit == "%" ? this.height.value : 1;
            return { width: width * w_scale, height: height * h_scale };
        }
        bbox() {
            const { p0, p1, p2, p3 } = this.rect();
            const left = Math.min(p0.x, p1.x, p2.x, p3.x);
            const top = Math.min(p0.y, p1.y, p2.y, p3.y);
            const right = Math.max(p0.x, p1.x, p2.x, p3.x);
            const bottom = Math.max(p0.y, p1.y, p2.y, p3.y);
            return new bbox_1.BBox({ left, right, top, bottom });
        }
        rect() {
            const rect = this._rect();
            const { angle } = this;
            if (angle == null || angle == 0) {
                return rect;
            }
            else {
                const { sx, sy } = this.position;
                const tr = new affine_1.AffineTransform();
                tr.translate(sx, sy);
                tr.rotate(angle);
                tr.translate(-sx, -sy);
                return tr.apply_rect(rect);
            }
        }
        paint_rect(ctx) {
            const { p0, p1, p2, p3 } = this.rect();
            ctx.save();
            ctx.strokeStyle = "red";
            ctx.lineWidth = 1;
            ctx.beginPath();
            const { round } = Math;
            ctx.moveTo(round(p0.x), round(p0.y));
            ctx.lineTo(round(p1.x), round(p1.y));
            ctx.lineTo(round(p2.x), round(p2.y));
            ctx.lineTo(round(p3.x), round(p3.y));
            ctx.closePath();
            ctx.stroke();
            ctx.restore();
        }
        paint_bbox(ctx) {
            const { x, y, width, height } = this.bbox();
            ctx.save();
            ctx.strokeStyle = "blue";
            ctx.lineWidth = 1;
            ctx.beginPath();
            const { round } = Math;
            ctx.moveTo(round(x), round(y));
            ctx.lineTo(round(x), round(y + height));
            ctx.lineTo(round(x + width), round(y + height));
            ctx.lineTo(round(x + width), round(y));
            ctx.closePath();
            ctx.stroke();
            ctx.restore();
        }
        async request_image() {
            if (this.provider.MathJax == null) {
                return;
            }
            const mathjax_element = this._process_text();
            if (mathjax_element == null) {
                this._has_finished = true;
                return;
            }
            const svg_element = mathjax_element.children[0];
            this.svg_element = svg_element;
            svg_element.setAttribute("font", this.font);
            svg_element.setAttribute("stroke", this.color);
            const svg = svg_element.outerHTML;
            const src = `data:image/svg+xml;utf-8,${encodeURIComponent(svg)}`;
            this.svg_image = await (0, image_1.load_image)(src);
        }
        async load_image() {
            await this.request_image();
            this.parent.request_layout();
        }
        /**
         * Takes a Canvas' Context2d and if the image has already
         * been loaded draws the image in it otherwise draws the model's text.
        */
        paint(ctx) {
            if (this.svg_image == null) {
                if (this.provider.status == "not_started" || this.provider.status == "loading") {
                    this.provider.ready.connect(() => this.load_image());
                }
                if (this.provider.status == "loaded") {
                    void this.load_image();
                }
            }
            ctx.save();
            const { sx, sy } = this.position;
            const { angle } = this;
            if (angle != null && angle != 0) {
                ctx.translate(sx, sy);
                ctx.rotate(angle);
                ctx.translate(-sx, -sy);
            }
            const { x, y } = this._computed_position();
            if (this.svg_image != null) {
                const { width, height } = this.get_image_dimensions();
                ctx.drawImage(this.svg_image, x, y, width, height);
            }
            else if (this.provider.status == "failed" || this.provider.status == "not_started") {
                ctx.fillStyle = this.color;
                ctx.font = this.font;
                ctx.textAlign = "left";
                ctx.textBaseline = "alphabetic";
                ctx.fillText(this.truncated_text, x, y + (0, text_1.font_metrics)(this.font).ascent);
            }
            ctx.restore();
            if (!this._has_finished && (this.provider.status == "failed" || this.svg_image != null)) {
                this._has_finished = true;
                this.parent.notify_finished_after_paint();
            }
        }
    }
    exports.MathTextView = MathTextView;
    MathTextView.__name__ = "MathTextView";
    class MathText extends base_text_1.BaseText {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.MathText = MathText;
    MathText.__name__ = "MathText";
    class AsciiView extends MathTextView {
        // TODO: Color ascii
        get styled_text() {
            return this.text;
        }
        _process_text() {
            return undefined; // TODO: this.provider.MathJax?.ascii2svg(text)
        }
        _size() {
            return {
                width: (0, graphics_1.text_width)(this.text, this.font),
                height: (0, text_1.font_metrics)(this.font).height,
            };
        }
        paint(ctx) {
            ctx.save();
            const { sx, sy } = this.position;
            const { angle } = this;
            if (angle != null && angle != 0) {
                ctx.translate(sx, sy);
                ctx.rotate(angle);
                ctx.translate(-sx, -sy);
            }
            const { x, y } = this._computed_position();
            ctx.fillStyle = this.color;
            ctx.font = this.font;
            ctx.textAlign = "left";
            ctx.textBaseline = "alphabetic";
            ctx.fillText(this.text, x, y + (0, text_1.font_metrics)(this.font).ascent);
            ctx.restore();
            this._has_finished = true;
            this.parent.notify_finished_after_paint();
        }
    }
    exports.AsciiView = AsciiView;
    AsciiView.__name__ = "AsciiView";
    class Ascii extends MathText {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Ascii = Ascii;
    _a = Ascii;
    Ascii.__name__ = "Ascii";
    (() => {
        _a.prototype.default_view = AsciiView;
    })();
    class MathMLView extends MathTextView {
        get styled_text() {
            let styled = this.text.trim();
            let matches = styled.match(/<math(.*?[^?])?>/s);
            if (matches == null) {
                return this.text.trim();
            }
            styled = (0, string_1.insert_text_on_position)(styled, styled.indexOf(matches[0]) + matches[0].length, `<mstyle displaystyle="true" mathcolor="${(0, color_1.color2hexrgb)(this.color)}" ${this.font.includes("bold") ? 'mathvariant="bold"' : ""}>`);
            matches = styled.match(/<\/[^>]*?math.*?>/s);
            if (matches == null) {
                return this.text.trim();
            }
            return (0, string_1.insert_text_on_position)(styled, styled.indexOf(matches[0]), "</mstyle>");
        }
        _process_text() {
            const fmetrics = (0, text_1.font_metrics)(this.font);
            return this.provider.MathJax?.mathml2svg(this.styled_text, {
                em: this.base_font_size,
                ex: fmetrics.x_height,
            });
        }
    }
    exports.MathMLView = MathMLView;
    MathMLView.__name__ = "MathMLView";
    class MathML extends MathText {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.MathML = MathML;
    _b = MathML;
    MathML.__name__ = "MathML";
    (() => {
        _b.prototype.default_view = MathMLView;
    })();
    class TeXView extends MathTextView {
        get styled_text() {
            const [r, g, b] = (0, color_1.color2rgba)(this.color);
            return `\\color[RGB]{${r}, ${g}, ${b}} ${this.font.includes("bold") ? `\\boldsymbol{${this.text}}` : this.text}`;
        }
        _process_text() {
            // TODO: allow plot/document level configuration of macros
            const fmetrics = (0, text_1.font_metrics)(this.font);
            return this.provider.MathJax?.tex2svg(this.styled_text, {
                display: !this.model.inline,
                em: this.base_font_size,
                ex: fmetrics.x_height,
            }, (0, object_1.to_object)(this.model.macros));
        }
    }
    exports.TeXView = TeXView;
    TeXView.__name__ = "TeXView";
    class TeX extends MathText {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.TeX = TeX;
    _c = TeX;
    TeX.__name__ = "TeX";
    (() => {
        _c.prototype.default_view = TeXView;
        _c.define(({ Bool, Float, Str, Dict, Tuple, Or }) => ({
            macros: [Dict(Or(Str, Tuple(Str, Float))), {}],
            inline: [Bool, false],
        }));
    })();
},
/* core/util/image.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.load_image = load_image;
    const logging_1 = require(20) /* ../logging */;
    async function load_image(url, options) {
        return new ImageLoader(url, options).promise;
    }
    class ImageLoader {
        constructor(src, config = {}) {
            this.image = new Image();
            this._finished = false;
            const { attempts = 1, timeout = 1 } = config;
            const url = (() => {
                if (src instanceof ArrayBuffer) {
                    const blob = new Blob([src], { type: "image/png" }); // TODO mime
                    return URL.createObjectURL(blob); // TODO revoke
                }
                else {
                    return src;
                }
            })();
            this.promise = new Promise((resolve, _reject) => {
                this.image.crossOrigin = "anonymous";
                let retries = 0;
                this.image.onerror = () => {
                    if (++retries == attempts) {
                        const message = `unable to load ${url} image after ${attempts} attempts`;
                        logging_1.logger.warn(message);
                        if (this.image.crossOrigin != null) {
                            logging_1.logger.warn(`attempting to load ${url} without a cross origin policy`);
                            this.image.crossOrigin = null;
                            retries = 0;
                        }
                        else {
                            config.failed?.();
                            return; // XXX reject(new Error(message))
                        }
                    }
                    setTimeout(() => this.image.src = url, timeout);
                };
                this.image.onload = () => {
                    this._finished = true;
                    config.loaded?.(this.image);
                    resolve(this.image);
                };
                this.image.src = url;
            });
        }
        get finished() {
            return this._finished;
        }
    }
    exports.ImageLoader = ImageLoader;
    ImageLoader.__name__ = "ImageLoader";
},
/* core/graphics.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const bbox_1 = require(64) /* ./util/bbox */;
    const text_1 = require(181) /* ./util/text */;
    const array_1 = require(10) /* ./util/array */;
    const types_1 = require(8) /* ./util/types */;
    const affine_1 = require(114) /* ./util/affine */;
    const color_1 = require(23) /* ./util/color */;
    exports.text_width = (() => {
        const canvas = document.createElement("canvas");
        const ctx = canvas.getContext("2d");
        let current_font = "";
        return (text, font) => {
            if (font != current_font) {
                current_font = font;
                ctx.font = font;
            }
            return ctx.measureText(text).width;
        };
    })();
    class GraphicsBox {
        constructor() {
            this._position = { sx: 0, sy: 0 };
            this.font_size_scale = 1.0;
            this.align = "left";
            this._base_font_size = 13; // the same as :host's font-size (13px)
            this._x_anchor = "left";
            this._y_anchor = "center";
        }
        set base_font_size(v) {
            if (v != null) {
                this._base_font_size = v;
            }
        }
        get base_font_size() {
            return this._base_font_size;
        }
        set position(p) {
            this._position = p;
        }
        get position() {
            return this._position;
        }
        infer_text_height() {
            return "ascent_descent";
        }
        bbox() {
            const { p0, p1, p2, p3 } = this.rect();
            const left = Math.min(p0.x, p1.x, p2.x, p3.x);
            const top = Math.min(p0.y, p1.y, p2.y, p3.y);
            const right = Math.max(p0.x, p1.x, p2.x, p3.x);
            const bottom = Math.max(p0.y, p1.y, p2.y, p3.y);
            return new bbox_1.BBox({ left, right, top, bottom });
        }
        size() {
            const { width, height } = this._size();
            const { angle } = this;
            if (angle == null || angle == 0) {
                return { width, height };
            }
            else {
                const c = Math.cos(Math.abs(angle));
                const s = Math.sin(Math.abs(angle));
                return {
                    width: Math.abs(width * c + height * s),
                    height: Math.abs(width * s + height * c),
                };
            }
        }
        rect() {
            const rect = this._rect();
            const { angle } = this;
            if (angle == null || angle == 0) {
                return rect;
            }
            else {
                const { sx, sy } = this.position;
                const tr = new affine_1.AffineTransform();
                tr.translate(sx, sy);
                tr.rotate(angle);
                tr.translate(-sx, -sy);
                return tr.apply_rect(rect);
            }
        }
        paint_rect(ctx) {
            const { p0, p1, p2, p3 } = this.rect();
            ctx.save();
            ctx.strokeStyle = "red";
            ctx.lineWidth = 1;
            ctx.beginPath();
            const { round } = Math;
            ctx.moveTo(round(p0.x), round(p0.y));
            ctx.lineTo(round(p1.x), round(p1.y));
            ctx.lineTo(round(p2.x), round(p2.y));
            ctx.lineTo(round(p3.x), round(p3.y));
            ctx.closePath();
            ctx.stroke();
            ctx.restore();
        }
        paint_bbox(ctx) {
            const { x, y, width, height } = this.bbox();
            ctx.save();
            ctx.strokeStyle = "blue";
            ctx.lineWidth = 1;
            ctx.beginPath();
            const { round } = Math;
            ctx.moveTo(round(x), round(y));
            ctx.lineTo(round(x), round(y + height));
            ctx.lineTo(round(x + width), round(y + height));
            ctx.lineTo(round(x + width), round(y));
            ctx.closePath();
            ctx.stroke();
            ctx.restore();
        }
    }
    exports.GraphicsBox = GraphicsBox;
    GraphicsBox.__name__ = "GraphicsBox";
    class TextBox extends GraphicsBox {
        set visuals(v) {
            const color = v.color;
            const alpha = v.alpha;
            const outline_color = v.outline_color;
            const style = v.font_style;
            let size = v.font_size;
            const face = v.font;
            const { font_size_scale, base_font_size } = this;
            const res = (0, text_1.parse_css_font_size)(size);
            if (res != null) {
                let { value, unit } = res;
                value *= font_size_scale;
                if (unit == "em" && base_font_size != 0) {
                    value *= base_font_size;
                    unit = "px";
                }
                size = `${value}${unit}`;
            }
            const font = `${style} ${size} ${face}`;
            this.font = font;
            this.color = (0, color_1.color2css)(color, alpha);
            this.outline_color = (0, color_1.color2css)(outline_color, alpha);
            this.line_height = v.line_height;
            const align = v.align;
            this._visual_align = align;
            this._x_anchor = align;
            const baseline = v.baseline;
            this._y_anchor = (() => {
                switch (baseline) {
                    case "top": return "top";
                    case "middle": return "center";
                    case "bottom": return "bottom";
                    default: return "baseline";
                }
            })();
        }
        constructor({ text }) {
            super();
            //padding: Padding
            this._visual_align = "left";
            this.text = text;
        }
        infer_text_height() {
            if (this.text.includes("\n")) {
                return "ascent_descent";
            }
            else {
                function is_math_like(text) {
                    for (const c of new Set(text)) {
                        if ("0" <= c && c <= "9") {
                            continue;
                        }
                        switch (c) {
                            case ",":
                            case ".":
                            case "+":
                            case "-":
                            case "\u2212":
                            case "e":
                                continue;
                            default:
                                return false;
                        }
                    }
                    return true;
                }
                if (is_math_like(this.text)) {
                    return "cap";
                }
                else {
                    return "ascent_descent";
                }
            }
        }
        _text_line(fmetrics) {
            const metric = this.text_height_metric ?? this.infer_text_height();
            const ascent = (() => {
                switch (metric) {
                    case "x":
                    case "x_descent":
                        return fmetrics.x_height;
                    case "cap":
                    case "cap_descent":
                        return fmetrics.cap_height;
                    case "ascent":
                    case "ascent_descent":
                        return fmetrics.ascent;
                }
            })();
            const descent = (() => {
                switch (metric) {
                    case "x":
                    case "cap":
                    case "ascent":
                        return 0;
                    case "x_descent":
                    case "cap_descent":
                    case "ascent_descent":
                        return fmetrics.descent;
                }
            })();
            return { height: ascent + descent, ascent, descent };
        }
        get nlines() {
            const lines = this.text.split("\n");
            return lines.length;
        }
        _size() {
            const { font } = this;
            const fmetrics = (0, text_1.font_metrics)(font);
            const line_spacing = (this.line_height - 1) * fmetrics.height; // TODO: max(trailing(L[n-1]), leading(L[n]))
            const empty = this.text == "";
            const lines = this.text.split("\n");
            const nlines = lines.length;
            const widths = lines.map((line) => (0, exports.text_width)(line, font));
            const text_line = this._text_line(fmetrics);
            const text_height = text_line.height * nlines;
            /*
            const heights: number[] = []
            const ascents: number[] = []
            const descents: number[] = []
        
            for (const line of lines) {
              const metrics = [...line].map((c) => glyph_metrics(c, font))
              const max_ascent = Math.max(max(metrics.map((m) => m.ascent)), fmetrics.cap_height)
              const max_descent = max(metrics.map((m) => m.descent))
              ascents.push(max_ascent)
              descents.push(max_descent)
              heights.push(max_ascent + max_descent)
            }
        
            const text_height = sum(heights)
            */
            const w_scale = this.width?.unit == "%" ? this.width.value : 1;
            const h_scale = this.height?.unit == "%" ? this.height.value : 1;
            const width = (0, array_1.max)(widths) * w_scale;
            const height = empty ? 0 : (text_height + line_spacing * (nlines - 1)) * h_scale;
            return { width, height, metrics: fmetrics };
        }
        _computed_position(size, metrics, nlines) {
            const { width, height } = size;
            const { sx, sy, x_anchor = this._x_anchor, y_anchor = this._y_anchor } = this.position;
            const x = sx - (() => {
                if ((0, types_1.isNumber)(x_anchor)) {
                    return x_anchor * width;
                }
                else {
                    switch (x_anchor) {
                        case "left": return 0;
                        case "center": return 0.5 * width;
                        case "right": return width;
                    }
                }
            })();
            const y = sy - (() => {
                if ((0, types_1.isNumber)(y_anchor)) {
                    return y_anchor * height;
                }
                else {
                    switch (y_anchor) {
                        case "top": return 0;
                        case "center": return 0.5 * height;
                        case "bottom": return height;
                        case "baseline": {
                            if (nlines == 1) {
                                const metric = this.text_height_metric ?? this.infer_text_height();
                                switch (metric) {
                                    case "x":
                                    case "x_descent":
                                        return metrics.x_height;
                                    case "cap":
                                    case "cap_descent":
                                        return metrics.cap_height;
                                    case "ascent":
                                    case "ascent_descent":
                                        return metrics.ascent;
                                }
                            }
                            else {
                                return 0.5 * height;
                            }
                        }
                    }
                }
            })();
            return { x, y };
        }
        _rect() {
            const { width, height, metrics } = this._size();
            const nlines = this.text.split("\n").length;
            const { x, y } = this._computed_position({ width, height }, metrics, nlines);
            const bbox = new bbox_1.BBox({ x, y, width, height });
            return bbox.rect;
        }
        paint(ctx) {
            const { font } = this;
            const fmetrics = (0, text_1.font_metrics)(font);
            const line_spacing = (this.line_height - 1) * fmetrics.height; // TODO: see above
            const lines = this.text.split("\n");
            const nlines = lines.length;
            const widths = lines.map((line) => (0, exports.text_width)(line, font));
            const text_line = this._text_line(fmetrics);
            const text_height = text_line.height * nlines;
            /*
            const heights: number[] = []
            const ascents: number[] = []
            const descents: number[] = []
        
            for (const line of lines) {
              const metrics = [...line].map((c) => glyph_metrics(c, font))
              const max_ascent = Math.max(max(metrics.map((m) => m.ascent)), fmetrics.cap_height)
              const max_descent = max(metrics.map((m) => m.descent))
              ascents.push(max_ascent)
              descents.push(max_descent)
              heights.push(max_ascent + max_descent)
            }
            */
            const w_scale = this.width?.unit == "%" ? this.width.value : 1;
            const h_scale = this.height?.unit == "%" ? this.height.value : 1;
            const width = (0, array_1.max)(widths) * w_scale;
            const height = (text_height + line_spacing * (nlines - 1)) * h_scale;
            ctx.save();
            ctx.fillStyle = this.color;
            ctx.strokeStyle = this.outline_color;
            ctx.font = this.font;
            ctx.textAlign = "left";
            ctx.textBaseline = "alphabetic";
            const { sx, sy } = this.position;
            const { align } = this;
            const { angle } = this;
            if (angle != null && angle != 0) {
                ctx.translate(sx, sy);
                ctx.rotate(angle);
                ctx.translate(-sx, -sy);
            }
            let { x, y } = this._computed_position({ width, height }, fmetrics, nlines);
            if (align == "justify") {
                for (let i = 0; i < nlines; i++) {
                    let xij = x;
                    const line = lines[i];
                    const words = line.split(" ");
                    const nwords = words.length;
                    const word_widths = words.map((word) => (0, exports.text_width)(word, font));
                    const word_spacing = (width - (0, array_1.sum)(word_widths)) / (nwords - 1);
                    for (let j = 0; j < nwords; j++) {
                        ctx.fillText(words[j], xij, y);
                        ctx.strokeText(words[j], xij, y);
                        xij += word_widths[j] + word_spacing;
                    }
                    y += /*heights[i]*/ text_line.height + line_spacing;
                }
            }
            else {
                for (let i = 0; i < nlines; i++) {
                    const xi = x + (() => {
                        switch (align == "auto" ? this._visual_align : align) {
                            case "left": return 0;
                            case "center": return 0.5 * (width - widths[i]);
                            case "right": return width - widths[i];
                        }
                    })();
                    const linei = lines[i];
                    const yi = y + /*ascents[i]*/ text_line.ascent;
                    ctx.fillText(linei, xi, yi);
                    ctx.strokeText(linei, xi, yi);
                    y += /*heights[i]*/ text_line.height + line_spacing;
                }
            }
            ctx.restore();
        }
    }
    exports.TextBox = TextBox;
    TextBox.__name__ = "TextBox";
    class BaseExpo extends GraphicsBox {
        constructor(base, expo) {
            super();
            this.base = base;
            this.expo = expo;
        }
        get children() {
            return [this.base, this.expo];
        }
        set base_font_size(v) {
            super.base_font_size = v;
            this.base.base_font_size = v;
            this.expo.base_font_size = v;
        }
        set position(p) {
            this._position = p;
            const bs = this.base.size();
            const es = this.expo.size();
            const shift = this._shift_scale() * bs.height;
            const height = Math.max(bs.height, shift + es.height);
            this.base.position = {
                sx: 0, x_anchor: "left",
                sy: height, y_anchor: "bottom",
            };
            this.expo.position = {
                sx: bs.width, x_anchor: "left",
                sy: shift, y_anchor: "bottom",
            };
        }
        get position() {
            return this._position;
        }
        set visuals(v) {
            this.expo.font_size_scale = 0.7;
            this.base.visuals = v;
            this.expo.visuals = v;
        }
        _shift_scale() {
            if (this.base instanceof TextBox && this.base.nlines == 1) {
                const { x_height, cap_height } = (0, text_1.font_metrics)(this.base.font);
                return x_height / cap_height;
            }
            else {
                return 2 / 3;
            }
        }
        infer_text_height() {
            return this.base.infer_text_height();
        }
        _rect() {
            const bb = this.base.bbox();
            const eb = this.expo.bbox();
            const bbox = bb.union(eb);
            const { x, y } = this._computed_position();
            return bbox.translate(x, y).rect;
        }
        _size() {
            const bs = this.base.size();
            const es = this.expo.size();
            return {
                width: bs.width + es.width,
                height: Math.max(bs.height, this._shift_scale() * bs.height + es.height),
            };
        }
        paint(ctx) {
            ctx.save();
            const { angle } = this;
            if (angle