# Interface methods for submodule: Histogram
from typing import Union, Any
# additional imports
from .support.template_class import itkTemplate as _itkTemplate



# Interface methods for class: Histogram
class HistogramProxy():
	def GetNameOfClass(self):
		""""""
		...

	@staticmethod
	def New():
		""""""
		...

	def Clone(self):
		""""""
		...

	@overload
	def Initialize(self, size: Sequence[int]) -> None:
		""""""
		...

	@overload
	def Initialize(self, size: Sequence[int], lowerBound: Sequence[float], upperBound: Sequence[float]) -> None:
		""""""
		...

	def SetToZero(self) -> None:
		""""""
		...

	@overload
	def GetIndex(self, measurement: Sequence[float], index: Sequence[int]) -> bool:
		""""""
		...

	@overload
	def GetIndex(self, id: int) -> Sequence[int]:
		""""""
		...

	def GetClipBinsAtEnds(self) -> bool:
		""""""
		...

	def SetClipBinsAtEnds(self, _arg: bool) -> None:
		""""""
		...

	def ClipBinsAtEndsOn(self) -> None:
		""""""
		...

	def ClipBinsAtEndsOff(self) -> None:
		""""""
		...

	def IsIndexOutOfBounds(self, index: Sequence[int]) -> bool:
		""""""
		...

	def GetInstanceIdentifier(self, index: Sequence[int]) -> int:
		""""""
		...

	def Size(self) -> int:
		""""""
		...

	@overload
	def GetSize(self) -> Sequence[int]:
		""""""
		...

	@overload
	def GetSize(self, dimension: int) -> int:
		""""""
		...

	def GetBinMin(self, dimension: int, nbin: int) -> float:
		""""""
		...

	def GetBinMax(self, dimension: int, nbin: int) -> float:
		""""""
		...

	def SetBinMin(self, dimension: int, nbin: int, min: float) -> None:
		""""""
		...

	def SetBinMax(self, dimension: int, nbin: int, max: float) -> None:
		""""""
		...

	def GetBinMinFromValue(self, dimension: int, value: float) -> float:
		""""""
		...

	def GetBinMaxFromValue(self, dimension: int, value: float) -> float:
		""""""
		...

	def GetDimensionMins(self, dimension: int) -> Sequence[float]:
		""""""
		...

	def GetDimensionMaxs(self, dimension: int) -> Sequence[float]:
		""""""
		...

	def GetMins(self):
		""""""
		...

	def GetMaxs(self):
		""""""
		...

	def GetHistogramMinFromIndex(self, index: Sequence[int]) -> Sequence[float]:
		""""""
		...

	def GetHistogramMaxFromIndex(self, index: Sequence[int]) -> Sequence[float]:
		""""""
		...

	@overload
	def GetFrequency(self, id: int) -> int:
		""""""
		...

	@overload
	def GetFrequency(self, index: Sequence[int]) -> int:
		""""""
		...

	@overload
	def GetFrequency(self, n: int, dimension: int) -> int:
		""""""
		...

	@overload
	def SetFrequency(self, value: int) -> None:
		""""""
		...

	@overload
	def SetFrequency(self, id: int, value: int) -> bool:
		""""""
		...

	def SetFrequencyOfIndex(self, index: Sequence[int], value: int) -> bool:
		""""""
		...

	def SetFrequencyOfMeasurement(self, measurement: Sequence[float], value: int) -> bool:
		""""""
		...

	def IncreaseFrequency(self, id: int, value: int) -> bool:
		""""""
		...

	def IncreaseFrequencyOfIndex(self, index: Sequence[int], value: int) -> bool:
		""""""
		...

	def IncreaseFrequencyOfMeasurement(self, measurement: Sequence[float], value: int) -> bool:
		""""""
		...

	@overload
	def GetMeasurementVector(self, id: int) -> Sequence[float]:
		""""""
		...

	@overload
	def GetMeasurementVector(self, index: Sequence[int]) -> Sequence[float]:
		""""""
		...

	def GetMeasurement(self, n: int, dimension: int) -> float:
		""""""
		...

	def GetTotalFrequency(self) -> int:
		""""""
		...

	def Quantile(self, dimension: int, p: float) -> float:
		""""""
		...

	def Mean(self, dimension: int) -> float:
		""""""
		...

	def Graft(self, arg0) -> None:
		""""""
		...

