import * as mixins from "../../core/property_mixins";
import type * as visuals from "../../core/visuals";
import * as p from "../../core/properties";
import { Signal0 } from "../../core/signaling";
import type { Place } from "../../core/enums";
import { Location, OutputBackend, ResetPolicy, WindowAxis } from "../../core/enums";
import type { LRTB } from "../../core/util/bbox";
import type { Dict } from "../../core/types";
import { LayoutDOM } from "../layouts/layout_dom";
import { Axis } from "../axes/axis";
import { Grid } from "../grids/grid";
import type { GuideRenderer } from "../renderers/guide_renderer";
import { Annotation } from "../annotations/annotation";
import { Title } from "../annotations/title";
import { Toolbar } from "../tools/toolbar";
import { HTML } from "../dom/html";
import { Range } from "../ranges/range";
import { Scale } from "../scales/scale";
import type { Glyph } from "../glyphs/glyph";
import type { ColumnarDataSource } from "../sources/columnar_data_source";
import { Renderer } from "../renderers/renderer";
import { DataRenderer } from "../renderers/data_renderer";
import { GlyphRenderer } from "../renderers/glyph_renderer";
import type { ToolAliases } from "../tools/tool";
import { Tool } from "../tools/tool";
import { PlotView } from "./plot_canvas";
export { PlotView };
export declare namespace Plot {
    type Attrs = p.AttrsOf<Props>;
    type Props = LayoutDOM.Props & {
        toolbar: p.Property<Toolbar>;
        toolbar_location: p.Property<Location | null>;
        toolbar_sticky: p.Property<boolean>;
        toolbar_inner: p.Property<boolean>;
        frame_width: p.Property<number | null>;
        frame_height: p.Property<number | null>;
        frame_align: p.Property<boolean | Partial<LRTB<boolean>>>;
        title: p.Property<Title | string | null>;
        title_location: p.Property<Location | null>;
        above: p.Property<(Annotation | Axis)[]>;
        below: p.Property<(Annotation | Axis)[]>;
        left: p.Property<(Annotation | Axis)[]>;
        right: p.Property<(Annotation | Axis)[]>;
        center: p.Property<(Annotation | Grid)[]>;
        renderers: p.Property<Renderer[]>;
        x_range: p.Property<Range>;
        y_range: p.Property<Range>;
        x_scale: p.Property<Scale>;
        y_scale: p.Property<Scale>;
        extra_x_ranges: p.Property<Dict<Range>>;
        extra_y_ranges: p.Property<Dict<Range>>;
        extra_x_scales: p.Property<Dict<Scale>>;
        extra_y_scales: p.Property<Dict<Scale>>;
        window_axis: p.Property<WindowAxis>;
        lod_factor: p.Property<number>;
        lod_interval: p.Property<number>;
        lod_threshold: p.Property<number | null>;
        lod_timeout: p.Property<number>;
        hidpi: p.Property<boolean>;
        output_backend: p.Property<OutputBackend>;
        min_border: p.Property<number | null>;
        min_border_top: p.Property<number | null>;
        min_border_left: p.Property<number | null>;
        min_border_bottom: p.Property<number | null>;
        min_border_right: p.Property<number | null>;
        inner_width: p.Property<number>;
        inner_height: p.Property<number>;
        outer_width: p.Property<number>;
        outer_height: p.Property<number>;
        match_aspect: p.Property<boolean>;
        aspect_scale: p.Property<number>;
        reset_policy: p.Property<ResetPolicy>;
        hold_render: p.Property<boolean>;
        attribution: p.Property<(string | HTML)[]>;
    } & Mixins;
    type Mixins = mixins.OutlineLine & mixins.BackgroundFill & mixins.BackgroundHatch & mixins.BorderFill & mixins.BorderHatch;
    type Visuals = visuals.Visuals & {
        outline_line: visuals.Line;
        background_fill: visuals.Fill;
        background_hatch: visuals.Hatch;
        border_fill: visuals.Fill;
        border_hatch: visuals.Hatch;
    };
}
export interface Plot extends Plot.Attrs {
}
export declare class Plot extends LayoutDOM {
    properties: Plot.Props;
    __view_type__: PlotView;
    readonly use_map: boolean;
    readonly reset: Signal0<this>;
    constructor(attrs?: Partial<Plot.Attrs>);
    add_layout(renderer: Annotation | GuideRenderer, side?: Place): void;
    remove_layout(renderer: Annotation | GuideRenderer): void;
    get data_renderers(): DataRenderer[];
    add_renderers(...renderers: Renderer[]): void;
    add_glyph<BaseGlyph extends Glyph>(glyph: BaseGlyph, source?: ColumnarDataSource, attrs?: Partial<GlyphRenderer.Attrs<BaseGlyph>>): GlyphRenderer<BaseGlyph>;
    add_tools(...tools: (Tool | keyof ToolAliases)[]): void;
    remove_tools(...tools: Tool[]): void;
    get panels(): (Annotation | Axis | Grid)[];
    get side_panels(): (Annotation | Axis)[];
}
//# sourceMappingURL=plot.d.ts.map