# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Dict, List
from typing_extensions import Literal, Required, Annotated, TypedDict

from ..._utils import PropertyInfo

__all__ = ["ScanCreateParams"]


class ScanCreateParams(TypedDict, total=False):
    account_id: Required[str]
    """Account ID."""

    url: Required[str]

    country: Literal[
        "AF",
        "AL",
        "DZ",
        "AD",
        "AO",
        "AG",
        "AR",
        "AM",
        "AU",
        "AT",
        "AZ",
        "BH",
        "BD",
        "BB",
        "BY",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BO",
        "BA",
        "BW",
        "BR",
        "BN",
        "BG",
        "BF",
        "BI",
        "KH",
        "CM",
        "CA",
        "CV",
        "KY",
        "CF",
        "TD",
        "CL",
        "CN",
        "CO",
        "KM",
        "CG",
        "CR",
        "CI",
        "HR",
        "CU",
        "CY",
        "CZ",
        "CD",
        "DK",
        "DJ",
        "DM",
        "DO",
        "EC",
        "EG",
        "SV",
        "GQ",
        "ER",
        "EE",
        "SZ",
        "ET",
        "FJ",
        "FI",
        "FR",
        "GA",
        "GE",
        "DE",
        "GH",
        "GR",
        "GL",
        "GD",
        "GT",
        "GN",
        "GW",
        "GY",
        "HT",
        "HN",
        "HU",
        "IS",
        "IN",
        "ID",
        "IR",
        "IQ",
        "IE",
        "IL",
        "IT",
        "JM",
        "JP",
        "JO",
        "KZ",
        "KE",
        "KI",
        "KW",
        "KG",
        "LA",
        "LV",
        "LB",
        "LS",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MO",
        "MG",
        "MW",
        "MY",
        "MV",
        "ML",
        "MR",
        "MU",
        "MX",
        "FM",
        "MD",
        "MC",
        "MN",
        "MS",
        "MA",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NL",
        "NZ",
        "NI",
        "NE",
        "NG",
        "KP",
        "MK",
        "NO",
        "OM",
        "PK",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PH",
        "PL",
        "PT",
        "QA",
        "RO",
        "RU",
        "RW",
        "SH",
        "KN",
        "LC",
        "VC",
        "WS",
        "SM",
        "ST",
        "SA",
        "SN",
        "RS",
        "SC",
        "SL",
        "SK",
        "SI",
        "SB",
        "SO",
        "ZA",
        "KR",
        "SS",
        "ES",
        "LK",
        "SD",
        "SR",
        "SE",
        "CH",
        "SY",
        "TW",
        "TJ",
        "TZ",
        "TH",
        "BS",
        "GM",
        "TL",
        "TG",
        "TO",
        "TT",
        "TN",
        "TR",
        "TM",
        "UG",
        "UA",
        "AE",
        "GB",
        "US",
        "UY",
        "UZ",
        "VU",
        "VE",
        "VN",
        "YE",
        "ZM",
        "ZW",
    ]
    """Country to geo egress from"""

    customagent: str

    custom_headers: Annotated[Dict[str, str], PropertyInfo(alias="customHeaders")]
    """Set custom headers."""

    referer: str

    screenshots_resolutions: Annotated[
        List[Literal["desktop", "mobile", "tablet"]], PropertyInfo(alias="screenshotsResolutions")
    ]
    """Take multiple screenshots targeting different device types."""

    visibility: Literal["Public", "Unlisted"]
    """
    The option `Public` means it will be included in listings like recent scans and
    search results. `Unlisted` means it will not be included in the aforementioned
    listings, users will need to have the scan's ID to access it. A a scan will be
    automatically marked as unlisted if it fails, if it contains potential PII or
    other sensitive material.
    """
