from _typeshed import IdentityFunction, Unused
from collections.abc import Callable, Iterator, MutableMapping, Sequence
from contextlib import AbstractContextManager
from threading import Condition
from typing import Any, Generic, Literal, NamedTuple, TypeVar, overload
from typing_extensions import Self, deprecated

__all__ = ("Cache", "FIFOCache", "LFUCache", "LRUCache", "RRCache", "TLRUCache", "TTLCache", "cached", "cachedmethod")
__version__: str

_KT = TypeVar("_KT")
_VT = TypeVar("_VT")
_T = TypeVar("_T")
_R = TypeVar("_R")

class Cache(MutableMapping[_KT, _VT]):
    @overload
    def __init__(self, maxsize: float, getsizeof: Callable[[_VT], float]) -> None: ...
    @overload
    def __init__(self, maxsize: float, getsizeof: None = None) -> None: ...
    def __getitem__(self, key: _KT) -> _VT: ...
    def __setitem__(self, key: _KT, value: _VT) -> None: ...
    def __delitem__(self, key: _KT) -> None: ...
    def __missing__(self, key: _KT) -> _VT: ...
    def __iter__(self) -> Iterator[_KT]: ...
    def __len__(self) -> int: ...
    @overload
    def pop(self, key: _KT) -> _VT: ...
    @overload
    def pop(self, key: _KT, default: _VT | _T) -> _VT | _T: ...
    def setdefault(self, key: _KT, default: _VT | None = None) -> _VT: ...
    @property
    def maxsize(self) -> float: ...
    @property
    def currsize(self) -> float: ...
    @staticmethod
    def getsizeof(value: _VT) -> float: ...

class FIFOCache(Cache[_KT, _VT]): ...
class LFUCache(Cache[_KT, _VT]): ...
class LRUCache(Cache[_KT, _VT]): ...

class RRCache(Cache[_KT, _VT]):
    @overload
    def __init__(self, maxsize: float, choice: None = None, getsizeof: None = None) -> None: ...
    @overload
    def __init__(self, maxsize: float, *, getsizeof: Callable[[_VT], float]) -> None: ...
    @overload
    def __init__(self, maxsize: float, choice: None, getsizeof: Callable[[_VT], float]) -> None: ...
    @overload
    def __init__(self, maxsize: float, choice: Callable[[Sequence[_KT]], _KT], getsizeof: None = None) -> None: ...
    @overload
    def __init__(self, maxsize: float, choice: Callable[[Sequence[_KT]], _KT], getsizeof: Callable[[_VT], float]) -> None: ...
    @property
    def choice(self) -> Callable[[Sequence[_KT]], _KT]: ...
    def __setitem__(self, key: _KT, value: _VT, cache_setitem: Callable[[Self, _KT, _VT], None] = ...) -> None: ...
    def __delitem__(self, key: _KT, cache_delitem: Callable[[Self, _KT], None] = ...) -> None: ...

class _TimedCache(Cache[_KT, _VT]):
    @overload
    def __init__(self, maxsize: float, timer: Callable[[], float] = ..., getsizeof: None = None) -> None: ...
    @overload
    def __init__(self, maxsize: float, timer: Callable[[], float], getsizeof: Callable[[_VT], float]) -> None: ...
    @overload
    def __init__(self, maxsize: float, timer: Callable[[], float] = ..., *, getsizeof: Callable[[_VT], float]) -> None: ...
    @property
    def currsize(self) -> float: ...

    class _Timer:
        def __init__(self, timer: Callable[[], float]) -> None: ...
        def __call__(self) -> float: ...
        def __enter__(self) -> float: ...
        def __exit__(self, *exc: Unused) -> None: ...

    @property
    def timer(self) -> _Timer: ...

class TTLCache(_TimedCache[_KT, _VT]):
    @overload
    def __init__(self, maxsize: float, ttl: float, timer: Callable[[], float] = ..., getsizeof: None = None) -> None: ...
    @overload
    def __init__(self, maxsize: float, ttl: float, timer: Callable[[], float], getsizeof: Callable[[_VT], float]) -> None: ...
    @overload
    def __init__(
        self, maxsize: float, ttl: float, timer: Callable[[], float] = ..., *, getsizeof: Callable[[_VT], float]
    ) -> None: ...
    @property
    def ttl(self) -> float: ...
    def expire(self, time: float | None = None) -> list[tuple[_KT, _VT]]: ...

class TLRUCache(_TimedCache[_KT, _VT]):
    def __init__(
        self,
        maxsize: float,
        ttu: Callable[[_KT, _VT, float], float],
        timer: Callable[[], float] = ...,
        getsizeof: Callable[[_VT], float] | None = None,
    ) -> None: ...
    @property
    def ttu(self) -> Callable[[_KT, _VT, float], float]: ...
    def expire(self, time: float | None = None) -> list[tuple[_KT, _VT]]: ...

class _CacheInfo(NamedTuple):
    hits: int
    misses: int
    maxsize: int | None
    currsize: int

class _cached_wrapper(Generic[_R]):
    __wrapped__: Callable[..., _R]
    def __call__(self, /, *args: Any, **kwargs: Any) -> _R: ...

class _cached_wrapper_info(_cached_wrapper[_R]):
    def cache_info(self) -> _CacheInfo: ...
    def cache_clear(self) -> None: ...

@overload
def cached(
    cache: MutableMapping[_KT, Any] | None,
    key: Callable[..., _KT] = ...,
    lock: AbstractContextManager[Any] | None = None,
    condition: Condition | None = None,
    info: Literal[True] = ...,
) -> Callable[[Callable[..., _R]], _cached_wrapper_info[_R]]: ...
@overload
def cached(
    cache: MutableMapping[_KT, Any] | None,
    key: Callable[..., _KT] = ...,
    lock: AbstractContextManager[Any] | None = None,
    condition: Condition | None = None,
    info: Literal[False] = ...,
) -> Callable[[Callable[..., _R]], _cached_wrapper[_R]]: ...
@overload
@deprecated("Passing `info` as positional parameter is deprecated.")
def cached(
    cache: MutableMapping[_KT, Any] | None,
    key: Callable[..., _KT] = ...,
    lock: AbstractContextManager[Any] | None = None,
    condition: Literal[True] = ...,
) -> Callable[[Callable[..., _R]], _cached_wrapper_info[_R]]: ...
@overload
@deprecated("Passing `info` as positional parameter is deprecated.")
def cached(
    cache: MutableMapping[_KT, Any] | None,
    key: Callable[..., _KT] = ...,
    lock: AbstractContextManager[Any] | None = None,
    condition: Literal[False] | None = ...,
) -> Callable[[Callable[..., _R]], _cached_wrapper[_R]]: ...
def cachedmethod(
    cache: Callable[[Any], MutableMapping[_KT, Any] | None],
    key: Callable[..., _KT] = ...,
    lock: Callable[[Any], AbstractContextManager[Any]] | None = None,
    condition: Condition | None = None,
) -> IdentityFunction: ...
