class ClientMixin:
    def get_default_redirect_uri(self): ...
    def get_client_secret(self): ...
    def get_rsa_public_key(self): ...

class TokenCredentialMixin:
    def get_oauth_token(self): ...
    def get_oauth_token_secret(self): ...

class TemporaryCredentialMixin(TokenCredentialMixin):
    def get_client_id(self): ...
    def get_redirect_uri(self): ...
    def check_verifier(self, verifier) -> bool: ...

class TemporaryCredential(dict[str, object], TemporaryCredentialMixin):
    def get_client_id(self): ...
    def get_user_id(self): ...
    def get_redirect_uri(self): ...
    def check_verifier(self, verifier): ...
    def get_oauth_token(self): ...
    def get_oauth_token_secret(self): ...
