from _typeshed import Incomplete
from typing import Any, Literal, TypeVar

from antlr4.ParserRuleContext import ParserRuleContext, RuleContext
from antlr4.Token import Token as Token

INVALID_INTERVAL: Incomplete

class Tree: ...
class SyntaxTree(Tree): ...
class ParseTree(SyntaxTree): ...
class RuleNode(ParseTree): ...
class TerminalNode(ParseTree): ...
class ErrorNode(TerminalNode): ...

_GenericType = TypeVar("_GenericType", bound=type)

class ParseTreeVisitor:
    def visit(self, tree: Tree) -> None: ...
    def visitChildren(self, node) -> None: ...
    def visitTerminal(self, node: TerminalNode) -> None: ...
    def visitErrorNode(self, node: ErrorNode) -> None: ...
    def defaultResult(self) -> None: ...
    def aggregateResult(self, aggregate, nextResult: _GenericType) -> _GenericType: ...
    def shouldVisitNextChild(self, node, currentResult) -> Literal[True]: ...

class ParseTreeListener:
    def visitTerminal(self, node: TerminalNode) -> None: ...
    def visitErrorNode(self, node: ErrorNode) -> None: ...
    def enterEveryRule(self, ctx: ParserRuleContext) -> None: ...
    def exitEveryRule(self, ctx: ParserRuleContext) -> None: ...

class TerminalNodeImpl(TerminalNode):
    __slots__ = ("parentCtx", "symbol")
    parentCtx: RuleContext | None
    symbol: Token
    def __init__(self, symbol: Token) -> None: ...
    def __setattr__(self, key: str, value: Any) -> None: ...
    def getChild(self, i: int) -> None: ...
    def getSymbol(self) -> Token: ...
    def getParent(self) -> RuleContext | None: ...
    def getPayload(self) -> Token: ...
    def getSourceInterval(self) -> tuple[Literal[-1], Literal[-2]] | tuple[int | None, int | None]: ...
    def getChildCount(self) -> Literal[0]: ...
    def accept(self, visitor: ParseTreeVisitor) -> None: ...
    def getText(self) -> str: ...

class ErrorNodeImpl(TerminalNodeImpl, ErrorNode):
    def __init__(self, token: Token) -> None: ...
    def accept(self, visitor: ParseTreeVisitor) -> None: ...

class ParseTreeWalker:
    DEFAULT: ParseTreeWalker
    def walk(self, listener: ParseTreeListener, t: ParseTree) -> None: ...
    def enterRule(self, listener: ParseTreeListener, r: RuleNode) -> None: ...
    def exitRule(self, listener: ParseTreeListener, r: RuleNode) -> None: ...
