/*
 * Decompiled with CFR 0.152.
 */
package org.qore.jni.compiler;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import javax.tools.JavaFileObject;
import org.qore.jni.QoreURLClassLoader;
import org.qore.jni.compiler.CustomJavaFileObject;
import org.qore.jni.compiler.QoreJavaClassObject;

class PackageInternalsFinder {
    private QoreURLClassLoader classLoader;
    private static final String CLASS_FILE_EXTENSION = ".class";
    private final HashMap<String, HashSet<String>> pendingClasses = new HashMap();

    public PackageInternalsFinder(QoreURLClassLoader qoreURLClassLoader) {
        this.classLoader = qoreURLClassLoader;
    }

    public List<JavaFileObject> find(String string) throws IOException {
        ArrayList<JavaFileObject> arrayList = new ArrayList<JavaFileObject>();
        if (QoreURLClassLoader.isDynamic((String)string)) {
            for (String object : this.classLoader.getClassesInNamespace(string)) {
                arrayList.add(new QoreJavaClassObject(object, this.classLoader, 0));
            }
        }
        for (String string2 : this.classLoader.getPendingClassesForPackage(string)) {
            arrayList.add(new QoreJavaClassObject(string2, this.classLoader, 1));
        }
        if (string.startsWith("org.qore.jni")) {
            for (String string3 : this.classLoader.getInternalClassesForPackage(string)) {
                arrayList.add(new QoreJavaClassObject(string3, this.classLoader, 2));
            }
        }
        Iterator iterator = string.replaceAll("\\.", "/");
        for (URL uRL : this.classLoader.getURLs()) {
            arrayList.addAll(this.listUnder(string, uRL));
        }
        return arrayList;
    }

    private Collection<JavaFileObject> listUnder(String string, URL uRL) {
        File file = new File(uRL.getFile());
        if (file.isDirectory()) {
            return this.processDir(string, file);
        }
        return this.processJar(string, uRL);
    }

    private List<JavaFileObject> processJar(String string, URL uRL) {
        ArrayList<JavaFileObject> arrayList = new ArrayList<JavaFileObject>();
        try {
            URLConnection uRLConnection = uRL.openConnection();
            if (!(uRLConnection instanceof JarURLConnection)) {
                String string2;
                File file;
                URL uRL2 = uRLConnection.getURL();
                if (uRL2.getProtocol().equals("file") && (file = new File(string2 = URLDecoder.decode(uRL2.getPath(), StandardCharsets.UTF_8))).isDirectory()) {
                    return this.processDir(string, file);
                }
                return arrayList;
            }
            JarURLConnection jarURLConnection = (JarURLConnection)uRLConnection;
            String string3 = jarURLConnection.getEntryName();
            if (string3 == null) {
                string3 = string.replaceAll("\\.", "/");
            }
            int n = string3.length() + 1;
            String string4 = uRL.toExternalForm().split("!")[0];
            Enumeration<JarEntry> enumeration = jarURLConnection.getJarFile().entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                String string5 = jarEntry.getName();
                if (!string5.startsWith(string3) || string5.indexOf(47, n) != -1 || !string5.endsWith(CLASS_FILE_EXTENSION)) continue;
                URI uRI = URI.create(string4 + "!/" + string5);
                String string6 = string5.replaceAll("/", ".");
                string6 = string6.replaceAll(".class$", "");
                arrayList.add(new CustomJavaFileObject(string6, uRI));
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Wasn't able to open " + String.valueOf(uRL) + " as a jar file", exception);
        }
        return arrayList;
    }

    private List<JavaFileObject> processDir(String string, File file) {
        File[] fileArray;
        ArrayList<JavaFileObject> arrayList = new ArrayList<JavaFileObject>();
        for (File file2 : fileArray = file.listFiles()) {
            if (!file2.isFile() || !file2.getName().endsWith(CLASS_FILE_EXTENSION)) continue;
            Object object = string + "." + file2.getName();
            object = ((String)object).replaceAll(".class$", "");
            arrayList.add(new CustomJavaFileObject((String)object, file2.toURI()));
        }
        return arrayList;
    }
}

