
#line 1 "../gen/tmpl/lib.c"
/*
  gsl_rng.c
  Ruby/Numo::GSL - GSL wrapper for Ruby/Numo::NArray

  created on: 2017-03-11
  Copyright (C) 2017 Masahiro Tanaka
*/

#include <ruby.h>
#include <assert.h>
#include "numo/narray.h"
#include "numo/template.h"
#include "../numo_gsl.h"
#line 15 "../gen/tmpl/lib.c"
#include <gsl/gsl_rng.h>
#include <gsl/gsl_randist.h>

static VALUE mG;



#line 1 "../gen/tmpl/create_new_narray.c"
static VALUE
create_new_narray(VALUE datatype, VALUE vshape)
{
    size_t size, *shape;
    int j, ndim;

    switch(TYPE(vshape)) {
    case T_FIXNUM:
    case T_BIGNUM:
        size = NUM2SIZET(vshape);
        ndim = 1;
        shape = &size;
        break;
    case T_ARRAY:
        ndim = RARRAY_LEN(vshape);
        shape = ALLOCA_N(size_t,ndim);
        size = 1;
        for (j=0; j<ndim; j++) {
            shape[j] = NUM2SIZET(RARRAY_AREF(vshape,j));
        }
        break;
    default:
        rb_raise(rb_eArgError,"invalid argument for shape");
    }
    return rb_narray_new(datatype,ndim,shape);
}


#line 1 "../gen/tmpl/cast_1d_contiguous.c"
static VALUE
cast_1d_contiguous(VALUE v1, VALUE type)
{
    narray_t *na;

    v1 = rb_funcall(type, rb_intern("cast"), 1, v1);
    GetNArray(v1,na);
    if (NA_NDIM(na) != 1) {
        rb_raise(nary_eShapeError, "argument should be 1-dimensional array");
    }
    if (!RTEST(na_check_contiguous(v1))) {
        v1 = na_copy(v1);
    }
    return v1;
}


#line 1 "../gen/tmpl/class.c"
/*
  class definition: Numo::GSL::Rng
*/

static VALUE cRng;

static void
rng_free(void *ptr)
{
    gsl_rng_free(ptr);
}

static size_t
rng_memsize(const void *ptr)
{
    return sizeof(gsl_rng);
}

static const rb_data_type_t rng_data_type = {
    "Numo::GSL::Rng",
    {NULL, rng_free, rng_memsize,},
    0, 0, RUBY_TYPED_FREE_IMMEDIATELY|RUBY_TYPED_WB_PROTECTED
};



#line 1 "tmpl/rng_alloc.c"

#line 5 "tmpl/rng_alloc.c"
/*
  :nodoc:
 */
static VALUE
rng_s_new(int argc, VALUE *argv, VALUE self, const gsl_rng_type *t)
{
    gsl_rng *w;

    if (argc > 1) {
        rb_raise(rb_eArgError,"wrong number of arguments (given %d, expected 0..1)", argc);
    }
    w = gsl_rng_alloc(t);
    if (!w) {
        rb_raise(rb_eNoMemError,"fail to allocate struct");
    }
    if (argc == 1) {
        gsl_rng_set(w, NUM2ULONG(argv[0]));
    }
    return TypedData_Wrap_Struct(cRng, &rng_data_type, (void*)w);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Borosh13 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_borosh13 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_borosh13_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_borosh13);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Coveyou class,
  a subclass of Numo::GSL::Rng class with gsl_rng_coveyou type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_coveyou_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_coveyou);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Cmrg class,
  a subclass of Numo::GSL::Rng class with gsl_rng_cmrg type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_cmrg_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_cmrg);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Fishman18 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_fishman18 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_fishman18_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_fishman18);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Fishman20 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_fishman20 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_fishman20_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_fishman20);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Fishman2x class,
  a subclass of Numo::GSL::Rng class with gsl_rng_fishman2x type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_fishman2x_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_fishman2x);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Gfsr4 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_gfsr4 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_gfsr4_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_gfsr4);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Knuthran class,
  a subclass of Numo::GSL::Rng class with gsl_rng_knuthran type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_knuthran_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_knuthran);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Knuthran2 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_knuthran2 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_knuthran2_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_knuthran2);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Knuthran2002 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_knuthran2002 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_knuthran2002_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_knuthran2002);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Lecuyer21 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_lecuyer21 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_lecuyer21_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_lecuyer21);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Minstd class,
  a subclass of Numo::GSL::Rng class with gsl_rng_minstd type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_minstd_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_minstd);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Mrg class,
  a subclass of Numo::GSL::Rng class with gsl_rng_mrg type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_mrg_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_mrg);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Mt19937 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_mt19937 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_mt19937_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_mt19937);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Mt199371999 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_mt19937_1999 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_mt19937_1999_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_mt19937_1999);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Mt199371998 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_mt19937_1998 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_mt19937_1998_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_mt19937_1998);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::R250 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_r250 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_r250_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_r250);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Ran0 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_ran0 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_ran0_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_ran0);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Ran1 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_ran1 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_ran1_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_ran1);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Ran2 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_ran2 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_ran2_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_ran2);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Ran3 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_ran3 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_ran3_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_ran3);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Rand class,
  a subclass of Numo::GSL::Rng class with gsl_rng_rand type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_rand_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_rand);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Rand48 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_rand48 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_rand48_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_rand48);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Random128Bsd class,
  a subclass of Numo::GSL::Rng class with gsl_rng_random128_bsd type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_random128_bsd_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_random128_bsd);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Random128Glibc2 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_random128_glibc2 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_random128_glibc2_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_random128_glibc2);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Random128Libc5 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_random128_libc5 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_random128_libc5_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_random128_libc5);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Random256Bsd class,
  a subclass of Numo::GSL::Rng class with gsl_rng_random256_bsd type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_random256_bsd_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_random256_bsd);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Random256Glibc2 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_random256_glibc2 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_random256_glibc2_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_random256_glibc2);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Random256Libc5 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_random256_libc5 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_random256_libc5_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_random256_libc5);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Random32Bsd class,
  a subclass of Numo::GSL::Rng class with gsl_rng_random32_bsd type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_random32_bsd_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_random32_bsd);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Random32Glibc2 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_random32_glibc2 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_random32_glibc2_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_random32_glibc2);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Random32Libc5 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_random32_libc5 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_random32_libc5_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_random32_libc5);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Random64Bsd class,
  a subclass of Numo::GSL::Rng class with gsl_rng_random64_bsd type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_random64_bsd_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_random64_bsd);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Random64Glibc2 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_random64_glibc2 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_random64_glibc2_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_random64_glibc2);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Random64Libc5 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_random64_libc5 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_random64_libc5_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_random64_libc5);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Random8Bsd class,
  a subclass of Numo::GSL::Rng class with gsl_rng_random8_bsd type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_random8_bsd_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_random8_bsd);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Random8Glibc2 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_random8_glibc2 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_random8_glibc2_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_random8_glibc2);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Random8Libc5 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_random8_libc5 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_random8_libc5_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_random8_libc5);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::RandomBsd class,
  a subclass of Numo::GSL::Rng class with gsl_rng_random_bsd type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_random_bsd_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_random_bsd);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::RandomGlibc2 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_random_glibc2 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_random_glibc2_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_random_glibc2);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::RandomLibc5 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_random_libc5 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_random_libc5_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_random_libc5);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Randu class,
  a subclass of Numo::GSL::Rng class with gsl_rng_randu type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_randu_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_randu);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Ranf class,
  a subclass of Numo::GSL::Rng class with gsl_rng_ranf type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_ranf_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_ranf);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Ranlux class,
  a subclass of Numo::GSL::Rng class with gsl_rng_ranlux type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_ranlux_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_ranlux);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Ranlux389 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_ranlux389 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_ranlux389_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_ranlux389);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Ranlxd1 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_ranlxd1 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_ranlxd1_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_ranlxd1);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Ranlxd2 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_ranlxd2 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_ranlxd2_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_ranlxd2);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Ranlxs0 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_ranlxs0 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_ranlxs0_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_ranlxs0);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Ranlxs1 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_ranlxs1 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_ranlxs1_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_ranlxs1);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Ranlxs2 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_ranlxs2 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_ranlxs2_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_ranlxs2);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Ranmar class,
  a subclass of Numo::GSL::Rng class with gsl_rng_ranmar type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_ranmar_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_ranmar);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Slatec class,
  a subclass of Numo::GSL::Rng class with gsl_rng_slatec type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_slatec_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_slatec);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Taus class,
  a subclass of Numo::GSL::Rng class with gsl_rng_taus type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_taus_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_taus);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Taus2 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_taus2 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_taus2_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_taus2);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Taus113 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_taus113 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_taus113_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_taus113);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Transputer class,
  a subclass of Numo::GSL::Rng class with gsl_rng_transputer type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_transputer_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_transputer);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Tt800 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_tt800 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_tt800_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_tt800);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Uni class,
  a subclass of Numo::GSL::Rng class with gsl_rng_uni type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_uni_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_uni);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Uni32 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_uni32 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_uni32_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_uni32);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Vax class,
  a subclass of Numo::GSL::Rng class with gsl_rng_vax type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_vax_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_vax);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Waterman14 class,
  a subclass of Numo::GSL::Rng class with gsl_rng_waterman14 type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_waterman14_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_waterman14);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Zuf class,
  a subclass of Numo::GSL::Rng class with gsl_rng_zuf type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_zuf_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_zuf);
}


#line 1 "tmpl/rng_type_new.c"
/*
  @overload new([seed])
  @param [Integer]  seed  Random seed.

  Generate an instance of Numo::GSL::Rng::Default class,
  a subclass of Numo::GSL::Rng class with gsl_rng_default type.

  This function returns a pointer to a newly-created
instance of a random number generator of type T.
For example, the following code creates an instance of the Tausworthe
generator,

gsl_rng * r = gsl_rng_alloc (gsl_rng_taus);

If there is insufficient memory to create the generator then the
function returns a null pointer and the error handler is invoked with an
error code of GSL_ENOMEM.

The generator is automatically initialized with the default seed,
gsl_rng_default_seed.  This is zero by default but can be changed
either directly or by using the environment variable GSL_RNG_SEED
(Random number environment variables).

The details of the available generator types are
described later in this chapter.
  */
static VALUE
rng_default_s_new(int argc, VALUE *argv, VALUE self)
{
    return rng_s_new(argc, argv, self, gsl_rng_default);
}


#line 1 "../gen/tmpl/c_void_f_ulong.c"
/*
  @overload set(s)
  @param  [Integer]  s
  @return [Qnil]

  This function initializes (or `seeds') the random number generator.  If
the generator is seeded with the same value of s on two different
runs, the same stream of random numbers will be generated by successive
calls to the routines below.  If different values of $s \geq 1$
s >= 1 are supplied, then the generated streams of random
numbers should be completely different.  If the seed s is zero
then the standard seed from the original implementation is used
instead.  For example, the original Fortran source code for the
ranlux generator used a seed of 314159265, and so choosing
s equal to zero reproduces this when using
gsl_rng_ranlux.  

When using multiple seeds with the same generator, choose seed values
greater than zero to avoid collisions with the default setting.  

Note that the most generators only accept 32-bit seeds, with higher
values being reduced modulo $2^{32}$ 
2^32.  For generators
with smaller ranges the maximum seed value will typically be lower.
*/
static VALUE
rng_set(VALUE self, VALUE v1)
{
    gsl_rng *w;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, w);

    gsl_rng_set(w, NUM2ULONG(v1));
    return Qnil;
}


#line 1 "../gen/tmpl/c_ulong_f_void.c"
/*
  @overload get()
  @return [Integer]

  This function returns a random integer from the generator r.  The
minimum and maximum values depend on the algorithm used, but all
integers in the range [min,max] are equally likely.  The
values of min and max can be determined using the auxiliary
functions gsl_rng_max (r) and gsl_rng_min (r).
*/
static VALUE
rng_get(VALUE self)
{
    gsl_rng *w;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, w);

    return ULONG2NUM(gsl_rng_get(w));
}


#line 1 "tmpl/rng_DFloat.c"
/*
  @overload uniform([shape])
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Float or DFloat]  returns random number

  This function returns a double precision floating point number uniformly
distributed in the range [0,1).  The range includes 0.0 but excludes 1.0.
The value is typically obtained by dividing the result of
gsl_rng_get(r) by gsl_rng_max(r) + 1.0 in double
precision.  Some generators compute this ratio internally so that they
can provide floating point numbers with more than 32 bits of randomness
(the maximum number of bits that can be portably represented in a single
unsigned long int).
*/
static VALUE
rng_uniform(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    double *ptr;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    if (rb_scan_args(argc, argv, "01", &vshape) == 0) {
        return rb_float_new(gsl_rng_uniform(r));
    } else {
        vna = create_new_narray(cDF,vshape);
        ptr = (double*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_rng_uniform(r);
        }
        return vna;
    }
}


#line 1 "tmpl/rng_DFloat.c"
/*
  @overload uniform_pos([shape])
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Float or DFloat]  returns random number

  This function returns a positive double precision floating point number
uniformly distributed in the range (0,1), excluding both 0.0 and 1.0.
The number is obtained by sampling the generator with the algorithm of
gsl_rng_uniform until a non-zero value is obtained.  You can use
this function if you need to avoid a singularity at 0.0.
*/
static VALUE
rng_uniform_pos(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    double *ptr;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    if (rb_scan_args(argc, argv, "01", &vshape) == 0) {
        return rb_float_new(gsl_rng_uniform_pos(r));
    } else {
        vna = create_new_narray(cDF,vshape);
        ptr = (double*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_rng_uniform_pos(r);
        }
        return vna;
    }
}


#line 1 "tmpl/rng_UInt.c"
/*
  @overload uniform_int(n,[shape])
  @param  [Integer]  n
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Integer or UInt32/UInt64]  returns random number

  This function returns a random integer from 0 to n-1 inclusive
by scaling down and/or discarding samples from the generator r.
All integers in the range [0,n-1] are produced with equal
probability.  For generators with a non-zero minimum value an offset
is applied so that zero is returned with the correct probability.

Note that this function is designed for sampling from ranges smaller
than the range of the underlying generator.  The parameter n
must be less than or equal to the range of the generator r.
If n is larger than the range of the generator then the function
calls the error handler with an error code of GSL_EINVAL and
returns zero.

In particular, this function is not intended for generating the full range of
unsigned integer values $[0,2^{32}-1]$ 
[0,2^32-1]. Instead
choose a generator with the maximal integer range and zero minimum
value, such as gsl_rng_ranlxd1, gsl_rng_mt19937 or
gsl_rng_taus, and sample it directly using
gsl_rng_get.  The range of each generator can be found using
the auxiliary functions described in the next section.
*/
static VALUE
rng_uniform_int(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna, vn;
    size_t i, size;
    int nargs;
    unsigned long n;
    u_int32_t *p32;
    u_int64_t *p64;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "11", &vn, &vshape);
    n = NUM2ULONG(vn);
    if (nargs == 1) {
        return ULONG2NUM(gsl_rng_uniform_int(r, n));
    } else {
        if (n > 4294967295ul) {
            vna = create_new_narray(numo_cUInt64,vshape);
            p64 = (u_int64_t*)na_get_pointer_for_write(vna);
            size = RNARRAY_SIZE(vna);
            for (i=0; i<size; i++) {
                p64[i] = (u_int64_t)gsl_rng_uniform_int(r, n);
            }
        } else {
            vna = create_new_narray(numo_cUInt32,vshape);
            p32 = (u_int32_t*)na_get_pointer_for_write(vna);
            size = RNARRAY_SIZE(vna);
            for (i=0; i<size; i++) {
                p32[i] = (u_int32_t)gsl_rng_uniform_int(r, n);
            }
        }
        return vna;
    }
}


#line 1 "../gen/tmpl/c_str_f_void.c"
/*
  @overload name
  @return [String]

  This function returns a pointer to the name of the generator.
For example,

printf ("r is a '%s' generator\n", 
        gsl_rng_name (r));

would print something like r is a 'taus' generator.
*/
static VALUE
rng_name(VALUE self)
{
    gsl_rng *w;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, w);

    return rb_str_new_cstr(gsl_rng_name(w));
}


#line 1 "../gen/tmpl/c_ulong_f_void.c"
/*
  @overload max()
  @return [Integer]

  gsl_rng_max returns the largest value that gsl_rng_get
can return.
*/
static VALUE
rng_max(VALUE self)
{
    gsl_rng *w;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, w);

    return ULONG2NUM(gsl_rng_max(w));
}


#line 1 "../gen/tmpl/c_ulong_f_void.c"
/*
  @overload min()
  @return [Integer]

  gsl_rng_min returns the smallest value that gsl_rng_get
can return.  Usually this value is zero.  There are some generators with
algorithms that cannot return zero, and for these generators the minimum
value is 1.
*/
static VALUE
rng_min(VALUE self)
{
    gsl_rng *w;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, w);

    return ULONG2NUM(gsl_rng_min(w));
}


#line 1 "../gen/tmpl/c_sizet_f_void.c"
/*
  @overload size()
  @return [Integer]

  These functions return a pointer to the state of generator r and
its size.  You can use this information to access the state directly.  For
example, the following code will write the state of a generator to a
stream,

void * state = gsl_rng_state (r);
size_t n = gsl_rng_size (r);
fwrite (state, n, 1, stream);
*/
static VALUE
rng_size(VALUE self)
{
    gsl_rng *w;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, w);

    return SIZET2NUM(gsl_rng_size(w));
}


#line 1 "../gen/tmpl/c_self_f_other.c"
/*
  @overload memcpy(src)
  @param  [Numo::GSL::Rng]  src other
  @return [Numo::GSL::Rng]  self

  This function copies the random number generator src into the
pre-existing generator dest, making dest into an exact copy
of src.  The two generators must be of the same type.
*/
static VALUE
rng_memcpy(VALUE self, VALUE other)
{
    gsl_rng *w, *x;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, w);
    TypedData_Get_Struct(other, gsl_rng, &rng_data_type, x);
    gsl_rng_memcpy(w,x);
    return self;
}


#line 1 "../gen/tmpl/c_other_f_void.c"
/*
  @overload clone()
  @return [Numo::GSL::Rng]

 This function returns a pointer to a newly created generator which is an
exact copy of the generator r.
 */
static VALUE
rng_clone(VALUE self)
{
    gsl_rng *x, *w;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, x);

    w = gsl_rng_clone(x);
    if (!w) {
        rb_raise(rb_eNoMemError,"fail to allocate struct");
    }
    return TypedData_Wrap_Struct(cRng, &rng_data_type, (void*)w);
}


#line 1 "../gen/tmpl/module.c"
/*
  module definition: Numo::GSL::Ran
*/

#line 6 "../gen/tmpl/module.c"
static VALUE mRan;


#line 1 "tmpl/ran.c"
/*
  @overload gaussian(sigma,[shape])
  
  @param  [Float]  sigma
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Float or DFloat]  returns random number

This function returns a Gaussian random variate, with mean zero and
standard deviation sigma.  The probability distribution for
Gaussian random variates is,

p(x) dx = [1 \over \sqrt[2 \pi \sigma^2]] \exp (-x^2 / 2\sigma^2) dx

for x in the range -\infty to +\infty.  Use the
transformation z = \mu + x on the numbers returned by
gsl_ran_gaussian to obtain a Gaussian distribution with mean
\mu.  This function uses the Box-Muller algorithm which requires two
calls to the random number generator r.
 */
static VALUE
ran_gaussian(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    double *ptr;
    
    VALUE v0;
    
    double a0;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "11" , &v0, &vshape);
    a0 = NUM2DBL(v0);
    
    if (nargs == 1) {
        return rb_float_new(gsl_ran_gaussian(r , a0));
    } else {
        vna = create_new_narray(cDF,vshape);
        ptr = (double*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_gaussian(r , a0);
        }
        return vna;
    }
}


#line 1 "tmpl/ran.c"
/*
  @overload gaussian_ziggurat(sigma,[shape])
  
  @param  [Float]  sigma
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Float or DFloat]  returns random number

This function computes a Gaussian random variate using the alternative
Marsaglia-Tsang ziggurat and Kinderman-Monahan-Leva ratio methods.  The
Ziggurat algorithm is the fastest available algorithm in most cases.
 */
static VALUE
ran_gaussian_ziggurat(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    double *ptr;
    
    VALUE v0;
    
    double a0;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "11" , &v0, &vshape);
    a0 = NUM2DBL(v0);
    
    if (nargs == 1) {
        return rb_float_new(gsl_ran_gaussian_ziggurat(r , a0));
    } else {
        vna = create_new_narray(cDF,vshape);
        ptr = (double*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_gaussian_ziggurat(r , a0);
        }
        return vna;
    }
}


#line 1 "tmpl/ran.c"
/*
  @overload gaussian_ratio_method(sigma,[shape])
  
  @param  [Float]  sigma
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Float or DFloat]  returns random number

This function computes a Gaussian random variate using the alternative
Marsaglia-Tsang ziggurat and Kinderman-Monahan-Leva ratio methods.  The
Ziggurat algorithm is the fastest available algorithm in most cases.
 */
static VALUE
ran_gaussian_ratio_method(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    double *ptr;
    
    VALUE v0;
    
    double a0;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "11" , &v0, &vshape);
    a0 = NUM2DBL(v0);
    
    if (nargs == 1) {
        return rb_float_new(gsl_ran_gaussian_ratio_method(r , a0));
    } else {
        vna = create_new_narray(cDF,vshape);
        ptr = (double*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_gaussian_ratio_method(r , a0);
        }
        return vna;
    }
}


#line 1 "tmpl/ran.c"
/*
  @overload ugaussian([shape])
  
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Float or DFloat]  returns random number

These functions compute results for the unit Gaussian distribution.  They
are equivalent to the functions above with a standard deviation of one,
sigma = 1.
 */
static VALUE
ran_ugaussian(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    double *ptr;
    
    
#line 22 "tmpl/ran.c"
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "01" , &vshape);
    
#line 29 "tmpl/ran.c"
    if (nargs == 0) {
        return rb_float_new(gsl_ran_ugaussian(r ));
    } else {
        vna = create_new_narray(cDF,vshape);
        ptr = (double*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_ugaussian(r );
        }
        return vna;
    }
}


#line 1 "tmpl/ran.c"
/*
  @overload ugaussian_ratio_method([shape])
  
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Float or DFloat]  returns random number

These functions compute results for the unit Gaussian distribution.  They
are equivalent to the functions above with a standard deviation of one,
sigma = 1.
 */
static VALUE
ran_ugaussian_ratio_method(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    double *ptr;
    
    
#line 22 "tmpl/ran.c"
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "01" , &vshape);
    
#line 29 "tmpl/ran.c"
    if (nargs == 0) {
        return rb_float_new(gsl_ran_ugaussian_ratio_method(r ));
    } else {
        vna = create_new_narray(cDF,vshape);
        ptr = (double*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_ugaussian_ratio_method(r );
        }
        return vna;
    }
}


#line 1 "tmpl/ran.c"
/*
  @overload gaussian_tail(a,sigma,[shape])
  
  @param  [Float]  a
  @param  [Float]  sigma
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Float or DFloat]  returns random number

This function provides random variates from the upper tail of a Gaussian
distribution with standard deviation sigma.  The values returned
are larger than the lower limit a, which must be positive.  The
method is based on Marsaglia's famous rectangle-wedge-tail algorithm (Ann. 
Math. Stat. 32, 894--899 (1961)), with this aspect explained in Knuth, v2,
3rd ed, p139,586 (exercise 11).

The probability distribution for Gaussian tail random variates is,

p(x) dx = [1 \over N(a;\sigma) \sqrt[2 \pi \sigma^2]] \exp (- x^2/(2 \sigma^2)) dx

for x > a where N(a;\sigma) is the normalization constant,

N(a;\sigma) = (1/2) erfc(a / sqrt(2 sigma^2)).

 */
static VALUE
ran_gaussian_tail(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    double *ptr;
    
    VALUE v0;
#line 19 "tmpl/ran.c"
    VALUE v1;
    
    double a0;
#line 21 "tmpl/ran.c"
    double a1;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "21" , &v0, &v1, &vshape);
    a0 = NUM2DBL(v0);
    a1 = NUM2DBL(v1);
    
#line 29 "tmpl/ran.c"
    if (nargs == 2) {
        return rb_float_new(gsl_ran_gaussian_tail(r , a0, a1));
    } else {
        vna = create_new_narray(cDF,vshape);
        ptr = (double*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_gaussian_tail(r , a0, a1);
        }
        return vna;
    }
}


#line 1 "tmpl/ran.c"
/*
  @overload ugaussian_tail(a,[shape])
  
  @param  [Float]  a
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Float or DFloat]  returns random number

These functions compute results for the tail of a unit Gaussian
distribution.  They are equivalent to the functions above with a standard
deviation of one, sigma = 1.
 */
static VALUE
ran_ugaussian_tail(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    double *ptr;
    
    VALUE v0;
    
    double a0;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "11" , &v0, &vshape);
    a0 = NUM2DBL(v0);
    
    if (nargs == 1) {
        return rb_float_new(gsl_ran_ugaussian_tail(r , a0));
    } else {
        vna = create_new_narray(cDF,vshape);
        ptr = (double*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_ugaussian_tail(r , a0);
        }
        return vna;
    }
}


#line 1 "tmpl/ran_DFloat_x2.c"
/*
  @overload bivariate_gaussian(sigma_x,sigma_y,rho,[shape])
  
  @param  [Float]  sigma_x
  @param  [Float]  sigma_y
  @param  [Float]  rho
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return []  returns random number

This function generates a pair of correlated Gaussian variates, with
mean zero, correlation coefficient rho and standard deviations
sigma_x and sigma_y in the x and y directions.
The probability distribution for bivariate Gaussian random variates is,

p(x,y) dx dy = [1 \over 2 \pi \sigma_x \sigma_y \sqrt[1-\rho^2]] \exp (-(x^2/\sigma_x^2 + y^2/\sigma_y^2 - 2 \rho x y/(\sigma_x\sigma_y))/2(1-\rho^2)) dx dy

for x,y in the range -\infty to +\infty.  The
correlation coefficient rho should lie between 1 and
-1.
 */
static VALUE
ran_bivariate_gaussian(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vx, vy;
    size_t i, size;
    int nargs;
    double x, y;
    double *px, *py;
    
    VALUE v0;
#line 20 "tmpl/ran_DFloat_x2.c"
    VALUE v1;
#line 20 "tmpl/ran_DFloat_x2.c"
    VALUE v2;
    
    double a0;
#line 22 "tmpl/ran_DFloat_x2.c"
    double a1;
#line 22 "tmpl/ran_DFloat_x2.c"
    double a2;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "31" , &v0, &v1, &v2, &vshape);
    
    a0 = NUM2DBL(v0);
    a1 = NUM2DBL(v1);
    a2 = NUM2DBL(v2);
#line 30 "tmpl/ran_DFloat_x2.c"
    if (nargs == 3) {
        gsl_ran_bivariate_gaussian(r , a0, a1, a2, &x, &y);
        return rb_assoc_new(DBL2NUM(x),DBL2NUM(y));
    } else {
        vx = create_new_narray(cDF,vshape);
        vy = create_new_narray(cDF,vshape);
        px = (double*)na_get_pointer_for_write(vx);
        py = (double*)na_get_pointer_for_write(vy);
        size = RNARRAY_SIZE(vx);
        for (i=0; i<size; i++) {
            gsl_ran_bivariate_gaussian(r , a0, a1, a2, px, py);
            px++; py++;
        }
        return rb_assoc_new(vx,vy);
    }
}


#line 1 "tmpl/ran.c"
/*
  @overload exponential(mu,[shape])
  
  @param  [Float]  mu
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Float or DFloat]  returns random number

This function returns a random variate from the exponential distribution
with mean mu. The distribution is,

p(x) dx = [1 \over \mu] \exp(-x/\mu) dx

for $x \ge 0$
x >= 0. 
 */
static VALUE
ran_exponential(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    double *ptr;
    
    VALUE v0;
    
    double a0;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "11" , &v0, &vshape);
    a0 = NUM2DBL(v0);
    
    if (nargs == 1) {
        return rb_float_new(gsl_ran_exponential(r , a0));
    } else {
        vna = create_new_narray(cDF,vshape);
        ptr = (double*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_exponential(r , a0);
        }
        return vna;
    }
}


#line 1 "tmpl/ran.c"
/*
  @overload laplace(a,[shape])
  
  @param  [Float]  a
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Float or DFloat]  returns random number

This function returns a random variate from the Laplace distribution
with width a.  The distribution is,

p(x) dx = [1 \over 2 a]  \exp(-|x/a|) dx

for -\infty < x < \infty.
 */
static VALUE
ran_laplace(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    double *ptr;
    
    VALUE v0;
    
    double a0;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "11" , &v0, &vshape);
    a0 = NUM2DBL(v0);
    
    if (nargs == 1) {
        return rb_float_new(gsl_ran_laplace(r , a0));
    } else {
        vna = create_new_narray(cDF,vshape);
        ptr = (double*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_laplace(r , a0);
        }
        return vna;
    }
}


#line 1 "tmpl/ran.c"
/*
  @overload exppow(a,b,[shape])
  
  @param  [Float]  a
  @param  [Float]  b
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Float or DFloat]  returns random number

This function returns a random variate from the exponential power distribution
with scale parameter a and exponent b.  The distribution is,

p(x) dx = [1 \over 2 a \Gamma(1+1/b)] \exp(-|x/a|^b) dx

for $x \ge 0$
x >= 0.  For b = 1 this reduces to the Laplace
distribution.  For b = 2 it has the same form as a Gaussian
distribution, but with $a = \sqrt{2} \sigma$
a = \sqrt[2] \sigma.
 */
static VALUE
ran_exppow(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    double *ptr;
    
    VALUE v0;
#line 19 "tmpl/ran.c"
    VALUE v1;
    
    double a0;
#line 21 "tmpl/ran.c"
    double a1;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "21" , &v0, &v1, &vshape);
    a0 = NUM2DBL(v0);
    a1 = NUM2DBL(v1);
    
#line 29 "tmpl/ran.c"
    if (nargs == 2) {
        return rb_float_new(gsl_ran_exppow(r , a0, a1));
    } else {
        vna = create_new_narray(cDF,vshape);
        ptr = (double*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_exppow(r , a0, a1);
        }
        return vna;
    }
}


#line 1 "tmpl/ran.c"
/*
  @overload cauchy(a,[shape])
  
  @param  [Float]  a
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Float or DFloat]  returns random number

This function returns a random variate from the Cauchy distribution with
scale parameter a.  The probability distribution for Cauchy
random variates is,

p(x) dx = [1 \over a\pi (1 + (x/a)^2) ] dx

for x in the range -\infty to +\infty.  The Cauchy
distribution is also known as the Lorentz distribution.
 */
static VALUE
ran_cauchy(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    double *ptr;
    
    VALUE v0;
    
    double a0;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "11" , &v0, &vshape);
    a0 = NUM2DBL(v0);
    
    if (nargs == 1) {
        return rb_float_new(gsl_ran_cauchy(r , a0));
    } else {
        vna = create_new_narray(cDF,vshape);
        ptr = (double*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_cauchy(r , a0);
        }
        return vna;
    }
}


#line 1 "tmpl/ran.c"
/*
  @overload rayleigh(sigma,[shape])
  
  @param  [Float]  sigma
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Float or DFloat]  returns random number

This function returns a random variate from the Rayleigh distribution with
scale parameter sigma.  The distribution is,

p(x) dx = [x \over \sigma^2] \exp(- x^2/(2 \sigma^2)) dx

for x > 0.
 */
static VALUE
ran_rayleigh(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    double *ptr;
    
    VALUE v0;
    
    double a0;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "11" , &v0, &vshape);
    a0 = NUM2DBL(v0);
    
    if (nargs == 1) {
        return rb_float_new(gsl_ran_rayleigh(r , a0));
    } else {
        vna = create_new_narray(cDF,vshape);
        ptr = (double*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_rayleigh(r , a0);
        }
        return vna;
    }
}


#line 1 "tmpl/ran.c"
/*
  @overload rayleigh_tail(a,sigma,[shape])
  
  @param  [Float]  a
  @param  [Float]  sigma
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Float or DFloat]  returns random number

This function returns a random variate from the tail of the Rayleigh
distribution with scale parameter sigma and a lower limit of
a.  The distribution is,

p(x) dx = [x \over \sigma^2] \exp ((a^2 - x^2) /(2 \sigma^2)) dx

for x > a.
 */
static VALUE
ran_rayleigh_tail(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    double *ptr;
    
    VALUE v0;
#line 19 "tmpl/ran.c"
    VALUE v1;
    
    double a0;
#line 21 "tmpl/ran.c"
    double a1;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "21" , &v0, &v1, &vshape);
    a0 = NUM2DBL(v0);
    a1 = NUM2DBL(v1);
    
#line 29 "tmpl/ran.c"
    if (nargs == 2) {
        return rb_float_new(gsl_ran_rayleigh_tail(r , a0, a1));
    } else {
        vna = create_new_narray(cDF,vshape);
        ptr = (double*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_rayleigh_tail(r , a0, a1);
        }
        return vna;
    }
}


#line 1 "tmpl/ran.c"
/*
  @overload landau([shape])
  
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Float or DFloat]  returns random number

This function returns a random variate from the Landau distribution.  The
probability distribution for Landau random variates is defined
analytically by the complex integral,

p(x) = (1/(2 \pi i)) \int_[c-i\infty]^[c+i\infty] ds exp(s log(s) + x s) 
For numerical purposes it is more convenient to use the following
equivalent form of the integral,

p(x) = (1/\pi) \int_0^\infty dt \exp(-t \log(t) - x t) \sin(\pi t).
 */
static VALUE
ran_landau(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    double *ptr;
    
    
#line 22 "tmpl/ran.c"
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "01" , &vshape);
    
#line 29 "tmpl/ran.c"
    if (nargs == 0) {
        return rb_float_new(gsl_ran_landau(r ));
    } else {
        vna = create_new_narray(cDF,vshape);
        ptr = (double*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_landau(r );
        }
        return vna;
    }
}


#line 1 "tmpl/ran.c"
/*
  @overload levy(c,alpha,[shape])
  
  @param  [Float]  c
  @param  [Float]  alpha
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Float or DFloat]  returns random number

This function returns a random variate from the Levy symmetric stable
distribution with scale c and exponent alpha.  The symmetric
stable probability distribution is defined by a Fourier transform,

p(x) = [1 \over 2 \pi] \int_[-\infty]^[+\infty] dt \exp(-it x - |c t|^alpha)

There is no explicit solution for the form of p(x) and the
library does not define a corresponding pdf function.  For
\alpha = 1 the distribution reduces to the Cauchy distribution.  For
\alpha = 2 it is a Gaussian distribution with $\sigma = \sqrt{2} c$ 
\sigma = \sqrt[2] c.  For \alpha < 1 the tails of the
distribution become extremely wide.

The algorithm only works for $0 < \alpha \le 2$
0 < alpha <= 2.
 */
static VALUE
ran_levy(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    double *ptr;
    
    VALUE v0;
#line 19 "tmpl/ran.c"
    VALUE v1;
    
    double a0;
#line 21 "tmpl/ran.c"
    double a1;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "21" , &v0, &v1, &vshape);
    a0 = NUM2DBL(v0);
    a1 = NUM2DBL(v1);
    
#line 29 "tmpl/ran.c"
    if (nargs == 2) {
        return rb_float_new(gsl_ran_levy(r , a0, a1));
    } else {
        vna = create_new_narray(cDF,vshape);
        ptr = (double*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_levy(r , a0, a1);
        }
        return vna;
    }
}


#line 1 "tmpl/ran.c"
/*
  @overload gamma(a,b,[shape])
  
  @param  [Float]  a
  @param  [Float]  b
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Float or DFloat]  returns random number

This function returns a random variate from the gamma
distribution.  The distribution function is,

p(x) dx = [1 \over \Gamma(a) b^a] x^[a-1] e^[-x/b] dx

for x > 0.
If X and Y are independent gamma-distributed random
variables of order a and b, then X+Y has a gamma
distribution of order a+b.

The gamma distribution with an integer parameter a is known as the Erlang distribution.

The variates are computed using the Marsaglia-Tsang fast gamma method.
This function for this method was previously called
gsl_ran_gamma_mt and can still be accessed using this name.
 */
static VALUE
ran_gamma(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    double *ptr;
    
    VALUE v0;
#line 19 "tmpl/ran.c"
    VALUE v1;
    
    double a0;
#line 21 "tmpl/ran.c"
    double a1;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "21" , &v0, &v1, &vshape);
    a0 = NUM2DBL(v0);
    a1 = NUM2DBL(v1);
    
#line 29 "tmpl/ran.c"
    if (nargs == 2) {
        return rb_float_new(gsl_ran_gamma(r , a0, a1));
    } else {
        vna = create_new_narray(cDF,vshape);
        ptr = (double*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_gamma(r , a0, a1);
        }
        return vna;
    }
}


#line 1 "tmpl/ran.c"
/*
  @overload gamma_knuth(a,b,[shape])
  
  @param  [Float]  a
  @param  [Float]  b
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Float or DFloat]  returns random number

This function returns a gamma variate using the algorithms from Knuth (vol 2).
 */
static VALUE
ran_gamma_knuth(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    double *ptr;
    
    VALUE v0;
#line 19 "tmpl/ran.c"
    VALUE v1;
    
    double a0;
#line 21 "tmpl/ran.c"
    double a1;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "21" , &v0, &v1, &vshape);
    a0 = NUM2DBL(v0);
    a1 = NUM2DBL(v1);
    
#line 29 "tmpl/ran.c"
    if (nargs == 2) {
        return rb_float_new(gsl_ran_gamma_knuth(r , a0, a1));
    } else {
        vna = create_new_narray(cDF,vshape);
        ptr = (double*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_gamma_knuth(r , a0, a1);
        }
        return vna;
    }
}


#line 1 "tmpl/ran.c"
/*
  @overload flat(a,b,[shape])
  
  @param  [Float]  a
  @param  [Float]  b
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Float or DFloat]  returns random number

This function returns a random variate from the flat (uniform)
distribution from a to b. The distribution is,

p(x) dx = [1 \over (b-a)] dx

if $a \le x < b$
a <= x < b and 0 otherwise.
 */
static VALUE
ran_flat(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    double *ptr;
    
    VALUE v0;
#line 19 "tmpl/ran.c"
    VALUE v1;
    
    double a0;
#line 21 "tmpl/ran.c"
    double a1;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "21" , &v0, &v1, &vshape);
    a0 = NUM2DBL(v0);
    a1 = NUM2DBL(v1);
    
#line 29 "tmpl/ran.c"
    if (nargs == 2) {
        return rb_float_new(gsl_ran_flat(r , a0, a1));
    } else {
        vna = create_new_narray(cDF,vshape);
        ptr = (double*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_flat(r , a0, a1);
        }
        return vna;
    }
}


#line 1 "tmpl/ran.c"
/*
  @overload lognormal(zeta,sigma,[shape])
  
  @param  [Float]  zeta
  @param  [Float]  sigma
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Float or DFloat]  returns random number

This function returns a random variate from the lognormal
distribution.  The distribution function is,

p(x) dx = [1 \over x \sqrt[2 \pi \sigma^2] ] \exp(-(\ln(x) - \zeta)^2/2 \sigma^2) dx

for x > 0.
 */
static VALUE
ran_lognormal(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    double *ptr;
    
    VALUE v0;
#line 19 "tmpl/ran.c"
    VALUE v1;
    
    double a0;
#line 21 "tmpl/ran.c"
    double a1;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "21" , &v0, &v1, &vshape);
    a0 = NUM2DBL(v0);
    a1 = NUM2DBL(v1);
    
#line 29 "tmpl/ran.c"
    if (nargs == 2) {
        return rb_float_new(gsl_ran_lognormal(r , a0, a1));
    } else {
        vna = create_new_narray(cDF,vshape);
        ptr = (double*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_lognormal(r , a0, a1);
        }
        return vna;
    }
}


#line 1 "tmpl/ran.c"
/*
  @overload chisq(nu,[shape])
  
  @param  [Float]  nu
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Float or DFloat]  returns random number

This function returns a random variate from the chi-squared distribution
with nu degrees of freedom. The distribution function is,

p(x) dx = [1 \over 2 \Gamma(\nu/2) ] (x/2)^[\nu/2 - 1] \exp(-x/2) dx

for $x \ge 0$
x >= 0. 
 */
static VALUE
ran_chisq(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    double *ptr;
    
    VALUE v0;
    
    double a0;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "11" , &v0, &vshape);
    a0 = NUM2DBL(v0);
    
    if (nargs == 1) {
        return rb_float_new(gsl_ran_chisq(r , a0));
    } else {
        vna = create_new_narray(cDF,vshape);
        ptr = (double*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_chisq(r , a0);
        }
        return vna;
    }
}


#line 1 "tmpl/ran.c"
/*
  @overload fdist(nu1,nu2,[shape])
  
  @param  [Float]  nu1
  @param  [Float]  nu2
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Float or DFloat]  returns random number

This function returns a random variate from the F-distribution with degrees of freedom nu1 and nu2. The distribution function is,

p(x) dx = 
   [ \Gamma((\nu_1 + \nu_2)/2)
        \over \Gamma(\nu_1/2) \Gamma(\nu_2/2) ] 
   \nu_1^[\nu_1/2] \nu_2^[\nu_2/2] 
   x^[\nu_1/2 - 1] (\nu_2 + \nu_1 x)^[-\nu_1/2 -\nu_2/2]

for $x \ge 0$
x >= 0. 
 */
static VALUE
ran_fdist(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    double *ptr;
    
    VALUE v0;
#line 19 "tmpl/ran.c"
    VALUE v1;
    
    double a0;
#line 21 "tmpl/ran.c"
    double a1;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "21" , &v0, &v1, &vshape);
    a0 = NUM2DBL(v0);
    a1 = NUM2DBL(v1);
    
#line 29 "tmpl/ran.c"
    if (nargs == 2) {
        return rb_float_new(gsl_ran_fdist(r , a0, a1));
    } else {
        vna = create_new_narray(cDF,vshape);
        ptr = (double*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_fdist(r , a0, a1);
        }
        return vna;
    }
}


#line 1 "tmpl/ran.c"
/*
  @overload tdist(nu,[shape])
  
  @param  [Float]  nu
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Float or DFloat]  returns random number

This function returns a random variate from the t-distribution.  The
distribution function is,

p(x) dx = [\Gamma((\nu + 1)/2) \over \sqrt[\pi \nu] \Gamma(\nu/2)]
   (1 + x^2/\nu)^[-(\nu + 1)/2] dx

for -\infty < x < +\infty.
 */
static VALUE
ran_tdist(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    double *ptr;
    
    VALUE v0;
    
    double a0;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "11" , &v0, &vshape);
    a0 = NUM2DBL(v0);
    
    if (nargs == 1) {
        return rb_float_new(gsl_ran_tdist(r , a0));
    } else {
        vna = create_new_narray(cDF,vshape);
        ptr = (double*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_tdist(r , a0);
        }
        return vna;
    }
}


#line 1 "tmpl/ran.c"
/*
  @overload beta(a,b,[shape])
  
  @param  [Float]  a
  @param  [Float]  b
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Float or DFloat]  returns random number

This function returns a random variate from the beta
distribution.  The distribution function is,

p(x) dx = [\Gamma(a+b) \over \Gamma(a) \Gamma(b)] x^[a-1] (1-x)^[b-1] dx

for $0 \le x \le 1$
0 <= x <= 1.
 */
static VALUE
ran_beta(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    double *ptr;
    
    VALUE v0;
#line 19 "tmpl/ran.c"
    VALUE v1;
    
    double a0;
#line 21 "tmpl/ran.c"
    double a1;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "21" , &v0, &v1, &vshape);
    a0 = NUM2DBL(v0);
    a1 = NUM2DBL(v1);
    
#line 29 "tmpl/ran.c"
    if (nargs == 2) {
        return rb_float_new(gsl_ran_beta(r , a0, a1));
    } else {
        vna = create_new_narray(cDF,vshape);
        ptr = (double*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_beta(r , a0, a1);
        }
        return vna;
    }
}


#line 1 "tmpl/ran.c"
/*
  @overload logistic(a,[shape])
  
  @param  [Float]  a
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Float or DFloat]  returns random number

This function returns a random variate from the logistic
distribution.  The distribution function is,

p(x) dx = [ \exp(-x/a) \over a (1 + \exp(-x/a))^2 ] dx

for -\infty < x < +\infty.
 */
static VALUE
ran_logistic(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    double *ptr;
    
    VALUE v0;
    
    double a0;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "11" , &v0, &vshape);
    a0 = NUM2DBL(v0);
    
    if (nargs == 1) {
        return rb_float_new(gsl_ran_logistic(r , a0));
    } else {
        vna = create_new_narray(cDF,vshape);
        ptr = (double*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_logistic(r , a0);
        }
        return vna;
    }
}


#line 1 "tmpl/ran.c"
/*
  @overload pareto(a,b,[shape])
  
  @param  [Float]  a
  @param  [Float]  b
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Float or DFloat]  returns random number

This function returns a random variate from the Pareto distribution of
order a.  The distribution function is,

p(x) dx = (a/b) / (x/b)^[a+1] dx

for $x \ge b$
x >= b.
 */
static VALUE
ran_pareto(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    double *ptr;
    
    VALUE v0;
#line 19 "tmpl/ran.c"
    VALUE v1;
    
    double a0;
#line 21 "tmpl/ran.c"
    double a1;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "21" , &v0, &v1, &vshape);
    a0 = NUM2DBL(v0);
    a1 = NUM2DBL(v1);
    
#line 29 "tmpl/ran.c"
    if (nargs == 2) {
        return rb_float_new(gsl_ran_pareto(r , a0, a1));
    } else {
        vna = create_new_narray(cDF,vshape);
        ptr = (double*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_pareto(r , a0, a1);
        }
        return vna;
    }
}


#line 1 "tmpl/ran_DFloat_x2.c"
/*
  @overload dir_2d([shape])
  
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return []  returns random number

This function returns a random direction vector v =
(x,y) in two dimensions.  The vector is normalized such that
|v|^2 = x^2 + y^2 = 1.  The obvious way to do this is to take a
uniform random number between 0 and 2\pi and let x and
y be the sine and cosine respectively.  Two trig functions would
have been expensive in the old days, but with modern hardware
implementations, this is sometimes the fastest way to go.  This is the
case for the Pentium (but not the case for the Sun Sparcstation).
One can avoid the trig evaluations by choosing x and
y in the interior of a unit circle (choose them at random from the
interior of the enclosing square, and then reject those that are outside
the unit circle), and then dividing by $\sqrt{x^2 + y^2}$
\sqrt[x^2 + y^2].
A much cleverer approach, attributed to von Neumann (See Knuth, v2, 3rd
ed, p140, exercise 23), requires neither trig nor a square root.  In
this approach, u and v are chosen at random from the
interior of a unit circle, and then x=(u^2-v^2)/(u^2+v^2) and
y=2uv/(u^2+v^2).
 */
static VALUE
ran_dir_2d(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vx, vy;
    size_t i, size;
    int nargs;
    double x, y;
    double *px, *py;
    
    
#line 23 "tmpl/ran_DFloat_x2.c"
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "01" , &vshape);
    
#line 30 "tmpl/ran_DFloat_x2.c"
    if (nargs == 0) {
        gsl_ran_dir_2d(r , &x, &y);
        return rb_assoc_new(DBL2NUM(x),DBL2NUM(y));
    } else {
        vx = create_new_narray(cDF,vshape);
        vy = create_new_narray(cDF,vshape);
        px = (double*)na_get_pointer_for_write(vx);
        py = (double*)na_get_pointer_for_write(vy);
        size = RNARRAY_SIZE(vx);
        for (i=0; i<size; i++) {
            gsl_ran_dir_2d(r , px, py);
            px++; py++;
        }
        return rb_assoc_new(vx,vy);
    }
}


#line 1 "tmpl/ran_DFloat_x2.c"
/*
  @overload dir_2d_trig_method([shape])
  
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return []  returns random number

This function returns a random direction vector v =
(x,y) in two dimensions.  The vector is normalized such that
|v|^2 = x^2 + y^2 = 1.  The obvious way to do this is to take a
uniform random number between 0 and 2\pi and let x and
y be the sine and cosine respectively.  Two trig functions would
have been expensive in the old days, but with modern hardware
implementations, this is sometimes the fastest way to go.  This is the
case for the Pentium (but not the case for the Sun Sparcstation).
One can avoid the trig evaluations by choosing x and
y in the interior of a unit circle (choose them at random from the
interior of the enclosing square, and then reject those that are outside
the unit circle), and then dividing by $\sqrt{x^2 + y^2}$
\sqrt[x^2 + y^2].
A much cleverer approach, attributed to von Neumann (See Knuth, v2, 3rd
ed, p140, exercise 23), requires neither trig nor a square root.  In
this approach, u and v are chosen at random from the
interior of a unit circle, and then x=(u^2-v^2)/(u^2+v^2) and
y=2uv/(u^2+v^2).
 */
static VALUE
ran_dir_2d_trig_method(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vx, vy;
    size_t i, size;
    int nargs;
    double x, y;
    double *px, *py;
    
    
#line 23 "tmpl/ran_DFloat_x2.c"
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "01" , &vshape);
    
#line 30 "tmpl/ran_DFloat_x2.c"
    if (nargs == 0) {
        gsl_ran_dir_2d_trig_method(r , &x, &y);
        return rb_assoc_new(DBL2NUM(x),DBL2NUM(y));
    } else {
        vx = create_new_narray(cDF,vshape);
        vy = create_new_narray(cDF,vshape);
        px = (double*)na_get_pointer_for_write(vx);
        py = (double*)na_get_pointer_for_write(vy);
        size = RNARRAY_SIZE(vx);
        for (i=0; i<size; i++) {
            gsl_ran_dir_2d_trig_method(r , px, py);
            px++; py++;
        }
        return rb_assoc_new(vx,vy);
    }
}


#line 1 "tmpl/ran_DFloat_x3.c"
/*
  @overload dir_3d([shape])
  
  @param  [Array or Integer]  shape (optional) shape for result Numo::NArray
  @return [Array]  returns array of [x,y,z], where x,y,z are Float or Numo::DFloat

This function returns a random direction vector v =
(x,y,z) in three dimensions.  The vector is normalized
such that |v|^2 = x^2 + y^2 + z^2 = 1.  The method employed is
due to Robert E. Knop (CACM 13, 326 (1970)), and explained in Knuth, v2,
3rd ed, p136.  It uses the surprising fact that the distribution
projected along any axis is actually uniform (this is only true for 3
dimensions).
 */
static VALUE
ran_dir_3d(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape;
    VALUE v[3];
    size_t i, size;
    int nargs;
    double x, y, z;
    double *px, *py, *pz;
    
    
#line 24 "tmpl/ran_DFloat_x3.c"
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "01" , &vshape);
    
#line 31 "tmpl/ran_DFloat_x3.c"
    if (nargs == 0) {
        gsl_ran_dir_3d(r , &x, &y, &z);
        v[0] = DBL2NUM(x);
        v[1] = DBL2NUM(y);
        v[2] = DBL2NUM(z);
        return rb_ary_new4(3,v);
    } else {
        v[0] = create_new_narray(cDF,vshape);
        v[1] = create_new_narray(cDF,vshape);
        v[2] = create_new_narray(cDF,vshape);
        px = (double*)na_get_pointer_for_write(v[0]);
        py = (double*)na_get_pointer_for_write(v[1]);
        pz = (double*)na_get_pointer_for_write(v[2]);
        size = RNARRAY_SIZE(v[0]);
        for (i=0; i<size; i++) {
            gsl_ran_dir_3d(r , px, py, pz);
            px++; py++; pz++;
        }
        return rb_ary_new4(3,v);
    }
}


#line 1 "tmpl/ran.c"
/*
  @overload weibull(a,b,[shape])
  
  @param  [Float]  a
  @param  [Float]  b
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Float or DFloat]  returns random number

This function returns a random variate from the Weibull distribution.  The
distribution function is,

p(x) dx = [b \over a^b] x^[b-1]  \exp(-(x/a)^b) dx

for $x \ge 0$
x >= 0.
 */
static VALUE
ran_weibull(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    double *ptr;
    
    VALUE v0;
#line 19 "tmpl/ran.c"
    VALUE v1;
    
    double a0;
#line 21 "tmpl/ran.c"
    double a1;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "21" , &v0, &v1, &vshape);
    a0 = NUM2DBL(v0);
    a1 = NUM2DBL(v1);
    
#line 29 "tmpl/ran.c"
    if (nargs == 2) {
        return rb_float_new(gsl_ran_weibull(r , a0, a1));
    } else {
        vna = create_new_narray(cDF,vshape);
        ptr = (double*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_weibull(r , a0, a1);
        }
        return vna;
    }
}


#line 1 "tmpl/ran.c"
/*
  @overload gumbel1(a,b,[shape])
  
  @param  [Float]  a
  @param  [Float]  b
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Float or DFloat]  returns random number

This function returns  a random variate from the Type-1 Gumbel
distribution.  The Type-1 Gumbel distribution function is,

p(x) dx = a b \exp(-(b \exp(-ax) + ax)) dx

for -\infty < x < \infty. 
 */
static VALUE
ran_gumbel1(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    double *ptr;
    
    VALUE v0;
#line 19 "tmpl/ran.c"
    VALUE v1;
    
    double a0;
#line 21 "tmpl/ran.c"
    double a1;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "21" , &v0, &v1, &vshape);
    a0 = NUM2DBL(v0);
    a1 = NUM2DBL(v1);
    
#line 29 "tmpl/ran.c"
    if (nargs == 2) {
        return rb_float_new(gsl_ran_gumbel1(r , a0, a1));
    } else {
        vna = create_new_narray(cDF,vshape);
        ptr = (double*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_gumbel1(r , a0, a1);
        }
        return vna;
    }
}


#line 1 "tmpl/ran.c"
/*
  @overload gumbel2(a,b,[shape])
  
  @param  [Float]  a
  @param  [Float]  b
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Float or DFloat]  returns random number

This function returns a random variate from the Type-2 Gumbel
distribution.  The Type-2 Gumbel distribution function is,

p(x) dx = a b x^[-a-1] \exp(-b x^[-a]) dx

for 0 < x < \infty.
 */
static VALUE
ran_gumbel2(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    double *ptr;
    
    VALUE v0;
#line 19 "tmpl/ran.c"
    VALUE v1;
    
    double a0;
#line 21 "tmpl/ran.c"
    double a1;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "21" , &v0, &v1, &vshape);
    a0 = NUM2DBL(v0);
    a1 = NUM2DBL(v1);
    
#line 29 "tmpl/ran.c"
    if (nargs == 2) {
        return rb_float_new(gsl_ran_gumbel2(r , a0, a1));
    } else {
        vna = create_new_narray(cDF,vshape);
        ptr = (double*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_gumbel2(r , a0, a1);
        }
        return vna;
    }
}


#line 1 "tmpl/ran_DFloat_f_DFloat.c"
/*
  @overload dirichlet(alpha[])
  @param  [DFloat]  alpha[]
  @return [DFloat]  theta[]

This function returns an array of K random variates from a Dirichlet
distribution of order K-1. The distribution function is

p(\theta_1, ..., \theta_K) d\theta_1 ... d\theta_K = 
  (1/Z) \prod_[i=1]^K \theta_i^[\alpha_i - 1] \delta(1 -\sum_[i=1]^K \theta_i) d\theta_1 ... d\theta_K

for $\theta_i \ge 0$ 
theta_i >= 0
and $\alpha_i > 0$ 
alpha_i > 0.  The delta function ensures that \sum \theta_i = 1.
The normalization factor Z is

Z = [\prod_[i=1]^K \Gamma(\alpha_i)] / [\Gamma( \sum_[i=1]^K \alpha_i)]

The random variates are generated by sampling K values 
from gamma distributions with parameters 
$a=\alpha_i$, $b=1$ 
a=alpha_i, b=1, 
and renormalizing. 
See A.M. Law, W.D. Kelton, Simulation Modeling and Analysis (1991).
 */
static VALUE
ran_dirichlet(VALUE self, VALUE valpha)
{
    VALUE   vtheta;
    double *alpha, *theta;
    narray_t *na;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    valpha = cast_1d_contiguous(valpha, cDF);
    GetNArray(valpha,na);
    vtheta = rb_narray_new(cDF,na->ndim,na->shape);
    theta = (double*)na_get_pointer_for_write(vtheta);
    alpha = (double*)na_get_pointer_for_read(valpha);

    gsl_ran_dirichlet(r, na->size, alpha, theta);
    RB_GC_GUARD(valpha);
    return vtheta;
}


#line 1 "tmpl/ran.c"
/*
  @overload poisson(mu,[shape])
  
  @param  [Float]  mu
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Integer or UInt]  returns random number

This function returns a random integer from the Poisson distribution
with mean mu.  The probability distribution for Poisson variates is,

p(k) = [\mu^k \over k!] \exp(-\mu)

for $k \ge 0$
k >= 0.
 */
static VALUE
ran_poisson(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    unsigned int *ptr;
    
    VALUE v0;
    
    double a0;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "11" , &v0, &vshape);
    a0 = NUM2DBL(v0);
    
    if (nargs == 1) {
        return rb_float_new(gsl_ran_poisson(r , a0));
    } else {
        vna = create_new_narray(cUInt,vshape);
        ptr = (unsigned int*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_poisson(r , a0);
        }
        return vna;
    }
}


#line 1 "tmpl/ran.c"
/*
  @overload bernoulli(p,[shape])
  
  @param  [Float]  p
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Integer or UInt]  returns random number

This function returns either 0 or 1, the result of a Bernoulli trial
with probability p.  The probability distribution for a Bernoulli
trial is,

p(0) = 1 - p
p(1) = p

 */
static VALUE
ran_bernoulli(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    unsigned int *ptr;
    
    VALUE v0;
    
    double a0;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "11" , &v0, &vshape);
    a0 = NUM2DBL(v0);
    
    if (nargs == 1) {
        return rb_float_new(gsl_ran_bernoulli(r , a0));
    } else {
        vna = create_new_narray(cUInt,vshape);
        ptr = (unsigned int*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_bernoulli(r , a0);
        }
        return vna;
    }
}


#line 1 "tmpl/ran.c"
/*
  @overload binomial(p,n,[shape])
  
  @param  [Float]  p
  @param  [Integer]  n
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Integer or UInt]  returns random number

This function returns a random integer from the binomial distribution,
the number of successes in n independent trials with probability
p.  The probability distribution for binomial variates is,

p(k) = [n! \over k! (n-k)! ] p^k (1-p)^[n-k]

for $0 \le k \le n$
0 <= k <= n.
 */
static VALUE
ran_binomial(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    unsigned int *ptr;
    
    VALUE v0;
#line 19 "tmpl/ran.c"
    VALUE v1;
    
    double a0;
#line 21 "tmpl/ran.c"
    unsigned int a1;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "21" , &v0, &v1, &vshape);
    a0 = NUM2DBL(v0);
    a1 = NUM2UINT(v1);
    
#line 29 "tmpl/ran.c"
    if (nargs == 2) {
        return rb_float_new(gsl_ran_binomial(r , a0, a1));
    } else {
        vna = create_new_narray(cUInt,vshape);
        ptr = (unsigned int*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_binomial(r , a0, a1);
        }
        return vna;
    }
}


#line 1 "tmpl/ran_multinomial.c"
/*
  @overload multinomial(N, p[])
  @param  [Integer] N
  @param  [DFloat]  p[]
  @return [UInt]    n[]


This function computes a random sample n[] from the multinomial
distribution formed by N trials from an underlying distribution
p[K]. The distribution function for n[] is,

P(n_1, n_2, ..., n_K) = 
  (N!/(n_1! n_2! ... n_K!)) p_1^n_1 p_2^n_2 ... p_K^n_K

where ($n_1$, $n_2$, $\ldots$, $n_K$)
(n_1, n_2, ..., n_K) 
are nonnegative integers with 
$\sum_{k=1}^{K} n_k =N$ 
sum_[k=1]^K n_k = N,
and
$(p_1, p_2, \ldots, p_K)$ 
(p_1, p_2, ..., p_K)
is a probability distribution with \sum p_i = 1.  
If the array p[K] is not normalized then its entries will be
treated as weights and normalized appropriately.  The arrays n[]
and p[] must both be of length K.

Random variates are generated using the conditional binomial method (see
C.S. Davis, The computer generation of multinomial random
variates, Comp. Stat. Data Anal. 16 (1993) 205--217 for details).
 */
static VALUE
ran_multinomial(VALUE self, VALUE vN, VALUE vp)
{
    VALUE vn;
    double *p;
    unsigned int *n;
    unsigned int  N;
    narray_t *na;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    N = NUM2UINT(vN);
    vp = cast_1d_contiguous(vp, cDF);
    GetNArray(vp,na);
    p = (double*)na_get_pointer_for_read(vp);
    vn = rb_narray_new(cUInt,na->ndim,na->shape);
    n = (unsigned int*)na_get_pointer_for_write(vn);

    gsl_ran_multinomial(r, na->size, N, p, n);
    RB_GC_GUARD(vp);
    return vn;
}


#line 1 "tmpl/ran.c"
/*
  @overload pascal(p,n,[shape])
  
  @param  [Float]  p
  @param  [Integer]  n
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Integer or UInt]  returns random number

This function returns a random integer from the Pascal distribution.  The
Pascal distribution is simply a negative binomial distribution with an
integer value of n.

p(k) = [(n + k - 1)! \over k! (n - 1)! ] p^n (1-p)^k

for $k \ge 0$
k >= 0
 */
static VALUE
ran_pascal(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    unsigned int *ptr;
    
    VALUE v0;
#line 19 "tmpl/ran.c"
    VALUE v1;
    
    double a0;
#line 21 "tmpl/ran.c"
    unsigned int a1;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "21" , &v0, &v1, &vshape);
    a0 = NUM2DBL(v0);
    a1 = NUM2UINT(v1);
    
#line 29 "tmpl/ran.c"
    if (nargs == 2) {
        return rb_float_new(gsl_ran_pascal(r , a0, a1));
    } else {
        vna = create_new_narray(cUInt,vshape);
        ptr = (unsigned int*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_pascal(r , a0, a1);
        }
        return vna;
    }
}


#line 1 "tmpl/ran.c"
/*
  @overload geometric(p,[shape])
  
  @param  [Float]  p
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Integer or UInt]  returns random number

This function returns a random integer from the geometric distribution,
the number of independent trials with probability p until the
first success.  The probability distribution for geometric variates
is,

p(k) =  p (1-p)^(k-1)

for $k \ge 1$
k >= 1.  Note that the distribution begins with k=1 with this
definition.  There is another convention in which the exponent k-1 
is replaced by k.
 */
static VALUE
ran_geometric(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    unsigned int *ptr;
    
    VALUE v0;
    
    double a0;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "11" , &v0, &vshape);
    a0 = NUM2DBL(v0);
    
    if (nargs == 1) {
        return rb_float_new(gsl_ran_geometric(r , a0));
    } else {
        vna = create_new_narray(cUInt,vshape);
        ptr = (unsigned int*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_geometric(r , a0);
        }
        return vna;
    }
}


#line 1 "tmpl/ran.c"
/*
  @overload hypergeometric(n1,n2,t,[shape])
  
  @param  [Integer]  n1
  @param  [Integer]  n2
  @param  [Integer]  t
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Integer or UInt]  returns random number

This function returns a random integer from the hypergeometric
distribution.  The probability distribution for hypergeometric
random variates is,

p(k) =  C(n_1, k) C(n_2, t - k) / C(n_1 + n_2, t)

where C(a,b) = a!/(b!(a-b)!) and 
$t \leq n_1 + n_2$
t <= n_1 + n_2.  The domain of k is 
$\hbox{max}(0,t-n_2), \ldots, \hbox{min}(t,n_1)$ 
max(0,t-n_2), ..., min(t,n_1).

If a population contains n_1 elements of ``type 1'' and
n_2 elements of ``type 2'' then the hypergeometric
distribution gives the probability of obtaining k elements of
``type 1'' in t samples from the population without
replacement.
 */
static VALUE
ran_hypergeometric(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    unsigned int *ptr;
    
    VALUE v0;
#line 19 "tmpl/ran.c"
    VALUE v1;
#line 19 "tmpl/ran.c"
    VALUE v2;
    
    unsigned int a0;
#line 21 "tmpl/ran.c"
    unsigned int a1;
#line 21 "tmpl/ran.c"
    unsigned int a2;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "31" , &v0, &v1, &v2, &vshape);
    a0 = NUM2UINT(v0);
    a1 = NUM2UINT(v1);
    a2 = NUM2UINT(v2);
    
#line 29 "tmpl/ran.c"
    if (nargs == 3) {
        return rb_float_new(gsl_ran_hypergeometric(r , a0, a1, a2));
    } else {
        vna = create_new_narray(cUInt,vshape);
        ptr = (unsigned int*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_hypergeometric(r , a0, a1, a2);
        }
        return vna;
    }
}


#line 1 "tmpl/ran.c"
/*
  @overload logarithmic(p,[shape])
  
  @param  [Float]  p
  @param  [Array or Integer]  shape (optional) shape for result NArray
  @return [Integer or UInt]  returns random number

This function returns a random integer from the logarithmic
distribution.  The probability distribution for logarithmic random variates
is,

p(k) = [-1 \over \log(1-p)] [(p^k \over k)]

for $k \ge 1$
k >= 1.
 */
static VALUE
ran_logarithmic(int argc, VALUE *argv, VALUE self)
{
    VALUE vshape, vna;
    size_t i, size;
    int nargs;
    unsigned int *ptr;
    
    VALUE v0;
    
    double a0;
    gsl_rng *r;

    TypedData_Get_Struct(self, gsl_rng, &rng_data_type, r);

    nargs = rb_scan_args(argc, argv, "11" , &v0, &vshape);
    a0 = NUM2DBL(v0);
    
    if (nargs == 1) {
        return rb_float_new(gsl_ran_logarithmic(r , a0));
    } else {
        vna = create_new_narray(cUInt,vshape);
        ptr = (unsigned int*)na_get_pointer_for_write(vna);
        size = RNARRAY_SIZE(vna);
        for (i=0; i<size; i++) {
            ptr[i] = gsl_ran_logarithmic(r , a0);
        }
        return vna;
    }
}



#line 28 "../gen/tmpl/lib.c"
void
Init_rng(void)
{
    VALUE mN;
    mN = rb_define_module("Numo");
    mG = rb_define_module_under(mN, "GSL");

    


#line 1 "../gen/tmpl/init_class.c"

    /*
      Document-class: Numo::GSL::Rng
      
    */
    {
    cRng = rb_define_class_under(mG, "Rng", rb_cObject);
    
    rb_undef_alloc_func(cRng);
    
    { VALUE cBorosh13 = rb_define_class_under(cRng, "Borosh13", cRng);
      rb_define_singleton_method(cBorosh13, "new", rng_borosh13_s_new, -1); }
    { VALUE cCoveyou = rb_define_class_under(cRng, "Coveyou", cRng);
      rb_define_singleton_method(cCoveyou, "new", rng_coveyou_s_new, -1); }
    { VALUE cCmrg = rb_define_class_under(cRng, "Cmrg", cRng);
      rb_define_singleton_method(cCmrg, "new", rng_cmrg_s_new, -1); }
    { VALUE cFishman18 = rb_define_class_under(cRng, "Fishman18", cRng);
      rb_define_singleton_method(cFishman18, "new", rng_fishman18_s_new, -1); }
    { VALUE cFishman20 = rb_define_class_under(cRng, "Fishman20", cRng);
      rb_define_singleton_method(cFishman20, "new", rng_fishman20_s_new, -1); }
    { VALUE cFishman2x = rb_define_class_under(cRng, "Fishman2x", cRng);
      rb_define_singleton_method(cFishman2x, "new", rng_fishman2x_s_new, -1); }
    { VALUE cGfsr4 = rb_define_class_under(cRng, "Gfsr4", cRng);
      rb_define_singleton_method(cGfsr4, "new", rng_gfsr4_s_new, -1); }
    { VALUE cKnuthran = rb_define_class_under(cRng, "Knuthran", cRng);
      rb_define_singleton_method(cKnuthran, "new", rng_knuthran_s_new, -1); }
    { VALUE cKnuthran2 = rb_define_class_under(cRng, "Knuthran2", cRng);
      rb_define_singleton_method(cKnuthran2, "new", rng_knuthran2_s_new, -1); }
    { VALUE cKnuthran2002 = rb_define_class_under(cRng, "Knuthran2002", cRng);
      rb_define_singleton_method(cKnuthran2002, "new", rng_knuthran2002_s_new, -1); }
    { VALUE cLecuyer21 = rb_define_class_under(cRng, "Lecuyer21", cRng);
      rb_define_singleton_method(cLecuyer21, "new", rng_lecuyer21_s_new, -1); }
    { VALUE cMinstd = rb_define_class_under(cRng, "Minstd", cRng);
      rb_define_singleton_method(cMinstd, "new", rng_minstd_s_new, -1); }
    { VALUE cMrg = rb_define_class_under(cRng, "Mrg", cRng);
      rb_define_singleton_method(cMrg, "new", rng_mrg_s_new, -1); }
    { VALUE cMt19937 = rb_define_class_under(cRng, "Mt19937", cRng);
      rb_define_singleton_method(cMt19937, "new", rng_mt19937_s_new, -1); }
    { VALUE cMt199371999 = rb_define_class_under(cRng, "Mt199371999", cRng);
      rb_define_singleton_method(cMt199371999, "new", rng_mt19937_1999_s_new, -1); }
    { VALUE cMt199371998 = rb_define_class_under(cRng, "Mt199371998", cRng);
      rb_define_singleton_method(cMt199371998, "new", rng_mt19937_1998_s_new, -1); }
    { VALUE cR250 = rb_define_class_under(cRng, "R250", cRng);
      rb_define_singleton_method(cR250, "new", rng_r250_s_new, -1); }
    { VALUE cRan0 = rb_define_class_under(cRng, "Ran0", cRng);
      rb_define_singleton_method(cRan0, "new", rng_ran0_s_new, -1); }
    { VALUE cRan1 = rb_define_class_under(cRng, "Ran1", cRng);
      rb_define_singleton_method(cRan1, "new", rng_ran1_s_new, -1); }
    { VALUE cRan2 = rb_define_class_under(cRng, "Ran2", cRng);
      rb_define_singleton_method(cRan2, "new", rng_ran2_s_new, -1); }
    { VALUE cRan3 = rb_define_class_under(cRng, "Ran3", cRng);
      rb_define_singleton_method(cRan3, "new", rng_ran3_s_new, -1); }
    { VALUE cRand = rb_define_class_under(cRng, "Rand", cRng);
      rb_define_singleton_method(cRand, "new", rng_rand_s_new, -1); }
    { VALUE cRand48 = rb_define_class_under(cRng, "Rand48", cRng);
      rb_define_singleton_method(cRand48, "new", rng_rand48_s_new, -1); }
    { VALUE cRandom128Bsd = rb_define_class_under(cRng, "Random128Bsd", cRng);
      rb_define_singleton_method(cRandom128Bsd, "new", rng_random128_bsd_s_new, -1); }
    { VALUE cRandom128Glibc2 = rb_define_class_under(cRng, "Random128Glibc2", cRng);
      rb_define_singleton_method(cRandom128Glibc2, "new", rng_random128_glibc2_s_new, -1); }
    { VALUE cRandom128Libc5 = rb_define_class_under(cRng, "Random128Libc5", cRng);
      rb_define_singleton_method(cRandom128Libc5, "new", rng_random128_libc5_s_new, -1); }
    { VALUE cRandom256Bsd = rb_define_class_under(cRng, "Random256Bsd", cRng);
      rb_define_singleton_method(cRandom256Bsd, "new", rng_random256_bsd_s_new, -1); }
    { VALUE cRandom256Glibc2 = rb_define_class_under(cRng, "Random256Glibc2", cRng);
      rb_define_singleton_method(cRandom256Glibc2, "new", rng_random256_glibc2_s_new, -1); }
    { VALUE cRandom256Libc5 = rb_define_class_under(cRng, "Random256Libc5", cRng);
      rb_define_singleton_method(cRandom256Libc5, "new", rng_random256_libc5_s_new, -1); }
    { VALUE cRandom32Bsd = rb_define_class_under(cRng, "Random32Bsd", cRng);
      rb_define_singleton_method(cRandom32Bsd, "new", rng_random32_bsd_s_new, -1); }
    { VALUE cRandom32Glibc2 = rb_define_class_under(cRng, "Random32Glibc2", cRng);
      rb_define_singleton_method(cRandom32Glibc2, "new", rng_random32_glibc2_s_new, -1); }
    { VALUE cRandom32Libc5 = rb_define_class_under(cRng, "Random32Libc5", cRng);
      rb_define_singleton_method(cRandom32Libc5, "new", rng_random32_libc5_s_new, -1); }
    { VALUE cRandom64Bsd = rb_define_class_under(cRng, "Random64Bsd", cRng);
      rb_define_singleton_method(cRandom64Bsd, "new", rng_random64_bsd_s_new, -1); }
    { VALUE cRandom64Glibc2 = rb_define_class_under(cRng, "Random64Glibc2", cRng);
      rb_define_singleton_method(cRandom64Glibc2, "new", rng_random64_glibc2_s_new, -1); }
    { VALUE cRandom64Libc5 = rb_define_class_under(cRng, "Random64Libc5", cRng);
      rb_define_singleton_method(cRandom64Libc5, "new", rng_random64_libc5_s_new, -1); }
    { VALUE cRandom8Bsd = rb_define_class_under(cRng, "Random8Bsd", cRng);
      rb_define_singleton_method(cRandom8Bsd, "new", rng_random8_bsd_s_new, -1); }
    { VALUE cRandom8Glibc2 = rb_define_class_under(cRng, "Random8Glibc2", cRng);
      rb_define_singleton_method(cRandom8Glibc2, "new", rng_random8_glibc2_s_new, -1); }
    { VALUE cRandom8Libc5 = rb_define_class_under(cRng, "Random8Libc5", cRng);
      rb_define_singleton_method(cRandom8Libc5, "new", rng_random8_libc5_s_new, -1); }
    { VALUE cRandomBsd = rb_define_class_under(cRng, "RandomBsd", cRng);
      rb_define_singleton_method(cRandomBsd, "new", rng_random_bsd_s_new, -1); }
    { VALUE cRandomGlibc2 = rb_define_class_under(cRng, "RandomGlibc2", cRng);
      rb_define_singleton_method(cRandomGlibc2, "new", rng_random_glibc2_s_new, -1); }
    { VALUE cRandomLibc5 = rb_define_class_under(cRng, "RandomLibc5", cRng);
      rb_define_singleton_method(cRandomLibc5, "new", rng_random_libc5_s_new, -1); }
    { VALUE cRandu = rb_define_class_under(cRng, "Randu", cRng);
      rb_define_singleton_method(cRandu, "new", rng_randu_s_new, -1); }
    { VALUE cRanf = rb_define_class_under(cRng, "Ranf", cRng);
      rb_define_singleton_method(cRanf, "new", rng_ranf_s_new, -1); }
    { VALUE cRanlux = rb_define_class_under(cRng, "Ranlux", cRng);
      rb_define_singleton_method(cRanlux, "new", rng_ranlux_s_new, -1); }
    { VALUE cRanlux389 = rb_define_class_under(cRng, "Ranlux389", cRng);
      rb_define_singleton_method(cRanlux389, "new", rng_ranlux389_s_new, -1); }
    { VALUE cRanlxd1 = rb_define_class_under(cRng, "Ranlxd1", cRng);
      rb_define_singleton_method(cRanlxd1, "new", rng_ranlxd1_s_new, -1); }
    { VALUE cRanlxd2 = rb_define_class_under(cRng, "Ranlxd2", cRng);
      rb_define_singleton_method(cRanlxd2, "new", rng_ranlxd2_s_new, -1); }
    { VALUE cRanlxs0 = rb_define_class_under(cRng, "Ranlxs0", cRng);
      rb_define_singleton_method(cRanlxs0, "new", rng_ranlxs0_s_new, -1); }
    { VALUE cRanlxs1 = rb_define_class_under(cRng, "Ranlxs1", cRng);
      rb_define_singleton_method(cRanlxs1, "new", rng_ranlxs1_s_new, -1); }
    { VALUE cRanlxs2 = rb_define_class_under(cRng, "Ranlxs2", cRng);
      rb_define_singleton_method(cRanlxs2, "new", rng_ranlxs2_s_new, -1); }
    { VALUE cRanmar = rb_define_class_under(cRng, "Ranmar", cRng);
      rb_define_singleton_method(cRanmar, "new", rng_ranmar_s_new, -1); }
    { VALUE cSlatec = rb_define_class_under(cRng, "Slatec", cRng);
      rb_define_singleton_method(cSlatec, "new", rng_slatec_s_new, -1); }
    { VALUE cTaus = rb_define_class_under(cRng, "Taus", cRng);
      rb_define_singleton_method(cTaus, "new", rng_taus_s_new, -1); }
    { VALUE cTaus2 = rb_define_class_under(cRng, "Taus2", cRng);
      rb_define_singleton_method(cTaus2, "new", rng_taus2_s_new, -1); }
    { VALUE cTaus113 = rb_define_class_under(cRng, "Taus113", cRng);
      rb_define_singleton_method(cTaus113, "new", rng_taus113_s_new, -1); }
    { VALUE cTransputer = rb_define_class_under(cRng, "Transputer", cRng);
      rb_define_singleton_method(cTransputer, "new", rng_transputer_s_new, -1); }
    { VALUE cTt800 = rb_define_class_under(cRng, "Tt800", cRng);
      rb_define_singleton_method(cTt800, "new", rng_tt800_s_new, -1); }
    { VALUE cUni = rb_define_class_under(cRng, "Uni", cRng);
      rb_define_singleton_method(cUni, "new", rng_uni_s_new, -1); }
    { VALUE cUni32 = rb_define_class_under(cRng, "Uni32", cRng);
      rb_define_singleton_method(cUni32, "new", rng_uni32_s_new, -1); }
    { VALUE cVax = rb_define_class_under(cRng, "Vax", cRng);
      rb_define_singleton_method(cVax, "new", rng_vax_s_new, -1); }
    { VALUE cWaterman14 = rb_define_class_under(cRng, "Waterman14", cRng);
      rb_define_singleton_method(cWaterman14, "new", rng_waterman14_s_new, -1); }
    { VALUE cZuf = rb_define_class_under(cRng, "Zuf", cRng);
      rb_define_singleton_method(cZuf, "new", rng_zuf_s_new, -1); }
    { VALUE cDefault = rb_define_class_under(cRng, "Default", cRng);
      rb_define_singleton_method(cDefault, "new", rng_default_s_new, -1); }
    rb_define_method(cRng, "set", rng_set, 1);
    rb_define_method(cRng, "get", rng_get, 0);
    rb_define_method(cRng, "uniform", rng_uniform, -1);
    rb_define_method(cRng, "uniform_pos", rng_uniform_pos, -1);
    rb_define_method(cRng, "uniform_int", rng_uniform_int, -1);
    rb_define_method(cRng, "name", rng_name, 0);
    rb_define_method(cRng, "max", rng_max, 0);
    rb_define_method(cRng, "min", rng_min, 0);
    rb_define_method(cRng, "size", rng_size, 0);
    rb_define_method(cRng, "memcpy", rng_memcpy, 1);
    rb_define_method(cRng, "clone", rng_clone, 0);
#line 10 "../gen/tmpl/init_class.c"
    }

#line 1 "../gen/tmpl/init_module.c"

    /*
      Document-module: Numo::GSL::Ran
      
    */
    {
    
    mRan = rb_define_module_under(mG, "Ran");
    
    
    rb_define_method(mRan, "gaussian", ran_gaussian, -1);
    rb_define_method(mRan, "gaussian_ziggurat", ran_gaussian_ziggurat, -1);
    rb_define_method(mRan, "gaussian_ratio_method", ran_gaussian_ratio_method, -1);
    rb_define_method(mRan, "ugaussian", ran_ugaussian, -1);
    rb_define_method(mRan, "ugaussian_ratio_method", ran_ugaussian_ratio_method, -1);
    rb_define_method(mRan, "gaussian_tail", ran_gaussian_tail, -1);
    rb_define_method(mRan, "ugaussian_tail", ran_ugaussian_tail, -1);
    rb_define_method(mRan, "bivariate_gaussian", ran_bivariate_gaussian, -1);
    rb_define_method(mRan, "exponential", ran_exponential, -1);
    rb_define_method(mRan, "laplace", ran_laplace, -1);
    rb_define_method(mRan, "exppow", ran_exppow, -1);
    rb_define_method(mRan, "cauchy", ran_cauchy, -1);
    rb_define_method(mRan, "rayleigh", ran_rayleigh, -1);
    rb_define_method(mRan, "rayleigh_tail", ran_rayleigh_tail, -1);
    rb_define_method(mRan, "landau", ran_landau, -1);
    rb_define_method(mRan, "levy", ran_levy, -1);
    rb_define_method(mRan, "gamma", ran_gamma, -1);
    rb_define_method(mRan, "gamma_knuth", ran_gamma_knuth, -1);
    rb_define_method(mRan, "flat", ran_flat, -1);
    rb_define_method(mRan, "lognormal", ran_lognormal, -1);
    rb_define_method(mRan, "chisq", ran_chisq, -1);
    rb_define_method(mRan, "fdist", ran_fdist, -1);
    rb_define_method(mRan, "tdist", ran_tdist, -1);
    rb_define_method(mRan, "beta", ran_beta, -1);
    rb_define_method(mRan, "logistic", ran_logistic, -1);
    rb_define_method(mRan, "pareto", ran_pareto, -1);
    rb_define_method(mRan, "dir_2d", ran_dir_2d, -1);
    rb_define_method(mRan, "dir_2d_trig_method", ran_dir_2d_trig_method, -1);
    rb_define_method(mRan, "dir_3d", ran_dir_3d, -1);
    rb_define_method(mRan, "weibull", ran_weibull, -1);
    rb_define_method(mRan, "gumbel1", ran_gumbel1, -1);
    rb_define_method(mRan, "gumbel2", ran_gumbel2, -1);
    rb_define_method(mRan, "dirichlet", ran_dirichlet, 1);
    rb_define_method(mRan, "poisson", ran_poisson, -1);
    rb_define_method(mRan, "bernoulli", ran_bernoulli, -1);
    rb_define_method(mRan, "binomial", ran_binomial, -1);
    rb_define_method(mRan, "multinomial", ran_multinomial, 1);
    rb_define_method(mRan, "pascal", ran_pascal, -1);
    rb_define_method(mRan, "geometric", ran_geometric, -1);
    rb_define_method(mRan, "hypergeometric", ran_hypergeometric, -1);
    rb_define_method(mRan, "logarithmic", ran_logarithmic, -1);
    rb_include_module(cRng, mRan);
#line 12 "../gen/tmpl/init_module.c"
    }
#line 41 "../gen/tmpl/lib.c"
}
