[{:func_name=>"gsl_ran_gaussian",
  :func_type=>"double",
  :args=>[["const gsl_rng *", "r"], ["double", "sigma"]],
  :desc=>
   "This function returns a Gaussian random variate, with mean zero and\n" +
   "standard deviation sigma.  The probability distribution for\n" +
   "Gaussian random variates is,\n" +
   "\n" +
   "p(x) dx = @{1 \\over \\sqrt@{2 \\pi \\sigma^2@}@} \\exp (-x^2 / 2\\sigma^2) dx\n" +
   "\n" +
   "for x in the range -\\infty to +\\infty.  Use the\n" +
   "transformation z = \\mu + x on the numbers returned by\n" +
   "gsl_ran_gaussian to obtain a Gaussian distribution with mean\n" +
   "\\mu.  This function uses the Box-Muller algorithm which requires two\n" +
   "calls to the random number generator r."},
 {:func_name=>"gsl_ran_gaussian_pdf",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "sigma"]],
  :desc=>
   "This function computes the probability density p(x) at x\n" +
   "for a Gaussian distribution with standard deviation sigma, using\n" +
   "the formula given above."},
 {:func_name=>"gsl_ran_gaussian_ziggurat",
  :func_type=>"double",
  :args=>[["const gsl_rng *", "r"], ["double", "sigma"]],
  :desc=>
   "This function computes a Gaussian random variate using the alternative\n" +
   "Marsaglia-Tsang ziggurat and Kinderman-Monahan-Leva ratio methods.  The\n" +
   "Ziggurat algorithm is the fastest available algorithm in most cases."},
 {:func_name=>"gsl_ran_gaussian_ratio_method",
  :func_type=>"double",
  :args=>[["const gsl_rng *", "r"], ["double", "sigma"]],
  :desc=>
   "This function computes a Gaussian random variate using the alternative\n" +
   "Marsaglia-Tsang ziggurat and Kinderman-Monahan-Leva ratio methods.  The\n" +
   "Ziggurat algorithm is the fastest available algorithm in most cases."},
 {:func_name=>"gsl_ran_ugaussian",
  :func_type=>"double",
  :args=>[["const gsl_rng *", "r"]],
  :desc=>
   "These functions compute results for the unit Gaussian distribution.  They\n" +
   "are equivalent to the functions above with a standard deviation of one,\n" +
   "sigma = 1."},
 {:func_name=>"gsl_ran_ugaussian_pdf",
  :func_type=>"double",
  :args=>[["double", "x"]],
  :desc=>
   "These functions compute results for the unit Gaussian distribution.  They\n" +
   "are equivalent to the functions above with a standard deviation of one,\n" +
   "sigma = 1."},
 {:func_name=>"gsl_ran_ugaussian_ratio_method",
  :func_type=>"double",
  :args=>[["const gsl_rng *", "r"]],
  :desc=>
   "These functions compute results for the unit Gaussian distribution.  They\n" +
   "are equivalent to the functions above with a standard deviation of one,\n" +
   "sigma = 1."},
 {:func_name=>"gsl_cdf_gaussian_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "sigma"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Gaussian\n" +
   "distribution with standard deviation sigma."},
 {:func_name=>"gsl_cdf_gaussian_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "sigma"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Gaussian\n" +
   "distribution with standard deviation sigma."},
 {:func_name=>"gsl_cdf_gaussian_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"], ["double", "sigma"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Gaussian\n" +
   "distribution with standard deviation sigma."},
 {:func_name=>"gsl_cdf_gaussian_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"], ["double", "sigma"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Gaussian\n" +
   "distribution with standard deviation sigma."},
 {:func_name=>"gsl_cdf_ugaussian_P",
  :func_type=>"double",
  :args=>[["double", "x"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the unit Gaussian\n" +
   "distribution."},
 {:func_name=>"gsl_cdf_ugaussian_Q",
  :func_type=>"double",
  :args=>[["double", "x"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the unit Gaussian\n" +
   "distribution."},
 {:func_name=>"gsl_cdf_ugaussian_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the unit Gaussian\n" +
   "distribution."},
 {:func_name=>"gsl_cdf_ugaussian_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the unit Gaussian\n" +
   "distribution."},
 {:func_name=>"gsl_ran_gaussian_tail",
  :func_type=>"double",
  :args=>[["const gsl_rng *", "r"], ["double", "a"], ["double", "sigma"]],
  :desc=>
   "This function provides random variates from the upper tail of a Gaussian\n" +
   "distribution with standard deviation sigma.  The values returned\n" +
   "are larger than the lower limit a, which must be positive.  The\n" +
   "method is based on Marsaglia's famous rectangle-wedge-tail algorithm (Ann. \n" +
   "Math. Stat. 32, 894--899 (1961)), with this aspect explained in Knuth, v2,\n" +
   "3rd ed, p139,586 (exercise 11).\n" +
   "\n" +
   "The probability distribution for Gaussian tail random variates is,\n" +
   "\n" +
   "p(x) dx = @{1 \\over N(a;\\sigma) \\sqrt@{2 \\pi \\sigma^2@}@} \\exp (- x^2/(2 \\sigma^2)) dx\n" +
   "\n" +
   "for x > a where N(a;\\sigma) is the normalization constant,\n" +
   "\n" +
   "N(a;\\sigma) = (1/2) erfc(a / sqrt(2 sigma^2)).\n"},
 {:func_name=>"gsl_ran_gaussian_tail_pdf",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "sigma"]],
  :desc=>
   "This function computes the probability density p(x) at x\n" +
   "for a Gaussian tail distribution with standard deviation sigma and\n" +
   "lower limit a, using the formula given above."},
 {:func_name=>"gsl_ran_ugaussian_tail",
  :func_type=>"double",
  :args=>[["const gsl_rng *", "r"], ["double", "a"]],
  :desc=>
   "These functions compute results for the tail of a unit Gaussian\n" +
   "distribution.  They are equivalent to the functions above with a standard\n" +
   "deviation of one, sigma = 1."},
 {:func_name=>"gsl_ran_ugaussian_tail_pdf",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"]],
  :desc=>
   "These functions compute results for the tail of a unit Gaussian\n" +
   "distribution.  They are equivalent to the functions above with a standard\n" +
   "deviation of one, sigma = 1."},
 {:func_name=>"gsl_ran_bivariate_gaussian",
  :func_type=>"void",
  :args=>
   [["const gsl_rng *", "r"],
    ["double", "sigma_x"],
    ["double", "sigma_y"],
    ["double", "rho"],
    ["double *", "x"],
    ["double *", "y"]],
  :desc=>
   "This function generates a pair of correlated Gaussian variates, with\n" +
   "mean zero, correlation coefficient rho and standard deviations\n" +
   "sigma_x and sigma_y in the x and y directions.\n" +
   "The probability distribution for bivariate Gaussian random variates is,\n" +
   "\n" +
   "p(x,y) dx dy = @{1 \\over 2 \\pi \\sigma_x \\sigma_y \\sqrt@{1-\\rho^2@}@} \\exp (-(x^2/\\sigma_x^2 + y^2/\\sigma_y^2 - 2 \\rho x y/(\\sigma_x\\sigma_y))/2(1-\\rho^2)) dx dy\n" +
   "\n" +
   "for x,y in the range -\\infty to +\\infty.  The\n" +
   "correlation coefficient rho should lie between 1 and\n" +
   "-1."},
 {:func_name=>"gsl_ran_bivariate_gaussian_pdf",
  :func_type=>"double",
  :args=>
   [["double", "x"],
    ["double", "y"],
    ["double", "sigma_x"],
    ["double", "sigma_y"],
    ["double", "rho"]],
  :desc=>
   "This function computes the probability density p(x,y) at\n" +
   "(x,y) for a bivariate Gaussian distribution with standard\n" +
   "deviations sigma_x, sigma_y and correlation coefficient\n" +
   "rho, using the formula given above."},
 {:func_name=>"gsl_ran_exponential",
  :func_type=>"double",
  :args=>[["const gsl_rng *", "r"], ["double", "mu"]],
  :desc=>
   "This function returns a random variate from the exponential distribution\n" +
   "with mean mu. The distribution is,\n" +
   "\n" +
   "p(x) dx = @{1 \\over \\mu@} \\exp(-x/\\mu) dx\n" +
   "\n" +
   "for $x \\ge 0$\n" +
   "x >= 0. "},
 {:func_name=>"gsl_ran_exponential_pdf",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "mu"]],
  :desc=>
   "This function computes the probability density p(x) at x\n" +
   "for an exponential distribution with mean mu, using the formula\n" +
   "given above."},
 {:func_name=>"gsl_cdf_exponential_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "mu"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the exponential\n" +
   "distribution with mean mu."},
 {:func_name=>"gsl_cdf_exponential_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "mu"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the exponential\n" +
   "distribution with mean mu."},
 {:func_name=>"gsl_cdf_exponential_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"], ["double", "mu"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the exponential\n" +
   "distribution with mean mu."},
 {:func_name=>"gsl_cdf_exponential_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"], ["double", "mu"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the exponential\n" +
   "distribution with mean mu."},
 {:func_name=>"gsl_ran_laplace",
  :func_type=>"double",
  :args=>[["const gsl_rng *", "r"], ["double", "a"]],
  :desc=>
   "This function returns a random variate from the Laplace distribution\n" +
   "with width a.  The distribution is,\n" +
   "\n" +
   "p(x) dx = @{1 \\over 2 a@}  \\exp(-|x/a|) dx\n" +
   "\n" +
   "for -\\infty < x < \\infty."},
 {:func_name=>"gsl_ran_laplace_pdf",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"]],
  :desc=>
   "This function computes the probability density p(x) at x\n" +
   "for a Laplace distribution with width a, using the formula\n" +
   "given above."},
 {:func_name=>"gsl_cdf_laplace_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Laplace\n" +
   "distribution with width a."},
 {:func_name=>"gsl_cdf_laplace_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Laplace\n" +
   "distribution with width a."},
 {:func_name=>"gsl_cdf_laplace_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"], ["double", "a"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Laplace\n" +
   "distribution with width a."},
 {:func_name=>"gsl_cdf_laplace_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"], ["double", "a"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Laplace\n" +
   "distribution with width a."},
 {:func_name=>"gsl_ran_exppow",
  :func_type=>"double",
  :args=>[["const gsl_rng *", "r"], ["double", "a"], ["double", "b"]],
  :desc=>
   "This function returns a random variate from the exponential power distribution\n" +
   "with scale parameter a and exponent b.  The distribution is,\n" +
   "\n" +
   "p(x) dx = @{1 \\over 2 a \\Gamma(1+1/b)@} \\exp(-|x/a|^b) dx\n" +
   "\n" +
   "for $x \\ge 0$\n" +
   "x >= 0.  For b = 1 this reduces to the Laplace\n" +
   "distribution.  For b = 2 it has the same form as a Gaussian\n" +
   "distribution, but with $a = \\sqrt{2} \\sigma$\n" +
   "a = \\sqrt@{2@} \\sigma."},
 {:func_name=>"gsl_ran_exppow_pdf",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "This function computes the probability density p(x) at x\n" +
   "for an exponential power distribution with scale parameter a\n" +
   "and exponent b, using the formula given above."},
 {:func_name=>"gsl_cdf_exppow_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) for the exponential power distribution with\n" +
   "parameters a and b."},
 {:func_name=>"gsl_cdf_exppow_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) for the exponential power distribution with\n" +
   "parameters a and b."},
 {:func_name=>"gsl_ran_cauchy",
  :func_type=>"double",
  :args=>[["const gsl_rng *", "r"], ["double", "a"]],
  :desc=>
   "This function returns a random variate from the Cauchy distribution with\n" +
   "scale parameter a.  The probability distribution for Cauchy\n" +
   "random variates is,\n" +
   "\n" +
   "p(x) dx = @{1 \\over a\\pi (1 + (x/a)^2) @} dx\n" +
   "\n" +
   "for x in the range -\\infty to +\\infty.  The Cauchy\n" +
   "distribution is also known as the Lorentz distribution."},
 {:func_name=>"gsl_ran_cauchy_pdf",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"]],
  :desc=>
   "This function computes the probability density p(x) at x\n" +
   "for a Cauchy distribution with scale parameter a, using the formula\n" +
   "given above."},
 {:func_name=>"gsl_cdf_cauchy_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Cauchy\n" +
   "distribution with scale parameter a."},
 {:func_name=>"gsl_cdf_cauchy_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Cauchy\n" +
   "distribution with scale parameter a."},
 {:func_name=>"gsl_cdf_cauchy_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"], ["double", "a"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Cauchy\n" +
   "distribution with scale parameter a."},
 {:func_name=>"gsl_cdf_cauchy_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"], ["double", "a"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Cauchy\n" +
   "distribution with scale parameter a."},
 {:func_name=>"gsl_ran_rayleigh",
  :func_type=>"double",
  :args=>[["const gsl_rng *", "r"], ["double", "sigma"]],
  :desc=>
   "This function returns a random variate from the Rayleigh distribution with\n" +
   "scale parameter sigma.  The distribution is,\n" +
   "\n" +
   "p(x) dx = @{x \\over \\sigma^2@} \\exp(- x^2/(2 \\sigma^2)) dx\n" +
   "\n" +
   "for x > 0."},
 {:func_name=>"gsl_ran_rayleigh_pdf",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "sigma"]],
  :desc=>
   "This function computes the probability density p(x) at x\n" +
   "for a Rayleigh distribution with scale parameter sigma, using the\n" +
   "formula given above."},
 {:func_name=>"gsl_cdf_rayleigh_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "sigma"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Rayleigh\n" +
   "distribution with scale parameter sigma."},
 {:func_name=>"gsl_cdf_rayleigh_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "sigma"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Rayleigh\n" +
   "distribution with scale parameter sigma."},
 {:func_name=>"gsl_cdf_rayleigh_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"], ["double", "sigma"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Rayleigh\n" +
   "distribution with scale parameter sigma."},
 {:func_name=>"gsl_cdf_rayleigh_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"], ["double", "sigma"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Rayleigh\n" +
   "distribution with scale parameter sigma."},
 {:func_name=>"gsl_ran_rayleigh_tail",
  :func_type=>"double",
  :args=>[["const gsl_rng *", "r"], ["double", "a"], ["double", "sigma"]],
  :desc=>
   "This function returns a random variate from the tail of the Rayleigh\n" +
   "distribution with scale parameter sigma and a lower limit of\n" +
   "a.  The distribution is,\n" +
   "\n" +
   "p(x) dx = @{x \\over \\sigma^2@} \\exp ((a^2 - x^2) /(2 \\sigma^2)) dx\n" +
   "\n" +
   "for x > a."},
 {:func_name=>"gsl_ran_rayleigh_tail_pdf",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "sigma"]],
  :desc=>
   "This function computes the probability density p(x) at x\n" +
   "for a Rayleigh tail distribution with scale parameter sigma and\n" +
   "lower limit a, using the formula given above."},
 {:func_name=>"gsl_ran_landau",
  :func_type=>"double",
  :args=>[["const gsl_rng *", "r"]],
  :desc=>
   "This function returns a random variate from the Landau distribution.  The\n" +
   "probability distribution for Landau random variates is defined\n" +
   "analytically by the complex integral,\n" +
   "\n" +
   "p(x) = (1/(2 \\pi i)) \\int_@{c-i\\infty@}^@{c+i\\infty@} ds exp(s log(s) + x s) \n" +
   "For numerical purposes it is more convenient to use the following\n" +
   "equivalent form of the integral,\n" +
   "\n" +
   "p(x) = (1/\\pi) \\int_0^\\infty dt \\exp(-t \\log(t) - x t) \\sin(\\pi t)."},
 {:func_name=>"gsl_ran_landau_pdf",
  :func_type=>"double",
  :args=>[["double", "x"]],
  :desc=>
   "This function computes the probability density p(x) at x\n" +
   "for the Landau distribution using an approximation to the formula given\n" +
   "above."},
 {:func_name=>"gsl_ran_levy",
  :func_type=>"double",
  :args=>[["const gsl_rng *", "r"], ["double", "c"], ["double", "alpha"]],
  :desc=>
   "This function returns a random variate from the Levy symmetric stable\n" +
   "distribution with scale c and exponent alpha.  The symmetric\n" +
   "stable probability distribution is defined by a Fourier transform,\n" +
   "\n" +
   "p(x) = @{1 \\over 2 \\pi@} \\int_@{-\\infty@}^@{+\\infty@} dt \\exp(-it x - |c t|^alpha)\n" +
   "\n" +
   "There is no explicit solution for the form of p(x) and the\n" +
   "library does not define a corresponding pdf function.  For\n" +
   "\\alpha = 1 the distribution reduces to the Cauchy distribution.  For\n" +
   "\\alpha = 2 it is a Gaussian distribution with $\\sigma = \\sqrt{2} c$ \n" +
   "\\sigma = \\sqrt@{2@} c.  For \\alpha < 1 the tails of the\n" +
   "distribution become extremely wide.\n" +
   "\n" +
   "The algorithm only works for $0 < \\alpha \\le 2$\n" +
   "0 < alpha <= 2."},
 {:func_name=>"gsl_ran_levy_skew",
  :func_type=>"double",
  :args=>
   [["const gsl_rng *", "r"],
    ["double", "c"],
    ["double", "alpha"],
    ["double", "beta"]],
  :desc=>
   "This function returns a random variate from the Levy skew stable\n" +
   "distribution with scale c, exponent alpha and skewness\n" +
   "parameter beta.  The skewness parameter must lie in the range\n" +
   "[-1,1].  The Levy skew stable probability distribution is defined\n" +
   "by a Fourier transform,\n" +
   "\n" +
   "p(x) = @{1 \\over 2 \\pi@} \\int_@{-\\infty@}^@{+\\infty@} dt \\exp(-it x - |c t|^alpha (1-i beta sign(t) tan(pi alpha/2)))\n" +
   "\n" +
   "When \\alpha = 1 the term \\tan(\\pi \\alpha/2) is replaced by\n" +
   "-(2/\\pi)\\log|t|.  There is no explicit solution for the form of\n" +
   "p(x) and the library does not define a corresponding pdf\n" +
   "function.  For \\alpha = 2 the distribution reduces to a Gaussian\n" +
   "distribution with $\\sigma = \\sqrt{2} c$ \n" +
   "\\sigma = \\sqrt@{2@} c and the skewness parameter has no effect.  \n" +
   "For \\alpha < 1 the tails of the distribution become extremely\n" +
   "wide.  The symmetric distribution corresponds to \\beta =\n" +
   "0.\n" +
   "\n" +
   "The algorithm only works for $0 < \\alpha \\le 2$\n" +
   "0 < alpha <= 2."},
 {:func_name=>"gsl_ran_gamma",
  :func_type=>"double",
  :args=>[["const gsl_rng *", "r"], ["double", "a"], ["double", "b"]],
  :desc=>
   "This function returns a random variate from the gamma\n" +
   "distribution.  The distribution function is,\n" +
   "\n" +
   "p(x) dx = @{1 \\over \\Gamma(a) b^a@} x^@{a-1@} e^@{-x/b@} dx\n" +
   "\n" +
   "for x > 0.\n" +
   "If X and Y are independent gamma-distributed random\n" +
   "variables of order a and b, then X+Y has a gamma\n" +
   "distribution of order a+b.\n" +
   "\n" +
   "The gamma distribution with an integer parameter a is known as the Erlang distribution.\n" +
   "\n" +
   "The variates are computed using the Marsaglia-Tsang fast gamma method.\n" +
   "This function for this method was previously called\n" +
   "gsl_ran_gamma_mt and can still be accessed using this name."},
 {:func_name=>"gsl_ran_gamma_knuth",
  :func_type=>"double",
  :args=>[["const gsl_rng *", "r"], ["double", "a"], ["double", "b"]],
  :desc=>
   "This function returns a gamma variate using the algorithms from Knuth (vol 2)."},
 {:func_name=>"gsl_ran_gamma_pdf",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "This function computes the probability density p(x) at x\n" +
   "for a gamma distribution with parameters a and b, using the\n" +
   "formula given above."},
 {:func_name=>"gsl_cdf_gamma_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the gamma\n" +
   "distribution with parameters a and b."},
 {:func_name=>"gsl_cdf_gamma_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the gamma\n" +
   "distribution with parameters a and b."},
 {:func_name=>"gsl_cdf_gamma_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the gamma\n" +
   "distribution with parameters a and b."},
 {:func_name=>"gsl_cdf_gamma_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the gamma\n" +
   "distribution with parameters a and b."},
 {:func_name=>"gsl_ran_flat",
  :func_type=>"double",
  :args=>[["const gsl_rng *", "r"], ["double", "a"], ["double", "b"]],
  :desc=>
   "This function returns a random variate from the flat (uniform)\n" +
   "distribution from a to b. The distribution is,\n" +
   "\n" +
   "p(x) dx = @{1 \\over (b-a)@} dx\n" +
   "\n" +
   "if $a \\le x < b$\n" +
   "a <= x < b and 0 otherwise."},
 {:func_name=>"gsl_ran_flat_pdf",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "This function computes the probability density p(x) at x\n" +
   "for a uniform distribution from a to b, using the formula\n" +
   "given above."},
 {:func_name=>"gsl_cdf_flat_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for a uniform distribution\n" +
   "from a to b."},
 {:func_name=>"gsl_cdf_flat_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for a uniform distribution\n" +
   "from a to b."},
 {:func_name=>"gsl_cdf_flat_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for a uniform distribution\n" +
   "from a to b."},
 {:func_name=>"gsl_cdf_flat_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for a uniform distribution\n" +
   "from a to b."},
 {:func_name=>"gsl_ran_lognormal",
  :func_type=>"double",
  :args=>[["const gsl_rng *", "r"], ["double", "zeta"], ["double", "sigma"]],
  :desc=>
   "This function returns a random variate from the lognormal\n" +
   "distribution.  The distribution function is,\n" +
   "\n" +
   "p(x) dx = @{1 \\over x \\sqrt@{2 \\pi \\sigma^2@} @} \\exp(-(\\ln(x) - \\zeta)^2/2 \\sigma^2) dx\n" +
   "\n" +
   "for x > 0."},
 {:func_name=>"gsl_ran_lognormal_pdf",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "zeta"], ["double", "sigma"]],
  :desc=>
   "This function computes the probability density p(x) at x\n" +
   "for a lognormal distribution with parameters zeta and sigma,\n" +
   "using the formula given above."},
 {:func_name=>"gsl_cdf_lognormal_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "zeta"], ["double", "sigma"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the lognormal\n" +
   "distribution with parameters zeta and sigma."},
 {:func_name=>"gsl_cdf_lognormal_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "zeta"], ["double", "sigma"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the lognormal\n" +
   "distribution with parameters zeta and sigma."},
 {:func_name=>"gsl_cdf_lognormal_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"], ["double", "zeta"], ["double", "sigma"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the lognormal\n" +
   "distribution with parameters zeta and sigma."},
 {:func_name=>"gsl_cdf_lognormal_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"], ["double", "zeta"], ["double", "sigma"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the lognormal\n" +
   "distribution with parameters zeta and sigma."},
 {:func_name=>"gsl_ran_chisq",
  :func_type=>"double",
  :args=>[["const gsl_rng *", "r"], ["double", "nu"]],
  :desc=>
   "This function returns a random variate from the chi-squared distribution\n" +
   "with nu degrees of freedom. The distribution function is,\n" +
   "\n" +
   "p(x) dx = @{1 \\over 2 \\Gamma(\\nu/2) @} (x/2)^@{\\nu/2 - 1@} \\exp(-x/2) dx\n" +
   "\n" +
   "for $x \\ge 0$\n" +
   "x >= 0. "},
 {:func_name=>"gsl_ran_chisq_pdf",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "nu"]],
  :desc=>
   "This function computes the probability density p(x) at x\n" +
   "for a chi-squared distribution with nu degrees of freedom, using\n" +
   "the formula given above."},
 {:func_name=>"gsl_cdf_chisq_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "nu"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the chi-squared\n" +
   "distribution with nu degrees of freedom."},
 {:func_name=>"gsl_cdf_chisq_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "nu"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the chi-squared\n" +
   "distribution with nu degrees of freedom."},
 {:func_name=>"gsl_cdf_chisq_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"], ["double", "nu"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the chi-squared\n" +
   "distribution with nu degrees of freedom."},
 {:func_name=>"gsl_cdf_chisq_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"], ["double", "nu"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the chi-squared\n" +
   "distribution with nu degrees of freedom."},
 {:func_name=>"gsl_ran_fdist",
  :func_type=>"double",
  :args=>[["const gsl_rng *", "r"], ["double", "nu1"], ["double", "nu2"]],
  :desc=>
   "This function returns a random variate from the F-distribution with degrees of freedom nu1 and nu2. The distribution function is,\n" +
   "\n" +
   "p(x) dx = \n" +
   "   @{ \\Gamma((\\nu_1 + \\nu_2)/2)\n" +
   "        \\over \\Gamma(\\nu_1/2) \\Gamma(\\nu_2/2) @} \n" +
   "   \\nu_1^@{\\nu_1/2@} \\nu_2^@{\\nu_2/2@} \n" +
   "   x^@{\\nu_1/2 - 1@} (\\nu_2 + \\nu_1 x)^@{-\\nu_1/2 -\\nu_2/2@}\n" +
   "\n" +
   "for $x \\ge 0$\n" +
   "x >= 0. "},
 {:func_name=>"gsl_ran_fdist_pdf",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "nu1"], ["double", "nu2"]],
  :desc=>
   "This function computes the probability density p(x) at x\n" +
   "for an F-distribution with nu1 and nu2 degrees of freedom,\n" +
   "using the formula given above."},
 {:func_name=>"gsl_cdf_fdist_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "nu1"], ["double", "nu2"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the F-distribution\n" +
   "with nu1 and nu2 degrees of freedom."},
 {:func_name=>"gsl_cdf_fdist_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "nu1"], ["double", "nu2"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the F-distribution\n" +
   "with nu1 and nu2 degrees of freedom."},
 {:func_name=>"gsl_cdf_fdist_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"], ["double", "nu1"], ["double", "nu2"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the F-distribution\n" +
   "with nu1 and nu2 degrees of freedom."},
 {:func_name=>"gsl_cdf_fdist_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"], ["double", "nu1"], ["double", "nu2"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the F-distribution\n" +
   "with nu1 and nu2 degrees of freedom."},
 {:func_name=>"gsl_ran_tdist",
  :func_type=>"double",
  :args=>[["const gsl_rng *", "r"], ["double", "nu"]],
  :desc=>
   "This function returns a random variate from the t-distribution.  The\n" +
   "distribution function is,\n" +
   "\n" +
   "p(x) dx = @{\\Gamma((\\nu + 1)/2) \\over \\sqrt@{\\pi \\nu@} \\Gamma(\\nu/2)@}\n" +
   "   (1 + x^2/\\nu)^@{-(\\nu + 1)/2@} dx\n" +
   "\n" +
   "for -\\infty < x < +\\infty."},
 {:func_name=>"gsl_ran_tdist_pdf",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "nu"]],
  :desc=>
   "This function computes the probability density p(x) at x\n" +
   "for a t-distribution with nu degrees of freedom, using the formula\n" +
   "given above."},
 {:func_name=>"gsl_cdf_tdist_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "nu"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the t-distribution\n" +
   "with nu degrees of freedom."},
 {:func_name=>"gsl_cdf_tdist_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "nu"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the t-distribution\n" +
   "with nu degrees of freedom."},
 {:func_name=>"gsl_cdf_tdist_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"], ["double", "nu"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the t-distribution\n" +
   "with nu degrees of freedom."},
 {:func_name=>"gsl_cdf_tdist_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"], ["double", "nu"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the t-distribution\n" +
   "with nu degrees of freedom."},
 {:func_name=>"gsl_ran_beta",
  :func_type=>"double",
  :args=>[["const gsl_rng *", "r"], ["double", "a"], ["double", "b"]],
  :desc=>
   "This function returns a random variate from the beta\n" +
   "distribution.  The distribution function is,\n" +
   "\n" +
   "p(x) dx = @{\\Gamma(a+b) \\over \\Gamma(a) \\Gamma(b)@} x^@{a-1@} (1-x)^@{b-1@} dx\n" +
   "\n" +
   "for $0 \\le x \\le 1$\n" +
   "0 <= x <= 1."},
 {:func_name=>"gsl_ran_beta_pdf",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "This function computes the probability density p(x) at x\n" +
   "for a beta distribution with parameters a and b, using the\n" +
   "formula given above."},
 {:func_name=>"gsl_cdf_beta_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the beta\n" +
   "distribution with parameters a and b."},
 {:func_name=>"gsl_cdf_beta_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the beta\n" +
   "distribution with parameters a and b."},
 {:func_name=>"gsl_cdf_beta_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the beta\n" +
   "distribution with parameters a and b."},
 {:func_name=>"gsl_cdf_beta_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the beta\n" +
   "distribution with parameters a and b."},
 {:func_name=>"gsl_ran_logistic",
  :func_type=>"double",
  :args=>[["const gsl_rng *", "r"], ["double", "a"]],
  :desc=>
   "This function returns a random variate from the logistic\n" +
   "distribution.  The distribution function is,\n" +
   "\n" +
   "p(x) dx = @{ \\exp(-x/a) \\over a (1 + \\exp(-x/a))^2 @} dx\n" +
   "\n" +
   "for -\\infty < x < +\\infty."},
 {:func_name=>"gsl_ran_logistic_pdf",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"]],
  :desc=>
   "This function computes the probability density p(x) at x\n" +
   "for a logistic distribution with scale parameter a, using the\n" +
   "formula given above."},
 {:func_name=>"gsl_cdf_logistic_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the logistic\n" +
   "distribution with scale parameter a."},
 {:func_name=>"gsl_cdf_logistic_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the logistic\n" +
   "distribution with scale parameter a."},
 {:func_name=>"gsl_cdf_logistic_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"], ["double", "a"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the logistic\n" +
   "distribution with scale parameter a."},
 {:func_name=>"gsl_cdf_logistic_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"], ["double", "a"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the logistic\n" +
   "distribution with scale parameter a."},
 {:func_name=>"gsl_ran_pareto",
  :func_type=>"double",
  :args=>[["const gsl_rng *", "r"], ["double", "a"], ["double", "b"]],
  :desc=>
   "This function returns a random variate from the Pareto distribution of\n" +
   "order a.  The distribution function is,\n" +
   "\n" +
   "p(x) dx = (a/b) / (x/b)^@{a+1@} dx\n" +
   "\n" +
   "for $x \\ge b$\n" +
   "x >= b."},
 {:func_name=>"gsl_ran_pareto_pdf",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "This function computes the probability density p(x) at x\n" +
   "for a Pareto distribution with exponent a and scale b, using\n" +
   "the formula given above."},
 {:func_name=>"gsl_cdf_pareto_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Pareto\n" +
   "distribution with exponent a and scale b."},
 {:func_name=>"gsl_cdf_pareto_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Pareto\n" +
   "distribution with exponent a and scale b."},
 {:func_name=>"gsl_cdf_pareto_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Pareto\n" +
   "distribution with exponent a and scale b."},
 {:func_name=>"gsl_cdf_pareto_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Pareto\n" +
   "distribution with exponent a and scale b."},
 {:func_name=>"gsl_ran_dir_2d",
  :func_type=>"void",
  :args=>[["const gsl_rng *", "r"], ["double *", "x"], ["double *", "y"]],
  :desc=>
   "This function returns a random direction vector v =\n" +
   "(x,y) in two dimensions.  The vector is normalized such that\n" +
   "|v|^2 = x^2 + y^2 = 1.  The obvious way to do this is to take a\n" +
   "uniform random number between 0 and 2\\pi and let x and\n" +
   "y be the sine and cosine respectively.  Two trig functions would\n" +
   "have been expensive in the old days, but with modern hardware\n" +
   "implementations, this is sometimes the fastest way to go.  This is the\n" +
   "case for the Pentium (but not the case for the Sun Sparcstation).\n" +
   "One can avoid the trig evaluations by choosing x and\n" +
   "y in the interior of a unit circle (choose them at random from the\n" +
   "interior of the enclosing square, and then reject those that are outside\n" +
   "the unit circle), and then dividing by $\\sqrt{x^2 + y^2}$\n" +
   "\\sqrt@{x^2 + y^2@}.\n" +
   "A much cleverer approach, attributed to von Neumann (See Knuth, v2, 3rd\n" +
   "ed, p140, exercise 23), requires neither trig nor a square root.  In\n" +
   "this approach, u and v are chosen at random from the\n" +
   "interior of a unit circle, and then x=(u^2-v^2)/(u^2+v^2) and\n" +
   "y=2uv/(u^2+v^2)."},
 {:func_name=>"gsl_ran_dir_2d_trig_method",
  :func_type=>"void",
  :args=>[["const gsl_rng *", "r"], ["double *", "x"], ["double *", "y"]],
  :desc=>
   "This function returns a random direction vector v =\n" +
   "(x,y) in two dimensions.  The vector is normalized such that\n" +
   "|v|^2 = x^2 + y^2 = 1.  The obvious way to do this is to take a\n" +
   "uniform random number between 0 and 2\\pi and let x and\n" +
   "y be the sine and cosine respectively.  Two trig functions would\n" +
   "have been expensive in the old days, but with modern hardware\n" +
   "implementations, this is sometimes the fastest way to go.  This is the\n" +
   "case for the Pentium (but not the case for the Sun Sparcstation).\n" +
   "One can avoid the trig evaluations by choosing x and\n" +
   "y in the interior of a unit circle (choose them at random from the\n" +
   "interior of the enclosing square, and then reject those that are outside\n" +
   "the unit circle), and then dividing by $\\sqrt{x^2 + y^2}$\n" +
   "\\sqrt@{x^2 + y^2@}.\n" +
   "A much cleverer approach, attributed to von Neumann (See Knuth, v2, 3rd\n" +
   "ed, p140, exercise 23), requires neither trig nor a square root.  In\n" +
   "this approach, u and v are chosen at random from the\n" +
   "interior of a unit circle, and then x=(u^2-v^2)/(u^2+v^2) and\n" +
   "y=2uv/(u^2+v^2)."},
 {:func_name=>"gsl_ran_dir_3d",
  :func_type=>"void",
  :args=>
   [["const gsl_rng *", "r"],
    ["double *", "x"],
    ["double *", "y"],
    ["double *", "z"]],
  :desc=>
   "This function returns a random direction vector v =\n" +
   "(x,y,z) in three dimensions.  The vector is normalized\n" +
   "such that |v|^2 = x^2 + y^2 + z^2 = 1.  The method employed is\n" +
   "due to Robert E. Knop (CACM 13, 326 (1970)), and explained in Knuth, v2,\n" +
   "3rd ed, p136.  It uses the surprising fact that the distribution\n" +
   "projected along any axis is actually uniform (this is only true for 3\n" +
   "dimensions)."},
 {:func_name=>"gsl_ran_dir_nd",
  :func_type=>"void",
  :args=>[["const gsl_rng *", "r"], ["size_t", "n"], ["double *", "x"]],
  :desc=>
   "\n" +
   "This function returns a random direction vector\n" +
   "$v = (x_1,x_2,\\ldots,x_n)$\n" +
   "v = (x_1,x_2,...,x_n) in n dimensions.  The vector is normalized\n" +
   "such that \n" +
   "$|v|^2 = x_1^2 + x_2^2 + \\cdots + x_n^2 = 1$\n" +
   "|v|^2 = x_1^2 + x_2^2 + ... + x_n^2 = 1.  The method\n" +
   "uses the fact that a multivariate Gaussian distribution is spherically\n" +
   "symmetric.  Each component is generated to have a Gaussian distribution,\n" +
   "and then the components are normalized.  The method is described by\n" +
   "Knuth, v2, 3rd ed, p135--136, and attributed to G. W. Brown, Modern\n" +
   "Mathematics for the Engineer (1956)."},
 {:func_name=>"gsl_ran_weibull",
  :func_type=>"double",
  :args=>[["const gsl_rng *", "r"], ["double", "a"], ["double", "b"]],
  :desc=>
   "This function returns a random variate from the Weibull distribution.  The\n" +
   "distribution function is,\n" +
   "\n" +
   "p(x) dx = @{b \\over a^b@} x^@{b-1@}  \\exp(-(x/a)^b) dx\n" +
   "\n" +
   "for $x \\ge 0$\n" +
   "x >= 0."},
 {:func_name=>"gsl_ran_weibull_pdf",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "This function computes the probability density p(x) at x\n" +
   "for a Weibull distribution with scale a and exponent b,\n" +
   "using the formula given above."},
 {:func_name=>"gsl_cdf_weibull_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Weibull\n" +
   "distribution with scale a and exponent b."},
 {:func_name=>"gsl_cdf_weibull_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Weibull\n" +
   "distribution with scale a and exponent b."},
 {:func_name=>"gsl_cdf_weibull_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Weibull\n" +
   "distribution with scale a and exponent b."},
 {:func_name=>"gsl_cdf_weibull_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Weibull\n" +
   "distribution with scale a and exponent b."},
 {:func_name=>"gsl_ran_gumbel1",
  :func_type=>"double",
  :args=>[["const gsl_rng *", "r"], ["double", "a"], ["double", "b"]],
  :desc=>
   "This function returns  a random variate from the Type-1 Gumbel\n" +
   "distribution.  The Type-1 Gumbel distribution function is,\n" +
   "\n" +
   "p(x) dx = a b \\exp(-(b \\exp(-ax) + ax)) dx\n" +
   "\n" +
   "for -\\infty < x < \\infty. "},
 {:func_name=>"gsl_ran_gumbel1_pdf",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "This function computes the probability density p(x) at x\n" +
   "for a Type-1 Gumbel distribution with parameters a and b,\n" +
   "using the formula given above."},
 {:func_name=>"gsl_cdf_gumbel1_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Type-1 Gumbel\n" +
   "distribution with parameters a and b."},
 {:func_name=>"gsl_cdf_gumbel1_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Type-1 Gumbel\n" +
   "distribution with parameters a and b."},
 {:func_name=>"gsl_cdf_gumbel1_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Type-1 Gumbel\n" +
   "distribution with parameters a and b."},
 {:func_name=>"gsl_cdf_gumbel1_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Type-1 Gumbel\n" +
   "distribution with parameters a and b."},
 {:func_name=>"gsl_ran_gumbel2",
  :func_type=>"double",
  :args=>[["const gsl_rng *", "r"], ["double", "a"], ["double", "b"]],
  :desc=>
   "This function returns a random variate from the Type-2 Gumbel\n" +
   "distribution.  The Type-2 Gumbel distribution function is,\n" +
   "\n" +
   "p(x) dx = a b x^@{-a-1@} \\exp(-b x^@{-a@}) dx\n" +
   "\n" +
   "for 0 < x < \\infty."},
 {:func_name=>"gsl_ran_gumbel2_pdf",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "This function computes the probability density p(x) at x\n" +
   "for a Type-2 Gumbel distribution with parameters a and b,\n" +
   "using the formula given above."},
 {:func_name=>"gsl_cdf_gumbel2_P",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Type-2 Gumbel\n" +
   "distribution with parameters a and b."},
 {:func_name=>"gsl_cdf_gumbel2_Q",
  :func_type=>"double",
  :args=>[["double", "x"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Type-2 Gumbel\n" +
   "distribution with parameters a and b."},
 {:func_name=>"gsl_cdf_gumbel2_Pinv",
  :func_type=>"double",
  :args=>[["double", "P"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Type-2 Gumbel\n" +
   "distribution with parameters a and b."},
 {:func_name=>"gsl_cdf_gumbel2_Qinv",
  :func_type=>"double",
  :args=>[["double", "Q"], ["double", "a"], ["double", "b"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(x), Q(x) and their inverses for the Type-2 Gumbel\n" +
   "distribution with parameters a and b."},
 {:func_name=>"gsl_ran_dirichlet",
  :func_type=>"void",
  :args=>
   [["const gsl_rng *", "r"],
    ["size_t", "K"],
    ["const double", "alpha[]"],
    ["double", "theta[]"]],
  :desc=>
   "This function returns an array of K random variates from a Dirichlet\n" +
   "distribution of order K-1. The distribution function is\n" +
   "\n" +
   "p(\\theta_1, ..., \\theta_K) d\\theta_1 ... d\\theta_K = \n" +
   "  (1/Z) \\prod_@{i=1@}^K \\theta_i^@{\\alpha_i - 1@} \\delta(1 -\\sum_@{i=1@}^K \\theta_i) d\\theta_1 ... d\\theta_K\n" +
   "\n" +
   "for $\\theta_i \\ge 0$ \n" +
   "theta_i >= 0\n" +
   "and $\\alpha_i > 0$ \n" +
   "alpha_i > 0.  The delta function ensures that \\sum \\theta_i = 1.\n" +
   "The normalization factor Z is\n" +
   "\n" +
   "Z = @{\\prod_@{i=1@}^K \\Gamma(\\alpha_i)@} / @{\\Gamma( \\sum_@{i=1@}^K \\alpha_i)@}\n" +
   "\n" +
   "The random variates are generated by sampling K values \n" +
   "from gamma distributions with parameters \n" +
   "$a=\\alpha_i$, $b=1$ \n" +
   "a=alpha_i, b=1, \n" +
   "and renormalizing. \n" +
   "See A.M. Law, W.D. Kelton, Simulation Modeling and Analysis (1991)."},
 {:func_name=>"gsl_ran_dirichlet_pdf",
  :func_type=>"double",
  :args=>
   [["size_t", "K"], ["const double", "alpha[]"], ["const double", "theta[]"]],
  :desc=>
   "This function computes the probability density \n" +
   "$p(\\theta_1, \\ldots , \\theta_K)$\n" +
   "p(\\theta_1, ... , \\theta_K)\n" +
   "at theta[K] for a Dirichlet distribution with parameters \n" +
   "alpha[K], using the formula given above."},
 {:func_name=>"gsl_ran_dirichlet_lnpdf",
  :func_type=>"double",
  :args=>
   [["size_t", "K"], ["const double", "alpha[]"], ["const double", "theta[]"]],
  :desc=>
   "This function computes the logarithm of the probability density \n" +
   "$p(\\theta_1, \\ldots , \\theta_K)$\n" +
   "p(\\theta_1, ... , \\theta_K)\n" +
   "for a Dirichlet distribution with parameters \n" +
   "alpha[K]."},
 {:func_name=>"gsl_ran_discrete_preproc",
  :func_type=>"gsl_ran_discrete_t *",
  :args=>[["size_t", "K"], ["const double *", "P"]],
  :desc=>
   "This function returns a pointer to a structure that contains the lookup\n" +
   "table for the discrete random number generator.  The array P[] contains\n" +
   "the probabilities of the discrete events; these array elements must all be \n" +
   "positive, but they needn't add up to one (so you can think of them more\n" +
   "generally as ``weights'')---the preprocessor will normalize appropriately.\n" +
   "This return value is used\n" +
   "as an argument for the gsl_ran_discrete function below."},
 {:func_name=>"gsl_ran_discrete",
  :func_type=>"size_t",
  :args=>[["const gsl_rng *", "r"], ["const gsl_ran_discrete_t *", "g"]],
  :desc=>
   "After the preprocessor, above, has been called, you use this function to\n" +
   "get the discrete random numbers."},
 {:func_name=>"gsl_ran_discrete_pdf",
  :func_type=>"double",
  :args=>[["size_t", "k"], ["const gsl_ran_discrete_t *", "g"]],
  :desc=>
   "Returns the probability P[k] of observing the variable k.\n" +
   "Since P[k] is not stored as part of the lookup table, it must be\n" +
   "recomputed; this computation takes O(K), so if K is large\n" +
   "and you care about the original array P[k] used to create the\n" +
   "lookup table, then you should just keep this original array P[k]\n" +
   "around."},
 {:func_name=>"gsl_ran_discrete_free",
  :func_type=>"void",
  :args=>[["gsl_ran_discrete_t *", "g"]],
  :desc=>"De-allocates the lookup table pointed to by g."},
 {:func_name=>"gsl_ran_poisson",
  :func_type=>"unsigned int",
  :args=>[["const gsl_rng *", "r"], ["double", "mu"]],
  :desc=>
   "This function returns a random integer from the Poisson distribution\n" +
   "with mean mu.  The probability distribution for Poisson variates is,\n" +
   "\n" +
   "p(k) = @{\\mu^k \\over k!@} \\exp(-\\mu)\n" +
   "\n" +
   "for $k \\ge 0$\n" +
   "k >= 0."},
 {:func_name=>"gsl_ran_poisson_pdf",
  :func_type=>"double",
  :args=>[["unsigned int", "k"], ["double", "mu"]],
  :desc=>
   "This function computes the probability p(k) of obtaining  k\n" +
   "from a Poisson distribution with mean mu, using the formula\n" +
   "given above."},
 {:func_name=>"gsl_cdf_poisson_P",
  :func_type=>"double",
  :args=>[["unsigned int", "k"], ["double", "mu"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(k), Q(k) for the Poisson distribution with parameter\n" +
   "mu."},
 {:func_name=>"gsl_cdf_poisson_Q",
  :func_type=>"double",
  :args=>[["unsigned int", "k"], ["double", "mu"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(k), Q(k) for the Poisson distribution with parameter\n" +
   "mu."},
 {:func_name=>"gsl_ran_bernoulli",
  :func_type=>"unsigned int",
  :args=>[["const gsl_rng *", "r"], ["double", "p"]],
  :desc=>
   "This function returns either 0 or 1, the result of a Bernoulli trial\n" +
   "with probability p.  The probability distribution for a Bernoulli\n" +
   "trial is,\n" +
   "\n" +
   "p(0) = 1 - p\n" +
   "p(1) = p\n"},
 {:func_name=>"gsl_ran_bernoulli_pdf",
  :func_type=>"double",
  :args=>[["unsigned int", "k"], ["double", "p"]],
  :desc=>
   "This function computes the probability p(k) of obtaining\n" +
   "k from a Bernoulli distribution with probability parameter\n" +
   "p, using the formula given above."},
 {:func_name=>"gsl_ran_binomial",
  :func_type=>"unsigned int",
  :args=>[["const gsl_rng *", "r"], ["double", "p"], ["unsigned int", "n"]],
  :desc=>
   "This function returns a random integer from the binomial distribution,\n" +
   "the number of successes in n independent trials with probability\n" +
   "p.  The probability distribution for binomial variates is,\n" +
   "\n" +
   "p(k) = @{n! \\over k! (n-k)! @} p^k (1-p)^@{n-k@}\n" +
   "\n" +
   "for $0 \\le k \\le n$\n" +
   "0 <= k <= n."},
 {:func_name=>"gsl_ran_binomial_pdf",
  :func_type=>"double",
  :args=>[["unsigned int", "k"], ["double", "p"], ["unsigned int", "n"]],
  :desc=>
   "This function computes the probability p(k) of obtaining k\n" +
   "from a binomial distribution with parameters p and n, using\n" +
   "the formula given above."},
 {:func_name=>"gsl_cdf_binomial_P",
  :func_type=>"double",
  :args=>[["unsigned int", "k"], ["double", "p"], ["unsigned int", "n"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(k), Q(k)  for the binomial\n" +
   "distribution with parameters p and n."},
 {:func_name=>"gsl_cdf_binomial_Q",
  :func_type=>"double",
  :args=>[["unsigned int", "k"], ["double", "p"], ["unsigned int", "n"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(k), Q(k)  for the binomial\n" +
   "distribution with parameters p and n."},
 {:func_name=>"gsl_ran_multinomial",
  :func_type=>"void",
  :args=>
   [["const gsl_rng *", "r"],
    ["size_t", "K"],
    ["unsigned int", "N"],
    ["const double", "p[]"],
    ["unsigned int", "n[]"]],
  :desc=>
   "\n" +
   "This function computes a random sample n[] from the multinomial\n" +
   "distribution formed by N trials from an underlying distribution\n" +
   "p[K]. The distribution function for n[] is,\n" +
   "\n" +
   "P(n_1, n_2, ..., n_K) = \n" +
   "  (N!/(n_1! n_2! ... n_K!)) p_1^n_1 p_2^n_2 ... p_K^n_K\n" +
   "\n" +
   "where ($n_1$, $n_2$, $\\ldots$, $n_K$)\n" +
   "(n_1, n_2, ..., n_K) \n" +
   "are nonnegative integers with \n" +
   "$\\sum_{k=1}^{K} n_k =N$ \n" +
   "sum_@{k=1@}^K n_k = N,\n" +
   "and\n" +
   "$(p_1, p_2, \\ldots, p_K)$ \n" +
   "(p_1, p_2, ..., p_K)\n" +
   "is a probability distribution with \\sum p_i = 1.  \n" +
   "If the array p[K] is not normalized then its entries will be\n" +
   "treated as weights and normalized appropriately.  The arrays n[]\n" +
   "and p[] must both be of length K.\n" +
   "\n" +
   "Random variates are generated using the conditional binomial method (see\n" +
   "C.S. Davis, The computer generation of multinomial random\n" +
   "variates, Comp. Stat. Data Anal. 16 (1993) 205--217 for details)."},
 {:func_name=>"gsl_ran_multinomial_pdf",
  :func_type=>"double",
  :args=>
   [["size_t", "K"], ["const double", "p[]"], ["const unsigned int", "n[]"]],
  :desc=>
   "This function computes the probability \n" +
   "$P(n_1, n_2, \\ldots, n_K)$\n" +
   "P(n_1, n_2, ..., n_K)\n" +
   "of sampling n[K] from a multinomial distribution \n" +
   "with parameters p[K], using the formula given above."},
 {:func_name=>"gsl_ran_multinomial_lnpdf",
  :func_type=>"double",
  :args=>
   [["size_t", "K"], ["const double", "p[]"], ["const unsigned int", "n[]"]],
  :desc=>
   "This function returns the logarithm of the probability for the\n" +
   "multinomial distribution $P(n_1, n_2, \\ldots, n_K)$\n" +
   "P(n_1, n_2, ..., n_K) with parameters p[K]."},
 {:func_name=>"gsl_ran_negative_binomial",
  :func_type=>"unsigned int",
  :args=>[["const gsl_rng *", "r"], ["double", "p"], ["double", "n"]],
  :desc=>
   "This function returns a random integer from the negative binomial\n" +
   "distribution, the number of failures occurring before n successes\n" +
   "in independent trials with probability p of success.  The\n" +
   "probability distribution for negative binomial variates is,\n" +
   "\n" +
   "p(k) = @{\\Gamma(n + k) \\over \\Gamma(k+1) \\Gamma(n) @} p^n (1-p)^k\n" +
   "\n" +
   "Note that n is not required to be an integer."},
 {:func_name=>"gsl_ran_negative_binomial_pdf",
  :func_type=>"double",
  :args=>[["unsigned int", "k"], ["double", "p"], ["double", "n"]],
  :desc=>
   "This function computes the probability p(k) of obtaining k\n" +
   "from a negative binomial distribution with parameters p and\n" +
   "n, using the formula given above."},
 {:func_name=>"gsl_cdf_negative_binomial_P",
  :func_type=>"double",
  :args=>[["unsigned int", "k"], ["double", "p"], ["double", "n"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(k), Q(k) for the negative binomial distribution with\n" +
   "parameters p and n."},
 {:func_name=>"gsl_cdf_negative_binomial_Q",
  :func_type=>"double",
  :args=>[["unsigned int", "k"], ["double", "p"], ["double", "n"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(k), Q(k) for the negative binomial distribution with\n" +
   "parameters p and n."},
 {:func_name=>"gsl_ran_pascal",
  :func_type=>"unsigned int",
  :args=>[["const gsl_rng *", "r"], ["double", "p"], ["unsigned int", "n"]],
  :desc=>
   "This function returns a random integer from the Pascal distribution.  The\n" +
   "Pascal distribution is simply a negative binomial distribution with an\n" +
   "integer value of n.\n" +
   "\n" +
   "p(k) = @{(n + k - 1)! \\over k! (n - 1)! @} p^n (1-p)^k\n" +
   "\n" +
   "for $k \\ge 0$\n" +
   "k >= 0"},
 {:func_name=>"gsl_ran_pascal_pdf",
  :func_type=>"double",
  :args=>[["unsigned int", "k"], ["double", "p"], ["unsigned int", "n"]],
  :desc=>
   "This function computes the probability p(k) of obtaining k\n" +
   "from a Pascal distribution with parameters p and\n" +
   "n, using the formula given above."},
 {:func_name=>"gsl_cdf_pascal_P",
  :func_type=>"double",
  :args=>[["unsigned int", "k"], ["double", "p"], ["unsigned int", "n"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(k), Q(k) for the Pascal distribution with\n" +
   "parameters p and n."},
 {:func_name=>"gsl_cdf_pascal_Q",
  :func_type=>"double",
  :args=>[["unsigned int", "k"], ["double", "p"], ["unsigned int", "n"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(k), Q(k) for the Pascal distribution with\n" +
   "parameters p and n."},
 {:func_name=>"gsl_ran_geometric",
  :func_type=>"unsigned int",
  :args=>[["const gsl_rng *", "r"], ["double", "p"]],
  :desc=>
   "This function returns a random integer from the geometric distribution,\n" +
   "the number of independent trials with probability p until the\n" +
   "first success.  The probability distribution for geometric variates\n" +
   "is,\n" +
   "\n" +
   "p(k) =  p (1-p)^(k-1)\n" +
   "\n" +
   "for $k \\ge 1$\n" +
   "k >= 1.  Note that the distribution begins with k=1 with this\n" +
   "definition.  There is another convention in which the exponent k-1 \n" +
   "is replaced by k."},
 {:func_name=>"gsl_ran_geometric_pdf",
  :func_type=>"double",
  :args=>[["unsigned int", "k"], ["double", "p"]],
  :desc=>
   "This function computes the probability p(k) of obtaining k\n" +
   "from a geometric distribution with probability parameter p, using\n" +
   "the formula given above."},
 {:func_name=>"gsl_cdf_geometric_P",
  :func_type=>"double",
  :args=>[["unsigned int", "k"], ["double", "p"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(k), Q(k) for the geometric distribution with parameter\n" +
   "p."},
 {:func_name=>"gsl_cdf_geometric_Q",
  :func_type=>"double",
  :args=>[["unsigned int", "k"], ["double", "p"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(k), Q(k) for the geometric distribution with parameter\n" +
   "p."},
 {:func_name=>"gsl_ran_hypergeometric",
  :func_type=>"unsigned int",
  :args=>
   [["const gsl_rng *", "r"],
    ["unsigned int", "n1"],
    ["unsigned int", "n2"],
    ["unsigned int", "t"]],
  :desc=>
   "This function returns a random integer from the hypergeometric\n" +
   "distribution.  The probability distribution for hypergeometric\n" +
   "random variates is,\n" +
   "\n" +
   "p(k) =  C(n_1, k) C(n_2, t - k) / C(n_1 + n_2, t)\n" +
   "\n" +
   "where C(a,b) = a!/(b!(a-b)!) and \n" +
   "$t \\leq n_1 + n_2$\n" +
   "t <= n_1 + n_2.  The domain of k is \n" +
   "$\\hbox{max}(0,t-n_2), \\ldots, \\hbox{min}(t,n_1)$ \n" +
   "max(0,t-n_2), ..., min(t,n_1).\n" +
   "\n" +
   "If a population contains n_1 elements of ``type 1'' and\n" +
   "n_2 elements of ``type 2'' then the hypergeometric\n" +
   "distribution gives the probability of obtaining k elements of\n" +
   "``type 1'' in t samples from the population without\n" +
   "replacement."},
 {:func_name=>"gsl_ran_hypergeometric_pdf",
  :func_type=>"double",
  :args=>
   [["unsigned int", "k"],
    ["unsigned int", "n1"],
    ["unsigned int", "n2"],
    ["unsigned int", "t"]],
  :desc=>
   "This function computes the probability p(k) of obtaining k\n" +
   "from a hypergeometric distribution with parameters n1, n2,\n" +
   "t, using the formula given above."},
 {:func_name=>"gsl_cdf_hypergeometric_P",
  :func_type=>"double",
  :args=>
   [["unsigned int", "k"],
    ["unsigned int", "n1"],
    ["unsigned int", "n2"],
    ["unsigned int", "t"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(k), Q(k) for the hypergeometric distribution with\n" +
   "parameters n1, n2 and t."},
 {:func_name=>"gsl_cdf_hypergeometric_Q",
  :func_type=>"double",
  :args=>
   [["unsigned int", "k"],
    ["unsigned int", "n1"],
    ["unsigned int", "n2"],
    ["unsigned int", "t"]],
  :desc=>
   "These functions compute the cumulative distribution functions\n" +
   "P(k), Q(k) for the hypergeometric distribution with\n" +
   "parameters n1, n2 and t."},
 {:func_name=>"gsl_ran_logarithmic",
  :func_type=>"unsigned int",
  :args=>[["const gsl_rng *", "r"], ["double", "p"]],
  :desc=>
   "This function returns a random integer from the logarithmic\n" +
   "distribution.  The probability distribution for logarithmic random variates\n" +
   "is,\n" +
   "\n" +
   "p(k) = @{-1 \\over \\log(1-p)@} @{(p^k \\over k)@}\n" +
   "\n" +
   "for $k \\ge 1$\n" +
   "k >= 1."},
 {:func_name=>"gsl_ran_logarithmic_pdf",
  :func_type=>"double",
  :args=>[["unsigned int", "k"], ["double", "p"]],
  :desc=>
   "This function computes the probability p(k) of obtaining k\n" +
   "from a logarithmic distribution with probability parameter p,\n" +
   "using the formula given above."},
 {:func_name=>"gsl_ran_shuffle",
  :func_type=>"void",
  :args=>
   [["const gsl_rng *", "r"],
    ["void *", "base"],
    ["size_t", "n"],
    ["size_t", "size"]],
  :desc=>
   "\n" +
   "This function randomly shuffles the order of n objects, each of\n" +
   "size size, stored in the array base[0..n-1].  The\n" +
   "output of the random number generator r is used to produce the\n" +
   "permutation.  The algorithm generates all possible n!\n" +
   "permutations with equal probability, assuming a perfect source of random\n" +
   "numbers.\n" +
   "\n" +
   "The following code shows how to shuffle the numbers from 0 to 51,\n" +
   "\n" +
   "int a[52];\n" +
   "\n" +
   "for (i = 0; i < 52; i++)\n" +
   "  @{\n" +
   "    a[i] = i;\n" +
   "  @}\n" +
   "\n" +
   "gsl_ran_shuffle (r, a, 52, sizeof (int));\n"},
 {:func_name=>"gsl_ran_choose",
  :func_type=>"int",
  :args=>
   [["const gsl_rng *", "r"],
    ["void *", "dest"],
    ["size_t", "k"],
    ["void *", "src"],
    ["size_t", "n"],
    ["size_t", "size"]],
  :desc=>
   "This function fills the array dest[k] with k objects taken\n" +
   "randomly from the n elements of the array\n" +
   "src[0..n-1].  The objects are each of size size.  The\n" +
   "output of the random number generator r is used to make the\n" +
   "selection.  The algorithm ensures all possible samples are equally\n" +
   "likely, assuming a perfect source of randomness.\n" +
   "\n" +
   "The objects are sampled without replacement, thus each object can\n" +
   "only appear once in dest[k].  It is required that k be less\n" +
   "than or equal to n.  The objects in dest will be in the\n" +
   "same relative order as those in src.  You will need to call\n" +
   "gsl_ran_shuffle(r, dest, n, size) if you want to randomize the\n" +
   "order.\n" +
   "\n" +
   "The following code shows how to select a random sample of three unique\n" +
   "numbers from the set 0 to 99,\n" +
   "\n" +
   "double a[3], b[100];\n" +
   "\n" +
   "for (i = 0; i < 100; i++)\n" +
   "  @{\n" +
   "    b[i] = (double) i;\n" +
   "  @}\n" +
   "\n" +
   "gsl_ran_choose (r, a, 3, b, 100, sizeof (double));\n"},
 {:func_name=>"gsl_ran_sample",
  :func_type=>"void",
  :args=>
   [["const gsl_rng *", "r"],
    ["void *", "dest"],
    ["size_t", "k"],
    ["void *", "src"],
    ["size_t", "n"],
    ["size_t", "size"]],
  :desc=>
   "This function is like gsl_ran_choose but samples k items\n" +
   "from the original array of n items src with replacement, so\n" +
   "the same object can appear more than once in the output sequence\n" +
   "dest.  There is no requirement that k be less than n\n" +
   "in this case."}]
