private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "x86"
	condition:
		true
}

rule function_16_0 {
	meta:
		name = "AllocTlsBuffer"
		size = 9
		refs = "0004 LocalAlloc"
	strings:
		$1 = { 50 6A 40 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_18_0 {
	meta:
		name = "InitThreadTLS"
		size = 68
		refs = "0002 GetTlsSize 000e TlsIndex 001b @RunError 0022 AllocTlsBuffer 003e TlsSetValue"
	strings:
		$1 = { 53 E8 ?? ?? ?? ?? 8B D8 85 DB 74 36 83 3D ?? ?? ?? ?? FF 75 0A B8 E2 00 00 00 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 85 C0 75 0C B8 E2 00 00 00 E8 ?? ?? ?? ?? EB 0C 50 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_19_0 {
	meta:
		name = "InitProcessTLS"
		size = 41
		refs = "0001 TlsLast 000a TlsAlloc 000f TlsIndex 0014 InitThreadTLS 001f TlsGetValue 0024 tlsBuffer"
	strings:
		$1 = { B8 ?? ?? ?? ?? 85 C0 74 1F E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_20_0 {
	meta:
		name = "ExitThreadTLS"
		size = 53
		refs = "0001 TlsLast 000b TlsIndex 0019 TlsGetValue 0023 LocalFree 0030 TlsSetValue"
	strings:
		$1 = { B8 ?? ?? ?? ?? 85 C0 74 2B 83 3D ?? ?? ?? ?? FF 74 22 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 74 13 50 E8 ?? ?? ?? ?? 6A 00 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_21_0 {
	meta:
		name = "ExitProcessTLS"
		size = 35
		refs = "0001 TlsLast 000a ExitThreadTLS 0010 TlsIndex 001e TlsFree"
	strings:
		$1 = { B8 ?? ?? ?? ?? 85 C0 74 19 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? FF 74 0B A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_22_0 {
	meta:
		name = "@GetTls"
		size = 64
		refs = "0002 ModuleIsLib 0007 TlsIndex 001b InitThreadTLS 0026 TlsGetValue 0030 tlsBuffer"
	strings:
		$1 = { 8A 0D ?? ?? ?? ?? A1 ?? ?? ?? ?? 84 C9 75 26 64 8B 15 2C 00 00 00 8B 04 82 C3 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 74 01 C3 A1 ?? ?? ?? ?? C3 50 E8 ?? ?? ?? ?? 85 C0 74 DB C3 }
	condition:
		$1
}

rule function_24_0 {
	meta:
		name = "UninitializeModule"
		size = 34
		refs = "0001 Module 0006 UnregisterModule 001d FreeLibrary"
	strings:
		$1 = { B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 74 0A 85 C0 74 06 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_25_0 {
	meta:
		name = "VclInit"
		size = 151
		refs = "000d ModuleIsLib 0013 ModuleIsPackage 0027 IsLibrary 002f HInstance 0035 Module 0049 ModuleIsCpp 004f InitializeModule 005d VclInit 0062 FindHInstance 006c DataMark 007b GetCommandLine 0081 CmdLine 008f IsConsole"
	strings:
		$1 = { 55 8B EC 8B 4D 10 8B 55 0C 8B 45 08 A2 ?? ?? ?? ?? 88 15 ?? ?? ?? ?? 84 C0 74 04 84 D2 74 04 33 C0 EB 02 B0 01 8B 15 ?? ?? ?? ?? 88 02 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 E8 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 75 39 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 02 0F B6 45 14 34 01 8B 15 ?? ?? ?? ?? 88 02 5D C3 }
	condition:
		$1
}

rule function_26_0 {
	meta:
		name = "VclExit"
		size = 45
		refs = "0004 ExitProc 000a ModuleIsLib 0026 UninitializeModule"
	strings:
		$1 = { 53 56 8B 35 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 75 14 83 3E 00 74 0F 8B 06 89 C3 33 C0 89 06 FF D3 83 3E 00 75 F1 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_27_0 {
	meta:
		name = "@InitPkg"
		size = 99
		refs = "000d ModuleIsLib 0014 ModuleIsPackage 001a Module 002f HInstance 0034 TlsLast 003f TlsProc 004b InitializeModule 0056 UninitializeModule"
	strings:
		$1 = { 55 8B EC 53 56 8B 5D 0C 8B 45 08 C6 05 ?? ?? ?? ?? 01 C6 05 ?? ?? ?? ?? 01 A3 ?? ?? ?? ?? 33 D2 89 15 ?? ?? ?? ?? 33 D2 89 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? B8 ?? ?? ?? ?? 85 C0 74 09 8B 34 9D ?? ?? ?? ?? FF D6 83 FB 01 75 07 E8 ?? ?? ?? ?? EB 09 85 DB 75 05 E8 ?? ?? ?? ?? 83 C8 FF 5E 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_30_0 {
	meta:
		name = "@InitLib"
		size = 76
		refs = "0001 Module 000f ModuleIsLib 0019 HInstance 0035 InitializeModule 003d DllProc 0042 TlsProc 0047 @StartLib"
	strings:
		$1 = { BA ?? ?? ?? ?? 83 7D 0C 01 75 30 50 52 C6 05 ?? ?? ?? ?? 01 8B 4D 08 89 0D ?? ?? ?? ?? 89 4A 04 C7 42 08 00 00 00 00 C7 42 0C 00 00 00 00 8D 40 08 89 42 14 E8 ?? ?? ?? ?? 5A 58 FF 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_31_0 {
	meta:
		name = "@InitExe"
		size = 73
		refs = "0006 TlsIndex 000d GetModuleHandle 0012 HInstance 001c Module 0037 InitializeModule 0043 @StartExe"
	strings:
		$1 = { 53 8B D8 33 C0 A3 ?? ?? ?? ?? 6A 00 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 8D 43 08 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_33_0 {
	meta:
		name = "SysInit"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34_0 {
	meta:
		name = "Abs"
		size = 4
		altNames = "Addr Append Assert Assign AssignFile Assigned BlockRead BlockWrite Break Chr Close CloseFile Concat Continue Copy Dec Delete Dispose Eof Eoln Erase Exclude Exit Fail FilePos FileSize FillChar Finalize FreeMem GetDir GetMem Halt Hi High Inc Include Initialize Insert Length Lo Low New Odd Ord Pi Pred Ptr Read Readln ReallocMem Rename Reset Rewrite Round RunError Seek SeekEof SeekEoln SetLength SetString SetTextBuf SizeOf Slice Sqr Str Succ Swap Trunc Truncate TypeHandle TypeInfo TypeOf Val VarArrayRedim VarCast VarClear VarCopy Write Writeln"
	strings:
		$1 = { 09 04 00 00 }
	condition:
		$1
}

rule function_140_0 {
	meta:
		name = "InterlockedExchangePointer"
		size = 11
	strings:
		$1 = { 89 C1 8B 01 F0 0F B1 11 75 FA C3 }
	condition:
		$1
}

rule function_143_0 {
	meta:
		name = "InterlockedAdd"
		size = 11
	strings:
		$1 = { 89 C1 89 D0 F0 0F C1 01 01 D0 C3 }
	condition:
		$1
}

rule function_144_0 {
	meta:
		name = "InterlockedIncrement"
		size = 11
		refs = "0006 InterlockedAdd"
	strings:
		$1 = { BA 01 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_146_0 {
	meta:
		name = "InterlockedCompareExchange"
		size = 6
	strings:
		$1 = { 91 F0 0F B1 11 C3 }
	condition:
		$1
}

rule function_267_0 {
	meta:
		name = "GetCmdShow"
		size = 41
		refs = "0012 GetStartupInfo"
	strings:
		$1 = { 53 83 C4 BC BB 0A 00 00 00 C7 04 24 44 00 00 00 54 E8 ?? ?? ?? ?? F6 44 24 2C 01 74 05 0F B7 5C 24 30 8B C3 83 C4 44 5B C3 }
	condition:
		$1
}

rule function_276_0 {
	meta:
		name = "LockCmpxchg"
		size = 5
	strings:
		$1 = { F0 0F B0 11 C3 }
	condition:
		$1
}

rule function_277_0 {
	meta:
		name = "@_StringLength"
		size = 6
		altNames = "GetBlockHeader __StringLength"
	strings:
		$1 = { 83 E8 04 8B 00 C3 }
	condition:
		$1
}

rule function_278_0 {
	meta:
		name = "SetBlockHeader"
		size = 6
	strings:
		$1 = { 83 E8 04 89 10 C3 }
	condition:
		$1
}

rule function_279_0 {
	meta:
		name = "Move12"
		size = 17
	strings:
		$1 = { 8B 08 89 0A 8B 48 04 8B 40 08 89 4A 04 89 42 08 C3 }
	condition:
		$1
}

rule function_280_0 {
	meta:
		name = "Move20"
		size = 29
	strings:
		$1 = { 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 48 0C 8B 40 10 89 4A 0C 89 42 10 C3 }
	condition:
		$1
}

rule function_281_0 {
	meta:
		name = "Move28"
		size = 41
	strings:
		$1 = { 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 48 0C 89 4A 0C 8B 48 10 89 4A 10 8B 48 14 8B 40 18 89 4A 14 89 42 18 C3 }
	condition:
		$1
}

rule function_282_0 {
	meta:
		name = "Move36"
		size = 29
	strings:
		$1 = { DF 28 DF 68 08 DF 68 10 DF 68 18 8B 48 20 89 4A 20 DF 7A 18 DF 7A 10 DF 7A 08 DF 3A C3 }
	condition:
		$1
}

rule function_283_0 {
	meta:
		name = "Move44"
		size = 35
	strings:
		$1 = { DF 28 DF 68 08 DF 68 10 DF 68 18 DF 68 20 8B 48 28 89 4A 28 DF 7A 20 DF 7A 18 DF 7A 10 DF 7A 08 DF 3A C3 }
	condition:
		$1
}

rule function_284_0 {
	meta:
		name = "Move52"
		size = 41
	strings:
		$1 = { DF 28 DF 68 08 DF 68 10 DF 68 18 DF 68 20 DF 68 28 8B 48 30 89 4A 30 DF 7A 28 DF 7A 20 DF 7A 18 DF 7A 10 DF 7A 08 DF 3A C3 }
	condition:
		$1
}

rule function_285_0 {
	meta:
		name = "Move60"
		size = 47
	strings:
		$1 = { DF 28 DF 68 08 DF 68 10 DF 68 18 DF 68 20 DF 68 28 DF 68 30 8B 48 38 89 4A 38 DF 7A 30 DF 7A 28 DF 7A 20 DF 7A 18 DF 7A 10 DF 7A 08 DF 3A C3 }
	condition:
		$1
}

rule function_286_0 {
	meta:
		name = "Move68"
		size = 53
	strings:
		$1 = { DF 28 DF 68 08 DF 68 10 DF 68 18 DF 68 20 DF 68 28 DF 68 30 DF 68 38 8B 48 40 89 4A 40 DF 7A 38 DF 7A 30 DF 7A 28 DF 7A 20 DF 7A 18 DF 7A 10 DF 7A 08 DF 3A C3 }
	condition:
		$1
}

rule function_287_0 {
	meta:
		name = "MoveX16L4"
		size = 45
	strings:
		$1 = { 83 E9 0C 01 C8 01 CA F7 D9 79 13 DF 2C 01 DF 6C 01 08 DF 7C 11 08 DF 3C 11 83 C1 10 78 ED DF 2C 01 DF 3C 11 8B 44 01 08 89 44 11 08 C3 }
	condition:
		$1
}

rule function_288_0 {
	meta:
		name = "MoveX8L4"
		size = 27
	strings:
		$1 = { 83 E9 04 01 C8 01 CA F7 D9 DF 2C 01 DF 3C 11 83 C1 08 78 F5 8B 04 01 89 04 11 C3 }
	condition:
		$1
}

rule function_289_0 {
	meta:
		name = "LockAllSmallBlockTypes"
		size = 88
		refs = "0004 NeverSleepOnMMThreadContention 000a IsMultiThread 0017 SmallBlockTypes 0025 Sleep 0030 LockCmpxchg"
	strings:
		$1 = { 53 56 57 BF ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 74 43 BE 37 00 00 00 BB ?? ?? ?? ?? EB 22 80 3F 00 75 1D 6A 00 E8 ?? ?? ?? ?? 8B CB B2 01 33 C0 E8 ?? ?? ?? ?? 84 C0 74 16 6A 0A E8 ?? ?? ?? ?? 8B CB B2 01 33 C0 E8 ?? ?? ?? ?? 84 C0 75 CF 83 C3 20 4E 75 EB 5F 5E 5B C3 }
	condition:
		$1
}

rule function_290_0 {
	meta:
		name = "LockMediumBlocks"
		size = 71
		refs = "0002 IsMultiThread 000d NeverSleepOnMMThreadContention 0017 Sleep 001c MediumBlocksLocked 0025 LockCmpxchg"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 00 74 3D EB 29 80 3D ?? ?? ?? ?? 00 75 20 6A 00 E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? B2 01 33 C0 E8 ?? ?? ?? ?? 84 C0 74 19 6A 0A E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? B2 01 33 C0 E8 ?? ?? ?? ?? 84 C0 75 C5 C3 }
	condition:
		$1
}

rule function_296_0 {
	meta:
		name = "LockLargeBlocks"
		size = 71
		refs = "0002 IsMultiThread 000d NeverSleepOnMMThreadContention 0017 Sleep 001c LargeBlocksLocked 0025 LockCmpxchg"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 00 74 3D EB 29 80 3D ?? ?? ?? ?? 00 75 20 6A 00 E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? B2 01 33 C0 E8 ?? ?? ?? ?? 84 C0 74 19 6A 0A E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? B2 01 33 C0 E8 ?? ?? ?? ?? 84 C0 75 C5 C3 }
	condition:
		$1
}

rule function_291_0 {
	meta:
		name = "RemoveMediumFreeBlock"
		size = 62
		refs = "0012 MediumBlockBins 0028 MediumBlockBinBitmaps 0039 MediumBlockBinGroupBitmap"
	strings:
		$1 = { 8B 48 04 8B 10 39 D1 89 11 89 4A 04 74 02 C3 90 81 E9 ?? ?? ?? ?? 89 CA C1 E9 03 0F B6 D6 B8 FE FF FF FF D3 C0 21 04 95 ?? ?? ?? ?? 75 E0 B8 FE FF FF FF 89 D1 D3 C0 21 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_292_0 {
	meta:
		name = "InsertMediumBlockIntoBin"
		size = 96
		refs = "001c MediumBlockBins 004c MediumBlockBinBitmaps 005b MediumBlockBinGroupBitmap"
	strings:
		$1 = { 81 EA 30 0B 00 00 C1 EA 08 81 EA FF 03 00 00 19 C9 21 CA 81 C2 FF 03 00 00 8D 0C D5 ?? ?? ?? ?? 8B 51 04 39 CA 89 08 89 50 04 89 02 89 41 04 74 03 C3 90 90 81 E9 ?? ?? ?? ?? 89 CA C1 E9 03 0F B6 D6 B8 01 00 00 00 D3 E0 09 04 95 ?? ?? ?? ?? B8 01 00 00 00 89 D1 D3 E0 09 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_293_0 {
	meta:
		name = "BinMediumSequentialFeedRemainder"
		size = 107
		refs = "0002 MediumSequentialFeedBytesLeft 000d LastSequentiallyFedMediumBlock 0035 InsertMediumBlockIntoBin 004d RemoveMediumFreeBlock"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 03 C3 90 90 A1 ?? ?? ?? ?? F6 40 FC 01 75 25 83 48 FC 08 8B 15 ?? ?? ?? ?? 29 D0 8D 4A 03 89 48 FC 89 54 02 F8 81 FA 30 0B 00 00 0F 83 ?? ?? ?? ?? C3 90 90 BA F0 FF FF FF 23 50 FC 81 FA 30 0B 00 00 72 12 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? BA F0 FF FF FF 23 50 FC 8B 0D ?? ?? ?? ?? 29 C8 01 CA EB B9 C3 }
	condition:
		$1
}

rule function_294_0 {
	meta:
		name = "AllocNewSequentialFeedMediumPool"
		size = 119
		refs = "0004 BinMediumSequentialFeedRemainder 0017 VirtualAlloc 0021 MediumBlockPoolsCircularList 0053 MediumSequentialFeedBytesLeft 005c LastSequentiallyFedMediumBlock"
	strings:
		$1 = { 53 8B D8 E8 ?? ?? ?? ?? 6A 04 68 00 10 00 00 68 F0 FF 13 00 6A 00 E8 ?? ?? ?? ?? 85 C0 74 4D 8B 15 ?? ?? ?? ?? 8B C8 C7 01 ?? ?? ?? ?? A3 ?? ?? ?? ?? 89 51 04 89 02 8B C8 81 C1 F0 FF 13 00 8B D1 83 EA 04 C7 02 02 00 00 00 BA E0 FF 13 00 2B D3 89 15 ?? ?? ?? ?? 2B CB 8B C1 A3 ?? ?? ?? ?? 8B D0 83 CB 02 83 EA 04 89 1A 5B C3 33 C0 A3 ?? ?? ?? ?? 33 C0 5B C3 }
	condition:
		$1
}

rule function_295_0 {
	meta:
		name = "FreeMediumBlockPool"
		size = 24
		refs = "0013 VirtualFree"
	strings:
		$1 = { 8B 10 8B 48 04 89 4A 04 89 11 68 00 80 00 00 6A 00 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_297_0 {
	meta:
		name = "AllocateLargeBlock"
		size = 98
		refs = "0021 VirtualAlloc 0037 LockLargeBlocks 003c LargeBlocksCircularList 0053 LargeBlocksLocked"
	strings:
		$1 = { 53 56 57 55 8B E8 8D B5 10 00 01 00 4E 83 C6 04 81 E6 00 00 FF FF 6A 04 68 00 10 10 00 56 6A 00 E8 ?? ?? ?? ?? 8B D8 85 DB 74 30 8B FB 89 6F 08 83 CE 04 89 77 0C E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 07 ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 89 47 04 89 18 C6 05 ?? ?? ?? ?? 00 83 C3 10 8B C3 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_298_0 {
	meta:
		name = "FreeLargeBlock"
		size = 163
		refs = "000d LockLargeBlocks 0030 VirtualFree 0053 VirtualQuery 0094 LargeBlocksLocked"
	strings:
		$1 = { 53 56 57 55 83 C4 DC 8B F0 83 EE 10 E8 ?? ?? ?? ?? 8B C6 8B 10 89 14 24 8B 50 04 89 54 24 04 8B 50 0C F6 C2 08 75 1A 68 00 80 00 00 6A 00 56 E8 ?? ?? ?? ?? 85 C0 74 04 33 FF EB 3F 83 CF FF EB 3A 8B DE 8B EA 83 E5 F0 33 FF 6A 1C 8D 44 24 0C 50 53 E8 ?? ?? ?? ?? 68 00 80 00 00 6A 00 53 E8 ?? ?? ?? ?? 85 C0 75 05 83 CF FF EB 0E 8B 74 24 14 3B EE 76 06 2B EE 01 F3 EB CF 85 FF 75 13 8B 44 24 04 8B 14 24 89 10 8B 04 24 8B 54 24 04 89 50 04 C6 05 ?? ?? ?? ?? 00 8B C7 83 C4 24 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_299_0 {
	meta:
		name = "ReallocateLargeBlock"
		size = 332
		refs = "004d VirtualQuery 0096 VirtualAlloc 00ce SysGetMem 00f6 MoveX16L4 00fd SysFreeMem 0137 MoveX8L4"
	strings:
		$1 = { 53 56 57 55 83 C4 E0 8B F2 8B F8 8B C7 83 E8 04 8B 00 8B D8 83 E3 F0 83 EB 14 3B DE 0F 83 E1 00 00 00 8B D3 C1 EA 02 03 D3 3B D6 76 04 8B EA EB 02 8B EE 8B D7 83 EA 10 83 E0 F0 03 D0 89 14 24 6A 1C 8D 44 24 08 50 8B 44 24 08 50 E8 ?? ?? ?? ?? 81 7C 24 14 00 00 01 00 75 70 81 64 24 10 00 00 FF FF 8B D6 2B D3 8B 44 24 10 3B D0 73 5C 8B D5 2B D3 81 C2 00 00 01 00 4A 81 E2 00 00 FF FF 8B DA 3B C3 73 02 8B D8 6A 04 68 00 20 00 00 53 8B 44 24 0C 50 E8 ?? ?? ?? ?? 85 C0 74 2D 6A 04 68 00 10 00 00 53 8B 44 24 0C 50 E8 ?? ?? ?? ?? 85 C0 74 17 8B C7 83 E8 10 89 70 08 8B D0 03 5A 0C 83 CB 08 89 5A 0C 8B DF EB 77 8B C5 E8 ?? ?? ?? ?? 8B D8 85 DB 74 6A 81 FD 2C 0A 04 00 76 08 8B C3 83 E8 10 89 70 08 8B C7 83 E8 10 8B 40 08 8B D3 8B CF 91 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? EB 3F D1 EB 3B F3 72 0A 8B DF 83 EF 10 89 77 08 EB 2F 8B C6 E8 ?? ?? ?? ?? 8B D8 85 DB 74 22 81 FE 2C 0A 04 00 76 08 8B C7 83 E8 10 89 70 08 8B D3 8B C7 8B CE E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 8B C3 83 C4 20 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_300_0 {
	meta:
		name = "SysGetMem"
		size = 900
		refs = "000e IsMultiThread 001d AllocSize2SmallBlockTypeIndX4 0024 SmallBlockTypes 00ae NeverSleepOnMMThreadContention 00b8 Sleep 00e8 MediumBlocksLocked 011e MediumBlockBinGroupBitmap 0131 MediumBlockBinBitmaps 013e MediumBlockBins 018e InsertMediumBlockIntoBin 019a MediumSequentialFeedBytesLeft 01a4 LastSequentiallyFedMediumBlock 01cf AllocNewSequentialFeedMediumPool 037d AllocateLargeBlock"
	strings:
		$1 = { 8D 50 03 C1 EA 03 3D 2C 0A 00 00 53 8A 0D ?? ?? ?? ?? 0F 87 48 02 00 00 84 C9 0F B6 82 ?? ?? ?? ?? 8D 1C C5 ?? ?? ?? ?? 75 56 8B 53 04 8B 42 08 B9 F8 FF FF FF 39 DA 74 17 83 42 0C 01 23 48 FC 89 4A 08 89 50 FC 74 28 C6 03 00 5B C3 90 90 90 8B 53 10 0F B7 4B 02 01 C1 3B 43 0C 77 76 83 42 0C 01 89 4B 08 C6 03 00 89 50 FC 5B C3 90 90 90 8B 4A 04 89 59 14 89 4B 04 C6 03 00 5B C3 90 90 B8 00 01 00 00 F0 0F B0 23 74 9F 83 C3 20 B8 00 01 00 00 F0 0F B0 23 74 91 83 C3 20 B8 00 01 00 00 F0 0F B0 23 74 83 83 EB 40 F3 90 80 3D ?? ?? ?? ?? 00 75 CB 6A 00 E8 ?? ?? ?? ?? B8 00 01 00 00 F0 0F B0 23 0F 84 5F FF FF FF 6A 0A E8 ?? ?? ?? ?? EB AC 56 57 80 3D ?? ?? ?? ?? 00 74 39 B8 00 01 00 00 F0 0F B0 25 ?? ?? ?? ?? 74 2A F3 90 80 3D ?? ?? ?? ?? 00 75 E6 6A 00 E8 ?? ?? ?? ?? B8 00 01 00 00 F0 0F B0 25 ?? ?? ?? ?? 74 09 6A 0A E8 ?? ?? ?? ?? EB C7 0F BE 73 01 23 35 ?? ?? ?? ?? 74 70 0F BC C6 8D 34 C5 00 00 00 00 8B 0C 85 ?? ?? ?? ?? 0F BC C9 8D 0C B1 8D 3C CD ?? ?? ?? ?? 8B 77 04 8B 56 04 89 57 04 89 3A 39 D7 75 17 BA FE FF FF FF D3 C2 21 14 85 ?? ?? ?? ?? 75 07 0F B3 05 ?? ?? ?? ?? BF F0 FF FF FF 23 7E FC 81 FF 60 0A 01 00 72 6C 89 FA 0F B7 7B 1A 29 FA 8D 04 37 8D 4A 03 89 48 FC 89 54 02 F8 E8 ?? ?? ?? ?? EB 55 0F B7 4B 18 8B 3D ?? ?? ?? ?? 39 CF 72 26 8B 35 ?? ?? ?? ?? 0F B7 4B 1A 8D 91 30 0B 00 00 39 D7 72 02 89 CF 29 FE 29 3D ?? ?? ?? ?? 89 35 ?? ?? ?? ?? EB 21 0F B7 43 1A 89 C7 E8 ?? ?? ?? ?? 89 C6 85 C0 75 10 A2 ?? ?? ?? ?? 88 03 5F 5E 5B C3 80 64 37 FC F7 8D 4F 06 89 4E FC 31 C0 A2 ?? ?? ?? ?? 89 1E 89 46 08 C7 46 0C 01 00 00 00 89 73 10 8D 46 20 0F B7 4B 02 8D 14 01 89 53 08 01 F7 29 CF 89 7B 0C C6 03 00 89 70 FC 5F 5E 5B C3 90 B8 00 01 00 00 F0 0F B0 25 ?? ?? ?? ?? 74 4B F3 90 80 3D ?? ?? ?? ?? 00 75 E6 6A 00 E8 ?? ?? ?? ?? B8 00 01 00 00 F0 0F B0 25 ?? ?? ?? ?? 74 2A 6A 0A E8 ?? ?? ?? ?? EB C7 90 90 90 3D 2C 0A 04 00 0F 87 0D 01 00 00 8D 98 D3 00 00 00 81 E3 00 FF FF FF 83 C3 30 84 C9 75 A6 8D 93 D0 F4 FF FF 89 D1 C1 EA 0D C1 E9 08 B8 FF FF FF FF D3 E0 23 04 95 ?? ?? ?? ?? 74 0C 83 E1 E0 0F BC C0 09 C1 EB 5E 90 90 B8 FE FF FF FF 89 D1 D3 E0 23 05 ?? ?? ?? ?? 74 17 0F BC D0 8B 04 95 ?? ?? ?? ?? 0F BC C8 89 D0 C1 E0 05 09 C1 EB 35 90 8B 0D ?? ?? ?? ?? 29 D9 72 1A A1 ?? ?? ?? ?? 29 D8 A3 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 83 CB 02 89 58 FC EB 07 89 D8 E8 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 00 5B C3 56 57 8D 3C CD ?? ?? ?? ?? 8B 77 04 8B 46 04 89 47 04 89 38 39 C7 75 17 B8 FE FF FF FF D3 C0 21 04 95 ?? ?? ?? ?? 75 07 0F B3 15 ?? ?? ?? ?? BF F0 FF FF FF 23 7E FC 89 FA 29 DA 74 1F 8D 04 33 8D 4A 03 89 48 FC 89 54 02 F8 81 FA 30 0B 00 00 72 0F E8 ?? ?? ?? ?? EB 08 90 90 90 80 64 37 FC F7 8D 4B 02 89 4E FC C6 05 ?? ?? ?? ?? 00 89 F0 5F 5E 5B C3 5B 85 C0 0F 89 ?? ?? ?? ?? 31 C0 C3 }
	condition:
		$1
}

rule function_301_0 {
	meta:
		name = "SysFreeMem"
		size = 504
		refs = "000b IsMultiThread 008b NeverSleepOnMMThreadContention 0097 Sleep 00c5 MediumBlocksLocked 013f InsertMediumBlockIntoBin 0161 RemoveMediumFreeBlock 0182 MediumSequentialFeedBytesLeft 01a9 VirtualFree 01bf BinMediumSequentialFeedRemainder 01d6 LastSequentiallyFedMediumBlock 01ee FreeLargeBlock"
	strings:
		$1 = { 8B 50 FC F6 C2 07 89 C1 53 8A 1D ?? ?? ?? ?? 0F 85 E3 00 00 00 84 DB 8B 1A 75 61 83 6A 0C 01 8B 42 08 74 2C 85 C0 89 4A 08 8D 40 01 89 41 FC 74 07 31 C0 88 03 5B C3 90 8B 4B 04 89 5A 14 89 4A 04 89 51 14 89 53 04 C6 03 00 31 C0 5B C3 90 90 85 C0 74 13 8B 42 14 8B 4A 04 89 48 04 89 41 14 31 C0 39 53 10 75 03 89 43 0C 88 03 89 D0 8B 52 FC 8A 1D ?? ?? ?? ?? E9 85 00 00 00 B8 00 01 00 00 F0 0F B0 23 74 94 F3 90 80 3D ?? ?? ?? ?? 00 75 EA 51 52 6A 00 E8 ?? ?? ?? ?? 5A 59 B8 00 01 00 00 F0 0F B0 23 0F 84 6F FF FF FF 51 52 6A 0A E8 ?? ?? ?? ?? 5A 59 EB C3 90 90 90 B8 00 01 00 00 F0 0F B0 25 ?? ?? ?? ?? 74 42 F3 90 80 3D ?? ?? ?? ?? 00 75 E6 6A 00 E8 ?? ?? ?? ?? B8 00 01 00 00 F0 0F B0 25 ?? ?? ?? ?? 74 21 6A 0A E8 ?? ?? ?? ?? EB C7 90 90 90 F6 C2 05 0F 85 E7 00 00 00 83 E2 F0 84 DB 89 D3 56 89 C6 75 AF F7 44 33 FC 01 00 00 00 8B 4C 33 FC 75 35 83 C9 08 89 4C 33 FC F6 46 FC 08 75 40 81 FB E0 FF 13 00 74 50 8D 43 03 89 46 FC 89 5C 33 F8 89 F0 89 DA E8 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 00 31 C0 5E 5B C3 90 8D 04 33 83 E1 F0 01 CB 81 F9 30 0B 00 00 72 C2 E8 ?? ?? ?? ?? EB BB 90 8B 4E F8 29 CE 01 CB 81 F9 30 0B 00 00 72 B1 89 F0 E8 ?? ?? ?? ?? EB A8 81 3D ?? ?? ?? ?? E0 FF 13 00 75 2C 83 EE 10 8B 06 8B 56 04 89 50 04 89 02 C6 05 ?? ?? ?? ?? 00 68 00 80 00 00 6A 00 56 E8 ?? ?? ?? ?? 83 F8 01 19 C0 5E 5B C3 90 90 90 8D 9E E0 FF 13 00 E8 ?? ?? ?? ?? C7 43 FC 02 00 00 00 C7 05 ?? ?? ?? ?? E0 FF 13 00 89 1D ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 00 31 C0 5E 5B C3 90 90 5B F6 C2 03 0F 84 ?? ?? ?? ?? B8 FF FF FF FF C3 }
	condition:
		$1
}

rule function_302_0 {
	meta:
		name = "SysReallocMem"
		size = 790
		refs = "0031 SysGetMem 0042 MoveX8L4 0049 SysFreeMem 00fb IsMultiThread 010b MediumBlocksLocked 0115 NeverSleepOnMMThreadContention 0120 Sleep 0172 RemoveMediumFreeBlock 018e InsertMediumBlockIntoBin 02f5 MoveX16L4 030f ReallocateLargeBlock"
	strings:
		$1 = { 8B 48 FC F6 C1 07 53 56 89 C6 0F 85 88 00 00 00 8B 19 0F B7 4B 02 83 E9 04 39 D1 72 37 8D 1C 95 40 00 00 00 39 CB 72 04 5E 5B C3 90 89 D3 89 D0 E8 ?? ?? ?? ?? 85 C0 74 16 89 D9 89 C2 89 C3 89 F0 E8 ?? ?? ?? ?? 89 F0 E8 ?? ?? ?? ?? 89 D8 5E 5B C3 90 90 8D 4C 09 20 57 89 D7 31 C0 29 D1 83 D0 FF 21 C8 01 D0 E8 ?? ?? ?? ?? 85 C0 74 24 81 FF 2C 0A 04 00 76 03 89 78 F8 0F B7 4B 02 83 E9 04 89 C2 89 C7 89 F0 FF 53 1C 89 F0 E8 ?? ?? ?? ?? 89 F8 5F 5E 5B C3 90 F6 C1 05 0F 85 67 02 00 00 89 CB 83 E1 F0 57 8D 3C 01 83 E9 04 83 E3 0F 39 CA 55 0F 87 0F 01 00 00 8D 2C 12 39 CD 72 08 5D 5F 5E 5B C3 90 90 90 81 FA 2C 0B 00 00 73 15 81 FA CC 02 00 00 0F 82 C4 00 00 00 BA 2C 0B 00 00 39 D1 76 DB 8D AA D3 00 00 00 81 E5 00 FF FF FF 83 C5 30 83 C1 04 29 E9 80 3D ?? ?? ?? ?? 00 74 46 B8 00 01 00 00 F0 0F B0 25 ?? ?? ?? ?? 74 2F F3 90 80 3D ?? ?? ?? ?? 00 75 E6 51 6A 00 E8 ?? ?? ?? ?? 59 B8 00 01 00 00 F0 0F B0 25 ?? ?? ?? ?? 74 0C 51 6A 0A E8 ?? ?? ?? ?? 59 EB C3 90 BB 0F 00 00 00 23 5E FC 09 EB 89 5E FC 89 CB 8B 57 FC F6 C2 01 75 09 83 CA 08 89 57 FC EB 17 90 89 F8 83 E2 F0 01 D3 01 D7 81 FA 30 0B 00 00 72 05 E8 ?? ?? ?? ?? 89 5F F8 8D 43 03 89 44 2E FC 81 FB 30 0B 00 00 72 0A 8D 04 2E 89 DA E8 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 00 89 F0 5D 5F 5E 5B C3 89 D7 89 D0 E8 ?? ?? ?? ?? 85 C0 74 16 89 C5 89 C2 89 F0 89 F9 E8 ?? ?? ?? ?? 89 F0 E8 ?? ?? ?? ?? 89 E8 5D 5F 5E 5B C3 8B 47 FC A8 01 0F 84 ED 00 00 00 83 E0 F0 8D 2C 01 39 EA 0F 87 DF 00 00 00 80 3D ?? ?? ?? ?? 00 74 5B B8 00 01 00 00 F0 0F B0 25 ?? ?? ?? ?? 74 33 F3 90 80 3D ?? ?? ?? ?? 00 75 E6 51 52 6A 00 E8 ?? ?? ?? ?? 5A 59 B8 00 01 00 00 F0 0F B0 25 ?? ?? ?? ?? 74 0E 51 52 6A 0A E8 ?? ?? ?? ?? 5A 59 EB BF 90 BB 0F 00 00 00 23 5E FC 8B 47 FC A8 01 74 7E 83 E0 F0 8D 2C 01 39 EA 77 74 3D 30 0B 00 00 72 0B 89 F8 51 52 E8 ?? ?? ?? ?? 5A 59 89 C8 C1 E8 02 01 C8 31 FF 29 D0 83 D7 FF 21 F8 8D 84 02 D3 00 00 00 25 00 FF FF FF 83 C0 30 8D 55 04 29 C2 77 0B 83 24 2E F7 83 C5 04 EB 1E 90 90 89 54 2E FC 8D 7A 03 89 7C 30 FC 89 C5 81 FA 30 0B 00 00 72 07 01 F0 E8 ?? ?? ?? ?? 09 DD 89 6E FC C6 05 ?? ?? ?? ?? 00 89 F0 5D 5F 5E 5B C3 90 90 C6 05 ?? ?? ?? ?? 00 89 C8 C1 E8 02 01 C8 31 FF 29 D0 83 D7 FF 21 F8 01 D0 89 C5 89 CF 52 E8 ?? ?? ?? ?? 5A 85 C0 74 D1 81 FD 2C 0A 04 00 76 03 89 50 F8 89 C5 89 C2 89 F0 89 F9 E8 ?? ?? ?? ?? 89 F0 E8 ?? ?? ?? ?? 89 E8 5D 5F 5E 5B C3 90 5E 5B F6 C1 03 0F 84 ?? ?? ?? ?? 31 C0 C3 }
	condition:
		$1
}

rule function_303_0 {
	meta:
		name = "SysAllocMem"
		size = 50
		refs = "0008 SysGetMem"
	strings:
		$1 = { 53 8D 58 FF 83 E3 FC E8 ?? ?? ?? ?? 83 F8 01 19 C9 8D 14 03 09 CB 81 FB 2C 0A 04 00 73 12 F7 DB D9 EE DD 14 13 83 C3 08 78 F8 89 0A DD C0 D9 F7 5B C3 }
	condition:
		$1
}

rule function_304_0 {
	meta:
		name = "NextMediumBlock"
		size = 33
	strings:
		$1 = { 8B C8 8B D1 83 EA 04 8B 12 83 E2 F0 03 D1 8B C2 8B D0 83 EA 04 8B 12 83 E2 F0 85 D2 75 02 33 C0 C3 }
	condition:
		$1
}

rule function_305_0 {
	meta:
		name = "GetFirstMediumBlockInPool"
		size = 61
		refs = "0002 MediumSequentialFeedBytesLeft 000b LastSequentiallyFedMediumBlock"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 1A 8B 15 ?? ?? ?? ?? 3B D0 72 10 8B D0 81 C2 F0 FF 13 00 3B 15 ?? ?? ?? ?? 73 04 83 C0 10 C3 81 3D ?? ?? ?? ?? E0 FF 13 00 74 07 A1 ?? ?? ?? ?? EB 02 33 C0 C3 }
	condition:
		$1
}

rule function_306_0 {
	meta:
		name = "GetFirstAndLastSmallBlockInPool"
		size = 53
	strings:
		$1 = { 53 8B D8 83 C3 20 89 1A 8B 10 3B 42 10 75 08 8B 5A 08 3B 5A 0C 76 16 8B D8 83 EB 04 8B 1B 83 E3 F0 03 D8 0F B7 42 02 2B D8 89 19 5B C3 8B 42 08 48 89 01 5B C3 }
	condition:
		$1
}

rule function_307_0 {
	meta:
		name = "CardinalToStrBuf"
		size = 281
	strings:
		$1 = { 57 89 D7 83 C0 01 BA 41 5F 70 89 F7 E2 C1 E8 1E 89 D1 81 E2 FF FF FF 1F C1 E9 1D 8D 14 92 01 C2 89 C8 83 C8 30 88 07 89 D0 83 F9 01 83 DF FF C1 E8 1C 81 E2 FF FF FF 0F 09 C1 83 C8 30 88 07 8D 04 92 8D 14 92 83 F9 01 83 DF FF C1 E8 1B 81 E2 FF FF FF 07 09 C1 83 C8 30 88 07 8D 04 92 8D 14 92 83 F9 01 83 DF FF C1 E8 1A 81 E2 FF FF FF 03 09 C1 83 C8 30 88 07 8D 04 92 8D 14 92 83 F9 01 83 DF FF C1 E8 19 81 E2 FF FF FF 01 09 C1 83 C8 30 88 07 8D 04 92 8D 14 92 83 F9 01 83 DF FF C1 E8 18 81 E2 FF FF FF 00 09 C1 83 C8 30 88 07 8D 04 92 8D 14 92 83 F9 01 83 DF FF C1 E8 17 81 E2 FF FF 7F 00 09 C1 83 C8 30 88 07 8D 04 92 8D 14 92 83 F9 01 83 DF FF C1 E8 16 81 E2 FF FF 3F 00 09 C1 83 C8 30 88 07 8D 04 92 8D 14 92 83 F9 01 83 DF FF C1 E8 15 81 E2 FF FF 1F 00 09 C1 83 C8 30 88 07 8D 04 92 83 F9 01 83 DF FF C1 E8 14 83 C8 30 88 07 8D 47 01 5F C3 }
	condition:
		$1
}

rule function_308_0 {
	meta:
		name = "AppendStringToBuffer"
		size = 22
		refs = "000b Move"
	strings:
		$1 = { 53 56 8B F1 8B DA 8B D3 8B CE E8 ?? ?? ?? ?? 8B C3 03 C6 5E 5B C3 }
	condition:
		$1
}

rule function_309_0 {
	meta:
		name = "AppendClassNameToBuffer"
		size = 51
		refs = "0013 AppendStringToBuffer 001a UnknownClassNameMsg 001f @PCharLen"
	strings:
		$1 = { 53 8B DA 85 C0 74 12 83 C0 C8 8B 00 0F B6 08 40 8B D3 E8 ?? ?? ?? ?? 5B C3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_310_0 {
	meta:
		name = "IsValidVMTAddress"
		size = 123
		refs = "0042 VirtualQuery"
	strings:
		$1 = { 55 8B EC 53 8B D0 81 FA FF FF 00 00 76 68 F6 C2 03 75 63 8B 55 08 8B 52 E4 8B C8 3B D1 77 10 8B 5D 08 8B 5D 08 03 53 F0 83 C1 04 3B D1 73 17 8B 55 08 33 C9 89 4A F0 6A 1C 8B 55 08 83 C2 E4 52 50 E8 ?? ?? ?? ?? 8B 45 08 83 78 F0 04 72 1E 8B 45 08 81 78 F4 00 10 00 00 75 12 8B 45 08 F6 40 F8 F6 74 09 8B 45 08 F6 40 F9 01 74 04 33 C0 EB 07 B0 01 5B 5D C3 33 C0 5B 5D C3 }
	condition:
		$1
}

rule function_311_0 {
	meta:
		name = "InternalIsValidClass"
		size = 126
		refs = "001c IsValidVMTAddress 0066 InternalIsValidClass"
	strings:
		$1 = { 55 8B EC 53 56 57 8B FA 8B D8 81 FF E8 03 00 00 7D 65 8B 45 08 50 8B C3 83 C0 A8 E8 ?? ?? ?? ?? 59 84 C0 74 52 8B 45 08 50 8B C3 83 C0 D0 E8 ?? ?? ?? ?? 59 84 C0 74 3F 8B C3 83 C0 D0 8B 30 8B C3 83 C0 A8 3B 18 75 27 85 F6 74 27 8B 45 08 50 8B C6 E8 ?? ?? ?? ?? 59 84 C0 74 13 8B 45 08 50 8D 57 01 8B 06 E8 ?? ?? ?? ?? 59 84 C0 75 04 33 C0 EB 06 B0 01 EB 02 33 C0 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule function_312_0 {
	meta:
		name = "GetObjectClass"
		size = 38
		refs = "0014 InternalIsValidClass"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 8B 18 33 C0 89 45 F0 55 33 D2 8B C3 E8 ?? ?? ?? ?? 59 84 C0 75 02 33 DB 8B C3 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_313_0 {
	meta:
		name = "LockExpectedMemoryLeaksList"
		size = 114
		refs = "0002 IsMultiThread 000d NeverSleepOnMMThreadContention 0017 Sleep 001c ExpectedMemoryLeaksListLocked 0025 LockCmpxchg 0048 ExpectedMemoryLeaks 005e VirtualAlloc"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 00 74 3D EB 29 80 3D ?? ?? ?? ?? 00 75 20 6A 00 E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? B2 01 33 C0 E8 ?? ?? ?? ?? 84 C0 74 19 6A 0A E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? B2 01 33 C0 E8 ?? ?? ?? ?? 84 C0 75 C5 83 3D ?? ?? ?? ?? 00 75 18 6A 04 68 00 10 00 00 68 00 00 01 00 6A 00 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 0F 95 C0 C3 }
	condition:
		$1
}

rule function_314_0 {
	meta:
		name = "SysRegisterExpectedMemoryLeak"
		size = 64
		refs = "0004 LockExpectedMemoryLeaksList 000d ExpectedMemoryLeaks 0039 ExpectedMemoryLeaksListLocked"
	strings:
		$1 = { 53 8B D8 E8 ?? ?? ?? ?? 84 C0 74 29 A1 ?? ?? ?? ?? 81 38 FE 3F 00 00 7D 1C A1 ?? ?? ?? ?? 8B 00 8B 15 ?? ?? ?? ?? 89 5C 82 04 A1 ?? ?? ?? ?? FF 00 B0 01 EB 02 33 C0 C6 05 ?? ?? ?? ?? 00 5B C3 }
	condition:
		$1
}

rule function_315_0 {
	meta:
		name = "SysUnregisterExpectedMemoryLeak"
		size = 86
		refs = "0006 ExpectedMemoryLeaks 0012 LockExpectedMemoryLeaksList 004b ExpectedMemoryLeaksListLocked"
	strings:
		$1 = { 53 56 57 8B F0 BF ?? ?? ?? ?? 33 DB 83 3F 00 74 3F E8 ?? ?? ?? ?? 84 C0 74 36 8B 07 8B 10 4A 85 D2 7C 26 42 33 C0 8B 0F 3B 74 81 04 75 17 8B 17 8B 12 8B 0F 8B 14 91 8B 0F 89 54 81 04 8B 17 FF 0A B3 01 EB 04 40 4A 75 DD C6 05 ?? ?? ?? ?? 00 8B C3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_316_0 {
	meta:
		name = "CheckSmallBlockPoolForLeaks"
		size = 454
		refs = "0013 SmallBlockTypes 0031 GetFirstAndLastSmallBlockInPool 004a SysUnregisterExpectedMemoryLeak 0066 GetObjectClass"
	strings:
		$1 = { 55 8B EC 83 C4 D0 53 56 57 89 45 FC 8B 45 FC 8B 00 81 E8 ?? ?? ?? ?? C1 E8 05 C1 E0 08 8B 55 08 8D BC C2 00 48 FE FF 8D 4D D4 8D 55 D8 8B 45 FC E8 ?? ?? ?? ?? E9 79 01 00 00 83 EE 04 F6 06 01 0F 85 61 01 00 00 8B 45 D8 E8 ?? ?? ?? ?? 84 C0 0F 85 51 01 00 00 8B 45 08 C6 80 FF 47 FE FF 00 33 DB 8B 45 D8 E8 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 0F 85 FE 00 00 00 8B 45 D8 81 78 04 00 01 00 00 0F 8D 1C 01 00 00 8B 45 D8 8B 40 08 89 45 F0 8B 45 D8 0F B7 40 02 89 45 E8 83 7D E8 01 74 0A 83 7D E8 02 0F 85 F9 00 00 00 8B 45 F0 40 F7 6D E8 83 C0 0C 89 45 EC 83 7D F0 00 0F 8E E2 00 00 00 8B 45 FC 8B 00 0F B7 40 02 83 E8 04 3B 45 EC 0F 8C CD 00 00 00 C6 45 DF 01 83 7D E8 01 75 4B 8B 45 D8 83 C0 0C 89 45 E4 8B 45 F0 85 C0 7E 22 89 45 D0 80 7D DF 00 74 08 8B 45 E4 80 38 20 73 04 33 C0 EB 02 B0 01 88 45 DF FF 45 E4 FF 4D D0 75 E1 80 7D DF 00 0F 84 87 00 00 00 8B 45 E4 80 38 00 75 7F BB 01 00 00 00 EB 78 8B 45 D8 83 C0 0C 89 45 E0 8B 45 F0 85 C0 7E 24 89 45 D0 80 7D DF 00 74 09 8B 45 E0 66 83 38 20 73 04 33 C0 EB 02 B0 01 88 45 DF 83 45 E0 02 FF 4D D0 75 DF 80 7D DF 00 74 3E 8B 45 E0 66 83 38 00 75 35 BB 02 00 00 00 EB 2E BB 03 00 00 00 8B 04 DF 3B 45 F8 74 0F 83 3C DF 00 74 09 43 81 FB FF 00 00 00 7E E9 81 FB FF 00 00 00 7F 08 8B 45 F8 89 04 DF EB 02 33 DB FF 44 DF 04 8B 45 FC 8B 00 0F B7 40 02 01 45 D8 8B 75 D8 3B 75 D4 0F 86 7B FE FF FF 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_317_0 {
	meta:
		name = "ScanForMemoryLeaks"
		size = 993
		refs = "002d @FillChar 0054 MediumBlockPoolsCircularList 0060 GetFirstMediumBlockInPool 0085 CheckSmallBlockPoolForLeaks 00a7 SysUnregisterExpectedMemoryLeak 00d2 NextMediumBlock 00ed LargeBlocksCircularList 015b LeakMessageHeader 0160 @PCharLen 0172 AppendStringToBuffer 0188 SmallBlockTypes 01df SmallLeakDetail 021a CardinalToStrBuf 023c BytesMessage 0275 UnknownClassNameMsg 0291 AnsiStringBlockMessage 02ad UnicodeStringBlockMessage 02ce AppendClassNameToBuffer 0344 LargeLeakDetail 03aa LeakMessageFooter 03c7 LeakMessageTitle 03d6 MessageBoxA"
	strings:
		$1 = { 55 8B EC 50 B8 27 00 00 00 81 C4 04 F0 FF FF 50 48 75 F6 8B 45 FC 81 C4 E0 F7 FF FF 53 56 57 8D 85 00 48 FE FF 33 C9 BA 00 B8 01 00 E8 ?? ?? ?? ?? 8D 85 DC 07 FE FF 33 C9 BA 00 40 00 00 E8 ?? ?? ?? ?? 33 C0 89 85 F8 47 FE FF C6 85 FF 47 FE FF 01 8B 3D ?? ?? ?? ?? E9 82 00 00 00 8B C7 E8 ?? ?? ?? ?? 8B D8 85 DB 74 72 8B C3 83 E8 04 8B 30 F7 C6 01 00 00 00 75 56 F7 C6 04 00 00 00 74 0B 55 8B C3 E8 ?? ?? ?? ?? 59 EB 43 81 BD F8 47 FE FF 00 10 00 00 7D 37 83 E6 F0 83 EE 04 89 B5 EC 47 FE FF 8B C3 E8 ?? ?? ?? ?? 84 C0 75 20 C6 85 FF 47 FE FF 00 8B 85 F8 47 FE FF 8B 95 EC 47 FE FF 89 94 85 DC 07 FE FF FF 85 F8 47 FE FF 8B C3 E8 ?? ?? ?? ?? 8B D8 85 DB 75 8E 8B 7F 04 81 FF ?? ?? ?? ?? 0F 85 72 FF FF FF 8B 1D ?? ?? ?? ?? EB 37 8B C3 83 C0 10 E8 ?? ?? ?? ?? 84 C0 75 26 C6 85 FF 47 FE FF 00 8B 73 0C 83 E6 F0 83 EE 04 83 EE 10 8B 85 F8 47 FE FF 89 B4 85 DC 07 FE FF FF 85 F8 47 FE FF 8B 5B 04 81 FB ?? ?? ?? ?? 74 0C 81 BD F8 47 FE FF 00 10 00 00 7C B5 80 BD FF 47 FE FF 00 0F 85 8F 02 00 00 C6 85 F7 47 FE FF 00 33 C0 89 85 E8 47 FE FF A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 8D 95 DC 87 FD FF A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 C7 85 F0 47 FE FF 37 00 00 00 C7 85 E0 47 FE FF ?? ?? ?? ?? 8D 85 FC 4F FE FF 89 85 DC 47 FE FF 8B 85 E0 47 FE FF 0F B7 00 83 E8 04 89 85 E4 47 FE FF C6 85 F6 47 FE FF 00 BF FF 00 00 00 8B 85 DC 47 FE FF 8B F0 8D 85 DB FF FD FF 3B D8 0F 87 2C 01 00 00 83 3E 00 0F 86 16 01 00 00 80 BD F7 47 FE FF 00 75 21 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 C6 85 F7 47 FE FF 01 80 BD F6 47 FE FF 00 75 56 C6 03 0D 43 C6 03 0A 43 8B 85 E8 47 FE FF 40 8B D3 E8 ?? ?? ?? ?? 8B D8 C6 03 20 43 C6 03 2D 43 C6 03 20 43 8B D3 8B 85 E4 47 FE FF E8 ?? ?? ?? ?? 8B D8 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 C6 85 F6 47 FE FF 01 EB 08 C6 03 2C 43 C6 03 20 43 8B C7 83 E8 01 72 07 74 21 48 74 3A EB 54 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 EB 44 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 EB 28 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 EB 0C 8B 46 FC 8B D3 E8 ?? ?? ?? ?? 8B D8 C6 03 20 43 C6 03 78 43 C6 03 20 43 8B 06 8B D3 E8 ?? ?? ?? ?? 8B D8 4F 83 EE 08 83 FF FF 0F 85 C6 FE FF FF 8B 85 E4 47 FE FF 89 85 E8 47 FE FF 81 85 DC 47 FE FF 00 08 00 00 83 85 E0 47 FE FF 20 FF 8D F0 47 FE FF 0F 85 77 FE FF FF 83 BD F8 47 FE FF 00 7E 7F 80 BD F7 47 FE FF 00 74 10 C6 03 0D 43 C6 03 0A 43 C6 03 0D 43 C6 03 0A 43 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 8B B5 F8 47 FE FF 4E 85 F6 72 41 46 33 FF 8D 85 DC 07 FE FF 89 85 DC 47 FE FF 85 FF 74 08 C6 03 2C 43 C6 03 20 43 8B 85 DC 47 FE FF 8B 00 8B D3 E8 ?? ?? ?? ?? 8B D8 8D 85 DB FF FD FF 3B D8 77 0B 47 83 85 DC 47 FE FF 04 4E 75 CE A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 8B D3 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 10 20 00 00 A1 ?? ?? ?? ?? 50 8D 85 DC 87 FD FF 50 6A 00 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_318_0 {
	meta:
		name = "GetMemoryManagerState"
		size = 328
		refs = "0013 @FillChar 001d SmallBlockTypes 0044 LockAllSmallBlockTypes 0049 LockMediumBlocks 004e MediumBlockPoolsCircularList 0068 GetFirstMediumBlockInPool 00ce NextMediumBlock 00f1 MediumBlocksLocked 010a LockLargeBlocks 010f LargeBlocksCircularList 013c LargeBlocksLocked"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 8B F8 8B C7 33 C9 BA 88 03 00 00 E8 ?? ?? ?? ?? B9 37 00 00 00 BA ?? ?? ?? ?? 8B C7 0F B7 1A 89 18 0F B7 1A 83 EB 04 89 58 04 85 DB 7D 05 33 DB 89 58 04 83 C0 10 83 C2 20 49 75 E0 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 04 24 E9 87 00 00 00 81 87 78 03 00 00 F0 FF 13 00 8B 04 24 E8 ?? ?? ?? ?? 8B D8 85 DB 74 66 8B C3 83 E8 04 8B 30 F7 C6 01 00 00 00 75 4A 8B EE 83 E5 F0 F7 C6 04 00 00 00 74 2E 8B 03 81 E8 ?? ?? ?? ?? C1 E8 05 89 44 24 04 29 AF 78 03 00 00 8B 44 24 04 03 C0 01 6C C7 0C 8B 44 24 04 03 C0 8B 53 0C 01 54 C7 08 EB 0F FF 87 70 03 00 00 83 ED 04 01 AF 74 03 00 00 8B C3 E8 ?? ?? ?? ?? 8B D8 85 DB 75 9A 8B 04 24 8B 40 04 89 04 24 B8 ?? ?? ?? ?? 3B 04 24 0F 85 6B FF FF FF C6 05 ?? ?? ?? ?? 00 B9 37 00 00 00 B8 ?? ?? ?? ?? C6 00 00 83 C0 20 49 75 F7 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? EB 1E 8B 50 0C 83 E2 F0 FF 87 7C 03 00 00 01 97 84 03 00 00 8B 50 08 01 97 80 03 00 00 8B 40 04 3D ?? ?? ?? ?? 75 DB C6 05 ?? ?? ?? ?? 00 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_319_0 {
	meta:
		name = "GetMemoryMap"
		size = 213
		refs = "0012 @FillChar 0017 LockMediumBlocks 001d MediumBlockPoolsCircularList 0044 MediumBlocksLocked 004a LockLargeBlocks 0050 LargeBlocksCircularList 008a LargeBlocksLocked 00a6 VirtualQuery"
	strings:
		$1 = { 53 56 57 83 C4 E0 8B F0 8B C6 33 C9 BA 00 00 01 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? EB 17 8B C2 C1 E8 10 33 DB 8D 0C 03 C6 04 0E 01 43 83 FB 14 75 F3 8B 52 04 81 FA ?? ?? ?? ?? 75 E1 C6 05 ?? ?? ?? ?? 00 E8 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? EB 2A 8B C7 C1 E8 10 8B 57 0C 83 E2 F0 89 14 24 8B 14 24 4A C1 EA 10 85 D2 72 0E 42 33 DB 8D 0C 03 C6 04 0E 01 43 4A 75 F5 8B 7F 04 81 FF ?? ?? ?? ?? 75 CE C6 05 ?? ?? ?? ?? 00 33 DB 8B FE 80 3F 00 75 2C 6A 1C 8D 44 24 08 50 8B C3 C1 E0 10 50 E8 ?? ?? ?? ?? 8B 44 24 14 3D 00 10 00 00 75 05 C6 07 03 EB 0A 3D 00 20 00 00 75 03 C6 07 04 43 47 81 FB 00 00 01 00 75 C5 83 C4 20 5F 5E 5B C3 }
	condition:
		$1
}

rule function_320_0 {
	meta:
		name = "GetHeapStatus"
		size = 354
		refs = "0013 @FillChar 0018 LockAllSmallBlockTypes 001d LockMediumBlocks 0022 MediumBlockPoolsCircularList 0043 GetFirstMediumBlockInPool 0071 SmallBlockTypes 00d3 NextMediumBlock 00f9 MediumSequentialFeedBytesLeft 0102 MediumBlocksLocked 011b LockLargeBlocks 0120 LargeBlocksCircularList 0149 LargeBlocksLocked"
	strings:
		$1 = { 53 56 57 55 83 C4 F0 8B F0 8B C6 33 C9 BA 28 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 04 24 E9 BC 00 00 00 81 06 00 00 14 00 81 46 08 00 00 14 00 83 46 20 20 8B 04 24 E8 ?? ?? ?? ?? 8B D8 85 DB 0F 84 90 00 00 00 8B C3 83 E8 04 8B 38 8B EF 83 E5 F0 F7 C7 01 00 00 00 75 68 F7 C7 04 00 00 00 74 54 8B 03 81 E8 ?? ?? ?? ?? C1 E8 05 89 44 24 04 8B 43 0C 8B 54 24 04 03 D2 03 D2 0F B7 14 D5 ?? ?? ?? ?? F7 EA 89 44 24 08 8B 43 0C 03 C0 03 C0 89 44 24 0C 2B 6C 24 08 83 ED 04 01 6E 14 8B 44 24 0C 83 C0 04 01 46 20 8B 44 24 08 2B 44 24 0C 01 46 0C EB 0F 83 ED 04 01 6E 0C 83 46 20 04 EB 03 01 6E 18 8B C3 E8 ?? ?? ?? ?? 8B D8 85 DB 0F 85 70 FF FF FF 8B 04 24 8B 40 04 89 04 24 B8 ?? ?? ?? ?? 3B 04 24 0F 85 36 FF FF FF A1 ?? ?? ?? ?? 01 46 1C C6 05 ?? ?? ?? ?? 00 BA 37 00 00 00 B8 ?? ?? ?? ?? C6 00 00 83 C0 20 4A 75 F7 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? EB 1A 8B 50 0C 83 E2 F0 01 16 01 56 08 8B 48 08 01 4E 0C 2B 50 08 01 56 20 8B 40 04 3D ?? ?? ?? ?? 75 DF C6 05 ?? ?? ?? ?? 00 8B 46 14 03 46 18 03 46 1C 89 46 10 83 C4 10 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_321_0 {
	meta:
		name = "BuildMappingObjectName"
		size = 51
		refs = "0002 GetCurrentProcessId 001a HexTable 0027 MappingObjectName"
	strings:
		$1 = { 53 E8 ?? ?? ?? ?? 8B D0 33 C0 8B C8 03 C9 03 C9 8B DA D3 EB 83 E3 0F 0F B6 8B ?? ?? ?? ?? BB 18 00 00 00 2B D8 88 8B ?? ?? ?? ?? 40 83 F8 08 75 D9 5B C3 }
	condition:
		$1
}

rule function_322_0 {
	meta:
		name = "FindSharedMemoryManager"
		size = 64
		refs = "0003 BuildMappingObjectName 0008 MappingObjectName 0011 OpenFileMappingA 0029 MapViewOfFile 0031 UnmapViewOfFile 0037 CloseHandle"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 04 E8 ?? ?? ?? ?? 8B D8 85 DB 75 04 33 F6 EB 1C 6A 00 6A 00 6A 00 6A 04 53 E8 ?? ?? ?? ?? 8B 30 50 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_323_0 {
	meta:
		name = "AttemptToUseSharedMemoryManager"
		size = 100
		refs = "0001 IsMemoryManagerSet 000b MappingObjectHandle 0013 MediumBlockPoolsCircularList 0020 LargeBlocksCircularList 002d FindSharedMemoryManager 0036 SetMemoryManager 0048 ShareMMErrorTitle 004e LivePointersErrorMsg 0056 MessageBoxA"
	strings:
		$1 = { E8 ?? ?? ?? ?? 84 C0 75 58 83 3D ?? ?? ?? ?? 00 75 4C B8 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 75 23 B8 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 75 16 E8 ?? ?? ?? ?? 85 C0 74 09 E8 ?? ?? ?? ?? B0 01 EB 25 33 C0 EB 21 68 10 20 00 00 A1 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? 50 6A 00 E8 ?? ?? ?? ?? 33 C0 EB 05 B0 01 C3 33 C0 C3 }
	condition:
		$1
}

rule function_324_0 {
	meta:
		name = "ShareMemoryManager"
		size = 93
		refs = "0001 IsMemoryManagerSet 000b MappingObjectHandle 0013 FindSharedMemoryManager 001c MappingObjectName 002b CreateFileMappingA 0043 MapViewOfFile 0049 ThisMemoryManager 004f UnmapViewOfFile"
	strings:
		$1 = { E8 ?? ?? ?? ?? 84 C0 75 51 83 3D ?? ?? ?? ?? 00 75 48 E8 ?? ?? ?? ?? 85 C0 75 3C 68 ?? ?? ?? ?? 6A 04 6A 00 6A 04 6A 00 6A FF E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 02 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? C7 00 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? B0 01 EB 05 33 C0 C3 33 C0 C3 }
	condition:
		$1
}

rule function_325_0 {
	meta:
		name = "BuildBlockTypeLookupTable"
		size = 66
		refs = "0007 SmallBlockTypes 000d MinimumBlockAlignment 002b AllocSize2SmallBlockTypeIndX4"
	strings:
		$1 = { 56 57 33 C0 33 F6 BA ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 74 05 F6 02 0F 75 1D 0F B7 3A C1 EF 03 8B CE 03 C9 03 C9 3B F8 76 0B 88 88 ?? ?? ?? ?? 40 3B F8 77 F5 8B C7 46 83 C2 20 83 FE 37 75 CC 5F 5E C3 }
	condition:
		$1
}

rule function_326_0 {
	meta:
		name = "GetMinimumBlockAlignment"
		size = 8
		refs = "0003 MinimumBlockAlignment"
	strings:
		$1 = { 0F B6 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_327_0 {
	meta:
		name = "SetMinimumBlockAlignment"
		size = 19
		refs = "0002 MinimumBlockAlignment 000e BuildBlockTypeLookupTable"
	strings:
		$1 = { 3A 05 ?? ?? ?? ?? 74 0A A2 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_328_0 {
	meta:
		name = "InitializeMemoryManager"
		size = 293
		refs = "0009 SmallBlockTypes 0014 MoveX16L4 00de BuildBlockTypeLookupTable 00e4 MediumBlockPoolsCircularList 00fc MediumBlockBins 010f LargeBlocksCircularList"
	strings:
		$1 = { 53 56 57 BE 37 00 00 00 BB ?? ?? ?? ?? 83 3B 00 75 06 C7 03 ?? ?? ?? ?? 8D 43 E4 89 43 F8 8D 43 E4 89 43 E8 33 C0 89 43 F0 C7 43 EC 01 00 00 00 0F B7 43 E6 03 C0 03 C0 8D 04 40 05 EF 00 00 00 25 00 FF FF FF 83 C0 30 3D 30 0B 00 00 73 05 B8 30 0B 00 00 05 D0 04 00 00 C1 E8 0D 83 F8 07 76 05 B8 07 00 00 00 8B C8 B2 FF D2 E2 88 53 E5 C1 E0 0D 66 05 30 0B 66 89 43 FC 0F B7 7B E6 0F B7 C7 8B C8 C1 E1 04 8D 0C 49 81 C1 EF 00 00 00 81 E1 00 FF FF FF 83 C1 30 81 F9 30 73 00 00 73 05 B9 30 73 00 00 81 F9 30 FF 00 00 76 05 B9 30 FF 00 00 8B C1 83 E8 20 0F B7 D7 8B CA 33 D2 F7 F1 66 F7 EF 66 05 EF 00 66 25 00 FF 66 83 C0 30 66 89 43 FE 83 C3 20 4E 0F 85 30 FF FF FF E8 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? BE 00 04 00 00 BA ?? ?? ?? ?? 8B C2 89 00 89 40 04 83 C2 08 4E 75 F3 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_329_0 {
	meta:
		name = "FreeAllMemory"
		size = 144
		refs = "0005 MediumBlockPoolsCircularList 000a LargeBlocksCircularList 001f VirtualFree 002f SmallBlockTypes 005a MediumBlockBins"
	strings:
		$1 = { 53 56 57 55 BB ?? ?? ?? ?? BE ?? ?? ?? ?? 8B 7B 04 EB 12 8B 6F 04 68 00 80 00 00 6A 00 57 E8 ?? ?? ?? ?? 8B FD 3B FB 75 EA BA 37 00 00 00 B8 ?? ?? ?? ?? 8B C8 89 48 14 8B C8 89 48 04 C7 40 08 01 00 00 00 33 C9 89 48 0C 83 C0 20 4A 75 E4 89 1B 89 5B 04 BA 00 04 00 00 B9 ?? ?? ?? ?? 8B C1 89 00 89 40 04 83 C1 08 4A 75 F3 8B 5E 04 EB 12 8B 7B 04 68 00 80 00 00 6A 00 53 E8 ?? ?? ?? ?? 8B DF 3B DE 75 EA 89 36 89 76 04 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_330_0 {
	meta:
		name = "FinalizeMemoryManager"
		size = 81
		refs = "0002 MappingObjectHandle 0010 CloseHandle 001d ReportMemoryLeaksOnShutdown 0025 ScanForMemoryLeaks 002b ExpectedMemoryLeaks 0040 VirtualFree 004c FreeAllMemory"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 12 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 74 05 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 19 68 00 80 00 00 6A 00 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_331_0 {
	meta:
		name = "AllocMem"
		size = 24
		refs = "0006 MemoryManager 0013 Error"
	strings:
		$1 = { 85 C0 74 0A FF 15 ?? ?? ?? ?? 85 C0 74 02 F3 C3 B0 01 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_332_0 {
	meta:
		name = "RegisterExpectedMemoryLeak"
		size = 27
		refs = "000b MemoryManager"
		altNames = "UnregisterExpectedMemoryLeak"
	strings:
		$1 = { 53 8B D8 85 DB 74 0C 8B C3 FF 15 ?? ?? ?? ?? 84 C0 75 04 33 C0 5B C3 B0 01 5B C3 }
	condition:
		$1
}

rule function_334_0 {
	meta:
		name = "@GetMem"
		size = 27
		refs = "0006 MemoryManager 0013 Error"
	strings:
		$1 = { 85 C0 7E 13 FF 15 ?? ?? ?? ?? 85 C0 74 02 F3 C3 B0 01 E9 ?? ?? ?? ?? 31 C0 F3 C3 }
	condition:
		$1
}

rule function_335_0 {
	meta:
		name = "@FreeMem"
		size = 24
		refs = "0006 MemoryManager 0013 Error"
	strings:
		$1 = { 85 C0 74 0A FF 15 ?? ?? ?? ?? 85 C0 75 02 F3 C3 B0 02 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_336_0 {
	meta:
		name = "@ReallocMem"
		size = 77
		refs = "000f MemoryManager 001e Error"
	strings:
		$1 = { 8B 08 85 C9 74 32 85 D2 74 18 50 89 C8 FF 15 ?? ?? ?? ?? 59 09 C0 74 19 89 01 C3 B0 02 E9 ?? ?? ?? ?? 89 10 89 C8 FF 15 ?? ?? ?? ?? 09 C0 75 EB C3 B0 01 E9 ?? ?? ?? ?? 85 D2 74 10 50 89 D0 FF 15 ?? ?? ?? ?? 59 09 C0 74 E7 89 01 C3 }
	condition:
		$1
}

rule function_337_0 {
	meta:
		name = "DefaultAllocMem"
		size = 33
		refs = "0007 @GetMem 0018 @FillChar"
	strings:
		$1 = { 53 56 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D8 85 DB 74 0B 8B C3 33 C9 8B D6 E8 ?? ?? ?? ?? 8B C3 5E 5B C3 }
	condition:
		$1
}

rule function_339_0 {
	meta:
		name = "GetMemoryManager"
		size = 27
		refs = "0002 MemoryManager"
	strings:
		$1 = { 8B 15 ?? ?? ?? ?? 89 10 8B 15 ?? ?? ?? ?? 89 50 04 8B 15 ?? ?? ?? ?? 89 50 08 C3 }
	condition:
		$1
}

rule function_340_0 {
	meta:
		name = "SetMemoryManager"
		size = 43
		refs = "0001 MemoryManager 0018 DefaultAllocMem 001f DefaultRegisterAndUnregisterExpectedMemoryLeak"
	strings:
		$1 = { BA ?? ?? ?? ?? 8B 08 89 0A 8B 48 04 89 4A 04 8B 40 08 89 42 08 C7 42 0C ?? ?? ?? ?? C7 42 10 ?? ?? ?? ?? C7 42 14 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_341_0 {
	meta:
		name = "GetMemoryManager"
		size = 19
		refs = "0005 MemoryManager"
	strings:
		$1 = { 56 57 8B F8 BE ?? ?? ?? ?? B9 06 00 00 00 F3 A5 5F 5E C3 }
	condition:
		$1
}

rule function_342_0 {
	meta:
		name = "SetMemoryManager"
		size = 19
		refs = "0005 MemoryManager"
	strings:
		$1 = { 56 57 8B F0 BF ?? ?? ?? ?? B9 06 00 00 00 F3 A5 5F 5E C3 }
	condition:
		$1
}

rule function_343_0 {
	meta:
		name = "IsMemoryManagerSet"
		size = 70
		refs = "0001 MemoryManager 0006 SysGetMem 000f SysFreeMem 0019 SysReallocMem 0023 SysAllocMem 002d SysRegisterExpectedMemoryLeak 0037 SysUnregisterExpectedMemoryLeak"
	strings:
		$1 = { B8 ?? ?? ?? ?? BA ?? ?? ?? ?? 3B 10 75 35 BA ?? ?? ?? ?? 3B 50 04 75 2B BA ?? ?? ?? ?? 3B 50 08 75 21 BA ?? ?? ?? ?? 3B 50 0C 75 17 BA ?? ?? ?? ?? 3B 50 10 75 0D BA ?? ?? ?? ?? 3B 50 14 75 03 33 C0 C3 B0 01 C3 }
	condition:
		$1
}

rule function_344_0 {
	meta:
		name = "ExceptObject"
		size = 32
		refs = "0001 @GetTls 0007 RaiseListPtr"
	strings:
		$1 = { E8 ?? ?? ?? ?? 83 B8 ?? ?? ?? ?? 00 74 0F E8 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 8B 40 08 C3 33 C0 C3 }
	condition:
		$1
}

rule function_345_0 {
	meta:
		name = "ExceptAddr"
		size = 32
		refs = "0001 @GetTls 0007 RaiseListPtr"
	strings:
		$1 = { E8 ?? ?? ?? ?? 83 B8 ?? ?? ?? ?? 00 74 0F E8 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 8B 40 04 C3 33 C0 C3 }
	condition:
		$1
}

rule function_346_0 {
	meta:
		name = "AcquireExceptionObject"
		size = 49
		refs = "0002 @GetTls 0008 RaiseListPtr 001a ExceptionAcquired"
	strings:
		$1 = { 53 E8 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 85 C0 74 1B 8B 58 08 33 D2 89 50 08 83 3D ?? ?? ?? ?? 00 74 0C 8B C3 FF 15 ?? ?? ?? ?? EB 02 33 DB 8B C3 5B C3 }
	condition:
		$1
}

rule function_348_0 {
	meta:
		name = "RaiseList"
		size = 12
		refs = "0001 @GetTls 0007 RaiseListPtr"
	strings:
		$1 = { E8 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_349_0 {
	meta:
		name = "SetRaiseList"
		size = 21
		refs = "0002 @GetTls 0008 RaiseListPtr"
	strings:
		$1 = { 50 E8 ?? ?? ?? ?? 8B 90 ?? ?? ?? ?? 8F 80 ?? ?? ?? ?? 89 D0 C3 }
	condition:
		$1
}

rule function_352_0 {
	meta:
		name = "RunErrorAt"
		size = 12
		refs = "0002 ErrorAddr 0007 @Halt"
	strings:
		$1 = { 89 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_353_0 {
	meta:
		name = "ErrorAt"
		size = 73
		refs = "000b ErrorProc 0021 @GetTls 0027 InOutRes 0038 reMap 0042 RunErrorAt"
	strings:
		$1 = { 53 56 8B F2 8B D8 80 E3 7F 83 3D ?? ?? ?? ?? 00 74 0A 8B D6 8B C3 FF 15 ?? ?? ?? ?? 84 DB 75 0D E8 ?? ?? ?? ?? 8B 98 ?? ?? ?? ?? EB 0F 80 FB 1B 77 0A 0F B6 C3 0F B6 98 ?? ?? ?? ?? 0F B6 C3 8B D6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_354_0 {
	meta:
		name = "Error"
		size = 29
		refs = "0016 ErrorAt"
	strings:
		$1 = { 55 8B EC 51 88 45 FF 8A 45 FF 24 7F 8D 55 FF 42 83 C2 04 8B 12 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule function_355_0 {
	meta:
		name = "SetLineBreakStyle"
		size = 39
		refs = "0022 SetInOutRes"
	strings:
		$1 = { 66 81 78 04 B0 D7 75 14 0F B7 48 06 66 81 E1 FE FF 0F B6 D2 66 0B CA 66 89 48 06 C3 B8 6B 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_356_0 {
	meta:
		name = "@_IOTest"
		size = 29
		refs = "0004 @GetTls 000a InOutRes 0018 Error"
	strings:
		$1 = { 50 52 51 E8 ?? ?? ?? ?? 83 B8 ?? ?? ?? ?? 00 59 5A 58 75 01 C3 31 C0 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_357_0 {
	meta:
		name = "SetInOutRes"
		size = 16
		refs = "0004 @GetTls 000a InOutRes"
	strings:
		$1 = { 53 8B D8 E8 ?? ?? ?? ?? 89 98 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_359_0 {
	meta:
		name = "ChDir"
		size = 17
		refs = "0006 @UStrToPWChar 000b ChDir"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_366_0 {
	meta:
		name = "MkDir"
		size = 17
		refs = "0006 @UStrToPWChar 000b MkDir"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_376_0 {
	meta:
		name = "RmDir"
		size = 17
		refs = "0006 @UStrToPWChar 000b RmDir"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_360_0 {
	meta:
		name = "ChDir"
		size = 21
		refs = "0005 SetCurrentDirectory 000f InOutError"
	strings:
		$1 = { 53 8B D8 53 E8 ?? ?? ?? ?? 66 85 C0 75 05 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_377_0 {
	meta:
		name = "RmDir"
		size = 21
		refs = "0005 RemoveDirectory 000f InOutError"
	strings:
		$1 = { 53 8B D8 53 E8 ?? ?? ?? ?? 66 85 C0 75 05 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_361_0 {
	meta:
		name = "@UGetDir"
		size = 123
		refs = "0038 GetCurrentDirectoryW 003e SetCurrentDirectoryW 006e @UStrFromWArray"
	strings:
		$1 = { 53 56 81 C4 E4 FB FF FF 8B F2 8B D8 84 DB 74 32 0F B6 C3 66 83 C0 41 48 66 89 04 24 66 C7 44 24 02 3A 00 66 C7 44 24 04 00 00 8D 84 24 12 02 00 00 50 68 05 01 00 00 E8 ?? ?? ?? ?? 54 E8 ?? ?? ?? ?? 8D 44 24 08 50 68 05 01 00 00 E8 ?? ?? ?? ?? 84 DB 74 0D 8D 84 24 12 02 00 00 50 E8 ?? ?? ?? ?? 8B C6 8D 54 24 08 B9 05 01 00 00 E8 ?? ?? ?? ?? 81 C4 1C 04 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_362_0 {
	meta:
		name = "@LGetDir"
		size = 119
		refs = "0032 GetCurrentDirectoryA 0038 SetCurrentDirectoryA 006a @LStrFromArray"
	strings:
		$1 = { 53 56 81 C4 F0 FD FF FF 8B F2 8B D8 84 DB 74 2C 0F B6 C3 83 C0 41 48 88 04 24 C6 44 24 01 3A C6 44 24 02 00 8D 84 24 09 01 00 00 50 68 05 01 00 00 E8 ?? ?? ?? ?? 54 E8 ?? ?? ?? ?? 8D 44 24 04 50 68 05 01 00 00 E8 ?? ?? ?? ?? 84 DB 74 0D 8D 84 24 09 01 00 00 50 E8 ?? ?? ?? ?? 8B C6 8D 54 24 04 B9 05 01 00 00 6A 00 E8 ?? ?? ?? ?? 81 C4 10 02 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_363_0 {
	meta:
		name = "@WGetDir"
		size = 122
		refs = "0037 GetCurrentDirectoryW 003d SetCurrentDirectoryW 006d @WStrFromWArray"
	strings:
		$1 = { 53 56 81 C4 E4 FB FF FF 8B F2 8B D8 84 DB 74 31 0F B6 C3 83 C0 41 48 66 89 04 24 66 C7 44 24 02 3A 00 66 C7 44 24 04 00 00 8D 84 24 12 02 00 00 50 68 05 01 00 00 E8 ?? ?? ?? ?? 54 E8 ?? ?? ?? ?? 8D 44 24 08 50 68 05 01 00 00 E8 ?? ?? ?? ?? 84 DB 74 0D 8D 84 24 12 02 00 00 50 E8 ?? ?? ?? ?? 8B C6 8D 54 24 08 B9 05 01 00 00 E8 ?? ?? ?? ?? 81 C4 1C 04 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_364_0 {
	meta:
		name = "@SGetDir"
		size = 111
		refs = "0018 @SGetDir 0026 @LGetDir 0039 @LStrToString 0048 @PStrNCpy 005d @LStrClr 0063 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 FC FE FF FF 53 56 33 DB 89 5D FC 8B F1 8B DA 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8D 55 FC E8 ?? ?? ?? ?? 8D 85 FC FE FF FF 8B 55 FC B9 FF 00 00 00 E8 ?? ?? ?? ?? 8D 95 FC FE FF FF 8B C3 8B CE E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_365_0 {
	meta:
		name = "IOResult"
		size = 29
		refs = "0002 @GetTls 0008 InOutRes"
	strings:
		$1 = { 53 E8 ?? ?? ?? ?? 8B 98 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 D2 89 90 ?? ?? ?? ?? 8B C3 5B C3 }
	condition:
		$1
}

rule function_367_0 {
	meta:
		name = "MkDir"
		size = 23
		refs = "0007 CreateDirectory 0011 InOutError"
	strings:
		$1 = { 53 8B D8 6A 00 53 E8 ?? ?? ?? ?? 66 85 C0 75 05 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_368_0 {
	meta:
		name = "Move"
		size = 253
		refs = "0011 Move"
	strings:
		$1 = { 39 D0 74 31 83 F9 20 77 7C 83 E9 08 7F 07 FF 24 8D ?? ?? ?? ?? DF 2C 01 DF 28 83 F9 08 7E 11 DF 68 08 83 F9 10 7E 06 DF 68 10 DF 7A 10 DF 7A 08 DF 3A DF 3C 11 C3 90 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 52 DF 28 8D 44 01 F8 8D 4C 0A F8 DF 28 51 F7 D9 83 E2 F8 8D 4C 0A 08 5A DF 2C 01 DF 3C 11 83 C1 08 7C F5 DF 3A 5A DF 3A C3 7E 2E 39 D0 77 D1 29 CA 39 D0 8D 14 11 76 C8 83 E9 08 51 DF 2C 01 DF 28 01 D1 83 E1 F8 29 D1 DF 2C 01 DF 3C 11 83 E9 08 7F F5 59 DF 3A DF 3C 11 C3 0F B6 08 88 0A C3 0F B7 08 66 89 0A C3 66 8B 08 8A 40 02 66 89 0A 88 42 02 C3 8B 08 89 0A C3 8B 08 8A 40 04 89 0A 88 42 04 C3 8B 08 66 8B 40 04 89 0A 66 89 42 04 C3 8B 08 8B 40 03 89 0A 89 42 03 C3 DF 28 DF 3A C3 }
	condition:
		$1
}

rule function_369_0 {
	meta:
		name = "MoveChars"
		size = 8
		refs = "0003 Move"
	strings:
		$1 = { 03 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_370_0 {
	meta:
		name = "GetParamStr"
		size = 185
		refs = "006b @UStrSetLength"
	strings:
		$1 = { 53 56 57 55 8B DA EB 03 83 C0 02 0F B7 10 66 85 D2 74 06 66 83 FA 20 76 EF 66 83 38 22 75 0C 66 83 78 02 22 75 05 83 C0 04 EB E0 33 FF 8B F0 EB 2C 66 83 FD 22 75 22 83 C0 02 EB 04 47 83 C0 02 0F B7 10 66 85 D2 74 06 66 83 FA 22 75 EE 66 83 38 00 74 09 83 C0 02 EB 04 47 83 C0 02 0F B7 28 66 83 FD 20 77 CB 8B C3 8B D7 E8 ?? ?? ?? ?? 8B C6 8B 33 33 C9 EB 34 66 83 FF 22 75 26 83 C0 02 EB 08 66 89 14 4E 83 C0 02 41 0F B7 10 66 85 D2 74 06 66 83 FA 22 75 EA 66 83 38 00 74 0D 83 C0 02 EB 08 66 89 3C 4E 83 C0 02 41 0F B7 38 66 83 FF 20 77 C3 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_371_0 {
	meta:
		name = "ParamCount"
		size = 95
		refs = "000b ParamCount 0018 GetCommandLine 0020 GetParamStr 004c @UStrClr 0052 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 F6 E8 ?? ?? ?? ?? 8D 55 FC E8 ?? ?? ?? ?? 8B D8 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B D8 83 7D FC 00 74 03 46 EB EB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_372_0 {
	meta:
		name = "ParamStr"
		size = 94
		refs = "0010 @UStrClr 0025 GetModuleFileName 0030 @UStrFromPWCharLen 0037 GetCommandLine 0042 GetParamStr"
	strings:
		$1 = { 53 56 57 81 C4 F4 FD FF FF 8B DA 8B F0 8B C3 E8 ?? ?? ?? ?? 85 F6 75 1E 68 05 01 00 00 8D 44 24 04 50 6A 00 E8 ?? ?? ?? ?? 8B C8 8B D4 8B C3 E8 ?? ?? ?? ?? EB 1E E8 ?? ?? ?? ?? 8B F8 8B D3 8B C7 E8 ?? ?? ?? ?? 8B F8 85 F6 74 08 83 3B 00 74 03 4E EB E9 81 C4 0C 02 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_373_0 {
	meta:
		name = "Randomize"
		size = 37
		refs = "0005 QueryPerformanceCounter 0011 RandSeed 0019 GetTickCount"
	strings:
		$1 = { 83 C4 F8 54 E8 ?? ?? ?? ?? 85 C0 74 0B 8B 04 24 A3 ?? ?? ?? ?? 59 5A C3 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 59 5A C3 }
	condition:
		$1
}

rule function_374_0 {
	meta:
		name = "Random"
		size = 26
		refs = "0005 RandSeed"
	strings:
		$1 = { 53 31 DB 69 93 ?? ?? ?? ?? 05 84 08 08 42 89 93 ?? ?? ?? ?? F7 E2 89 D0 5B C3 }
	condition:
		$1
}

rule function_375_0 {
	meta:
		name = "Random"
		size = 39
		refs = "0005 RandSeed 0016 two2neg32"
	strings:
		$1 = { 53 31 DB 69 93 ?? ?? ?? ?? 05 84 08 08 42 89 93 ?? ?? ?? ?? DD 83 ?? ?? ?? ?? 6A 00 52 DF 2C 24 83 C4 08 DE C9 5B C3 }
	condition:
		$1
}

rule function_378_0 {
	meta:
		name = "UpCase"
		size = 13
	strings:
		$1 = { 8B D0 80 C2 9F 80 EA 1A 73 02 2C 20 C3 }
	condition:
		$1
}

rule function_382_0 {
	meta:
		name = "UpCase"
		size = 23
	strings:
		$1 = { 8B D0 8B C8 83 C1 9F 66 83 E9 1A 73 07 8B D0 66 81 E2 DF FF 8B C2 C3 }
	condition:
		$1
}

rule function_383_0 {
	meta:
		name = "Reset8087CW"
		size = 13
		refs = "0003 Default8087CW 0008 Set8087CW"
	strings:
		$1 = { 0F B7 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_384_0 {
	meta:
		name = "Set8087CW"
		size = 15
		refs = "0002 Default8087CW"
	strings:
		$1 = { 66 A3 ?? ?? ?? ?? DB E2 D9 2D ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_385_0 {
	meta:
		name = "Get8087CW"
		size = 7
	strings:
		$1 = { 6A 00 D9 3C 24 58 C3 }
	condition:
		$1
}

rule function_386_0 {
	meta:
		name = "Int"
		size = 41
	strings:
		$1 = { 55 8B EC DB 6D 08 83 EC 04 D9 3C 24 D9 7C 24 02 9B 66 81 4C 24 02 00 0F D9 6C 24 02 D9 FC 9B D9 2C 24 83 C4 04 5D C2 0C 00 }
	condition:
		$1
}

rule function_387_0 {
	meta:
		name = "Frac"
		size = 45
	strings:
		$1 = { 55 8B EC DB 6D 08 D9 C0 83 EC 04 D9 3C 24 D9 7C 24 02 9B 66 81 4C 24 02 00 0F D9 6C 24 02 D9 FC 9B D9 2C 24 83 C4 04 DE E9 5D C2 0C 00 }
	condition:
		$1
}

rule function_388_0 {
	meta:
		name = "Exp"
		size = 32
	strings:
		$1 = { 55 8B EC DB 6D 08 D9 EA DE C9 D9 C0 D9 FC DC E9 D9 C9 D9 F0 D9 E8 DE C1 D9 FD DD D9 5D C2 0C 00 }
	condition:
		$1
}

rule function_389_0 {
	meta:
		name = "Cos"
		size = 13
	strings:
		$1 = { 55 8B EC DB 6D 08 D9 FF 9B 5D C2 0C 00 }
	condition:
		$1
}

rule function_390_0 {
	meta:
		name = "Sin"
		size = 13
	strings:
		$1 = { 55 8B EC DB 6D 08 D9 FE 9B 5D C2 0C 00 }
	condition:
		$1
}

rule function_391_0 {
	meta:
		name = "Ln"
		size = 17
	strings:
		$1 = { 55 8B EC DB 6D 08 D9 ED D9 C9 D9 F1 9B 5D C2 0C 00 }
	condition:
		$1
}

rule function_392_0 {
	meta:
		name = "ArcTan"
		size = 15
	strings:
		$1 = { 55 8B EC DB 6D 08 D9 E8 D9 F3 9B 5D C2 0C 00 }
	condition:
		$1
}

rule function_393_0 {
	meta:
		name = "Sqrt"
		size = 13
	strings:
		$1 = { 55 8B EC DB 6D 08 D9 FA 9B 5D C2 0C 00 }
	condition:
		$1
}

rule function_394_0 {
	meta:
		name = "@ROUND"
		size = 10
	strings:
		$1 = { 83 EC 08 DF 3C 24 9B 58 5A C3 }
	condition:
		$1
}

rule function_395_0 {
	meta:
		name = "@TRUNC"
		size = 34
	strings:
		$1 = { 83 EC 0C D9 3C 24 D9 7C 24 02 9B 66 81 4C 24 02 00 0F D9 6C 24 02 DF 7C 24 04 9B D9 2C 24 59 58 5A C3 }
	condition:
		$1
}

rule function_396_0 {
	meta:
		name = "@AbstractError"
		size = 26
		refs = "0002 AbstractErrorProc 0015 @RunError"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 06 FF 15 ?? ?? ?? ?? B8 D2 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_397_0 {
	meta:
		name = "OpenText"
		size = 89
		refs = "0026 @Close 003e TextOpen 0050 SetInOutRes"
	strings:
		$1 = { 53 56 8B F2 8B D8 0F B7 43 04 66 3D B0 D7 72 06 66 3D B3 D7 76 07 BB 66 00 00 00 EB 2C 66 3D B0 D7 74 07 8B C3 E8 ?? ?? ?? ?? 66 89 73 04 66 83 7B 48 00 75 0D 83 7B 18 00 75 07 C7 43 18 ?? ?? ?? ?? 8B C3 FF 53 18 8B D8 85 DB 74 07 8B C3 E8 ?? ?? ?? ?? 8B C3 5E 5B C3 }
	condition:
		$1
}

rule function_398_0 {
	meta:
		name = "@ResetText"
		size = 10
		refs = "0005 OpenText"
	strings:
		$1 = { 66 BA B1 D7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_399_0 {
	meta:
		name = "@RewritText"
		size = 10
		refs = "0005 OpenText"
	strings:
		$1 = { 66 BA B2 D7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_400_0 {
	meta:
		name = "@Append"
		size = 10
		refs = "0005 OpenText"
	strings:
		$1 = { 66 BA B3 D7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_401_0 {
	meta:
		name = "TextIn"
		size = 57
		refs = "001f ReadFile 0028 GetLastError"
	strings:
		$1 = { 53 8B D8 33 C0 89 43 10 33 C0 89 43 0C 6A 00 8D 43 10 50 8B 43 08 50 8B 43 14 50 8B 03 50 E8 ?? ?? ?? ?? 85 C0 75 0E E8 ?? ?? ?? ?? 83 F8 6D 75 06 33 C0 5B C3 33 C0 5B C3 }
	condition:
		$1
}

rule function_403_0 {
	meta:
		name = "TextOut"
		size = 58
		refs = "0020 WriteFile 0029 GetLastError"
	strings:
		$1 = { 53 56 51 8B D8 8B 73 0C 85 F6 75 04 33 C0 EB 26 6A 00 8D 44 24 04 50 56 8B 43 14 50 8B 03 50 E8 ?? ?? ?? ?? 85 C0 75 07 E8 ?? ?? ?? ?? EB 02 33 C0 33 D2 89 53 0C 5A 5E 5B C3 }
	condition:
		$1
}

rule function_404_0 {
	meta:
		name = "InternalClose"
		size = 15
		refs = "0005 CloseHandle"
	strings:
		$1 = { 53 8B D8 53 E8 ?? ?? ?? ?? 48 0F 94 C0 5B C3 }
	condition:
		$1
}

rule function_405_0 {
	meta:
		name = "TextClose"
		size = 31
		refs = "000c InternalClose 0015 GetLastError"
	strings:
		$1 = { 53 8B D8 66 C7 43 04 B0 D7 8B 03 E8 ?? ?? ?? ?? 84 C0 75 07 E8 ?? ?? ?? ?? 5B C3 33 C0 5B C3 }
	condition:
		$1
}

rule function_406_0 {
	meta:
		name = "TextOpenCleanup"
		size = 23
		refs = "0006 InternalClose 0011 GetLastError"
	strings:
		$1 = { 53 8B D8 8B 03 E8 ?? ?? ?? ?? 66 C7 43 04 B0 D7 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_407_0 {
	meta:
		name = "TextOpen"
		size = 429
		refs = "0033 TextIn 005c TextOut 0063 TextClose 006a FileNOPProc 008a CreateFile 00ae GetFileSize 00ca SetFilePointer 00eb ReadFile 0122 SetEndOfFile 0150 ErrOutput 015d GetStdHandle 0173 GetFileType 018e CloseHandle 01a6 GetLastError"
	strings:
		$1 = { 56 89 C6 31 C0 89 46 0C 89 46 10 66 8B 46 04 2D B1 D7 00 00 74 0B 48 74 20 48 74 2E E9 68 01 00 00 B8 00 00 00 80 BA 01 00 00 00 B9 03 00 00 00 C7 46 1C ?? ?? ?? ?? EB 27 B8 00 00 00 40 BA 01 00 00 00 B9 02 00 00 00 EB 0F B8 00 00 00 C0 BA 01 00 00 00 B9 03 00 00 00 C7 46 1C ?? ?? ?? ?? C7 46 24 ?? ?? ?? ?? C7 46 20 ?? ?? ?? ?? 66 83 7E 48 00 0F 84 B2 00 00 00 6A 00 68 80 00 00 00 51 6A 00 52 50 8D 46 48 50 E8 ?? ?? ?? ?? 83 F8 FF 0F 84 08 01 00 00 89 06 66 81 7E 04 B3 D7 0F 85 C3 00 00 00 66 FF 4E 04 6A 00 FF 36 E8 ?? ?? ?? ?? 40 0F 84 E6 00 00 00 2D 81 00 00 00 73 02 31 C0 6A 00 6A 00 50 FF 36 E8 ?? ?? ?? ?? 40 0F 84 CA 00 00 00 6A 00 89 E2 6A 00 52 68 80 00 00 00 8D 96 50 02 00 00 52 FF 36 E8 ?? ?? ?? ?? 5A 48 0F 85 A8 00 00 00 31 C0 39 D0 73 6B 80 BC 06 50 02 00 00 0E 74 03 40 EB EF 6A 02 6A 00 29 D0 50 FF 36 E8 ?? ?? ?? ?? 40 0F 84 80 00 00 00 FF 36 E8 ?? ?? ?? ?? 48 75 76 EB 3D 8D 86 50 02 00 00 C7 46 08 80 00 00 00 C7 46 24 ?? ?? ?? ?? 89 46 14 66 81 7E 04 B2 D7 74 04 6A F6 EB 0E 81 FE ?? ?? ?? ?? 75 04 6A F4 EB 02 6A F5 E8 ?? ?? ?? ?? 83 F8 FF 74 39 89 06 66 81 7E 04 B1 D7 74 17 FF 36 E8 ?? ?? ?? ?? 85 C0 74 10 83 F8 02 75 07 C7 46 20 ?? ?? ?? ?? 31 C0 5E C3 FF 36 E8 ?? ?? ?? ?? 66 C7 46 04 B0 D7 B8 69 00 00 00 EB EA 66 C7 46 04 B0 D7 E8 ?? ?? ?? ?? EB DD C3 }
	condition:
		$1
}

rule function_408_0 {
	meta:
		name = "@Assign"
		size = 97
		refs = "0011 @FillChar 0027 DefaultTextLineBreakStyle 0039 TextOpen 0040 @PWCharLen 0050 Move"
	strings:
		$1 = { 53 56 57 8B FA 8B D8 8B C3 33 C9 BA 50 02 00 00 E8 ?? ?? ?? ?? 8D 83 50 02 00 00 89 43 14 66 C7 43 04 B0 D7 0F B6 05 ?? ?? ?? ?? 66 89 43 06 C7 43 08 80 00 00 00 C7 43 18 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 8B F0 8B C7 8D 53 48 8B CE 03 C9 E8 ?? ?? ?? ?? 66 C7 44 73 48 00 00 33 C0 5F 5E 5B C3 }
	condition:
		$1
}

rule function_409_0 {
	meta:
		name = "InternalFlush"
		size = 69
		refs = "0020 Output 0027 ErrOutput 003d SetInOutRes"
	strings:
		$1 = { 53 0F B7 48 04 66 81 E9 B1 D7 74 0F 49 66 83 E9 02 73 0C 8B DA FF D3 8B D8 EB 1B 33 DB EB 17 3D ?? ?? ?? ?? 74 07 3D ?? ?? ?? ?? 75 04 33 DB EB 05 BB 67 00 00 00 85 DB 74 07 8B C3 E8 ?? ?? ?? ?? 8B C3 5B C3 }
	condition:
		$1
}

rule function_410_0 {
	meta:
		name = "Flush"
		size = 9
		refs = "0004 InternalFlush"
	strings:
		$1 = { 8B 50 1C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_411_0 {
	meta:
		name = "@Flush"
		size = 9
		refs = "0004 InternalFlush"
	strings:
		$1 = { 8B 50 20 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_414_0 {
	meta:
		name = "BlockIO"
		size = 142
		refs = "0032 GetLastError 0037 SetInOutRes"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B F1 8B FA 8B D8 8B 45 10 0F B7 53 04 23 D0 3B C2 75 5A 6A 00 8D 45 FC 50 8B 43 08 F7 EE 50 57 8B 03 50 FF 55 0C 85 C0 75 11 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 89 45 FC EB 41 8B 4B 08 8B 45 FC 33 D2 F7 F1 89 45 FC 8B 45 14 85 C0 74 0A 8B 45 14 8B 55 FC 89 10 EB 23 3B 75 FC 74 1E 8B 45 08 E8 ?? ?? ?? ?? 33 C0 89 45 FC EB 0F B8 67 00 00 00 E8 ?? ?? ?? ?? 33 C0 89 45 FC 8B 45 FC 5F 5E 5B 59 5D C2 10 00 }
	condition:
		$1
}

rule function_415_0 {
	meta:
		name = "@BlockRead"
		size = 30
		refs = "000e ReadFileX 0015 BlockIO"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 53 68 B1 D7 00 00 68 ?? ?? ?? ?? 6A 64 E8 ?? ?? ?? ?? 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_416_0 {
	meta:
		name = "@BlockWrite"
		size = 30
		refs = "000e WriteFileX 0015 BlockIO"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 53 68 B2 D7 00 00 68 ?? ?? ?? ?? 6A 65 E8 ?? ?? ?? ?? 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_417_0 {
	meta:
		name = "@Close"
		size = 86
		refs = "0039 SetInOutRes 0041 Input"
	strings:
		$1 = { 53 56 8B D8 33 F6 0F B7 43 04 66 3D B1 D7 72 2F 66 3D B3 D7 77 29 66 25 B2 D7 66 3D B2 D7 75 07 8B C3 FF 53 1C 8B F0 85 F6 75 07 8B C3 FF 53 24 8B F0 85 F6 74 1B 8B C6 E8 ?? ?? ?? ?? EB 12 81 FB ?? ?? ?? ?? 74 0A B8 67 00 00 00 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_418_0 {
	meta:
		name = "@EofFile"
		size = 28
		refs = "0007 @FilePos 0010 @FileSize"
	strings:
		$1 = { 53 56 8B D8 8B C3 E8 ?? ?? ?? ?? 8B F0 8B C3 E8 ?? ?? ?? ?? 3B F0 0F 9D C0 5E 5B C3 }
	condition:
		$1
}

rule function_419_0 {
	meta:
		name = "@EofText"
		size = 55
		refs = "0027 @ReadChar"
	strings:
		$1 = { 66 81 78 04 B1 D7 75 1D 8B 50 0C 3B 50 10 73 15 03 50 14 66 F7 40 06 01 00 74 19 8A 0A 80 F9 1A 75 12 B0 01 C3 50 E8 ?? ?? ?? ?? 5A 80 FC 1A 74 F1 FF 4A 0C 31 C0 C3 }
	condition:
		$1
}

rule function_420_0 {
	meta:
		name = "@Eoln"
		size = 87
		refs = "0037 @ReadChar"
	strings:
		$1 = { 66 81 78 04 B1 D7 75 2D 8B 50 0C 3B 50 10 73 25 03 50 14 66 F7 40 06 01 00 B0 00 8A 0A 74 0B 80 F9 0D 74 30 80 F9 1A 74 2B C3 80 F9 0A 74 25 80 F9 1A 74 20 C3 50 E8 ?? ?? ?? ?? 5A 80 FC 1A 74 13 FF 4A 0C 31 C9 91 66 F7 42 04 01 00 74 DB 80 F9 0D 75 02 B0 01 C3 }
	condition:
		$1
}

rule function_421_0 {
	meta:
		name = "@Erase"
		size = 56
		refs = "0019 SetInOutRes 0024 DeleteFile 002d GetLastError"
	strings:
		$1 = { 53 8B D8 0F B7 43 04 66 3D B0 D7 72 06 66 3D B3 D7 76 0C B8 66 00 00 00 E8 ?? ?? ?? ?? 5B C3 8D 43 48 50 E8 ?? ?? ?? ?? 85 C0 75 0A E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_422_0 {
	meta:
		name = "@FSafeDivideR"
		size = 8
		refs = "0003 @FSafeDivide"
	strings:
		$1 = { D9 C9 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_423_0 {
	meta:
		name = "@FSafeDivide"
		size = 354
		refs = "0002 TestFDIV 0050 @FSafeDivide"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 00 7E 7E DE F9 C3 00 01 00 00 04 00 00 07 00 00 0A 00 00 0D 00 00 00 00 70 3F 00 00 88 3F 00 00 00 5F 00 00 00 C0 7E 01 50 41 00 00 00 80 FF FF 47 41 00 00 00 00 00 00 F0 3F C6 05 ?? ?? ?? ?? 01 50 83 EC 0C DB 3C 24 DD 05 ?? ?? ?? ?? DC 35 ?? ?? ?? ?? DC 0D ?? ?? ?? ?? DC 2D ?? ?? ?? ?? DC 1D ?? ?? ?? ?? 9B DF E0 C1 E8 07 83 E0 02 48 A2 ?? ?? ?? ?? DB 2C 24 83 C4 0C 58 E9 ?? ?? ?? ?? 74 B7 50 83 EC 18 DB 7C 24 0C DB 3C 24 DB 2C 24 DB 6C 24 0C 8B 44 24 10 01 C0 73 63 35 00 00 00 0E A9 00 00 00 0E 74 07 DE F9 83 C4 18 58 C3 C1 E8 1C 80 B8 ?? ?? ?? ?? 00 74 ED 8B 44 24 14 25 FF 7F 00 00 74 E2 3D FF 7F 00 00 74 DB 8B 44 24 08 25 FF 7F 00 00 83 F8 01 74 12 D8 0D ?? ?? ?? ?? D9 C9 D8 0D ?? ?? ?? ?? D9 C9 EB BB D8 0D ?? ?? ?? ?? D9 C9 D8 0D ?? ?? ?? ?? D9 C9 EB A9 8B 44 24 0C 0B 44 24 10 74 9F 8B 44 24 14 25 FF 7F 00 00 75 94 8B 44 24 08 25 FF 7F 00 00 74 15 3D FF 7F 00 00 74 82 8B 44 24 04 01 C0 0F 83 76 FF FF FF EB 0C 8B 44 24 04 01 C0 0F 82 68 FF FF FF D9 C9 DD D8 D9 C0 D8 0D ?? ?? ?? ?? DB 7C 24 0C DB 2C 24 D9 C9 E9 3A FF FF FF C3 }
	condition:
		$1
}

rule function_424_0 {
	meta:
		name = "@FilePos"
		size = 77
		refs = "001e SetFilePointer 002a InOutError 0041 SetInOutRes"
	strings:
		$1 = { 53 56 8B D8 0F B7 43 04 66 3D B0 D7 76 2D 66 3D B3 D7 77 27 6A 01 6A 00 6A 00 8B 03 50 E8 ?? ?? ?? ?? 8B F0 83 FE FF 75 07 E8 ?? ?? ?? ?? EB 18 8B C6 33 D2 F7 73 08 8B F0 EB 0D B8 67 00 00 00 E8 ?? ?? ?? ?? 83 CE FF 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_425_0 {
	meta:
		name = "@FileSize"
		size = 73
		refs = "001d GetFileSize 0029 InOutError 0040 SetInOutRes"
	strings:
		$1 = { 53 56 8B D8 83 CE FF 0F B7 43 04 66 3D B0 D7 76 29 66 3D B3 D7 77 23 6A 00 8B 03 50 E8 ?? ?? ?? ?? 8B F0 83 FE FF 75 07 E8 ?? ?? ?? ?? EB 15 8B C6 33 D2 F7 73 08 8B F0 EB 0A B8 67 00 00 00 E8 ?? ?? ?? ?? 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_426_0 {
	meta:
		name = "@FillChar"
		size = 155
		refs = "0056 @FillChar"
	strings:
		$1 = { 83 FA 20 88 CD 7C 3F 66 89 08 66 89 48 02 66 89 48 04 66 89 48 06 83 EA 10 DD 00 DD 14 02 DD 54 02 08 89 C1 83 E1 07 83 E9 08 29 C8 01 CA 01 D0 F7 DA DD 14 02 DD 54 02 08 83 C2 10 7C F4 DD C0 D9 F7 C3 90 90 90 85 D2 7E 50 88 4C 02 FF 83 E2 FE F7 DA 8D 14 55 ?? ?? ?? ?? FF E2 90 90 66 89 48 1C 66 89 48 1A 66 89 48 18 66 89 48 16 66 89 48 14 66 89 48 12 66 89 48 10 66 89 48 0E 66 89 48 0C 66 89 48 0A 66 89 48 08 66 89 48 06 66 89 48 04 66 89 48 02 66 89 08 C3 C3 }
	condition:
		$1
}

rule function_427_0 {
	meta:
		name = "Mark"
		size = 8
		refs = "0003 Error"
		altNames = "Release"
	strings:
		$1 = { B0 02 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_428_0 {
	meta:
		name = "@ReadRec"
		size = 75
		refs = "0024 ReadFile 0040 GetLastError 0045 SetInOutRes"
	strings:
		$1 = { 53 31 C9 89 C3 66 8B 48 04 81 E9 B1 D7 00 00 74 05 83 E9 02 75 22 6A 00 89 E0 6A 00 50 FF 73 08 52 FF 33 E8 ?? ?? ?? ?? 5A 48 75 13 3B 53 08 74 18 B8 64 00 00 00 EB 0C B8 67 00 00 00 EB 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_429_0 {
	meta:
		name = "TryOpenForInput"
		size = 58
		refs = "0005 Input 000e DefaultTextLineBreakStyle 0019 @ResetText 0032 SetInOutRes"
	strings:
		$1 = { 53 8B D8 81 FB ?? ?? ?? ?? 75 12 0F B6 05 ?? ?? ?? ?? 66 89 43 06 8B C3 E8 ?? ?? ?? ?? 66 81 7B 04 B1 D7 0F 94 C0 8B D8 84 DB 75 0A B8 68 00 00 00 E8 ?? ?? ?? ?? 8B C3 5B C3 }
	condition:
		$1
}

rule function_430_0 {
	meta:
		name = "@ReadChar"
		size = 105
		refs = "000a TryOpenForInput 005d SetInOutRes"
	strings:
		$1 = { 66 81 78 04 B1 D7 74 0B 50 E8 ?? ?? ?? ?? 84 C0 58 74 4F 8B 50 0C 3B 50 10 73 1C 66 F7 40 06 01 00 8B 48 14 8A 0C 0A 74 05 80 F9 1A 74 34 42 89 50 0C 31 C0 88 C8 C3 50 FF 50 1C 85 C0 75 1D 58 8B 50 0C 3B 50 10 72 D3 66 F7 40 06 01 00 74 12 8B 48 14 C6 04 0A 1A FF 40 10 EB 06 E8 ?? ?? ?? ?? 58 B1 1A 88 CC 88 C8 C3 }
	condition:
		$1
}

rule function_431_0 {
	meta:
		name = "@ValLongL"
		size = 83
		refs = "000f @ValLongL 001f @UStrFromLStr 0029 @ValLong 0040 @UStrClr 0046 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B D3 E8 ?? ?? ?? ?? 8B 45 FC 8B D6 E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_432_0 {
	meta:
		name = "@ReadLong"
		size = 106
		refs = "0012 @SeekEof 0023 @ReadChar 0042 @ValLongL 0051 SetInOutRes"
	strings:
		$1 = { 53 56 57 83 EC 24 6A 00 6A FF 68 00 00 01 00 89 C6 E8 ?? ?? ?? ?? FE C8 74 47 8D 7C 24 0C B3 20 89 F0 E8 ?? ?? ?? ?? 3C 20 76 2C AA FE CB 75 F0 C6 07 00 8D 44 24 0C 89 F9 29 C1 89 48 FC 52 89 E2 E8 ?? ?? ?? ?? 5A 85 D2 74 18 B8 6A 00 00 00 E8 ?? ?? ?? ?? EB 0C 80 FC 1A 74 D4 FF 4E 0C EB CF 31 C0 83 C4 30 5F 5E 5B C3 }
	condition:
		$1
}

rule function_433_0 {
	meta:
		name = "ReadLine"
		size = 127
		refs = "0012 TryOpenForInput 0063 @ReadChar"
	strings:
		$1 = { 53 56 57 51 89 CE 89 D7 66 81 78 04 B1 D7 74 0B 50 E8 ?? ?? ?? ?? 84 C0 58 74 5B 89 C3 85 F6 7E 55 8B 53 0C 8B 4B 10 29 D1 03 53 14 49 7C 2E 8A 02 42 3C 0A 74 1E 3C 0D 74 14 3C 1A 74 06 AA 4E 7F EA EB 11 66 F7 43 06 01 00 74 F2 EB 07 8A 02 3C 0A 75 D8 4A 2B 53 14 89 53 0C EB 19 89 53 0C 89 D8 E8 ?? ?? ?? ?? 8B 53 0C 8B 4B 10 29 D1 03 53 14 84 E4 74 BC 89 D8 59 29 F1 5F 5E 5B C3 }
	condition:
		$1
}

rule function_434_0 {
	meta:
		name = "@ReadString"
		size = 11
		refs = "0003 ReadLine"
	strings:
		$1 = { 52 42 E8 ?? ?? ?? ?? 5A 88 0A C3 }
	condition:
		$1
}

rule function_435_0 {
	meta:
		name = "@ReadCString"
		size = 12
		refs = "0002 ReadLine"
	strings:
		$1 = { 52 E8 ?? ?? ?? ?? 5A C6 04 11 00 C3 }
	condition:
		$1
}

rule function_436_0 {
	meta:
		name = "@ReadLString"
		size = 114
		refs = "000c @LStrClr 0020 @ReadString 002b @LStrFromString 0056 @LStrCat"
	strings:
		$1 = { 53 56 57 89 C3 89 D6 89 CF 89 D0 E8 ?? ?? ?? ?? 81 EC 00 01 00 00 89 D8 89 E2 B9 FF 00 00 00 E8 ?? ?? ?? ?? 89 F0 89 E2 89 F9 E8 ?? ?? ?? ?? 80 3C 24 FF 75 33 89 D8 89 E2 B9 FF 00 00 00 E8 ?? ?? ?? ?? 89 E2 6A 00 89 E0 89 F9 E8 ?? ?? ?? ?? 89 F0 8B 14 24 E8 ?? ?? ?? ?? 89 E0 E8 ?? ?? ?? ?? 58 80 3C 24 FF 74 CD 81 C4 00 01 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_437_0 {
	meta:
		name = "@ReadUString"
		size = 80
		refs = "000c @ReadUString 001c DefaultSystemCodePage 0021 @ReadLString 002b @UStrFromLStr 0040 @LStrClr 0046 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B DA 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8D 55 FC 0F B7 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C3 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_441_0 {
	meta:
		name = "@ReadWString"
		size = 80
		refs = "000c @ReadWString 001c DefaultSystemCodePage 0021 @ReadLString 002b @WStrFromLStr 0040 @LStrClr 0046 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B DA 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8D 55 FC 0F B7 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C3 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_438_0 {
	meta:
		name = "IsValidMultibyteChar"
		size = 44
		refs = "0019 DefaultSystemCodePage 001e UnicodeFromLocaleChars"
	strings:
		$1 = { 55 8B EC 51 53 56 8B F2 8B D8 56 8D 45 FE 50 6A 01 8B CB BA 08 00 00 00 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 95 C0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_439_0 {
	meta:
		name = "@ReadWChar"
		size = 116
		refs = "0010 @ReadChar 002e DefaultSystemCodePage 0033 UnicodeFromLocaleChars 004e WCharFromChar 0064 SetInOutRes"
	strings:
		$1 = { 53 56 57 55 83 C4 F4 8B F0 8B EC 33 DB 8B C6 E8 ?? ?? ?? ?? 88 44 1D 00 43 C6 44 1D 00 00 53 8D 44 24 0E 50 6A 01 8B CD BA 08 00 00 00 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 1E 53 A1 ?? ?? ?? ?? 50 8B CD 8D 44 24 10 BA 01 00 00 00 E8 ?? ?? ?? ?? 0F B7 7C 24 08 EB 11 83 FB 07 7C AF B8 6A 00 00 00 E8 ?? ?? ?? ?? 33 FF 8B C7 83 C4 0C 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_440_0 {
	meta:
		name = "@ReadWCString"
		size = 116
		refs = "0021 @ReadWChar 003c @EofText"
	strings:
		$1 = { 53 56 57 55 51 8B EA 8B F8 85 ED 74 61 33 DB D1 F9 79 03 83 D1 00 89 0C 24 3B 1C 24 7D 49 8B C7 E8 ?? ?? ?? ?? 8B F0 0F B7 C6 83 E8 0A 74 17 83 E8 03 74 17 83 E8 0D 75 23 8B C7 E8 ?? ?? ?? ?? 84 C0 75 23 EB 16 FF 4F 0C EB 1C 8B 47 0C 8B 57 14 80 3C 02 0A 75 05 FF 4F 0C EB 0B 66 89 74 5D 00 43 3B 1C 24 7C B7 66 C7 44 5D 00 00 00 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_442_0 {
	meta:
		name = "@ValExtL"
		size = 93
		refs = "0015 @ValExtL 0025 @UStrFromLStr 002f @ValExt 0048 @UStrClr 004e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 33 C9 89 4D EC 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 EC 8B D3 E8 ?? ?? ?? ?? 8B 45 EC 8B D6 E8 ?? ?? ?? ?? DB 7D F0 9B 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 DB 6D F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_443_0 {
	meta:
		name = "@ReadExt"
		size = 106
		refs = "0012 @SeekEof 0023 @ReadChar 0042 @ValExtL 0051 SetInOutRes"
	strings:
		$1 = { 53 56 57 83 EC 44 6A 00 6A FF 68 00 00 01 00 89 C6 E8 ?? ?? ?? ?? FE C8 74 47 8D 7C 24 0C B3 40 89 F0 E8 ?? ?? ?? ?? 3C 20 76 2C AA FE CB 75 F0 C6 07 00 8D 44 24 0C 89 F9 29 C1 89 48 FC 52 89 E2 E8 ?? ?? ?? ?? 5A 85 D2 74 18 B8 6A 00 00 00 E8 ?? ?? ?? ?? EB 0C 80 FC 1A 74 D4 FF 4E 0C EB CF D9 EE 83 C4 50 5F 5E 5B C3 }
	condition:
		$1
}

rule function_444_0 {
	meta:
		name = "@ReadLn"
		size = 46
		refs = "0006 @ReadChar"
	strings:
		$1 = { 53 89 C3 89 D8 E8 ?? ?? ?? ?? 3C 0A 74 1E 80 FC 1A 74 19 3C 0D 75 EC 89 D8 E8 ?? ?? ?? ?? 3C 0A 74 0A 80 FC 1A 74 05 FF 4B 0C EB D7 5B C3 }
	condition:
		$1
}

rule function_445_0 {
	meta:
		name = "@Rename"
		size = 168
		refs = "000f @Rename 0036 @UStrFromWArray 003f @UStrToPWChar 0045 MoveFile 006a GetLastError 006f SetInOutRes 0090 @UStrClr 0096 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 66 81 7E 04 B0 D7 75 54 85 DB 75 05 BB ?? ?? ?? ?? 8D 45 FC 8D 56 48 B9 04 01 00 00 E8 ?? ?? ?? ?? 53 8B 45 FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 74 1C 33 C0 EB 06 66 89 54 46 48 40 0F B7 14 43 66 85 D2 74 1F 3D 03 01 00 00 7C EA EB 16 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 0A B8 66 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_447_0 {
	meta:
		name = "@CloseFile"
		size = 38
		refs = "000f InternalClose 0018 InOutError"
	strings:
		$1 = { 53 56 8B D8 66 C7 43 04 B0 D7 33 F6 8B 03 E8 ?? ?? ?? ?? 84 C0 75 0A E8 ?? ?? ?? ?? BE 01 00 00 00 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_448_0 {
	meta:
		name = "OpenFile"
		size = 222
		refs = "0028 SetInOutRes 0038 @CloseFile 003f FileNOPProc 0051 FileMode 005d ShareTab 009d CreateFile 00bd GetStdHandle 00d1 GetLastError"
	strings:
		$1 = { 53 56 57 89 D6 89 CF 31 D2 89 C3 66 8B 50 04 81 EA B0 D7 00 00 74 15 83 FA 03 0F 87 A3 00 00 00 FF 53 24 85 C0 74 05 E8 ?? ?? ?? ?? 66 C7 43 04 B3 D7 89 73 08 C7 43 24 ?? ?? ?? ?? C7 43 1C ?? ?? ?? ?? 66 83 7B 48 00 74 60 B8 00 00 00 C0 8A 15 ?? ?? ?? ?? 83 E2 70 C1 EA 02 8B 92 ?? ?? ?? ?? B9 02 00 00 00 83 EF 03 74 21 B9 03 00 00 00 47 74 19 B8 00 00 00 40 47 66 C7 43 04 B2 D7 74 0B B8 00 00 00 80 66 C7 43 04 B1 D7 6A 00 68 80 00 00 00 51 6A 00 52 50 8D 43 48 50 E8 ?? ?? ?? ?? 83 F8 FF 74 24 89 03 EB 30 C7 43 24 ?? ?? ?? ?? 83 FF 03 74 04 6A F6 EB 02 6A F5 E8 ?? ?? ?? ?? EB DE B8 66 00 00 00 EB 0B 66 C7 43 04 B0 D7 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_449_0 {
	meta:
		name = "@ResetFile"
		size = 26
		refs = "0003 FileMode 0015 OpenFile"
	strings:
		$1 = { 0F B6 0D ?? ?? ?? ?? 80 E1 03 80 F9 02 76 02 B1 02 0F B6 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_450_0 {
	meta:
		name = "@RewritFile"
		size = 11
		refs = "0006 OpenFile"
	strings:
		$1 = { B9 03 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_451_0 {
	meta:
		name = "@Seek"
		size = 52
		refs = "001d SetFilePointer 0024 InOutError 002f SetInOutRes"
	strings:
		$1 = { 89 C1 0F B7 40 04 2D B1 D7 00 00 83 F8 02 77 19 6A 00 8B 41 08 F7 E2 6A 00 50 FF 31 E8 ?? ?? ?? ?? 40 0F 84 ?? ?? ?? ?? C3 B8 67 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_452_0 {
	meta:
		name = "@SeekEof"
		size = 30
		refs = "0006 @ReadChar"
	strings:
		$1 = { 53 89 C3 89 D8 E8 ?? ?? ?? ?? 3C 20 77 09 80 FC 1A 75 F0 B0 01 5B C3 FF 4B 0C 32 C0 5B C3 }
	condition:
		$1
}

rule function_453_0 {
	meta:
		name = "@SeekEoln"
		size = 42
		refs = "0006 @ReadChar"
	strings:
		$1 = { 53 89 C3 89 D8 E8 ?? ?? ?? ?? 3C 20 77 11 80 FC 1A 74 13 3C 0A 74 04 3C 0D 75 E8 B0 01 EB 02 32 C0 FF 4B 0C 5B C3 B0 01 5B C3 }
	condition:
		$1
}

rule function_454_0 {
	meta:
		name = "@SetTextBuf"
		size = 40
		refs = "0010 Error"
	strings:
		$1 = { 53 56 57 8B F1 8B FA 8B D8 85 F6 7D 07 B0 04 E8 ?? ?? ?? ?? 89 7B 14 89 73 08 33 C0 89 43 0C 33 C0 89 43 10 5F 5E 5B C3 }
	condition:
		$1
}

rule function_455_0 {
	meta:
		name = "@StrLong"
		size = 95
	strings:
		$1 = { 53 56 57 52 83 EC 14 89 CF 89 C6 99 31 D0 29 D0 B9 0A 00 00 00 31 DB 31 D2 F7 F1 83 C2 30 88 14 1C 43 85 C0 75 F1 85 F6 7D 05 C6 04 1C 2D 43 88 1F 47 8B 4C 24 14 81 F9 FF 00 00 00 7E 05 B9 FF 00 00 00 29 D9 7E 07 00 4F FF B0 20 F3 AA 8A 44 1C FF 88 07 47 4B 75 F6 83 C4 18 5F 5E 5B C3 }
	condition:
		$1
}

rule function_456_0 {
	meta:
		name = "@Str0Long"
		size = 10
		refs = "0005 @StrLong"
	strings:
		$1 = { 8B CA 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_457_0 {
	meta:
		name = "@Truncate"
		size = 41
		refs = "0012 SetEndOfFile 001a InOutError 0024 SetInOutRes"
	strings:
		$1 = { 0F B7 50 04 81 EA B1 D7 00 00 83 FA 02 77 0F FF 30 E8 ?? ?? ?? ?? 48 74 0F E9 ?? ?? ?? ?? B8 67 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_458_0 {
	meta:
		name = "@ValLong"
		size = 258
	strings:
		$1 = { 53 56 57 89 C6 50 85 C0 0F 84 83 00 00 00 31 C0 31 DB BF CC CC CC 0C 66 8B 1E 83 C6 02 66 83 FB 20 74 F4 B5 00 66 83 FB 2D 74 76 66 83 FB 2B 74 72 66 83 FB 24 74 74 66 83 FB 78 74 6E 66 83 FB 58 74 68 66 83 FB 30 75 19 66 8B 1E 83 C6 02 66 83 FB 78 74 56 66 83 FB 58 74 50 66 85 DB 74 27 EB 05 66 85 DB 74 35 66 83 EB 30 66 83 FB 09 77 2B 39 F8 77 27 8D 04 80 01 C0 01 D8 66 8B 1E 83 C6 02 66 85 DB 75 E0 FE CD 74 0B 85 C0 7D 68 EB 0B 83 C6 02 EB 06 F7 D8 7E 5D 78 5B 5B 29 DE EB 59 FE C5 66 8B 1E 83 C6 02 EB 86 BF FF FF FF 0F 66 8B 1E 83 C6 02 66 85 DB 74 D6 66 83 FB 61 72 04 66 83 EB 20 66 83 EB 30 66 83 FB 09 76 0E 66 83 EB 11 66 83 FB 05 77 C3 66 83 C3 0A 39 F8 77 BB C1 E0 04 01 D8 66 8B 1E 83 C6 02 66 85 DB 75 CA FE CD 75 02 F7 D8 59 31 F6 D1 EE 89 32 5F 5E 5B C3 }
	condition:
		$1
}

rule function_459_0 {
	meta:
		name = "@WriteRec"
		size = 72
		refs = "001f WriteFile 003b GetLastError 0040 SetInOutRes"
	strings:
		$1 = { 53 89 C3 0F B7 40 04 2D B2 D7 00 00 83 F8 01 77 22 6A 00 89 E0 6A 00 50 FF 73 08 52 FF 33 E8 ?? ?? ?? ?? 5A 48 75 13 3B 53 08 74 18 B8 65 00 00 00 EB 0C B8 05 00 00 00 EB 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 D8 5B C3 }
	condition:
		$1
}

rule function_460_0 {
	meta:
		name = "TryOpenForOutput"
		size = 66
		refs = "0005 Output 000d ErrOutput 0016 DefaultTextLineBreakStyle 0021 @RewritText 003a SetInOutRes"
	strings:
		$1 = { 53 8B D8 81 FB ?? ?? ?? ?? 74 08 81 FB ?? ?? ?? ?? 75 12 0F B6 05 ?? ?? ?? ?? 66 89 43 06 8B C3 E8 ?? ?? ?? ?? 66 81 7B 04 B2 D7 0F 94 C0 8B D8 84 DB 75 0A B8 69 00 00 00 E8 ?? ?? ?? ?? 8B C3 5B C3 }
	condition:
		$1
}

rule function_461_0 {
	meta:
		name = "@WriteBytes"
		size = 83
		refs = "0010 TryOpenForOutput 0042 SetInOutRes"
	strings:
		$1 = { 56 57 89 D6 66 81 78 04 B2 D7 74 0F 50 52 51 E8 ?? ?? ?? ?? 84 C0 59 5A 58 74 35 8B 78 14 03 78 0C 8B 50 08 2B 50 0C 39 CA 7F 20 01 50 0C 29 D1 50 51 89 D1 F3 A4 FF 50 1C 85 C0 75 04 59 58 EB DA E8 ?? ?? ?? ?? 59 58 5F 5E C3 01 48 0C F3 A4 5F 5E C3 }
	condition:
		$1
}

rule function_462_0 {
	meta:
		name = "@WriteSpaces"
		size = 121
		refs = "0003 @WriteSpaces 0017 @WriteBytes 001c @GetTls 0022 InOutRes"
	strings:
		$1 = { 89 D1 BA ?? ?? ?? ?? 83 F9 40 7E 64 83 E9 40 50 51 B9 40 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 B8 ?? ?? ?? ?? 00 75 04 59 58 EB D5 59 58 C3 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 85 C9 0F 8F ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_463_0 {
	meta:
		name = "@Write0Char"
		size = 60
		refs = "000b TryOpenForOutput 0024 SetInOutRes"
	strings:
		$1 = { 66 81 78 04 B2 D7 74 23 50 52 E8 ?? ?? ?? ?? 84 C0 5A 58 75 16 C3 50 52 FF 50 1C 85 C0 75 04 5A 58 EB 08 E8 ?? ?? ?? ?? 5A 58 C3 8B 48 0C 3B 48 08 7D E3 03 48 14 88 11 FF 40 0C C3 }
	condition:
		$1
}

rule function_464_0 {
	meta:
		name = "@WriteChar"
		size = 34
		refs = "000d @WriteSpaces 001b @WriteBytes"
	strings:
		$1 = { 53 51 88 14 24 8B D8 8B D1 4A 8B C3 E8 ?? ?? ?? ?? 8B D4 8B C3 B9 01 00 00 00 E8 ?? ?? ?? ?? 5A 5B C3 }
	condition:
		$1
}

rule function_465_0 {
	meta:
		name = "@WriteBool"
		size = 19
		refs = "0009 BoolStrs 000e @WriteString"
	strings:
		$1 = { 83 E2 7F C1 E2 05 8D 14 D5 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_466_0 {
	meta:
		name = "@Write0Bool"
		size = 8
		refs = "0003 @WriteBool"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_471_0 {
	meta:
		name = "@Write0CString"
		size = 8
		refs = "0003 @WriteCString"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_473_0 {
	meta:
		name = "@Write0LString"
		size = 8
		refs = "0003 @WriteLString"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_468_0 {
	meta:
		name = "@Write0Long"
		size = 8
		refs = "0003 @WriteLong"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_475_0 {
	meta:
		name = "@Write0UString"
		size = 8
		refs = "0003 @WriteUString"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_484_0 {
	meta:
		name = "@Write0Variant"
		size = 8
		refs = "0003 @WriteVariant"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_479_0 {
	meta:
		name = "@Write0WCString"
		size = 8
		refs = "0003 @WriteWCString"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_481_0 {
	meta:
		name = "@Write0WChar"
		size = 8
		refs = "0003 @WriteWChar"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_477_0 {
	meta:
		name = "@Write0WString"
		size = 8
		refs = "0003 @WriteWString"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_467_0 {
	meta:
		name = "@WriteLong"
		size = 62
		refs = "0018 @StrLong 0025 @PStrNCpy 0030 @WriteString"
	strings:
		$1 = { 53 56 57 81 C4 E0 FE FF FF 8B F9 8B F2 8B D8 8D 4C 24 20 33 D2 8B C6 E8 ?? ?? ?? ?? 8D 54 24 20 8B C4 B1 1F E8 ?? ?? ?? ?? 8B D4 8B C3 8B CF E8 ?? ?? ?? ?? 81 C4 20 01 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_469_0 {
	meta:
		name = "@Write0String"
		size = 10
		refs = "0005 @WriteBytes"
	strings:
		$1 = { 0F B6 0A 42 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_470_0 {
	meta:
		name = "@WriteString"
		size = 36
		refs = "0010 @WriteSpaces 001d @WriteBytes"
	strings:
		$1 = { 53 56 8B DA 8B F0 0F B6 03 8B D1 2B D0 8B C6 E8 ?? ?? ?? ?? 0F B6 0B 8D 53 01 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_472_0 {
	meta:
		name = "@WriteCString"
		size = 45
		refs = "000c @strlenA 0019 @WriteSpaces 0024 @WriteBytes"
	strings:
		$1 = { 53 56 57 55 8B E9 8B FA 8B F0 57 E8 ?? ?? ?? ?? 8B D8 8B D5 2B D3 8B C6 E8 ?? ?? ?? ?? 8B D7 8B C6 8B CB E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_474_0 {
	meta:
		name = "@WriteLString"
		size = 34
		refs = "0013 @WriteSpaces 001d @WriteBytes"
	strings:
		$1 = { 53 56 89 D3 89 CA 31 C9 85 DB 74 05 8B 4B FC 29 CA 51 E8 ?? ?? ?? ?? 59 89 DA 5E 5B E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_476_0 {
	meta:
		name = "@WriteUString"
		size = 112
		refs = "0012 @WriteUString 001f @UStrLen 002a @WriteSpaces 0039 @LStrFromUStr 0045 @WriteLString 005c @LStrClr 0062 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 8B D7 2B D0 8B C3 E8 ?? ?? ?? ?? 8D 45 FC 8B D6 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 55 FC 8B C3 33 C9 E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_478_0 {
	meta:
		name = "@WriteWString"
		size = 112
		refs = "0012 @WriteWString 001f @WStrLen 002a @WriteSpaces 0039 @LStrFromWStr 0045 @WriteLString 005c @LStrClr 0062 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 8B D7 2B D0 8B C3 E8 ?? ?? ?? ?? 8D 45 FC 8B D6 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 55 FC 8B C3 33 C9 E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_480_0 {
	meta:
		name = "@WriteWCString"
		size = 117
		refs = "000f @WriteWCString 0030 @WriteSpaces 003f @LStrFromPWChar 004b @WriteLString 0062 @LStrClr 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 85 DB 74 0A EB 01 40 66 83 3C 43 00 75 F8 8B D1 2B D0 8B C6 E8 ?? ?? ?? ?? 8D 45 FC 8B D3 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 55 FC 8B C6 33 C9 E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_482_0 {
	meta:
		name = "@WriteWChar"
		size = 100
		refs = "000f @WriteWChar 001f @WriteSpaces 002e @LStrFromWChar 003a @WriteLString 0051 @LStrClr 0057 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B D1 4A 8B C3 E8 ?? ?? ?? ?? 8D 45 FC 8B D6 B9 00 00 00 00 E8 ?? ?? ?? ?? 8B 55 FC 8B C3 33 C9 E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_483_0 {
	meta:
		name = "@WriteVariant"
		size = 100
		refs = "000f @WriteVariant 001b VarToLStrProc 0033 @WriteLString 003c Error 0051 @LStrClr 0057 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 3D ?? ?? ?? ?? 00 74 17 8D 45 FC FF 15 ?? ?? ?? ?? 8B C3 8B CE 8B 55 FC E8 ?? ?? ?? ?? EB 07 B0 10 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_485_0 {
	meta:
		name = "@Write2Ext"
		size = 50
		refs = "001b @Str2Ext 0024 @WriteString"
	strings:
		$1 = { DB 6C 24 04 81 EC 00 01 00 00 50 52 83 EC 0C DB 3C 24 89 D0 89 CA 8D 4C 24 14 E8 ?? ?? ?? ?? 59 58 89 E2 E8 ?? ?? ?? ?? 81 C4 00 01 00 00 C2 0C 00 C3 }
	condition:
		$1
}

rule function_486_0 {
	meta:
		name = "@Write1Ext"
		size = 9
		refs = "0004 @Write2Ext"
	strings:
		$1 = { 83 C9 FF E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_487_0 {
	meta:
		name = "@Write0Ext"
		size = 14
		refs = "0009 @Write2Ext"
	strings:
		$1 = { BA 17 00 00 00 83 C9 FF E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_488_0 {
	meta:
		name = "@WriteLn"
		size = 71
		refs = "001e @WriteBytes 003d @Flush"
	strings:
		$1 = { 53 56 51 8B D8 F6 43 06 01 74 1B C6 04 24 0D C6 44 24 01 0A 8B D4 8B C3 B9 02 00 00 00 E8 ?? ?? ?? ?? 8B F0 EB 14 C6 04 24 0A 8B D4 8B C3 B9 01 00 00 00 E8 ?? ?? ?? ?? 8B F0 8B C3 E8 ?? ?? ?? ?? 8B C6 5A 5E 5B C3 }
	condition:
		$1
}

rule function_489_0 {
	meta:
		name = "@_CToPasStr"
		size = 11
		refs = "0006 @_CLenToPasStr"
	strings:
		$1 = { B9 FF 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_490_0 {
	meta:
		name = "@_CLenToPasStr"
		size = 45
	strings:
		$1 = { 53 50 85 D2 74 21 81 F9 FF 00 00 00 76 05 B9 FF 00 00 00 8A 1A 42 84 DB 74 06 40 88 18 49 75 F3 5A 29 D0 88 02 5B C3 5A 31 C0 EB F7 C3 }
	condition:
		$1
}

rule function_491_0 {
	meta:
		name = "@_ArrayToPasStr"
		size = 23
		refs = "0012 Move"
	strings:
		$1 = { 81 F9 FF 00 00 00 7E 05 B9 FF 00 00 00 88 08 40 92 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_492_0 {
	meta:
		name = "@_PasToCStr"
		size = 29
		refs = "000f Move"
	strings:
		$1 = { 53 56 8B F2 8B D8 0F B6 0B 8B D6 8D 43 01 E8 ?? ?? ?? ?? 0F B6 03 C6 04 06 00 5E 5B C3 }
	condition:
		$1
}

rule function_493_0 {
	meta:
		name = "@SetElem"
		size = 34
	strings:
		$1 = { 53 57 89 C7 31 DB 88 CB 89 D9 31 C0 F3 AA 29 DF 40 88 D1 D2 C0 C1 E9 03 39 D9 73 03 08 04 39 5F 5B C3 }
	condition:
		$1
}

rule function_494_0 {
	meta:
		name = "@SetRange"
		size = 86
	strings:
		$1 = { 53 56 57 31 DB 88 E3 0F B6 F0 0F B6 D2 89 CF 89 D9 31 C0 F3 AA 29 DF C1 E3 03 39 DA 72 03 8D 53 FF 39 D6 77 2D 48 89 F1 80 E1 07 D2 E0 C1 EE 03 88 D1 F6 D1 80 E1 07 D2 EC C1 EA 03 01 F7 89 D1 29 F1 75 06 20 E0 88 07 EB 08 AA 49 B0 FF F3 AA 88 27 5F 5E 5B C3 }
	condition:
		$1
}

rule function_495_0 {
	meta:
		name = "@SetEq"
		size = 51
	strings:
		$1 = { 56 57 89 C6 89 D7 81 E1 FF 00 00 00 49 74 14 0F B7 44 31 FF 0F B7 54 39 FF 39 D0 75 03 49 75 EC 5F 5E C3 8A 04 31 8A 14 39 38 D0 75 F3 09 C9 5F 5E C3 C3 }
	condition:
		$1
}

rule function_496_0 {
	meta:
		name = "@SetLe"
		size = 15
	strings:
		$1 = { 8A 2A F6 D5 22 28 75 06 42 40 FE C9 75 F2 C3 }
	condition:
		$1
}

rule function_497_0 {
	meta:
		name = "@SetIntersect"
		size = 11
	strings:
		$1 = { 8A 2A 42 20 28 40 FE C9 75 F6 C3 }
	condition:
		$1
}

rule function_498_0 {
	meta:
		name = "@SetIntersect3"
		size = 24
	strings:
		$1 = { 53 56 8B 74 24 0C 8A 5C 11 FF 22 5C 31 FF 88 5C 01 FF 49 75 F1 5E 5B C3 }
	condition:
		$1
}

rule function_499_0 {
	meta:
		name = "@SetUnion"
		size = 11
	strings:
		$1 = { 8A 2A 42 08 28 40 FE C9 75 F6 C3 }
	condition:
		$1
}

rule function_500_0 {
	meta:
		name = "@SetUnion3"
		size = 24
	strings:
		$1 = { 53 56 8B 74 24 0C 8A 5C 11 FF 0A 5C 31 FF 88 5C 01 FF 49 75 F1 5E 5B C3 }
	condition:
		$1
}

rule function_501_0 {
	meta:
		name = "@SetSub"
		size = 13
	strings:
		$1 = { 8A 2A F6 D5 42 20 28 40 FE C9 75 F4 C3 }
	condition:
		$1
}

rule function_502_0 {
	meta:
		name = "@SetSub3"
		size = 26
	strings:
		$1 = { 53 56 8B 74 24 0C 8A 5C 31 FF F6 D3 22 5C 11 FF 88 5C 01 FF 49 75 EF 5E 5B C3 }
	condition:
		$1
}

rule function_503_0 {
	meta:
		name = "@SetExpand"
		size = 31
	strings:
		$1 = { 56 57 89 C6 89 D7 89 CA 31 C9 31 C0 88 D1 F3 AA 88 F1 28 D1 F3 A4 B1 20 28 F1 F3 AA 5F 5E C3 }
	condition:
		$1
}

rule function_504_0 {
	meta:
		name = "@EmitDigits"
		size = 110
		refs = "0010 tenE17 0018 tenE18"
	strings:
		$1 = { 53 31 DB 57 89 D7 89 C1 83 EC 0A C6 07 30 DC 8B ?? ?? ?? ?? D9 FC DC 93 ?? ?? ?? ?? 9B DF E0 9E 72 09 DC A3 ?? ?? ?? ?? C6 07 31 DF 34 24 BA 08 00 00 00 47 9B 8A 04 14 88 C4 C0 E8 04 80 E4 0F 66 05 30 30 66 AB 4A 79 EB 83 E9 12 7C 06 B0 30 F3 AA EB 14 01 CF 80 3F 35 7C 0D 4F FE 07 80 3F 39 7E 05 C6 07 30 EB F3 83 C4 0A 5F 5B C3 }
	condition:
		$1
}

rule function_505_0 {
	meta:
		name = "@ScaleExt"
		size = 68
		refs = "002a @Pow10"
	strings:
		$1 = { 53 83 EC 0C 31 DB D9 C0 DB 3C 24 66 8B 44 24 08 66 85 C0 74 1B 66 2D FF 3F 66 BA 10 4D 66 F7 EA 0F BF C2 F7 D8 74 16 29 C3 E8 ?? ?? ?? ?? EB D6 83 7C 24 04 00 75 DE 83 3C 24 00 75 D8 83 C4 0C 89 D8 5B C3 }
	condition:
		$1
}

rule function_506_0 {
	meta:
		name = "@Str2Ext"
		size = 441
		refs = "0049 @ScaleExt 006e @EmitDigits 00f8 Ten 018a NanStr 0193 PlusInfStr 019b MinInfStr"
	strings:
		$1 = { DB 6C 24 04 53 56 57 89 C3 89 D6 51 81 EC 00 01 00 00 81 FB FF 00 00 00 7E 05 BB FF 00 00 00 D9 C0 DB 3C 24 31 C0 66 8B 44 24 08 89 C7 C1 EF 0F 66 25 FF 7F 66 3D FF 7F 0F 84 3E 01 00 00 D9 E1 85 F6 0F 8D A1 00 00 00 E8 ?? ?? ?? ?? 89 DE 83 EE 08 83 FE 02 7D 07 BE 02 00 00 00 EB 0A 83 FE 12 7E 05 BE 12 00 00 00 89 E2 50 89 F0 E8 ?? ?? ?? ?? 89 FA 8B BC 24 04 01 00 00 88 1F 47 B0 20 89 D9 29 F1 83 E9 08 7E 02 F3 AA 28 4F FF 84 D2 74 02 B0 2D AA 58 89 F1 89 E6 80 3E 30 74 02 40 4E 46 A4 C6 07 2E 47 49 F3 A4 C6 07 45 B1 2B 85 C0 7D 04 B1 2D F7 D8 88 4F 01 31 D2 66 B9 0A 00 66 F7 F1 80 C2 30 88 57 05 31 D2 66 F7 F1 80 C2 30 88 57 04 31 D2 66 F7 F1 80 C2 30 88 57 03 04 30 88 47 02 E9 86 00 00 00 81 FE D8 00 00 00 7E 05 BE D8 00 00 00 DC 15 ?? ?? ?? ?? 9B DF E0 9E B8 00 00 00 00 72 0E E8 ?? ?? ?? ?? 83 F8 23 0F 8F 38 FF FF FF 40 89 E2 50 01 F0 E8 ?? ?? ?? ?? 58 89 F2 89 E6 80 3E 30 74 02 40 4E 46 89 C1 01 F9 85 D2 74 09 41 01 D1 39 CB 7F 02 89 CB 50 57 8B BC 24 08 01 00 00 88 1F 47 29 CB 89 D9 7E 04 B0 20 F3 AA 28 4F FF 58 59 85 C0 74 04 C6 07 2D 47 F3 A4 85 D2 74 08 C6 07 2E 47 89 D1 F3 A4 81 C4 00 01 00 00 59 5F 5E 5B C2 0C 00 31 C0 DD D8 81 7C 24 04 00 00 00 80 8D B0 ?? ?? ?? ?? 75 0F 4F 8D B0 ?? ?? ?? ?? 75 06 8D B0 ?? ?? ?? ?? 89 CF 89 D9 88 0F 47 2A 0E 76 04 B0 20 F3 AA 28 4F FF 8A 0E 46 F3 A4 EB B7 C3 }
	condition:
		$1
}

rule function_507_0 {
	meta:
		name = "@Str0Ext"
		size = 16
		refs = "000b @Str2Ext"
	strings:
		$1 = { 89 C1 B8 17 00 00 00 83 CA FF E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_508_0 {
	meta:
		name = "@Str1Ext"
		size = 11
		refs = "0006 @Str2Ext"
	strings:
		$1 = { 89 D1 83 CA FF E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_509_0 {
	meta:
		name = "@ValExt"
		size = 312
		refs = "0057 Ten 0110 @Pow10"
	strings:
		$1 = { 53 31 DB 56 57 53 89 C6 50 D9 EE 31 C0 31 DB 31 FF 53 85 F6 0F 84 11 01 00 00 66 8B 1E 83 C6 02 66 83 FB 20 74 F4 B5 00 66 83 FB 2D 74 08 66 83 FB 2B 74 04 EB 08 FE C5 66 8B 1E 83 C6 02 66 85 DB 0F 84 E7 00 00 00 8B 7C 24 08 66 83 EB 30 66 83 FB 09 77 19 DC 8F ?? ?? ?? ?? 89 1C 24 DA 04 24 66 8B 1E 83 C6 02 66 85 DB 75 DF EB 33 66 83 FB FE 75 31 66 8B 1E 83 C6 02 66 85 DB 74 22 66 83 EB 30 66 83 FB 09 77 1C DC 8F ?? ?? ?? ?? 89 1C 24 DA 04 24 48 66 8B 1E 83 C6 02 66 85 DB 75 DE 31 FF EB 66 66 83 FB 15 74 06 66 83 FB 35 75 7D 66 8B 1E 83 C6 02 B4 00 66 83 FB 2D 74 08 66 83 FB 2B 74 04 EB 08 FE C4 66 8B 1E 83 C6 02 66 83 EB 30 66 83 FB 09 77 55 89 DF 66 8B 1E 83 C6 02 66 85 DB 74 1C 66 83 EB 30 66 83 FB 09 77 3E 8D 3C BF 01 FF 01 DF 66 8B 1E 83 C6 02 66 85 DB 75 E4 FE CC 75 02 F7 DF 0F BE C0 01 F8 52 51 E8 ?? ?? ?? ?? 59 5A FE CD 74 0D 83 C4 0C 31 F6 D1 EE 89 32 5F 5E 5B C3 D9 E0 EB EF 83 C6 02 58 5B 29 DE 83 C4 04 EB E8 C3 }
	condition:
		$1
}

rule function_511_0 {
	meta:
		name = "@Pow10"
		size = 740
		refs = "0023 @Pow10"
	strings:
		$1 = { 53 31 DB 85 C0 7C 4D 0F 84 9A 00 00 00 3D 00 14 00 00 0F 8D 81 00 00 00 89 C2 83 E2 1F 8D 14 92 DB AC 53 ?? ?? ?? ?? DE C9 C1 E8 05 74 79 89 C2 83 E2 0F 74 0C 8D 14 92 DB AC 53 ?? ?? ?? ?? DE C9 C1 E8 04 74 61 8D 04 80 DB AC 43 ?? ?? ?? ?? DE C9 EB 53 F7 D8 3D 00 14 00 00 7D 46 89 C2 83 E2 1F 8D 14 92 DB AC 53 ?? ?? ?? ?? DE F9 C1 E8 05 74 34 89 C2 83 E2 0F 74 0C 8D 14 92 DB AC 53 ?? ?? ?? ?? DE F9 C1 E8 04 74 1C 8D 04 80 DB AC 43 ?? ?? ?? ?? DE F9 EB 0E DD D8 DB AB ?? ?? ?? ?? EB 04 DD D8 D9 EE 5B C3 00 00 00 00 00 00 00 80 FF 7F 00 00 00 00 00 00 00 80 FF 3F 00 00 00 00 00 00 00 A0 02 40 00 00 00 00 00 00 00 C8 05 40 00 00 00 00 00 00 00 FA 08 40 00 00 00 00 00 00 40 9C 0C 40 00 00 00 00 00 00 50 C3 0F 40 00 00 00 00 00 00 24 F4 12 40 00 00 00 00 00 80 96 98 16 40 00 00 00 00 00 20 BC BE 19 40 00 00 00 00 00 28 6B EE 1C 40 00 00 00 00 00 F9 02 95 20 40 00 00 00 00 40 B7 43 BA 23 40 00 00 00 00 10 A5 D4 E8 26 40 00 00 00 00 2A E7 84 91 2A 40 00 00 00 80 F4 20 E6 B5 2D 40 00 00 00 A0 31 A9 5F E3 30 40 00 00 00 04 BF C9 1B 8E 34 40 00 00 00 C5 2E BC A2 B1 37 40 00 00 40 76 3A 6B 0B DE 3A 40 00 00 E8 89 04 23 C7 8A 3E 40 00 00 62 AC C5 EB 78 AD 41 40 00 80 7A 17 B7 26 D7 D8 44 40 00 90 AC 6E 32 78 86 87 48 40 00 B4 57 0A 3F 16 68 A9 4B 40 00 A1 ED CC CE 1B C2 D3 4E 40 A0 84 14 40 61 51 59 84 52 40 C8 A5 19 90 B9 A5 6F A5 55 40 3A 0F 20 F4 27 8F CB CE 58 40 84 09 94 F8 78 39 3F 81 5C 40 E5 0B B9 36 D7 07 8F A1 5F 40 DF 4E 67 04 CD C9 F2 C9 62 40 96 22 81 45 40 7C 6F FC 65 40 9E B5 70 2B A8 AD C5 9D 69 40 D5 A6 CF FF 49 1F 78 C2 D3 40 A3 14 9B C5 16 AB B3 EF 3D 41 E0 8C E9 80 C9 47 BA 93 A8 41 AA 17 E6 7F 2B A1 16 B6 12 42 6B 55 27 39 8D F7 70 E0 7C 42 30 C9 3C E3 FF 96 52 8A E7 42 8E DE F9 9D FB EB 7E AA 51 43 8C 2F 6A 5C 19 FC 26 D2 BB 43 76 E3 CC F2 29 2F 84 81 26 44 D2 0A 90 DB 00 27 A4 9F 90 44 17 AA F8 AE 10 E3 C5 C4 FA 44 59 9C B0 E9 07 9C 8A F2 64 45 D4 F3 F7 EB E1 4A 7A 95 CF 45 62 A2 95 07 DC D8 3E B8 39 46 C7 91 0E A6 AE A0 19 E3 A3 46 17 0C 75 81 86 75 76 C9 48 4D E4 A7 93 39 3B 35 B8 B2 ED 53 E5 5D 3D C5 5D 3B 8B 9E 92 5A A6 F0 A1 20 C0 54 A5 8C 37 61 8B 5A 8B D8 25 5D 89 F9 DB 67 F8 F3 27 BF A2 C8 5D DD 80 6E 9B 97 20 8A 02 52 60 C4 25 75 F0 59 D5 6E 62 11 35 AE CA 7B C3 }
	condition:
		$1
}

rule function_512_0 {
	meta:
		name = "@Real2Ext"
		size = 46
	strings:
		$1 = { 8A 70 05 80 E6 80 8A 10 84 D2 74 1E 66 81 C2 7E 3F 52 8B 50 02 81 CA 00 00 00 80 52 8A 50 01 C1 E2 18 52 DB 2C 24 83 C4 0C C3 D9 EE C3 C3 }
	condition:
		$1
}

rule function_513_0 {
	meta:
		name = "@Ext2Real"
		size = 75
		refs = "0046 Error"
	strings:
		$1 = { 53 83 EC 0C DB 3C 24 5B 5A 59 C1 EB 18 80 D3 00 83 D2 00 66 83 D1 00 70 29 01 D2 66 01 C9 D1 DA 66 D1 E9 66 81 E9 7E 3F 7E 0E 84 ED 7F 14 88 08 88 58 01 89 50 02 5B C3 31 C9 89 08 66 89 48 04 5B C3 5B B0 08 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_514_0 {
	meta:
		name = "@ObjSetup"
		size = 94
		refs = "0014 @GetMem"
	strings:
		$1 = { 83 FA 01 73 01 C3 51 85 C0 75 43 8B 42 F8 85 C0 74 35 52 E8 ?? ?? ?? ?? 5A 85 C0 74 26 57 8B 4A F8 89 C7 50 31 C0 C1 E9 02 F3 AB 8B 4A F8 83 E1 03 F3 AA 58 5F 8B 4A FC 85 C9 7C 03 89 14 01 85 C0 59 C3 31 D2 59 C3 31 D2 83 F8 01 59 C3 8B 4A FC 85 C9 7C 03 89 14 01 31 D2 85 C0 59 C3 }
	condition:
		$1
}

rule function_515_0 {
	meta:
		name = "@ObjCopy"
		size = 35
	strings:
		$1 = { 53 56 57 89 D6 89 C7 8D 04 39 8B 10 8B 5A F8 89 D9 C1 E9 02 F3 A5 89 D9 83 E1 03 F3 A4 89 10 5F 5E 5B C3 }
	condition:
		$1
}

rule function_516_0 {
	meta:
		name = "@Fail"
		size = 12
		refs = "0005 @FreeMem"
	strings:
		$1 = { 85 D2 74 05 E8 ?? ?? ?? ?? 33 C0 C3 }
	condition:
		$1
}

rule function_517_0 {
	meta:
		name = "@FpuInit"
		size = 10
		refs = "0005 Default8087CW"
	strings:
		$1 = { DB E3 9B D9 2D ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_518_0 {
	meta:
		name = "@BoundErr"
		size = 8
		refs = "0003 Error"
	strings:
		$1 = { B0 04 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_519_0 {
	meta:
		name = "@IntOver"
		size = 8
		refs = "0003 Error"
	strings:
		$1 = { B0 05 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_520_0 {
	meta:
		name = "TObject.ClassType"
		size = 7
	strings:
		$1 = { 8B 00 89 C2 8B C2 C3 }
	condition:
		$1
}

rule function_521_0 {
	meta:
		name = "TObject.ClassName"
		size = 21
		refs = "000e UTF8ToString"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 83 C3 C8 8B 03 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_522_0 {
	meta:
		name = "TObject.ClassNameIs"
		size = 124
		refs = "000f TObject.ClassNameIs 001f TObject.ClassName 0026 @UStrLen 002e @UStrToPWChar 0048 UTF8CompareLocale 004e CompareString 0069 @UStrClr 006f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 50 8B C6 E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 50 6A 01 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 F8 02 0F 94 C3 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_523_0 {
	meta:
		name = "TObject.ClassParent"
		size = 10
	strings:
		$1 = { 8B 40 D0 85 C0 74 02 8B 00 C3 }
	condition:
		$1
}

rule function_524_0 {
	meta:
		name = "TObject.NewInstance"
		size = 26
		refs = "0006 TObject.InstanceSize 000b @GetMem 0014 TObject.InitInstance"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_525_0 {
	meta:
		name = "TObject.FreeInstance"
		size = 19
		refs = "0006 TObject.CleanupInstance 000d @FreeMem"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_526_0 {
	meta:
		name = "TObject.InstanceSize"
		size = 6
	strings:
		$1 = { 83 C0 CC 8B 00 C3 }
	condition:
		$1
}

rule function_527_0 {
	meta:
		name = "TObject.Create"
		size = 32
		refs = "0008 @ClassCreate 0011 @AfterConstruction"
	strings:
		$1 = { 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 84 D2 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C C3 }
	condition:
		$1
}

rule function_528_0 {
	meta:
		name = "TObject.Destroy"
		size = 15
		refs = "0001 @BeforeDestruction 000a @ClassDestroy"
	strings:
		$1 = { E8 ?? ?? ?? ?? 84 D2 7E 05 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_529_0 {
	meta:
		name = "TObject.Free"
		size = 12
	strings:
		$1 = { 85 C0 74 07 B2 01 8B 08 FF 51 FC C3 }
	condition:
		$1
}

rule function_530_0 {
	meta:
		name = "TObject.InitInstance"
		size = 86
	strings:
		$1 = { 53 56 57 89 C3 89 D7 AB 8B 4B CC 31 C0 51 C1 E9 02 49 F3 AB 59 83 E1 03 F3 AA 89 D0 89 E2 8B 4B AC 85 C9 74 01 51 8B 5B D0 85 DB 74 04 8B 1B EB ED 39 D4 74 1D 5B 8B 0B 83 C3 04 8B 73 10 85 F6 74 06 8B 7B 14 89 34 07 83 C3 1C 49 75 ED 39 D4 75 E3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_531_0 {
	meta:
		name = "TObject.CleanupInstance"
		size = 39
		refs = "0013 @FinalizeRecord 0020 TMonitor.Destroy"
	strings:
		$1 = { 53 56 89 C3 89 C6 8B 36 8B 56 B4 8B 76 D0 85 D2 74 07 E8 ?? ?? ?? ?? 89 D8 85 F6 75 E9 89 D8 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_532_0 {
	meta:
		name = "InvokeImplGetter"
		size = 45
		refs = "0028 @IntfCopy"
	strings:
		$1 = { 87 D1 81 F9 00 00 00 FF 73 11 81 F9 00 00 00 FE 72 07 0F BF C9 03 08 FF 21 FF E1 81 E1 FF FF FF 00 01 C1 89 D0 8B 11 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_533_0 {
	meta:
		name = "TObject.Equals"
		size = 6
	strings:
		$1 = { 3B C2 0F 94 C0 C3 }
	condition:
		$1
}

rule function_535_0 {
	meta:
		name = "TObject.GetInterface"
		size = 208
		refs = "0019 TObject.GetInterface 002d TObject.GetInterfaceEntry 005a InvokeImplGetter 0064 @IntfCopy 006b ObjCastGUID 00bb @IntfClear 00c1 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 33 DB 89 5D F8 8B D9 89 55 FC 8B F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 89 03 8B 55 FC 8B 07 E8 ?? ?? ?? ?? 8B F0 85 F6 74 33 8B 46 14 85 C0 74 13 03 F8 89 3B 83 3B 00 74 5B 8B 03 50 8B 00 FF 50 04 EB 51 8D 4D F8 8B 56 18 8B C7 E8 ?? ?? ?? ?? 8B 55 F8 8B C3 E8 ?? ?? ?? ?? EB 38 A1 ?? ?? ?? ?? 33 D2 52 50 8B 45 FC 8B 00 33 D2 3B 54 24 04 75 03 3B 04 24 5A 58 75 1B 8B 45 FC 8B 50 0C 8B 40 08 3B 15 ?? ?? ?? ?? 75 0A 3B 05 ?? ?? ?? ?? 75 02 89 3B 83 3B 00 0F 95 C0 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_536_0 {
	meta:
		name = "TObject.GetInterfaceEntry"
		size = 68
	strings:
		$1 = { 53 56 89 C3 8B 43 AC 85 C0 74 29 8B 08 83 C0 04 8B 32 3B 30 75 18 8B 72 04 3B 70 04 75 10 8B 72 08 3B 70 08 75 08 8B 72 0C 3B 70 0C 74 13 83 C0 1C 49 75 DC 8B 5B D0 85 DB 74 04 8B 1B EB C5 31 C0 5E 5B C3 }
	condition:
		$1
}

rule function_537_0 {
	meta:
		name = "TObject.GetInterfaceTable"
		size = 6
	strings:
		$1 = { 83 C0 AC 8B 00 C3 }
	condition:
		$1
}

rule function_538_0 {
	meta:
		name = "TObject.UnitName"
		size = 52
		refs = "0006 TObject.ClassInfo 0023 UTF8ToString 002c @UStrClr"
	strings:
		$1 = { 53 56 57 8B F2 E8 ?? ?? ?? ?? 8B D8 85 DB 74 19 8B FB 8B C7 83 C0 02 47 0F B6 17 03 C2 83 C0 0A 8B D6 E8 ?? ?? ?? ?? EB 07 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_539_0 {
	meta:
		name = "@IsClass"
		size = 33
		refs = "000f TObject.InheritsFrom"
	strings:
		$1 = { 53 56 8B F2 8B D8 85 DB 74 0D 8B D6 8B 03 E8 ?? ?? ?? ?? 84 C0 75 05 33 C0 5E 5B C3 B0 01 5E 5B C3 }
	condition:
		$1
}

rule function_540_0 {
	meta:
		name = "@AsClass"
		size = 27
		refs = "0016 Error"
	strings:
		$1 = { 85 C0 74 16 89 C1 8B 09 39 D1 74 0E 8B 49 D0 85 C9 75 F3 B0 0A E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_541_0 {
	meta:
		name = "@IntfAsClass"
		size = 26
		refs = "0007 ObjCastGUID 000e @IntfCast 0015 @AsClass"
	strings:
		$1 = { 52 6A 00 89 C2 8D 0D ?? ?? ?? ?? 89 E0 E8 ?? ?? ?? ?? 58 5A E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_542_0 {
	meta:
		name = "@SafeIntfAsClass"
		size = 52
		refs = "000d ObjCastGUID 0020 @IsClass"
	strings:
		$1 = { 53 56 51 8B F2 8B D8 85 DB 74 1D 54 68 ?? ?? ?? ?? 53 8B 03 FF 10 85 C0 75 0E 8B 04 24 8B D6 E8 ?? ?? ?? ?? 84 C0 75 05 33 C0 89 04 24 8B 04 24 5A 5E 5B C3 }
	condition:
		$1
}

rule function_543_0 {
	meta:
		name = "@IntfIsClass"
		size = 23
		refs = "000b @SafeIntfAsClass"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 85 C0 0F 95 C0 5E 5B C3 }
	condition:
		$1
}

rule function_544_0 {
	meta:
		name = "@GetHelperDelegate"
		size = 12
		refs = "0007 TClassHelperBase._Create"
	strings:
		$1 = { 8B C8 8B C2 B2 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_545_0 {
	meta:
		name = "@GetHelperIntf"
		size = 90
		refs = "000d TObject.GetInterfaceTable 0022 TObject.GetInterfaceEntry 0036 @IntfCopy 0041 @GetHelperDelegate"
	strings:
		$1 = { 53 56 57 55 8B F9 8B DA 8B F0 8B C3 E8 ?? ?? ?? ?? 85 C0 74 27 83 38 00 7E 22 8D 68 04 8B D5 8B 06 E8 ?? ?? ?? ?? 85 C0 74 12 8B C7 8B D6 85 D2 74 03 83 EA F0 E8 ?? ?? ?? ?? EB 19 8B D3 8B C6 E8 ?? ?? ?? ?? 8B D0 85 D2 74 03 83 EA F0 8B C7 E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_546_0 {
	meta:
		name = "FindDynaMethod"
		size = 46
	strings:
		$1 = { 57 96 EB 02 8B 36 8B 7E C4 85 FF 74 0D 0F B7 0F 51 83 C7 02 F2 66 AF 74 0A 59 8B 76 D0 85 F6 75 E3 5F C3 58 01 C0 29 C8 8B 74 47 FC 5F C3 }
	condition:
		$1
}

rule function_547_0 {
	meta:
		name = "GetDynaMethod"
		size = 18
		refs = "0004 FindDynaMethod"
	strings:
		$1 = { 56 89 D6 E8 ?? ?? ?? ?? 74 04 89 F0 5E C3 31 C0 5E C3 }
	condition:
		$1
}

rule function_548_0 {
	meta:
		name = "@CallDynaInst"
		size = 22
		refs = "0005 FindDynaMethod 0011 @AbstractError"
	strings:
		$1 = { 50 51 8B 00 E8 ?? ?? ?? ?? 59 58 74 02 FF E6 59 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_549_0 {
	meta:
		name = "@CallDynaClass"
		size = 20
		refs = "0003 FindDynaMethod 000f @AbstractError"
	strings:
		$1 = { 50 51 E8 ?? ?? ?? ?? 59 58 74 02 FF E6 59 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_550_0 {
	meta:
		name = "@FindDynaInst"
		size = 22
		refs = "0006 FindDynaMethod 0011 @AbstractError"
	strings:
		$1 = { 56 89 D6 8B 00 E8 ?? ?? ?? ?? 89 F0 5E 75 06 59 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_551_0 {
	meta:
		name = "@FindDynaClass"
		size = 20
		refs = "0004 FindDynaMethod 000f @AbstractError"
	strings:
		$1 = { 56 89 D6 E8 ?? ?? ?? ?? 89 F0 5E 75 06 59 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_552_0 {
	meta:
		name = "TObject.InheritsFrom"
		size = 19
	strings:
		$1 = { EB 02 8B 00 39 D0 74 08 8B 40 D0 85 C0 75 F3 C3 B0 01 C3 }
	condition:
		$1
}

rule function_553_0 {
	meta:
		name = "TObject.ClassInfo"
		size = 6
	strings:
		$1 = { 83 C0 B8 8B 00 C3 }
	condition:
		$1
}

rule function_554_0 {
	meta:
		name = "TObject.SafeCallException"
		size = 6
	strings:
		$1 = { B8 FF FF 00 80 C3 }
	condition:
		$1
}

rule function_555_0 {
	meta:
		name = "TObject.ToString"
		size = 18
		refs = "000b TObject.ClassName"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B 03 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_559_0 {
	meta:
		name = "TObject.Dispatch"
		size = 39
		refs = "0014 FindDynaMethod"
	strings:
		$1 = { 56 66 8B 32 66 09 F6 74 17 66 81 FE 00 C0 73 10 50 8B 00 E8 ?? ?? ?? ?? 58 74 05 89 F1 5E FF E1 5E 8B 08 FF 61 F0 C3 }
	condition:
		$1
}

rule function_560_0 {
	meta:
		name = "UTF8Compare"
		size = 118
		refs = "0022 MultiByteToWideChar 005d UTF8CompareLocale 0063 CompareStringW"
	strings:
		$1 = { 53 56 81 C4 00 FC FF FF 8B DA 68 00 01 00 00 8D 54 24 04 52 0F B6 10 52 40 50 6A 00 68 E9 FD 00 00 E8 ?? ?? ?? ?? 8B F0 68 00 01 00 00 8D 84 24 04 02 00 00 50 0F B6 03 50 8D 43 01 50 6A 00 68 E9 FD 00 00 E8 ?? ?? ?? ?? 8B D8 53 8D 84 24 04 02 00 00 50 56 8D 44 24 0C 50 6A 01 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 F8 02 0F 94 C0 81 C4 00 04 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_561_0 {
	meta:
		name = "UTF8ShortStringToString"
		size = 18
		refs = "000b UTF8ToString"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_961_0 {
	meta:
		name = "AnsiToUtf8"
		size = 18
		refs = "000b UTF8Encode"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_641_0 {
	meta:
		name = "LoadResStringU"
		size = 18
		refs = "000b LoadResString"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_957_0 {
	meta:
		name = "UTF8ToString"
		size = 18
		refs = "000b UTF8ToUnicodeString"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_953_0 {
	meta:
		name = "UTF8ToWideString"
		size = 18
		refs = "000b UTF8Decode"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_962_0 {
	meta:
		name = "Utf8ToAnsi"
		size = 18
		refs = "000b UTF8ToUnicodeString"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_562_0 {
	meta:
		name = "TObject.MethodAddress"
		size = 112
		refs = "0040 UTF8Compare"
	strings:
		$1 = { 53 56 57 31 C9 31 FF 8A 1A EB 02 8B 00 8B 70 C0 85 F6 74 19 66 8B 3E 85 FF 74 12 83 C6 02 8A 4E 06 38 D9 74 29 66 8B 0E 01 CE 4F 75 F1 8B 40 D0 85 C0 75 D7 EB 36 8A 1A EB EB 50 52 8D 46 06 E8 ?? ?? ?? ?? 31 C9 84 C0 5A 58 74 EA EB 1B B5 00 8A 5C 31 06 F6 C3 80 75 E1 32 1C 11 F6 C3 80 75 D9 80 E3 DF 75 D0 49 75 E7 8B 46 02 5F 5E 5B C3 }
	condition:
		$1
}

rule function_563_0 {
	meta:
		name = "TObject.MethodAddress"
		size = 39
		refs = "0011 UTF8EncodeToShortString 001a TObject.MethodAddress"
	strings:
		$1 = { 53 56 81 C4 00 FF FF FF 8B F2 8B D8 8B D4 8B C6 E8 ?? ?? ?? ?? 8B D4 8B C3 E8 ?? ?? ?? ?? 81 C4 00 01 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_566_0 {
	meta:
		name = "TObject.FieldAddress"
		size = 39
		refs = "0011 UTF8EncodeToShortString 001a TObject.FieldAddress"
	strings:
		$1 = { 53 56 81 C4 00 FF FF FF 8B F2 8B D8 8B D4 8B C6 E8 ?? ?? ?? ?? 8B D4 8B C3 E8 ?? ?? ?? ?? 81 C4 00 01 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_564_0 {
	meta:
		name = "TObject.MethodName"
		size = 75
		refs = "0034 TObject.MethodName 0046 UTF8ShortStringToString"
	strings:
		$1 = { 53 56 57 89 CF 31 DB 31 C9 EB 02 8B 00 8B 70 C0 85 F6 74 17 66 8B 0E 85 C9 74 10 83 C6 02 3B 56 02 74 18 66 8B 1E 01 DE 49 75 F3 8B 40 D0 85 C0 75 D9 8D 35 ?? ?? ?? ?? EB 04 00 83 C6 06 89 F0 89 FA 5F 5E 5B E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_565_0 {
	meta:
		name = "TObject.FieldAddress"
		size = 114
		refs = "0042 UTF8Compare"
	strings:
		$1 = { 53 56 57 31 C9 31 FF 8A 1A 50 8B 00 8B 70 BC 85 F6 74 18 66 8B 3E 85 FF 74 11 83 C6 06 8A 4E 06 38 D9 74 2C 8D 74 31 07 4F 75 F2 8B 40 D0 85 C0 75 D8 5A EB 39 8A 1A 8A 4E 06 EB E8 50 52 8D 46 06 E8 ?? ?? ?? ?? 31 C9 84 C0 5A 58 74 E7 EB 19 8A 5C 31 06 F6 C3 80 75 E3 32 1C 11 F6 C3 80 75 DB 80 E3 DF 75 CF 49 75 E7 8B 06 5A 01 D0 5F 5E 5B C3 }
	condition:
		$1
}

rule function_567_0 {
	meta:
		name = "@ClassCreate"
		size = 77
		refs = "001b @ClassCreate 002a @HandleAnyException 0043 @ClassDestroy 0048 @RaiseAgain"
	strings:
		$1 = { 52 51 53 84 D2 7C 03 FF 50 F4 31 D2 8D 4C 24 10 64 8B 1A 89 19 89 69 08 C7 41 04 ?? ?? ?? ?? 89 41 0C 64 89 0A 5B 59 5A C3 E9 ?? ?? ?? ?? 8B 44 24 2C 8B 40 0C 85 C0 74 0E 8B 08 B2 81 50 FF 51 FC 58 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_568_0 {
	meta:
		name = "@ClassDestroy"
		size = 6
	strings:
		$1 = { 8B 10 FF 52 F8 C3 }
	condition:
		$1
}

rule function_569_0 {
	meta:
		name = "@AfterConstruction"
		size = 78
		refs = "000e @AfterConstruction 0030 @HandleAnyException 003a @BeforeDestruction 003f @RaiseAgain 0044 @DoneExcept"
	strings:
		$1 = { 55 8B EC 51 53 56 57 89 45 FC 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 FC 8B 10 FF 52 E4 8B 45 FC 64 8F 05 00 00 00 00 83 C4 08 EB 19 E9 ?? ?? ?? ?? B2 01 8B 45 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_570_0 {
	meta:
		name = "@BeforeDestruction"
		size = 15
	strings:
		$1 = { 84 D2 7F 01 C3 50 52 8B 10 FF 52 E8 5A 58 C3 }
	condition:
		$1
}

rule function_571_0 {
	meta:
		name = "TMonitor.TSpinWait.Reset"
		size = 5
	strings:
		$1 = { 33 D2 89 10 C3 }
	condition:
		$1
}

rule function_572_0 {
	meta:
		name = "TMonitor.TSpinWait.SpinCycle"
		size = 119
		refs = "000d CPUCount 0034 Sleep 0053 Yield 0063 TMonitor.Spin"
	strings:
		$1 = { 53 56 8B D8 8B 03 83 F8 0A 7F 09 83 3D ?? ?? ?? ?? 01 7F 45 83 F8 0A 7C 07 8B C8 83 E9 0A EB 02 8B C8 8B C1 BE 14 00 00 00 99 F7 FE 83 FA 13 75 09 6A 01 E8 ?? ?? ?? ?? EB 2D 8B C1 B9 05 00 00 00 99 F7 F9 83 FA 04 75 09 6A 00 E8 ?? ?? ?? ?? EB 15 E8 ?? ?? ?? ?? EB 0E 8B C8 B8 04 00 00 00 D3 E0 E8 ?? ?? ?? ?? FF 03 83 3B 00 7D 06 C7 03 0A 00 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_573_0 {
	meta:
		name = "TMonitor.TSpinLock.Enter"
		size = 47
		refs = "001a InterlockedCompareExchange 0025 TMonitor.TSpinWait.SpinCycle"
	strings:
		$1 = { 53 56 51 8B F0 33 C0 89 04 24 8B 1E 85 DB 75 12 8B C6 8B CB BA 01 00 00 00 E8 ?? ?? ?? ?? 3B D8 74 09 8B C4 E8 ?? ?? ?? ?? EB DF 5A 5E 5B C3 }
	condition:
		$1
}

rule function_574_0 {
	meta:
		name = "TMonitor.TSpinLock.Exit"
		size = 8
		refs = "0003 InterlockedExchange"
	strings:
		$1 = { 33 D2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_575_0 {
	meta:
		name = "TMonitor.Spin"
		size = 27
	strings:
		$1 = { 55 8B EC 51 89 45 FC 83 7D FC 00 7E 0B F3 90 FF 4D FC 83 7D FC 00 7F F5 59 5D C3 }
	condition:
		$1
}

rule function_576_0 {
	meta:
		name = "TMonitor.CheckMonitorSupport"
		size = 17
		refs = "0002 MonitorSupport 000c Error"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 07 B0 1A E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_577_0 {
	meta:
		name = "TMonitor.CheckOwningThread"
		size = 24
		refs = "0005 GetCurrentThreadId 0010 Error"
	strings:
		$1 = { 53 8B 58 08 E8 ?? ?? ?? ?? 3B D8 74 07 B0 19 E8 ?? ?? ?? ?? 8B C3 5B C3 }
	condition:
		$1
}

rule function_578_0 {
	meta:
		name = "TMonitor.Create"
		size = 31
		refs = "0007 @GetMem 0017 @FillChar"
	strings:
		$1 = { 53 B8 1C 00 00 00 E8 ?? ?? ?? ?? 8B D8 8B C3 33 C9 BA 1C 00 00 00 E8 ?? ?? ?? ?? 8B C3 5B C3 }
	condition:
		$1
}

rule function_579_0 {
	meta:
		name = "TMonitor.Destroy"
		size = 23
		refs = "0001 TMonitor.GetFieldAddress 0012 TMonitor.Destroy"
	strings:
		$1 = { E8 ?? ?? ?? ?? 8B 10 85 D2 74 0B 33 C9 89 08 8B C2 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_580_0 {
	meta:
		name = "TMonitor.Destroy"
		size = 43
		refs = "0006 MonitorSupport 0024 @FreeMem"
	strings:
		$1 = { 53 56 8B D8 83 3D ?? ?? ?? ?? 00 74 12 83 7B 0C 00 74 0C 8B 43 0C 8B 35 ?? ?? ?? ?? FF 56 04 8B C3 33 D2 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_581_0 {
	meta:
		name = "TMonitor.Enter"
		size = 25
		refs = "0004 TMonitor.CheckMonitorSupport 000b TMonitor.GetMonitor 0013 TMonitor.Enter"
	strings:
		$1 = { 53 8B D8 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 83 CA FF E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_582_0 {
	meta:
		name = "TMonitor.Enter"
		size = 28
		refs = "0007 TMonitor.CheckMonitorSupport 000e TMonitor.GetMonitor 0015 TMonitor.Enter"
	strings:
		$1 = { 53 56 8B F2 8B D8 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_583_0 {
	meta:
		name = "TMonitor.DequeueWaiter"
		size = 134
		refs = "0010 TMonitor.TSpinLock.Enter 0018 TMonitor.DequeueWaiter 0044 @TryFinallyExit 0073 TMonitor.TSpinLock.Exit 0079 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 89 45 FC 8B 45 FC 83 C0 18 E8 ?? ?? ?? ?? 33 C9 55 68 ?? ?? ?? ?? 64 FF 31 64 89 21 8B 45 FC 8B 40 14 89 45 F8 83 7D F8 00 74 0A 8B 45 F8 8B 00 3B 45 F8 75 0F 8B 45 FC 33 D2 89 50 14 E8 ?? ?? ?? ?? EB 35 8B 55 FC 8B 52 14 8B 02 89 45 F8 8B 4D FC 8B 00 8B 4D FC 89 02 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 83 C0 18 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 8B 45 F8 59 59 5D C3 }
	condition:
		$1
}

rule function_584_0 {
	meta:
		name = "TMonitor.Enter"
		size = 405
		refs = "0011 TMonitor.TryEnter 0038 GetTickCount 0074 InterlockedCompareExchange 007d GetCurrentThreadId 00e6 TMonitor.GetEvent 00ee MonitorSupport"
	strings:
		$1 = { 53 56 57 55 83 C4 F4 8B FA 8B F0 8B 6E 10 8B C6 E8 ?? ?? ?? ?? 88 04 24 80 3C 24 00 0F 85 67 01 00 00 85 FF 0F 84 5F 01 00 00 C6 44 24 01 00 85 ED 0F 8E 89 00 00 00 E8 ?? ?? ?? ?? 89 44 24 04 85 ED 7E 57 83 FF FF 74 16 E8 ?? ?? ?? ?? 2B 44 24 04 3B F8 77 09 C6 04 24 00 E9 2A 01 00 00 8B 1E 83 FB 01 7F 35 85 DB 75 2A 8B C6 33 C9 BA 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 18 E8 ?? ?? ?? ?? 89 46 08 C7 46 04 01 00 00 00 C6 04 24 01 E9 F5 00 00 00 F3 90 4D 85 ED 7F A9 83 FF FF 74 20 E8 ?? ?? ?? ?? 89 44 24 08 8B 44 24 08 2B 44 24 04 3B F8 77 09 C6 04 24 00 E9 CB 00 00 00 2B F8 8B 1E 85 DB 0F 84 44 FF FF FF 8D 53 02 8B C6 8B CB E8 ?? ?? ?? ?? 3B D8 75 E6 E8 ?? ?? ?? ?? 89 44 24 04 8B C6 E8 ?? ?? ?? ?? 8B D0 8B 1D ?? ?? ?? ?? 8B CF 33 C0 FF 53 10 85 C0 0F 94 04 24 83 FF FF 74 23 E8 ?? ?? ?? ?? 89 44 24 08 8B 44 24 08 2B 44 24 04 3B F8 76 0C 8B 44 24 08 2B 44 24 04 2B F8 EB 02 33 FF 80 3C 24 00 74 23 8B 1E F6 C3 01 75 35 8B D3 83 EA 02 83 CA 01 8B C6 8B CB E8 ?? ?? ?? ?? 3B D8 75 E4 C6 44 24 01 01 EB 19 8B 1E 8B D3 83 EA 02 8B C6 8B CB E8 ?? ?? ?? ?? 3B D8 75 EC C6 44 24 01 01 80 7C 24 01 00 0F 84 66 FF FF FF 80 3C 24 00 74 0F E8 ?? ?? ?? ?? 89 46 08 C7 46 04 01 00 00 00 0F B6 04 24 83 C4 0C 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_585_0 {
	meta:
		name = "TMonitor.Exit"
		size = 74
		refs = "0007 TMonitor.CheckOwningThread 0023 InterlockedCompareExchange 0036 TMonitor.GetEvent 003c MonitorSupport"
	strings:
		$1 = { 53 56 8B F0 8B C6 E8 ?? ?? ?? ?? FF 4E 04 83 7E 04 00 75 33 33 C0 89 46 08 8B 1E 8B D3 4A 8B C6 8B CB E8 ?? ?? ?? ?? 3B D8 75 EE F7 C3 FE FF FF FF 74 14 8B C6 E8 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 33 C9 33 D2 FF 53 10 5E 5B C3 }
	condition:
		$1
}

rule function_586_0 {
	meta:
		name = "TMonitor.Exit"
		size = 22
		refs = "0004 TMonitor.CheckMonitorSupport 000b TMonitor.GetMonitor 0010 TMonitor.Exit"
	strings:
		$1 = { 53 8B D8 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_591_0 {
	meta:
		name = "TMonitor.Pulse"
		size = 22
		refs = "0004 TMonitor.CheckMonitorSupport 000b TMonitor.GetMonitor 0010 TMonitor.Pulse"
	strings:
		$1 = { 53 8B D8 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_593_0 {
	meta:
		name = "TMonitor.PulseAll"
		size = 22
		refs = "0004 TMonitor.CheckMonitorSupport 000b TMonitor.GetMonitor 0010 TMonitor.PulseAll"
	strings:
		$1 = { 53 8B D8 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_597_0 {
	meta:
		name = "TMonitor.TryEnter"
		size = 22
		refs = "0004 TMonitor.CheckMonitorSupport 000b TMonitor.GetMonitor 0010 TMonitor.TryEnter"
	strings:
		$1 = { 53 8B D8 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_587_0 {
	meta:
		name = "TMonitor.GetEvent"
		size = 101
		refs = "0014 MonitorSupport 0024 InterlockedCompareExchangePointer 0047 Sleep"
	strings:
		$1 = { 53 56 57 55 8B E8 BE 01 00 00 00 8B 5D 0C 85 DB 75 4C 8B 1D ?? ?? ?? ?? FF 13 8B F8 8D 45 0C 33 C9 8B D7 E8 ?? ?? ?? ?? 8B D8 85 DB 75 04 8B DF EB 0F 85 FF 74 0B 8B 15 ?? ?? ?? ?? 8B C7 FF 52 04 85 DB 75 19 56 E8 ?? ?? ?? ?? 81 FE 00 02 00 00 7E 07 BE 01 00 00 00 EB B8 03 F6 EB B4 8B C3 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_588_0 {
	meta:
		name = "TMonitor.GetFieldAddress"
		size = 15
	strings:
		$1 = { 8B 10 83 C2 CC 8B 12 03 D0 83 EA 04 8B C2 C3 }
	condition:
		$1
}

rule function_589_0 {
	meta:
		name = "TMonitor.GetMonitor"
		size = 62
		refs = "0004 TMonitor.GetFieldAddress 0011 TMonitor.Create 001e InterlockedCompareExchangePointer 0034 @FreeMem"
	strings:
		$1 = { 53 56 57 E8 ?? ?? ?? ?? 8B F0 8B 1E 85 DB 75 28 E8 ?? ?? ?? ?? 8B F8 8B C6 33 C9 8B D7 E8 ?? ?? ?? ?? 8B D8 85 DB 75 04 8B DF EB 0C BA 1C 00 00 00 8B C7 E8 ?? ?? ?? ?? 8B C3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_590_0 {
	meta:
		name = "TMonitor.Pulse"
		size = 28
		refs = "0002 TMonitor.DequeueWaiter 000c MonitorSupport"
	strings:
		$1 = { 53 E8 ?? ?? ?? ?? 85 C0 74 10 8B 1D ?? ?? ?? ?? 33 C9 33 D2 8B 40 08 FF 53 10 5B C3 }
	condition:
		$1
}

rule function_592_0 {
	meta:
		name = "TMonitor.PulseAll"
		size = 51
		refs = "0008 TMonitor.DequeueWaiter 0014 MonitorSupport"
	strings:
		$1 = { 53 56 57 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D8 85 DB 74 1D 8B 3D ?? ?? ?? ?? 33 C9 33 D2 8B 43 08 FF 57 10 8B C6 E8 ?? ?? ?? ?? 8B D8 85 DB 75 E3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_594_0 {
	meta:
		name = "TMonitor.QueueWaiter"
		size = 112
		refs = "0011 TMonitor.TSpinLock.Enter 0019 TMonitor.QueueWaiter 0060 TMonitor.TSpinLock.Exit 0066 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 89 45 FC 8B 45 FC 83 C0 18 E8 ?? ?? ?? ?? 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 FC 8B 40 14 85 C0 75 0A 8B 45 FC 89 58 14 89 1B EB 15 8B 55 FC 8B 00 89 03 8B 45 FC 8B 40 14 89 18 8B 45 FC 89 58 14 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 83 C0 18 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 5B 59 5D C3 }
	condition:
		$1
}

rule function_595_0 {
	meta:
		name = "TMonitor.RemoveWaiter"
		size = 146
		refs = "001a TMonitor.TSpinLock.Enter 0022 TMonitor.RemoveWaiter 0082 TMonitor.TSpinLock.Exit 0088 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 89 45 FC 8B 45 FC 83 78 14 00 74 7B 8B 45 FC 83 C0 18 E8 ?? ?? ?? ?? 33 C9 55 68 ?? ?? ?? ?? 64 FF 31 64 89 21 8B 45 FC 8B 40 14 8B 10 8B 02 EB 0E 3B C3 75 06 8B 08 89 0A EB 0C 8B D0 8B 00 8B 4D FC 3B 41 14 75 EA 8B 4D FC 3B 41 14 75 18 3B C3 75 14 3B 00 75 0A 8B 45 FC 33 D2 89 50 14 EB 06 8B 45 FC 89 50 14 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 83 C0 18 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ED 5B 59 5D C3 }
	condition:
		$1
}

rule function_596_0 {
	meta:
		name = "TMonitor.SetSpinCount"
		size = 29
		refs = "0005 CPUCount 000d TMonitor.GetMonitor 0017 InterlockedExchange"
	strings:
		$1 = { 53 8B DA 83 3D ?? ?? ?? ?? 01 7E 0F E8 ?? ?? ?? ?? 83 C0 10 8B D3 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_598_0 {
	meta:
		name = "TMonitor.TryEnter"
		size = 61
		refs = "0004 GetCurrentThreadId 001e InterlockedCompareExchange"
	strings:
		$1 = { 53 8B D8 E8 ?? ?? ?? ?? 3B 43 08 75 07 FF 43 04 B0 01 5B C3 8B C3 33 C9 BA 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 13 E8 ?? ?? ?? ?? 89 43 08 C7 43 04 01 00 00 00 B0 01 EB 02 33 C0 5B C3 }
	condition:
		$1
}

rule function_599_0 {
	meta:
		name = "TMonitor.Wait"
		size = 180
		refs = "0018 TMonitor.CheckOwningThread 0021 MonitorSupport 002f TMonitor.Wait 0045 TMonitor.QueueWaiter 0053 TMonitor.Exit 0074 TMonitor.Enter 007e TMonitor.RemoveWaiter 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E8 53 56 57 89 4D FC 8B DA 8B F0 33 C0 89 45 E8 8B C3 E8 ?? ?? ?? ?? 89 45 EC 8B 3D ?? ?? ?? ?? FF 57 08 89 45 F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 43 04 89 45 F4 8D 55 E8 8B C6 E8 ?? ?? ?? ?? C7 43 04 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 8B 4D FC 8B 55 F0 33 C0 FF 57 10 85 C0 0F 94 45 FB 8B C3 83 CA FF E8 ?? ?? ?? ?? 8D 55 E8 8B C6 E8 ?? ?? ?? ?? 8B 45 F4 89 43 04 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 8B 45 F0 FF 53 0C C3 E9 ?? ?? ?? ?? EB EC 0F B6 45 FB 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_600_0 {
	meta:
		name = "TMonitor.Wait"
		size = 31
		refs = "0007 TMonitor.CheckMonitorSupport 000e TMonitor.GetMonitor 0018 TMonitor.Wait"
	strings:
		$1 = { 53 56 8B F2 8B D8 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B D0 8B CE 92 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_601_0 {
	meta:
		name = "TMonitor.Wait"
		size = 41
		refs = "000a TMonitor.CheckMonitorSupport 0011 TMonitor.GetMonitor 0021 TMonitor.Wait"
	strings:
		$1 = { 53 56 57 8B F9 8B F2 8B D8 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 50 8B C3 E8 ?? ?? ?? ?? 8B CF 5A E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_605_0 {
	meta:
		name = "MonitorWait"
		size = 10
		refs = "0005 TMonitor.Wait"
	strings:
		$1 = { 8B CA 8B D0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_609_0 {
	meta:
		name = "MemoryBarrier"
		size = 6
	strings:
		$1 = { 50 87 04 24 58 C3 }
	condition:
		$1
}

rule function_611_0 {
	meta:
		name = "NotifyReRaise"
		size = 27
		refs = "0002 DebugHook 0016 RaiseExceptionProc"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 01 76 11 6A 00 6A 00 6A 00 68 DF FA ED 0E FF 15 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_612_0 {
	meta:
		name = "NotifyNonDelphiException"
		size = 33
		refs = "0002 DebugHook 0018 RaiseExceptionProc"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 00 74 17 50 50 52 54 6A 02 6A 00 68 E4 FA ED 0E FF 15 ?? ?? ?? ?? 83 C4 08 58 C3 }
	condition:
		$1
}

rule function_613_0 {
	meta:
		name = "NotifyExcept"
		size = 21
		refs = "000c RaiseExceptionProc"
	strings:
		$1 = { 54 6A 01 6A 00 68 E0 FA ED 0E FF 15 ?? ?? ?? ?? 83 C4 04 58 C3 }
	condition:
		$1
}

rule function_614_0 {
	meta:
		name = "NotifyOnExcept"
		size = 19
		refs = "0002 DebugHook 000e NotifyExcept"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 01 76 09 50 FF 73 04 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_615_0 {
	meta:
		name = "NotifyAnyExcept"
		size = 17
		refs = "0002 DebugHook 000c NotifyExcept"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 01 76 07 50 53 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_616_0 {
	meta:
		name = "CheckJmp"
		size = 30
	strings:
		$1 = { 85 C9 74 19 8B 41 01 80 39 E9 74 0C 80 39 EB 75 0C 0F BE C0 41 41 EB 03 83 C1 05 01 C1 C3 }
	condition:
		$1
}

rule function_617_0 {
	meta:
		name = "NotifyExceptFinally"
		size = 39
		refs = "0002 DebugHook 000d CheckJmp 001e RaiseExceptionProc"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 01 76 1D 50 52 51 E8 ?? ?? ?? ?? 51 54 6A 01 6A 00 68 E1 FA ED 0E FF 15 ?? ?? ?? ?? 59 59 5A 58 C3 }
	condition:
		$1
}

rule function_618_0 {
	meta:
		name = "NotifyTerminate"
		size = 28
		refs = "0002 DebugHook 0016 RaiseExceptionProc"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 01 76 12 52 54 6A 01 6A 00 68 E2 FA ED 0E FF 15 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule function_619_0 {
	meta:
		name = "NotifyUnhandled"
		size = 30
		refs = "0004 DebugHook 0017 RaiseExceptionProc"
	strings:
		$1 = { 50 52 80 3D ?? ?? ?? ?? 01 76 10 54 6A 02 6A 00 68 E3 FA ED 0E FF 15 ?? ?? ?? ?? 5A 58 C3 }
	condition:
		$1
}

rule function_620_0 {
	meta:
		name = "@HandleAnyException"
		size = 298
		refs = "0021 @FpuInit 0027 ExceptObjProc 004e NotifyNonDelphiException 0054 JITEnable 005d DebugHook 006b UnhandledExceptionFilter 00cd @HandleAnyException 00d4 RTLUnwindProc 00dd @GetTls 00e3 RaiseListPtr 00fe NotifyAnyExcept 0105 @HandleFinallyInternal 0120 TObject.Free"
	strings:
		$1 = { 8B 44 24 04 F7 40 04 06 00 00 00 0F 85 13 01 00 00 81 38 DE FA ED 0E 8B 50 18 8B 48 14 74 6E FC E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 85 D2 0F 84 F1 00 00 00 FF D2 85 C0 0F 84 E7 00 00 00 8B 54 24 0C 8B 4C 24 04 81 39 CE FA EF 0E 74 37 E8 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 76 29 80 3D ?? ?? ?? ?? 00 77 20 8D 4C 24 04 50 51 E8 ?? ?? ?? ?? 83 F8 00 58 0F 84 AB 00 00 00 89 C2 8B 44 24 04 8B 48 0C EB 30 89 C2 8B 44 24 04 8B 48 0C 80 3D ?? ?? ?? ?? 01 76 1E 80 3D ?? ?? ?? ?? 00 77 15 50 8D 44 24 08 52 51 50 E8 ?? ?? ?? ?? 83 F8 00 59 5A 58 74 70 83 48 04 02 53 31 DB 56 57 55 64 8B 1B 53 50 52 51 8B 54 24 28 6A 00 50 68 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 8B 7C 24 28 E8 ?? ?? ?? ?? FF B0 ?? ?? ?? ?? 89 A0 ?? ?? ?? ?? 8B 6F 08 8B 5F 04 C7 47 04 ?? ?? ?? ?? 83 C3 05 E8 ?? ?? ?? ?? FF E3 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 88 ?? ?? ?? ?? 8B 11 89 90 ?? ?? ?? ?? 8B 41 08 E9 ?? ?? ?? ?? B8 01 00 00 00 C3 }
	condition:
		$1
}

rule function_621_0 {
	meta:
		name = "@HandleOnException"
		size = 390
		refs = "001b @FpuInit 0021 ExceptClsProc 007b @AStrCmp 00ad ExceptObjProc 00b6 NotifyNonDelphiException 00bc JITEnable 00c5 DebugHook 00d3 UnhandledExceptionFilter 0129 @HandleOnException 0130 RTLUnwindProc 013a @GetTls 0140 RaiseListPtr 0159 NotifyOnExcept 0161 @HandleFinallyInternal 017c TObject.Free"
	strings:
		$1 = { 8B 44 24 04 F7 40 04 06 00 00 00 0F 85 6F 01 00 00 81 38 DE FA ED 0E 74 1F FC E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 85 D2 0F 84 53 01 00 00 FF D2 85 C0 75 0A E9 48 01 00 00 8B 40 18 8B 00 8B 54 24 08 53 56 57 55 8B 4A 04 8B 59 05 8D 71 09 89 C5 8B 06 85 C0 74 43 89 EF EB 02 8B 3F 8B 00 39 F8 74 37 8B 48 CC 3B 4F CC 75 17 8B 40 C8 8B 57 C8 31 C9 8A 08 3A 0A 75 09 40 42 E8 ?? ?? ?? ?? 74 18 8B 7F D0 8B 06 85 FF 75 D0 83 C6 08 4B 75 C0 5D 5F 5E 5B E9 E7 00 00 00 8B 44 24 14 81 38 DE FA ED 0E 8B 50 18 8B 48 14 74 41 FF 15 ?? ?? ?? ?? 8B 54 24 1C E8 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 76 1E 80 3D ?? ?? ?? ?? 00 77 15 8D 4C 24 14 50 51 E8 ?? ?? ?? ?? 83 F8 00 58 0F 84 9F 00 00 00 89 C2 8B 44 24 14 8B 48 0C EB 27 80 3D ?? ?? ?? ?? 01 76 1E 80 3D ?? ?? ?? ?? 00 77 15 50 8D 44 24 18 52 51 50 E8 ?? ?? ?? ?? 83 F8 00 59 5A 58 74 6D 31 DB 64 8B 1B 53 50 52 51 8B 54 24 28 83 48 04 02 56 6A 00 50 68 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 5B 8B 7C 24 28 E8 ?? ?? ?? ?? FF B0 ?? ?? ?? ?? 89 A0 ?? ?? ?? ?? 8B 6F 08 C7 47 04 ?? ?? ?? ?? 8B 44 24 08 E8 ?? ?? ?? ?? FF 63 04 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 88 ?? ?? ?? ?? 8B 11 89 90 ?? ?? ?? ?? 8B 41 08 E9 ?? ?? ?? ?? B8 01 00 00 00 C3 }
	condition:
		$1
}

rule function_622_0 {
	meta:
		name = "@HandleFinally"
		size = 166
		refs = "0019 @HandleFinally 0035 @GetTls 003b RaiseListPtr 0056 NotifyExceptFinally 0081 @HandleFinallyInternal 009c TObject.Free"
	strings:
		$1 = { 8B 44 24 04 F7 40 04 06 00 00 00 0F 84 8F 00 00 00 53 31 DB 56 57 55 55 68 ?? ?? ?? ?? 64 FF 33 64 89 23 64 8B 1B 8B 50 18 8B 48 14 53 50 52 51 8B 7C 24 34 E8 ?? ?? ?? ?? FF B0 ?? ?? ?? ?? 89 A0 ?? ?? ?? ?? 8B 4F 04 8B 6F 08 C7 47 04 ?? ?? ?? ?? 83 C1 05 E8 ?? ?? ?? ?? FF D1 E8 ?? ?? ?? ?? 8B 88 ?? ?? ?? ?? 8B 11 89 90 ?? ?? ?? ?? 83 C4 14 31 C0 5A 59 59 64 89 10 5D 5F 5E 5B EB 20 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 88 ?? ?? ?? ?? 8B 11 89 90 ?? ?? ?? ?? 8B 41 08 E9 ?? ?? ?? ?? B8 01 00 00 00 C3 }
	condition:
		$1
}

rule function_623_0 {
	meta:
		name = "@HandleFinallyInternal"
		size = 54
		refs = "0017 @HandleFinallyInternal 0026 NotifyExceptFinally"
	strings:
		$1 = { 8B 44 24 04 8B 54 24 08 F7 40 04 06 00 00 00 74 1F 8B 4A 04 C7 42 04 ?? ?? ?? ?? 53 56 57 55 8B 6A 08 83 C1 05 E8 ?? ?? ?? ?? FF D1 5D 5F 5E 5B B8 01 00 00 00 C3 }
	condition:
		$1
}

rule function_624_0 {
	meta:
		name = "@HandleAutoException"
		size = 194
		refs = "0019 @FpuInit 0021 JITEnable 002a DebugHook 0037 UnhandledExceptionFilter 0067 @HandleAutoException 006e RTLUnwindProc 00a6 TObject.Free"
	strings:
		$1 = { 8B 44 24 04 F7 40 04 06 00 00 00 0F 85 AB 00 00 00 81 38 DE FA ED 0E FC E8 ?? ?? ?? ?? 74 27 80 3D ?? ?? ?? ?? 00 76 1E 80 3D ?? ?? ?? ?? 00 77 15 8D 44 24 04 50 E8 ?? ?? ?? ?? 83 F8 00 74 7C 8B 44 24 04 EB 12 80 3D ?? ?? ?? ?? 01 76 09 80 3D ?? ?? ?? ?? 00 76 D9 83 48 04 02 56 57 55 8B 54 24 14 6A 00 50 68 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 5D 5F 5E 8B 44 24 04 BB FF FF 00 80 81 38 DE FA ED 0E 75 24 8B 50 18 8B 48 14 8B 44 24 08 8B 40 0C 85 C0 74 07 8B 18 FF 53 E0 89 C3 8B 44 24 04 8B 40 18 E8 ?? ?? ?? ?? 31 C0 8B 64 24 08 59 64 89 08 5A 5D 8D 52 05 59 FF E2 B8 01 00 00 00 C3 }
	condition:
		$1
}

rule function_625_0 {
	meta:
		name = "@RaiseExcept"
		size = 109
		refs = "000a @RunError 0025 RaiseExceptObjProc 0048 RaiseList 0068 RaiseExceptionProc"
	strings:
		$1 = { 09 C0 75 0A B8 D8 00 00 00 E8 ?? ?? ?? ?? 5A 54 55 57 56 53 50 52 89 E0 54 6A 07 6A 01 68 DE FA ED 0E 52 8B 15 ?? ?? ?? ?? 85 D2 74 39 FF 70 18 FF 70 14 FF 70 10 FF 70 0C FF 70 08 FF 70 04 FF 30 6A 07 FF 30 50 52 E8 ?? ?? ?? ?? 89 C1 5A 58 85 C9 74 03 8B 49 0C 51 6A 01 68 DE FA ED 0E 89 E0 FF D2 83 C4 30 FF 25 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_626_0 {
	meta:
		name = "@RaiseAgain"
		size = 81
		refs = "0007 @RaiseAgain 000c @GetTls 0012 RaiseListPtr 0031 TObject.Free 0036 NotifyReRaise"
	strings:
		$1 = { 8B 44 24 30 C7 40 04 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 90 ?? ?? ?? ?? 8B 0A 89 88 ?? ?? ?? ?? 8B 42 0C 83 60 04 FD 81 38 DE FA ED 0E 74 0D 8B 42 08 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 31 C0 83 C4 14 64 8B 10 59 8B 12 89 11 5D 5F 5E 5B B8 01 00 00 00 C3 }
	condition:
		$1
}

rule function_627_0 {
	meta:
		name = "@DoneExcept"
		size = 48
		refs = "0001 @GetTls 0007 RaiseListPtr 0017 TObject.Free 0029 NotifyTerminate"
	strings:
		$1 = { E8 ?? ?? ?? ?? 8B 90 ?? ?? ?? ?? 8B 0A 89 88 ?? ?? ?? ?? 8B 42 08 E8 ?? ?? ?? ?? 5A 8B 64 24 2C 31 C0 59 64 89 08 58 5D E8 ?? ?? ?? ?? FF E2 C3 }
	condition:
		$1
}

rule function_628_0 {
	meta:
		name = "@TryFinallyExit"
		size = 22
	strings:
		$1 = { 31 D2 8B 4C 24 08 8B 44 24 04 83 C1 05 64 89 02 FF D1 C2 0C 00 C3 }
	condition:
		$1
}

rule function_629_0 {
	meta:
		name = "MapToRunError"
		size = 158
		refs = "0096 RunErrorAt"
	strings:
		$1 = { 55 8B EC 8B 55 08 8B 02 3D 92 00 00 C0 7F 2C 74 5C 3D 8E 00 00 C0 7F 15 74 57 2D 05 00 00 C0 74 5C 2D 87 00 00 00 74 3D 48 74 4E EB 60 05 71 FF FF 3F 83 E8 02 72 36 74 30 EB 52 3D 96 00 00 C0 7F 11 74 3D 2D 93 00 00 C0 74 2E 48 74 13 48 74 24 EB 3A 2D FD 00 00 C0 74 2F 83 E8 3D 74 26 EB 2C B0 C8 EB 2A B0 C9 EB 26 B0 CD EB 22 B0 CF EB 1E B0 C8 EB 1A B0 D7 EB 16 B0 CE EB 12 B0 D8 EB 0E B0 DA EB 0A B0 D9 EB 06 B0 CA EB 02 B0 FF 0F B6 C0 8B 52 0C E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule function_630_0 {
	meta:
		name = "@ExceptionHandler"
		size = 157
		refs = "0013 DebugHook 0020 UnhandledExceptionFilter 002f @FpuInit 003b @ExceptionHandler 0042 RTLUnwindProc 005a ExceptObjProc 0062 MapToRunError 0076 NotifyUnhandled 007c ExceptProc 0096 @RunError"
	strings:
		$1 = { 8B 44 24 04 F7 40 04 06 00 00 00 0F 85 89 00 00 00 80 3D ?? ?? ?? ?? 00 77 0F 8D 44 24 04 50 E8 ?? ?? ?? ?? 83 F8 00 74 71 8B 44 24 04 FC E8 ?? ?? ?? ?? 8B 54 24 08 6A 00 50 68 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 8B 5C 24 04 81 3B DE FA ED 0E 8B 53 14 8B 43 18 74 1D 8B 15 ?? ?? ?? ?? 85 D2 0F 84 ?? ?? ?? ?? 89 D8 FF D2 85 C0 0F 84 ?? ?? ?? ?? 8B 53 0C E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 85 C9 74 02 FF D1 8B 4C 24 04 B8 D9 00 00 00 8B 51 14 89 14 24 E9 ?? ?? ?? ?? 31 C0 C3 }
	condition:
		$1
}

rule function_631_0 {
	meta:
		name = "SetExceptionHandler"
		size = 29
		refs = "0011 @ExceptionHandler"
	strings:
		$1 = { 50 31 D2 8D 45 F0 64 8B 0A 64 89 02 89 08 C7 40 04 ?? ?? ?? ?? 89 68 08 59 89 41 04 C3 }
	condition:
		$1
}

rule function_632_0 {
	meta:
		name = "UnsetExceptionHandler"
		size = 38
	strings:
		$1 = { 8B 40 04 31 D2 85 C0 74 1C 64 8B 0A 39 C8 75 08 8B 00 64 89 02 C3 8B 09 83 F9 FF 74 08 39 01 75 F5 8B 00 89 01 C3 }
	condition:
		$1
}

rule function_633_0 {
	meta:
		name = "FinalizeUnits"
		size = 103
		refs = "0007 InitContext 001c FinalizeUnits 004f @HandleAnyException 0059 @RaiseAgain 005e @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 A1 ?? ?? ?? ?? 85 C0 74 53 8B 1D ?? ?? ?? ?? 8B 78 04 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 DB 7E 1A 4B 89 1D ?? ?? ?? ?? 8B 74 DF 04 85 F6 74 07 83 3E 00 74 02 FF D6 85 DB 7F E6 33 C0 5A 59 59 64 89 10 EB 14 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule function_634_0 {
	meta:
		name = "InitUnits"
		size = 108
		refs = "0008 InitContext 001e InitUnits 0053 @HandleAnyException 0058 FinalizeUnits 005d @RaiseAgain 0062 @DoneExcept"
	strings:
		$1 = { 55 8B EC 51 53 56 57 A1 ?? ?? ?? ?? 85 C0 74 56 8B 38 33 DB 8B 40 04 89 45 FC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 3B FB 7E 1C 8B 45 FC 8B 34 D8 43 89 1D ?? ?? ?? ?? 85 F6 74 07 83 3E 00 74 02 FF D6 3B FB 7F E4 33 C0 5A 59 59 64 89 10 EB 14 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_635_0 {
	meta:
		name = "@PackageLoad"
		size = 117
		refs = "0009 InitContext 003c @PackageLoad 0047 InitUnits 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 D0 56 57 BE ?? ?? ?? ?? 8D 7D D0 B9 0C 00 00 00 F3 A5 C6 05 ?? ?? ?? ?? 00 A3 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 89 15 ?? ?? ?? ?? 8D 45 D0 A3 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 75 D0 BF ?? ?? ?? ?? B9 0C 00 00 00 F3 A5 C3 E9 ?? ?? ?? ?? EB E9 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule function_636_0 {
	meta:
		name = "@PackageUnload"
		size = 117
		refs = "0009 InitContext 003c @PackageUnload 0047 FinalizeUnits 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 D0 56 57 BE ?? ?? ?? ?? 8D 7D D0 B9 0C 00 00 00 F3 A5 C6 05 ?? ?? ?? ?? 00 A3 ?? ?? ?? ?? 8B 00 A3 ?? ?? ?? ?? 89 15 ?? ?? ?? ?? 8D 45 D0 A3 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 75 D0 BF ?? ?? ?? ?? B9 0C 00 00 00 F3 A5 C3 E9 ?? ?? ?? ?? EB E9 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule function_637_0 {
	meta:
		name = "@StartExe"
		size = 69
		refs = "0002 RaiseExceptionProc 0006 RaiseException 000c RTLUnwindProc 0010 RtlUnwind 0015 InitContext 002a MainInstance 0034 SetExceptionHandler 003a IsLibrary 0040 InitUnits"
	strings:
		$1 = { C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? A3 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 89 15 ?? ?? ?? ?? 8B 42 04 A3 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_638_0 {
	meta:
		name = "@StartLib"
		size = 198
		refs = "0005 InitContext 0010 DLLThreadContext 0038 GetCurrentThreadId 0050 RaiseException 0055 RaiseExceptionProc 005a RtlUnwind 005f RTLUnwindProc 0066 SetExceptionHandler 009f MainInstance 00a8 IsLibrary 00af Default8087CW 00b9 @Halt0 00be InitUnits"
	strings:
		$1 = { 51 53 56 57 BB ?? ?? ?? ?? 83 7D 0C 02 7C 05 BB ?? ?? ?? ?? 89 DE 8D 7D C0 B9 0C 00 00 00 F3 A5 8F 43 20 8F 43 1C 8F 43 18 89 6B 14 89 43 08 89 53 10 8D 4D C0 89 0B E8 ?? ?? ?? ?? 89 43 2C 8B 43 08 31 C9 83 7D 0C 00 75 02 8B 08 89 4B 0C B8 ?? ?? ?? ?? A3 ?? ?? ?? ?? B8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 89 D8 E8 ?? ?? ?? ?? 8B 45 0C 40 88 43 28 48 59 8B 11 89 53 24 74 07 3C 03 7D 03 FF 14 81 51 8B 4C 24 08 85 C9 74 08 8B 45 0C 8B 55 10 FF D1 59 8B 45 0C 3C 03 7C 03 FF 14 81 83 3D ?? ?? ?? ?? 00 75 0D C6 05 ?? ?? ?? ?? 01 D9 3D ?? ?? ?? ?? 8B 45 0C 48 0F 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? C2 04 00 C3 }
	condition:
		$1
}

rule function_639_0 {
	meta:
		name = "LoadResStringA"
		size = 84
		refs = "000f LoadResStringA 001f LoadResString 002e @LStrFromUStr 0043 @UStrClr 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 55 FC 8B C6 B9 00 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_640_0 {
	meta:
		name = "LoadResStringW"
		size = 79
		refs = "000f LoadResStringW 001f LoadResString 0029 @WStrFromUStr 003e @UStrClr 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_642_0 {
	meta:
		name = "@InitResStrings"
		size = 64
		refs = "0024 LoadResStringA 002b LoadResStringW 0032 LoadResStringU"
	strings:
		$1 = { 53 31 DB 57 56 8B 3C 18 8D 74 18 04 8B 46 04 01 D8 8B 16 01 DA 8B 4E 08 85 C9 74 07 49 74 0B 49 74 0F CC E8 ?? ?? ?? ?? EB 0C E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 83 C6 0C 4F 75 D0 5E 5F 5B C3 }
	condition:
		$1
}

rule function_643_0 {
	meta:
		name = "@InitResStringImports"
		size = 65
		refs = "0025 LoadResStringA 002c LoadResStringW 0033 LoadResStringU"
	strings:
		$1 = { 53 31 DB 57 56 8B 3C 18 8D 74 18 04 8B 46 04 8B 04 18 8B 16 01 DA 8B 4E 08 85 C9 74 07 49 74 0B 49 74 0F CC E8 ?? ?? ?? ?? EB 0C E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 83 C6 0C 4F 75 CF 5E 5F 5B C3 }
	condition:
		$1
}

rule function_644_0 {
	meta:
		name = "@InitImports"
		size = 36
	strings:
		$1 = { 53 31 DB 57 56 8B 3C 18 8D 74 18 04 8B 46 04 8B 16 8B 04 18 03 46 08 89 04 1A 83 C6 0C 4F 75 EC 5E 5F 5B C3 }
	condition:
		$1
}

rule function_645_0 {
	meta:
		name = "@InitWideStrings"
		size = 26
		refs = "000d @WStrAsg"
	strings:
		$1 = { 53 56 8B 18 8D 70 04 8B 56 04 8B 06 E8 ?? ?? ?? ?? 83 C6 08 4B 75 F0 5E 5B C3 }
	condition:
		$1
}

rule function_646_0 {
	meta:
		name = "MakeErrorMessage"
		size = 100
		refs = "0004 runErrMsg 000c ExitCode 0038 ErrorAddr 0044 hexDigits"
	strings:
		$1 = { 53 56 57 BF ?? ?? ?? ?? B3 10 8B 35 ?? ?? ?? ?? 8B C6 B9 0A 00 00 00 99 F7 F9 80 C2 30 0F B6 C3 88 14 07 B9 0A 00 00 00 8B C6 99 F7 F9 89 C6 4B 85 F6 75 DC B3 1C 8B 35 ?? ?? ?? ?? 8B C6 83 E0 0F 0F B6 80 ?? ?? ?? ?? 0F B6 D3 88 04 17 B9 10 00 00 00 8B C6 33 D2 F7 F1 89 C6 4B 85 F6 75 DC 5F 5E 5B C3 }
	condition:
		$1
}

rule function_647_0 {
	meta:
		name = "ExitDll"
		size = 43
		refs = "001d ExitCode"
	strings:
		$1 = { 89 C7 8B 5F 18 8B 6F 14 FF 77 1C FF 77 20 8B 37 B9 0C 00 00 00 F3 A5 5F 5E 31 C0 87 05 ?? ?? ?? ?? F7 D8 19 C0 40 C9 C2 0C 00 C3 }
	condition:
		$1
}

rule function_648_0 {
	meta:
		name = "WriteErrorMessage"
		size = 144
		refs = "0003 IsConsole 000d Output 0033 runErrMsg 003a GetStdHandle 0040 WriteFile 004e WriteErrorMessage 0063 NoErrMsg 006d errCaption 0079 MessageBoxA"
	strings:
		$1 = { 51 80 3D ?? ?? ?? ?? 00 74 57 66 81 3D ?? ?? ?? ?? B2 D7 75 14 83 3D ?? ?? ?? ?? 00 76 0B B8 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 6A 00 8D 44 24 04 50 6A 1D 68 ?? ?? ?? ?? 6A F5 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 6A 00 8D 44 24 04 50 6A 02 68 ?? ?? ?? ?? 6A F5 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5A C3 80 3D ?? ?? ?? ?? 00 75 13 6A 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 E8 ?? ?? ?? ?? 5A C3 00 E4 04 01 00 FF FF FF FF 02 00 00 00 0D 0A 00 00 }
	condition:
		$1
}

rule function_649_0 {
	meta:
		name = "@Halt0"
		size = 300
		refs = "0005 InitContext 000a ExitProc 0010 ErrorAddr 0018 MakeErrorMessage 001d WriteErrorMessage 002a DLLThreadContext 0032 GetCurrentThreadId 0044 UnsetExceptionHandler 004e ExitDll 0074 ExitCode 0081 AcquireExceptionObject 008e TObject.Free 009e FinalizeUnits 00bb UnregisterModule 00d3 FreeLibrary 00fb ExitProcessProc 010f ExitProcess"
	strings:
		$1 = { 53 56 57 55 BE ?? ?? ?? ?? BF ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 11 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 21 E8 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 75 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 80 7E 28 00 75 14 83 3F 00 74 0F 8B 07 89 C3 33 C0 89 07 FF D3 83 3F 00 75 F1 80 7E 28 02 75 0E 83 3D ?? ?? ?? ?? 00 75 05 33 C0 89 46 0C E8 ?? ?? ?? ?? 8B D8 85 DB 74 12 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 85 DB 75 EE E8 ?? ?? ?? ?? 80 7E 28 01 76 09 83 3D ?? ?? ?? ?? 00 74 26 8B 6E 10 85 ED 74 1F 8B C5 E8 ?? ?? ?? ?? 8B 46 10 8B 78 10 8B 46 10 3B 78 04 74 0A 85 FF 74 06 57 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 80 7E 28 01 75 03 FF 56 24 80 7E 28 00 74 07 8B C6 E8 ?? ?? ?? ?? 83 3E 00 75 1A 83 3D ?? ?? ?? ?? 00 74 06 FF 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 06 56 8B FE 8B F0 B9 0C 00 00 00 F3 A5 5E E9 45 FF FF FF 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_651_0 {
	meta:
		name = "@Run0Error"
		size = 8
		refs = "0003 @RunError"
	strings:
		$1 = { 31 C0 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_652_0 {
	meta:
		name = "@RunError"
		size = 12
		refs = "0002 ErrorAddr 0007 @Halt"
	strings:
		$1 = { 8F 05 ?? ?? ?? ?? E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_653_0 {
	meta:
		name = "@Assert"
		size = 76
		refs = "0022 AssertErrorProc 0044 ErrorAt"
	strings:
		$1 = { 55 8B EC 83 C4 F0 89 4D F4 89 55 F8 89 45 FC 8D 45 F0 83 C0 08 83 C0 04 83 C0 08 8B 00 89 45 F0 83 3D ?? ?? ?? ?? 00 74 15 8B 45 F0 50 8B 4D F4 8B 55 F8 8B 45 FC FF 15 ?? ?? ?? ?? EB 0A 8B 55 F0 B0 15 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule function_654_0 {
	meta:
		name = "ThreadWrapper"
		size = 54
		refs = "0004 @FpuInit 000c @ExceptionHandler 0022 @FreeMem"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 55 31 C9 68 ?? ?? ?? ?? 64 8B 11 52 64 89 21 8B 45 08 8B 48 04 8B 10 51 52 E8 ?? ?? ?? ?? 5A 58 FF D2 31 D2 59 64 89 0A 59 5D 5D C2 04 00 }
	condition:
		$1
}

rule function_655_0 {
	meta:
		name = "BeginThread"
		size = 124
		refs = "0016 SystemThreadFuncProc 0031 @GetMem 003e IsMultiThread 004d ThreadWrapper 005b CreateThread 006d @FreeMem"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 8B F1 89 55 F8 89 45 FC 8B 7D 10 83 3D ?? ?? ?? ?? 00 74 0E 8B D7 8B C6 FF 15 ?? ?? ?? ?? 8B D8 EB 11 B8 08 00 00 00 E8 ?? ?? ?? ?? 8B D8 89 33 89 7B 04 C6 05 ?? ?? ?? ?? 01 8B 45 08 50 8B 45 0C 50 53 B8 ?? ?? ?? ?? 50 8B 45 F8 50 8B 45 FC 50 E8 ?? ?? ?? ?? 8B F0 85 F6 75 0C BA 08 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B C6 5F 5E 5B 59 59 5D C2 0C 00 }
	condition:
		$1
}

rule function_656_0 {
	meta:
		name = "EndThread"
		size = 28
		refs = "0005 SystemThreadEndProc 0016 ExitThread"
	strings:
		$1 = { 53 8B D8 83 3D ?? ?? ?? ?? 00 74 08 8B C3 FF 15 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_658_0 {
	meta:
		name = "__StringLength"
		size = 13
	strings:
		$1 = { 83 E8 04 8B 00 D1 F8 79 03 83 D0 00 C3 }
	condition:
		$1
}

rule function_661_0 {
	meta:
		name = "@_StringRefCnt"
		size = 6
		altNames = "__StringRefCnt"
	strings:
		$1 = { 83 E8 08 8B 00 C3 }
	condition:
		$1
}

rule function_664_0 {
	meta:
		name = "@_StringCodePage"
		size = 7
		altNames = "__StringCodePage"
	strings:
		$1 = { 83 E8 0C 0F B7 00 C3 }
	condition:
		$1
}

rule function_667_0 {
	meta:
		name = "@NewUnicodeString"
		size = 64
		refs = "000f @GetMem 002f DefaultUnicodeCodePage 0039 @IntOver"
	strings:
		$1 = { 85 C0 7E 39 50 01 C0 70 2F 83 C0 0E 70 2A E8 ?? ?? ?? ?? 83 C0 0C 5A C7 40 F8 01 00 00 00 89 50 FC 66 C7 04 50 00 00 66 C7 40 F6 02 00 8B 15 ?? ?? ?? ?? 66 89 50 F4 C3 E9 ?? ?? ?? ?? 31 C0 C3 }
	condition:
		$1
}

rule function_668_0 {
	meta:
		name = "@NewAnsiString"
		size = 74
		refs = "0010 @GetMem 0031 DefaultSystemCodePage 0043 @IntOver"
	strings:
		$1 = { 85 C0 7E 43 50 83 C0 0E 70 38 83 E0 FE 52 50 E8 ?? ?? ?? ?? 5A 59 66 C7 44 02 FE 00 00 83 C0 0C 5A 89 50 FC C7 40 F8 01 00 00 00 85 C9 75 06 8B 0D ?? ?? ?? ?? 89 CA 66 89 50 F4 66 C7 40 F6 01 00 C3 E9 ?? ?? ?? ?? 31 C0 C3 }
	condition:
		$1
}

rule function_669_0 {
	meta:
		name = "WStrError"
		size = 8
		refs = "0003 Error"
	strings:
		$1 = { B0 01 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_670_0 {
	meta:
		name = "@NewWideString"
		size = 21
		refs = "0008 SysAllocStringLen 0010 WStrError"
	strings:
		$1 = { 85 C0 74 10 50 6A 00 E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_671_0 {
	meta:
		name = "@LStrClr"
		size = 35
		refs = "001d @FreeMem"
		altNames = "@UStrClr"
	strings:
		$1 = { 8B 10 85 D2 74 1C C7 00 00 00 00 00 8B 4A F8 49 7C 10 F0 FF 4A F8 75 0A 50 8D 42 F4 E8 ?? ?? ?? ?? 58 C3 }
	condition:
		$1
}

rule function_673_0 {
	meta:
		name = "@WStrClr"
		size = 21
		refs = "000f SysFreeString"
	strings:
		$1 = { 8B 10 85 D2 74 0E C7 00 00 00 00 00 50 52 E8 ?? ?? ?? ?? 58 C3 }
	condition:
		$1
}

rule function_674_0 {
	meta:
		name = "@LStrArrayClr"
		size = 47
		refs = "0022 @FreeMem"
		altNames = "@UStrArrayClr"
	strings:
		$1 = { 53 56 89 C3 89 D6 8B 13 85 D2 74 1A C7 03 00 00 00 00 8B 4A F8 49 7C 0E F0 FF 4A F8 75 08 8D 42 F4 E8 ?? ?? ?? ?? 83 C3 04 4E 75 DA 5E 5B C3 }
	condition:
		$1
}

rule function_676_0 {
	meta:
		name = "@WStrArrayClr"
		size = 33
		refs = "0014 SysFreeString"
	strings:
		$1 = { 53 56 89 C3 89 D6 8B 03 85 C0 74 0C C7 03 00 00 00 00 50 E8 ?? ?? ?? ?? 83 C3 04 4E 75 E8 5E 5B C3 }
	condition:
		$1
}

rule function_677_0 {
	meta:
		name = "@LStrAddRef"
		size = 15
		altNames = "@UStrAddRef"
	strings:
		$1 = { 85 C0 74 0A 8B 50 F8 42 7E 04 F0 FF 40 F8 C3 }
	condition:
		$1
}

rule function_679_0 {
	meta:
		name = "@WStrAddRef"
		size = 31
		refs = "000f SysAllocStringLen 0018 WStrError"
	strings:
		$1 = { 8B 10 85 D2 74 18 50 8B 4A FC D1 E9 51 52 E8 ?? ?? ?? ?? 5A 85 C0 0F 84 ?? ?? ?? ?? 89 02 C3 }
	condition:
		$1
}

rule function_680_0 {
	meta:
		name = "CharFromWChar"
		size = 43
		refs = "000e DefaultSystemCodePage 0021 LocaleCharsFromUnicode"
	strings:
		$1 = { 55 8B EC 53 56 8B 75 08 85 F6 75 06 8B 35 ?? ?? ?? ?? 8B 5D 0C 53 50 52 6A 00 6A 00 8B C6 33 D2 E8 ?? ?? ?? ?? 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_681_0 {
	meta:
		name = "CharFromWChar"
		size = 25
		refs = "000a DefaultSystemCodePage 0010 CharFromWChar"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 53 8B 1D ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_682_0 {
	meta:
		name = "WCharFromChar"
		size = 25
		refs = "0010 UnicodeFromLocaleChars"
	strings:
		$1 = { 55 8B EC 53 8B 5D 0C 53 50 52 8B 45 08 33 D2 E8 ?? ?? ?? ?? 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_683_0 {
	meta:
		name = "@UStrFromPWCharLen"
		size = 48
		refs = "000c @NewUnicodeString 001f Move 0026 @LStrClr"
	strings:
		$1 = { 53 56 57 89 C3 89 D6 89 CF 89 F8 E8 ?? ?? ?? ?? 89 F9 89 C7 85 F6 74 0B 89 C2 89 F0 D1 E1 E8 ?? ?? ?? ?? 89 D8 E8 ?? ?? ?? ?? 89 3B 5F 5E 5B C3 }
	condition:
		$1
}

rule function_684_0 {
	meta:
		name = "@WStrFromPWCharLen"
		size = 35
		refs = "0004 @WStrClr 000c SysAllocStringLen 0015 WStrError 001e SysFreeString"
	strings:
		$1 = { 85 C9 0F 84 ?? ?? ?? ?? 50 51 52 E8 ?? ?? ?? ?? 85 C0 5A 0F 84 ?? ?? ?? ?? FF 32 89 02 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_685_0 {
	meta:
		name = "@LStrFromPCharLen"
		size = 56
		refs = "0013 @NewAnsiString 0024 Move 002b @LStrClr"
	strings:
		$1 = { 55 8B EC 53 56 57 89 C3 89 D6 89 CF 89 F8 0F B7 55 08 E8 ?? ?? ?? ?? 89 F9 89 C7 85 F6 74 09 89 C2 89 F0 E8 ?? ?? ?? ?? 89 D8 E8 ?? ?? ?? ?? 89 3B 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_686_0 {
	meta:
		name = "InternalUStrFromPCharLen"
		size = 148
		refs = "001e @UStrClr 0042 WCharFromChar 0057 @UStrFromPWCharLen 0065 @UStrSetLength"
	strings:
		$1 = { 55 8B EC 81 C4 04 F0 FF FF 50 83 C4 FC 53 56 57 8B F1 89 55 FC 8B F8 85 F6 7F 09 8B C7 E8 ?? ?? ?? ?? EB 67 8D 46 01 3D FF 07 00 00 7D 2F 56 8B 45 08 50 8D 85 FC EF FF FF 8B 4D FC BA FF 07 00 00 E8 ?? ?? ?? ?? 8B D8 85 DB 7E 11 8D 95 FC EF FF FF 8B C7 8B CB E8 ?? ?? ?? ?? EB 2E 8D 5E 01 8B C7 8B D3 E8 ?? ?? ?? ?? 56 8B 45 08 50 8B 07 8B 4D FC 8B D3 E8 ?? ?? ?? ?? 8B D8 85 DB 7D 02 33 DB 8B C7 8B D3 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_688_0 {
	meta:
		name = "InternalWStrFromPCharLen"
		size = 148
		refs = "001e @WStrClr 0042 WCharFromChar 0057 @WStrFromPWCharLen 0065 @WStrSetLength"
	strings:
		$1 = { 55 8B EC 81 C4 04 F0 FF FF 50 83 C4 FC 53 56 57 8B F1 89 55 FC 8B F8 85 F6 7F 09 8B C7 E8 ?? ?? ?? ?? EB 67 8D 46 01 3D FF 07 00 00 7D 2F 56 8B 45 08 50 8D 85 FC EF FF FF 8B 4D FC BA FF 07 00 00 E8 ?? ?? ?? ?? 8B D8 85 DB 7E 11 8D 95 FC EF FF FF 8B C7 8B CB E8 ?? ?? ?? ?? EB 2E 8D 5E 01 8B C7 8B D3 E8 ?? ?? ?? ?? 56 8B 45 08 50 8B 07 8B 4D FC 8B D3 E8 ?? ?? ?? ?? 8B D8 85 DB 7D 02 33 DB 8B C7 8B D3 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_687_0 {
	meta:
		name = "@UStrFromPCharLen"
		size = 15
		refs = "0003 DefaultSystemCodePage 0009 InternalUStrFromPCharLen"
	strings:
		$1 = { 53 8B 1D ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_689_0 {
	meta:
		name = "@WStrFromPCharLen"
		size = 15
		refs = "0003 DefaultSystemCodePage 0009 InternalWStrFromPCharLen"
	strings:
		$1 = { 53 8B 1D ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_690_0 {
	meta:
		name = "@LStrFromPWCharLen"
		size = 130
		refs = "001d @LStrClr 002b DefaultSystemCodePage 003f CharFromWChar 004c @LStrSetLength"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 89 4D F8 89 55 FC 8B F8 8B 5D 08 83 7D F8 00 7F 09 8B C7 E8 ?? ?? ?? ?? EB 56 66 85 DB 75 07 0F B7 1D ?? ?? ?? ?? 8B 45 F8 50 0F B7 C3 50 8B 4D FC 33 D2 33 C0 E8 ?? ?? ?? ?? 8B F0 8B C7 33 C9 8B D6 E8 ?? ?? ?? ?? 85 F6 7E 1E 8B 45 F8 50 0F B7 C3 50 8B 07 8B 4D FC 8B D6 E8 ?? ?? ?? ?? 8B 07 83 E8 0C 66 89 18 EB 07 8B C7 E8 ?? ?? ?? ?? 5F 5E 5B 59 59 5D C2 04 00 }
	condition:
		$1
}

rule function_691_0 {
	meta:
		name = "@UStrAsg"
		size = 69
		refs = "0010 @NewUnicodeString 001e Move 0040 @FreeMem"
	strings:
		$1 = { 85 D2 74 26 8B 4A F8 41 7F 1C 50 52 8B 42 FC E8 ?? ?? ?? ?? 89 C2 58 52 8B 48 FC D1 E1 E8 ?? ?? ?? ?? 5A 58 EB 04 F0 FF 42 F8 87 10 85 D2 74 14 8B 4A F8 49 7C 0E F0 FF 4A F8 75 08 8D 42 F4 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_692_0 {
	meta:
		name = "@LStrLAsg"
		size = 41
		refs = "0024 @FreeMem"
		altNames = "@UStrLAsg"
	strings:
		$1 = { 85 D2 74 0A 8B 4A F8 41 7E 04 F0 FF 42 F8 87 10 85 D2 74 14 8B 4A F8 49 7C 0E F0 FF 4A F8 75 08 8D 42 F4 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_693_0 {
	meta:
		name = "@WStrAsg"
		size = 40
		refs = "0008 @WStrClr 001b SysReAllocStringLen 0023 WStrError"
	strings:
		$1 = { 39 10 74 23 85 D2 0F 84 ?? ?? ?? ?? 8B 4A FC D1 E9 0F 84 ?? ?? ?? ?? 51 52 50 E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_695_0 {
	meta:
		name = "@LStrAsg"
		size = 71
		refs = "0014 @NewAnsiString 0020 Move 0042 @FreeMem"
	strings:
		$1 = { 85 D2 74 28 8B 4A F8 41 7F 1E 50 52 8B 42 FC 0F B7 52 F4 E8 ?? ?? ?? ?? 89 C2 58 52 8B 48 FC E8 ?? ?? ?? ?? 5A 58 EB 04 F0 FF 42 F8 87 10 85 D2 74 14 8B 4A F8 49 7C 0E F0 FF 4A F8 75 08 8D 42 F4 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_697_0 {
	meta:
		name = "StringElementSize"
		size = 21
	strings:
		$1 = { 53 8B D8 85 DB 74 08 83 EB 0A 0F B7 03 5B C3 66 B8 02 00 5B C3 }
	condition:
		$1
}

rule function_698_0 {
	meta:
		name = "StringElementSize"
		size = 21
	strings:
		$1 = { 53 8B D8 85 DB 74 08 83 EB 0A 0F B7 03 5B C3 66 B8 01 00 5B C3 }
	condition:
		$1
}

rule function_699_0 {
	meta:
		name = "StringCodePage"
		size = 24
		refs = "0012 DefaultUnicodeCodePage"
	strings:
		$1 = { 53 8B D8 85 DB 74 08 83 EB 0C 0F B7 03 5B C3 0F B7 05 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_700_0 {
	meta:
		name = "StringCodePage"
		size = 24
		refs = "0012 DefaultSystemCodePage"
	strings:
		$1 = { 53 8B D8 85 DB 74 08 83 EB 0C 0F B7 03 5B C3 0F B7 05 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_701_0 {
	meta:
		name = "StringRefCount"
		size = 10
	strings:
		$1 = { 85 C0 74 05 83 E8 08 8B 00 C3 }
	condition:
		$1
}

rule function_703_0 {
	meta:
		name = "@LStrLen"
		size = 10
		altNames = "@UStrLen"
	strings:
		$1 = { 85 C0 74 05 83 E8 04 8B 00 C3 }
	condition:
		$1
}

rule function_704_0 {
	meta:
		name = "@WStrLen"
		size = 12
	strings:
		$1 = { 85 C0 74 07 83 E8 04 8B 00 D1 E8 C3 }
	condition:
		$1
}

rule function_706_0 {
	meta:
		name = "@PCharLen"
		size = 38
	strings:
		$1 = { 85 C0 74 21 50 31 C9 3A 08 74 17 3A 48 01 74 11 3A 48 02 74 0B 3A 48 03 74 05 83 C0 04 EB E8 40 40 40 59 29 C8 C3 }
	condition:
		$1
}

rule function_707_0 {
	meta:
		name = "@PWCharLen"
		size = 50
	strings:
		$1 = { 85 C0 74 2D 50 31 C9 66 3B 08 74 20 66 3B 48 02 74 17 66 3B 48 04 74 0E 66 3B 48 06 74 05 83 C0 08 EB E4 83 C0 02 83 C0 02 83 C0 02 59 29 C8 D1 E8 C3 }
	condition:
		$1
}

rule function_708_0 {
	meta:
		name = "InternalUniqueStringU"
		size = 65
		refs = "0013 @NewUnicodeString 0022 Move 0037 @FreeMem"
	strings:
		$1 = { 8B 10 85 D2 74 38 8B 4A F8 49 74 32 53 89 C3 8B 42 FC E8 ?? ?? ?? ?? 89 C2 87 03 50 8B 48 FC D1 E1 E8 ?? ?? ?? ?? 58 8B 48 F8 49 7C 0E F0 FF 48 F8 75 08 8D 40 F4 E8 ?? ?? ?? ?? 8B 13 5B 89 D0 C3 }
	condition:
		$1
}

rule function_709_0 {
	meta:
		name = "InternalUniqueStringA"
		size = 67
		refs = "0017 @NewAnsiString 0024 Move 0039 @FreeMem"
	strings:
		$1 = { 8B 10 85 D2 74 3A 8B 4A F8 49 74 34 53 89 C3 8B 42 FC 0F B7 52 F4 E8 ?? ?? ?? ?? 89 C2 87 03 50 8B 48 FC E8 ?? ?? ?? ?? 58 8B 48 F8 49 7C 0E F0 FF 48 F8 75 08 8D 40 F4 E8 ?? ?? ?? ?? 8B 13 5B 89 D0 C3 }
	condition:
		$1
}

rule function_715_0 {
	meta:
		name = "@PStrCmp"
		size = 130
	strings:
		$1 = { 53 56 57 89 C6 89 D7 31 C0 31 D2 8A 06 8A 17 46 47 29 D0 77 02 01 C2 52 C1 EA 02 74 26 8B 0E 8B 1F 39 D9 75 44 4A 74 15 8B 4E 04 8B 5F 04 39 D9 75 37 83 C6 08 83 C7 08 4A 75 E2 EB 06 83 C6 04 83 C7 04 5A 83 E2 03 74 1C 8A 0E 3A 0F 75 2F 4A 74 13 8A 4E 01 3A 4F 01 75 24 4A 74 08 8A 4E 02 3A 4F 02 75 19 01 C0 EB 15 5A 38 D9 75 10 38 FD 75 0C C1 E9 10 C1 EB 10 38 D9 75 02 38 FD 5F 5E 5B C3 }
	condition:
		$1
}

rule function_716_0 {
	meta:
		name = "@AStrCmp"
		size = 111
	strings:
		$1 = { 53 56 51 89 CE C1 EE 02 74 26 8B 08 8B 1A 39 D9 75 45 4E 74 15 8B 48 04 8B 5A 04 39 D9 75 38 83 C0 08 83 C2 08 4E 75 E2 EB 06 83 C0 04 83 C2 04 5E 83 E6 03 74 36 8A 08 3A 0A 75 30 4E 74 13 8A 48 01 3A 4A 01 75 25 4E 74 08 8A 48 02 3A 4A 02 75 1A 31 C0 5E 5B C3 5E 38 D9 75 10 38 FD 75 0C C1 E9 10 C1 EB 10 38 D9 75 02 38 FD 5E 5B C3 }
	condition:
		$1
}

rule function_717_0 {
	meta:
		name = "@WStrLCmp"
		size = 84
	strings:
		$1 = { 53 56 51 89 CE D1 EE 74 26 8B 08 8B 1A 39 D9 75 31 4E 74 15 8B 48 04 8B 5A 04 39 D9 75 24 83 C0 08 83 C2 08 4E 75 E2 EB 06 83 C0 04 83 C2 04 5E 83 E6 01 74 1C 66 8B 08 66 3B 0A 75 14 31 C0 5E 5B C3 5E 66 39 D9 75 09 C1 E9 10 C1 EB 10 66 39 D9 5E 5B C3 }
	condition:
		$1
}

rule function_718_0 {
	meta:
		name = "@PStrCpy"
		size = 11
		refs = "0006 Move"
	strings:
		$1 = { 0F B6 0A 41 92 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_719_0 {
	meta:
		name = "@PStrNCpy"
		size = 25
		refs = "0013 Move"
	strings:
		$1 = { 53 0F B6 1A 3A CB 76 02 8B CB 88 08 42 40 0F B6 C9 92 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_720_0 {
	meta:
		name = "@PStrCat"
		size = 40
	strings:
		$1 = { 56 57 89 C7 31 C0 8A 07 89 D6 31 C9 8A 0E 46 88 C2 00 CA 72 0A 88 17 47 01 C7 F3 A4 5F 5E C3 FE C2 28 D1 B2 FF EB EE C3 }
	condition:
		$1
}

rule function_721_0 {
	meta:
		name = "@PStrNCat"
		size = 48
	strings:
		$1 = { 56 57 89 C7 31 C0 8A 07 89 D6 31 D2 8A 16 46 00 D0 72 12 38 C8 77 0E 89 D1 8A 17 88 07 47 01 D7 F3 A4 5F 5E C3 88 C8 2A 0F 76 F7 88 CA EB E8 C3 }
	condition:
		$1
}

rule function_722_0 {
	meta:
		name = "@Copy"
		size = 65
	strings:
		$1 = { 56 57 89 C6 8B 7C 24 0C 31 C0 0A 06 74 2B 85 D2 7E 18 39 C2 7F 1B 29 D0 40 85 C9 7C 14 39 C1 7F 14 01 D6 88 0F 47 F3 A4 EB 11 BA 01 00 00 00 EB E5 31 C9 EB EC 89 C1 EB E8 88 07 5F 5E C2 04 00 C3 }
	condition:
		$1
}

rule function_723_0 {
	meta:
		name = "@Delete"
		size = 45
	strings:
		$1 = { 56 57 89 C7 31 C0 8A 07 85 D2 7E 1E 39 C2 7F 1A 85 C9 7E 16 29 D0 40 39 C1 7E 02 89 C1 28 0F 01 D7 8D 34 39 29 C8 89 C1 F3 A4 5F 5E C3 }
	condition:
		$1
}

rule function_724_0 {
	meta:
		name = "@Insert"
		size = 102
	strings:
		$1 = { 53 56 57 51 8B 4C 24 14 81 EC 00 02 00 00 89 D3 89 D6 31 D2 8A 16 46 42 85 C9 7E 32 39 D1 7F 35 4A 89 E7 49 29 CA F3 A4 96 8A 0E 46 F3 A4 89 C6 89 D1 F3 A4 29 E7 8B 8C 24 00 02 00 00 39 F9 72 02 89 F9 89 DF 89 E6 88 0F 47 F3 A4 EB 0B B9 01 00 00 00 EB CB 89 D1 EB C7 81 C4 04 02 00 00 5F 5E 5B C2 04 00 C3 }
	condition:
		$1
}

rule function_726_0 {
	meta:
		name = "@SetString"
		size = 17
		refs = "000c Move"
	strings:
		$1 = { 88 08 85 D2 74 0A 40 0F B6 C9 92 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_727_0 {
	meta:
		name = "@LStrFromChar"
		size = 16
		refs = "000a @LStrFromPCharLen"
	strings:
		$1 = { 52 89 E2 51 B9 01 00 00 00 E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule function_728_0 {
	meta:
		name = "@LStrFromWChar"
		size = 16
		refs = "000a @LStrFromPWCharLen"
	strings:
		$1 = { 52 89 E2 51 B9 01 00 00 00 E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule function_729_0 {
	meta:
		name = "@LStrFromPChar"
		size = 52
		refs = "002f @LStrFromPCharLen"
	strings:
		$1 = { FF 34 24 89 4C 24 04 31 C9 85 D2 74 21 52 3A 0A 74 17 3A 4A 01 74 11 3A 4A 02 74 0B 3A 4A 03 74 05 83 C2 04 EB E8 42 42 42 89 D1 5A 29 D1 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_730_0 {
	meta:
		name = "@LStrFromPWChar"
		size = 64
		refs = "003b @LStrFromPWCharLen"
	strings:
		$1 = { FF 34 24 89 4C 24 04 31 C9 85 D2 74 2D 52 66 3B 0A 74 20 66 3B 4A 02 74 17 66 3B 4A 04 74 0E 66 3B 4A 06 74 05 83 C2 08 EB E4 83 C2 02 83 C2 02 83 C2 02 89 D1 5A 29 D1 D1 E9 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_731_0 {
	meta:
		name = "@LStrFromString"
		size = 18
		refs = "000d @LStrFromPCharLen"
	strings:
		$1 = { FF 34 24 89 4C 24 04 31 C9 8A 0A 42 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_732_0 {
	meta:
		name = "@LStrFromArray"
		size = 31
		refs = "0017 @LStrFromPCharLen"
	strings:
		$1 = { 55 8B EC 57 50 51 89 D7 31 C0 F2 AE 75 02 F7 D1 58 01 C1 58 5F 5D E9 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule function_733_0 {
	meta:
		name = "@LStrFromWArray"
		size = 32
		refs = "0018 @LStrFromPWCharLen"
	strings:
		$1 = { 55 8B EC 57 50 51 89 D7 31 C0 F2 66 AF 75 02 F7 D1 58 01 C1 58 5F 5D E9 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule function_734_0 {
	meta:
		name = "@LStrFromWStr"
		size = 24
		refs = "0013 @LStrFromPWCharLen"
	strings:
		$1 = { FF 34 24 89 4C 24 04 31 C9 85 D2 74 05 8B 4A FC D1 E9 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_735_0 {
	meta:
		name = "@LStrToString"
		size = 34
		refs = "0017 Move"
	strings:
		$1 = { 53 85 D2 74 18 8B 5A FC 85 DB 74 11 39 D9 7C 02 89 D9 88 08 40 92 E8 ?? ?? ?? ?? 5B C3 C6 00 00 5B C3 }
	condition:
		$1
}

rule function_736_0 {
	meta:
		name = "@LStrCat"
		size = 87
		refs = "000a @LStrAsg 002c @LStrSetLength 003a Move 0052 @IntOver"
	strings:
		$1 = { 85 D2 74 52 8B 08 85 C9 0F 84 ?? ?? ?? ?? 53 56 57 89 C3 89 D6 89 CF 39 CE 8B 79 FC 8B 56 FC 01 FA 70 2E 39 CE 74 1B 0F B7 49 F4 E8 ?? ?? ?? ?? 89 F0 8B 4E FC 8B 13 01 FA E8 ?? ?? ?? ?? 5F 5E 5B C3 0F B7 49 F4 E8 ?? ?? ?? ?? 8B 03 89 F9 EB E4 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_737_0 {
	meta:
		name = "@LStrCat3"
		size = 130
		refs = "0008 @LStrAsg 001e @LStrCat 0039 @NewAnsiString 0047 Move 007d @IntOver"
	strings:
		$1 = { 85 D2 74 69 85 C9 0F 84 ?? ?? ?? ?? 3B 10 74 64 3B 08 74 0E 50 51 E8 ?? ?? ?? ?? 5A 58 E9 ?? ?? ?? ?? 57 8B 7A FC 03 79 FC 70 50 53 56 50 89 D3 89 CE 89 F8 0F B7 56 F4 E8 ?? ?? ?? ?? 89 C7 89 FA 89 D8 8B 4B FC E8 ?? ?? ?? ?? 89 FA 89 F0 8B 4E FC 03 53 FC E8 ?? ?? ?? ?? 58 89 FA 85 FF 74 03 FF 4F F8 E8 ?? ?? ?? ?? 5E 5B 5F C3 89 CA E9 ?? ?? ?? ?? 89 CA E9 ?? ?? ?? ?? 5F E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_738_0 {
	meta:
		name = "@LStrCatN"
		size = 200
		refs = "0066 @LStrSetLength 007d @NewAnsiString 0096 Move 00b0 @LStrAsg 00c3 @IntOver"
	strings:
		$1 = { 6A 00 53 56 57 52 50 6A 00 89 D3 31 FF 8B 4C 94 1C 85 C9 74 14 0F B7 71 F4 89 74 24 18 39 08 75 08 89 CF 8B 41 FC 4A EB 02 31 C0 8B 4C 94 1C 85 C9 74 1E 03 41 FC 0F 80 86 00 00 00 83 7C 24 18 00 75 08 0F B7 71 F4 89 74 24 18 39 CF 75 02 31 FF 4A 75 D7 85 FF 74 20 89 C2 8B 44 24 04 8B 77 FC 0F B7 4F F4 E8 ?? ?? ?? ?? 8B 7C 24 04 8B 07 89 04 24 03 37 4B EB 0E 8B 54 24 18 E8 ?? ?? ?? ?? 89 04 24 89 C6 8B 44 9C 1C 89 F2 85 C0 74 0A 8B 48 FC 01 CE E8 ?? ?? ?? ?? 4B 75 E9 8B 14 24 8B 44 24 04 85 FF 75 0C 85 D2 74 03 FF 4A F8 E8 ?? ?? ?? ?? 83 C4 08 5A 5F 5E 5B 58 58 8D 24 94 FF E0 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_739_0 {
	meta:
		name = "@LStrCmp"
		size = 88
	strings:
		$1 = { 39 D0 74 30 85 D0 74 40 0F B6 08 2A 0A 75 25 53 8B 58 FC 2B 5A FC 53 83 D1 FF 21 D9 2B 48 FC 29 C8 29 CA 8B 1C 01 33 1C 11 75 0A 83 C1 04 78 F3 58 01 C0 5B C3 0F BC DB C1 EB 03 01 D9 79 F1 8A 04 01 3A 04 11 5B 5B C3 85 C0 74 08 85 D2 75 B8 39 50 FC C3 3B 42 FC C3 }
	condition:
		$1
}

rule function_740_0 {
	meta:
		name = "@LStrEqual"
		size = 69
	strings:
		$1 = { 39 D0 74 2B 85 D0 74 2C 8B 48 FC 3B 4A FC 75 1F 53 8D 54 11 FC 8D 5C 01 FC F7 D9 8B 03 3B 02 75 0D 83 C1 04 79 0A 8B 04 19 3B 04 11 74 F3 5B C3 31 C0 5B C3 85 C0 74 08 85 D2 75 CC 39 50 FC C3 3B 42 FC C3 C3 }
	condition:
		$1
}

rule function_741_0 {
	meta:
		name = "@LStrToPChar"
		size = 15
		refs = "0007 EmptyStringA"
	strings:
		$1 = { 8B D0 85 D2 75 06 B8 ?? ?? ?? ?? C3 8B C2 C3 }
	condition:
		$1
}

rule function_769_0 {
	meta:
		name = "@UStrToPWChar"
		size = 15
		refs = "0007 EmptyStringW"
	strings:
		$1 = { 8B D0 85 D2 75 06 B8 ?? ?? ?? ?? C3 8B C2 C3 }
	condition:
		$1
}

rule function_758_0 {
	meta:
		name = "@WStrToPWChar"
		size = 20
		refs = "0007 @WStrToPWChar"
	strings:
		$1 = { 8B D0 85 D2 75 06 B8 ?? ?? ?? ?? C3 8B C2 C3 00 00 00 00 00 }
	condition:
		$1
}

rule function_742_0 {
	meta:
		name = "@LStrCopy"
		size = 69
		refs = "0029 @LStrFromPCharLen 003c @LStrClr"
	strings:
		$1 = { 53 85 C0 74 32 8B 58 FC 85 DB 74 2B 4A 7C 20 39 DA 7D 24 29 D3 85 C9 7C 1E 39 D9 7F 16 01 C2 0F B7 40 F4 50 8B 44 24 0C E8 ?? ?? ?? ?? EB 11 31 D2 EB E0 89 D9 EB E6 8B 44 24 08 E8 ?? ?? ?? ?? 5B C2 04 00 C3 }
	condition:
		$1
}

rule function_743_0 {
	meta:
		name = "@LStrDelete"
		size = 76
		refs = "000a InternalUniqueStringA 0032 Move 0044 @LStrSetLength"
	strings:
		$1 = { 53 56 57 89 C3 89 D6 89 CF E8 ?? ?? ?? ?? 8B 13 85 D2 74 34 8B 4A FC 4E 7C 2E 39 CE 7D 2A 85 FF 7E 26 29 F1 39 CF 7E 02 89 CF 29 F9 01 F2 8D 04 17 E8 ?? ?? ?? ?? 8B 13 89 D8 0F B7 4A F4 8B 52 FC 29 FA E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_744_0 {
	meta:
		name = "@LStrInsert"
		size = 111
		refs = "0039 @LStrSetLength 0053 Move 006a @IntOver"
	strings:
		$1 = { 85 C0 74 64 53 56 57 55 89 C3 89 D6 89 CF 8B 12 52 85 D2 74 03 8B 52 FC 4F 7D 02 31 FF 39 D7 7E 02 89 D7 8B 6B FC 8B 06 85 C0 75 02 89 D8 0F B7 48 F4 89 F0 01 EA 70 31 E8 ?? ?? ?? ?? 58 39 D8 75 02 8B 1E 8B 06 8D 14 2F 8B 48 FC 29 D1 01 C2 01 F8 E8 ?? ?? ?? ?? 89 D8 8B 16 89 E9 01 FA E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_745_0 {
	meta:
		name = "@LStrPos"
		size = 69
	strings:
		$1 = { 85 C0 74 40 85 D2 74 31 53 56 57 89 C6 89 D7 8B 4F FC 57 8B 56 FC 4A 78 1B 8A 06 46 29 D1 7E 14 F2 AE 75 10 89 CB 56 57 89 D1 F3 A6 5F 5E 74 0C 89 D9 EB EC 5A 31 C0 EB 08 31 C0 C3 5A 89 F8 29 D0 5F 5E 5B C3 }
	condition:
		$1
}

rule function_746_0 {
	meta:
		name = "@LStrSetLength"
		size = 118
		refs = "002c @ReallocMem 0042 @IntOver 004b @NewAnsiString 0063 Move 006a @LStrClr"
	strings:
		$1 = { 53 56 57 55 6A 00 89 C3 89 D6 89 CD 31 FF 85 D2 7E 55 8B 03 85 C0 74 2E 83 78 F8 01 75 28 83 E8 0C 83 C2 0D 70 1B 89 04 24 89 E0 E8 ?? ?? ?? ?? 8B 04 24 83 C0 0C 89 03 89 70 FC C6 04 06 00 EB 2F E9 ?? ?? ?? ?? 89 D0 89 EA E8 ?? ?? ?? ?? 89 C7 8B 03 85 C0 74 10 89 FA 8B 48 FC 39 F1 7C 02 89 F1 E8 ?? ?? ?? ?? 89 D8 E8 ?? ?? ?? ?? 89 3B 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_747_0 {
	meta:
		name = "@LStrFromUStr"
		size = 22
		refs = "0011 @LStrFromPWCharLen"
	strings:
		$1 = { FF 34 24 89 4C 24 04 31 C9 85 D2 74 03 8B 4A FC E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_748_0 {
	meta:
		name = "WStrSet"
		size = 13
		refs = "0008 SysFreeString"
	strings:
		$1 = { 87 10 85 D2 74 06 52 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_749_0 {
	meta:
		name = "@WStrFromChar"
		size = 21
		refs = "000a DefaultSystemCodePage 000f InternalWStrFromPCharLen"
	strings:
		$1 = { 52 89 E2 B9 01 00 00 00 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule function_750_0 {
	meta:
		name = "@WStrFromWChar"
		size = 15
		refs = "0009 @WStrFromPWCharLen"
	strings:
		$1 = { 52 89 E2 B9 01 00 00 00 E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule function_770_0 {
	meta:
		name = "@UStrFromChar"
		size = 15
		refs = "0009 @UStrFromPCharLen"
	strings:
		$1 = { 52 89 E2 B9 01 00 00 00 E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule function_771_0 {
	meta:
		name = "@UStrFromWChar"
		size = 15
		refs = "0009 @UStrFromPWCharLen"
	strings:
		$1 = { 52 89 E2 B9 01 00 00 00 E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule function_751_0 {
	meta:
		name = "@WStrFromPChar"
		size = 45
		refs = "0028 @WStrFromPCharLen"
	strings:
		$1 = { 31 C9 85 D2 74 21 52 3A 0A 74 17 3A 4A 01 74 11 3A 4A 02 74 0B 3A 4A 03 74 05 83 C2 04 EB E8 42 42 42 89 D1 5A 29 D1 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_772_0 {
	meta:
		name = "@UStrFromPChar"
		size = 45
		refs = "0028 @UStrFromPCharLen"
	strings:
		$1 = { 31 C9 85 D2 74 21 52 3A 0A 74 17 3A 4A 01 74 11 3A 4A 02 74 0B 3A 4A 03 74 05 83 C2 04 EB E8 42 42 42 89 D1 5A 29 D1 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_752_0 {
	meta:
		name = "@WStrFromPWChar"
		size = 57
		refs = "0034 @WStrFromPWCharLen"
	strings:
		$1 = { 31 C9 85 D2 74 2D 52 66 3B 0A 74 20 66 3B 4A 02 74 17 66 3B 4A 04 74 0E 66 3B 4A 06 74 05 83 C2 08 EB E4 83 C2 02 83 C2 02 83 C2 02 89 D1 5A 29 D1 D1 E9 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_773_0 {
	meta:
		name = "@UStrFromPWChar"
		size = 57
		refs = "0034 @UStrFromPWCharLen"
	strings:
		$1 = { 31 C9 85 D2 74 2D 52 66 3B 0A 74 20 66 3B 4A 02 74 17 66 3B 4A 04 74 0E 66 3B 4A 06 74 05 83 C2 08 EB E4 83 C2 02 83 C2 02 83 C2 02 89 D1 5A 29 D1 D1 E9 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_753_0 {
	meta:
		name = "@WStrFromString"
		size = 11
		refs = "0006 @WStrFromPCharLen"
	strings:
		$1 = { 31 C9 8A 0A 42 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_780_0 {
	meta:
		name = "@UStrFromString"
		size = 11
		refs = "0006 @UStrFromPCharLen"
	strings:
		$1 = { 31 C9 8A 0A 42 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_754_0 {
	meta:
		name = "@WStrFromArray"
		size = 24
		refs = "0013 @WStrFromPCharLen"
	strings:
		$1 = { 57 50 51 89 D7 31 C0 F2 AE 75 02 F7 D1 58 01 C1 58 5F E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_774_0 {
	meta:
		name = "@UStrFromArray"
		size = 24
		refs = "0013 @UStrFromPCharLen"
	strings:
		$1 = { 57 50 51 89 D7 31 C0 F2 AE 75 02 F7 D1 58 01 C1 58 5F E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_755_0 {
	meta:
		name = "@WStrFromWArray"
		size = 25
		refs = "0014 @WStrFromPWCharLen"
	strings:
		$1 = { 57 50 51 89 D7 31 C0 F2 66 AF 75 02 F7 D1 58 01 C1 58 5F E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_775_0 {
	meta:
		name = "@UStrFromWArray"
		size = 25
		refs = "0014 @UStrFromPWCharLen"
	strings:
		$1 = { 57 50 51 89 D7 31 C0 F2 66 AF 75 02 F7 D1 58 01 C1 58 5F E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_756_0 {
	meta:
		name = "@WStrFromLStr"
		size = 31
		refs = "0015 InternalWStrFromPCharLen 001a @WStrClr"
	strings:
		$1 = { 31 C9 85 D2 74 13 0F B7 4A F4 FF 34 24 89 4C 24 04 8B 4A FC E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_776_0 {
	meta:
		name = "@UStrFromLStr"
		size = 31
		refs = "0015 InternalUStrFromPCharLen 001a @UStrFromPCharLen"
	strings:
		$1 = { 31 C9 85 D2 74 13 0F B7 4A F4 FF 34 24 89 4C 24 04 8B 4A FC E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_757_0 {
	meta:
		name = "@WStrToString"
		size = 109
		refs = "0041 CharFromWChar 0060 Move"
	strings:
		$1 = { 53 56 81 C4 00 FE FF FF 8B D9 8B F0 81 FB FF 00 00 00 7E 05 BB FF 00 00 00 8B C2 85 C0 74 07 83 E8 04 8B 00 D1 E8 3B D8 7F 02 8B C3 85 C0 75 04 33 C0 EB 1F 50 8D 44 24 04 8B CA BA FF 01 00 00 E8 ?? ?? ?? ?? 85 C0 7D 04 33 C0 EB 06 3B D8 7D 02 8B C3 88 06 85 C0 7E 0B 8D 56 01 8B CC 91 E8 ?? ?? ?? ?? 81 C4 00 02 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_759_0 {
	meta:
		name = "@WStrCat"
		size = 123
		refs = "0040 @NewWideString 0056 Move 0070 WStrSet"
	strings:
		$1 = { 53 56 57 83 C4 F4 89 54 24 04 89 04 24 8B 44 24 04 85 C0 74 07 83 E8 04 8B 00 D1 E8 8B D8 85 DB 74 52 8B 04 24 8B 00 89 44 24 08 8B 44 24 08 85 C0 74 07 83 E8 04 8B 00 D1 E8 8B F0 8D 04 33 E8 ?? ?? ?? ?? 8B F8 85 F6 7E 10 8B CE 03 C9 8B D7 8B 04 24 8B 00 E8 ?? ?? ?? ?? 8D 14 77 8B CB 03 C9 8B 44 24 04 E8 ?? ?? ?? ?? 8B 04 24 8B D7 E8 ?? ?? ?? ?? 83 C4 0C 5F 5E 5B C3 }
	condition:
		$1
}

rule function_760_0 {
	meta:
		name = "@WStrCat3"
		size = 122
		refs = "003c @NewWideString 004b Move 0065 WStrSet 006f @WStrClr"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 89 4C 24 04 8B EA 89 04 24 8B C5 85 C0 74 07 83 E8 04 8B 00 D1 E8 8B D8 8B 44 24 04 85 C0 74 07 83 E8 04 8B 00 D1 E8 8B F0 85 DB 75 04 85 F6 74 33 8D 04 1E E8 ?? ?? ?? ?? 8B F8 8B CB 03 C9 8B D7 8B C5 E8 ?? ?? ?? ?? 8D 14 5F 8B CE 03 C9 8B 44 24 04 E8 ?? ?? ?? ?? 8B 04 24 8B D7 E8 ?? ?? ?? ?? EB 08 8B 04 24 E8 ?? ?? ?? ?? 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_761_0 {
	meta:
		name = "@WStrCatN"
		size = 72
		refs = "0019 @NewWideString 0030 Move 003a WStrSet"
	strings:
		$1 = { 53 56 52 50 89 D3 31 C0 8B 4C 94 10 85 C9 74 03 03 41 FC 4A 75 F2 D1 E8 E8 ?? ?? ?? ?? 50 89 C6 8B 44 9C 14 89 F2 85 C0 74 0A 8B 48 FC 01 CE E8 ?? ?? ?? ?? 4B 75 E9 5A 58 E8 ?? ?? ?? ?? 5A 5E 5B 58 8D 24 94 FF E0 C3 }
	condition:
		$1
}

rule function_762_0 {
	meta:
		name = "@WStrCmp"
		size = 129
	strings:
		$1 = { 53 56 57 89 C6 89 D7 39 D0 74 72 85 F6 74 51 85 FF 74 54 8B 46 FC 8B 57 FC 29 D0 77 02 01 C2 52 C1 EA 02 74 26 8B 0E 8B 1F 39 D9 75 41 4A 74 15 8B 4E 04 8B 5F 04 39 D9 75 34 83 C6 08 83 C7 08 4A 75 E2 EB 06 83 C6 04 83 C7 04 5A 83 E2 02 74 0B 66 8B 0E 66 8B 1F 66 39 D9 75 21 01 C0 EB 1D 8B 57 FC 29 D0 EB 16 8B 46 FC 29 D0 EB 0F 5A 66 39 D9 75 09 C1 E9 10 C1 EB 10 66 39 D9 5F 5E 5B C3 }
	condition:
		$1
}

rule function_764_0 {
	meta:
		name = "@WStrCopy"
		size = 73
		refs = "003f @WStrFromPWCharLen"
	strings:
		$1 = { 55 8B EC 53 56 8B D8 85 DB 74 07 83 EB 04 8B 1B D1 EB 83 FA 01 7D 04 33 D2 EB 07 4A 3B DA 7D 02 8B D3 85 C9 7D 04 33 F6 EB 0A 8B F3 2B F2 3B CE 7D 02 8B F1 8B 4D 08 03 D2 03 D0 8B C6 91 E8 ?? ?? ?? ?? 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_765_0 {
	meta:
		name = "@WStrDelete"
		size = 154
		refs = "0054 @NewWideString 006a Move 008f WStrSet"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 8B DA 89 04 24 8B 04 24 8B 00 89 44 24 04 8B 44 24 04 85 C0 74 07 83 E8 04 8B 00 D1 E8 8B F0 85 F6 7E 69 83 FB 01 7C 64 3B F3 7C 60 85 C9 7E 5C 4B 8B FE 2B FB 2B F9 85 FF 7D 02 33 FF 85 DB 75 08 85 FF 75 04 33 ED EB 39 8D 04 1F E8 ?? ?? ?? ?? 8B E8 85 DB 7E 10 8B CB 03 C9 8B D5 8B 04 24 8B 00 E8 ?? ?? ?? ?? 85 FF 7E 17 2B F7 8B 04 24 8B 00 8D 04 70 8B CF 03 C9 8D 54 5D 00 E8 ?? ?? ?? ?? 8B 04 24 8B D5 E8 ?? ?? ?? ?? 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_766_0 {
	meta:
		name = "@WStrInsert"
		size = 179
		refs = "0057 @NewWideString 006e Move 00a7 WStrSet"
	strings:
		$1 = { 53 56 57 55 83 C4 F4 8B D9 89 54 24 04 89 04 24 8B 04 24 85 C0 74 07 83 E8 04 8B 00 D1 E8 8B F0 85 F6 0F 8E 83 00 00 00 8B 44 24 04 8B 00 89 44 24 08 8B 44 24 08 85 C0 74 07 83 E8 04 8B 00 D1 E8 8B F8 83 FB 01 7D 04 33 DB EB 07 4B 3B FB 7D 02 8B DF 8D 04 3E E8 ?? ?? ?? ?? 8B E8 85 DB 7E 11 8B CB 03 C9 8B D5 8B 44 24 04 8B 00 E8 ?? ?? ?? ?? 8B CE 03 C9 8D 54 5D 00 8B 04 24 E8 ?? ?? ?? ?? 3B FB 7E 1A 03 F3 8D 54 75 00 2B FB 8B CF 03 C9 8B 44 24 04 8B 00 8D 04 58 E8 ?? ?? ?? ?? 8B 44 24 04 8B D5 E8 ?? ?? ?? ?? 83 C4 0C 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_767_0 {
	meta:
		name = "@WStrSetLength"
		size = 81
		refs = "0011 @NewWideString 003f Move 0048 WStrSet"
	strings:
		$1 = { 53 56 57 51 8B F2 8B F8 33 DB 85 F6 7E 35 8B C6 E8 ?? ?? ?? ?? 8B D8 8B 17 8B C2 89 04 24 8B 04 24 85 C0 74 07 83 E8 04 8B 00 D1 E8 85 C0 7E 13 3B F0 7D 02 8B C6 8B C8 03 C9 8B C2 8B D3 E8 ?? ?? ?? ?? 8B C7 8B D3 E8 ?? ?? ?? ?? 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_768_0 {
	meta:
		name = "@WCharToString"
		size = 91
		refs = "002d CharFromWChar 004e Move"
	strings:
		$1 = { 53 56 81 C4 FC FE FF FF 8B D9 66 89 14 24 8B F0 81 FB FF 00 00 00 7E 05 BB FF 00 00 00 6A 01 8D 4C 24 04 8D 44 24 06 BA FF 00 00 00 E8 ?? ?? ?? ?? 85 C0 7D 04 33 C0 EB 06 3B D8 7D 02 8B C3 88 06 85 C0 7E 0D 8D 56 01 8D 4C 24 02 91 E8 ?? ?? ?? ?? 81 C4 04 01 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_777_0 {
	meta:
		name = "@UStrFromWStr"
		size = 17
		refs = "000c @UStrFromPWCharLen"
	strings:
		$1 = { 31 C9 85 D2 74 05 8B 4A FC D1 E9 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_778_0 {
	meta:
		name = "@WStrFromUStr"
		size = 15
		refs = "000a @WStrFromPWCharLen"
	strings:
		$1 = { 31 C9 85 D2 74 03 8B 4A FC E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_779_0 {
	meta:
		name = "@UStrToString"
		size = 107
		refs = "003f CharFromWChar 005e Move"
	strings:
		$1 = { 53 56 81 C4 00 FE FF FF 8B D9 8B F0 81 FB FF 00 00 00 7E 05 BB FF 00 00 00 8B C2 85 C0 74 05 83 E8 04 8B 00 3B D8 7F 02 8B C3 85 C0 75 04 33 C0 EB 1F 50 8D 44 24 04 8B CA BA FF 01 00 00 E8 ?? ?? ?? ?? 85 C0 7D 04 33 C0 EB 06 3B D8 7D 02 8B C3 88 06 85 C0 7E 0B 8D 56 01 8B CC 91 E8 ?? ?? ?? ?? 81 C4 00 02 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_781_0 {
	meta:
		name = "@UStrSetLength"
		size = 126
		refs = "0029 @ReallocMem 0044 @LStrClr 004c @IntOver 0053 @NewUnicodeString 006d Move"
	strings:
		$1 = { 53 56 57 89 C3 89 D6 31 FF 85 D2 7E 64 8B 03 85 C0 74 3D 83 78 F8 01 75 37 83 E8 0C 01 D2 70 2B 83 C2 0E 70 26 50 89 E0 E8 ?? ?? ?? ?? 58 83 C0 0C 89 03 89 70 FC 66 C7 04 70 00 00 85 FF 74 3A 57 89 E0 E8 ?? ?? ?? ?? 5F EB 2F E9 ?? ?? ?? ?? 89 D0 E8 ?? ?? ?? ?? 89 C7 8B 03 85 C0 74 12 89 FA 8B 48 FC 39 F1 7C 02 89 F1 D1 E1 E8 ?? ?? ?? ?? 89 D8 E8 ?? ?? ?? ?? 89 3B 5F 5E 5B C3 }
	condition:
		$1
}

rule function_782_0 {
	meta:
		name = "@UStrCat"
		size = 85
		refs = "000a @UStrAsg 002a @UStrSetLength 003c Move 0050 @IntOver"
	strings:
		$1 = { 85 D2 74 50 8B 08 85 C9 0F 84 ?? ?? ?? ?? 53 56 57 89 C3 89 D6 8B 79 FC 8B 56 FC 01 FA F7 C2 00 00 00 C0 75 2A 39 CE 74 1B E8 ?? ?? ?? ?? 89 F0 8B 4E FC 8B 13 D1 E7 01 FA D1 E1 E8 ?? ?? ?? ?? 5F 5E 5B C3 E8 ?? ?? ?? ?? 8B 03 89 F9 EB E4 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_783_0 {
	meta:
		name = "@UStrCat3"
		size = 134
		refs = "0008 @UStrAsg 001e @UStrCat 0038 @NewUnicodeString 0048 Move 0081 @IntOver"
	strings:
		$1 = { 85 D2 74 6E 85 C9 0F 84 ?? ?? ?? ?? 3B 10 74 69 3B 08 74 0E 50 51 E8 ?? ?? ?? ?? 5A 58 E9 ?? ?? ?? ?? 53 56 57 89 D3 89 CE 50 8B 43 FC 03 46 FC A9 00 00 00 C0 75 49 E8 ?? ?? ?? ?? 89 C7 89 FA 89 D8 8B 4B FC D1 E1 E8 ?? ?? ?? ?? 89 F0 8B 4E FC D1 E1 8B 53 FC D1 E2 01 FA E8 ?? ?? ?? ?? 58 89 FA 85 FF 74 03 FF 4F F8 E8 ?? ?? ?? ?? 5F 5E 5B C3 89 CA E9 ?? ?? ?? ?? 89 CA E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_784_0 {
	meta:
		name = "@UStrCatN"
		size = 175
		refs = "004d @UStrSetLength 0062 @NewUnicodeString 007d Move 0097 @UStrAsg 00aa @IntOver"
	strings:
		$1 = { 83 EC 04 53 56 57 52 50 6A 00 89 D3 31 FF 8B 4C 94 1C 85 C9 74 0C 39 08 75 08 89 CF 8B 41 FC 4A EB 02 31 C0 8B 4C 94 1C 85 C9 74 10 03 41 FC A9 00 00 00 C0 75 73 39 CF 75 02 31 FF 4A 75 E5 85 FF 74 1E 89 C2 8B 44 24 04 8B 77 FC E8 ?? ?? ?? ?? 8B 7C 24 04 8B 07 89 04 24 D1 E6 03 37 4B EB 0A E8 ?? ?? ?? ?? 89 04 24 89 C6 8B 44 9C 1C 89 F2 85 C0 74 0C 8B 48 FC D1 E1 01 CE E8 ?? ?? ?? ?? 4B 75 E7 8B 14 24 8B 44 24 04 85 FF 75 0C 85 D2 74 03 FF 4A F8 E8 ?? ?? ?? ?? 83 C4 08 5A 5F 5E 5B 58 58 8D 24 94 FF E0 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_785_0 {
	meta:
		name = "@UStrCmp"
		size = 93
	strings:
		$1 = { 39 D0 74 41 85 D0 74 49 8B 08 3B 0A 75 38 53 8B 58 FC 31 C9 2B 5A FC 53 83 D1 FF 21 D9 2B 48 FC 01 C9 29 C8 29 CA 83 C1 04 79 16 8B 1C 01 3B 1C 11 74 F3 8B 14 11 C1 CB 10 C1 CA 10 39 D3 5B 5B C3 58 01 C0 5B C3 8B 12 C1 C9 10 C1 CA 10 39 D1 C3 85 C0 74 04 85 D2 75 AF 39 D0 C3 C3 }
	condition:
		$1
}

rule function_786_0 {
	meta:
		name = "@UStrEqual"
		size = 53
	strings:
		$1 = { 39 D0 74 30 85 D0 74 22 8B 48 FC 3B 4A FC 75 24 01 C9 01 C8 01 CA F7 D9 53 8B 1C 01 3B 1C 11 75 07 83 C1 04 78 F3 31 C0 5B C3 85 C0 74 04 85 D2 75 D6 39 D0 C3 }
	condition:
		$1
}

rule function_787_0 {
	meta:
		name = "@UStrCopy"
		size = 71
		refs = "003d @UStrFromPWCharLen"
	strings:
		$1 = { 55 8B EC 53 56 8B D8 85 DB 74 05 83 EB 04 8B 1B 83 FA 01 7D 04 33 D2 EB 07 4A 3B DA 7D 02 8B D3 85 C9 7D 04 33 F6 EB 0A 8B F3 2B F2 3B CE 7D 02 8B F1 8B 4D 08 03 D2 03 D0 8B C6 91 E8 ?? ?? ?? ?? 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_788_0 {
	meta:
		name = "UStrSet"
		size = 16
		refs = "000a @UStrClr"
	strings:
		$1 = { 87 10 85 D2 74 09 52 89 E0 E8 ?? ?? ?? ?? 58 C3 }
	condition:
		$1
}

rule function_789_0 {
	meta:
		name = "@UStrDelete"
		size = 98
		refs = "000d InternalUniqueStringU 004f Move 0059 @UStrSetLength"
	strings:
		$1 = { 53 56 57 51 8B F9 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B 06 89 04 24 8B 04 24 85 C0 74 05 83 E8 04 8B 00 83 FB 01 7C 36 3B C3 7C 32 85 FF 7E 2E 4B 8B D0 2B D3 2B D7 8B FA 85 FF 7D 02 33 FF 2B C7 8B 16 8D 04 42 8B CF 03 C9 8B 16 8D 14 5A E8 ?? ?? ?? ?? 8D 14 1F 8B C6 E8 ?? ?? ?? ?? 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_790_0 {
	meta:
		name = "@UStrInsert"
		size = 191
		refs = "0063 @IntOver 006e @UStrSetLength 008b Move"
	strings:
		$1 = { 53 56 57 55 83 C4 F0 8B F1 8B FA 89 04 24 8B 04 24 85 C0 74 05 83 E8 04 8B 00 8B E8 85 ED 0F 8E 93 00 00 00 8B 17 8B C2 89 44 24 0C 8B 44 24 0C 85 C0 74 05 83 E8 04 8B 00 8B D8 83 FE 01 7D 04 33 F6 EB 07 4E 3B DE 7D 02 8B F3 3B 14 24 0F 94 44 24 08 8D 44 1D 00 89 44 24 04 83 7C 24 04 00 7D 05 E8 ?? ?? ?? ?? 8B C7 8B 54 24 04 E8 ?? ?? ?? ?? 3B DE 7E 19 8D 44 35 00 8B 17 8D 14 42 8B 07 8D 04 70 2B DE 8B CB 03 C9 E8 ?? ?? ?? ?? 80 7C 24 08 00 74 10 8B 07 8D 14 70 8B CD 03 C9 E8 ?? ?? ?? ?? EB 11 8B 07 8D 14 70 8B CD 03 C9 8B 04 24 E8 ?? ?? ?? ?? 83 C4 10 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_791_0 {
	meta:
		name = "Pos"
		size = 62
	strings:
		$1 = { 53 56 57 89 C6 89 D7 31 C9 8A 0F 47 57 31 D2 8A 16 46 4A 78 1B 8A 06 46 29 D1 7E 14 F2 AE 75 10 89 CB 56 57 89 D1 F3 A6 5F 5E 74 09 89 D9 EB EC 5A 31 C0 EB 05 5A 89 F8 29 D0 5F 5E 5B C3 }
	condition:
		$1
}

rule function_792_0 {
	meta:
		name = "Pos"
		size = 76
	strings:
		$1 = { 85 C0 74 47 85 D2 74 36 53 56 57 89 C6 89 D7 8B 4F FC 57 8B 56 FC 4A 78 20 66 8B 06 83 C6 02 29 D1 7E 16 F2 66 AF 75 11 89 CB 56 57 89 D1 F3 66 A7 5F 5E 74 0C 89 D9 EB EA 5A 31 C0 EB 0A 31 C0 C3 5A 89 F8 29 D0 D1 E8 5F 5E 5B C3 }
	condition:
		$1
}

rule function_793_0 {
	meta:
		name = "Pos"
		size = 80
	strings:
		$1 = { 85 C0 74 4B 85 D2 74 3A 53 56 57 89 C6 89 D7 8B 4F FC D1 E9 57 8B 56 FC D1 EA 4A 78 20 66 8B 06 83 C6 02 29 D1 7E 16 F2 66 AF 75 11 89 CB 56 57 89 D1 F3 66 A7 5F 5E 74 0C 89 D9 EB EA 5A 31 C0 EB 0A 31 C0 C3 5A 89 F8 29 D0 D1 E8 5F 5E 5B C3 }
	condition:
		$1
}

rule function_794_0 {
	meta:
		name = "Pos"
		size = 323
	strings:
		$1 = { 53 56 83 C4 F0 85 D2 74 4E 85 C0 74 4A 8B 72 FC 8B 58 FC 39 DE 7C 40 85 DB 7E 3C 4B 01 D6 01 DA 89 74 24 08 01 D8 89 54 24 04 F7 DB 0F B6 08 89 1C 24 0F 85 99 00 00 00 83 EE 02 89 74 24 0C 3A 0A 74 41 3A 4A 01 74 4C 83 C2 02 3B 54 24 0C 72 0A 3B 54 24 08 72 E8 31 C0 EB 30 3A 0A 74 25 3A 4A 01 74 30 3A 4A 02 74 18 3A 4A 03 74 23 83 C2 04 3B 54 24 0C 72 E4 3B 54 24 08 72 C2 31 C0 EB 0A 83 C2 02 42 89 D0 2B 44 24 04 83 C4 10 5E 5B C3 83 C2 02 83 C2 02 31 C0 3B 54 24 08 77 06 89 D0 2B 44 24 04 83 C4 10 5E 5B C3 3A 0A 74 75 3A 4A 01 74 43 3A 4A 02 74 68 3A 4A 03 74 36 83 C2 04 3B 54 24 0C 72 E4 3B 54 24 08 72 0B 31 C0 EB 4A 83 EE 02 89 74 24 0C 3A 0A 74 48 3A 4A 01 74 16 83 C2 02 3B 54 24 0C 72 C1 3B 54 24 08 72 E8 31 C0 EB 27 83 C2 02 8B 34 24 0F B7 1C 30 66 3B 5C 32 01 75 DC 83 C6 02 7C F0 83 C2 02 31 C0 3B 54 24 08 77 06 89 D0 2B 44 24 04 83 C4 10 5E 5B C3 83 C2 02 8B 34 24 0F B7 1C 30 66 3B 1C 32 75 AB 83 C6 02 7C F1 42 89 D0 2B 44 24 04 83 C4 10 5E 5B C3 }
	condition:
		$1
}

rule function_795_0 {
	meta:
		name = "StringOfChar"
		size = 39
		refs = "0010 @UStrFromPWCharLen"
	strings:
		$1 = { 53 56 57 8B F9 8B DA 8B F0 8B C7 8B CB 33 D2 E8 ?? ?? ?? ?? 8B 07 85 DB 7E 09 4B 66 89 34 58 85 DB 7F F7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_796_0 {
	meta:
		name = "StringOfChar"
		size = 48
		refs = "000c @LStrClr 0018 DefaultSystemCodePage 001d @NewAnsiString 0028 @FillChar"
	strings:
		$1 = { 53 56 57 89 C3 89 D6 89 CF 89 C8 E8 ?? ?? ?? ?? 85 F6 7E 18 89 F0 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 07 89 F2 88 D9 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_797_0 {
	meta:
		name = "SetAnsiString"
		size = 19
		refs = "000a @LStrFromPWCharLen"
	strings:
		$1 = { 55 8B EC 53 0F B7 5D 08 53 E8 ?? ?? ?? ?? 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_798_0 {
	meta:
		name = "SetCodePage"
		size = 372
		refs = "0019 SetCodePage 003f DefaultSystemCodePage 009d @UStrFromLStr 00a9 @UStrLAsg 00c2 @UStrToPWChar 00cd CharFromWChar 00da @LStrSetLength 011e @LStrToPChar 012f InternalUniqueStringA 0161 @UStrClr 0167 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 33 DB 89 5D FC 88 4D FB 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 3B 89 7D F0 83 7D F0 00 74 0E 89 7D F0 8B 45 F0 83 E8 0C 0F B7 00 EB 07 0F B7 05 ?? ?? ?? ?? 66 3B F0 75 04 B0 01 EB 16 8B 03 89 45 F0 8B 45 F0 85 C0 74 05 83 E8 04 8B 00 85 C0 0F 94 C0 84 C0 0F 85 E6 00 00 00 80 7D FB 00 0F 84 B8 00 00 00 8B 3B 89 7D F0 83 7D F0 00 74 0E 89 7D F0 8B 45 F0 83 E8 0A 0F B7 00 EB 04 66 B8 01 00 66 83 F8 01 75 0C 8D 45 FC 8B 13 E8 ?? ?? ?? ?? EB 0A 8D 45 FC 8B 13 E8 ?? ?? ?? ?? 8B 7D FC 85 FF 74 05 83 EF 04 8B 3F 57 0F B7 C6 50 8B 45 FC E8 ?? ?? ?? ?? 8B C8 33 D2 33 C0 E8 ?? ?? ?? ?? 8B F8 8B C3 33 C9 8B D7 E8 ?? ?? ?? ?? 85 FF 7E 51 8B 03 89 45 F0 8B 7D F0 85 FF 74 05 83 EF 04 8B 3F 8B 45 FC 89 45 F4 83 7D F4 00 74 0B 8B 45 F4 83 E8 04 8B 00 89 45 F4 8B 45 F4 50 0F B7 C6 50 8B 45 FC E8 ?? ?? ?? ?? 50 8B 03 E8 ?? ?? ?? ?? 8B D7 59 E8 ?? ?? ?? ?? EB 07 8B C3 E8 ?? ?? ?? ?? 8B 03 89 45 F0 8B 45 F0 85 C0 74 05 83 E8 04 8B 00 85 C0 7E 08 8B 03 83 E8 0C 66 89 30 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_799_0 {
	meta:
		name = "UnicodeStringToUCS4String"
		size = 248
		refs = "002a UCS4String 002f @DynArraySetLength 00b9 @UStrLen"
	strings:
		$1 = { 53 56 57 55 83 C4 F4 89 14 24 8B F0 33 C0 89 44 24 04 8B DE 85 DB 74 05 83 EB 04 8B 1B 43 53 8B 44 24 04 B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 33 FF EB 7C 0F B7 2C 7E 66 81 FD 00 D8 72 2B 66 81 FD FF DF 77 24 89 74 24 08 83 7C 24 08 00 74 0D 8B 44 24 08 83 E8 04 8B 00 89 44 24 08 8D 47 01 3B 44 24 08 0F 9C C3 EB 02 33 DB 84 DB 74 2C 0F B7 C5 25 FF 03 00 00 C1 E0 0A 0F B7 54 7E 02 81 E2 FF 03 00 00 0B C2 05 00 00 01 00 8B 14 24 8B 12 8B 4C 24 04 89 04 8A 47 EB 0F 8B 04 24 8B 00 8B 54 24 04 0F B7 CD 89 0C 90 FF 44 24 04 47 8B C6 E8 ?? ?? ?? ?? 3B F8 0F 8C 75 FF FF FF 8B 04 24 8B 00 8B 54 24 04 33 C9 89 0C 90 8B 44 24 04 40 50 8B 44 24 04 B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 83 C4 0C 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_800_0 {
	meta:
		name = "UCS4StringToUnicodeString"
		size = 154
		refs = "000b @DynArrayLength 0017 @UStrSetLength 002e @UniqueStringU"
	strings:
		$1 = { 53 56 57 55 8B EA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D0 03 D2 4A 8B C5 E8 ?? ?? ?? ?? 33 FF 33 DB EB 5F 81 3C 9E 00 00 01 00 72 44 47 8B C5 E8 ?? ?? ?? ?? 8B 14 9E 81 EA 00 00 01 00 C1 EA 0A 66 81 E2 FF 03 66 81 CA 00 D8 66 89 54 78 FE 47 8B C5 E8 ?? ?? ?? ?? 0F B7 14 9E 66 83 EA 00 66 81 E2 FF 03 66 81 CA 00 DC 66 89 54 78 FE EB 11 47 8B C5 E8 ?? ?? ?? ?? 0F B7 14 9E 66 89 54 78 FE 43 8B C6 E8 ?? ?? ?? ?? 48 3B D8 7C 95 8B C5 8B D7 E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_801_0 {
	meta:
		name = "FlushBuffer"
		size = 132
		refs = "000c @DynArrayLength 0025 UCS4String 002a @DynArraySetLength 005e Move"
	strings:
		$1 = { 55 8B EC 53 56 8B F2 8B D8 8B 03 E8 ?? ?? ?? ?? 8B 55 08 03 82 FC FB FF FF 03 C6 50 8B C3 B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 8B 03 E8 ?? ?? ?? ?? 8B 55 08 2B 82 FC FB FF FF 2B C6 8B 13 8D 14 82 8B 45 08 8B 88 FC FB FF FF 03 C9 03 C9 8B 45 08 05 00 FC FF FF E8 ?? ?? ?? ?? 85 F6 7E 0F 8B 03 E8 ?? ?? ?? ?? 8B 13 33 C9 89 4C 82 FC 8B 45 08 33 D2 89 90 FC FB FF FF 5E 5B 5D C3 }
	condition:
		$1
}

rule function_802_0 {
	meta:
		name = "WideCharToUCS4String"
		size = 198
		refs = "009a FlushBuffer"
	strings:
		$1 = { 55 8B EC 81 C4 F8 FB FF FF 53 56 57 89 8D F8 FB FF FF 8B FA 8B D8 33 C0 89 85 FC FB FF FF EB 7F 0F B7 33 66 81 FE 00 D8 72 40 66 81 FE FF DF 77 39 85 FF 7E 35 66 83 7B 02 00 74 2E 0F B7 C6 25 FF 03 00 00 C1 E0 0A 0F B7 53 02 81 E2 FF 03 00 00 0B C2 05 00 00 01 00 8B 95 FC FB FF FF 89 84 95 00 FC FF FF 83 C3 02 EB 10 0F B7 C6 8B 95 FC FB FF FF 89 84 95 00 FC FF FF FF 85 FC FB FF FF 83 C3 02 4F 81 BD FC FB FF FF 00 01 00 00 7C 0F 55 8B 85 F8 FB FF FF 33 D2 E8 ?? ?? ?? ?? 59 66 83 3B 00 74 08 85 FF 0F 8F 73 FF FF FF 55 8B 85 F8 FB FF FF BA 01 00 00 00 E8 ?? ?? ?? ?? 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_803_0 {
	meta:
		name = "@InitializeRecord"
		size = 51
		refs = "0025 @InitializeArray"
	strings:
		$1 = { 31 C9 53 8A 4A 01 56 57 89 C3 8D 74 11 0A 8B 7C 11 06 85 FF 74 19 8B 16 8B 46 04 01 D8 8B 12 B9 01 00 00 00 E8 ?? ?? ?? ?? 83 C6 08 4F 7F E7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_805_0 {
	meta:
		name = "@InitializeArray"
		size = 151
		refs = "0040 Error 0075 @InitializeArray 008b @InitializeRecord"
	strings:
		$1 = { 85 C9 0F 84 8E 00 00 00 53 56 57 89 C3 89 D6 89 CF 31 D2 8A 06 8A 56 01 31 C9 3C 0A 74 26 3C 0B 74 22 3C 0C 74 28 3C 0D 74 37 3C 0E 74 51 3C 0F 74 12 3C 11 74 0E 3C 12 74 0A B0 02 5F 5E 5B E9 ?? ?? ?? ?? 89 0B 83 C3 04 4F 7F F8 EB 45 89 0B 89 4B 04 89 4B 08 89 4B 0C 83 C3 10 4F 7F EF EB 32 55 89 D5 8B 54 2E 0A 89 D8 03 5C 2E 02 8B 4C 2E 06 8B 12 E8 ?? ?? ?? ?? 4F 7F E8 5D EB 14 55 89 D5 89 D8 03 5C 2E 02 89 F2 E8 ?? ?? ?? ?? 4F 7F F0 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_806_0 {
	meta:
		name = "@Initialize"
		size = 11
		refs = "0006 @InitializeArray"
	strings:
		$1 = { B9 01 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_814_0 {
	meta:
		name = "@AddRef"
		size = 11
		refs = "0006 @AddRefArray"
	strings:
		$1 = { B9 01 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_810_0 {
	meta:
		name = "@Finalize"
		size = 11
		refs = "0006 @FinalizeArray"
	strings:
		$1 = { B9 01 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_807_0 {
	meta:
		name = "@FinalizeRecord"
		size = 53
		refs = "0025 @FinalizeArray"
	strings:
		$1 = { 31 C9 53 8A 4A 01 56 57 89 C3 8D 74 11 0A 8B 7C 11 06 85 FF 74 19 8B 16 8B 46 04 01 D8 8B 12 B9 01 00 00 00 E8 ?? ?? ?? ?? 83 C6 08 4F 7F E7 89 D8 5F 5E 5B C3 }
	condition:
		$1
}

rule function_808_0 {
	meta:
		name = "@VarClr"
		size = 24
		refs = "0002 VarClearProc 0013 Error"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 07 FF 15 ?? ?? ?? ?? C3 B0 10 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_812_0 {
	meta:
		name = "@VarAddRef"
		size = 24
		refs = "0002 VarAddRefProc 0013 Error"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 07 FF 15 ?? ?? ?? ?? C3 B0 10 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_815_0 {
	meta:
		name = "@VarCopy"
		size = 24
		refs = "0002 VarCopyProc 0013 Error"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 07 FF 15 ?? ?? ?? ?? C3 B0 10 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_809_0 {
	meta:
		name = "@FinalizeArray"
		size = 271
		refs = "0053 @LStrClr 005f @LStrArrayClr 0070 @WStrClr 007c @WStrArrayClr 008d @UStrClr 0096 @UStrArrayClr 00a2 @VarClr 00bf @FinalizeArray 00d5 @FinalizeRecord 00e5 @IntfClear 00f6 @DynArrayClear 0106 Error"
	strings:
		$1 = { 83 F9 00 0F 84 05 01 00 00 50 53 56 57 89 C3 89 D6 89 CF 31 D2 8A 06 8A 56 01 3C 0A 74 2D 3C 12 74 63 3C 0B 74 42 3C 0C 74 72 3C 0D 74 7D 3C 0E 0F 84 93 00 00 00 3C 0F 0F 84 A1 00 00 00 3C 11 0F 84 A8 00 00 00 E9 B4 00 00 00 83 F9 01 89 D8 7F 0A E8 ?? ?? ?? ?? E9 AE 00 00 00 89 CA E8 ?? ?? ?? ?? E9 A2 00 00 00 83 F9 01 89 D8 7F 0A E8 ?? ?? ?? ?? E9 91 00 00 00 89 CA E8 ?? ?? ?? ?? E9 85 00 00 00 83 F9 01 89 D8 7F 07 E8 ?? ?? ?? ?? EB 77 89 CA E8 ?? ?? ?? ?? EB 6E 89 D8 83 C3 10 E8 ?? ?? ?? ?? 4F 7F F3 EB 5F 55 89 D5 8B 54 2E 0A 89 D8 03 5C 2E 02 8B 4C 2E 06 8B 12 E8 ?? ?? ?? ?? 4F 7F E8 5D EB 41 55 89 D5 89 D8 03 5C 2E 02 89 F2 E8 ?? ?? ?? ?? 4F 7F F0 5D EB 2B 89 D8 83 C3 04 E8 ?? ?? ?? ?? 4F 7F F3 EB 1C 89 D8 89 F2 83 C3 04 E8 ?? ?? ?? ?? 4F 7F F1 EB 0B 5F 5E 5B 58 B0 02 E9 ?? ?? ?? ?? 5F 5E 5B 58 C3 }
	condition:
		$1
}

rule function_811_0 {
	meta:
		name = "@AddRefRecord"
		size = 47
		refs = "0021 @AddRefArray"
	strings:
		$1 = { 31 C9 53 8A 4A 01 56 57 89 C3 8D 74 11 0A 8B 7C 11 06 8B 16 8B 46 04 01 D8 8B 12 B9 01 00 00 00 E8 ?? ?? ?? ?? 83 C6 08 4F 7F E7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_813_0 {
	meta:
		name = "@AddRefArray"
		size = 195
		refs = "003e Error 0048 @LStrAddRef 0057 @WStrAddRef 0066 @VarAddRef 0083 @AddRefArray 0099 @AddRefRecord 00a9 @IntfAddRef 00b8 @DynArrayAddRef"
	strings:
		$1 = { 53 56 57 85 C9 0F 84 B4 00 00 00 89 C3 89 D6 89 CF 31 D2 8A 06 8A 56 01 3C 0A 74 26 3C 0B 74 31 3C 12 74 1E 3C 0C 74 38 3C 0D 74 43 3C 0E 74 5D 3C 0F 74 6F 3C 11 74 7A B0 02 5F 5E 5B E9 ?? ?? ?? ?? 8B 03 83 C3 04 E8 ?? ?? ?? ?? 4F 7F F3 EB 6E 89 D8 83 C3 04 E8 ?? ?? ?? ?? 4F 7F F3 EB 5F 89 D8 83 C3 10 E8 ?? ?? ?? ?? 4F 7F F3 EB 50 55 89 D5 8B 54 2E 0A 89 D8 03 5C 2E 02 8B 4C 2E 06 8B 12 E8 ?? ?? ?? ?? 4F 7F E8 5D EB 32 55 89 D5 89 D8 03 5C 2E 02 89 F2 E8 ?? ?? ?? ?? 4F 7F F0 5D EB 1C 8B 03 83 C3 04 E8 ?? ?? ?? ?? 4F 7F F3 EB 0D 8B 03 83 C3 04 E8 ?? ?? ?? ?? 4F 7F F3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_816_0 {
	meta:
		name = "@CopyRecord"
		size = 320
		refs = "0030 Move 0079 Error 0083 @LStrAsg 0097 @UStrAsg 00a8 @WStrAsg 00b9 @VarCopy 00dd @CopyArray 00f6 @CopyRecord 0103 @IntfCopy 0116 @DynArrayAsg"
	strings:
		$1 = { 53 56 57 55 89 C3 89 D6 31 C0 8A 41 01 8D 7C 08 0A 8B 6F FC 31 C0 8B 4F F8 85 ED 0F 84 0C 01 00 00 51 8B 4F 04 29 C1 7E 0B 89 C2 01 F0 01 DA E8 ?? ?? ?? ?? 8B 47 04 8B 17 8B 12 8A 0A 80 F9 0A 74 3B 80 F9 0B 74 5B 80 F9 12 74 45 80 F9 0C 74 62 80 F9 0D 74 6E 80 F9 0E 0F 84 85 00 00 00 80 F9 0F 0F 84 95 00 00 00 80 F9 11 0F 84 9D 00 00 00 B0 02 59 5D 5F 5E 5B E9 ?? ?? ?? ?? 8B 14 30 01 D8 E8 ?? ?? ?? ?? B8 04 00 00 00 E9 8E 00 00 00 8B 14 30 01 D8 E8 ?? ?? ?? ?? B8 04 00 00 00 EB 7D 8B 14 30 01 D8 E8 ?? ?? ?? ?? B8 04 00 00 00 EB 6C 8D 14 30 01 D8 E8 ?? ?? ?? ?? B8 10 00 00 00 EB 5B 31 C9 8A 4A 01 FF 74 11 02 FF 74 11 06 8B 4C 11 0A 8B 09 8D 14 30 01 D8 E8 ?? ?? ?? ?? 58 EB 3B 31 C9 8A 4A 01 8B 4C 11 02 51 89 D1 8D 14 30 01 D8 E8 ?? ?? ?? ?? 58 EB 22 8B 14 30 01 D8 E8 ?? ?? ?? ?? B8 04 00 00 00 EB 11 89 D1 8B 14 30 01 D8 E8 ?? ?? ?? ?? B8 04 00 00 00 03 47 04 83 C7 08 4D 0F 85 F6 FE FF FF 59 29 C1 7E 0A 8D 14 18 01 F0 E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_817_0 {
	meta:
		name = "@CopyObject"
		size = 21
		refs = "000a @CopyRecord"
	strings:
		$1 = { 01 C1 FF 31 51 8B 4C 24 0C E8 ?? ?? ?? ?? 59 8F 01 C2 04 00 C3 }
	condition:
		$1
}

rule function_818_0 {
	meta:
		name = "@CopyArray"
		size = 277
		refs = "004b Error 0054 @LStrAsg 006b @WStrAsg 0082 @UStrAsg 0096 @VarCopy 00bb @CopyArray 00cf @CopyRecord 00ea @IntfCopy 0100 @DynArrayAsg"
	strings:
		$1 = { 53 56 57 55 89 C3 89 D6 89 CF 8B 6C 24 14 8A 0F 80 F9 0A 74 3A 80 F9 0B 74 4C 80 F9 12 74 5E 80 F9 0C 74 6D 80 F9 0D 74 7C 80 F9 0E 0F 84 96 00 00 00 80 F9 0F 0F 84 AA 00 00 00 80 F9 11 0F 84 B5 00 00 00 B0 02 5D 5F 5E 5B E9 ?? ?? ?? ?? 89 D8 8B 16 E8 ?? ?? ?? ?? 83 C3 04 83 C6 04 4D 75 EE E9 A7 00 00 00 89 D8 8B 16 E8 ?? ?? ?? ?? 83 C3 04 83 C6 04 4D 75 EE E9 90 00 00 00 89 D8 8B 16 E8 ?? ?? ?? ?? 83 C3 04 83 C6 04 4D 75 EE EB 7C 89 D8 89 F2 E8 ?? ?? ?? ?? 83 C3 10 83 C6 10 4D 75 EE EB 68 31 C9 8A 4F 01 8D 7C 39 02 89 D8 89 F2 8B 4F 08 8B 09 FF 77 04 E8 ?? ?? ?? ?? 03 1F 03 37 4D 75 E8 EB 45 89 D8 89 F2 89 F9 E8 ?? ?? ?? ?? 31 C0 8A 47 01 03 5C 38 02 03 74 38 02 4D 75 E5 EB 28 89 D8 8B 16 E8 ?? ?? ?? ?? 83 C3 04 83 C6 04 4D 75 EE EB 14 89 D8 8B 16 89 F9 E8 ?? ?? ?? ?? 83 C3 04 83 C6 04 4D 75 EC 5D 5F 5E 5B C2 04 00 C3 }
	condition:
		$1
}

rule function_819_0 {
	meta:
		name = "@New"
		size = 19
		refs = "0002 @GetMem 000d @Initialize"
	strings:
		$1 = { 52 E8 ?? ?? ?? ?? 5A 85 C0 74 07 50 E8 ?? ?? ?? ?? 58 C3 }
	condition:
		$1
}

rule function_820_0 {
	meta:
		name = "@Dispose"
		size = 13
		refs = "0002 @Finalize 0008 @FreeMem"
	strings:
		$1 = { 50 E8 ?? ?? ?? ?? 58 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_824_0 {
	meta:
		name = "WideCharLenToStrVar"
		size = 9
		refs = "0004 @UStrFromPWCharLen"
	strings:
		$1 = { 91 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_825_0 {
	meta:
		name = "WideCharLenToStrVar"
		size = 19
		refs = "0004 DefaultSystemCodePage 000d @LStrFromPWCharLen"
	strings:
		$1 = { 53 0F B7 1D ?? ?? ?? ?? 53 91 87 CA E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_826_0 {
	meta:
		name = "StringToWideChar"
		size = 108
		refs = "002c StringToWideChar 0040 @UStrToPWChar 004b Move"
	strings:
		$1 = { 53 56 57 51 89 0C 24 8B FA 8B F0 8B C6 85 C0 74 05 83 E8 04 8B 00 40 3B 04 24 7E 16 83 3C 24 00 7E 09 66 C7 07 00 00 8B C7 EB 37 B8 ?? ?? ?? ?? EB 30 8B DE 85 DB 74 05 83 EB 04 8B 1B 8B C6 E8 ?? ?? ?? ?? 8B CB 03 C9 8B D7 E8 ?? ?? ?? ?? 8B C6 85 C0 74 05 83 E8 04 8B 00 66 C7 04 47 00 00 8B C7 5A 5F 5E 5B C3 00 00 00 00 00 }
	condition:
		$1
}

rule function_828_0 {
	meta:
		name = "OleStrToStrVar"
		size = 27
		refs = "0015 WideCharLenToStrVar"
	strings:
		$1 = { 51 89 04 24 8B 0C 24 85 C9 74 07 83 E9 04 8B 09 D1 E9 87 D1 E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule function_830_0 {
	meta:
		name = "StringToOleStr"
		size = 32
		refs = "0017 @WStrFromPCharLen"
	strings:
		$1 = { 51 33 D2 89 14 24 8B D0 85 D2 74 05 83 EA 04 8B 12 8B CC 91 87 D1 E8 ?? ?? ?? ?? 8B 04 24 5A C3 }
	condition:
		$1
}

rule function_831_0 {
	meta:
		name = "StringToOleStr"
		size = 32
		refs = "0017 @WStrFromPWCharLen"
	strings:
		$1 = { 51 33 D2 89 14 24 8B D0 85 D2 74 05 83 EA 04 8B 12 8B CC 91 87 D1 E8 ?? ?? ?? ?? 8B 04 24 5A C3 }
	condition:
		$1
}

rule function_832_0 {
	meta:
		name = "GetVariantManager"
		size = 13
		refs = "0008 @FillChar"
	strings:
		$1 = { 33 C9 BA B0 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_836_0 {
	meta:
		name = "@DispCallByIDError"
		size = 8
		refs = "0003 Error"
	strings:
		$1 = { B0 11 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_838_0 {
	meta:
		name = "@_llmul"
		size = 36
		altNames = "@_llmulo"
	strings:
		$1 = { 52 50 8B 44 24 10 F7 24 24 89 C1 8B 44 24 04 F7 64 24 0C 01 C1 8B 04 24 F7 64 24 0C 01 CA 59 59 C2 08 00 C3 }
	condition:
		$1
}

rule function_840_0 {
	meta:
		name = "@_lldiv"
		size = 146
	strings:
		$1 = { 53 56 57 8B 5C 24 10 8B 4C 24 14 89 D6 89 CF C1 FE 1F 31 F0 31 F2 29 F0 19 F2 C1 FF 1F 31 FE 31 FB 31 F9 29 FB 19 F9 75 13 39 DA 72 09 89 C1 89 D0 31 D2 F7 F3 91 F7 F3 89 CA EB 47 83 EC 0C 89 04 24 89 5C 24 04 89 54 24 08 89 CF D1 EA D1 D8 D1 CF D1 DB 0F BD C9 0F AD FB 0F AD D0 D3 EA D1 C7 F7 F3 8B 1C 24 89 C1 0F AF F8 F7 64 24 04 01 FA 29 C3 89 C8 8B 4C 24 08 19 D1 83 D8 00 31 D2 83 C4 0C 31 F0 31 F2 29 F0 19 F2 5F 5E 5B C2 08 00 C3 }
	condition:
		$1
}

rule function_841_0 {
	meta:
		name = "@_lldivo"
		size = 56
		refs = "002e @_lldiv"
	strings:
		$1 = { 56 8B 74 24 0C 23 74 24 08 81 FE FF FF FF FF 75 13 89 C6 09 D6 81 FE 00 00 00 80 75 07 89 F0 5E 48 C2 08 00 5E FF 74 24 08 FF 74 24 08 E8 ?? ?? ?? ?? 21 C0 C2 08 00 C3 }
	condition:
		$1
}

rule function_844_0 {
	meta:
		name = "@_llmodo"
		size = 56
		refs = "002e @_llmod"
	strings:
		$1 = { 56 8B 74 24 0C 23 74 24 08 81 FE FF FF FF FF 75 13 89 C6 09 D6 81 FE 00 00 00 80 75 07 89 F0 5E 48 C2 08 00 5E FF 74 24 08 FF 74 24 08 E8 ?? ?? ?? ?? 21 C0 C2 08 00 C3 }
	condition:
		$1
}

rule function_842_0 {
	meta:
		name = "@_lludiv"
		size = 74
	strings:
		$1 = { 55 53 56 57 8B 5C 24 14 8B 4C 24 18 09 C9 75 08 09 D2 74 2F 09 DB 74 2B 89 CD B9 40 00 00 00 31 FF 31 F6 D1 E0 D1 D2 D1 D6 D1 D7 39 EF 72 0B 77 04 39 DE 72 05 29 DE 19 EF 40 E2 E7 5F 5E 5B 5D C2 08 00 F7 F3 31 D2 EB F3 C3 }
	condition:
		$1
}

rule function_843_0 {
	meta:
		name = "@_llmod"
		size = 123
	strings:
		$1 = { 55 53 56 57 31 FF 8B 5C 24 14 8B 4C 24 18 09 C9 75 08 09 D2 74 5D 09 DB 74 59 09 D2 79 0A F7 DA F7 D8 83 DA 00 83 CF 01 09 C9 79 07 F7 D9 F7 DB 83 D9 00 89 CD B9 40 00 00 00 57 31 FF 31 F6 D1 E0 D1 D2 D1 D6 D1 D7 39 EF 72 0B 77 04 39 DE 72 05 29 DE 19 EF 40 E2 E7 89 F0 89 FA 5B F7 C3 01 00 00 00 74 07 F7 DA F7 D8 83 DA 00 5F 5E 5B 5D C2 08 00 F7 F3 92 31 D2 EB F2 C3 }
	condition:
		$1
}

rule function_845_0 {
	meta:
		name = "@_llumod"
		size = 79
	strings:
		$1 = { 55 53 56 57 8B 5C 24 14 8B 4C 24 18 09 C9 75 08 09 D2 74 33 09 DB 74 2F 89 CD B9 40 00 00 00 31 FF 31 F6 D1 E0 D1 D2 D1 D6 D1 D7 39 EF 72 0B 77 04 39 DE 72 05 29 DE 19 EF 40 E2 E7 89 F0 89 FA 5F 5E 5B 5D C2 08 00 F7 F3 92 31 D2 EB F2 C3 }
	condition:
		$1
}

rule function_846_0 {
	meta:
		name = "@_llshl"
		size = 22
	strings:
		$1 = { 80 E1 3F 80 F9 20 7C 07 89 C2 D3 E2 31 C0 C3 0F A5 C2 D3 E0 C3 C3 }
	condition:
		$1
}

rule function_847_0 {
	meta:
		name = "@_llshr"
		size = 21
	strings:
		$1 = { 80 E1 3F 80 F9 20 7C 06 89 D0 99 D3 F8 C3 0F AD D0 D3 FA C3 C3 }
	condition:
		$1
}

rule function_848_0 {
	meta:
		name = "@_llushr"
		size = 22
	strings:
		$1 = { 80 E1 3F 80 F9 20 7C 07 89 D0 31 D2 D3 E8 C3 0F AD D0 D3 EA C3 C3 }
	condition:
		$1
}

rule function_849_0 {
	meta:
		name = "@StrUInt64Digits"
		size = 164
		refs = "001d @_llumod 0038 @_lludiv 0097 @SetLength"
	strings:
		$1 = { 55 8B EC 83 C4 BC 53 56 57 8B F1 88 55 FF 8B F8 33 DB 6A 00 6A 0A 8B 45 08 8B 55 0C E8 ?? ?? ?? ?? 83 C0 30 83 D2 00 66 89 44 5D BE 43 6A 00 6A 0A 8B 45 08 8B 55 0C E8 ?? ?? ?? ?? 89 45 08 89 55 0C 83 7D 0C 00 75 CA 83 7D 08 00 75 C4 80 7D FF 00 74 08 66 C7 44 5D BE 2D 00 43 81 FF FF 00 00 00 7E 05 BF FF 00 00 00 B8 01 00 00 00 8B D7 2B D3 3B D0 7C 09 C6 04 06 20 40 3B D0 7D F7 85 DB 7E 0E 4B 0F B6 54 5D BE 88 14 06 40 85 DB 7F F2 8B D0 4A 8B C6 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_850_0 {
	meta:
		name = "@StrInt64"
		size = 61
		refs = "0033 @StrUInt64Digits"
	strings:
		$1 = { 55 8B EC 53 56 8B F2 8B D8 8B 45 08 8B 55 0C 85 D2 7D 07 F7 D8 83 D2 00 F7 DA 52 50 83 7D 0C 00 75 09 83 7D 08 00 0F 92 C2 EB 03 0F 9C C2 8B CE 8B C3 E8 ?? ?? ?? ?? 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_851_0 {
	meta:
		name = "@Str0Int64"
		size = 26
		refs = "0011 @StrInt64"
	strings:
		$1 = { 55 8B EC 53 8B D8 FF 75 0C FF 75 08 8B D3 33 C0 E8 ?? ?? ?? ?? 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_853_0 {
	meta:
		name = "@Str0UInt64"
		size = 26
		refs = "0011 @StrUInt64"
	strings:
		$1 = { 55 8B EC 53 8B D8 FF 75 0C FF 75 08 8B D3 33 C0 E8 ?? ?? ?? ?? 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_852_0 {
	meta:
		name = "@StrUInt64"
		size = 32
		refs = "0016 @StrUInt64Digits"
	strings:
		$1 = { 55 8B EC 53 56 8B F2 8B D8 FF 75 0C FF 75 08 8B CE 33 D2 8B C3 E8 ?? ?? ?? ?? 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_854_0 {
	meta:
		name = "@WriteInt64"
		size = 40
		refs = "0014 @StrInt64 001d @WriteString"
	strings:
		$1 = { 83 EC 20 50 52 FF 74 24 30 FF 74 24 30 31 C0 8D 54 24 10 E8 ?? ?? ?? ?? 59 58 89 E2 E8 ?? ?? ?? ?? 83 C4 20 C2 08 00 C3 }
	condition:
		$1
}

rule function_856_0 {
	meta:
		name = "@WriteUInt64"
		size = 40
		refs = "0014 @StrUInt64 001d @WriteString"
	strings:
		$1 = { 83 EC 20 50 52 FF 74 24 30 FF 74 24 30 31 C0 8D 54 24 10 E8 ?? ?? ?? ?? 59 58 89 E2 E8 ?? ?? ?? ?? 83 C4 20 C2 08 00 C3 }
	condition:
		$1
}

rule function_855_0 {
	meta:
		name = "@Write0Int64"
		size = 8
		refs = "0003 @WriteInt64"
	strings:
		$1 = { 31 D2 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_857_0 {
	meta:
		name = "@Write0UInt64"
		size = 8
		refs = "0003 @WriteUInt64"
	strings:
		$1 = { 31 D2 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_858_0 {
	meta:
		name = "@ValInt64L"
		size = 98
		refs = "0015 @ValInt64L 0025 @UStrFromLStr 002f @ValInt64 004a @UStrClr 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 C9 89 4D F4 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F4 8B D3 E8 ?? ?? ?? ?? 8B 45 F4 8B D6 E8 ?? ?? ?? ?? 89 45 F8 89 55 FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 F8 8B 55 FC 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_859_0 {
	meta:
		name = "@ReadInt64"
		size = 107
		refs = "0012 @SeekEof 0023 @ReadChar 0042 @ValInt64L 0051 SetInOutRes"
	strings:
		$1 = { 53 56 57 83 EC 24 6A 00 6A FF 68 00 00 01 00 89 C6 E8 ?? ?? ?? ?? FE C8 74 4C 8D 7C 24 0C B3 20 89 F0 E8 ?? ?? ?? ?? 3C 20 76 31 AA FE CB 75 F0 C6 07 00 8D 44 24 0C 89 F9 29 C1 89 48 FC 52 89 E2 E8 ?? ?? ?? ?? 59 85 C9 74 0A B8 6A 00 00 00 E8 ?? ?? ?? ?? 83 C4 30 5F 5E 5B C3 80 FC 1A 74 CF FF 4E 0C EB CA 31 C0 EB EB C3 }
	condition:
		$1
}

rule function_860_0 {
	meta:
		name = "@ValInt64"
		size = 629
		refs = "01e3 @_llmul"
	strings:
		$1 = { 53 56 57 55 83 C4 EC 89 14 24 8B F0 BD 01 00 00 00 33 FF C7 44 24 08 00 00 00 00 C7 44 24 0C 00 00 00 00 85 F6 75 0B 8B 04 24 89 28 E9 34 02 00 00 45 66 83 7C 6E FE 20 74 F7 C6 44 24 10 00 0F B7 44 6E FE 66 83 F8 2D 75 08 C6 44 24 10 01 45 EB 07 66 83 F8 2B 75 01 45 B3 01 0F B7 44 6E FE 66 83 F8 24 75 04 B2 01 EB 1B 8B D0 8B C8 83 C1 9F 66 83 E9 1A 73 07 8B D0 66 81 E2 DF FF 66 83 FA 58 0F 94 C2 84 D2 74 04 B2 01 EB 43 66 83 F8 30 75 12 8B D6 85 D2 74 05 83 EA 04 8B 12 3B D5 0F 9F C2 EB 02 33 D2 84 D2 74 23 0F B7 14 6E 0F B7 0C 6E 83 C1 9F 66 83 E9 1A 73 09 0F B7 14 6E 66 81 E2 DF FF 66 83 FA 58 0F 94 C2 EB 02 33 D2 84 D2 0F 84 BE 00 00 00 66 83 F8 30 75 01 45 45 0F B7 4C 6E FE 8B C1 83 C0 D0 66 83 E8 0A 72 14 83 C0 F9 66 83 E8 06 72 13 83 C0 E6 66 83 E8 06 72 12 EB 6B 0F B7 F9 83 EF 30 EB 0E 0F B7 F9 83 EF 37 EB 06 0F B7 F9 83 EF 57 83 7C 24 0C 00 75 09 83 7C 24 08 00 72 47 EB 02 7C 43 81 7C 24 0C FF FF FF 0F 75 09 83 7C 24 08 FF 76 04 EB 30 7F 2E 8B C7 99 52 50 8B 44 24 10 8B 54 24 14 0F A4 C2 04 C1 E0 04 03 04 24 13 54 24 04 83 C4 08 89 44 24 08 89 54 24 0C 45 33 DB E9 71 FF FF FF 80 7C 24 10 00 0F 84 D0 00 00 00 8B 44 24 08 8B 54 24 0C F7 D8 83 D2 00 F7 DA 89 44 24 08 89 54 24 0C E9 B4 00 00 00 0F B7 44 6E FE 83 C0 D0 66 83 E8 0A 73 5F 0F B7 7C 6E FE 83 EF 30 83 7C 24 0C 00 75 09 83 7C 24 08 00 72 49 EB 02 7C 45 81 7C 24 0C CC CC CC 0C 75 0C 81 7C 24 08 CC CC CC CC 76 04 EB 2F 7F 2D 6A 00 6A 0A 8B 44 24 10 8B 54 24 14 E8 ?? ?? ?? ?? 52 50 8B C7 99 03 04 24 13 54 24 04 83 C4 08 89 44 24 08 89 54 24 0C 45 33 DB EB 93 80 7C 24 10 00 74 17 8B 44 24 08 8B 54 24 0C F7 D8 83 D2 00 F7 DA 89 44 24 08 89 54 24 0C 83 7C 24 0C 00 75 05 83 7C 24 08 00 74 1B 83 7C 24 0C 00 75 0A 83 7C 24 08 00 0F 92 C0 EB 03 0F 9C C0 3A 44 24 10 74 01 4D 66 83 7C 6E FE 00 0F 95 C0 0A D8 74 07 8B 04 24 89 28 EB 07 8B 04 24 33 D2 89 10 8B 44 24 08 8B 54 24 0C 83 C4 14 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_861_0 {
	meta:
		name = "@DynArrayLength"
		size = 8
		altNames = "DynArraySize"
	strings:
		$1 = { 85 C0 74 03 8B 40 FC C3 }
	condition:
		$1
}

rule function_863_0 {
	meta:
		name = "CopyArray"
		size = 15
		refs = "0007 @CopyArray"
	strings:
		$1 = { 55 8B EC FF 75 08 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule function_866_0 {
	meta:
		name = "DynArraySetLength"
		size = 406
		refs = "0026 Error 0030 DynArrayClear 00bb FinalizeArray 00c6 @ReallocMem 00d5 @GetMem 00fc @FillChar 0111 CopyArray 0129 Move 017e DynArraySetLength"
	strings:
		$1 = { 55 8B EC 83 C4 E0 53 56 57 89 4D F8 8B F2 89 45 FC 8B 5D FC 8B 1B 8B 45 08 8B 38 85 FF 7F 1A 85 FF 7D 07 B0 04 E8 ?? ?? ?? ?? 8B 45 FC 8B D6 E8 ?? ?? ?? ?? E9 54 01 00 00 33 C0 89 45 F0 85 DB 74 09 83 EB 08 8B 43 04 89 45 F0 0F B6 46 01 01 C6 8B C6 8B 50 02 89 55 E8 8B 50 06 85 D2 74 04 8B 32 EB 02 33 F6 8B C7 F7 6D E8 89 45 E4 8B 45 E4 99 F7 FF 3B 45 E8 74 07 B0 04 E8 ?? ?? ?? ?? 83 45 E4 08 83 7D E4 00 7D 07 B0 04 E8 ?? ?? ?? ?? 85 DB 74 05 83 3B 01 75 35 89 5D E0 3B 7D F0 7D 1D 85 F6 74 19 8B C3 83 C0 08 8B D7 0F AF 55 E8 03 C2 8B 4D F0 2B CF 8B D6 E8 ?? ?? ?? ?? 8D 45 E0 8B 55 E4 E8 ?? ?? ?? ?? 8B 5D E0 EB 5E FF 0B 8B 45 E4 E8 ?? ?? ?? ?? 8B D8 8B 45 F0 89 45 EC 3B 7D EC 7D 03 89 7D EC 85 F6 74 2A 8B 55 EC 0F AF 55 E8 8B C3 83 C0 08 33 C9 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 55 FC 8B 12 8B C3 83 C0 08 8B CE E8 ?? ?? ?? ?? EB 16 8B 4D EC 0F AF 4D E8 8B D3 83 C2 08 8B 45 FC 8B 00 E8 ?? ?? ?? ?? 8B C3 C7 00 01 00 00 00 89 78 04 83 C3 08 8B D7 2B 55 F0 0F AF 55 E8 8B 45 E8 0F AF 45 F0 03 C3 33 C9 E8 ?? ?? ?? ?? 83 7D F8 01 7E 2E 83 45 08 04 FF 4D F8 4F 85 FF 7C 22 47 C7 45 F4 00 00 00 00 8B 45 08 50 8B 45 F4 8D 04 83 8B 4D F8 8B D6 E8 ?? ?? ?? ?? FF 45 F4 4F 75 E6 8B 45 FC 89 18 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_867_0 {
	meta:
		name = "@DynArraySetLength"
		size = 11
		refs = "0006 DynArraySetLength"
	strings:
		$1 = { 54 83 04 24 04 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_868_0 {
	meta:
		name = "@DynArrayCopy"
		size = 33
		refs = "0012 @DynArrayCopyRange 001b @DynArrayClear"
	strings:
		$1 = { 53 85 C0 74 13 8B D8 83 EB 08 8B 5B 04 53 51 33 C9 E8 ?? ?? ?? ?? 5B C3 8B C1 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_869_0 {
	meta:
		name = "@DynArrayCopyRange"
		size = 244
		refs = "0087 @GetMem 00b7 @FillChar 00c5 CopyArray 00d7 Move 00e2 DynArrayClear"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 8B F9 89 55 F8 89 45 FC 8B 5D 0C 33 F6 83 7D FC 00 0F 84 BB 00 00 00 8B 45 F8 89 45 F0 85 FF 7D 04 03 DF 33 FF 8B 45 FC 83 E8 08 8B 40 04 3B C7 7D 02 8B F8 8B D0 2B D7 3B DA 7E 02 8B DA 85 DB 7D 02 33 DB 85 DB 0F 8E 86 00 00 00 8B 45 F0 0F B6 40 01 01 45 F0 8B 45 F0 8B 40 02 89 45 F4 8B 45 F0 8B 40 06 85 C0 74 07 8B 00 89 45 F0 EB 05 33 C0 89 45 F0 8B C3 F7 6D F4 83 C0 08 E8 ?? ?? ?? ?? 8B F0 8B C6 C7 00 01 00 00 00 89 58 04 83 C6 08 0F AF 7D F4 01 7D FC 85 DB 7E 35 83 7D F0 00 74 1F 8B D3 0F AF 55 F4 8B C6 33 C9 E8 ?? ?? ?? ?? 53 8B 4D F0 8B 55 FC 8B C6 E8 ?? ?? ?? ?? EB 10 8B CB 0F AF 4D F4 8B D6 8B 45 FC E8 ?? ?? ?? ?? 8B 45 08 8B 55 F8 E8 ?? ?? ?? ?? 8B 45 08 89 30 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_870_0 {
	meta:
		name = "@DynArrayClear"
		size = 60
		refs = "002d @FinalizeArray 0036 @FreeMem"
	strings:
		$1 = { 8B 08 85 C9 74 35 C7 00 00 00 00 00 F0 FF 49 F8 75 29 50 89 C8 31 C9 8A 4A 01 8B 54 11 06 85 D2 74 10 8B 48 FC 85 C9 74 09 8B 12 50 E8 ?? ?? ?? ?? 58 83 E8 08 E8 ?? ?? ?? ?? 58 C3 }
	condition:
		$1
}

rule function_871_0 {
	meta:
		name = "@DynArrayAsg"
		size = 39
		refs = "001d @DynArrayClear"
	strings:
		$1 = { 53 8B 18 85 D2 74 04 F0 FF 42 F8 85 DB 74 14 F0 FF 4B F8 75 0E 50 52 89 CA FF 43 F8 E8 ?? ?? ?? ?? 5A 58 89 10 5B C3 }
	condition:
		$1
}

rule function_872_0 {
	meta:
		name = "@DynArrayAddRef"
		size = 9
	strings:
		$1 = { 85 C0 74 04 F0 FF 40 F8 C3 }
	condition:
		$1
}

rule function_873_0 {
	meta:
		name = "DynArrayIndex"
		size = 62
	strings:
		$1 = { 55 8B EC 53 56 57 55 89 D6 8B 7D 08 89 C5 31 DB 85 C9 7D 03 8B 6D 00 31 C0 8A 47 01 01 C7 8B 04 9E F7 67 02 8B 7F 06 85 FF 74 02 8B 3F 01 C5 43 39 CB 7E E0 89 E8 5D 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_874_0 {
	meta:
		name = "DynArrayElTypeInfo"
		size = 24
	strings:
		$1 = { 33 D2 85 C0 74 0F 0F B6 48 01 01 C8 8B 48 06 85 C9 74 02 8B 11 8B C2 C3 }
	condition:
		$1
}

rule function_875_0 {
	meta:
		name = "DynArrayDim"
		size = 32
		refs = "000c DynArrayElTypeInfo"
	strings:
		$1 = { 53 56 8B D8 33 F6 EB 0A 46 8B C3 E8 ?? ?? ?? ?? 8B D8 85 DB 74 05 80 3B 11 74 ED 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_877_0 {
	meta:
		name = "IsDynArrayRectangular"
		size = 102
		refs = "0010 DynArrayDim 0024 DynArraySize"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 C6 04 24 01 8B D8 8B C2 E8 ?? ?? ?? ?? 48 85 C0 7E 42 89 44 24 04 85 DB 74 34 8B C3 E8 ?? ?? ?? ?? 8B F0 8B 03 E8 ?? ?? ?? ?? 8B E8 4E 85 F6 7E 1B BF 01 00 00 00 8B 04 BB E8 ?? ?? ?? ?? 3B E8 74 06 C6 04 24 00 EB 0C 47 4E 75 EA 8B 1B FF 4C 24 04 75 C2 0F B6 04 24 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_878_0 {
	meta:
		name = "DynArrayBounds"
		size = 82
		refs = "0010 DynArrayDim 0020 TBoundArray 0025 @DynArraySetLength 003b DynArraySize"
	strings:
		$1 = { 53 56 57 55 51 8B E9 89 14 24 8B D8 8B 04 24 E8 ?? ?? ?? ?? 8B F0 56 8B C5 B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 4E 85 F6 7C 1B 46 33 FF 85 DB 74 10 8B C3 E8 ?? ?? ?? ?? 48 8B 55 00 89 04 BA 8B 1B 47 4E 75 E8 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_879_0 {
	meta:
		name = "DecIndices"
		size = 304
		refs = "000d @DynArrayHigh 0031 @DynArrayLength 0048 DecIndices 0052 @Assert"
	strings:
		$1 = { 53 56 57 55 8B FA 8B F0 33 DB 8B 06 E8 ?? ?? ?? ?? 8B D0 85 D2 7C 13 42 33 C0 8B 0E 83 3C 81 00 74 04 B3 01 EB 04 40 4A 75 F0 84 DB 74 7D 8B 06 E8 ?? ?? ?? ?? 8B E8 8B C7 E8 ?? ?? ?? ?? 3B E8 74 14 B9 82 69 00 00 BA ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 06 E8 ?? ?? ?? ?? 83 F8 00 7C 49 8B 16 83 3C 82 00 74 07 8B 16 FF 0C 82 EB 3A 8B E8 EB 21 8B 04 AF 8B 16 89 04 AA 4D 85 ED 7D 14 B9 96 69 00 00 BA ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 06 83 3C A8 00 74 D7 8B 06 FF 0C A8 EB 06 48 83 F8 FF 75 B7 8B C3 5D 5F 5E 5B C3 00 00 B0 04 02 00 FF FF FF FF 1F 00 00 00 43 00 3A 00 5C 00 42 00 75 00 69 00 6C 00 64 00 73 00 5C 00 54 00 50 00 5C 00 72 00 74 00 6C 00 5C 00 73 00 79 00 73 00 5C 00 53 00 79 00 73 00 74 00 65 00 6D 00 2E 00 70 00 61 00 73 00 00 00 B0 04 02 00 FF FF FF FF 11 00 00 00 41 00 73 00 73 00 65 00 72 00 74 00 69 00 6F 00 6E 00 20 00 66 00 61 00 69 00 6C 00 75 00 72 00 65 00 00 00 }
	condition:
		$1
}

rule function_880_0 {
	meta:
		name = "FindModule"
		size = 39
		refs = "0002 LibModuleList"
	strings:
		$1 = { 8B 15 ?? ?? ?? ?? 85 D2 74 1A 3B 42 04 74 15 3B 42 08 74 10 3B 42 0C 74 0B 3B 42 10 74 06 8B 12 85 D2 75 E6 8B C2 C3 }
	condition:
		$1
}

rule function_881_0 {
	meta:
		name = "FindHInstance"
		size = 38
		refs = "000c VirtualQuery"
	strings:
		$1 = { 83 C4 E4 6A 1C 8D 54 24 04 52 50 E8 ?? ?? ?? ?? 81 7C 24 10 00 10 00 00 75 06 8B 44 24 04 EB 02 33 C0 83 C4 1C C3 }
	condition:
		$1
}

rule function_883_0 {
	meta:
		name = "DelayLoadResourceModule"
		size = 71
		refs = "001f GetModuleFileName 0028 LoadResourceModule"
	strings:
		$1 = { 53 56 81 C4 F4 FD FF FF 8B D8 83 7B 10 00 75 2B 68 0A 02 00 00 8D 44 24 04 50 8B 43 04 50 E8 ?? ?? ?? ?? 8B C4 B2 01 E8 ?? ?? ?? ?? 8B F0 89 73 10 85 F6 75 06 8B 43 04 89 43 10 8B 43 10 81 C4 0C 02 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_884_0 {
	meta:
		name = "FindResourceHInstance"
		size = 55
		refs = "0007 LibModuleList 0021 DelayLoadResourceModule"
	strings:
		$1 = { 53 56 57 8B F0 8B 1D ?? ?? ?? ?? 85 DB 74 20 3B 73 04 74 0A 3B 73 08 74 05 3B 73 0C 75 0B 8B C3 E8 ?? ?? ?? ?? 8B F8 EB 08 8B 1B 85 DB 75 E0 8B FE 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_885_0 {
	meta:
		name = "InitializeLocaleData"
		size = 240
		refs = "0001 CrSec 0006 InitializeCriticalSection 000d CachedLangID 0014 GetVersion 0023 UseThreadUILanguageAPI 0031 InitializeLocaleData 003b GetModuleHandle 0041 GetProcAddress 0046 GetThreadPreferredUILanguages 0060 SetThreadPreferredUILanguages 007a GetThreadUILanguage"
	strings:
		$1 = { 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 C7 05 ?? ?? ?? ?? 7F 00 E8 ?? ?? ?? ?? 25 FF 00 00 00 83 F8 06 0F 93 05 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 74 4E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? C3 00 47 65 74 54 68 72 65 61 64 50 72 65 66 65 72 72 65 64 55 49 4C 61 6E 67 75 61 67 65 73 00 00 00 6B 00 65 00 72 00 6E 00 65 00 6C 00 33 00 32 00 2E 00 64 00 6C 00 6C 00 00 00 00 00 53 65 74 54 68 72 65 61 64 50 72 65 66 65 72 72 65 64 55 49 4C 61 6E 67 75 61 67 65 73 00 00 00 47 65 74 54 68 72 65 61 64 55 49 4C 61 6E 67 75 61 67 65 00 }
	condition:
		$1
}

rule function_887_0 {
	meta:
		name = "LastHyphenPos"
		size = 105
		refs = "000c @UStrAddRef 0014 LastHyphenPos 0057 @UStrClr 005d @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 85 C0 74 05 83 E8 04 8B 00 83 F8 01 7C 15 8B 55 FC 66 83 7C 42 FE 2D 75 05 8B D8 4B EB 07 48 85 C0 75 EB 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 }
	condition:
		$1
}

rule function_888_0 {
	meta:
		name = "ConvertResToUILanguages"
		size = 240
		refs = "0013 ConvertResToUILanguages 0022 @UStrFromPChar 0054 @UStrLAsg 005b @UStrClr 0071 @UStrCatN 008a LastHyphenPos 0099 @UStrCopy 00cc @UStrArrayClr 00d2 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 53 56 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B D6 E8 ?? ?? ?? ?? 8B 03 89 45 F4 8B 45 F4 85 C0 74 05 83 E8 04 8B 00 85 C0 7E 13 BA 01 00 00 00 8B 0B 66 83 7C 51 FE 2C 74 64 42 48 75 F2 8D 45 F8 8B 13 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? EB 47 FF 33 FF 75 FC FF 75 F8 8B C3 BA 03 00 00 00 E8 ?? ?? ?? ?? 8D 45 FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 F0 50 8B 45 F8 E8 ?? ?? ?? ?? 8B C8 BA 01 00 00 00 8B 45 F8 E8 ?? ?? ?? ?? 8B 55 F0 8D 45 F8 E8 ?? ?? ?? ?? 83 7D F8 00 75 B3 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E3 5E 5B 8B E5 5D C3 00 00 B0 04 02 00 FF FF FF FF 01 00 00 00 2C 00 00 00 }
	condition:
		$1
}

rule function_889_0 {
	meta:
		name = "GetPreferredLangForOldOS"
		size = 404
		refs = "0029 GetPreferredLangForOldOS 0037 @UStrClr 003e LocaleTable 008d ConvertResToUILanguages 00ab IsValidLocale 00c7 GetLocaleInfo 00ee @UStrFromWArray 0143 @UStrCatN 0160 @UStrArrayClr 0166 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 98 FE FF FF 53 56 57 33 C9 89 8D A0 FE FF FF 89 8D 9C FE FF FF 89 8D 98 FE FF FF 89 55 FC 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC E8 ?? ?? ?? ?? 66 3B 35 ?? ?? ?? ?? 72 54 66 3B 35 ?? ?? ?? ?? 77 4B BF 40 00 00 00 33 C0 89 45 F8 3B 7D F8 72 3C 8B 5D F8 03 DF D1 EB 66 3B 34 DD ?? ?? ?? ?? 73 05 8B FB 4F EB 21 66 3B 34 DD ?? ?? ?? ?? 76 06 43 89 5D F8 EB 11 8B 55 FC 8B 04 DD ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 05 3B 7D F8 73 C4 8B 45 FC 83 38 00 0F 85 A3 00 00 00 6A 02 0F B7 C6 50 E8 ?? ?? ?? ?? 85 C0 0F 84 90 00 00 00 6A 55 8D 85 4E FF FF FF 50 6A 59 0F B7 DE 53 E8 ?? ?? ?? ?? 6A 55 8D 85 A4 FE FF FF 50 6A 5A 53 E8 ?? ?? ?? ?? 8D 85 A0 FE FF FF 8D 95 4E FF FF FF B9 55 00 00 00 E8 ?? ?? ?? ?? FF B5 A0 FE FF FF 68 ?? ?? ?? ?? 8D 85 9C FE FF FF 8D 95 A4 FE FF FF B9 55 00 00 00 E8 ?? ?? ?? ?? FF B5 9C FE FF FF 68 ?? ?? ?? ?? 8D 85 98 FE FF FF 8D 95 4E FF FF FF B9 55 00 00 00 E8 ?? ?? ?? ?? FF B5 98 FE FF FF 8B 45 FC BA 05 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 98 FE FF FF BA 03 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 00 B0 04 02 00 FF FF FF FF 01 00 00 00 2D 00 00 00 B0 04 02 00 FF FF FF FF 01 00 00 00 2C 00 00 00 }
	condition:
		$1
}

rule function_890_0 {
	meta:
		name = "CheckDifferentLanguageList"
		size = 36
	strings:
		$1 = { 53 56 8B F1 B1 01 85 F6 7E 13 0F B7 18 66 3B 1A 75 0D 83 C0 02 83 C2 02 4E 85 F6 7F ED 33 C9 8B C1 5E 5B C3 }
	condition:
		$1
}

rule function_891_0 {
	meta:
		name = "ThreadUILanguages"
		size = 65
		refs = "0019 GetThreadPreferredUILanguages 0026 @GetMem"
	strings:
		$1 = { 55 8B EC 51 53 56 8B D8 33 F6 33 C0 89 03 53 6A 00 8D 45 FC 50 6A 38 FF 15 ?? ?? ?? ?? 84 C0 74 19 8B 03 03 C0 E8 ?? ?? ?? ?? 8B F0 53 56 8D 45 FC 50 6A 38 FF 15 ?? ?? ?? ?? 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_892_0 {
	meta:
		name = "GetPreferredLangForNewOS"
		size = 281
		refs = "0013 GetThreadUILanguage 0020 ThreadUILanguages 003f hexDigits 0070 SetThreadPreferredUILanguages 00b2 @UStrFromPWChar 00b9 @FreeMem 00ec CheckDifferentLanguageList"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 8B F2 8B D8 33 C0 89 45 F4 FF 15 ?? ?? ?? ?? 66 3B D8 74 58 8D 45 FC E8 ?? ?? ?? ?? 89 45 F4 8B D3 C7 45 F0 03 00 00 00 8D 45 EA 8B CA 66 83 E1 0F 0F B7 C9 0F B6 89 ?? ?? ?? ?? 66 89 08 0F B7 D2 C1 EA 04 FF 4D F0 83 E8 02 83 7D F0 FF 75 DB 66 C7 45 EC 00 00 66 C7 45 EE 00 00 8D 45 F0 50 8D 45 E4 50 6A 04 FF 15 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8B D8 85 DB 74 3B 8B 45 F8 83 E8 02 85 C0 7C 21 40 C7 45 F0 00 00 00 00 8B 55 F0 66 83 3C 53 00 75 09 8B 55 F0 66 C7 04 53 2C 00 FF 45 F0 48 75 E7 8B C6 8B D3 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 83 7D F4 00 74 50 8D 45 F0 50 6A 00 6A 00 FF 15 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8B D8 8B 45 FC 3B 45 F8 75 11 8B 4D F8 8B D3 8B 45 F4 E8 ?? ?? ?? ?? 84 C0 74 10 8D 45 F0 50 8B 45 F4 50 6A 08 FF 15 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_893_0 {
	meta:
		name = "GetUILanguages"
		size = 288
		refs = "000f GetUILanguages 001a CrSec 001f EnterCriticalSection 0026 CachedLangID 002f CachedLanguageNames 0039 @UStrFromWArray 0043 LeaveCriticalSection 0059 @UStrClr 0064 IsValidLocale 006e UseThreadUILanguageAPI 007a GetPreferredLangForNewOS 0085 GetPreferredLangForOldOS 008a GetSystemDefaultUILanguage 00a0 @UStrCat 00d4 @UStrToPWChar 00df lstrcpyn 0104 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 3B 1D ?? ?? ?? ?? 75 20 8B C6 BA ?? ?? ?? ?? B9 55 00 00 00 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 A1 00 00 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 6A 02 0F B7 C3 50 E8 ?? ?? ?? ?? 85 C0 74 4F 80 3D ?? ?? ?? ?? 00 74 0B 8B D6 8B C3 E8 ?? ?? ?? ?? EB 3B 8B D6 8B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 3B D8 74 28 83 3E 00 74 0C 8B C6 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 55 FC E8 ?? ?? ?? ?? 8B 55 FC 8B C6 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 89 1D ?? ?? ?? ?? 68 AA 00 00 00 8B 06 E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 00 B0 04 02 00 FF FF FF FF 01 00 00 00 2C 00 00 00 }
	condition:
		$1
}

rule function_894_0 {
	meta:
		name = "FindBS"
		size = 33
		refs = "0008 CharNext"
	strings:
		$1 = { 53 56 8B D8 EB 08 53 E8 ?? ?? ?? ?? 8B D8 0F B7 33 66 85 F6 74 06 66 83 FE 5C 75 EA 8B C3 5E 5B C3 }
	condition:
		$1
}

rule function_895_0 {
	meta:
		name = "ToLongPath"
		size = 500
		refs = "0019 ToLongPath 001e GetModuleHandle 002f GetProcAddress 005f lstrcpyn 0086 FindBS 0129 FindFirstFile 013f FindClose 014b @strlen"
	strings:
		$1 = { 55 8B EC 81 C4 94 FB FF FF 53 56 57 89 55 F8 89 45 FC 8B 45 FC 89 45 F4 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 85 F6 74 40 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 89 C3 85 DB 74 2F 68 05 01 00 00 8D 85 96 FB FF FF 50 8B 45 FC 50 FF D3 85 C0 74 19 8B 45 F8 50 8D 85 96 FB FF FF 50 8B 45 FC 50 E8 ?? ?? ?? ?? E9 52 01 00 00 8B 45 FC 66 83 38 5C 75 3B 8B 45 FC 66 83 78 02 5C 0F 85 3B 01 00 00 8B 45 FC 83 C0 04 E8 ?? ?? ?? ?? 8B F0 66 83 3E 00 0F 84 24 01 00 00 8D 46 02 E8 ?? ?? ?? ?? 8B F0 66 83 3E 00 0F 84 10 01 00 00 EB 06 8B 75 FC 83 C6 04 8B DE 2B 5D FC D1 FB 79 03 83 D3 00 8D 43 01 50 8B 45 FC 50 8D 85 96 FB FF FF 50 E8 ?? ?? ?? ?? E9 C5 00 00 00 8D 46 02 E8 ?? ?? ?? ?? 8B F8 8B C7 2B C6 D1 F8 79 03 83 D0 00 03 C3 40 3D 05 01 00 00 0F 8F C0 00 00 00 8B C7 2B C6 D1 F8 79 03 83 D0 00 40 50 56 8D 85 96 FB FF FF 8B D3 03 D2 03 C2 50 E8 ?? ?? ?? ?? 8D 85 A0 FD FF FF 50 8D 85 96 FB FF FF 50 E8 ?? ?? ?? ?? 89 45 F0 83 7D F0 FF 0F 84 80 00 00 00 8B 45 F0 50 E8 ?? ?? ?? ?? 8D 85 CC FD FF FF 50 E8 ?? ?? ?? ?? 8D 53 01 03 C2 40 3D 05 01 00 00 7F 5E 66 C7 84 5D 96 FB FF FF 5C 00 B8 05 01 00 00 2B C3 48 50 8D 85 CC FD FF FF 50 8D 85 96 FB FF FF 8B D3 03 D2 03 C2 83 C0 02 50 E8 ?? ?? ?? ?? 8D 85 CC FD FF FF 50 E8 ?? ?? ?? ?? 40 03 D8 8B F7 66 83 3E 00 0F 85 31 FF FF FF 8B 45 F8 50 8D 85 96 FB FF FF 50 8B 45 FC 50 E8 ?? ?? ?? ?? 8B 45 F4 5F 5E 5B 8B E5 5D C3 6B 00 65 00 72 00 6E 00 65 00 6C 00 33 00 32 00 2E 00 64 00 6C 00 6C 00 00 00 00 00 47 65 74 4C 6F 6E 67 50 61 74 68 4E 61 6D 65 57 00 00 00 00 }
	condition:
		$1
}

rule function_896_0 {
	meta:
		name = "InternalGetLocaleOverride"
		size = 796
		refs = "0013 @UStrAddRef 001b InternalGetLocaleOverride 003a GetModuleFileName 0049 @UStrToPWChar 0056 lstrcpyn 0083 RegOpenKeyEx 0143 ToLongPath 015d RegQueryValueEx 0169 @GetMem 0192 @UStrFromPWChar 01fa @FreeMem 0203 RegCloseKey 0209 @HandleFinally 0220 @UStrClr"
	strings:
		$1 = { 55 8B EC 81 C4 E4 FD FF FF 53 8B DA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7D FC 00 75 15 68 05 01 00 00 8D 85 E6 FD FF FF 50 6A 00 E8 ?? ?? ?? ?? EB 1A 68 05 01 00 00 8B 45 FC E8 ?? ?? ?? ?? 50 8D 85 E6 FD FF FF 50 E8 ?? ?? ?? ?? 66 83 BD E6 FD FF FF 00 0F 84 A7 01 00 00 33 C0 89 45 F8 8D 45 F4 50 68 19 00 0F 00 6A 00 68 ?? ?? ?? ?? 68 01 00 00 80 E8 ?? ?? ?? ?? 85 C0 0F 84 9A 00 00 00 8D 45 F4 50 68 19 00 0F 00 6A 00 68 ?? ?? ?? ?? 68 02 00 00 80 E8 ?? ?? ?? ?? 85 C0 74 7C 8D 45 F4 50 68 19 00 0F 00 6A 00 68 ?? ?? ?? ?? 68 01 00 00 80 E8 ?? ?? ?? ?? 85 C0 74 5E 8D 45 F4 50 68 19 00 0F 00 6A 00 68 ?? ?? ?? ?? 68 02 00 00 80 E8 ?? ?? ?? ?? 85 C0 74 40 8D 45 F4 50 68 19 00 0F 00 6A 00 68 ?? ?? ?? ?? 68 01 00 00 80 E8 ?? ?? ?? ?? 85 C0 74 22 8D 45 F4 50 68 19 00 0F 00 6A 00 68 ?? ?? ?? ?? 68 01 00 00 80 E8 ?? ?? ?? ?? 85 C0 0F 85 E6 00 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 85 E6 FD FF FF BA 05 01 00 00 E8 ?? ?? ?? ?? 8D 45 F0 50 6A 00 6A 00 6A 00 8D 85 E6 FD FF FF 50 8B 45 F4 50 E8 ?? ?? ?? ?? 85 C0 75 33 8B 45 F0 E8 ?? ?? ?? ?? 89 45 F8 8D 45 F0 50 8B 45 F8 50 6A 00 6A 00 8D 85 E6 FD FF FF 50 8B 45 F4 50 E8 ?? ?? ?? ?? 8B C3 8B 55 F8 E8 ?? ?? ?? ?? EB 4B 8D 45 F0 50 6A 00 6A 00 6A 00 68 ?? ?? ?? ?? 8B 45 F4 50 E8 ?? ?? ?? ?? 85 C0 75 2F 8B 45 F0 E8 ?? ?? ?? ?? 89 45 F8 8D 45 F0 50 8B 45 F8 50 6A 00 6A 00 68 ?? ?? ?? ?? 8B 45 F4 50 E8 ?? ?? ?? ?? 8B C3 8B 55 F8 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 83 7D F8 00 74 08 8B 45 F8 E8 ?? ?? ?? ?? 8B 45 F4 50 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E1 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 8B E5 5D C3 00 00 00 53 00 6F 00 66 00 74 00 77 00 61 00 72 00 65 00 5C 00 45 00 6D 00 62 00 61 00 72 00 63 00 61 00 64 00 65 00 72 00 6F 00 5C 00 4C 00 6F 00 63 00 61 00 6C 00 65 00 73 00 00 00 00 00 53 00 6F 00 66 00 74 00 77 00 61 00 72 00 65 00 5C 00 43 00 6F 00 64 00 65 00 47 00 65 00 61 00 72 00 5C 00 4C 00 6F 00 63 00 61 00 6C 00 65 00 73 00 00 00 53 00 6F 00 66 00 74 00 77 00 61 00 72 00 65 00 5C 00 42 00 6F 00 72 00 6C 00 61 00 6E 00 64 00 5C 00 4C 00 6F 00 63 00 61 00 6C 00 65 00 73 00 00 00 00 00 53 00 6F 00 66 00 74 00 77 00 61 00 72 00 65 00 5C 00 42 00 6F 00 72 00 6C 00 61 00 6E 00 64 00 5C 00 44 00 65 00 6C 00 70 00 68 00 69 00 5C 00 4C 00 6F 00 63 00 61 00 6C 00 65 00 73 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_897_0 {
	meta:
		name = "GetLocaleOverride"
		size = 99
		refs = "000f GetLocaleOverride 001b PreferredLanguagesOverride 0028 InternalGetLocaleOverride 0030 SetLocaleOverride 003d @UStrFromPWChar 0052 @UStrClr 0058 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 3D ?? ?? ?? ?? 00 75 12 8D 55 FC 8B C6 E8 ?? ?? ?? ?? 8B 45 FC E8 ?? ?? ?? ?? 8B C3 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_898_0 {
	meta:
		name = "SetLocaleOverride"
		size = 82
		refs = "0007 PreferredLanguagesOverride 0014 @FreeMem 0031 @GetMem 003d @UStrToPWChar 004a Move"
	strings:
		$1 = { 53 56 57 8B F0 83 3D ?? ?? ?? ?? 00 74 0A A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C6 85 C0 74 05 83 E8 04 8B 00 8B D8 85 DB 7E 25 43 8B FB 03 FF 8B C7 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 8B CF E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_899_0 {
	meta:
		name = "LoadModule"
		size = 85
		refs = "000c @UStrAddRef 0014 LoadModule 0026 @UStrToPWChar 002c LoadLibraryEx 0043 @UStrClr 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A 02 6A 00 8B 45 FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 }
	condition:
		$1
}

rule function_900_0 {
	meta:
		name = "ResouceDLLExists"
		size = 108
		refs = "0011 @UStrAddRef 0019 ResouceDLLExists 002e @UStrToPWChar 0034 FindFirstFile 0044 FindClose 0059 @UStrClr 005f @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 AC FD FF FF 53 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 85 AC FD FF FF 50 8B 45 FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 F8 FF 0F 95 C3 84 DB 74 06 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_901_0 {
	meta:
		name = "LoadLanguageList"
		size = 201
		refs = "001a @UStrAddRef 002a LoadLanguageList 0037 @UStrClr 004b @UStrLen 0070 @UStrCopy 007d @UStrCat3 0084 ResouceDLLExists 00b6 @UStrArrayClr 00bc @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 57 33 DB 89 5D F4 8B F9 89 55 F8 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? BB 01 00 00 00 EB 4B 8B F3 EB 01 43 8B 45 F8 E8 ?? ?? ?? ?? 3B D8 7F 0B 8B 45 F8 66 83 7C 58 FE 2C 75 E8 3B DE 74 2A 8D 45 F4 50 8B CB 2B CE 8B D6 8B 45 F8 E8 ?? ?? ?? ?? 8B 4D F4 8B C7 8B 55 FC E8 ?? ?? ?? ?? 8B 07 E8 ?? ?? ?? ?? 84 C0 75 14 43 8B 45 F8 E8 ?? ?? ?? ?? 3B D8 7E A9 8B C7 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 BA 03 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_902_0 {
	meta:
		name = "Load3LettersModule"
		size = 204
		refs = "0018 @UStrAddRef 0020 Load3LettersModule 0033 GetUserDefaultUILanguage 003c GetLocaleInfo 004c @UStrFromWArray 0059 @UStrCat3 0060 ResouceDLLExists 0099 @UStrClr 00b3 @UStrArrayClr 00c1 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 33 C9 89 4D EC 89 4D F0 8B DA 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A 08 8D 45 F4 50 6A 03 E8 ?? ?? ?? ?? 0F B7 C0 50 E8 ?? ?? ?? ?? 8D 45 F0 8D 55 F4 B9 04 00 00 00 E8 ?? ?? ?? ?? 8B 4D F0 8B C3 8B 55 FC E8 ?? ?? ?? ?? 8B 03 E8 ?? ?? ?? ?? 84 C0 75 35 66 C7 45 F8 00 00 8D 45 EC 8D 55 F4 B9 04 00 00 00 E8 ?? ?? ?? ?? 8B 4D EC 8B C3 8B 55 FC E8 ?? ?? ?? ?? 8B 03 E8 ?? ?? ?? ?? 84 C0 75 07 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E3 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_903_0 {
	meta:
		name = "GetResourceModuleName"
		size = 282
		refs = "001d @UStrAddRef 002d GetResourceModuleName 003a @UStrClr 0045 @UStrLAsg 0076 @UStrCopy 0088 GetLocaleOverride 009b LoadLanguageList 00a2 GetUserDefaultUILanguage 00aa GetUILanguages 00c2 UseThreadUILanguageAPI 00ca GetSystemDefaultUILanguage 00ee Load3LettersModule 0108 @UStrArrayClr 010e @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 89 55 F8 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 8B 45 F8 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 8D 45 F0 8B 55 F8 E8 ?? ?? ?? ?? 8B 45 F8 85 C0 74 05 83 E8 04 8B 00 8B D8 83 FB 01 7C 25 8B 45 F8 66 83 7C 58 FE 2E 75 15 8D 45 F0 50 8B CB BA 01 00 00 00 8B 45 F8 E8 ?? ?? ?? ?? EB 05 4B 85 DB 75 DB 8D 55 F4 8B 45 FC E8 ?? ?? ?? ?? 83 7D F4 00 74 0F 8B CE 8B 55 F4 8B 45 F0 E8 ?? ?? ?? ?? EB 51 E8 ?? ?? ?? ?? 8D 55 EC E8 ?? ?? ?? ?? 8B 55 EC 8B CE 8B 45 F0 E8 ?? ?? ?? ?? 83 3E 00 75 23 80 3D ?? ?? ?? ?? 00 75 1A E8 ?? ?? ?? ?? 8D 55 E8 E8 ?? ?? ?? ?? 8B 55 E8 8B CE 8B 45 F0 E8 ?? ?? ?? ?? 83 3E 00 75 0A 8B D6 8B 45 F0 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E8 BA 06 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_904_0 {
	meta:
		name = "LoadResourceModule"
		size = 197
		refs = "0025 LoadResourceModule 0040 GetModuleFileName 004d @UStrFromPWChar 006a @UStrFromWArray 0079 GetResourceModuleName 0089 LoadModule 00a8 @UStrArrayClr 00b0 @UStrClr 00b6 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 E8 FD FF FF 53 56 57 33 C9 89 8D EC FD FF FF 89 8D E8 FD FF FF 89 4D FC 8B DA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 FF 68 05 01 00 00 8D 85 F2 FD FF FF 50 6A 00 E8 ?? ?? ?? ?? 8D 85 EC FD FF FF 8B D6 E8 ?? ?? ?? ?? 8B 85 EC FD FF FF 50 8D 85 E8 FD FF FF 8D 95 F2 FD FF FF B9 05 01 00 00 E8 ?? ?? ?? ?? 8B 85 E8 FD FF FF 8D 4D FC 5A E8 ?? ?? ?? ?? 83 7D FC 00 74 0C 8B D3 8B 45 FC E8 ?? ?? ?? ?? 8B F8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 E8 FD FF FF BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 8B C7 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_907_0 {
	meta:
		name = "EnumModules"
		size = 38
		refs = "0009 LibModuleList"
	strings:
		$1 = { 53 56 57 8B FA 8B F0 8B 1D ?? ?? ?? ?? 85 DB 74 11 8B D7 8B 43 04 FF D6 84 C0 74 06 8B 1B 85 DB 75 EF 5F 5E 5B C3 }
	condition:
		$1
}

rule function_908_0 {
	meta:
		name = "EnumResourceModules"
		size = 42
		refs = "0009 LibModuleList 0014 DelayLoadResourceModule"
	strings:
		$1 = { 53 56 57 8B FA 8B F0 8B 1D ?? ?? ?? ?? 85 DB 74 15 8B C3 E8 ?? ?? ?? ?? 8B D7 FF D6 84 C0 74 06 8B 1B 85 DB 75 EB 5F 5E 5B C3 }
	condition:
		$1
}

rule function_911_0 {
	meta:
		name = "AddModuleUnloadProc"
		size = 31
		refs = "0009 @GetMem 000f ModuleUnloadList"
	strings:
		$1 = { 53 8B D8 B8 08 00 00 00 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 10 89 58 04 A3 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_912_0 {
	meta:
		name = "RemoveModuleUnloadProc"
		size = 99
		refs = "0008 ModuleUnloadList 002b @FreeMem"
	strings:
		$1 = { 53 56 57 55 8B E8 8B 3D ?? ?? ?? ?? 85 FF 74 21 8B 47 04 3B C5 75 1A A1 ?? ?? ?? ?? 8B 00 A3 ?? ?? ?? ?? BA 08 00 00 00 8B C7 E8 ?? ?? ?? ?? EB 2D 8B DF 85 DB 74 27 8B 33 85 F6 74 1B 8B 46 04 3B C5 75 14 8B FE 8B 06 89 03 BA 08 00 00 00 8B C7 E8 ?? ?? ?? ?? EB 06 8B 1B 85 DB 75 D9 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_913_0 {
	meta:
		name = "NotifyModuleUnload"
		size = 90
		refs = "000d ModuleUnloadList 001e NotifyModuleUnload 003c @HandleAnyException 0041 @DoneExcept"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 89 45 FC A1 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 74 39 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 5D F8 8B 45 FC FF 53 04 33 C0 5A 59 59 64 89 10 EB 0A E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F8 8B 00 89 45 F8 83 7D F8 00 75 C7 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_914_0 {
	meta:
		name = "RegisterModule"
		size = 14
		refs = "0002 LibModuleList"
	strings:
		$1 = { 8B 15 ?? ?? ?? ?? 89 10 A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_915_0 {
	meta:
		name = "UnregisterModule"
		size = 110
		refs = "000b UnregisterModule 001c NotifyModuleUnload 0032 LibModuleList 0065 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 89 45 FC 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 FC 8B 40 04 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 3B 05 ?? ?? ?? ?? 75 0C 8B 45 FC 8B 00 A3 ?? ?? ?? ?? EB 1F A1 ?? ?? ?? ?? 85 C0 74 16 8B 10 3B 55 FC 75 09 8B 55 FC 8B 12 89 10 EB 06 8B 00 85 C0 75 EA C3 E9 ?? ?? ?? ?? EB C2 59 5D C3 }
	condition:
		$1
}

rule function_916_0 {
	meta:
		name = "@IntfClear"
		size = 21
	strings:
		$1 = { 8B 10 85 D2 74 0E C7 00 00 00 00 00 50 52 8B 02 FF 50 08 58 C3 }
	condition:
		$1
}

rule function_917_0 {
	meta:
		name = "@IntfCopy"
		size = 44
	strings:
		$1 = { 85 D2 74 19 52 50 8B 02 52 FF 50 04 58 8B 08 8F 00 85 C9 75 01 C3 8B 01 51 FF 50 08 C3 8B 08 85 C9 89 10 74 06 8B 01 51 FF 50 08 C3 }
	condition:
		$1
}

rule function_918_0 {
	meta:
		name = "@IntfCast"
		size = 48
		refs = "0004 @IntfClear 001b Error"
	strings:
		$1 = { 85 D2 0F 84 ?? ?? ?? ?? 57 89 C7 6A 00 54 51 52 8B 02 FF 10 85 C0 74 07 B0 17 E9 ?? ?? ?? ?? 8B 07 85 C0 74 06 50 8B 00 FF 50 08 58 89 07 5F C3 }
	condition:
		$1
}

rule function_919_0 {
	meta:
		name = "@IntfAddRef"
		size = 11
	strings:
		$1 = { 85 C0 74 06 50 8B 00 FF 50 04 C3 }
	condition:
		$1
}

rule function_920_0 {
	meta:
		name = "TInterfacedObject.AfterConstruction"
		size = 9
		refs = "0004 InterlockedDecrement"
	strings:
		$1 = { 83 C0 04 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_921_0 {
	meta:
		name = "TInterfacedObject.BeforeDestruction"
		size = 14
		refs = "0009 Error"
	strings:
		$1 = { 83 78 04 00 74 07 B0 02 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_922_0 {
	meta:
		name = "TInterfacedObject.NewInstance"
		size = 13
		refs = "0001 TObject.NewInstance"
	strings:
		$1 = { E8 ?? ?? ?? ?? C7 40 04 01 00 00 00 C3 }
	condition:
		$1
}

rule function_923_0 {
	meta:
		name = "TContainedObject.QueryInterface"
		size = 38
		refs = "0010 TObject.GetInterface"
		altNames = "TInterfacedObject.QueryInterface"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 8B 4D 10 8B 55 0C 8B C3 E8 ?? ?? ?? ?? 84 C0 74 04 33 C0 EB 05 B8 02 40 00 80 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_924_0 {
	meta:
		name = "TInterfacedObject._AddRef"
		size = 18
		refs = "000a InterlockedIncrement"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 C0 04 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule function_925_0 {
	meta:
		name = "TInterfacedObject._Release"
		size = 39
		refs = "000c InterlockedDecrement"
	strings:
		$1 = { 55 8B EC 53 56 8B 5D 08 8D 43 04 E8 ?? ?? ?? ?? 8B F0 85 F6 75 09 B2 01 8B C3 8B 08 FF 51 FC 8B C6 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_926_0 {
	meta:
		name = "TAggregatedObject.Create"
		size = 35
		refs = "0008 @ClassCreate 0014 @AfterConstruction"
	strings:
		$1 = { 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 89 48 04 84 D2 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C C3 }
	condition:
		$1
}

rule function_927_0 {
	meta:
		name = "TAggregatedObject.GetController"
		size = 19
		refs = "000c @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C6 8B 53 04 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_928_0 {
	meta:
		name = "TAggregatedObject.QueryInterface"
		size = 26
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 55 10 52 8B 55 0C 52 8B 40 04 50 8B 00 FF 10 5D C2 0C 00 }
	condition:
		$1
}

rule function_929_0 {
	meta:
		name = "TAggregatedObject._AddRef"
		size = 19
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 40 04 50 8B 00 FF 50 04 5D C2 04 00 }
	condition:
		$1
}

rule function_930_0 {
	meta:
		name = "TAggregatedObject._Release"
		size = 19
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 40 04 50 8B 00 FF 50 08 5D C2 04 00 }
	condition:
		$1
}

rule function_932_0 {
	meta:
		name = "TClassHelperBase._Create"
		size = 60
		refs = "000b @ClassCreate 001a TObject.Create 0028 @AfterConstruction"
	strings:
		$1 = { 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B F1 8B DA 8B F8 33 D2 8B C7 E8 ?? ?? ?? ?? 89 77 0C 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_933_0 {
	meta:
		name = "@CheckAutoResult"
		size = 73
		refs = "001f SafeCallErrorProc 0038 ErrorAt"
	strings:
		$1 = { 55 8B EC 83 C4 F4 89 45 FC 83 7D FC 00 7D 2D 8D 45 FC 83 C0 04 83 C0 04 8B 00 89 45 F4 83 3D ?? ?? ?? ?? 00 74 0C 8B 55 F4 8B 45 FC FF 15 ?? ?? ?? ?? 8B 55 F4 B0 18 E8 ?? ?? ?? ?? 8B 45 FC 89 45 F8 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule function_934_0 {
	meta:
		name = "CompToDouble"
		size = 20
	strings:
		$1 = { 55 8B EC 83 C4 F8 DF 6D 08 DD 5D F8 9B DD 45 F8 59 59 5D C3 }
	condition:
		$1
}

rule function_935_0 {
	meta:
		name = "DoubleToComp"
		size = 14
	strings:
		$1 = { 55 8B EC DD 45 08 8B 45 10 DF 38 9B 5D C3 }
	condition:
		$1
}

rule function_936_0 {
	meta:
		name = "CompToCurrency"
		size = 32
		refs = "000b CompToCurrency"
	strings:
		$1 = { 55 8B EC 83 C4 F8 DF 6D 08 D8 0D ?? ?? ?? ?? DF 7D F8 9B DF 6D F8 59 59 5D C3 00 00 00 40 1C 46 }
	condition:
		$1
}

rule function_937_0 {
	meta:
		name = "CurrencyToComp"
		size = 24
		refs = "0008 CurrencyToComp"
	strings:
		$1 = { 55 8B EC DF 6D 08 D8 35 ?? ?? ?? ?? 8B 45 10 DF 38 9B 5D C3 00 40 1C 46 }
	condition:
		$1
}

rule function_938_0 {
	meta:
		name = "GetMemory"
		size = 14
		refs = "0008 MemoryManager"
	strings:
		$1 = { 55 8B EC 8B 45 08 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule function_939_0 {
	meta:
		name = "FreeMemory"
		size = 22
		refs = "0010 MemoryManager"
	strings:
		$1 = { 55 8B EC 8B 45 08 85 C0 75 04 33 C0 5D C3 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule function_940_0 {
	meta:
		name = "ReallocMemory"
		size = 30
		refs = "000f GetMemory 0018 MemoryManager"
	strings:
		$1 = { 55 8B EC 8B 55 0C 8B 45 08 85 C0 75 09 52 E8 ?? ?? ?? ?? 59 5D C3 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule function_941_0 {
	meta:
		name = "UnicodeToUtf8"
		size = 10
		refs = "0005 UnicodeToUtf8"
	strings:
		$1 = { 6A FF 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_943_0 {
	meta:
		name = "Utf8ToUnicode"
		size = 10
		refs = "0005 Utf8ToUnicode"
	strings:
		$1 = { 6A FF 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_942_0 {
	meta:
		name = "UnicodeToUtf8"
		size = 125
		refs = "002e LocaleCharsFromUnicode"
	strings:
		$1 = { 55 8B EC 51 53 56 8B F1 89 55 FC 8B D8 33 C0 85 F6 74 63 85 DB 74 45 8B 45 08 50 53 8B 45 FC 50 6A 00 6A 00 8B CE 33 D2 B8 E9 FD 00 00 E8 ?? ?? ?? ?? 3B 45 FC 75 3F EB 01 48 83 F8 01 76 37 80 7C 03 FF 7F 76 30 F6 44 03 FF 80 74 29 0F B6 54 03 FF 80 E2 C0 80 FA C0 75 DF EB 1A 8B 45 08 50 6A 00 6A 00 6A 00 6A 00 8B CE 33 D2 B8 E9 FD 00 00 E8 ?? ?? ?? ?? 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_944_0 {
	meta:
		name = "Utf8ToUnicode"
		size = 110
		refs = "002e UnicodeFromLocaleChars"
	strings:
		$1 = { 55 8B EC 51 53 56 89 4D FC 8B F2 8B D8 33 C0 83 7D FC 00 74 52 85 DB 74 37 85 F6 76 33 8B 45 08 50 53 56 8B 4D FC 33 D2 B8 E9 FD 00 00 E8 ?? ?? ?? ?? 3B F0 75 31 83 F8 01 76 2C 66 81 7C 43 FE 00 DC 72 23 66 81 7C 43 FE FF DF 77 1A 48 EB 17 8B 45 08 50 6A 00 6A 00 8B 4D FC 33 D2 B8 E9 FD 00 00 E8 ?? ?? ?? ?? 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_945_0 {
	meta:
		name = "UTF8Encode"
		size = 226
		refs = "0017 UTF8Encode 0025 @LStrClr 002f @WStrEqual 0055 @LStrSetLength 006a @WStrToPWChar 0073 @LStrToPChar 007c UnicodeToUtf8 00a6 @LStrAsg 00d6 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 C9 89 4D FC 89 55 F4 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F4 E8 ?? ?? ?? ?? 8B 45 F8 33 D2 E8 ?? ?? ?? ?? 0F 84 86 00 00 00 8B 45 F8 85 C0 74 07 83 E8 04 8B 00 D1 E8 8B D8 8D 14 5B 8D 45 FC B9 E9 FD 00 00 E8 ?? ?? ?? ?? 8B 75 FC 85 F6 74 05 83 EE 04 8B 36 53 8B 45 F8 E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 8D 56 01 59 E8 ?? ?? ?? ?? 8B D8 85 DB 7E 11 8D 45 FC B9 E9 FD 00 00 8B D3 E8 ?? ?? ?? ?? EB 08 8D 45 FC E8 ?? ?? ?? ?? 8B 45 F4 8B 55 FC E8 ?? ?? ?? ?? 8B 45 F4 83 38 00 74 0D 8B 45 F4 8B 00 83 E8 0C 66 C7 00 E9 FD 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_946_0 {
	meta:
		name = "UTF8Encode"
		size = 218
		refs = "0017 UTF8Encode 0025 @LStrClr 004d @LStrSetLength 0062 @UStrToPWChar 006b @LStrToPChar 0074 UnicodeToUtf8 009e @LStrAsg 00ce @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 C9 89 4D FC 89 55 F4 89 45 F8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F4 E8 ?? ?? ?? ?? 83 7D F8 00 0F 84 84 00 00 00 8B 45 F8 85 C0 74 05 83 E8 04 8B 00 8B D8 8D 14 5B 8D 45 FC B9 E9 FD 00 00 E8 ?? ?? ?? ?? 8B 75 FC 85 F6 74 05 83 EE 04 8B 36 53 8B 45 F8 E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 8D 56 01 59 E8 ?? ?? ?? ?? 8B D8 85 DB 7E 11 8D 45 FC B9 E9 FD 00 00 8B D3 E8 ?? ?? ?? ?? EB 08 8D 45 FC E8 ?? ?? ?? ?? 8B 45 F4 8B 55 FC E8 ?? ?? ?? ?? 8B 45 F4 83 38 00 74 0D 8B 45 F4 8B 00 83 E8 0C 66 C7 00 E9 FD 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_947_0 {
	meta:
		name = "UTF8Encode"
		size = 117
		refs = "000f UTF8Encode 002a DefaultSystemCodePage 0039 @LStrAsg 0045 @UStrFromLStr 0064 @UStrClr 006a @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 DB 74 0A 8B C3 83 E8 0C 0F B7 00 EB 07 0F B7 05 ?? ?? ?? ?? 66 3D E9 FD 75 0B 8B C6 8B D3 E8 ?? ?? ?? ?? EB 14 8D 45 FC 8B D3 E8 ?? ?? ?? ?? 8B 45 FC 8B D6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_948_0 {
	meta:
		name = "Max"
		size = 7
	strings:
		$1 = { 3B D0 7C 02 8B C2 C3 }
	condition:
		$1
}

rule function_949_0 {
	meta:
		name = "UTF8EncodeToShortString"
		size = 57
		refs = "001a @WStrToPWChar 0029 UnicodeToUtf8"
	strings:
		$1 = { 53 56 57 8B F2 8B F8 8B DF 85 DB 74 09 83 EB 04 8B 03 D1 E8 8B D8 53 8B C7 E8 ?? ?? ?? ?? 8B C8 8D 46 01 BA FF 00 00 00 E8 ?? ?? ?? ?? 85 C0 7D 02 33 C0 88 06 5F 5E 5B C3 }
	condition:
		$1
}

rule function_950_0 {
	meta:
		name = "UTF8EncodeToShortString"
		size = 53
		refs = "0016 @UStrToPWChar 0025 UnicodeToUtf8"
	strings:
		$1 = { 53 56 57 8B F2 8B F8 8B DF 85 DB 74 05 83 EB 04 8B 1B 53 8B C7 E8 ?? ?? ?? ?? 8B C8 8D 46 01 BA FF 00 00 00 E8 ?? ?? ?? ?? 85 C0 7D 02 33 C0 88 06 5F 5E 5B C3 }
	condition:
		$1
}

rule function_951_0 {
	meta:
		name = "UTF8EncodeToShortString"
		size = 122
		refs = "000f UTF8EncodeToShortString 002a DefaultSystemCodePage 003e @LStrToString 004a @UStrFromLStr 0069 @UStrClr 006f @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 85 DB 74 0A 8B C3 83 E8 0C 0F B7 00 EB 07 0F B7 05 ?? ?? ?? ?? 66 3D E9 FD 75 10 8B C6 8B D3 B9 FF 00 00 00 E8 ?? ?? ?? ?? EB 14 8D 45 FC 8B D3 E8 ?? ?? ?? ?? 8B 45 FC 8B D6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_952_0 {
	meta:
		name = "UTF8Decode"
		size = 169
		refs = "0016 UTF8Decode 0024 @WStrClr 0043 @WStrSetLength 004b @LStrToPChar 0054 @WStrToPWChar 005d Utf8ToUnicode 0082 @WStrAsg 009d @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 C9 89 4D FC 89 55 F8 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 E8 ?? ?? ?? ?? 85 F6 74 5A 89 75 F4 8B 45 F4 85 C0 74 05 83 E8 04 8B 00 8B D8 8D 45 FC 8B D3 E8 ?? ?? ?? ?? 53 8B C6 E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 8D 53 01 59 E8 ?? ?? ?? ?? 8B D8 85 DB 7E 0C 8D 45 FC 8B D3 E8 ?? ?? ?? ?? EB 08 8D 45 FC E8 ?? ?? ?? ?? 8B 45 F8 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_954_0 {
	meta:
		name = "UTF8ToUnicodeString"
		size = 169
		refs = "0016 UTF8ToUnicodeString 0024 @UStrClr 0043 @UStrSetLength 004b @LStrToPChar 0054 @UStrToPWChar 005d Utf8ToUnicode 0082 @UStrAsg 009d @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 56 33 C9 89 4D FC 89 55 F8 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 F8 E8 ?? ?? ?? ?? 85 F6 74 5A 89 75 F4 8B 45 F4 85 C0 74 05 83 E8 04 8B 00 8B D8 8D 45 FC 8B D3 E8 ?? ?? ?? ?? 53 8B C6 E8 ?? ?? ?? ?? 50 8B 45 FC E8 ?? ?? ?? ?? 8D 53 01 59 E8 ?? ?? ?? ?? 8B D8 85 DB 7E 0C 8D 45 FC 8B D3 E8 ?? ?? ?? ?? EB 08 8D 45 FC E8 ?? ?? ?? ?? 8B 45 F8 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_955_0 {
	meta:
		name = "UTF8ToUnicodeString"
		size = 151
		refs = "0010 UTF8ToUnicodeString 001d @UStrClr 002d @PCharLen 0039 @UStrSetLength 0042 @UStrToPWChar 004c Utf8ToUnicode 0070 @UStrAsg 008b @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 85 F6 74 03 80 3E 00 74 4A 8B C6 E8 ?? ?? ?? ?? 8B D8 8D 45 FC 8B D3 E8 ?? ?? ?? ?? 53 8B 45 FC E8 ?? ?? ?? ?? 8D 53 01 8B CE E8 ?? ?? ?? ?? 8B D8 85 DB 7E 0C 8D 45 FC 8B D3 E8 ?? ?? ?? ?? EB 08 8D 45 FC E8 ?? ?? ?? ?? 8B C7 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_956_0 {
	meta:
		name = "UTF8ToUnicodeString"
		size = 142
		refs = "0010 UTF8ToUnicodeString 001d @UStrClr 002f @UStrSetLength 0038 @UStrToPWChar 0043 Utf8ToUnicode 0067 @UStrAsg 0082 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B FA 8B F0 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 80 3E 00 74 45 0F B6 1E 8D 45 FC 8B D3 E8 ?? ?? ?? ?? 53 8B 45 FC E8 ?? ?? ?? ?? 8D 4E 01 8D 53 01 E8 ?? ?? ?? ?? 8B D8 85 DB 7E 0C 8D 45 FC 8B D3 E8 ?? ?? ?? ?? EB 08 8D 45 FC E8 ?? ?? ?? ?? 8B C7 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_960_0 {
	meta:
		name = "UTF8ToString"
		size = 18
		refs = "000b UTF8ToUnicodeString"
	strings:
		$1 = { 53 56 8B F1 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_963_0 {
	meta:
		name = "LoadResString"
		size = 106
		refs = "0040 FindResourceHInstance 0046 LoadString 0051 @UStrFromPWCharLen 005d @UStrFromPWChar"
	strings:
		$1 = { 53 56 50 B8 02 00 00 00 81 C4 04 F0 FF FF 50 48 75 F6 8B 84 24 00 20 00 00 83 C4 04 8B F2 8B D8 85 DB 74 3D 81 7B 04 00 00 01 00 7D 2A 68 00 10 00 00 8D 44 24 04 50 8B 43 04 50 8B 03 8B 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B C8 8B D4 8B C6 E8 ?? ?? ?? ?? EB 0A 8B C6 8B 53 04 E8 ?? ?? ?? ?? 81 C4 00 20 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_964_0 {
	meta:
		name = "PUCS4Chars"
		size = 25
		refs = "0006 @DynArrayLength 0013 xxPNull"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 85 C0 7E 04 8B C3 5B C3 A1 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_965_0 {
	meta:
		name = "WideStringToUCS4String"
		size = 254
		refs = "002e UCS4String 0033 @DynArraySetLength 00bf @WStrLen"
	strings:
		$1 = { 53 56 57 55 83 C4 F4 89 14 24 8B F0 33 C0 89 44 24 04 8B DE 85 DB 74 09 83 EB 04 8B 03 D1 E8 8B D8 43 53 8B 44 24 04 B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 33 FF EB 7E 0F B7 2C 7E 66 81 FD 00 D8 72 2D 66 81 FD FF DF 77 26 89 74 24 08 83 7C 24 08 00 74 0F 8B 44 24 08 83 E8 04 8B 00 D1 E8 89 44 24 08 8D 47 01 3B 44 24 08 0F 9C C3 EB 02 33 DB 84 DB 74 2C 0F B7 C5 25 FF 03 00 00 C1 E0 0A 0F B7 54 7E 02 81 E2 FF 03 00 00 0B C2 05 00 00 01 00 8B 14 24 8B 12 8B 4C 24 04 89 04 8A 47 EB 0F 8B 04 24 8B 00 8B 54 24 04 0F B7 CD 89 0C 90 FF 44 24 04 47 8B C6 E8 ?? ?? ?? ?? 3B F8 0F 8C 73 FF FF FF 8B 04 24 8B 00 8B 54 24 04 33 C9 89 0C 90 8B 44 24 04 40 50 8B 44 24 04 B9 01 00 00 00 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 83 C4 0C 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_966_0 {
	meta:
		name = "UCS4StringToWideString"
		size = 142
		refs = "000b @DynArrayLength 0017 @WStrSetLength"
	strings:
		$1 = { 53 56 57 55 8B EA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D0 03 D2 4A 8B C5 E8 ?? ?? ?? ?? 33 FF 33 DB EB 53 81 3C 9E 00 00 01 00 72 3C 47 8B 45 00 8B 14 9E 81 EA 00 00 01 00 C1 EA 0A 66 81 E2 FF 03 66 81 CA 00 D8 66 89 54 78 FE 47 8B 45 00 0F B7 14 9E 66 83 EA 00 66 81 E2 FF 03 66 81 CA 00 DC 66 89 54 78 FE EB 0D 47 8B 45 00 0F B7 14 9E 66 89 54 78 FE 43 8B C6 E8 ?? ?? ?? ?? 48 3B D8 7C A1 8B C5 8B D7 E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_967_0 {
	meta:
		name = "LocaleCharsFromUnicode"
		size = 37
		refs = "001c WideCharToMultiByte"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 53 8B 5D 0C 53 8B 5D 10 53 8B 5D 14 53 8B 5D 18 53 51 52 50 E8 ?? ?? ?? ?? 5B 5D C2 14 00 }
	condition:
		$1
}

rule function_968_0 {
	meta:
		name = "UnicodeFromLocaleChars"
		size = 29
		refs = "0014 MultiByteToWideChar"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 53 8B 5D 0C 53 8B 5D 10 53 51 52 50 E8 ?? ?? ?? ?? 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_970_0 {
	meta:
		name = "GetCPUCount"
		size = 17
		refs = "0005 GetSystemInfo"
	strings:
		$1 = { 83 C4 DC 54 E8 ?? ?? ?? ?? 8B 44 24 14 83 C4 24 C3 }
	condition:
		$1
}

rule function_971_0 {
	meta:
		name = "SetUtf8CompareLocale"
		size = 58
		refs = "0001 GetVersion 0026 UTF8CompareLocale"
	strings:
		$1 = { E8 ?? ?? ?? ?? 8B D0 81 E2 FF 00 00 00 25 00 FF 00 00 C1 E8 08 83 FA 05 75 05 83 F8 01 73 05 83 FA 05 76 0B C7 05 ?? ?? ?? ?? 7F 00 00 00 C3 C7 05 ?? ?? ?? ?? 09 04 00 00 C3 }
	condition:
		$1
}

rule function_977_0 {
	meta:
		name = "@memcpy"
		size = 19
		refs = "000d Move"
	strings:
		$1 = { 55 8B EC 8B 55 08 8B 45 0C 8B 4D 10 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule function_978_0 {
	meta:
		name = "@memset"
		size = 20
		refs = "000e @FillChar"
	strings:
		$1 = { 55 8B EC 0F B6 4D 0C 8B 45 08 8B 55 10 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule function_979_0 {
	meta:
		name = "SetDliNotifyHook"
		size = 17
		refs = "0005 pfnDliNotifyHook 000b InterlockedExchangePtr"
	strings:
		$1 = { 53 8B D8 53 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_981_0 {
	meta:
		name = "SetDliFailureHook"
		size = 17
		refs = "0005 pfnDliFailureHook 000b InterlockedExchangePtr"
	strings:
		$1 = { 53 8B D8 53 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_980_0 {
	meta:
		name = "DliNotifyHook"
		size = 20
		refs = "0001 pfnDliNotifyHook 000f InterlockedExchangePtr"
	strings:
		$1 = { A1 ?? ?? ?? ?? 8B 00 50 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_982_0 {
	meta:
		name = "DliFailureHook"
		size = 20
		refs = "0001 pfnDliFailureHook 000f InterlockedExchangePtr"
	strings:
		$1 = { A1 ?? ?? ?? ?? 8B 00 50 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_984_0 {
	meta:
		name = "UnloadDelayLoadedDLL"
		size = 13
		refs = "0005 UnloadDelayLoadedDLLPtr"
	strings:
		$1 = { 55 8B EC FF 25 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule function_985_0 {
	meta:
		name = "TGUID.&op_Equality"
		size = 36
	strings:
		$1 = { 8B 08 3B 0A 75 18 8B 48 04 3B 4A 04 75 10 8B 48 08 3B 4A 08 75 08 8B 40 0C 3B 42 0C 74 03 33 C0 C3 B0 01 C3 }
	condition:
		$1
}

rule function_986_0 {
	meta:
		name = "TGUID.&op_Inequality"
		size = 20
		refs = "000b TGUID.&op_Equality"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B D6 8B C3 E8 ?? ?? ?? ?? 34 01 5E 5B C3 }
	condition:
		$1
}

rule function_987_0 {
	meta:
		name = "TGUID.Empty"
		size = 13
		refs = "0008 @FillChar"
	strings:
		$1 = { 33 C9 BA 10 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_988_0 {
	meta:
		name = "_DF_."
		size = 230
		refs = "000d LocalAlloc 0022 RaiseException 002a _DV_. 005c LocalFree 00b2 @memcpy"
	strings:
		$1 = { 55 8B EC 53 56 8B 75 08 6A 08 6A 40 E8 ?? ?? ?? ?? 8B D8 85 DB 75 0F 56 6A 01 6A 00 68 08 00 FB C0 E8 ?? ?? ?? ?? 89 73 04 A1 ?? ?? ?? ?? 89 03 89 1D ?? ?? ?? ?? 5E 5B 5D C3 55 8B EC 8B 55 08 B8 ?? ?? ?? ?? EB 02 8B 00 83 38 00 74 04 3B 10 75 F5 3B 10 75 04 8B 0A 89 08 52 E8 ?? ?? ?? ?? 5D C3 55 8B EC 8B 45 08 2B 45 0C 85 C0 79 03 83 C0 03 C1 F8 02 5D C3 55 8B EC 8B 45 08 33 D2 EB 04 83 C0 04 42 83 38 00 75 F7 8B C2 5D C3 55 8B EC 8B 45 08 03 40 3C 5D C2 04 00 55 8B EC 53 8B 5D 08 53 E8 CF FF FF FF 59 C1 E0 02 50 FF 75 0C 53 E8 ?? ?? ?? ?? 83 C4 0C 5B 5D C2 08 00 55 8B EC 8B 45 08 8B 40 08 5D C2 04 00 55 8B EC 8B 45 0C 8B 55 08 3B 42 34 75 07 B8 01 00 00 00 EB 02 33 C0 5D C2 08 00 }
	condition:
		$1
}

rule function_989_0 {
	meta:
		name = "@_delayLoadHelper"
		size = 612
		refs = "0015 @memset 0079 _DV_. 00be LoadLibraryA 00c9 GetLastError 00ff RaiseException 0111 EnterCriticalSection 0129 FreeLibrary 0136 LeaveCriticalSection 01a5 GetProcAddress"
	strings:
		$1 = { 55 8B EC 83 C4 D0 53 56 57 8B 75 08 6A 24 6A 00 8D 45 D0 50 E8 ?? ?? ?? ?? 83 C4 0C C7 45 D0 24 00 00 00 89 75 D4 8B 55 0C 89 55 D8 8B 4E 04 89 4D DC 8B 5E 08 FF 76 0C FF 75 0C E8 3C FF FF FF 83 C4 08 89 45 FC 8B 45 FC C1 E0 02 03 46 10 F6 40 03 80 0F 94 C2 83 E2 01 89 55 E0 85 D2 74 0A 8B 00 83 C0 02 89 45 E4 EB 0B 8B 08 81 E1 FF FF 00 00 89 4D E4 33 FF 83 3D ?? ?? ?? ?? 00 74 17 8D 45 D0 50 6A 00 FF 15 ?? ?? ?? ?? 8B F8 85 C0 74 05 E9 5B 01 00 00 85 DB 0F 85 9B 00 00 00 83 3D ?? ?? ?? ?? 00 74 0E 8D 55 D0 52 6A 01 FF 15 ?? ?? ?? ?? 8B D8 85 DB 75 0A FF 75 DC E8 ?? ?? ?? ?? 8B D8 85 DB 75 43 E8 ?? ?? ?? ?? 89 45 F0 83 3D ?? ?? ?? ?? 00 74 0E 8D 45 D0 50 6A 03 FF 15 ?? ?? ?? ?? 8B D8 85 DB 75 20 8D 45 D0 89 45 F8 8D 55 F8 52 6A 01 6A 00 68 7E 00 FB C0 E8 ?? ?? ?? ?? 8B 45 EC E9 09 01 00 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 7E 08 00 75 0C 56 E8 F9 FD FF FF 59 89 5E 08 EB 09 53 E8 ?? ?? ?? ?? 8B 5E 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 5D E8 83 3D ?? ?? ?? ?? 00 74 0E 8D 45 D0 50 6A 02 FF 15 ?? ?? ?? ?? 8B F8 85 FF 75 53 83 7E 14 00 74 42 83 7E 1C 00 74 3C 53 E8 3E FE FF FF 8B F8 81 3F 50 45 00 00 75 2C 57 E8 5E FE FF FF 3B 46 1C 75 21 53 57 E8 5F FE FF FF 85 C0 74 16 FF 76 14 FF 76 0C E8 20 FE FF FF 8B 46 0C 8B 55 FC 8B 3C 90 EB 52 FF 75 E4 53 E8 ?? ?? ?? ?? 8B F8 85 FF 75 3E E8 ?? ?? ?? ?? 89 45 F0 83 3D ?? ?? ?? ?? 00 74 0E 8D 45 D0 50 6A 04 FF 15 ?? ?? ?? ?? 8B F8 85 FF 75 1B 8D 45 D0 89 45 F4 8D 55 F4 52 6A 01 6A 00 68 7F 00 FB C0 E8 ?? ?? ?? ?? 8B 7D EC 8B 45 0C 89 38 83 3D ?? ?? ?? ?? 00 74 17 33 D2 89 55 F0 89 5D E8 89 7D EC 8D 4D D0 51 6A 05 FF 15 ?? ?? ?? ?? 8B C7 5F 5E 5B 8B E5 5D C2 08 00 55 8B EC 53 56 57 8B 5D 08 85 DB 74 33 8B 43 04 83 78 18 00 74 2A 8B 73 04 8B 7E 08 FF 76 18 FF 76 0C E8 71 FD FF FF 57 E8 ?? ?? ?? ?? 33 C0 89 46 08 53 E8 FF FC FF FF 59 B8 01 00 00 00 EB 02 33 C0 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule function_990_0 {
	meta:
		name = "@_FUnloadDelayLoadedDLL"
		size = 106
		refs = "0009 _DV_. 0013 EnterCriticalSection 0029 lstrcmpiA 005e LeaveCriticalSection"
	strings:
		$1 = { 55 8B EC 53 56 8B 75 08 BB ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 F6 74 33 8B 1B 85 DB 74 18 8B 43 04 FF 70 04 56 E8 ?? ?? ?? ?? 85 C0 75 02 EB 06 8B 1B 85 DB 75 E8 53 E8 7A FF FF FF 59 8B D8 EB 14 EB 08 FF 33 E8 6C FF FF FF 59 83 3B 00 75 F3 BB 01 00 00 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C3 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_991_0 {
	meta:
		name = "@InitDelayHelp"
		size = 15
		refs = "0004 _DV_. 0009 InitializeCriticalSection"
	strings:
		$1 = { 55 8B EC 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule function_992_0 {
	meta:
		name = "@ShutdownDelayHelp"
		size = 22
		refs = "000b _DV_. 0010 DeleteCriticalSection"
	strings:
		$1 = { 55 8B EC 6A 00 E8 7D FF FF FF 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule function_993_0 {
	meta:
		name = "Finalization"
		size = 103
		refs = "0007 Finalization 0013 _DV_8 001a Input 001f @Close 0024 Output 002e ErrOutput 0038 FinalizeLocaleDate 003d FinalizeMemoryManager 0042 @ShutdownDelayHelp 0047 Copyright 004c @LStrClr 005f @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 37 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_994_0 {
	meta:
		name = "System"
		size = 170
		refs = "0002 _DV_8 000e @InitDelayHelp 0013 InitializeMemoryManager 0018 InitializeLocaleData 001e FileMode 0025 RaiseExceptionProc 0029 RaiseException 002f RTLUnwindProc 0033 RtlUnwind 0039 Test8086 003f GetCPUCount 0044 CPUCount 004a DispCallByIDProc 004e @DispCallByIDError 0053 @FpuInit 005a Input 0063 Output 006c ErrOutput 0073 GetCommandLine 0078 CmdLine 007d GetCmdShow 0082 CmdShow 0087 GetACP 008c DefaultSystemCodePage 0092 DefaultUnicodeCodePage 009b GetCurrentThreadId 00a0 MainThreadID 00a5 SetUtf8CompareLocale"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 0F 83 9C 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 02 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 02 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 C7 05 ?? ?? ?? ?? B0 D7 66 C7 05 ?? ?? ?? ?? B0 D7 66 C7 05 ?? ?? ?? ?? B0 D7 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? B0 04 00 00 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}
