# mv

> 파일 및 디렉토리를 이동하거나 이름을 변경합니다.
> 더 많은 정보: <https://www.gnu.org/software/coreutils/manual/html_node/mv-invocation.html>.

- 대상이 기존 디렉토리가 아닌 경우 파일 또는 디렉토리 이름 변경:

`mv {{경로/대상/원본}} {{경로/대상/목표}}`

- 파일 또는 디렉토리를 기존 디렉토리로 이동:

`mv {{경로/대상/원본}} {{경로/대상/기존_폴더}}`

- 여러 파일을 기존 디렉토리로 이동하고 파일 이름은 그대로 유지:

`mv {{경로/대상/원본1 경로/대상/원본2 ...}} {{경로/대상/기존_폴더}}`

- 기존 파일을 덮어쓸 때 확인하지 않고 이동:

`mv {{[-f|--force]}} {{경로/대상/소스}} {{경로/대상/타겟}}`

- 파일 권한과 관계없이 기존 파일을 덮어쓸 때 [i]대화형 확인 요청:

`mv {{[-i|--interactive]}} {{경로/대상/소스}} {{경로/대상/타겟}}`

- 대상에서 기존 파일을 덮어쓰지 않음 ([n]):

`mv {{[-n|--no-clobber]}} {{경로/대상/소스}} {{경로/대상/타겟}}`

- 파일 이동 후 자세한 모드로 파일 보기:

`mv {{[-v|--verbose]}} {{경로/대상/소스}} {{경로/대상/타겟}}`

- 외부 도구를 사용하여 이동 가능한 파일을 수집하기 위해 [t]타겟 디렉터리 지정:

`{{find /var/log -type f -name '*.log' -print0}} | {{xargs -0}} mv {{[-t|--target-directory]}} {{경로/대상/타겟_디렉터리}}`
