# zegrep

> 압축 파일에서 `egrep`을 사용하여 확장 정규 표현식 패턴 찾기.
> 더 많은 정보: <https://manned.org/zegrep>.

- 압축 파일에서 확장 정규 표현식(대소문자 구분)을 검색 (`?`, `+`, `{}`, `()` 및 `|` 지원):

`zegrep "{{검색_패턴}}" {{경로/대상/파일}}`

- 압축 파일에서 확장 정규 표현식(대소문자 구분 안 함)을 검색 (`?`, `+`, `{}`, `()` 및 `|` 지원):

`zegrep --ignore-case "{{검색_패턴}}" {{경로/대상/파일}}`

- 패턴과 일치하지 않는 줄 검색:

`zegrep --invert-match "{{검색_패턴}}" {{경로/대상/파일}}`

- 일치하는 각 줄에 대해 파일 이름과 줄 번호 출력:

`zegrep --with-filename --line-number "{{검색_패턴}}" {{경로/대상/파일}}`

- 패턴과 일치하는 줄 검색, 일치한 텍스트만 출력:

`zegrep --only-matching "{{검색_패턴}}" {{경로/대상/파일}}`

- 압축 파일 내의 파일을 재귀적으로 검색하여 패턴 찾기:

`zegrep --recursive "{{검색_패턴}}" {{경로/대상/파일}}`
